// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <stdio.h>
#include <stdlib.h>
#include <binder/Parcel.h>
#include <vendor-ril/telephony/ril.h>
#include <pal/pal_nm.h>
#include <string.h>
#include <log/log.h>
#include <strings.h>
#include <apn_interface.h>
#include <vector>
#include <string>

#include "data/data.h"
#include "common.h"

#include "data/data_gdbus.h"
#include "Radio_capability_switch_util.h"
#include "util/utils.h"

#undef LOG_TAG
#define LOG_TAG "MULTI_USER_DATA"

#define SKIP_DATA_SETTINGS -2

typedef struct {
    char apn_type[10];
    int cid;
    int net_id;
    char ifname[16];
}map_cid;

struct apntype_2_bitmask {
char *type;
int typebitmask;
};

#define APN_TYPE_ALL "*"
#define TEXT_APN_TYPE_DEFAULT "default"
#define TEXT_APN_TYPE_IMS "ims"
#define TEXT_APN_TYPE_MMS "mms"
#define TEXT_APN_TYPE_SUPL "supl"
#define TEXT_APN_TYPE_DUN "dun"
#define TEXT_APN_TYPE_HIPRI "hipri"
#define TEXT_APN_TYPE_FOTA "fota"
#define TEXT_APN_TYPE_CBS "cbs"
#define TEXT_APN_TYPE_EMERGENCY "emergency"
#define TEXTAPN_TYPE_IA "ia"
#define TEXT_APN_TYPE_DM "dm"
#define TEXT_APN_TYPE_WAP "wap"
#define TEXT_APN_TYPE_NET "net"
#define TEXT_APN_TYPE_CMMAIL "cmmail"
#define TEXT_APN_TYPE_TETHERING "tethering"
#define TEXT_APN_TYPE_RCSE "rcse"
#define TEXT_APN_TYPE_XCAP "xcap"
#define TEXT_APN_TYPE_RCS "rcs"

//for IOT card type
#define IOT_TEXT_APN_TYPE_DEFAULT "iot_default"
#define IOT_TEXT_APN_TYPE_NET_0 "iot_net_0"
#define IOT_TEXT_APN_TYPE_NET_1 "iot_net_1"
#define IOT_TEXT_APN_TYPE_NET_2 "iot_net_2"
#define IOT_TEXT_APN_TYPE_NET_3 "iot_net_3"
#define IOT_TEXT_APN_TYPE_NET_4 "iot_net_4"
#define IOT_TEXT_APN_TYPE_NET_5 "iot_net_5"
#define IOT_TEXT_APN_TYPE_NET_6 "iot_net_6"

#ifdef TARGET_PLATFORM_MT2731
#define DATAASST_PDN_APN_TYPE_UNKNOWN      0x0
#define DATAASST_PDN_APN_TYPE_DEFAULT      0x1
#define DATAASST_PDN_APN_TYPE_MMS          0x2
#define DATAASST_PDN_APN_TYPE_SUPL         0x4
#define DATAASST_PDN_APN_TYPE_DUN          0x8
#define DATAASST_PDN_APN_TYPE_HIPRI        0x10
#define DATAASST_PDN_APN_TYPE_FOTA         0x20
#define DATAASST_PDN_APN_TYPE_IMS          0x40
#define DATAASST_PDN_APN_TYPE_CBS          0x80
#define DATAASST_PDN_APN_TYPE_IA           0x100
#define DATAASST_PDN_APN_TYPE_EMERGENCY    0x200
#define DATAASST_PDN_APN_TYPE_WAP          0x400
#define DATAASST_PDN_APN_TYPE_XCAP         0x800
#define DATAASST_PDN_APN_TYPE_RCS          0x1000
#define DATAASST_PDN_APN_TYPE_BIP          0x2000
#define DATAASST_PDN_APN_TYPE_VSIM         0x4000
#else
#define DATAASST_PDN_APN_TYPE_UNKNOWN (0x00000000)
#define DATAASST_PDN_APN_TYPE_DEFAULT (0x00000001)
#define DATAASST_PDN_APN_TYPE_IMS (0x00000002)
#define DATAASST_PDN_APN_TYPE_MMS (0x00000004)
#define DATAASST_PDN_APN_TYPE_SUPL (0x00000008)
#define DATAASST_PDN_APN_TYPE_DUN (0x00000010)
#define DATAASST_PDN_APN_TYPE_HIPRI (0x00000020)
#define DATAASST_PDN_APN_TYPE_FOTA (0x00000040)
#define DATAASST_PDN_APN_TYPE_CBS (0x00000080)
#define DATAASST_PDN_APN_TYPE_EMERGENCY (0x00000100)
#define DATAASST_PDN_APN_TYPE_IA (0x00000200)
#define DATAASST_PDN_APN_TYPE_DM (0x00000400)
#define DATAASST_PDN_APN_TYPE_WAP (0x00000800)
#define DATAASST_PDN_APN_TYPE_NET (0x00001000)
#define DATAASST_PDN_APN_TYPE_CMMAIL (0x00002000)
#define DATAASST_PDN_APN_TYPE_TETHERING (0x00004000)
#define DATAASST_PDN_APN_TYPE_RCSE (0x00008000)
#define DATAASST_PDN_APN_TYPE_XCAP (0x00010000)
#define DATAASST_PDN_APN_TYPE_RCS (0x00020000)
#endif
//for IOT
#define IOT_DATAASST_PDN_APN_TYPE_DEFAULT   (0x00100000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_0     (0x00200000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_1     (0x00400000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_2     (0x00800000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_3     (0x01000000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_4     (0x02000000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_5     (0x04000000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_6     (0x08000000)

#define LEN 128
char line[LEN] = {0};
char csname[27] = {0};
static int net_id = 1000;

int ims_type_in_db = 0;

static int data_call_num = 0;

RIL_Data_Call_Response_v6 *data_call_response = NULL;
const int INVALID_VALUE = -1;
const int INVALID = -2;
int gcid = -1;
bool isEnable = false;

char  cur_apn_type[12]={0};

int SETUP_DATA_AUTH_NONE      = 0;
int SETUP_DATA_AUTH_PAP       = 1;
int SETUP_DATA_AUTH_CHAP      = 2;
int SETUP_DATA_AUTH_PAP_CHAP  = 3;

char* SETUP_DATA_PROTOCOL_IPV4    = "IP";
char* SETUP_DATA_PROTOCOL_IPV6   = "IPV6";
char* SETUP_DATA_PROTOCOL_IPV4V6 = "IPV4V6";

map_cid current_cid[8] = {
    {"", -1, -1, ""}, \
    {"", -1, -1, ""}, \
    {"", -1, -1, ""}, \
    {"", -1, -1, ""}, \
    {"", -1, -1, ""}, \
    {"", -1, -1, ""}, \
    {"", -1, -1, ""}, \
    {"", -1, -1, ""}
};

//when false, libvendor-ril manage the PDN retry , network configuration than create from ril request.
bool isEnableLocalconf(){
    RLOGD("enable configuration: %d", isEnable);
    return isEnable;
}

/* Deactivate data call reasons */
int DEACTIVATE_REASON_NONE = 0;
int DEACTIVATE_REASON_RADIO_OFF = 1;
int DEACTIVATE_REASON_PDP_RESET = 2;

char dns[4][40] = {0};
int dnsNum = 0;

int findCellularName(char *s)
{
    int i = 0;
    while (i < LEN) {
        if (strncmp((s + i), "cellular_", 9) == 0) {
            strncpy(csname, (s + i), 26);
            csname[26] = '\0';
            RLOGD("cellular service name is %s\n", csname);
            return i;
        } else {
            i++;
        }
    }
    return -1;
}

int getCellularService()
{
    FILE *cmd = popen("connmanctl services | grep cellular", "r");

    if (cmd == NULL) {
        RLOGD("open pipe fail!\n");
        return -1;
    }

    fgets(line, LEN, cmd);
    RLOGD("line is %s\n", line);

    pclose(cmd);
    return 0;
}

char* checkParameters(char* para)
{
    if (strcasecmp(para, "null") == 0) {
        return "";
    } else {
        return para;
    }
}

void updateApntype(char* apntype)
{
    if(strcasecmp(cur_apn_type, "ims") == 0
        || strcasecmp(cur_apn_type, "xcap") == 0
        || strcasecmp(cur_apn_type, "ia") == 0)
    {
        RLOGD("the current apn type: %s, don't set router, so just return", cur_apn_type);
        return;
    }

    for(int i =0; i < 8; i++)
    {
        if((strcmp(current_cid[i].apn_type, "") == 0) || (current_cid[i].cid == INVALID_VALUE))
        {
            memset(current_cid[i].apn_type,0, strlen(current_cid[i].apn_type));
            strcpy(current_cid[i].apn_type, apntype);
            RLOGD("updateApntype[%d]: %s", i, apntype);
            break;
        }
    }
}

void updatenetId(char* apntype, int net_id)
{
    for(int i =0; i < 8; i++)
    {
        for (int i = 0; i < 8 ; i++)
        {
            if(current_cid[i].net_id== INVALID_VALUE
                && (strcmp(current_cid[i].apn_type, apntype) == 0))
            {
                current_cid[i].net_id = net_id;
                RLOGD("updatenetId[%d]: %d", i, net_id);
            }
        }
    }
}

void updateInterfaceName(char* apntype,char* interface_name)
{
    for (int i = 0; i < 8 ; i++)
    {
        if((strcmp(current_cid[i].ifname, "") == 0)
            && (strcmp(current_cid[i].apn_type, apntype) == 0))
        {
            memset(current_cid[i].ifname,0, strlen(current_cid[i].ifname));
            strncpy(current_cid[i].ifname, interface_name, sizeof(current_cid[i].ifname) - 1);
            current_cid[i].ifname[sizeof(current_cid[i].ifname) - 1] = '\0';
            RLOGD("updateinterfaceName[%d]: %s", i, current_cid[i].ifname);
            break;
        }
    }
}
void destroyCid(char* apntype)
{
    for(int i =0; i < 8; i++)
    {
        if(strcmp(current_cid[i].apn_type, apntype) == 0)
        {
            strcpy(current_cid[i].apn_type, "");
            current_cid[i].cid = -1;
            current_cid[i].net_id = -1;
            strcpy(current_cid[i].ifname, "");
            RLOGD("destroyCid[%d]: %s",i, apntype);
            break;
        }
    }
}

int getcid(char* apntype)
{
    int cid = INVALID_VALUE;
    for(int i = 0; i < 8; i++)
    {
        if(strcmp(current_cid[i].apn_type, apntype) == 0)
        {
            cid = current_cid[i].cid;
            break;
        }
    }
    RLOGD("getcid: %d , apntype: %s", cid, apntype);
    return cid;
}

int getnetId(char* apntype)
{
    int netid = INVALID_VALUE;
    for(int i = 0; i < 8; i++)
    {
        if(strcmp(current_cid[i].apn_type, apntype) == 0)
        {
            netid = current_cid[i].net_id;
            break;
        }
    }
    RLOGD("getnetId: %d , apntype: %s", netid, apntype);
    return netid;
}

char* getIfnameFromCache(char* apnType)
{
    char* interfaceName = NULL;
    for(int i = 0; i < 8; i++)
    {
        if(strcmp(current_cid[i].apn_type, apnType) == 0)
        {
            interfaceName = current_cid[i].ifname;
            break;
        }
    }
    RLOGD("getIfnameFromCache: %s, apntype: %s", interfaceName, apnType);
    return interfaceName;
}

char* getDns(char* apnType)
{
    RLOGD("getDns start data_call_num: %d", data_call_num);
    char dnses[150] = "";
    int cid = getcid(apnType);
    if(cid == INVALID_VALUE)
    {
        RLOGD("cid is invalid");
        return NULL;
    }
    for(int i = 0 ; i < data_call_num; i++)
    {
        if((data_call_response != NULL) && (data_call_response[i].cid == cid))
        {
            strncpy(dnses, data_call_response[i].dnses, sizeof(dnses)-1);
            dnses[sizeof(dnses) -1] = '\0';
        }
    }
    RLOGD("dnses: %s", dnses);
    if (strcmp(dnses, "") == 0)
    {
        RLOGD("dnses is null");
        return NULL;
    }

    memset(dns,0,4*40);
    dnsNum = 0;

    RLOGD("fill data");
    if(strstr(dnses, " "))
    {
        char* p = strtok(dnses, " ");
        while(p)
        {
            if(dnsNum < 4)
            {
                RLOGD("dns[%d]: %s",dnsNum, p);
                strcpy(dns[dnsNum],p);
                dnsNum++;
            }
            p = strtok(NULL, " ");
        }
    } else {
        RLOGD("dns: %s, only one", dnses);
        strcpy(dns[dnsNum],dnses);
        dnsNum++;
    }
    return NULL;
}

char* getAddress(char* apnType, const char token)
{
    char* ip = NULL;
    char* addrs = NULL;
    int cid = getcid(apnType);
    if(cid == INVALID_VALUE)
    {
        RLOGD("cid is invalid");
        return NULL;
    }
    for(int i = 0 ; i < data_call_num; i++)
    {
        if((data_call_response != NULL) && (data_call_response[i].cid == cid))
        {
            addrs = data_call_response[i].addresses;
        }
    }
    if(!addrs)
    {
        RLOGD("addresss is null");
        return NULL;
    }
    if(strstr(addrs, " "))
    {
        char* p = strtok(addrs, " ");
        while(p)
        {
            if(strchr(p, token))
            {
                ip = p;
                break;
            } else {
                p = strtok(p, " ");
            }
        }
    } else {
        if(strchr(addrs, token))
        {
            ip = addrs;
        }
    }
    RLOGD("ip: %s", ip);
    return ip;
}

char* getGateWay(char* apnType, const char token)
{
    char* gateway = NULL;
    char* gateways = NULL;
    int cid = getcid(apnType);
    if(cid == INVALID_VALUE)
    {
        RLOGD("cid is invalid");
        return NULL;
    }
    for(int i = 0 ; i < data_call_num; i++)
    {
        if((data_call_response != NULL) && (data_call_response[i].cid == cid))
        {
            gateways = data_call_response[i].gateways;
        }
    }
    if(!gateways)
    {
        RLOGD("gateways is null");
        return NULL;
    }
    if(strstr(gateways, " "))
    {
        char* p = strtok(gateways, " ");
        while(p)
        {
            if(strchr(p, token))
            {
                gateway = p;
                break;
            } else {
                p = strtok(p, " ");
            }
        }
    } else {
        if(strchr(gateways, token))
        {
            gateway = gateways;
        }
    }
    RLOGD("gateway : %s", gateway);
    return gateway;
}
char* getInterfaceNameFromLocal(char* apnType)
{
    char* interfaceName = NULL;
    int cid = getcid(apnType);
    if(cid == INVALID_VALUE)
    {
        RLOGD("cid is invalid");
        return NULL;
    }
    for(int i = 0 ; i < 8; i++)
    {
        if(current_cid[i].cid == cid)
        {
            interfaceName = current_cid[i].ifname;
        }
    }
    RLOGD("interfaceName: %s", interfaceName);
    return interfaceName;
}
char* getInterfaceName(char* apnType)
{
    char* interfaceName = NULL;
    int cid = getcid(apnType);
    if(cid == INVALID_VALUE)
    {
        RLOGD("cid is invalid");
        return NULL;
    }
    for(int i = 0 ; i < data_call_num; i++)
    {
        if((data_call_response != NULL) && (data_call_response[i].cid == cid))
        {
            interfaceName= data_call_response[i].ifname;
        }
    }
    RLOGD("interfaceName: %s", interfaceName);
    return interfaceName;
}

void configInterNetNetwork(char * apnType)
{
    //if route had filled. do fill the router information
    char* interface_name = getInterfaceName(apnType);
    if(!interface_name)
    {
        RLOGW("config fail, interface_name is nul");
        return;
    }
    //if mal had set the route, don't set it.
    unsigned int netid = 0;
    int value = nm_interface_get_netid(interface_name, &netid);
    if(netid > 0) {
        RLOGW("the netid exsited. value: %d, netid: %d ", value, netid);
        return;
    }
    if(net_id +1 >= 2000 ) {
        net_id =  1001;
    } else {
        net_id++;
    }

    RLOGD("NET_ID: %d", net_id);
    updatenetId(apnType,net_id);

    char* temp_gateway = NULL;
    char ipv4_gateway[16] = "";
    char ipv6_gateway[40] = "";
    temp_gateway = getGateWay(apnType, '.');
    if(temp_gateway != NULL) {
    strcpy(ipv4_gateway, temp_gateway);
    }
    temp_gateway = NULL;
    temp_gateway = getGateWay(apnType,':');
    if(temp_gateway != NULL) {
        strcpy(ipv6_gateway, temp_gateway);
    }


    int prefix_len_ipv4 = 8;
    int prefix_len_ipv6 = 64;
    char* temp_dns[4] = {0};

    updateInterfaceName(apnType,interface_name);
    getDns(apnType);
    char* DESTIONNATION_IPV4 = "0.0.0.0/0";
    char* DESTIONNATION_IPV6 = "::/0";

    RLOGD("nm_network_create() netid: %d", net_id);
    if(nm_network_create(net_id, NULL) != 0)
    {
        RLOGD("nm_network_create() fail");
        goto DEMO_CONFIG_NET_IF_ERR_1;
    }

    RLOGD("nm_network_interface_add() netid: %d, interface_name: %s", net_id, interface_name);
    if(nm_network_interface_add(net_id, interface_name) != 0)
    {
        RLOGD("nm_network_interface_add() fail");
        goto DEMO_CONFIG_NET_IF_ERR_2;
    }

    RLOGD("nm_network_route_add() netid: %d, ifname: %s, destion_ipv4: %s, ipv4_gateway: %s", net_id, interface_name, DESTIONNATION_IPV4,ipv4_gateway);
    if (strlen(ipv4_gateway) != 0 && nm_network_route_add(net_id, interface_name, DESTIONNATION_IPV4,ipv4_gateway, 0, 1) != 0)
    {
        RLOGD("nm_network_route_add() gateway_v4 fail");
        goto DEMO_CONFIG_NET_IF_ERR_2;
    }

    RLOGD("nm_network_route_add() netid: %d, ifname: %s, destion_ipv6: %s, ipv6_gateway: %s", net_id, interface_name, DESTIONNATION_IPV6,ipv6_gateway);
    if (strlen(ipv6_gateway) != 0 && nm_network_route_add(net_id, interface_name, DESTIONNATION_IPV6,ipv6_gateway, 0, 1) != 0)
    {
        RLOGD("nm_network_route_add() gateway_v6 fail");
        goto DEMO_CONFIG_NET_IF_ERR_2;
    }

    for (int k = 0 ; k < dnsNum; k++)
    {
        temp_dns[k] = dns[k];
    }

    if (nm_resolver_dns_set(net_id, interface_name, temp_dns, dnsNum, NM_NETWORK_TYPE_INTERNET) !=0)
    {
        RLOGD("nm_resolver_dns_set() fail");
        goto DEMO_CONFIG_NET_IF_ERR_3;
    }

    if(strstr(apnType, "default") != NULL) {
        RLOGD("nm_network_default_set(): netid: %d", net_id);
        if(nm_network_default_set(net_id) != 0)
        {
            RLOGD("nm_network_default_set() fail");
            return;
        }
    }

    RLOGD("Demo App config network Done");
    return;

DEMO_CONFIG_NET_IF_ERR_3:
    if(nm_resolver_dns_clear(net_id) != 0)
    {
        RLOGD("nm_resolver_dns_clear fail.");
    }

DEMO_CONFIG_NET_IF_ERR_2:
    if(nm_network_interface_remove(net_id, interface_name) != 0)
    {
        RLOGD("nm_network_interface_remove fail.");
    }

DEMO_CONFIG_NET_IF_ERR_1:
    if(nm_network_destroy(net_id) != 0)
    {
        RLOGD("nm_network_destroy fail.");
    }
    destroyCid(apnType);
}

void releaseInternetNetworkconfig(char* apnType)
{
    if(strcasecmp(cur_apn_type, "ims") == 0
        || strcasecmp(cur_apn_type, "xcap") == 0
        || strcasecmp(cur_apn_type, "ia") == 0)
    {
        RLOGD("the current apn type: %s, don't set router, so just return", cur_apn_type);
        return;
    }

    char* ifname = getInterfaceNameFromLocal(apnType);

    if((ifname == NULL)||(strcmp("", ifname) == 0))
    {
        RLOGD("interface_name is \"\"");
        return;
    }

    //if mal had set the route, don't set it.
    unsigned int netid = 0;
    int value = nm_interface_get_netid(ifname, &netid);
    RLOGD("query netid. value: %d, netid: %d ", value, netid);
    if(netid <= 0) return;

    if(nm_resolver_dns_clear(netid) != 0)
    {
        RLOGD("nm_resolver_dns_clear fail.");
    }

    if(nm_network_interface_remove(netid, ifname) != 0)
    {
        RLOGD("nm_network_interface_remove fail.");
    }

    if(nm_network_destroy(netid) != 0)
    {
        RLOGD("nm_network_destroy fail.");
    }
}

int getApnProfileID(char *apnType)
{
    if (strcasecmp(apnType, "ims") == 0) {
        return DATA_PROFILE_IMS;
    } else if (strcasecmp(apnType, "fota") == 0) {
        return DATA_PROFILE_FOTA;
    } else if (strcasecmp(apnType, "cbs") == 0) {
        return DATA_PROFILE_CBS;
    } else if (strcasecmp(apnType, "ia") == 0) {
        return DATA_PROFILE_DEFAULT; // DEFAULT for now
    } else if (strcasecmp(apnType, "dun") == 0) {
        return DATA_PROFILE_TETHERED;
    } else {
        return DATA_PROFILE_DEFAULT;
    }
}

int setDataAllowed(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    if(argc != 2)
    {
        free(pRI);
        RLOGD("the peremeters numbers isn't right , so return");
        return -1;
    }

    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(1);
    p.writeInt32(atoi(argv[1])); //allowed ? 1:0
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int setupDataCall(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    if(argc > 2){
        return setupDataCallargc(argc,argv,socket_id,pRI);
    }
    char cmd[256];
    getCellularService();
    findCellularName(line);
    sprintf(cmd, "connmanctl connect %s", csname);
    int ret = system(cmd);
    memset(line, 0, LEN*sizeof(char));
    memset(csname, 0, 27*sizeof(char));

    updataDataConnectState(get_default_sim_data(), true);
    /* no response from telecore, free pRI prevent memory leak */
    if (pRI != NULL) {
        free(pRI);
    }

    return ret;
}

int getIntefaceId(char * apnType) {
    int all_interface_id[5] = {1,2,3,7,0};
    int temp_cid = INVALID_VALUE;
    if (getcid(apnType) == INVALID_VALUE) {
        bool is_find = false;
        for(int i=0; i<5; i++)
        {
            temp_cid = all_interface_id[i];
            bool is_exsited = false;
            for (int j=0; j < 8; j++)
            {
                if (current_cid[j].cid != INVALID_VALUE && current_cid[j].cid == temp_cid)
                {
                    is_exsited = true;
                    break;
                }
            }
            if(!is_exsited)
            {
                is_find = true;
                break;
            }
        }
        if(!is_find)
        {
            RLOGE("PDN numbers is max, cann't create new PDN");
            temp_cid = INVALID_VALUE;
        } else {
            // for *default* type. should use interface 0 as interface id.
            if (strstr(apnType, "default") != NULL && temp_cid != 0)
            {
                temp_cid = 0;
            }
        }
    }
    RLOGD("getInterfaceId apn type: %s, inteface id : %d", apnType, temp_cid);
    return temp_cid;
}

int  setupDataCallargc(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    if(argc != 8)
    {
        free(pRI);
        RLOGD("the parameters numbers isn't right , so return");
        return -1;
    }

    char radioTechnoloy[2];
    char profile[2];
    char* apnType = argv[2];
    if(strcasecmp(apnType, "null") == 0)
    {
        free(pRI);
        RLOGD("apnType shouldn't is null");
        return -1;
    }
    if(!isEnableLocalconf()) {
        free(pRI);
        return enableData(true, apnType);
    }
    for(int i =0; i < 8; i++)
    {
        if(apnType != NULL && strcmp(current_cid[i].apn_type, apnType) == 0)
        {
            free(pRI);
            RLOGD("PDN existed, only return. type: %s",apnType);
            return -1;
        }
    }
    //cur_apn_type = apnType;
    memset(cur_apn_type, 0, sizeof(cur_apn_type));
    memcpy(cur_apn_type,apnType,sizeof(cur_apn_type));
    RLOGD("cur_apn_Type is %s",cur_apn_type);

    char* apn = argv[1];
    if(strcasecmp(apn, "null") == 0)
    {
        free(pRI);
        RLOGD("apn shouldn't is null");
        return -1;
    }
    char* user = checkParameters(argv[3]);
    char* password = checkParameters(argv[4]);
    char* protocol;
    sprintf(radioTechnoloy, "%d",get_reg_data_radio_tech(Radio_capability_switch_util::get_main_capability_phone_id()));

    sprintf(profile, "%d", getApnProfileID(apnType));
    profile[1] = '\0';
    char authtype[2];
    if(strcasecmp(argv[5], "null") == 0)
    {
        int temp = (strcmp(user, "") == 0) ? SETUP_DATA_AUTH_NONE : SETUP_DATA_AUTH_PAP_CHAP;
        sprintf(authtype, "%d", temp);
    } else {
        strcpy(authtype, argv[5]);
    }
    authtype[1] = '\0';
    //TBD
    if(/*getDataRoamingFromRegistration()*/ false)
    {
        if(strcasecmp(argv[7], "null") == 0)
        {
            protocol = SETUP_DATA_PROTOCOL_IPV4;
        } else {
            protocol = argv[7];
        }
    } else {
        if(strcasecmp(argv[6], "null") == 0)
        {
            protocol = SETUP_DATA_PROTOCOL_IPV4;
        } else {
            protocol = argv[6];
        }
    }

    if(getIntefaceId(apnType) == INVALID_VALUE)
    {
        free(pRI);
        RLOGE("the PDN exsited for %s type or PDN number max", apnType);
        return -1;
    }

    char interface_id[2] = {0};
    sprintf(interface_id, "%d", (getIntefaceId(apnType) + 1));
    interface_id[1] = '\0';
    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(8);
    writeStringToParcel(p,radioTechnoloy);
    writeStringToParcel(p,profile);
    writeStringToParcel(p,apn);
    writeStringToParcel(p,user);
    writeStringToParcel(p,password);
    writeStringToParcel(p,authtype);
    writeStringToParcel(p,protocol);
    writeStringToParcel(p, interface_id);
    p.setDataPosition(pos);
    updateApntype(apnType);
    RLOGD("setupDataCallargc: \nradioTechnoloy: %s\nprofileId: %s\napn: %s\n \
        username: %s\npassword: %s\nauthType: %s\nprotocol %s\napnType: %s\ninterface_id: %s",radioTechnoloy,profile,apn,
        user,password,authtype,protocol,apnType, interface_id);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

int deactivateDataCallarc(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    if(argc != 2)
    {
        free(pRI);
        RLOGD("the peremeters numbers isn't right , so return");
        return -1;
    }

    char* apnType = argv[1];
    if(!isEnableLocalconf()) {
        free(pRI);
        return enableData(false, apnType);
    }
    char cid[2];
    char reason[2];
    int temp_cid = getcid(apnType);
    if(temp_cid == INVALID_VALUE)
    {
        free(pRI);
        RLOGD("cid is invalid");
        return -1;
    }
    sprintf(cid, "%d", temp_cid);
    cid[1] = '\0';
    sprintf(reason,"%d",DEACTIVATE_REASON_NONE);
    reason[1] = '\0';
    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(2);
    writeStringToParcel(p,cid);
    writeStringToParcel(p,reason);
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    releaseInternetNetworkconfig(apnType);
    destroyCid(apnType);
    RLOGD("deactivateDataCall() done");
    return 0;
}

int deactivateDataCall(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    if(argc == 2){
        char* apnType = argv[1];
        if (strcasecmp("default", apnType) != 0) { //Compatible previous versions
            return deactivateDataCallarc(argc,argv,socket_id,pRI);
        }
    }
    char cmd[256];
    getCellularService();
    findCellularName(line);
    sprintf(cmd, "connmanctl disconnect %s", csname);
    int ret = system(cmd);
    memset(line, 0, LEN*sizeof(char));
    memset(csname, 0, 27*sizeof(char));
    updataDataConnectState(get_default_sim_data(), false);
    /* no response from telecore, free pRI prevent memory leak */
    if (pRI != NULL) {
        free(pRI);
    }

    return ret;
}

#if 0
int apnSetting(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    //apn show add delete update
    free(pRI);
    if(argc < 2){
        RLOGD("the peremeters numbers isn't right , so return");
        return -1;
    }
    int ret = APN_ERR;
    apn_list_t* g_apnlist = NULL;
    if(strncmp(argv[1], "show", 4) == 0){
        apn_record_t* record = apn_malloc_record();
        apn_build_cRecord(record, APN_PROP_MCC, mcc);
        apn_build_iRecord(record, APN_PROP_iMNC, mnc);
        if(g_apnlist){
            apn_free_list(g_apnlist);
            g_apnlist = NULL;
        }
        apn_query_db(record, &g_apnlist);
        RLOGD("apn list count %d\n",g_apnlist->count);
        apn_record_t* instance = g_apnlist->top;
        char apn_list[2048] = {0};
        int len = 0;
        while(instance != NULL) {
            for (int i = 0; i < instance->count; i++) {
                if (instance->values[i] != NULL) {
                    if (i == (instance->count - 1)) {
                        sprintf(apn_list+len,"%s/%s\n ",apn_get_prop_name(instance->columnIdx[i]),instance->values[i]);
                    }else{
                        sprintf(apn_list+len,"%s/%s; ",apn_get_prop_name(instance->columnIdx[i]),instance->values[i]);
                    }
                    len = strlen(apn_list);
                }
            }
            instance = (apn_record_t* )instance->next;
        }
        apn_free_record(record);
        android::emResultNotify(apn_list);
        RLOGD("Apn list: /%s",apn_list);
    }
    if(strncmp(argv[1], "add", 3) == 0){
        int i = 0;
        int apnidx = APN_ERR;
        apn_record_t* record = apn_malloc_record();
        RLOGD("add record count = %d",(argc-2));
        for (i = 0; i < (argc - 2 ) ; i+=2){
            apnidx = apn_get_idx_by_name(argv[i+2]);
            if(apnidx != APN_ERR){
                apn_build_iRecord(record,apnidx,argv[i+3]);
            }else{
                RLOGD("record name [%s] is not invalid",argv[i+2]);
            }
        }
        ret = apn_insert_record_db(record);
        apn_free_record(record);
        if(ret == -1){
            android::emResultNotify("add apn fail.\n");
        }else{
            android::emResultNotify("add apn success.\n");
        }
    }
    if(strncmp(argv[1], "delete", 6) == 0){
        if(argc < 3){
            RLOGD("the peremeters numbers isn't right , so return");
            return -1;
        }
        int apnid = atoi(argv[2]);
        RLOGD("delete id %d",apnid);
        ret = apn_delete_record_db(apnid);
        if(ret == -1){
            android::emResultNotify("delete apn fail.\n");
        }else{
            android::emResultNotify("delete apn success.\n");
        }
    }
    if(strncmp(argv[1], "update", 6) == 0){
        if(argc < 3){
            RLOGD("the peremeters numbers isn't right , so return");
        }
        int apnid = atoi(argv[2]);
        char *updateid_str = NULL;
        //get the select record and update it : _id
        apn_record_t* instance = g_apnlist->top;
        while(instance != NULL) {
            char *value = NULL;
            value = (char *)apn_get_prop_from_record(instance,APN_PROP_iId);
            if(value != NULL){
                if(apnid == atoi(value)){
                    updateid_str = value;
                    break;
                }
            }else{
                RLOGD("warning: record has no id");
            }
            instance = (apn_record_t* )instance->next;
        }
        if(updateid_str == NULL){
            RLOGD("the apn id(%d) is not exist in apn database, please check" ,apnid);
            android::emResultNotify("update fail, the apn id to update is not exist in apn database");
            return -1;
        }
        apn_record_t* record = apn_malloc_record();
        int columnidx = -1;
        apn_build_iRecord(record,APN_PROP_iId,updateid_str);
        for(int i = 0; i < (argc - 3) ; i+=2){
            columnidx = apn_get_idx_by_name(argv[i+3]);
            if(columnidx != APN_ERR){
                apn_build_iRecord(record,columnidx,argv[i+4]);
            }else{
                RLOGD("record name [%s] is not invalid",argv[i+2]);
            }
        }
        ret = apn_update_record_db(record);
        apn_free_record(record);
        if(ret == -1){
            android::emResultNotify("update apn fail.\n");
        }else{
            android::emResultNotify("update apn success.\n");
        }
    }

}
#endif

int setInitialAttachApnargc(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    if(argc != 6)
    {
        free(pRI);
        RLOGD("the peremeters numbers isn't right , so return");
        return -1;
    }

    android::Parcel p;
    size_t pos = p.dataPosition();
    char* apn = checkParameters(argv[1]);
    char* protocol;
    if(strcasecmp(argv[2], "null") == 0)
    {
        protocol = SETUP_DATA_PROTOCOL_IPV4;
    } else {
        protocol = argv[2];
    }
    int authType = -1;
    if(strcasecmp("null", argv[3]) != 0)
    {
        authType = atoi(argv[3]);
    }
    char* username = checkParameters(argv[4]);
    char* password = checkParameters(argv[5]);
    writeStringToParcel(p,apn); //apn
    writeStringToParcel(p,protocol); //protocol
    p.writeInt32(authType);  //authType
    writeStringToParcel(p,username);//username
    writeStringToParcel(p,password);//password
    p.setDataPosition(pos);

    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

int getDataCallList(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    if(argc != 1)
    {
        free(pRI);
        RLOGD("the peremeters numbers isn't right , so return");
        return -1;
    }

    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

int getLastDataCallFailCause(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    if(argc != 1)
    {
        free(pRI);
        RLOGD("the peremeters numbers isn't right , so return");
        return -1;
    }

    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

void updateRILDataCallResponsev6(int num ,RIL_Data_Call_Response_v6* p_cur)
{
    if(!isEnableLocalconf()) return;
    data_call_num = num;
    if(strcasecmp(cur_apn_type, "ims") == 0
        || strcasecmp(cur_apn_type, "xcap") == 0
        || strcasecmp(cur_apn_type, "ia") == 0)
    {
        RLOGD("the current apn type: %s, don't set router, so just return", cur_apn_type);
        return;
    }

    if(data_call_response != NULL)
    {
        free(data_call_response);
    }

    data_call_response = (RIL_Data_Call_Response_v6 *)calloc(1, num*sizeof(RIL_Data_Call_Response_v6));
    if(p_cur)
    {
        memcpy(data_call_response,p_cur, num*sizeof(RIL_Data_Call_Response_v6));
        int j;
        RLOGD("num: %d", num);
        for (j = num-1; j >=0 ; j--)
        {
            int temp_cid = data_call_response[j].cid;
            int k;
            for(k = 0; k < 8 ; k++)
            {
                if(current_cid[k].cid == temp_cid)
                {
                    break;
                }
            }

            if (k >= 8)
            {
                break;
            }
        }

        RLOGD("updateRILDataCallResponsev6()... j: %d", j);
        if(j < 0)
        {
            RLOGD("don't update data map_cid");
            return;
        }

        int new_cid = data_call_response[j].cid;
        RLOGD("updateRILDataCallResponsev6()... j: %d, new_cid: %d",j, new_cid);

        for (int i = 0; i < 8 ; i++)
        {
            if((strcmp(current_cid[i].apn_type, "") != 0) && current_cid[i].cid == INVALID_VALUE)
            {
                RLOGD("update current_cid[%d]: %d", i , new_cid);
                current_cid[i].cid = new_cid;
                break;
            }
        }
    configInterNetNetwork(cur_apn_type);
    } else {
        RLOGD("updateRILDataCallResponsev6 fail");
    }
}

void handleUnsolDataCalllistChange(int num ,RIL_Data_Call_Response_v6* p_cur){
    for(int i =0; i < 8; i++)
    {
        int temp_cid = current_cid[i].cid;
        if(temp_cid != -1){
            int j;
            bool isContant = false;
            for(j=0; j < num; j++){
                if(p_cur[i].cid == temp_cid){
                    isContant = true;
                    break;
                }
            }
            RLOGD("isContant = %d, curent_cid[%d].cid = %d", isContant, i, temp_cid);
            if(!isContant){
                releaseInternetNetworkconfig(current_cid[i].apn_type);
                destroyCid(current_cid[i].apn_type);
            }
        }
    }
}

static int getApntypeBitmask(const char *type)
{
    struct apntype_2_bitmask  apntypebitmask[] = {
            {TEXT_APN_TYPE_DEFAULT,DATAASST_PDN_APN_TYPE_DEFAULT},
            {TEXT_APN_TYPE_IMS,DATAASST_PDN_APN_TYPE_IMS},
            {TEXT_APN_TYPE_MMS,DATAASST_PDN_APN_TYPE_MMS},
            {TEXT_APN_TYPE_SUPL,DATAASST_PDN_APN_TYPE_SUPL},
            {TEXT_APN_TYPE_DUN,DATAASST_PDN_APN_TYPE_DUN},
            {TEXT_APN_TYPE_HIPRI,DATAASST_PDN_APN_TYPE_HIPRI},
            {TEXT_APN_TYPE_FOTA,DATAASST_PDN_APN_TYPE_FOTA},
            {TEXT_APN_TYPE_CBS,DATAASST_PDN_APN_TYPE_CBS},
            {TEXT_APN_TYPE_EMERGENCY,DATAASST_PDN_APN_TYPE_EMERGENCY},
            {TEXTAPN_TYPE_IA,DATAASST_PDN_APN_TYPE_IA},
#if !(defined(TARGET_PLATFORM_MT2731))
            {TEXT_APN_TYPE_DM,DATAASST_PDN_APN_TYPE_DM},
#endif
            {TEXT_APN_TYPE_WAP,DATAASST_PDN_APN_TYPE_WAP},
#if !(defined(TARGET_PLATFORM_MT2731))
            {TEXT_APN_TYPE_NET,DATAASST_PDN_APN_TYPE_NET},
            {TEXT_APN_TYPE_CMMAIL,DATAASST_PDN_APN_TYPE_CMMAIL},
            {TEXT_APN_TYPE_TETHERING,DATAASST_PDN_APN_TYPE_TETHERING},
            {TEXT_APN_TYPE_RCSE,DATAASST_PDN_APN_TYPE_RCSE},
#endif
            {TEXT_APN_TYPE_XCAP,DATAASST_PDN_APN_TYPE_XCAP},
            {TEXT_APN_TYPE_RCS,DATAASST_PDN_APN_TYPE_RCS},
            {IOT_TEXT_APN_TYPE_DEFAULT ,IOT_DATAASST_PDN_APN_TYPE_DEFAULT}, //for IOT
            {IOT_TEXT_APN_TYPE_NET_0 ,IOT_DATAASST_PDN_APN_TYPE_NET_0},//for IOT
            {IOT_TEXT_APN_TYPE_NET_1 ,IOT_DATAASST_PDN_APN_TYPE_NET_1},//for IOT
            {IOT_TEXT_APN_TYPE_NET_2 ,IOT_DATAASST_PDN_APN_TYPE_NET_2},//for IOT
            {IOT_TEXT_APN_TYPE_NET_3 ,IOT_DATAASST_PDN_APN_TYPE_NET_3},//for IOT
            {IOT_TEXT_APN_TYPE_NET_4 ,IOT_DATAASST_PDN_APN_TYPE_NET_4},//for IOT
            {IOT_TEXT_APN_TYPE_NET_5 ,IOT_DATAASST_PDN_APN_TYPE_NET_5},//for IOT
            {IOT_TEXT_APN_TYPE_NET_6 ,IOT_DATAASST_PDN_APN_TYPE_NET_6},//for IOT
    };
    int len = sizeof(apntypebitmask)/sizeof(apntype_2_bitmask);
    for(int i = 0; i < len ; i++){
        if(strcasecmp(type,apntypebitmask[i].type) == 0)
            return apntypebitmask[i].typebitmask;
     }
    return DATAASST_PDN_APN_TYPE_UNKNOWN;
}

static int check_is_number(char* str) {
    if(utils::is_number(str)){
        return atoi(str);
    } else {
        return INVALID;
    }
}

//RIL_REQUEST_SET_DATA_PROFILE
int setDataProfile(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    int count = check_is_number(argv[1]);
    if(count == INVALID) {
        free(pRI);
        printf("the peremeters count(%s) isn't invalid , so return\n", argv[1]);
        RLOGD("the peremeters count(%s) isn't invalid , so return", argv[1]);
        return -1;
    }

    if((argc-2) != 11*count) {
        free(pRI);
        printf("the peremeters numbers isn't right , so return\n");
        RLOGD("the peremeters numbers isn't right , so return");
        return -1;
    }
    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(count); //profileId
    for (int i=2; i < argc; i++) {
        int profileId = 0;
        std::vector<std::string> v;
        utils::tokenize(std::string(argv[i]),',',v);
        int index = 0;
        for(auto s: v) {
            RLOGD("%d:%s",index, s.c_str());
            profileId  |= getApntypeBitmask(s.c_str());
            index++;
        }
        p.writeInt32(profileId); //profileId
        char* apn = checkParameters(argv[i+1]);
        writeStringToParcel(p,apn); //apn
        char* protocol;
        if(strcasecmp(argv[i+2], "null") == 0)
        {
            protocol = SETUP_DATA_PROTOCOL_IPV4V6;
        } else {
            protocol = argv[i+2];
        }
        writeStringToParcel(p,protocol); //protocol
        int authType = -1;
        if((strcasecmp("null", argv[i+3]) != 0) && (strcasecmp("-1", argv[i+3]) != 0))
        {
            authType = check_is_number(argv[i+3]);
            if (authType == INVALID) {
                free(pRI);
                printf("the peremeters authType(%s) isn't invalid , so return\n", argv[i+3]);
                return -1;
            }
        }
        p.writeInt32(authType);  //authType
        char* username = checkParameters(argv[i+4]);
        writeStringToParcel(p,username);//username
        char* password = checkParameters(argv[i+5]);
        writeStringToParcel(p,password);//password
        int type = check_is_number(argv[i+6]);
        if(type == INVALID) {
            free(pRI);
            printf("the peremeters type(%s) isn't invalid , so return\n", argv[i+6]);
            RLOGD("the peremeters type(%s) isn't invalid , so return", argv[i+6]);
            return -1;
        }
        p.writeInt32(type);  //type
        int maxConnsTime = check_is_number(argv[i+7]);
        if(maxConnsTime == INVALID) {
            free(pRI);
            printf("the peremeters maxConnsTime(%s) isn't invalid , so return\n", argv[i+7]);
            RLOGD("the peremeters maxConnsTime(%s) isn't invalid , so return", argv[i+7]);
            return -1;
        }
        p.writeInt32(maxConnsTime);  //maxConnsTime
        int maxConns = check_is_number(argv[i+8]);
        if(maxConns == INVALID) {
            free(pRI);
            printf("the peremeters maxConns(%s) isn't invalid , so return\n", argv[i+8]);
            RLOGD("the peremeters maxConns(%s) isn't invalid , so return", argv[i+8]);
            return -1;
        }
        p.writeInt32(maxConns);  //maxConns
        int waitTime = check_is_number(argv[i+9]);
        if(waitTime == INVALID) {
            free(pRI);
            printf("the peremeters waitTime(%s) isn't invalid , so return\n", argv[i+9]);
            RLOGD("the peremeters waitTime(%s) isn't invalid , so return", argv[i+9]);
            return -1;
        }
        p.writeInt32(waitTime);  //waitTime
        int enabled = check_is_number(argv[i+10]);
        if(enabled == INVALID) {
            free(pRI);
            printf("the peremeters enabled(%s) isn't invalid , so return\n", argv[i+10]);
            RLOGD("the peremeters enabled(%s) isn't invalid , so return", argv[i+10]);
            return -1;
        }
        p.writeInt32(enabled);  //enabled
        RLOGD("index=%d",i);
        i = i+10;
    }
    p.setDataPosition(pos);

    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

//RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD
int syncDataSettingsToMd(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if (argc != 2){
        RLOGD("syncDataSettingsToMd parameters  number isn't enough");
        free(pRI);
        return -1;
    }
    uint32_t slot_Id = atoi(argv[1]);
    if(slot_Id == 0 || slot_Id == 1) {
        RLOGD("syncDataSettingsToMd sesssion id:%d", slot_Id);
        android::Parcel p;
        size_t pos = p.dataPosition();
        p.writeInt32(5);
        p.writeInt32(SKIP_DATA_SETTINGS);
        p.writeInt32(SKIP_DATA_SETTINGS);
        p.writeInt32(slot_Id);
        p.writeInt32(SKIP_DATA_SETTINGS);
        p.writeInt32(SKIP_DATA_SETTINGS);

        p.setDataPosition(pos);
        pRI->pCI->dispatchFunction(p, pRI);
        return 0;
    } else {
        RLOGD("syncDataSettingsToMd parameters(slot: %d)  isn't right", slot_Id);
        free(pRI);
        return -1;
    }
}

int syncDataSettings(RIL_SOCKET_ID socket_id) {
    char* slotID = "1";
    if(socket_id == 0) {
        slotID = "0";
    }
    char* tmp[2] = {"RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD", slotID};
    RequestInfo *pRI = creatRILInfoAndInit(RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD, OTHER, socket_id);
    if(pRI == NULL) return -1;
    syncDataSettingsToMd(2,tmp,socket_id,pRI);
    return 0;
}
