// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <unistd.h>
#include <string.h>
#include <log/log.h>
#include <vendor-ril/telephony/ril.h>
extern "C" {
#include <gio/gio.h>
#include <glib.h>
}

#define LOG_TAG "MULTI_USER_DATA_GDBUS"
#define TELEPHONY_SERVICE "mtk.telephony" /*well-known bus name */
#define TELEPHONY_DATA_INTERFACE "mtk.telephony.Data" /*interface name*/
#define TELEPHONY_DATA_PATH "/mtk/telephony/data" /*object name*/

GMainLoop *loop = NULL;
GDBusProxy *proxy = NULL;
MTK_Data_Call_Response_v1 req_response;
MTK_Data_Call_Response_v1 urc_response;

void freeMem(MTK_Data_Call_Response_v1 response)
{
    g_free(response.apnType);
    g_free(response.type);
    g_free(response.ifname);
    g_free(response.addresses);
    g_free(response.dnses);
    g_free(response.gateways);
    g_free(response.pcscf);
}

char* apnState2string(RIL_Data_Call_PdnState apnState) {
    switch (apnState) {
    case RIL_Data_Call_PdnState::PDN_CONNECTED:
        return "PDN_CONNECTED";
    case RIL_Data_Call_PdnState::PDN_CONNECTING:
        return "PDN_CONNECTING";
    case RIL_Data_Call_PdnState::PDN_DISCONNECTED:
        return "PDN_DISCONNECTED";
    case RIL_Data_Call_PdnState::PDN_DISCONNECTING:
        return "PDN_DISCONNECTING";
    case RIL_Data_Call_PdnState::PDN_FAILED:
        return "PDN_FAILED";
    case RIL_Data_Call_PdnState::PDN_IDLE:
        return "PDN_IDLE";
    case RIL_Data_Call_PdnState::PDN_RETRYING:
        return "PDN_RETRYING";
    case RIL_Data_Call_PdnState::PDN_SCANNING:
        return "PDN_SCANNING";
    default:
        return "UNKNOWN";
    }
}

void dumpResponse(MTK_Data_Call_Response_v1 *dataCallResponse)
{
    RLOGD("dumpResponse: netId: %d, pdnState: %s, status: %d, cId: %d, apnType: %s,"
            " protocolType: %s, ifaceName: %s, address: %s, dns: %s, gateway: %s, pcscf: %s, mtu: %d",
            dataCallResponse->netId, apnState2string(RIL_Data_Call_PdnState(dataCallResponse->pdnState)),
            dataCallResponse->status, dataCallResponse->cId, dataCallResponse->apnType, dataCallResponse->type,
            dataCallResponse->ifname, dataCallResponse->addresses, dataCallResponse->dnses,
            dataCallResponse->gateways, dataCallResponse->pcscf, dataCallResponse->mtu);
}

void parse(GVariant* result, MTK_Data_Call_Response_v1* data) {
    g_variant_get(result, "((iiiisssssssi))", &(data->netId),
            &(data->pdnState), &(data->status),
            &(data->cId), &(data->apnType), &(data->type),
            &(data->ifname), &(data->addresses),
            &(data->dnses), &(data->gateways),
            &(data->pcscf), &(data->mtu));
}

void proxy_method_cb (GDBusProxy   *proxy,
                                      GAsyncResult *res,
                                      gpointer      user_data)
{
    RLOGD("method call back");
    GError *error;
    GVariant *result;

    error = NULL;
    result = g_dbus_proxy_call_finish(proxy, res, &error);

    if(error != NULL)
    {
        RLOGD("method call back error %s", error->message);
        g_error_free(error);
        return;
    }
    freeMem(req_response);
    parse(result, &req_response);
    dumpResponse(&req_response);
    g_variant_unref(result);
}

int enableData (bool isEnable, gchar *apn_type)
{
    RLOGD("send: %s, %s", (isEnable ? "TRUE": "FALSE"), apn_type);
    g_dbus_proxy_call(proxy,
            "enableData",
            g_variant_new("(bs)", isEnable, apn_type),
            G_DBUS_CALL_FLAGS_NONE,
            -1,
            NULL,
            (GAsyncReadyCallback) proxy_method_cb,
            NULL);
    return 1;
}

void proxy_signals_on_signal (GDBusProxy  *proxy,
                              const gchar *sender_name,
                              const gchar *signal_name,
                              GVariant    *parameters,
                              gpointer     user_data)
{
    RLOGD("signal_name: %s", signal_name);
    freeMem(urc_response);
    parse(parameters, &urc_response);
    dumpResponse(&urc_response);
    if(g_strcmp0(signal_name, "InternetStatusChanged") == 0){

    } else if (g_strcmp0(signal_name, "SuplStatusChanged") == 0) {
    } else if (g_strcmp0(signal_name, "IOTDefaultStatusChanged") == 0) {
    } else if (g_strcmp0(signal_name, "IOTNet0StatusChanged") == 0) {
    } else if (g_strcmp0(signal_name, "IOTNet1StatusChanged") == 0) {
    } else if (g_strcmp0(signal_name, "IOTNet2StatusChanged") == 0) {
    } else if (g_strcmp0(signal_name, "IOTNet3StatusChanged") == 0) {
    } else if (g_strcmp0(signal_name, "IOTNet4StatusChanged") == 0) {
    } else if (g_strcmp0(signal_name, "IOTNet5StatusChanged") == 0) {
    } else if (g_strcmp0(signal_name, "IOTNet6StatusChanged") == 0) {
    }
}

void proxy_ready(GObject *source, GAsyncResult *result, gpointer user_data) {
    GError *error;

    error = NULL;
    proxy = g_dbus_proxy_new_for_bus_finish(result, &error);
    if (proxy == NULL) {
        RLOGE("create proxy fail");
        return ;
    }
    RLOGD("proxy is ready");
    gulong signal_handler_id;

    signal_handler_id = g_signal_connect(proxy, "g-signal",
            G_CALLBACK (proxy_signals_on_signal), NULL);
    if (signal_handler_id == 0) {
        RLOGE("listen singal fail!");
    }
}

void* init_data_gdbus_cb(void *param)
{
    /* all the tests rely on a shared main loop */
    loop = g_main_loop_new(NULL, FALSE);

    g_dbus_proxy_new_for_bus(G_BUS_TYPE_SYSTEM,
            G_DBUS_PROXY_FLAGS_NONE,
            NULL, /* GDBusInterfaceInfo */
            TELEPHONY_SERVICE, /* name */
            TELEPHONY_DATA_PATH, /* object path */
            TELEPHONY_DATA_INTERFACE, /* interface */
            NULL, /* GCancellable */
            proxy_ready,
            NULL);

    g_main_loop_run(loop);

    RLOGD("data gdbus main loop run()");
    if(proxy != NULL) {
        g_object_unref (proxy);
    }
    if(loop != NULL) {
        g_main_loop_unref(loop);
    }
    return NULL;
}

