#!/bin/bash
#Copyright (c) 2016, MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction,
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.
recv_data() {
    cat <&9 | while read line
    do
       result=${line}
       catp=$(ps | grep cat | awk '{print $1}')
       if [ "$line" != "" ];then
          if [ "$line" != "stopemdone" ];then
              echo $line
          fi
          if [ "$catp" != "" ];then
            kill $catp
          fi
       fi
    done
}

help()
{
    echo -e "\033[34m"
    echo "Usage:$0 <mute>"
    echo "mute: 1 for "enable mute" and 0 for "disable mute""
    echo -e "\033[0m"
}

fail_tip()
{
    echo -e "\033[31m"
    echo -E "parameter is invaild!"
    echo -e "\033[0m"
    help
}

is_num()
{
    re='^[+-]?[0-9]+$'
    if ! [[ $1 =~ $re ]]
    then
        return 0
    else
        return 1
    fi
}

if [ "$1" == "-h" ]
then
    help
    exit 0
fi

if [ "$#" != 1 ]
then
    fail_tip
    exit 0
fi

for var in "$1"
do
    if is_num $var
    then
        fail_tip
        exit 0
    fi
done

if [ "$1" -gt 0 ]
then
    echo "Turn on uplink (microphone) mute."
else
    echo "Turn off uplink (microphone) mute."
fi

value="$1"

#open a socket, communicated with Service.
exec 9<>/dev/udp/127.0.0.1/8000

#set mute
echo "RIL_REQUEST_SET_MUTE ${value}" >&9
recv_data

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
