#!/bin/bash
#Copyright (c) 2016, MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction,
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

if [ "$1" == "-h" ]
then
    echo -E "Usage:$0 <data1> <data2> <data3> <data4>"
    echo -E "data1: one of 1,2,3,4"
    echo -E "data2: one of 1,2,3,4, execpt data1"
    echo -E "data3: one of 1,2,3,4, execpt data1, data2"
    echo -E "data4: one of 1,2,3,4, execpt data1, data2, data3"
    echo -E "1: Customer assigned eCall URI"
    echo -E "2: eCall URI in USIM"
    echo -E "3: Customer assigned eCall number"
    echo -E "4: eCall number in USIM"
    exit 0
fi

data1=$1
data2=$2
data3=$3
data4=$4

if [ "$#" != 4 ]
then
    echo -E "parameter is invaild!"
    echo -E "Usage:$0 <data1> <data2> <data3> <data4>"
    echo -E "data1: one of 1,2,3,4"
    echo -E "data2: one of 1,2,3,4, execpt data1"
    echo -E "data3: one of 1,2,3,4, execpt data1, data2"
    echo -E "data4: one of 1,2,3,4, execpt data1, data2, data3"
    echo -E "1: Customer assigned eCall URI"
    echo -E "2: eCall URI in USIM"
    echo -E "3: Customer assigned eCall number"
    echo -E "4: eCall number in USIM"
    exit 0
fi

echo -E "RIL_REQUEST_ECALL_SET_PRI ${data1} ${data2} ${data3} ${data4}"

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#make ecall CMD
echo "RIL_REQUEST_ECALL_SET_PRI ${data1} ${data2} ${data3} ${data4}" >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
