#!/bin/bash
#Copyright (c) [2016], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

if [ "$1" == "-h" ]
then
	echo -E "Usage: sh $0 <serviceCategory_from> <serviceCategory_to> <language> <selected>"
	echo -E "[serviceCategory_from serviceCategory_to] : [0 255]"
	echo -E "language: default 1 .0-7 as defined in C.R1001G 9.2"
	echo -E "selected: 0 means message types specified in serviceCategory are not accepted, while 1 means accepted"
	exit 0
fi

if [ "$#" != 4 ]
then
	echo -E "parameter is invaild!"
	echo -E "Usage: sh $0 <serviceCategory_from> <serviceCategory_to> <language> <selected>"
	echo -E "[serviceCategory_from serviceCategory_to] : [0 255]"
	echo -E "language: default 1 .0-7 as defined in C.R1001G 9.2"
	echo -E "selected: 0 means message types specified in serviceCategory are not accepted, while 1 means accepted"
	exit 0
fi

echo -E "Set cdma broadcast sms config"
serviceCategory_from=$1
serviceCategory_to=$2
language=$3
selected=$4
#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_CDMA_SET_BROADCAST_SMS_CONFIG $serviceCategory_from $serviceCategory_to $language $selected"  >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
