/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include "eCall.h"
#include <vendor-ril/telephony/ril.h>

#include <cutils/jstring.h>
#include "cc.h"
#include <glib.h>

#undef LOG_TAG
#define LOG_TAG "MULTI_USER_ECALL"

#ifdef ECALL_SUPPORT
extern speech_status getSpeechStatus();
extern void setSpeechAndStatus(int value);
//RIL_REQUEST_ECALL_SET_IVS
int setIVS(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
  android::Parcel p;
  size_t pos = p.dataPosition();

  if (getSpeechStatus() == SPEECH_OFF) {
    if (get_audio_path() == 0) {
      setSpeechAndStatus(1);
    } else {
      setSpeechAndStatus(2);
    }
  }

  //paramter int. 0 disable, 1 enable
  p.writeInt32(1);
  p.writeInt32(atoi(argv[1]) ? 1 : 0);
  p.setDataPosition(pos);
  pRI->pCI->dispatchFunction(p, pRI);
  return 0;
}

//RIL_REQUEST_ECALL_SET_MSD
int setMSD(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
  android::Parcel p;
  size_t pos = p.dataPosition();
  int digitCount;
  uint8_t uct;
  int digitLimit;
  char *msd_data_src = (char *) argv[2];
  unsigned char msd_data_dst[MSD_MAX_LENGTH];
  int len = strlen(msd_data_src);

  if (argc < 2 || argv[2] == NULL || len % 2 == 1) {
    //add log msg
    free(pRI);
    return -1;
  }

  if (getSpeechStatus() == SPEECH_OFF) {
    if (get_audio_path() == 0) {
      setSpeechAndStatus(1);
    } else {
      setSpeechAndStatus(2);
    }
  }
  //call_id
  p.writeInt32(atoi(argv[1]));
  //msd_data Convert MSD to byte representation
  RLOGD("msd_data_src: msd_data_src length = %d %s\n", strlen(msd_data_src),
      msd_data_src);
  ConvertMsd((const char *) argv[2], msd_data_dst);

  digitLimit = MIN(len / 2, MSD_MAX_LENGTH);
  p.writeInt32(digitLimit);

  for (digitCount = 0; digitCount < digitLimit; digitCount++) {
    p.write(&(msd_data_dst[digitCount]), sizeof(uint8_t));
  }

  p.setDataPosition(pos);
  pRI->pCI->dispatchFunction(p, pRI);
  return 0;
}
//RIL_REQUEST_ECALL_SET_PSAP
int setPASP(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
  android::Parcel p;
  size_t pos = p.dataPosition();

  if (getSpeechStatus() == SPEECH_OFF) {
    if (get_audio_path() == 0) {
      setSpeechAndStatus(1);
    } else {
      setSpeechAndStatus(2);
    }
  }

  //paramter int. 0 disable, 1 enable
  p.writeInt32(1);
  p.writeInt32(atoi(argv[1]) ? 1 : 0);
  p.setDataPosition(pos);
  pRI->pCI->dispatchFunction(p, pRI);
  return 0;
}

//RIL_REQUEST_ECALL_IVS_PUSH_MSD
int IVSPushMSD(int argc, char **argv, RIL_SOCKET_ID socket_id,
    RequestInfo *pRI) {
  android::Parcel p;

  if (getSpeechStatus() == SPEECH_OFF) {
    if (get_audio_path() == 0) {
      setSpeechAndStatus(1);
    } else {
      setSpeechAndStatus(2);
    }
  }

  //paramter none
  pRI->pCI->dispatchFunction(p, pRI);
  return 0;
}
//RIL_REQUEST_ECALL_PSAP_PULL_MSD
int PSAPPushMSD(int argc, char **argv, RIL_SOCKET_ID socket_id,
    RequestInfo *pRI) {
  android::Parcel p;

  if (getSpeechStatus() == SPEECH_OFF) {
    if (get_audio_path() == 0) {
      setSpeechAndStatus(1);
    } else {
      setSpeechAndStatus(2);
    }
  }

  //paramter none
  pRI->pCI->dispatchFunction(p, pRI);
  return 0;
}
int setCTRLSequence(int argc, char **argv, RIL_SOCKET_ID socket_id,
    RequestInfo *pRI) {
  android::Parcel p;
  size_t pos = p.dataPosition();

  if (argc < 1 || argc > 4) {
    //add log msg
    free(pRI);
    return -1;
  }
  //CTRL Sequence
  p.writeInt32(3);
  writeStringToParcel(p, (const char *) argv[1]);
  writeStringToParcel(p, (const char *) argv[2]);
  writeStringToParcel(p, (const char *) argv[3]);

  p.setDataPosition(pos);
  pRI->pCI->dispatchFunction(p, pRI);

  return 0;
}
//RIL_REQUEST_ECALL_RESET_IVS
int resetIVS(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
  android::Parcel p;

  if (getSpeechStatus() == SPEECH_OFF) {
    if (get_audio_path() == 0) {
      setSpeechAndStatus(1);
    } else {
      setSpeechAndStatus(2);
    }
  }

  //paramter none
  pRI->pCI->dispatchFunction(p, pRI);
  return 0;
}
//RIL_REQUEST_ECALL_SET_TEST_NUM
int setTestNum(int argc, char **argv, RIL_SOCKET_ID socket_id,
    RequestInfo *pRI) {
  android::Parcel p;
  size_t pos = p.dataPosition();

  if(argc -1 == 0) {
    p.writeInt32(0);
    p.writeInt32(0);
    writeStringToParcel(p, "");
  } else if (argc -1 == 1) {
    p.writeInt32(1);
    p.writeInt32(atoi(argv[1]) ? 1 : 0);
    writeStringToParcel(p, "");
  } else if (argc - 1 == 2) {
    p.writeInt32(2);
    p.writeInt32(atoi(argv[1]) ? 1 : 0);
    writeStringToParcel(p, (const char *) argv[2]);
  } else {
    RLOGD("parameters is invalid");
    free(pRI);
    return -1;
  }
  p.setDataPosition(pos);
  pRI->pCI->dispatchFunction(p, pRI);
  return 0;
}

//RIL_REQUEST_ECALL_SET_RECONF_NUM
int setReconfNum(int argc, char **argv, RIL_SOCKET_ID socket_id,
    RequestInfo *pRI) {
  android::Parcel p;
  size_t pos = p.dataPosition();
  if(argc -1 == 0) {
    p.writeInt32(0);
    p.writeInt32(0);
    writeStringToParcel(p, "");
  } else if (argc -1 == 1) {
    p.writeInt32(1);
    p.writeInt32(atoi(argv[1]) ? 1 : 0);
    writeStringToParcel(p, "");
  } else if (argc - 1 == 2) {
    p.writeInt32(2);
    p.writeInt32(atoi(argv[1]) ? 1 : 0);
    writeStringToParcel(p, (const char *) argv[2]);
  } else {
    RLOGD("parameters is invalid");
    free(pRI);
    return -1;
  }
  p.setDataPosition(pos);
  pRI->pCI->dispatchFunction(p, pRI);
  return 0;
}

//RIL_REQUEST_ECALL_MAKE_ECALL
int makeECall(int argc, char **argv, RIL_SOCKET_ID socket_id,
    RequestInfo *pRI) {
  android::Parcel p;
  size_t pos = p.dataPosition();
  //paramter int, type
  int type;
  type = atoi(argv[1]);
  if (type < 0 || type > 3) {
    RLOGW("makeECall type is invaild. set default 0!");
    type = 0;
  }

  p.writeInt32(1);
  p.writeInt32(type);
  p.setDataPosition(pos);
  pRI->pCI->dispatchFunction(p, pRI);
  return 0;
}

//RIL_REQUEST_ECALL_FAST_MAKE_ECALL
/*cmd:1, ecall_cat,
*2, ecall_variant,
*3, ivs_mode,
*4, address
*5, msd_data
*/
int dialFastEcall(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
//    android::Parcel p;
//    size_t pos =  p.dataPosition();
//    int digitCount;
//    uint8_t uct;
//    int digitLimit;
//    char *msd_data_src = (char *)argv[5];
//    unsigned char msd_data_dst[MSD_MAX_LENGTH];
//    int len = strlen(msd_data_src);
//
//    if (argc < 5 || argv[4] == NULL || argv[5] == NULL || len%2 == 1) {
//        //add log msg
//        free(pRI);
//        return -1;
//    }
//    //ecall_cat
//    p.writeInt32(atoi(argv[1]));
//    //ecall_variant
//    p.writeInt32(atoi(argv[2]));
//    //ivs_mode
//    p.writeInt32(atoi(argv[3]));
//    //address;
//    if(strcasecmp(argv[4], "null") == 0)
//    {
//        writeStringToParcel(p, "");
//    } else {
//        writeStringToParcel(p, (const char *)argv[4]);
//    }
//
//    //msd_data Convert MSD to byte representation
//    RLOGD("msd_data_src: msd_data_src length = %d %s\n", strlen(msd_data_src), msd_data_src);
//    ConvertMsd((const char *)argv[5], msd_data_dst);
//
//    digitLimit= MIN(len/2, MSD_MAX_LENGTH);
//    p.writeInt32(digitLimit);
//
//    for (digitCount = 0 ; digitCount < digitLimit; digitCount ++) {
//        p.write(&(msd_data_dst[digitCount]), sizeof(uint8_t));
//    }
//
//    p.setDataPosition(pos);
//    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

//RIL_REQUEST_ECALL_SET_PRI
int setEmsdpri(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
  if(argc != 5) {
    RLOGW("parameter is invalid");
    free(pRI);
    return 0;
  }
  int data1 = atoi(argv[1]);
  int data2 = atoi(argv[2]);
  int data3 = atoi(argv[3]);
  int data4 = atoi(argv[4]);

  if (data1 + data2 + data3 + data4 != 10 ) {
    RLOGW("parameter is invalid , %d,%d,%d,%d",data1, data2, data3, data4);
    free(pRI);
    return 0;
  }
  android::Parcel p;
  size_t pos = p.dataPosition();
  p.writeInt32(4);
  p.writeInt32(data1);
  p.writeInt32(data2);
  p.writeInt32(data3);
  p.writeInt32(data4);
  p.setDataPosition(pos);
  pRI->pCI->dispatchFunction(p, pRI);
  return 0;
}
#endif /*ECALL_SUPPORT*/
