/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include <vendor-ril/telephony/ril.h>
#include <stdlib.h>
#include <stdio.h>
#include <cutils/jstring.h>
#include <log/log.h>
#include <unistd.h>
#include <math.h>
#include  "common.h"
#include "em/em.h"
#include "Radio_capability_switch_util.h"

#if EM_MODE_SUPPORT

#undef LOG_TAG
#define LOG_TAG "EM_CFU"

const int QUERY = 3;
const int SET_DEFAULT = 0;
const int SET_ON = 2;
const int SET_OFF = 1;
#define CFU_QUERY_CMD  "AT+ESSP?"
#define CFU_SET_CMD  "AT+ESSP="
int mCurrentEmcfuFlag = 0;
int cfumode = -1;

void  sendATCommand_ecfu(const char *cmd,int msg)
{
    mCurrentEmcfuFlag = msg;
    emSendATCommand(cmd, Radio_capability_switch_util::get_main_capability_phone_id());
    return ;
}

void emCfuAtCmdHandle(char*response, int responselen) {
    switch (mCurrentEmcfuFlag) {
        case QUERY:
        {
            //parse hspa mode.
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("emCfuAtCmdHandle QUERY response: %s\n",response);
            }
            else {
                RLOGD("send fail ");
            }
            android::unregisterNetwork();
            android::emResultNotify(RET_STRING_CFU_SUCCESS);
            break;
        }
        case SET_DEFAULT:
        {
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("Set default success: %s.\n",response);
            }
            else {
                RLOGD("send fail ");
            }
            break;
        }
        case SET_ON:
        {
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("Set on success: %s.\n",response);
            }
            else {
                RLOGD("send fail ");
            }
            break;
        }
        case SET_OFF:
        {
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("Set off success: %s.\n",response);
            }
            else {
                RLOGD("send fail ");
            }
            break;
        }
        default:
            break;
    }
}


//create thread to send command
void * emCfuThread(void* arg)
{
    char cmd_str[32] = {0};
    sprintf(cmd_str,"%s%d", CFU_SET_CMD,cfumode);
    sendATCommand_ecfu(cmd_str,cfumode);
    sendATCommand_ecfu(CFU_QUERY_CMD,QUERY);
    pthread_exit(0);
}

int emCfuStart(int argc, int *item)
{
    RLOGD("emCfuStart called");
    if(argc < 1)
    {
        RLOGD("emCfuStart: please select mode to test: \
                0: default, 1: set on 2: set off");
        android::emResultNotify(RET_STRING_CFU_FAIL);
        return -1;
    }
    if((item[0] > 2 ) || (item[0] < 0)){
        RLOGD("emCfuStart: invalid parameter %d",item[0]);
        android::emResultNotify(RET_STRING_CFU_FAIL);
        return -1;
    }
    int cfumapping[3] = {SET_DEFAULT,SET_ON,SET_OFF};
    mCurrentEmcfuFlag = 0;
    cfumode = cfumapping[item[0]];
    android::registerForATcmdResponse(emCfuAtCmdHandle);
    pthread_t emcfu_thread;
    pthread_create(&emcfu_thread,NULL, emCfuThread, NULL);
    return (0);
}

#endif

