/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <log/log.h>
#include <stdexcept>
#include "NetworkInfoUrcParser.h"
#include "Content.h"
#include "../../util/utils.h"
#include "../../util/ModemCategory.h"

#undef LOG_TAG
#define LOG_TAG "EM_NetworkInfoUrcParser"

const int NetworkInfoUrcParser::DATA_OFFSET_2 = 2;
const int NetworkInfoUrcParser::DATA_OFFSET_4 = 4;
const int NetworkInfoUrcParser::DATA_OFFSET_6 = 6;
const int NetworkInfoUrcParser::DATA_OFFSET_8 = 8;
const int NetworkInfoUrcParser::DATA_FORMAT = 16;
const int NetworkInfoUrcParser::MAX_DATA_PER_LINE = 7;

const int NetworkInfoUrcParser::TYPE_UINT8 = 0;
const int NetworkInfoUrcParser::TYPE_UINT16 = 1;
const int NetworkInfoUrcParser::TYPE_UINT32 = 2;
const int NetworkInfoUrcParser::TYPE_INT8 = 3;
const int NetworkInfoUrcParser::TYPE_INT16 = 4;
const int NetworkInfoUrcParser::TYPE_INT32 = 5;
const int NetworkInfoUrcParser::TYPE_LONG = 6;
const int NetworkInfoUrcParser::TYPE_FLOAT = 7;
const int NetworkInfoUrcParser::TYPE_ALIGNMENT = 8;
const int NetworkInfoUrcParser::TYPE_STRING = 9;

const bool NetworkInfoUrcParser::ALIGN_MENT_ENABLE = true;
const bool NetworkInfoUrcParser::GPRS_MODE_ENABLE = true;
const bool NetworkInfoUrcParser::AMR_SUPPORT_ENABLE = true;
const bool NetworkInfoUrcParser::FWPNC_LAI_INFO_ENABLE = false;
const bool NetworkInfoUrcParser::UMTS_R8 = true;
const bool NetworkInfoUrcParser::WISDOM_EM = true;
const bool NetworkInfoUrcParser::ADVANCED_EM = true;
const bool NetworkInfoUrcParser::IS_MOLY = Content::IS_MOLY;

const int NetworkInfoUrcParser::MODEM_FDD = 1;
const int NetworkInfoUrcParser::MODEM_TD = 2;

NetworkInfoUrcParser::NetworkInfoUrcParser() {
    // TODO Auto-generated constructor stub

}

NetworkInfoUrcParser::~NetworkInfoUrcParser() {
    // TODO Auto-generated destructor stub
}

std::string NetworkInfoUrcParser::get3GUl2EmPsDataRateStatusIndStruct() {
    parseElement(TYPE_UINT16, "rx_mac_data_rate:");
    parseElement(TYPE_UINT16, "rx_pdcp_data_rate:");
    parseElement(TYPE_UINT16, "tx_mac_data_rate:");
    parseElement(TYPE_UINT16, "tx_pdcp_data_rate:");
    return mResult;
}
std::string NetworkInfoUrcParser::get3Gul2EmHsdschReconfigStatusIndStruct(){
    for (int i = 0; i < 8; i++) {
        parseElement(TYPE_UINT8, std::string("reconfig_info") + std::to_string(i) + std::string(":"));
    }
    return mResult;
}

std::string NetworkInfoUrcParser::get3GUl2EmUrlcEventStatusIndStruct(){
    parseElement(TYPE_INT8, "rb_id:");
    parseElement(TYPE_UINT8, "rlc_action:");
    parseElement(TYPE_UINT8, "rb_info:--- \nis_srb:");
    parseElement(TYPE_UINT8, "cn_domain:");
    parseElement(TYPE_UINT8, "rlc_info:--- \nrlc_mode:");
    parseElement(TYPE_UINT8, "direction:");
    parseElement(TYPE_UINT16, "rlc_parameter:--- \npdu_Size:");
    parseElement(TYPE_UINT16, "tx_window_size:");
    parseElement(TYPE_UINT16, "rx_window_size:");
    parseElement(TYPE_UINT8, "discard_mode:");
    parseElement(TYPE_UINT16, "discard_value:");
    parseElement(TYPE_UINT8, "flush_data_indicator:");
    parseElement(TYPE_UINT8, "reset_cause:");
    return mResult;
}

std::string NetworkInfoUrcParser::get3GUl2EmPeriodicBlerReportInd(){
    parseElement(TYPE_UINT8, "num_trch:");
    parseElement(TYPE_ALIGNMENT, "");
    mResult.append("TrCHBler:--------");
    for (int i = 0; i < 8; i++) {
        parseElement(TYPE_UINT8, std::string("TrCHId") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT32, std::string("TotalCRC") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT32, std::string("BadCRC")  + std::to_string(i) + std::string(":"));
    }
    return mResult;
}

std::string NetworkInfoUrcParser::get3GUl2EmAdmPoolStatusIndStruct() {
    mResult.append("[dl_adm_poll_info:-----]\n");
    for (int i = 0; i < 4; i++) {
        parseElement(TYPE_UINT16, std::string("max_usage_kbytes") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT16, std::string("avg_usage_kbytes") + std::to_string(i) + std::string(":"));
    }
    mResult.append("[ul_adm_poll_info:-----]\n");
    for (int i = 0; i < 4; i++) {
        parseElement(TYPE_UINT16, std::string("max_usage_kbytes") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT16, std::string("avg_usage_kbytes") + std::to_string(i) + std::string(":"));
    }
    return mResult;
}

std::string NetworkInfoUrcParser::get3GCsceEMServCellSStatusInd(bool isTdd) {
    if (!IS_MOLY) {
        parseElement(TYPE_UINT8, "ref_count:");
        parseElement(TYPE_UINT16, "msg_len");
    }
    parseElement(TYPE_UINT8, "cell_idx: ");
    parseElement(TYPE_UINT16, "uarfacn_DL: ");
    parseElement(TYPE_UINT16, "psc: ");
    parseElement(TYPE_UINT8, "is_s_criteria_satisfied: ");
    parseElement(TYPE_INT8, "qQualmin: ");
    parseElement(TYPE_INT8, "qRxlevmin: ");
    parseElement(TYPE_INT32, "srxlev: ");
    parseElement(TYPE_INT32, "spual: ");
    parseElement(TYPE_LONG, "rscp: ");
    if (!isTdd) {
        parseElement(TYPE_FLOAT, "ec_no: ");
    }
    parseElement(TYPE_UINT16, "cycle_len: ");
    if (!isTdd) {
        parseElement(TYPE_UINT8, "quality_measure: ");
    }
    parseElement(TYPE_UINT8, "band: ");
    parseElement(TYPE_INT32, "rssi: ");
    parseElement(TYPE_UINT32, "cell_identity: ");
    if (UMTS_R8) {
        parseElement(TYPE_UINT32, "csg_id: ");
        parseElement(TYPE_UINT8, "apbcr_priority: ");
        parseElement(TYPE_UINT8, "sprio_search1: ");
        parseElement(TYPE_UINT8, "sprio_search2: ");
        parseElement(TYPE_UINT8, "threshserv_low: ");
        if (IS_MOLY) {
            parseElement(TYPE_UINT8, "threshserv_low2: ");
        }
    }
    if (!isTdd) {
        parseElement(TYPE_UINT8, "multi_plmn_count: ");
        for (int i = 0; i < 6; i++) {
            parseElement(TYPE_UINT8, std::string("multi_plmn_id[") + std::to_string(i) + std::string("].mcc: "), 3);
            parseElement(TYPE_UINT8, std::string("multi_plmn_id[") + std::to_string(i) + std::string("].mnc: "), 3);
        }

        int lacValid = readIntegerFromByte();
        if (lacValid != 0) {
            parseElement(TYPE_UINT16, "lac: ");
        } else {
            mResult.append("lac: invalid\n");
            mOffset += DATA_OFFSET_4;
        }

        int racValid = readIntegerFromByte();
        if (racValid != 0) {
            parseElement(TYPE_UINT8, "rac: ");
        } else {
            mResult.append("rac: invalid\n");
            mOffset += DATA_OFFSET_2;
        }

        int uraValid = readIntegerFromByte();
        if (uraValid != 0) {
            parseElement(TYPE_UINT8, "num_ura_id: ");
            for (int i = 0; i < 8; i++) {
                int numBits = readIntegerFromByte();
                if (numBits == 1) {
                    parseElement(TYPE_UINT8, std::string("uraIdentity[") + std::to_string(i) + std::string("]: "));
                    mOffset += DATA_OFFSET_2; // skip high byte
                } else {
                    parseElement(TYPE_UINT8, std::string("uraIdentity[") + std::to_string(i) + std::string("]: "), 2);
                }
            }
        } else {
            mResult.append("ura: invalid\n");
        }
    }
    return mResult;
}

std::string NetworkInfoUrcParser::getxGCsceEMNeighCellSStatusIndStructSize(bool isTdd) {
    if (!IS_MOLY) {
        parseElement(TYPE_UINT8, "ref_count:");
        parseElement(TYPE_UINT16, "msg_len");
    }
    parseElement(TYPE_UINT8, "neigh_cell_count:");
    parseElement(TYPE_UINT8, "operation:");
    std::string xgType = getValueFromByte(mRawString, mOffset, false);
    parseElement(TYPE_UINT8, "RAT_type:");
    parseElement(TYPE_ALIGNMENT, "");

    if (xgType == std::string("1")) {
        mResult.append("----GSM_neigh_cells----\n");
        for (int i = 0; i < 16; i++) {
            parseElement(TYPE_UINT8, std::string("cellidx") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_UINT16, "arfcn");
            parseElement(TYPE_UINT8, std::string("bsic") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_UINT8, std::string("is_bsic_verified") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_UINT8, std::string("is_s_criteria_saticified") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_UINT8, std::string("freq_band") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT8, std::string("qRxlevmin") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT32, std::string("srxlev") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT32, std::string("rssi") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT8, std::string("apbcr_priority") + std::to_string(i)+ std::string(":"));
            parseElement(TYPE_UINT8, std::string("threshx_high") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_UINT8, std::string("threshx_low") + std::to_string(i)+ std::string(":"));
            if (IS_MOLY) {
                parseElement(TYPE_UINT8, std::string("threshx_high2") + std::to_string(i) + std::string(":"));
                parseElement(TYPE_UINT8, std::string("threshx_low2") + std::to_string(i) + std::string(":"));
            }
            parseElement(TYPE_ALIGNMENT, "");
        }
    } else if (xgType == std::string("2")) {
        mResult.append("----LTE_neigh_cells----\n");
        for (int i = 0; i < 16; i++) {
            parseElement(TYPE_UINT16, "earfcn");
            parseElement(TYPE_UINT16, std::string("pci") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT32, std::string("rsrp") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT32, std::string("rsrq") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT32, std::string("Treselection") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT8, std::string("apbcr_priority") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT16, std::string("qRxlevmin") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT8, std::string("qQualMinEUTRA") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_UINT8, std::string("threshx_high") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_UINT8, std::string("threshx_low") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_UINT8, std::string("threshx_high2") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_UINT8, std::string("threshx_low2") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_ALIGNMENT, "");
        }
    } else {
        mResult.append("----3G_neigh_cells----\n");
        for (int i = 0; i < 16; i++) {
            parseElement(TYPE_UINT8, std::string("cellidx") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_UINT16, std::string("arfcn_DL"));
            parseElement(TYPE_UINT16, std::string("psc"));
            parseElement(TYPE_UINT8, std::string("is_s_criteria_saticified") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT8, std::string("qQualmin") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT8, std::string("qRxlevmin") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT32, std::string("srxlev") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT32, std::string("squal") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_LONG, "rscp: ");
            parseElement(TYPE_INT32, std::string("ec_no") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_INT8, std::string("apbcr_priority") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_UINT8, std::string("threshx_high") + std::to_string(i) + std::string(":"));
            parseElement(TYPE_UINT8, std::string("threshx_low") + std::to_string(i) + std::string(":"));
            if (IS_MOLY) {
                parseElement(TYPE_UINT8, std::string("threshx_high2") + std::to_string(i) + std::string(":"));
                parseElement(TYPE_UINT8, std::string("threshx_low2") + std::to_string(i) + std::string(":"));
            }
            if (!isTdd) {
                parseElement(TYPE_UINT32, std::string("cell_identity") + std::to_string(i) + std::string(":"));
                int plmnValid = readIntegerFromByte();
                if (plmnValid != 0) {
                    parseElement(TYPE_UINT8, std::string("multi_plmn_count: "));
                    for (int j = 0; j < 6; j++) {
                        parseElement(TYPE_UINT8, std::string("multi_plmn_id[") + std::to_string(j) + std::string("].mcc: "), 3);
                        parseElement(TYPE_UINT8, std::string("multi_plmn_id[") + std::to_string(j) + std::string("].mnc: "), 3);
                    }
                } else {
                    mOffset += 37 * 2; // skip plmn data
                }

                int lacValid = readIntegerFromByte();
                if (lacValid != 0) {
                    parseElement(TYPE_UINT16, "lac: ");
                } else {
                    mResult.append("lac: invalid\n");
                    mOffset += DATA_OFFSET_6;
                }

                int racValid = readIntegerFromByte();
                if (racValid != 0) {
                    parseElement(TYPE_UINT8, "rac: ");
                } else {
                    mResult.append("rac: invalid\n");
                    mOffset += DATA_OFFSET_2;
                }

                int uraValid = readIntegerFromByte();
                if (uraValid != 0) {
                    parseElement(TYPE_UINT8, "num_ura_id: ");
                    for (int j = 0; j < 8; j++) {
                        int numBits = readIntegerFromByte();
                        if (numBits == 1) {
                            parseElement(TYPE_UINT8, std::string("uraIdentity[") + std::to_string(j) + std::string("]: "));
                            mOffset += DATA_OFFSET_2; // skip high byte
                        } else {
                            parseElement(TYPE_UINT8, std::string("uraIdentity[") + std::to_string(j) + std::string("]: "), 2);
                        }
                    }
                } else {
                    mOffset += 25 * 2; // skip ura data
                    mResult.append("ura: invalid\n");
                }
            }
            parseElement(TYPE_ALIGNMENT, "");
        }
    }
    return mResult;
}

std::string NetworkInfoUrcParser::getValueFrom4Byte(std::string data, int start, bool sig) {
    if (data.length() < start + DATA_OFFSET_8) {
        return std::string("0");
    }
    try {
        std::string byte1 = data.substr(start, start + DATA_OFFSET_2);
        std::string byte2 = data.substr(start + DATA_OFFSET_2, start + DATA_OFFSET_4);
        std::string byte3 = data.substr(start + DATA_OFFSET_4, start + DATA_OFFSET_6);
        std::string byte4 = data.substr(start + DATA_OFFSET_6, start + DATA_OFFSET_8);
        std::string reverse = byte4 + byte3 + byte2 + byte1;
        if (sig) {
            long lg = std::stol(reverse,0, DATA_FORMAT);
            int i = (int) lg;
            return std::to_string(i);
        } else {
            return std::to_string(std::stol(reverse,0, DATA_FORMAT));
        }
    } catch (const std::out_of_range &e) {
        RLOGD("out of range: %s, line: %s", e.what(), __LINE__);
        return std::string("Error.");
    } catch (const std::invalid_argument &e) {
        RLOGD("invalid argument: %s, line: %s", e.what(), __LINE__);
        return std::string("Error.");
    }
}
std::string NetworkInfoUrcParser::oneBlockFrom4Byte(std::string label, std::string data, int start,bool sig, int dataLength) {
    std::string block(label);
    for (int i = 0; i < dataLength; i++) {
        if (dataLength > MAX_DATA_PER_LINE && 0 == i % MAX_DATA_PER_LINE) {
            block += std::string("\n");
        }
        block += getValueFrom4Byte(data, start, sig);
        start += DATA_OFFSET_8;
        if (i != dataLength - 1) {
            block += std::string(", ");
        }
    }
    return block + std::string("\n");
}

std::string NetworkInfoUrcParser::getValueFrom2Byte(std::string data, int start, bool sig) {
    if (data.length() < start + DATA_OFFSET_4) {
        return std::string("0");
    }
    try {
        std::string low = data.substr(start, start + DATA_OFFSET_2);
        std::string high = data.substr(start + DATA_OFFSET_2, start + DATA_OFFSET_4);
        std::string reverse = high + low;
        if (sig) {
            int i = std::stoi(reverse,0, DATA_FORMAT);
            int16_t s = (int16_t) i;
            return std::to_string(s);
        } else {
            return std::to_string(std::stoi(reverse,0, DATA_FORMAT));
        }
    } catch (const std::out_of_range &e) {
        RLOGD("out of range: %s, line: %s", e.what(), __LINE__);
        return std::string("Error.");
    } catch (const std::invalid_argument &e) {
        RLOGD("invalid argument: %s, line: %s", e.what(), __LINE__);
        return std::string("Error.");
    }
}

std::string NetworkInfoUrcParser::oneBlockFrom2Byte(std::string label, std::string data, int start,bool sig, int dataLength) {
    std::string block(label);
    for (int i = 0; i < dataLength; i++) {
        if ((dataLength > MAX_DATA_PER_LINE) && (0 == i % MAX_DATA_PER_LINE)) {
            block += std::string("\n");
        }
        block += getValueFrom2Byte(data, start, sig);
        start += DATA_OFFSET_4;
        if (i != dataLength - 1) {
            block += std::string(", ");
        }
    }
    return block + std::string("\n");
}

std::string NetworkInfoUrcParser::getValueFromByte(std::string data, int start, bool sig) {
    if (data.length() < start + DATA_OFFSET_2) {
        return std::string("0");
    }
    try {
        std::string sub = data.substr(start, start + DATA_OFFSET_2);
        if (sig) {
            int16_t s = std::stoi(sub, 0, DATA_FORMAT);
            int8_t b = (int8_t) s;
            return std::to_string(b); //???
        } else {
            return std::to_string(std::stoi(sub, 0, DATA_FORMAT));
        }
    } catch (const std::out_of_range &e) {
        RLOGD("out of range: %s, line: %s", e.what(), __LINE__);
        return std::string("Error.");
    } catch (const std::invalid_argument &e) {
        RLOGD("invalid argument: %s, line: %s", e.what(), __LINE__);
        return std::string("Error.");
    }
}

std::string NetworkInfoUrcParser::oneBlockFromByte(std::string label, std::string data, int start,bool sig, int dataLength) {
    std::string block(label);
    for (int i = 0; i < dataLength; i++) {
        if (dataLength > MAX_DATA_PER_LINE && 0 == i % MAX_DATA_PER_LINE) {
            block += "\n";
        }
        block.append(getValueFromByte(data, start, sig));
        start += DATA_OFFSET_2;
        if (i != dataLength - 1) {
            block += std::string(", ");
        }
    }
    return block + std::string("\n");
}

std::string NetworkInfoUrcParser::parseElement(int type, std::string label, int count){
    std::string value("");
    switch (type) {
    case TYPE_UINT8:
    {
        value = oneBlockFromByte(label, mRawString, mOffset, false, count);
        mOffset += 2 * count;
        break;
    }
    case TYPE_UINT16:
    {
        if (ALIGN_MENT_ENABLE) {
            mOffset = (mOffset + 3) & ~3;
        }
        value = oneBlockFrom2Byte(label, mRawString, mOffset, false, count);
        mOffset += 4 * count;
        break;
    }
    case TYPE_UINT32:
    {
        if (ALIGN_MENT_ENABLE) {
            mOffset = (mOffset + 7) & ~7;
        }
        value = oneBlockFrom4Byte(label, mRawString, mOffset, false, count);
        mOffset += 8 * count;
        break;
    }
    case TYPE_INT8:
    {
        value = oneBlockFromByte(label, mRawString, mOffset, true, count);
        mOffset += 2 * count;
        break;
    }
    case TYPE_INT16:
    {
        if (ALIGN_MENT_ENABLE) {
            mOffset = (mOffset + 3) & ~3;
        }
        value = oneBlockFrom2Byte(label, mRawString, mOffset, true, count);
        mOffset += 4 * count;
        break;
    }
    case TYPE_INT32:
    {
        if (ALIGN_MENT_ENABLE) {
            mOffset = (mOffset + 7) & ~7;
        }
        value = oneBlockFrom4Byte(label, mRawString, mOffset, true, count);
        mOffset += 8 * count;
        break;
    }
    case TYPE_LONG:
    {
        if (ALIGN_MENT_ENABLE) {
            mOffset = (mOffset + 7) & ~7;
        }
        std::string strRscp = getValueFrom4Byte(mRawString, mOffset, true);
        long rscp = 0;
        try {
            rscp = std::stol(strRscp) / 4096;
        } catch (const std::out_of_range &e) {
            RLOGD("out of range: %s, line: %s", e.what(), __LINE__);
        } catch (const std::invalid_argument &e) {
            RLOGD("invalid argument: %s, line: %s", e.what(), __LINE__);
        }
        value = label + std::to_string(rscp) + std::string("\n");
        mOffset += 8;
        break;
    }
    case TYPE_FLOAT:
    {
        if (ALIGN_MENT_ENABLE) {
            mOffset = (mOffset + 7) & ~7;
        }
        std::string strEcno = getValueFrom4Byte(mRawString, mOffset, true);
        float ecno = 0;
        try {
            ecno = std::stof(strEcno) / 4096;
        } catch (const std::out_of_range &e) {
            RLOGD("out of range: %s, line: %s", e.what(), __LINE__);
        } catch (const std::invalid_argument &e) {
            RLOGD("invalid argument: %s, line: %s", e.what(), __LINE__);
        }
        value = label + std::to_string(ecno) + std::string("\n");
        mOffset += 8;
        break;
    }
    case TYPE_STRING:
    {
        value = label;
        for (int i = 0; i < count; i++) {
            std::string str = getValueFromByte(mRawString, mOffset, false);
            mOffset += 2;
            try {
                short s = std::stoi(str);
                value.push_back((char) s); //???
            } catch (const std::out_of_range &e) {
                RLOGD("out of range: %s, line: %s", e.what(), __LINE__);
                break;
            } catch (const std::invalid_argument &e) {
                RLOGD("invalid argument: %s, line: %s", e.what(), __LINE__);
                break;
            }
        }
        value += std::string("\n");
        break;
    }
    case TYPE_ALIGNMENT:
    {
        if (ALIGN_MENT_ENABLE) {
            mOffset = (mOffset + 7) & ~7;
        }
        break;
    }
    default:
        break;
    }
    mResult.append(value);
    return value;
}

std::string NetworkInfoUrcParser::parseElement(int type, std::string label) {
    return parseElement(type, label, 1);
}

std::string NetworkInfoUrcParser::getCellSelInfo() {
    parseElement(TYPE_UINT8, "crh: ");
    parseElement(TYPE_UINT8, "ms_txpwr: ");
    parseElement(TYPE_UINT8, "rxlev_access_min: ");
    return mResult;
}

std::string NetworkInfoUrcParser::getChDscrInfo() {
    parseElement(TYPE_UINT8,  "channel_type: ");
    parseElement(TYPE_UINT8,  "tn: ");
    parseElement(TYPE_UINT8,  "tsc: ");
    parseElement(TYPE_UINT8,  "hopping_flag: ");
    parseElement(TYPE_UINT8,  "maio: ");
    parseElement(TYPE_UINT8,  "hsn: ");
    parseElement(TYPE_UINT8,  "num_of_carriers: ");
    parseElement(TYPE_UINT16, "arfcn:", 64);
    parseElement(TYPE_INT8,   "is_BCCH_arfcn_valid: ");
    parseElement(TYPE_UINT16, "BCCH_arfcn: ");
    parseElement(TYPE_UINT8,  "cipher_algo: ");
    parseElement(TYPE_UINT8,  "imeisv_digit: ", 16);
    parseElement(TYPE_UINT8,  "channel_mode: ");
    if (AMR_SUPPORT_ENABLE) {
        parseElement(TYPE_INT8,  "amr_valid: ");
        parseElement(TYPE_UINT8, "mr_ver: ");
        parseElement(TYPE_INT8,  "nscb: ");
        parseElement(TYPE_INT8,  "icmi: ");
        parseElement(TYPE_UINT8, "start_codec_mode: ");
        parseElement(TYPE_UINT8, "acs: ");
        parseElement(TYPE_UINT8, "threshold:", 3);
        parseElement(TYPE_UINT8, "hysteresis:", 3);
    }
    return mResult;
}

std::string NetworkInfoUrcParser::getRACHCtrlInfo() {
    parseElement(TYPE_UINT8, "max_retrans: ");
    parseElement(TYPE_UINT8, "tx_integer: ");
    parseElement(TYPE_UINT8, "cba: ");
    parseElement(TYPE_UINT8, "re: ");
    parseElement(TYPE_UINT8, "acc_class:", 2);
    parseElement(TYPE_INT8,  "CB_supported: ");
    return mResult;
}


std::string NetworkInfoUrcParser::getLAIInfo() {
    parseElement(TYPE_UINT8, "mcc:", 3);
    parseElement(TYPE_UINT8, "mnc:", 3);
    parseElement(TYPE_UINT8, "lac:", 2);
    parseElement(TYPE_UINT16, "cell_id: ");
    parseElement(TYPE_UINT8, "nc_info_index: ");
    parseElement(TYPE_UINT8, "rac: ");
    parseElement(TYPE_UINT8, "nmo: ");
    parseElement(TYPE_UINT8, "supported_Band: ");
    return mResult;
}

std::string NetworkInfoUrcParser::getRadioLinkInfo() {
    parseElement(TYPE_UINT16, "max_value: ");
    parseElement(TYPE_INT16, "current_value: ");
    parseElement(TYPE_UINT8, "dtx_ind: ");
    parseElement(TYPE_UINT8, "dtx_used: ");
    parseElement(TYPE_INT8, "is_dsf: ");
    return mResult;
}

std::string NetworkInfoUrcParser::getMeasRepInfo() {
    parseElement(TYPE_UINT8, "rr_state: ");
    if (IS_MOLY) {
        parseElement(TYPE_UINT8, "meas_mode: ");
    }
    parseElement(TYPE_UINT16, "serving_arfcn: ");
    parseElement(TYPE_UINT8, "serving_bsic: ");
    parseElement(TYPE_UINT8, "serving_current_band: ");
    parseElement(TYPE_UINT8, "serv_gprs_supported: ");
    parseElement(TYPE_INT16, "serv_rla_in_quarter_dbm: ");
    if (IS_MOLY) {
        parseElement(TYPE_UINT8, "serv_rla_reported_value: ");
    }
    parseElement(TYPE_INT8, "is_serv_BCCH_rla_valid: ");
    parseElement(TYPE_INT16, "serv_BCCH_rla_in_dedi_state: ");
    parseElement(TYPE_UINT8, "quality: ");
    parseElement(TYPE_INT8, "gprs_pbcch_present: ");
    parseElement(TYPE_INT8, "gprs_c31_c32_enable: ");
    if (!IS_MOLY) {
        parseElement(TYPE_INT16, "c31:", 32);
    }
    parseElement(TYPE_INT16, "c1_serv_cell: ");
    parseElement(TYPE_INT16, "c2_serv_cell: ");
    parseElement(TYPE_INT16, "c31_serv_cell: ");
    parseElement(TYPE_UINT8, "num_of_carriers: ");
    parseElement(TYPE_UINT16, "nc_arfcn:", 32);
    parseElement(TYPE_INT16, "rla_in_quarter_dbm:", 32);
    if (IS_MOLY) {
        parseElement(TYPE_UINT8, "rla_in_reported_value: ", 32);
    }
    parseElement(TYPE_UINT8, "nc_info_status:", 32);
    parseElement(TYPE_UINT8, "nc_bsic:", 32);
    parseElement(TYPE_INT32, "frame_offset:", 32);
    parseElement(TYPE_INT32, "ebit_offset:", 32);
    parseElement(TYPE_INT16, "c1:", 32);
    parseElement(TYPE_INT16, "c2:", 32);
    if (IS_MOLY) {
        parseElement(TYPE_INT16, "c31:", 32);
    }
    parseElement(TYPE_UINT8, "multiband_report: ");
    parseElement(TYPE_UINT8, "timing_advance: ");
    parseElement(TYPE_INT16, "tx_power_level: ");
    parseElement(TYPE_INT16, "serv_rla_full_value_in_quater_dbm: ");
    parseElement(TYPE_UINT8, "nco: ");
    parseElement(TYPE_UINT8, "rxqual_sub: ");
    parseElement(TYPE_UINT8, "rxqual_full: ");
    parseElement(TYPE_INT16, "using_tx_power_in_dbm: ");
    parseElement(TYPE_INT8, "amr_info_valid: ");
    parseElement(TYPE_UINT8, "cmr_cmc_cmiu_cmid: ");
    parseElement(TYPE_UINT8, "c_i: ");
    parseElement(TYPE_UINT16, "icm: ");
    parseElement(TYPE_UINT16, "acs: ");
    parseElement(TYPE_INT8, "dl_dtx_used: ");
    if (FWPNC_LAI_INFO_ENABLE) {
        parseElement(TYPE_UINT8, "num_of_nc_lai: ");
        mResult.append("nc_lai:\n");
        for (int i = 0; i < 6; i++) {
            parseElement(TYPE_UINT8, std::string("nc_lai[") + std::to_string(i) + std::string("]:\n") + std::string("mcc:"), 3);
            parseElement(TYPE_UINT8, "mnc:", 3);
            parseElement(TYPE_UINT8, "lac:", 2);
            parseElement(TYPE_UINT16, "cell_id: ");
            parseElement(TYPE_UINT8, "nc_info_index: ");
        }
    }
    return mResult;
}

std::string NetworkInfoUrcParser::getCaListInfo() {
    parseElement(TYPE_UINT8, "valid: ");
    parseElement(TYPE_UINT8, "number_of_channels: ");
    parseElement(TYPE_UINT16, "arfcn_list:", 64);
    return mResult;
}

std::string NetworkInfoUrcParser::getControlMsgInfo() {
    parseElement(TYPE_UINT8, "msg_type: ");
    parseElement(TYPE_UINT8, "rr_cause: ");
    return mResult;
}

std::string NetworkInfoUrcParser::getSI2QInfo() {
    parseElement(TYPE_INT8, "present: ");
    parseElement(TYPE_UINT8, "no_of_instance: ");
    parseElement(TYPE_INT8, "emr_report: ");
    parseElement(TYPE_INT8, "pemr_report: ");
    parseElement(TYPE_INT8, "umts_parameter_exist: ");
    return mResult;
}

std::string NetworkInfoUrcParser::getMIInfo() {
    parseElement(TYPE_INT8, "present: ");
    parseElement(TYPE_UINT8, "no_of_instance: ");
    parseElement(TYPE_INT8, "emr_report: ");
    parseElement(TYPE_INT8, "umts_parameter_exist: ");
    return mResult;
}


std::string NetworkInfoUrcParser::getBLKInfo() {
    parseElement(TYPE_UINT8, "ul_coding_scheme: ");
    parseElement(TYPE_UINT8, "ul_cv: ");
    parseElement(TYPE_UINT8, "ul_tlli: ");
    parseElement(TYPE_UINT16, "ul_bsn1: ");
    if (GPRS_MODE_ENABLE) {
        parseElement(TYPE_UINT16, "ul_bsn2: ");
        parseElement(TYPE_UINT8, "ul_cps: ");
        parseElement(TYPE_UINT8, "ul_rsb: ");
        parseElement(TYPE_UINT8, "ul_spb: ");
    }
    parseElement(TYPE_UINT8, "dl_c_value_in_rx_level: ");
    parseElement(TYPE_UINT8, "dl_rxqual: ");
    parseElement(TYPE_UINT8, "dl_sign_var: ");
    parseElement(TYPE_UINT8, "dl_coding_scheme: ");
    parseElement(TYPE_UINT8, "dl_fbi: ");
    parseElement(TYPE_UINT16, "dl_bsn1: ");
    if (GPRS_MODE_ENABLE) {
        parseElement(TYPE_UINT16, "dl_bsn2: ");
        parseElement(TYPE_UINT8, "dl_cps: ");
        parseElement(TYPE_UINT8, "dl_gmsk_mean_bep_lev: ");
        parseElement(TYPE_UINT8, "dl_8psk_mean_bep_lev: ");
        parseElement(TYPE_UINT8, "dl_tn_mean_bep_lev:", 8);
    }
    parseElement(TYPE_UINT8, "dl_tn_interference_lev:", 8);
    return mResult;
}


std::string NetworkInfoUrcParser::getTBFInfo() {
    parseElement(TYPE_UINT8, "tbf_mode: ");
    parseElement(TYPE_UINT8, "ul_tbf_status: ");
    parseElement(TYPE_UINT8, "ul_rel_cause: ");
    parseElement(TYPE_UINT8, "ul_ts_allocation: ");
    parseElement(TYPE_UINT8, "ul_rlc_mode: ");
    parseElement(TYPE_UINT8, "ul_mac_mode: ");
    parseElement(TYPE_UINT16, "number_rlc_octect: ");
    parseElement(TYPE_UINT8, "ul_tfi: ");
    parseElement(TYPE_UINT8, "ul_granularity: ");
    parseElement(TYPE_UINT8, "ul_usf: ");
    parseElement(TYPE_UINT8, "ul_tai: ");
    parseElement(TYPE_UINT16, "ul_tqi: ");
    parseElement(TYPE_UINT16, "ul_window_size: ");
    parseElement(TYPE_UINT8, "dl_tbf_status: ");
    parseElement(TYPE_UINT8, "dl_rel_cause: ");
    parseElement(TYPE_UINT8, "dl_ts_allocation: ");
    parseElement(TYPE_UINT8, "dl_rlc_mode: ");
    parseElement(TYPE_UINT8, "dl_mac_mode: ");
    parseElement(TYPE_UINT8, "dl_tfi: ");
    parseElement(TYPE_UINT8, "dl_tai: ");
    parseElement(TYPE_UINT16, "dl_window_size: ");
    if (GPRS_MODE_ENABLE) {
        parseElement(TYPE_UINT8, "dl_out_of_memory: ");
    }
    return mResult;
}

std::string NetworkInfoUrcParser::getGPRSGenInfo() {
    parseElement(TYPE_UINT32, "t3192: ");
    parseElement(TYPE_UINT32, "t3168: ");
    parseElement(TYPE_UINT8, "rp: ");
    parseElement(TYPE_UINT8, "gprs_support: ");
    parseElement(TYPE_UINT8, "egprs_support: ");
    parseElement(TYPE_UINT8, "sgsn_r: ");
    parseElement(TYPE_UINT8, "pfc_support: ");
    parseElement(TYPE_UINT8, "epcr_support: ");
    parseElement(TYPE_UINT8, "bep_period: ");
    return mResult;
}

std::string NetworkInfoUrcParser::get3GGeneralInfo() {
    if (getValueFromByte(mRawString, mOffset, false).compare("255") == 0) {
        // "FF" means Invalid service_status
        mResult.append("service_status:\n");
        mOffset += 2;
    } else {
        parseElement(TYPE_UINT8, "service_status: ");
    }

    if (getValueFromByte(mRawString, mOffset, false).compare("255") == 0) {
        // "FF" means Invalid umts_rrc_state
        mResult.append("umts_rrc_state:\n");
        mOffset += 2;
    } else {
        parseElement(TYPE_UINT8, "umts_rrc_state: ");
    }

    if (getValueFrom2Byte(mRawString, mOffset, false).compare("65535") == 0) {
        // "FFFF" means Invalid uarfcn_DL
        mResult.append("uarfcn_DL:\n");
        mOffset += 4;
    } else {
        parseElement(TYPE_UINT16, "uarfcn_DL: ");
    }

    if (getValueFrom2Byte(mRawString, mOffset, false).compare("65535") == 0) {
        // "FFFF" means Invalid psc
        mResult.append("psc:\n");
        mOffset += 4;
    } else {
        parseElement(TYPE_UINT16, "psc: ");
    }
    return mResult;
}

std::string NetworkInfoUrcParser::getSlceVoiceInfo() {
    if (IS_MOLY) {
        parseElement(TYPE_UINT8, "ULAMRType: ");
        parseElement(TYPE_UINT8, "DLAMRType: ");
    } else {
        parseElement(TYPE_UINT8, "voice: ");
    }
    return mResult;
}


std::string NetworkInfoUrcParser::getSecurityConfigInfo() {
    parseElement(TYPE_UINT8, "Ciphering Algorithm: ");
    parseElement(TYPE_UINT8, "Integrity Algorithm: ");
    return mResult;
}

std::string NetworkInfoUrcParser::get3GMmEmInfo() {
    parseElement(TYPE_UINT8, "t3212: ");
    parseElement(TYPE_UINT8, "ATT_flag: ");
    parseElement(TYPE_UINT8, "MM_reject_cause: ");
    parseElement(TYPE_UINT8, "MM_state: ");
    parseElement(TYPE_UINT8, "MCC:", 3);
    parseElement(TYPE_UINT8, "MNC:", 3);
    parseElement(TYPE_UINT8, "LOC:", 2);
    parseElement(TYPE_UINT8, "rac: ");
    parseElement(TYPE_UINT8, "TMSI:", 4);
    parseElement(TYPE_UINT8, "is_t3212_running:");
    parseElement(TYPE_UINT16, "t3212_timer_value:");
    parseElement(TYPE_UINT16, "t3212_passed_time:");
    parseElement(TYPE_UINT8, "common_access_class: ");
    parseElement(TYPE_UINT8, "cs_access_class: ");
    parseElement(TYPE_UINT8, "ps_access_class: ");
    mOffset += DATA_OFFSET_8;
    return mResult;
}

std::string NetworkInfoUrcParser::getSmEmInfo() {
    parseElement(TYPE_UINT8, "num_of_active_pdp_context: ");
    parseElement(TYPE_ALIGNMENT, "");
    for (int i = 0; i < 11; i++) {
        mResult.append("--------------------\n");
        mResult.append(std::string("pdp[") + std::to_string(i) + std::string("]:\n"));
        parseElement(TYPE_UINT8, "pdp_index: ");
        parseElement(TYPE_UINT8, "nsapi: ");
        if (IS_MOLY) {
            parseElement(TYPE_UINT8, "ti_value: ");
        }
        parseElement(TYPE_UINT8, "pdp_context_status: ");
        if (IS_MOLY) {
            parseElement(TYPE_UINT8, "context_type: ");
            parseElement(TYPE_UINT8, "initiated_by: ");
            parseElement(TYPE_UINT8, "pdp_addr_type: ");
        }
        parseElement(TYPE_UINT8, "ip:", 16);
        parseElement(TYPE_UINT16, "sdu_size:");
        parseElement(TYPE_STRING, "apn: ", 100);
        parseElement(TYPE_UINT8, "sm_cause: ");
        if (IS_MOLY) {
            mOffset += 249 * 2;
        } else {
            mOffset += 77 * 2; // Skip the rest 77 bytes
        }
    }
    return mResult;
}

std::string NetworkInfoUrcParser::getGmmEmInfo() {
    parseElement(TYPE_UINT16, "ready_timer: ");
    parseElement(TYPE_UINT16, "rau_timer: ");
    parseElement(TYPE_UINT8, "ms_state: ");
    parseElement(TYPE_INT8, "is_rau_timer_running: ");
    parseElement(TYPE_UINT16, "rau_timer_passed_time: ");
    parseElement(TYPE_UINT8, "attach_req_mobile_identity: ");
    if (WISDOM_EM && ADVANCED_EM) {
        parseElement(TYPE_UINT8, "ptmsi: ", 4);
        parseElement(TYPE_UINT8, "attach_rej_cause: ");
        parseElement(TYPE_UINT8, "rau_rej_cause: ");
        parseElement(TYPE_UINT8, "gprs_update_status: ");
        parseElement(TYPE_UINT8, "cipher_algo: ");
        parseElement(TYPE_UINT8, "attach_type: ");
        parseElement(TYPE_UINT8, "gmm_state: ");
        parseElement(TYPE_UINT8, "gprs_attach_status: ");
    }
    return mResult;
}

std::string NetworkInfoUrcParser::get3GTcmMmiEmInfo() {
    parseElement(TYPE_UINT8, "num_of_valid_entries: ");
    for (int i = 0; i < 3; i++) {
        parseElement(TYPE_UINT8, std::string("nsapi") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT8, std::string("data_speed_value") + std::to_string(i) + std::string(":"));
    }
    return mResult;
}

std::string NetworkInfoUrcParser::get3GCsceEmInfoMultiPlmn() {
    parseElement(TYPE_UINT8, "multi_plmn_count: ");
    for (int i = 0; i < 6; i++) {
        parseElement(TYPE_UINT8, std::string("mcc1_") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT8, std::string("mcc2_") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT8, std::string("mcc3_") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT8, std::string("mnc1_") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT8, std::string("mnc2_") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT8, std::string("mnc3_") + std::to_string(i) + std::string(":"));
    }
    return mResult;
}

std::string NetworkInfoUrcParser::get3GMemeEmInfoUmtsCellStatus() {
    parseElement(TYPE_INT8, "tx_power: ");
    parseElement(TYPE_UINT8, "num_cells: ");
    parseElement(TYPE_ALIGNMENT, "");
    for (int i = 0; i < 32; i++) {
        mResult.append("--------------------\n");
        mResult.append(std::string("umts_cell_list[") + std::to_string(i) + std::string("]:\n"));
        parseElement(TYPE_UINT16, "UARFCN: ");
        parseElement(TYPE_UINT16, "PSC: ");
        parseElement(TYPE_INT32, "RSCP: ");
        parseElement(TYPE_INT32, "ECNO: ");
        parseElement(TYPE_UINT8, "cell_type: ");
        parseElement(TYPE_UINT8, "Band: ");
        parseElement(TYPE_INT32, "RSSI: ");
        parseElement(TYPE_UINT32, "Cell_identity: ");

        int validity = readIntegerFromByte();
        int lacValid = validity & 0x01;
        int racValid = validity & 0x02;
        int uraValid = validity & 0x04;

        parseElement(TYPE_UINT8, "num_plmn_id: ");
        for (int j = 0; j < 6; j++) {
            parseElement(TYPE_UINT16, std::string("plmn_id_list[") + std::to_string(j) + std::string("].mcc: "));
            parseElement(TYPE_UINT16, std::string("plmn_id_list[") + std::to_string(j) + std::string("].mnc: "));
        }

        if (lacValid != 0) {
            parseElement(TYPE_UINT16, "lac: ");
        } else {
            mResult.append("lac: invalid\n");
            mOffset += DATA_OFFSET_4;
        }

        if (racValid != 0) {
            parseElement(TYPE_UINT8, "rac: ");
        } else {
            mResult.append("rac: invalid\n");
            mOffset += DATA_OFFSET_2;
        }

        if (uraValid != 0) {
            parseElement(TYPE_UINT8, "num_ura_id: ");
            for (int j = 0; j < 8; j++) {
                int numBits = readIntegerFromByte();
                if (numBits == 1) {
                    parseElement(TYPE_UINT8, std::string("uraIdentity[") + std::to_string(j) + std::string("]: "));
                    mOffset += DATA_OFFSET_2; // skip high byte
                } else {
                    parseElement(TYPE_UINT8, std::string("uraIdentity[") + std::to_string(j) + std::string("]: "), 2);
                }
            }
            mOffset += DATA_OFFSET_4;
        } else {
            mResult.append("ura: invalid\n");
            mOffset += 27 * 2;
        }
    }
    return mResult;
}

std::string NetworkInfoUrcParser::get3GMemeEmPeriodicBlerReportInd() {
    parseElement(TYPE_UINT8, "num_trch: ");
    for (int i = 0; i < 8; i++) {
        parseElement(TYPE_ALIGNMENT, "");
        parseElement(TYPE_UINT8, std::string("TrCHId") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT32, std::string("TotalCRC") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT32, std::string("BadCRC") + std::to_string(i) + std::string(":"));
    }
    return mResult;
}


std::string NetworkInfoUrcParser::get3GUrrUmtsSrncId() {
    parseElement(TYPE_UINT16, "srnc: ");
    return mResult;
}

std::string NetworkInfoUrcParser::get3GSlceEmPsDataRateStatusInd() {
    parseElement(TYPE_UINT8, "ps_number: ");
    parseElement(TYPE_ALIGNMENT, "");
    for (int i = 0; i < 8; i++) {
        parseElement(TYPE_UINT8, std::string("RAB_ID") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_INT8, std::string("RB_UD") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT32, std::string("DL_rate") + std::to_string(i) + std::string(":"));
        parseElement(TYPE_UINT32, std::string("UL_rate") + std::to_string(i) + std::string(":"));
    }
    return mResult;
}

std::string NetworkInfoUrcParser::get3GMemeEmInfoHServCellInd() {
    parseElement(TYPE_UINT16, "HSDSCH_Serving_UARFCN: ");
    parseElement(TYPE_UINT16, "HSDSCH_Serving_PSC: ");
    parseElement(TYPE_UINT16, "EDCH_Serving_UARFCN: ");
    parseElement(TYPE_UINT16, "EDCH_Serving_PSC: ");
    return mResult;
}

std::string NetworkInfoUrcParser::get3GHandoverSequenceIndStuct() {
    parseElement(TYPE_UINT8, "service_status: ");
    parseElement(TYPE_ALIGNMENT, "");
    parseElement(TYPE_UINT16, "[old_cell_info:-----]\nprimary_uarfcn_DL: ");
    parseElement(TYPE_UINT16, "working_uarfcn: ");
    parseElement(TYPE_UINT16, "physicalCellId: ");
    parseElement(TYPE_UINT16, "[target_cell_info:-----]\nprimary_uarfcn_DL: ");
    parseElement(TYPE_UINT16, "working_uarfcn: ");
    parseElement(TYPE_UINT16, "physicalCellId: ");
    return mResult;
}

std::string NetworkInfoUrcParser::getCtrlchanInfo() {
    parseElement(TYPE_UINT8, "mscr: ");
    parseElement(TYPE_UINT8, "att: ");
    parseElement(TYPE_UINT8, "bs_ag_blks_res: ");
    parseElement(TYPE_UINT8, "ccch_conf: ");
    parseElement(TYPE_UINT8, "cbq2: ");
    parseElement(TYPE_UINT8, "bs_pa_mfrms: ");
    parseElement(TYPE_UINT8, "t3212: ");
    return mResult;
}

std::string NetworkInfoUrcParser::parseInfo(int type, std::string info, int simType) {
    RLOGD("NetworkInfo ------ Type is: %d, simtype: %d",type, simType);
    RLOGD("NetworkInfo ------ Data is:\n");
    RLOGD("%s\n",info.c_str());
    RLOGD("NetworkInfo ---------------------------");
    mRawString = info;
    mResult = "";
    mOffset = 0;

    switch (type) {
    case Content::CELL_INDEX:
        return getCellSelInfo();
    case Content::CHANNEL_INDEX:
        return getChDscrInfo();
    case Content::CTRL_INDEX:
        return getCtrlchanInfo();
    case Content::RACH_INDEX:
        return getRACHCtrlInfo();
    case Content::LAI_INDEX:
        return getLAIInfo();
    case Content::RADIO_INDEX:
        return getRadioLinkInfo();
    case Content::MEAS_INDEX:
        return getMeasRepInfo();
    case Content::CA_INDEX:
        return getCaListInfo();
    case Content::CONTROL_INDEX:
        return getControlMsgInfo();
    case Content::SI2Q_INDEX:
        return getSI2QInfo();
    case Content::MI_INDEX:
        return getMIInfo();
    case Content::BLK_INDEX:
        return getBLKInfo();
    case Content::TBF_INDEX:
        return getTBFInfo();
    case Content::GPRS_INDEX:
        return getGPRSGenInfo();
    case Content::URR_3G_GENERAL_INDEX:
        return get3GGeneralInfo();
    case Content::GMM_INFO_INDEX:
        return getGmmEmInfo();
    default:
        break;
    }

    if (type == Content::SM_INFO_INDEX) {
        return getSmEmInfo();
    } else if (type == Content::SLCE_VOICE_INDEX) {
        return getSlceVoiceInfo();
    } else if (type == Content::SECURITY_CONFIGURATION_INDEX) {
        return getSecurityConfigInfo();
    } else if (type == Content::MM_INFO_INDEX) {
        return get3GMmEmInfo();
    } else if (type == Content::TCM_MMI_INDEX) {
        return get3GTcmMmiEmInfo();
    } else if (type == Content::CSCE_MULTIPLMN_INDEX) {
        return get3GCsceEmInfoMultiPlmn();
    } else if (type == Content::PERIOD_IC_BLER_REPORT_INDEX) {
        return get3GMemeEmPeriodicBlerReportInd();
    } else if (type == Content::URR_UMTS_SRNC_INDEX) {
        return get3GUrrUmtsSrncId();
    } else if (type == Content::HSERV_CELL_INDEX) {
        return get3GMemeEmInfoHServCellInd();
    } else if (type == Content::CSCE_NEIGH_CELL_STATUS_INDEX) {
        return getxGCsceEMNeighCellSStatusIndStructSize(
                ModemCategory::getModemType() == MODEM_TD);
    } else if (type == Content::CSCE_SERV_CELL_STATUS_INDEX) {
        return get3GCsceEMServCellSStatusInd(
                ModemCategory::getModemType() == MODEM_TD);
    }

    if (ModemCategory::getModemType() == MODEM_FDD) {
        if (type == Content::UMTS_CELL_STATUS_INDEX) {
            return get3GMemeEmInfoUmtsCellStatus();
        } else if (type == Content::PSDATA_RATE_STATUS_INDEX) {
            return get3GSlceEmPsDataRateStatusInd();
        }
    } else if (ModemCategory::getModemType() == MODEM_TD) {
        if (type == Content::HANDOVER_SEQUENCE_INDEX) {
            return get3GHandoverSequenceIndStuct();
        } else if (type == Content::UL_ADM_POOL_STATUS_INDEX) {
            return get3GUl2EmAdmPoolStatusIndStruct();
        } else if (type == Content::UL_PSDATA_RATE_STATUS_INDEX) {
            return get3GUl2EmPsDataRateStatusIndStruct();
        } else if (type == Content::UL_HSDSCH_RECONFIG_STATUS_INDEX) {
            return get3Gul2EmHsdschReconfigStatusIndStruct();
        } else if (type == Content::UL_URLC_EVENT_STATUS_INDEX) {
            return get3GUl2EmUrlcEventStatusIndStruct();
        } else if (type == Content::UL_PERIOD_IC_BLER_REPORT_INDEX) {
            return get3GUl2EmPeriodicBlerReportInd();
        }
    }

    return "";
}

int NetworkInfoUrcParser::readIntegerFromByte() {
    if (mRawString.length() < mOffset + 2) {
        mOffset += 2;
        return 0;
    }
    std::string str = mRawString.substr(mOffset, mOffset + 2);
    mOffset += 2;
    int ret = 0;
    try {
        ret = std::stoi(str,0, 16);
    } catch (const std::out_of_range &e) {
        RLOGD("out of range: %s, line: %s", e.what(), __LINE__);
        ret = 0;
    } catch (const std::invalid_argument &e) {
        RLOGD("invalid argument: %s, line: %s", e.what(), __LINE__);
        ret = 0;
    }
    return ret;
}

int NetworkInfoUrcParser::readIntegerFrom2Byte() {
    if (mRawString.length() < mOffset + DATA_OFFSET_4) {
        mOffset += 4;
        return 0;
    }
    try {
        std::string low = mRawString.substr(mOffset, mOffset + DATA_OFFSET_2);
        std::string high = mRawString.substr(mOffset + DATA_OFFSET_2, mOffset + DATA_OFFSET_4);
        std::string reverse = high + low;
        mOffset += 4;
        int i = std::stoi(reverse,0, DATA_FORMAT);
        int16_t s = (int16_t) i;
        return s;
    } catch (const std::out_of_range &e) {
        RLOGD("out of range: %s, line: %s", e.what(), __LINE__);
        return 0;
    } catch (const std::invalid_argument &e) {
        RLOGD("invalid argument: %s, line: %s", e.what(), __LINE__);
        return 0;
    }
}

std::string NetworkInfoUrcParser::decodeMcc(int value){
    value += 111;
    if (value % 10 == 0) {
        value -= 10;
    }
    if ((value / 10) % 10 == 0) {
        value -= 100;
    }
    if ((value / 100) % 10 == 0) {
        value -= 1000;
    }
    return (std::string("000") + std::to_string(value)).substr(std::to_string(value).length());
}

std::string NetworkInfoUrcParser::decodeMnc(int value){
    value += 11;
    if (value % 10 == 0) {
        value -= 10;
    }
    if ((value / 10) % 10 == 0) {
        value -= 100;
    }
    return (std::string("00") + std::to_string(value)).substr(std::to_string(value).length());
}

std::vector<std::string> NetworkInfoUrcParser::parseSecurityStatus(int type, std::string info) {
    std::vector<std::string> m2gCipher {"No Ciphering", "A5/1", "A5/2", "A5/3", "A5/4", "A5/5", "A5/6", "A5/7"};
    std::vector<std::string> m2gGprs {"No Ciphering", "GEA1", "GEA2", "GEA3"};
    std::vector<std::string> m3gCipher {"No Ciphering", "UEA0", "UEA1", "", "UEA2"};
    std::vector<std::string> m3gIntegrity {"No Integrity", "UIA1", "UIA2"};
    std::vector<std::string> m4gEnasCipher {"EEA0(NULL)", "EEA1(SNOW3G)", "EEA2(AES)", "EEA3(ZUC)"};
    std::vector<std::string> m4gEnasIntegrity {"EIA0(NULL)", "EIA1(SNOW3G)", "EIA2(AES)", "EIA3(ZUC)"};
    std::vector<std::string> m4gErrcCipher{"EEA0(NULL)", "EEA1(SNOW3G)", "EEA2(AES)", "EEA3(ZUC)"};
    std::vector<std::string> m4gErrcIntegrity {"EIA0(NULL)", "EIA1(SNOW3G)", "EIA2(AES)", "EIA3(ZUC)"};

    std::vector<std::string> ret {"---", "---"};
    if (info.empty()) {
        return ret;
    }
    RLOGD("NetworkInfo ------ Type is: %d", type);
    RLOGD("NetworkInfo ------ Data is:\n");
    RLOGD("%s\n", info.c_str());
    RLOGD("NetworkInfo ---------------------------");
    mRawString = info;
    mResult.clear();
    mOffset = 0;
    int cipherAlgo;
    int integrityAlgo;

    if (type == Content::CHANNEL_INDEX) {
        mOffset += 140 * 2;
        cipherAlgo = readIntegerFromByte();
        if (cipherAlgo >= 0 && cipherAlgo < m2gCipher.size()) {
            ret[0] = m2gCipher[cipherAlgo];
        }
    } else if (type == Content::LLC_EM_INFO_INDEX) {
        mOffset += 32 * 2;
        cipherAlgo = readIntegerFromByte();
        if (cipherAlgo >= 0 && cipherAlgo < m2gGprs.size()) {
            ret[0] = m2gGprs[cipherAlgo];
        }
    } else if (type == Content::SECURITY_CONFIGURATION_INDEX) {
        cipherAlgo = readIntegerFromByte();
        integrityAlgo = readIntegerFromByte();
        if (cipherAlgo >= 0 && cipherAlgo < m3gCipher.size()) {
            ret[0] = m3gCipher[cipherAlgo];
        }
        if (integrityAlgo >= 0 && integrityAlgo < m3gIntegrity.size()) {
            ret[1] = m3gIntegrity[integrityAlgo];
        }
    } else if (type == Content::ERRC_EM_SEC_PARAM_INDEX) {
        mOffset += 2 * 2;
        integrityAlgo = readIntegerFromByte();
        cipherAlgo = readIntegerFromByte();
        if (cipherAlgo >= 0 && cipherAlgo < m4gErrcCipher.size()) {
            ret[0] = m4gErrcCipher[cipherAlgo];
        } else if (cipherAlgo == 0xFF) {
            ret[0] = "N/A";
        }
        if (integrityAlgo >= 0 && integrityAlgo < m4gErrcIntegrity.size()) {
            ret[1] = m4gErrcIntegrity[integrityAlgo];
        } else if (integrityAlgo == 0xFF) {
            ret[1] = "N/A";
        }
    } else if (type == Content::EMM_L4C_EMM_INFO_INDEX) {
        mOffset += 89 * 2;
        integrityAlgo = readIntegerFromByte();
        cipherAlgo = readIntegerFromByte();
        if (cipherAlgo >= 0 && cipherAlgo < m4gEnasCipher.size()) {
            ret[0] = m4gEnasCipher[cipherAlgo];
        } else if (cipherAlgo == 0xFF) {
            ret[0] = "N/A";
        }
        if (integrityAlgo >= 0 && integrityAlgo < m4gEnasIntegrity.size()) {
            ret[1] = m4gEnasIntegrity[integrityAlgo];
        } else if (integrityAlgo == 0xFF) {
            ret[1] = "N/A";
        }
    } else if (type == Content::ERRC_EM_ERRC_STATE_INDEX) {
        ret[0] = getValueFromByte(mRawString, mOffset, false);
    }
    return ret;
}

std::vector<std::string> NetworkInfoUrcParser::parseAntennaDiversity(int type, std::string info) {
    std::vector<std::string> ret;
    if (info.empty()) {
        return ret;
    }
    RLOGD("NetworkInfo ------ Type is: %d", type);
    RLOGD("NetworkInfo ------ Data is:\n");
    RLOGD("%s\n",info.c_str());
    RLOGD("NetworkInfo ---------------------------");
    mRawString = info;
    mResult.clear();
    mOffset = 0;

    switch (type) {
    case Content::EL1TX_EM_TX_INFO_INDEX:
    {
        int band = readIntegerFromByte();
        if (band == 0) {
            return ret;
        }
        mOffset += 15 * 2;
        int rsrp0 = readIntegerFrom2Byte();
        int rsrp1 = readIntegerFrom2Byte();
        int rssi0 = readIntegerFrom2Byte();
        int rssi1 = readIntegerFrom2Byte();
        int snr0 = readIntegerFrom2Byte();
        int snr1 = readIntegerFrom2Byte();
        int rsrp = readIntegerFrom2Byte();
        int rsrq = readIntegerFrom2Byte();
        int snr = readIntegerFrom2Byte();
        ret = {std::to_string(rsrp0), std::to_string(rsrq), std::to_string(rssi0),
                std::to_string(snr0), std::to_string(rsrp1), std::to_string(rsrq),
                std::to_string(rssi1), std::to_string(snr1), std::to_string(rsrp),
                std::to_string(rsrq), std::to_string(rssi0 > rssi1 ? rssi0 : rssi1),
                std::to_string(snr)};
        break;
    }
    case Content::UL1_EM_PRX_DRX_MEASURE_INFO_INDEX:
    {
        int rscp0 = readIntegerFrom2Byte();
        int rscp1 = readIntegerFrom2Byte();
        int pssi0 = readIntegerFrom2Byte();
        int pssi1 = readIntegerFrom2Byte();
        ret = {std::to_string(rscp0), std::to_string(pssi0),
                std::to_string(rscp1), std::to_string(pssi1),
                std::to_string(rscp0 > rscp1 ? rscp0 : rscp1),
                std::to_string(pssi0 > pssi1 ? pssi0 : pssi1)};
        break;
    }
    default:
        break;
    }
    return ret;
}

std::vector<std::vector<std::string>> NetworkInfoUrcParser::parseCdmaInfo(int type, std::string info) {
    RLOGD("NetworkInfo ------ Type is: %d", type);
    RLOGD("NetworkInfo ------ Data is:\n");
    RLOGD("%s\n", info.c_str());
    RLOGD("NetworkInfo ---------------------------");
    mRawString = info;
    utils::tokenize(info,',',mRawValues);
    mOffset = 1;
    mType = type;

    switch (type) {
    case Content::CDMA_1XRTT_RADIO_INDEX:
        mLabels = {"Channel",
        "bandClass",
        "pilotPN",
        "rxPower_main(dbm)",
        "rxPower_div(dbm)",
        "txPower",
        "tx_Ant",
        "FER"};
        break;
    case Content::CDMA_1XRTT_INFO_INDEX:
        mLabels = {"cpState",
        "Calibration",
        "RfFileMajorVersion",
        "RfFileMinorVersion",
        "RfFileValueVersion",
        "RfFileCustVersion",
        "sid",
        "nid",
        "sysDetIndication",
        "regZone",
        "baseLat",
        "baseLong",
        "networkPrefSCI",
        "qpchMode",
        "mcc",
        "imsi_11_12",
        "currentPacketZoneID",
        "serviceOption",
        "T_ADD",
        "T_DROP",
        "T_COMP",
        "T_tDROP"};
        break;
    case Content::CDMA_1XRTT_SCH_INFO_INDEX:
        mLabels = {"ForSchMux",
        "ForSchRc",
        "ForSchStatus",
        "ForSchDuration(20ms)",
        "ForSchRate",
        "RevSchMux",
        "RevSchRc",
        "RevSchStatus",
        "RevSchDuration(20ms)",
        "RevSchRate"};
        break;
    case Content::CDMA_1XRTT_STATISTICS_INDEX:
        mLabels = {"total_msg",
        "error_msg",
        "acc_1",
        "acc_2",
        "acc_8",
        "dpchloss_count",
        "dtchloss_count",
        "idelHO_count",
        "hardHO_count",
        "interFreqIdleHO_count",
        "silentRetryTimeout_count",
        "T40_count",
        "T41_count"};
        break;
    case Content::CDMA_1XRTT_SERVING_INDEX:
        mLabels = {"pilotPN",
        "pilotEcIo",
        "pilotPhase"};
        break;
    case Content::CDMA_EVDO_SERVING_INFO_INDEX:
        mLabels = {"Band",
        "Channel",
        "PilotPN",
        "PhySubtype",
        "RSSI_main(dbm)",
        "RSSI_div(dbm)",
        "tx_Ant",
        "SectorID",
        "SubnetMask",
        "ColorCode",
        "UATI",
        "PilotInc",
        "ActiveSetWindow",
        "NeighborSetWindow",
        "RemainSetWindow",
        "PilotAdd",
        "PilotDrop",
        "PilotDropTimer"};
        break;
    case Content::CDMA_EVDO_ACTIVE_SET_INDEX:
        mLabels = {"PilotPN",
        "PilotEcIo",
        "DRC Cover"};
        break;
    case Content::CDMA_EVDO_CANDICATE_SET_INDEX:
        mLabels = {"band",
        "channel",
        "pilotPN",
        "pilotEcIo"};
        break;
    case Content::CDMA_EVDO_NEIGHBOR_SET_INDEX:
        mLabels = {"band",
        "channel",
        "pilotPN",
        "pilotEcIo"};
        break;
    case Content::CDMA_EVDO_FL_INDEX:
        mLabels = {"C/I",
        "DRC average value",
        "FTC crc error count",
        "FTC total count",
        "Sync crc error ratio"};
        break;
    case Content::CDMA_EVDO_RL_INDEX:
        mLabels = {"Average tbsize",
        "RTC retransmit count",
        "RTC transmit total count",
        "TX power",
        "pilot power",
        "RAB=1 ratio"};
        break;
    case Content::CDMA_EVDO_STATE_INDEX:
        mLabels = {"Session State",
        "AT State",
        "ALMP State",
        "Init State",
        "Idle State",
        "Overhead State",
        "Connected State",
        "Route Update State"};
        break;
    default:
        break;
    }

    switch (type) {
    case Content::CDMA_1XRTT_SERVING_INDEX:
        return parse1xRttServing();
    case Content::CDMA_EVDO_ACTIVE_SET_INDEX:
    case Content::CDMA_EVDO_CANDICATE_SET_INDEX:
    case Content::CDMA_EVDO_NEIGHBOR_SET_INDEX:
        return parseCellInfo();
    default:
        return parseCommonCdmaInfo();
    }
}

std::vector<std::vector<std::string>> NetworkInfoUrcParser::parseCommonCdmaInfo() {
    std::vector<std::vector<std::string>> ret;
    for (int i = 0; i < mLabels.size(); i++) {
        ret.push_back(std::vector<std::string> {mLabels[i], nextValue()});
    }
    return ret;
}

std::vector<std::vector<std::string>> NetworkInfoUrcParser::parseCellInfo() {
    std::vector<std::vector<std::string>> ret;
    ret.push_back(mLabels);
    int columns = mLabels.size();
    int rows = 0;
    mColumn = -1;
    try {
        rows = std::stoi(nextValue());
    } catch (const std::out_of_range &e) {
        RLOGD("out of range: %s, line: %s", e.what(), __LINE__);
        return ret;;
    } catch (const std::invalid_argument &e) {
        RLOGD("invalid argument: %s, line: %s", e.what(), __LINE__);
        return ret;
    }
    for (int i = 0; i < rows; i++) {
        std::vector<std::string> entry;
        for (int j = 0; j < columns; j++) {
            mColumn = j;
            entry.push_back(nextValue());
        }
        ret.push_back(entry);
    }
    return ret;
}

std::vector<std::vector<std::string>> NetworkInfoUrcParser::parse1xRttServing() {
    std::vector<std::vector<std::string>> ret;
    ret.push_back(std::vector<std::string> {"Active Set"});
    std::vector<std::vector<std::string>> active = parseCellInfo();
    ret.insert(ret.end(), active.begin(), active.end());;
    ret.push_back(std::vector<std::string> {"Candicate Set"});
    std::vector<std::vector<std::string>> candicate = parseCellInfo();
    ret.insert(ret.end(), candicate.begin(), candicate.end());;
    ret.push_back(std::vector<std::string> {"Neighbor Set"});
    std::vector<std::vector<std::string>> neighbor = parseCellInfo();
    ret.insert(ret.end(), neighbor.begin(), neighbor.end());;
    return ret;
}

std::string NetworkInfoUrcParser::nextValue() {
    int index = mOffset;
    mOffset++;
    if (mRawValues.empty() || mRawValues.size() <= index) {
        return "";
    }

    std::string rawValue = mRawValues[index];
    int value = 0;
    try {
        value = std::stoi(rawValue);
    } catch (const std::out_of_range &e) {
        RLOGD("out of range: %s, line: %s", e.what(), __LINE__);
        return rawValue;
    } catch (const std::invalid_argument &e) {
        RLOGD("invalid argument: %s, line: %s", e.what(), __LINE__);
        return rawValue;
    }

    std::vector<std::string> array;
    switch (mType) {
        case Content::CDMA_1XRTT_INFO_INDEX:
        switch (index) {
        case 1:
            array = {"CP_DISABLED", "CP_SYS_DETERMINATION", "CP_PILOT_ACQUISITION",
                    "CP_SYNC_ACQUISITION", "CP_TIMING_CHANGE", "CP_IDLE", "CP_UPDATE_OHD_INFO",
                    "CP_PAGE_RESPONSE", "CP_ORD_MSG_RESP", "CP_ORIGINATION",
                    "CP_REGISTRATION", "CP_MSG_TRANSMISSION", "CP_TC_INIT",
                    "CP_TC_WAIT_ORDER", "CP_TC_WAIT_ANSWER", "CP_TC_CONVERSATION",
                    "CP_TC_RELEASE", "CP_NST", "CP_FROZEN",
                    "CP_TC_FROZEN"};
            break;
        case 2:
            array = {"TRUE", "FALSE", "Unknown"};
            break;
        case 14:
            array = {"FALSE", "TRUE"};
            break;
        case 15:
            return decodeMcc(value);
        case 16:
            return decodeMnc(value);
        case 19:
        case 20:
            return utils::format("%.1f", (float) value / -2);
        case 22:
            return std::to_string(value / 10);
        default:
            break;
        }
        break;
    case Content::CDMA_1XRTT_SCH_INFO_INDEX:
        switch (index) {
        case 1: // for_sch_mux
        case 6: // rev_sch_mux
            return utils::format("0x%x", value);
        case 4: // ForSchDuration
        case 9: // RevSchDuration
            if (value == 15) {
                return "Infinite";
            }
            break;
        default:
            break;
        }
        break;
    case Content::CDMA_1XRTT_SERVING_INDEX:
        if (mColumn == 1) {
            return utils::format("%.1f", (float) value / -2);
        }
        break;
    case Content::CDMA_EVDO_SERVING_INFO_INDEX:
        switch (index) {
        case 5: // rssi
        case 6:
            return utils::format("%.2f", (float) value / 128);
        case 15: // t_add
        case 16: // t_drop
            return utils::format("%.1f", (float) value / -2);
        default:
            break;
        }
        break;
    case Content::CDMA_EVDO_ACTIVE_SET_INDEX:
        if (mColumn == 1) {
            return utils::format("%.2f", (float) value / 8);
        }
        break;
    case Content::CDMA_EVDO_CANDICATE_SET_INDEX:
    case Content::CDMA_EVDO_NEIGHBOR_SET_INDEX:
        if (mColumn == 3) {
            return utils::format("%.2f", (float) value / 8);
        }
        break;
    case Content::CDMA_EVDO_FL_INDEX:
        switch (index) {
        case 1:
            return utils::format("%.2f", (float) value / 64);
        default:
            break;
        }
        break;
    case Content::CDMA_EVDO_RL_INDEX:
        switch (index) {
        case 4:
        case 5:
            return utils::format("%.2f", (float) value / 128);
        default:
            break;
        }
        break;
    case Content::CDMA_EVDO_STATE_INDEX:
        switch (index) {
        case 1:
            array = {"NEW_SESSION", "ALIVE_SESSION", "PRIOR_SESSION",
                    "OPENED_SESSION"};
            break;
        case 2:
            array = {"AT_PWROFF", "AT_INACTIVE", "AT_PILOTACQ", "AT_SYNC",
                    "AT_IDLE", "AT_ACCESS", "AT_CONNECTED"};
            break;
        case 3:
            array = {"ALMP_INIT_STATE", "ALMP_IDLE_STATE", "ALMP_CONN_SETUP_STATE",
                    "ALMP_CONNECTED_STATE"};
            break;
        case 4:
            array = {"INSP_INACTIVE_STATE", "INSP_NETWORK_DET_STATE",
                    "INSP_PILOT_ACQ_STATE", "INSP_SYNC_STATE", "INSP_TIMING_CHANGE_STATE",
                    "INSP_WFR_1XASSTST_STATE"};
            break;
        case 5:
            array = {"IDP_INACTIVE_ST", "IDP_MONITOR_ST", "IDP_SLEEP_ST",
                    "IDP_CONN_SETUP_ST", "IDP_FREEZE_PENDING_ST", "IDP_FREEZE_ST",
                    "IDP_CONN_FROZEN_ST", "IDP_STATE_MAX"};
            break;
        case 6:
            array = {"OMP_INACTIVE_ST", "OMP_ACTIVE_ST", "OMP_STATE_MAX"};
            break;
        case 7:
            array = {"CSP_INACTIVE_STATE", "CSP_CLOSING_STATE", "CSP_OPEN_STATE"};
            break;
        case 8:
            array = {"RUP_INACTIVE", "RUP_IDLE", "RUP_CONNECTED",
                    "RUP_IRAT_MEASUREMENT", "RUP_INVALID"};
            break;
        default:
            break;
        }
        break;
    default:
        break;
    }

    if ((!array.empty()) && (value >= 0) && (value < array.size())) {
        return array[value];
    }
    return rawValue;
}
