/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include "rfdesense/RfDesenseTxTestLte.h"

#include <algorithm>
#include <iterator>
#include <stdexcept>

#include "rfdesense/RfDesenseTxTestBase.h"
#include "util/log_extra.h"
#include "em.h"

#undef LOG_TAG
#define LOG_TAG "EM_RfDesenseTxTestLte"

const int RfDesenseTxTestLte::INDEX_BAND = 0;
const int RfDesenseTxTestLte::INDEX_BAND_WIDTH = 1;
const int RfDesenseTxTestLte::INDEX_FREQ = 2;
const int RfDesenseTxTestLte::INDEX_VRB_START = 3;
const int RfDesenseTxTestLte::INDEX_VRB_LENGTH = 4;
const int RfDesenseTxTestLte::INDEX_MCS = 5;
const int RfDesenseTxTestLte::INDEX_POWER = 6;
const int RfDesenseTxTestLte::INDEX_MODE = 7;
const int RfDesenseTxTestLte::INDEX_TDD_CONFIG = 8;
const int RfDesenseTxTestLte::INDEX_TDD_SPECIAL = 9;
std::string RfDesenseTxTestLte::band="";
std::string RfDesenseTxTestLte::band_width="";
std::string RfDesenseTxTestLte::freq="";
std::string RfDesenseTxTestLte::tdd_config="";
std::string RfDesenseTxTestLte::tdd_special="";
std::string RfDesenseTxTestLte::vrb_start="";
std::string RfDesenseTxTestLte::vrb_length="";
std::string RfDesenseTxTestLte::mcs="";
std::string RfDesenseTxTestLte::power="";
std::string RfDesenseTxTestLte::mode="";

const std::vector<std::string> RfDesenseTxTestLte::band_fdd = {"1","2","3","4","5","6","7","8","9","10","11","12",
            "13","14","19","20","21","22","23","24","25","26","27","28","29","30","31","66"};
const std::vector<std::string> RfDesenseTxTestLte::band_tdd = {"33","34","35","36","37","38","39","40","41","42","43","44"};
const std::vector<std::vector<std::string>> RfDesenseTxTestLte::fdd_freq_limits = {
            {"19200","19800"},
            {"18500","19100"},
            {"17100","17850"},
            {"17100","17550"},
            {"8240","8490"},
            {"8300","8400"},
            {"25000","25700"},
            {"8800","9150"},
            {"17499","17849"},
            {"17100","17700"},
            {"14279","14479"},
            {"6990","7160"},
            {"7770","7870 "},
            {"7880","7980"},
            {"0","0"},
            {"0","0"},
            {"7040","7160"},
            {"8150","8300"},
            {"8300","8450"},
            {"8320","8620"},
            {"14479","14629"},
            {"34100","34900"},
            {"20000","20200"},
            {"16265","16605"},
            {"18500","19150"},
            {"8140","8490 "},
            {"8070","8240"},
            {"7030","7480"},
            {"0","0"},
            {"23050","23150"},
            {"4525","4575"},
            {"17100","17800"}
    };

const std::vector<std::vector<std::string>> RfDesenseTxTestLte::tdd_freq_limits = {
            {"19000","19200"},
            {"20100","20250"},
            {"18500","19100"},
            {"19300","19900"},
            {"19100","19300"},
            {"25700","26200"},
            {"18800","19200"},
            {"23000","24000"},
            {"24960","26900"},
            {"34000","36000"},
            {"36000","38000"}
    };

std::map<int, std::string> RfDesenseTxTestLte::lte_fdd_values = { { INDEX_BAND,
        "3" }, { INDEX_BAND_WIDTH, "3" }, { INDEX_FREQ, "17475" }, { INDEX_VRB_START, "0" }, {
                INDEX_VRB_LENGTH, "1" }, { INDEX_MCS, "0" }, { INDEX_POWER, "23" }, { INDEX_MODE,
        "1" }, { INDEX_TDD_CONFIG, "0" }, { INDEX_TDD_SPECIAL, "0" }, };
std::map<int, std::string> RfDesenseTxTestLte::lte_tdd_valuse= { { INDEX_BAND,
        "38" }, { INDEX_BAND_WIDTH, "3" }, { INDEX_FREQ, "25950" }, { INDEX_VRB_START, "0" }, {
                INDEX_VRB_LENGTH, "1" }, { INDEX_MCS, "0" }, { INDEX_POWER, "23" }, { INDEX_MODE,
        "1" }, { INDEX_TDD_CONFIG, "0" }, { INDEX_TDD_SPECIAL, "0" }, };

RfDesenseTxTestLte::RfDesenseTxTestLte(int type) {
    modem_type = type;
    std::map<int, std::string> tmp;
    if(modem_type == utils::MODEM_LTE_FDD){
        tmp = lte_fdd_values;
    } else if(modem_type == utils::MODEM_LTE_TDD) {
        tmp = lte_tdd_valuse;
    }
    LOG_D(LOG_TAG, "modem_type: %d", modem_type);
    if(!tmp.empty()) {
        band = tmp[INDEX_BAND];
        band_width = tmp[INDEX_BAND_WIDTH];
        freq = tmp[INDEX_FREQ];
        tdd_config = tmp[INDEX_TDD_CONFIG];
        tdd_special = tmp[INDEX_TDD_SPECIAL];
        vrb_start = tmp[INDEX_VRB_START];
        vrb_length = tmp[INDEX_VRB_LENGTH];
        mcs = tmp[INDEX_MCS];
        power = tmp[INDEX_POWER];
        mode = tmp[INDEX_MODE];
    }

}

void RfDesenseTxTestLte::show_default() {
    std::string str;
    std::string band_width_tmp(rfdesense_lte_bandwidth[std::stoi(band_width)].name);
    std::string mcs_tmp(rfdesense_lte_mcs[std::stoi(mcs)].name);
    std::string duplex;
    if (modem_type == utils::MODEM_LTE_FDD) {
        duplex = "LTE(fdd) ";
    } else if (modem_type == utils::MODEM_LTE_FDD) {
        duplex = "LTE(tdd) ";
    }
    str = duplex + "mode: "
            + (std::stoi(mode) == 0 ?
                    std::string("single tone") :
                    std::string("modulation signal")) + ", Band: " + band
            + ", UL Bandwidth: " + band_width_tmp + ", UL Freq(100kHz): " + freq
            + ", TDD Config index: " + tdd_config
            + ", TDD Special SF Config Index: " + tdd_special
            + ", VRB Start(0~99): " + vrb_start + ", VRB Length(1~100): "
            + vrb_length + ", MCS: " + mcs_tmp + ", Power Level(dBm)(-50-23): "
            + power;
    emResultNotifyWithDone(str);
}

RfDesenseTxTestLte::~RfDesenseTxTestLte() {
    // TODO Auto-generated destructor stub
}
std::string RfDesenseTxTestLte::modemTypeToString(int type) {
    switch(modem_type){
        case utils::MODEM_LTE_FDD:
            return "LTE(FDD)";
        case utils::MODEM_LTE_TDD:
            return "LTE(TDD)";
        default:
            return "UNKNOWN";
    }
}

std::string RfDesenseTxTestLte::get_command() {
    std::string atcmd = "";
    if(utils::is93Modem() && (mode == "0")){
        atcmd = "AT+ERFTX=6,0,2,";
    } else {
        atcmd = "AT+ERFTX=6,0,1,";
    }
    command = band + "," + band_width  + ","
            + freq + ","
            + (modem_type == utils::MODEM_LTE_TDD ? "0" : "1") + ","
#if 0
            + (modem_type == utils::MODEM_LTE_TDD ? tdd_config : "0") + ","
            + (modem_type == utils::MODEM_LTE_TDD ? tdd_special : "0") + ","
#endif
            + tdd_config + ","
            + tdd_special + ","
            + vrb_start + ","
            + vrb_length + ","
            + mcs + ","
            + power;
    LOG_D(LOG_TAG, "modem_type(%) command: %s", modemTypeToString(modem_type), command);
    return command;

}
std::string RfDesenseTxTestLte::get_band() {
    return band;
}
std::string RfDesenseTxTestLte::get_power() {
    return power;
}

bool RfDesenseTxTestLte::check_band(std::string band) {
    std::vector<std::string> band_values;
    if(modem_type == utils::MODEM_LTE_TDD){
        band_values = band_tdd;
    } else if(modem_type == utils::MODEM_LTE_FDD) {
        band_values = band_fdd;
    } else {
        LOG_D(LOG_TAG, "check_band(): modem type (%s) isn't right", modemTypeToString(modem_type));
        return false;
    }

    auto is_band_find = std::find(band_values.begin(), band_values.end(), band); //band
    int band_index = -1;
    if(is_band_find != band_values.end()) {
        band_index = std::distance(band_values.begin(), is_band_find);
        LOG_D(LOG_TAG, "checks: band_index: %d, band: %s", band_index, band.c_str());
    } else {
        LOG_D(LOG_TAG, "band value(%s) isn't invalid", band.c_str());
        return false;
    }
    return true;
}

bool RfDesenseTxTestLte::check_band_width(std::string band_width) {
    int value = -1;
    try {
        value = std::stoi(band_width);
    } catch (std::invalid_argument &err) {
        LOG_D(LOG_TAG, "check_band_width,check_band_width(%s) is invalid, reason: %s", band_width.c_str(), err.what());
        return false;
    }
    if (value < 0 || value > 5) {
        LOG_D(LOG_TAG, "check_band_width value range is [%d, %d], input value is %d", 0, 5, value);
        return false;
    }
    return true;
}

bool RfDesenseTxTestLte::check_freq(std::string freq) {
    return true;
}

bool RfDesenseTxTestLte::check_tdd_config(std::string config) {
    int value = -1;
    try {
        value = std::stoi(config);
    } catch (std::invalid_argument &err) {
        LOG_D(LOG_TAG, "check_tdd_config,check_tdd_config(%s) is invalid, reason: %s", config.c_str(), err.what());
        return false;
    }
    if(modem_type == utils::MODEM_LTE_TDD){
        if(value < 0 || value >6){
            LOG_D(LOG_TAG, "check_tdd_config value range is [%d, %d], input value is %d", 0, 6, value);
            return false;
        }
    } else if(modem_type == utils::MODEM_LTE_FDD) {
        if(value != 0) {
            return false;
        }
    } else {
        LOG_D(LOG_TAG, "check_tdd_config(): modem type (%s) isn't right", modemTypeToString(modem_type));
        return false;
    }
    return true;
}

bool RfDesenseTxTestLte::check_tdd_special(std::string special) {
    int value = -1;
    try {
        value = std::stoi(special);
    } catch (std::invalid_argument &err) {
        LOG_D(LOG_TAG, "check_tdd_special,check_tdd_config(%s) is invalid, reason: %s", special.c_str(), err.what());
        return false;
    }
    if(modem_type == utils::MODEM_LTE_TDD){
        if(value < 0 || value >9){
            LOG_D(LOG_TAG, "check_tdd_special value range is [%d, %d], input value is %d", 0, 9, value);
            return false;
        }
    } else if(modem_type == utils::MODEM_LTE_FDD) {
        if(value != 0) {
            return false;
        }
    } else {
        LOG_D(LOG_TAG, "check_tdd_special(): modem type (%s) isn't right", modemTypeToString(modem_type));
        return false;
    }
    return true;
}

bool RfDesenseTxTestLte::check_vrb_start(std::string start) {
    std::string s;
    int value = -1;
    try {
        value = std::stoi(start);
    } catch (std::invalid_argument &err) {
        s = utils::format("check_vrb_start,check_vrb_start(%s) is invalid, reason: %s", start.c_str(), err.what());
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_vrb_start,check_vrb_start(%s) is invalid, reason: %s", start.c_str(), err.what());
        return false;
    }
    if (value < 0 || value > 99) {
        s = utils::format("check_vrb_start value range is [%d, %d], input value is %d", 0, 9, value);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_vrb_start value range is [%d, %d], input value is %d", 0, 9, value);
        return false;
    }
    return true;
}

bool RfDesenseTxTestLte::check_vrb_length(std::string length) {
    std::string s;
    int value = -1;
    try {
        value = std::stoi(length);
    } catch (std::invalid_argument &err) {
        s = utils::format("check_vrb_length,check_vrb_length(%s) is invalid, reason: %s", length.c_str(), err.what());
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_vrb_length,check_vrb_length(%s) is invalid, reason: %s", length.c_str(), err.what());
        return false;
    }
    if (value < 1  || value > 100) {
        s = utils::format("check_vrb_length value range is [%d, %d], input value is %d", 1, 100, value);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_vrb_length value range is [%d, %d], input value is %d", 1, 100, value);
        return false;
    }
    return true;
}

bool RfDesenseTxTestLte::check_mcs(std::string mcs) {
    int value = -1;
    try {
        value = std::stoi(mcs);
    } catch (std::invalid_argument &err) {
        LOG_D(LOG_TAG, "check_mcs,check_mcs(%s) is invalid, reason: %s", mcs.c_str(), err.what());
        return false;
    }
    if (value < 0 || value > 2) {
        LOG_D(LOG_TAG, "check_mcs value range is [%d, %d], input value is %d", 0, 2, value);
        return false;
    }
    return true;
}

bool RfDesenseTxTestLte::check_power(std::string power) {
    std::string s;
    int value = -1;
    try {
        value = std::stoi(power);
    } catch (std::invalid_argument &err) {
        s = utils::format("check_power,check_power(%s) is invalid, reason: %s", power.c_str(), err.what());
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_power,check_power(%s) is invalid, reason: %s", power.c_str(), err.what());
        return false;
    }
    if (value < -50 || value > 23) {
        s = utils::format("check_power value range is [%d, %d], input value is %d", -50, 23, value);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_power value range is [%d, %d], input value is %d", -50, 23, value);
        return false;
    }
    return true;
}

bool RfDesenseTxTestLte::check_mode(std::string mode) {
    int value = -1;
    try {
        value = std::stoi(mode);
    } catch (std::invalid_argument &err) {
        LOG_D(LOG_TAG, "check_tone,check_tone(%s) is invalid, reason: %s", mode.c_str(), err.what());
        return false;
    }
    if (value == 0 || value == 1) {
        LOG_D(LOG_TAG, "check_mode value range is %d or %d, input value is %d", 0, 1, mode);
        return false;
    }
    return true;
}

bool RfDesenseTxTestLte::set_mode(int value){
    std::string s;
    if(value !=0 && value != 1) {
        s = utils::format("set_mode: value(%d) is out of range", value);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "set_mode: value(%d) is out of range", value);
        return false;
    }
    mode = std::to_string(value);
    if(modem_type == utils::MODEM_LTE_FDD){
        lte_fdd_values[INDEX_MODE] = mode;
    } else if(modem_type == utils::MODEM_LTE_TDD) {
        lte_tdd_valuse[INDEX_MODE] = mode;
    } else {
        em_result_notify_fail("set_mode error");
        LOG_D(LOG_TAG, "set_mode error");
        return false;
    }
    em_result_notify_ok("mode: " + (value == 0 ?
            std::string("single tone") :
            std::string("modulation signal")));
    return true;
}

bool RfDesenseTxTestLte::set_band(int value){
    std::string s;
    std::vector<std::string> band_values;
    if(modem_type == utils::MODEM_LTE_TDD){
        band_values = band_tdd;
    } else if(modem_type == utils::MODEM_LTE_FDD) {
        band_values = band_fdd;
    } else {
        s = utils::format("check_band(): modem type (%s) isn't right", modemTypeToString(modem_type));
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_band(): modem type (%s) isn't right", modemTypeToString(modem_type));
        return false;
    }
    if(value < 0 || value >= band_values.size()){
        s = utils::format("set_band: value(%d) is out of range", value);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "set_band: value(%d) is out of range", value);
        return false;
    }
    band = band_values[value];
    if(modem_type == utils::MODEM_LTE_TDD){
        lte_tdd_valuse[INDEX_BAND] = band;
    } else if(modem_type == utils::MODEM_LTE_FDD) {
        lte_fdd_values[INDEX_BAND] = band;
    } else {
        s = utils::format("check_band(): modem type (%s) isn't right", modemTypeToString(modem_type));
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_band(): modem type (%s) isn't right", modemTypeToString(modem_type));
        return false;
    }
    em_result_notify_ok("band: " + band);
    return true;
}

bool RfDesenseTxTestLte::set_bandwith(int value){
    std::string s;
    if (value < 0 || value > 5) {
        s = utils::format("check_band_width value range is [%d, %d], input value is %d", 0, 5, value);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_band_width value range is [%d, %d], input value is %d", 0, 5, value);
        return false;
    }
    band_width = std::to_string(value);
    if(modem_type == utils::MODEM_LTE_FDD){
        lte_fdd_values[INDEX_BAND_WIDTH] = band_width;
    } else if(modem_type == utils::MODEM_LTE_TDD) {
        lte_tdd_valuse[INDEX_BAND_WIDTH] = band_width;
    } else {
        em_result_notify_fail("set_bandwith error");
        LOG_D(LOG_TAG, "set_bandwith error");
        return false;
    }
    em_result_notify_ok(std::string("band_width: ") + rfdesense_lte_bandwidth[value].name);
    return true;
}

bool RfDesenseTxTestLte::set_freq(std::string str){
    freq = str;
    if(modem_type == utils::MODEM_LTE_FDD){
        lte_fdd_values[INDEX_FREQ] = freq;
    } else if(modem_type == utils::MODEM_LTE_TDD) {
        lte_tdd_valuse[INDEX_FREQ] = freq;
    } else {
        em_result_notify_fail("set_freq error");
        LOG_D(LOG_TAG, "set_freq error");
        return false;
    }
    em_result_notify_ok("freq: " + freq);
    return true;

}

bool RfDesenseTxTestLte::set_tdd_config(int value){
    if(modem_type == utils::MODEM_LTE_TDD){
        if(value < 0 || value >6){
            std::string s;
            s = utils::format("check_tdd_config value range is [%d, %d], input value is %d", 0, 6, value);
            em_result_notify_fail(s);
            LOG_D(LOG_TAG, "check_tdd_config value range is [%d, %d], input value is %d", 0, 6, value);
            return false;
        }
        tdd_config = std::to_string(value);
        lte_tdd_valuse[INDEX_TDD_CONFIG] = tdd_config;
    }
    em_result_notify_ok("tdd_config: " + tdd_config);
    return true;
}

bool RfDesenseTxTestLte::set_tdd_special(int value){
    if(modem_type == utils::MODEM_LTE_TDD){
        if(value < 0 || value >9){
            std::string s;
            s = utils::format("check_tdd_special value range is [%d, %d], input value is %d", 0, 9, value);
            em_result_notify_fail(s);
            LOG_D(LOG_TAG, "check_tdd_special value range is [%d, %d], input value is %d", 0, 9, value);
            return false;
        }
        tdd_special = std::to_string(value);
        lte_tdd_valuse[INDEX_TDD_SPECIAL] = tdd_special;
    }
    em_result_notify_ok("tdd_special: " + tdd_special);
    return true;
}

bool RfDesenseTxTestLte::set_start(std::string str){
    if(!check_vrb_start(str)) return false;
    vrb_start = str;
    if(modem_type == utils::MODEM_LTE_FDD){
        lte_fdd_values[INDEX_VRB_START] = vrb_start;
    } else if(modem_type == utils::MODEM_LTE_TDD) {
        lte_tdd_valuse[INDEX_VRB_START] = vrb_start;
    } else {
        em_result_notify_fail("set_start error");
        LOG_D(LOG_TAG, "set_start error");
        return false;
    }
    em_result_notify_ok("vrb_start: " + vrb_start);
    return true;

}

bool RfDesenseTxTestLte::set_length(std::string str){
    if(!check_vrb_length(str)) return false;
    vrb_length = str;
    if(modem_type == utils::MODEM_LTE_FDD){
        lte_fdd_values[INDEX_VRB_LENGTH] = vrb_length;
    } else if(modem_type == utils::MODEM_LTE_TDD) {
        lte_tdd_valuse[INDEX_VRB_LENGTH] = vrb_length;
    } else {
        em_result_notify_fail("set_start error");
        LOG_D(LOG_TAG, "set_length error");
        return false;
    }
    em_result_notify_ok("vrb_length: " + vrb_length);
    return true;
}

bool RfDesenseTxTestLte::set_power(std::string str){
    if(!check_power(str)) return false;
    power = str;
    if(modem_type == utils::MODEM_LTE_FDD){
        lte_fdd_values[INDEX_POWER] = power;
    } else if(modem_type == utils::MODEM_LTE_TDD) {
        lte_tdd_valuse[INDEX_POWER] = power;
    } else {
        em_result_notify_fail("set_start error");
        LOG_D(LOG_TAG, "set_power error");
        return false;
    }
    em_result_notify_ok("power: " + power);
    return true;
}
bool RfDesenseTxTestLte::set_mcs(int value) {
    if (value < 0 || value > 2) {
        std::string s;
        s = utils::format("check_mcs value range is [%d, %d], input value is %d", 0, 2, value);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_mcs value range is [%d, %d], input value is %d", 0, 2, value);
        return false;
    }
    mcs = std::to_string(value);
    if(modem_type == utils::MODEM_LTE_FDD){
        lte_fdd_values[INDEX_MCS] = mcs;;
    } else if(modem_type == utils::MODEM_LTE_TDD) {
        lte_tdd_valuse[INDEX_MCS] = mcs;;
    } else {
        em_result_notify_fail("set_start error");
        LOG_D(LOG_TAG, "set_mcs error");
        return false;
    }
    em_result_notify_ok(std::string("mcs: ") + rfdesense_lte_mcs[value].name);
    return true;
}

void RfDesenseTxTestLte::show_freq(){
    emResultNotifyWithDone("UL Freq(100kHZ): " + freq);
}

void RfDesenseTxTestLte::show_start(){
    emResultNotifyWithDone("VRB Start(0~99): " + vrb_start);
}

void RfDesenseTxTestLte::show_length(){
    emResultNotifyWithDone("VRB Length(1~100): " + vrb_length);
}

void RfDesenseTxTestLte::show_power(){
    emResultNotifyWithDone("Power Level(dBm)(-50~23): " + power);
}
