/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include <stdlib.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include <vendor-ril/telephony/ril.h>
#include <strings.h>
#include <string>

#include "sim.h"
#include  "common.h"
#include "Radio_capability_switch_util.h"

#undef LOG_TAG
#define LOG_TAG "MULTI_USER_SIM"

static char* checkParameters(char* para){
    if (strcasecmp(para, "null") == 0) {
        return "";
    } else {
        return para;
    }
}

int getIccCardStatus(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if(argc != 1)
    {
        free(pRI);
        RLOGD("the paremeters numbers isn't right , so return");
        return -1;
    }
    RLOGD("getIccCardStatus %d: " , pRI->pCI->requestNumber);
    android::Parcel p;

    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

int supplyIccPinForApp(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if(argc != 2)
    {
        free(pRI);
        RLOGD("the paremeters numbers isn't right , so return");
        return -1;
    }

    const char *pin = argv[1];
    android::Parcel p;
    size_t pos = p.dataPosition();

    p.writeInt32(2);
    writeStringToParcel(p, pin);
    writeStringToParcel(p, getAid(socket_id));
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}


int changeIccPinForApp(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if(argc != 3)
    {
        free(pRI);
        RLOGD("the paremeters numbers isn't right , so return");
        return -1;
    }

    const char *oldPin = argv[1];
    const char *newPin = argv[2];
    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(3);
    writeStringToParcel(p, oldPin);
    writeStringToParcel(p, newPin);
    writeStringToParcel(p, getAid(socket_id));
    p.setDataPosition(pos);

    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int supplyIccPukForApp(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if(argc != 3)
    {
        free(pRI);
        RLOGD("the paremeters numbers isn't right , so return");
        return -1;
    }

    const char *puk = argv[1];
    const char *newPin = argv[2];
    android::Parcel p;
    size_t pos = p.dataPosition();
    // start customize
    p.writeInt32(3);
    //check
    writeStringToParcel(p, puk);
    writeStringToParcel(p, newPin);
    writeStringToParcel(p, getAid(socket_id));
    p.setDataPosition(pos);

    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int getIMSIForApp(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if (argc != 1) {
        free(pRI);
        RLOGD("the paremeters numbers isn't right , so return");
        return -1;
    }
    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(1);
    RLOGD("getIMSIForApp, aid: %s", getAid(socket_id));
    writeStringToParcel(p, getAid(socket_id));
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}


int queryIccidForApp(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if(argc != 1)
    {
        free(pRI);
        RLOGD("the paremeters numbers isn't right , so return");
        return -1;
    }
    RLOGD("queryIccidForApp %d: " , pRI->pCI->requestNumber);
    android::Parcel p;

    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

bool is_valid(int id){
    RLOGD("is_valid id: %d", id);
    return (id == 0)||(id == 1);
}

//SET_DEFAULT_SIM_ALL
int set_default_sim_all(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    if((argc != 2) || (!is_valid(atoi(argv[1]))))
    {
        free(pRI);
        RLOGD("the paremeters numbers isn't right , so return");
        android::emResultNotify("Set failed.\n");
        return -1;
    }

    set_default_sim_all(atoi(argv[1]));
    android::emResultNotify("Set successful.\n");
    free(pRI);
    return 0;
}

//GET_DEFAULT_SIM_ALL
int get_default_sim_all(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    int slot_id = get_default_sim_all();
    std::string str("");
    str = "default SIM(except data): " + std::to_string(get_default_sim_all_except_data()) + "\n";
    str = str + "default data: " + std::to_string(get_default_sim_data()) + "\n";
    str = str + "main capability SIM: " + std::to_string(Radio_capability_switch_util::get_main_capability_phone_id()) + "\n";
    android::emResultNotify(str.c_str());
    free(pRI);
    return 0;
}

//SET_DEFAULT_SIM_VOICE
int set_default_sim_voice(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    if((argc != 2) || (!is_valid(atoi(argv[1]))))
    {
        free(pRI);
        RLOGD("the paremeters numbers isn't right , so return");
        android::emResultNotify("Set failed.\n");
        return -1;
    }
    set_default_sim_voice(atoi(argv[1]));
    android::emResultNotify("Set successful.\n");
    free(pRI);
    return 0;
}

//GET_DEFAULT_SIM_VOICE
int get_default_sim_voice(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    int slot_id = get_default_sim_voice();
    std::string str("");
    if(slot_id == UNSET) {
        str = "SIM NOT insert\n";
    } else {
        str = "default SIM for voice: " + std::to_string(slot_id) + "\n";
    }
    android::emResultNotify(str.c_str());
    free(pRI);
    return 0;
}

//SET_DEFAULT_SIM_DATA
int set_default_sim_data(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    if((argc != 2) || (!is_valid(atoi(argv[1]))))
    {
        free(pRI);
        RLOGD("the paremeters numbers isn't right , so return");
        android::emResultNotify("Set failed.\n");
        return -1;
    }
    set_default_sim_data(atoi(argv[1]));
    android::emResultNotify("Set successful.\n");
    free(pRI);
    return 0;
}

//GET_DEFAULT_SIM_DATA
int get_default_sim_data(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    int slot_id = get_default_sim_data();
    std::string str("");
    if(slot_id == UNSET) {
        str = "SIM NOT insert\n";
    } else {
        str = "default SIM for data: " + std::to_string(slot_id) + "\n";
    }
    android::emResultNotify(str.c_str());
    free(pRI);
    return 0;
}

//GET_MAIN_SIM_CARD
int get_main_sim_card(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    int slot_id = Radio_capability_switch_util::get_main_capability_phone_id();
    std::string str("");
    str = "main capability SIM: " + std::to_string(slot_id) + "\n";
    android::emResultNotify(str.c_str());
    free(pRI);
    return 0;
}

//SET_DEFAULT_SIM_SMS
int set_default_sim_sms(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    if((argc != 2) || (!is_valid(atoi(argv[1]))))
    {
        free(pRI);
        RLOGD("the paremeters numbers isn't right , so return");
        android::emResultNotify("Set failed.\n");
        return -1;
    }
    set_default_sim_sms(atoi(argv[1]));
    android::emResultNotify("Set successful.\n");
    free(pRI);
    return 0;
}

//GET_DEFAULT_SIM_SMS
int get_default_sim_sms(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    int slot_id = get_default_sim_sms();
    std::string str("");
    if(slot_id == UNSET) {
        str = "SIM NOT insert\n";
    } else {
        str = "default SIM for sms: " + std::to_string(slot_id) + "\n";
    }
    android::emResultNotify(str.c_str());
    free(pRI);
    return 0;
}

//SET_DEFAULT_SIM_ALL_EXCEPT_DATA
int set_default_sim_all_except_data(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    if((argc != 2) || (!is_valid(atoi(argv[1]))))
    {
        free(pRI);
        RLOGD("the paremeters numbers isn't right , so return");
        android::emResultNotify("Set failed.\n");
        return -1;
    }

    set_default_sim_all_except_data(atoi(argv[1]));
    android::emResultNotify("Set successful.\n");
    free(pRI);
    return 0;
}

//GET_DEFAULT_SIM_ALL_EXCEPT_DATA
int get_default_sim_all_except_data(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    int slot_id = get_default_sim_all_except_data();
    std::string str("");
    if(slot_id == UNSET) {
        str = "SIM NOT insert\n";
    } else {
        str = "default SIM(except data): " + std::to_string(slot_id) + "\n";
    }
    android::emResultNotify(str.c_str());
    free(pRI);
    return 0;
}

//RIL_REQUEST_SIM_IO
int iccIOForApp(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if(argc != 10)
    {
        free(pRI);
        RLOGD("the peremeters numbers isn't right , so return");
        return -1;
    }
    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(atoi(argv[1]));
    p.writeInt32(atoi(argv[2]));
    writeStringToParcel(p, argv[3]);
    p.writeInt32(atoi(argv[4]));
    p.writeInt32(atoi(argv[5]));
    p.writeInt32(atoi(argv[6]));
    writeStringToParcel(p, checkParameters(argv[7]));
    writeStringToParcel(p, checkParameters(argv[8]));
    writeStringToParcel(p, checkParameters(argv[9]));
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

//RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC
int iccTransmitApduBasicChannel(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if(argc > 8)
    {
        free(pRI);
        RLOGD("the peremeters numbers isn't right , so return");
        return -1;
    }
    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(atoi(argv[1]));
    p.writeInt32(atoi(argv[2]));
    p.writeInt32(atoi(argv[3]));
    p.writeInt32(atoi(argv[4]));
    p.writeInt32(atoi(argv[5]));
    p.writeInt32(atoi(argv[6]));
    writeStringToParcel(p, ((argc == 7) ? "" : argv[7]));
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

//RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL
int iccTransmitApduLogicalChannel(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if(argc > 8)
    {
        free(pRI);
        RLOGD("the peremeters numbers isn't right , so return");
        return -1;
    }
    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(atoi(argv[1]));
    p.writeInt32(atoi(argv[2]));
    p.writeInt32(atoi(argv[3]));
    p.writeInt32(atoi(argv[4]));
    p.writeInt32(atoi(argv[5]));
    p.writeInt32(atoi(argv[6]));
    writeStringToParcel(p, ((argc == 7) ? "" : argv[7]));
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

//RIL_REQUEST_SIM_OPEN_CHANNEL
int iccOpenLogicalChannel(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    if(argc != 2)
    {
        free(pRI);
        RLOGD("the peremeters numbers isn't right , so return");
        return -1;
    }
    android::Parcel p;
    size_t pos = p.dataPosition();
    writeStringToParcel(p, (const char *)argv[1]);
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_SIM_CLOSE_CHANNEL
int iccCloseLogicalChannel(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    if(argc != 2)
    {
        free(pRI);
        RLOGD("the peremeters numbers isn't right , so return");
        return -1;
    }

    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(1);
    p.writeInt32(atoi(argv[1]));
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}
