/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include <cstring>
#include <algorithm>
#include "BitwiseOutputStream.h"
using namespace std;

BitwiseOutputStream::BitwiseOutputStream(int startingLength) {
  mBuf = new uint8_t[startingLength];
  memset(mBuf, 0, startingLength * sizeof(uint8_t));
  mEnd = startingLength << 3;
  mPos = 0;
}

uint8_t* BitwiseOutputStream::toByteArray(uint32_t* length) {
  int len = (mPos >> 3) + ((mPos & 0x07) > 0 ? 1 : 0);  // &7==%8
  uint8_t* newBuf = new uint8_t[len];
  memset(newBuf, 0, len * sizeof(uint8_t));
  memcpy(newBuf, mBuf, len * sizeof(uint8_t));
  (*length) = len;
  return newBuf;
}

std::vector<uint8_t> BitwiseOutputStream::toByteVector() {
  int len = (mPos >> 3) + ((mPos & 0x07) > 0 ? 1 : 0);  // &7==%8
  std::vector<uint8_t> v(mBuf, mBuf + len);
  return v;
}

void BitwiseOutputStream::possExpand(uint32_t bits) {
  if ((mPos + bits) < mEnd)
    return;
  uint8_t* newBuf = new uint8_t[(mPos + bits) >> 2];
  memset(newBuf, 0, mEnd >> 3);
  memcpy(newBuf, mBuf, mEnd >> 3);
  delete[] mBuf;
  mBuf = nullptr;
  mBuf = newBuf;
  mEnd = (mEnd >> 3) << 3;
}

void BitwiseOutputStream::write(uint32_t bits, uint32_t data) {
  if ((bits < 0) || (bits > 8)) {
    //TBD,log
    return;
  }
  possExpand(bits);
  data &= (0xFFFFFFFF >> (32 - bits));
  uint32_t index = mPos >> 3;
  uint32_t offset = 16 - (mPos & 0x07) - bits;  // &7==%8
  data <<= offset;
  mPos += bits;
  mBuf[index] |= data >> 8;
  if (offset < 8)
    mBuf[index + 1] |= data & 0xFF;
}

void BitwiseOutputStream::writeByteArray(uint32_t bits, uint8_t arr[],
    uint32_t size) {
  for (uint32_t i = 0; i < size; i++) {
    uint32_t increment = std::min((uint32_t) 8, bits - (i << 3));
    if (increment > 0) {
      write(increment, (uint8_t) (arr[i] >> (8 - increment)));
    }
  }
}

void BitwiseOutputStream::writeByteVector(uint32_t bits,
    std::vector<uint8_t> v) {
  for (uint32_t i = 0; i < v.size(); i++) {
    uint32_t increment = std::min((uint32_t) 8, bits - (i << 3));
    if (increment > 0) {
      write(increment, (uint8_t) (v[i] >> (8 - increment)));
    }
  }
}

void BitwiseOutputStream::skip(uint32_t bits) {
  possExpand(bits);
  mPos += bits;
}
BitwiseOutputStream::~BitwiseOutputStream() {
  delete[] mBuf;
  mBuf = nullptr;
}

