/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SMSADDRESS_H_
#define SMSADDRESS_H_
#include <cstdint>
#include <string>
#include <vector>

class SmsAddress {
public:
  SmsAddress();
  virtual ~SmsAddress();
  // From TS 23.040 9.1.2.5 and TS 24.008 table 10.5.118
  // and C.S0005-D table 2.7.1.3.2.4-2
  static constexpr int TON_UNKNOWN = 0;
  static constexpr int TON_INTERNATIONAL = 1;
  static constexpr int TON_NATIONAL = 2;
  static constexpr int TON_NETWORK = 3;
  static constexpr int TON_SUBSCRIBER = 4;
  static constexpr int TON_ALPHANUMERIC = 5;
  static constexpr int TON_ABBREVIATED = 6;

  int ton;
  std::string address;
  std::vector<uint8_t> origBytes;
  //uint8_t* origBytes = nullptr;
  //int origBytes_length = 0;

  /**
   * Returns the address of the SMS message in String form or null if unavailable
   */
  std::string getAddressString() {
    return address;
  }

  /**
   * Returns true if this is an alphanumeric address
   */
  bool isAlphanumeric() {
    return ton == TON_ALPHANUMERIC;
  }

  /**
   * Returns true if this is a network address
   */
  bool isNetworkSpecific() {
    return ton == TON_NETWORK;
  }

  bool couldBeEmailGateway() {
    // Some carriers seems to send email gateway messages in this form:
    // from: an UNKNOWN TON, 3 or 4 digits long, beginning with a 5
    // PID: 0x00, Data coding scheme 0x03
    // So we just attempt to treat any message from an address length <= 4
    // as an email gateway

    return address.length() <= 4;
  }
};

#endif /* SMSADDRESS_H_ */
