/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SMSCONSTANTS_H_
#define SMSCONSTANTS_H_

#include <string>
class SmsConstants {
public:
  /** User data text encoding code unit size */
  static constexpr int ENCODING_UNKNOWN = 0;
  static constexpr int ENCODING_7BIT = 1;
  static constexpr int ENCODING_8BIT = 2;
  static constexpr int ENCODING_16BIT = 3;

  /** The maximum number of payload septets per message */
  static constexpr int MAX_USER_DATA_SEPTETS = 160;

  /**
   * The maximum number of payload septets per message if a user data header
   * is present.  This assumes the header only contains the
   * CONCATENATED_8_BIT_REFERENCE element.
   */
  static constexpr int MAX_USER_DATA_SEPTETS_WITH_HEADER = 153;

  /**
   * This value is not defined in global standard. Only in Korea, this is used.
   */
  static constexpr int ENCODING_KSC5601 = 4;

  /** The maximum number of payload bytes per message */
  static constexpr int MAX_USER_DATA_BYTES = 140;

  /**
   * The maximum number of payload bytes per message if a user data header
   * is present.  This assumes the header only contains the
   * CONCATENATED_8_BIT_REFERENCE element.
   */
  static constexpr int MAX_USER_DATA_BYTES_WITH_HEADER = 134;
  /**
   * SMS Class enumeration.
   * See TS 23.038.
   */
  enum MessageClass {
    UNKNOWN, CLASS_0, CLASS_1, CLASS_2, CLASS_3
  };
  /**
   * Indicates unknown format SMS message.
   * @hide pending API council approval
   */
  static const std::string FORMAT_UNKNOWN;
  /**
   * Indicates a 3GPP format SMS message.
   * @hide pending API council approval
   */
  static const std::string FORMAT_3GPP;

  /**
   * Indicates a 3GPP2 format SMS message.
   * @hide pending API council approval
   */
  static const std::string FORMAT_3GPP2;
};

#endif /* SMSCONSTANTS_H_ */
