/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include "stateManager/stateManager.h"

#include <string>
#include <alloca.h>
#include <stdlib.h>
#include <vector>
#include <arpa/inet.h>
#include <string.h>

#include "../util/AtLine.h"
#include "powerManager.h"
#include "util/utils.h"

#undef LOG_TAG
#define LOG_TAG "MULTI_USER_MANAGER"

//RIL_REQUEST_DEVICE_IDENTITY
int getDeviceIdentity(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}
//  RIL_REQUEST_GET_IMEI
int getIMEI(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_GET_IMEISV
int getIMEISV(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_BASEBAND_VERSION
int getBasebandVersion(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_RESET_RADIO
int resetRadio(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_SCREEN_STATE
int getScreenState(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    size_t pos = p.dataPosition();

    p.writeInt32(1);
    p.writeInt32(atoi(argv[1]));

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_SET_TRM
int setTRM(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
//  android::Parcel p;

//  pRI->pCI->dispatchFunction(p, pRI);
    free(pRI);
    return 0;
}
//RIL_REQUEST_SET_IMS_ENABLE
int setIMSEnable(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    size_t pos = p.dataPosition();

    p.writeInt32(1);
    p.writeInt32(atoi(argv[1]));
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}
//RIL_REQUEST_OEM_HOOK_RAW
int sendATCMD(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    char *cmd = (char *)argv[1];
    size_t pos = p.dataPosition();
    if (cmd == NULL){
        RLOGD("sendATCMD:cmd is null\n");
        free(pRI);
        return -1;
    }
    int len = strlen(cmd);
    p.writeInt32(len);
    p.write((const void*)cmd,len);
    RLOGD("sendATCMD: %s %d",cmd,strlen(cmd));

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}
#ifdef KEEP_ALIVE
//RIL_REQUEST_START_KEEPALIVE_PRO
void tranferToNetByteOrder(int type, char* addr, std::vector<uint8_t> & dest) {
    RLOGD("type is %d, addr: %s", type ,addr);
    int ret;
    int len = 0;
    int domain;
    if(type == static_cast<int>(RIL_PacketType::IPV4_TCP) || type == static_cast<int>(RIL_PacketType::IPV4_UDP)) {
        len = sizeof(struct in_addr);
        domain = AF_INET;
    } else if(type == static_cast<int>(RIL_PacketType::IPV6_TCP) || type == static_cast<int>(RIL_PacketType::IPV6_UDP)) {
        int len = sizeof(struct in6_addr);
        domain = AF_INET6;
    }
    if (len > 0) {
        unsigned char buf[len];
        ret = inet_pton(domain, addr, &buf);
        if (ret <= 0) {
            if (ret == 0)
                RLOGE("Not in presentation format");
            else
                RLOGE("inet_pton");
            return;
        }
        for (int i = 0 ; i < len; i++ ) {
            dest.push_back(buf[i]);
            RLOGD("tranferToNetByteOrder[%d]: %d", i,buf[i]);
        }
    }

}

int startKeepAlivePro(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if (argc != 10){
        RLOGD("startKeepAlivePro parameters  number isn't enough");
        free(pRI);
        return -1;
    }
    RLOGD("startKeepAlivePro");
    std::vector<uint8_t> sourceAddress;
    std::vector<uint8_t> destinationAddress;
    int type = atoi(argv[1]);
    tranferToNetByteOrder(type, argv[2], sourceAddress);
    int sourcePort = atoi(argv[3]);
    tranferToNetByteOrder(type, argv[4], destinationAddress);
    int destinationPort = atoi(argv[5]);
    int netif_id = atoi(argv[6]);
    int keepIdleTime = atoi(argv[7]);
    int keepIntervalTime = atoi(argv[8]);
    int retryCount = atoi(argv[9]);

    android::Parcel p;
    size_t pos = p.dataPosition();

    p.writeInt32(type);
    p.writeByteVector(sourceAddress);
    p.writeInt32(sourcePort);
    p.writeByteVector(destinationAddress);
    p.writeInt32(destinationPort);
    p.writeInt32(netif_id);
    p.writeInt32(keepIdleTime);
    p.writeInt32(keepIntervalTime);
    p.writeInt32(retryCount);

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_STOP_KEEPALIVE_PRO
int stopKeepAlivePro(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if (argc != 2){
        RLOGD("stopKeepAlivePro parameters  number isn't enough");
        free(pRI);
        return -1;
    }
    RLOGD("stopKeepAlivePro");
    android::Parcel p;
    uint32_t id = atoi(argv[1]);
    RLOGD("stopKeepAlivePro sesssion id:%d", id);
    size_t pos = p.dataPosition();
    p.writeInt32(1);
    p.writeInt32(id);

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

void composeMsg(int request,const void* data, size_t datalen) {
    int* p_int = (int*) (data);
    int numInts = datalen / sizeof(int);
    if (numInts < 2) {
        RLOGD("%s error.", android::requestToString(request));
        std::string fail(android::requestToString(request));
        fail.append(",fail");
        sendKeepAlive(fail.c_str());
        return;
    }
    std::string msg(android::requestToString(request));
    if(request == RIL_REQUEST_START_KEEPALIVE_PRO) {
        msg.append(",ok");
    }
    int sessionHandle = p_int[0];
    int code = p_int[1];
    msg.append(",");
    msg.append(std::to_string(sessionHandle));
    msg.append(",");
    msg.append(std::to_string(code));
    RLOGD("%s response(%s)", android::requestToString(request),msg.c_str());
    sendKeepAlive(msg.c_str());
}

void handleKeepAliveResponse(int request, const void* data, size_t datalen, RIL_SOCKET_ID soc_id, bool is_error) {
    RLOGD("handleKeepAliveResponse(%s) is_error: %d", android::requestToString(request),is_error);
    if(is_error) {
        if(request == RIL_REQUEST_START_KEEPALIVE_PRO) {
            sendKeepAlive("RIL_REQUEST_START_KEEPALIVE_PRO,fail");
        } else if(request == RIL_REQUEST_STOP_KEEPALIVE_PRO) {
            sendKeepAlive("RIL_REQUEST_STOP_KEEPALIVE_PRO,fail");
        }
    } else {
        if(request == RIL_REQUEST_START_KEEPALIVE_PRO) {
            composeMsg(request, data, datalen);
        } else if(request == RIL_REQUEST_STOP_KEEPALIVE_PRO) {
            sendKeepAlive("RIL_REQUEST_STOP_KEEPALIVE_PRO,ok");
        } else if (request == RIL_UNSOL_KEEPALIVE_STATUS_PRO) {
            composeMsg(request, data, datalen);
        }
    }
}
#endif /*KEEP_ALIVE*/

void parseAtCmd(const char* line) {
    if (strstr(line, "+ETHERMAL") != NULL) {
        RLOGD("parse at command: ETHERMAL");
        AtLine* atLine = new AtLine(line, NULL);
        int err;
        atLine->atTokStart(&err);
        if (err < 0) {
            delete atLine;
            RLOGW("this is not a valid response string");
            return;
        }
        int rat = atLine->atTokNextint(&err);
        if (err < 0) {
            delete atLine;
            RLOGW("parse rat fail");
            return;
        }
        int temperature = atLine->atTokNextint(&err);
        if (err < 0) {
            delete atLine;
            RLOGW("parse temperature fail");
            return;
        }
        int tx_power = atLine->atTokNextint(&err);
        if (err < 0) {
            delete atLine;
            RLOGW("parse tx_power fail");
            return;
        }
        RLOGD("[tx_power]rat: %d, temperature: %d, tx_power: %d", rat, temperature, tx_power);
        printf("[tx_power]rat: %d, temperature: %d, tx_power: %d\n", rat, temperature, tx_power);
        delete atLine;
    } else if (strstr(line, "+ECAL") != NULL) {
        RLOGD("parse at command: ECAL");
        AtLine* atLine = new AtLine(line, NULL);
        int err;
        atLine->atTokStart(&err);
        if (err < 0) {
            delete atLine;
            RLOGW("this is not a valid response string");
            return;
        }
        int cal = atLine->atTokNextint(&err);
        if (err < 0) {
            delete atLine;
            RLOGW("parse rat fail");
            return;
        }
        RLOGD("calibration data is %s", cal == 1 ? "download" : "not download");
        if (cal == 0) {
            printf(
                    "************************************************\n*** NOTICE: calibration data is not download ***\n************************************************\n");
        }
        delete atLine;
    }
}
