/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <log/log.h>
#include "ModemCategory.h"
#include "WorldPhoneUtil.h"
#include "RatConfiguration.h"
#include "Radio_capability_switch_util.h"
#include "common.h"
#undef LOG_TAG
#define LOG_TAG "EM_ModemCategory"

const int ModemCategory::MODEM_FDD = 1;
const int ModemCategory::MODEM_TD = 2;
const int ModemCategory::MODEM_NO3G = 3;
const std::string ModemCategory::FK_SIM_SWITCH = "persist.vendor.radio.simswitch";
const std::string ModemCategory::FK_CDMA_SLOT = "persist.vendor.radio.cdma_slot";

/**
 * The property is used to check if the card is cdma 3G dual mode card in the slot.
 */
std::vector<std::string> ModemCategory::PROPERTY_RIL_CT3G {
    "vendor.gsm.ril.ct3g",
    "vendor.gsm.ril.ct3g.2",
    "vendor.gsm.ril.ct3g.3",
    "vendor.gsm.ril.ct3g.4",
};

/**
 * The property is used to get supported card type of each SIM card in the slot.
 */
std::vector<std::string> ModemCategory::PROPERTY_RIL_FULL_UICC_TYPE {
    "vendor.gsm.ril.fulluicctype",
    "vendor.gsm.ril.fulluicctype.2",
    "vendor.gsm.ril.fulluicctype.3",
    "vendor.gsm.ril.fulluicctype.4"};

ModemCategory::ModemCategory() {
    // TODO Auto-generated constructor stub

}

ModemCategory::~ModemCategory() {
    // TODO Auto-generated destructor stub
}

int ModemCategory::getModemType() {
    int mode = MODEM_NO3G;
    int mask = WorldPhoneUtil::get3GDivisionDuplexMode();
    if ((1 == mask) || (2 == mask)) {
        mode = mask;
    }
    RLOGD("mode = %d", mode);
    return mode;
}

bool ModemCategory::isCdma() {
    return RatConfiguration::isC2kSupported();
}

bool ModemCategory::isLteSupport() {
    return (RatConfiguration::isLteFddSupported() || RatConfiguration::isLteTddSupported());
}

bool ModemCategory::isGsmSupport() {
    return (RatConfiguration::isGsmSupported());
}

bool ModemCategory::isWcdmaSupport() {
    return (RatConfiguration::isWcdmaSupported());
}

bool ModemCategory::isTdscdmaSupport() {
    return (RatConfiguration::isTdscdmaSupported());
}

bool ModemCategory::isCapabilitySim(int type) {
    int mainCard = Radio_capability_switch_util::get_main_capability_phone_id();
    bool isCapability = (type == mainCard) ? true : false;
    RLOGD("The card(%d) is main card = %d", type, isCapability);
    return isCapability;
}

bool ModemCategory::checkViceSimCapability(int simType, int capability) {
    int rat  = get_radio_capa(simType).rat;
    if ((rat & capability) > 0) {
        RLOGD("SIM has checked capability. rat: %d, cap: %d", rat , capability);
        return true;
    }
    return false;
}
