/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include "MtkRadioAccessFamily.h"
#include "Phone_utils.h"
// Radio Access Family
// 2G
const int MtkRadioAccessFamily::RAF_UNKNOWN = RIL_RadioAccessFamily::RAF_UNKNOWN;
const int MtkRadioAccessFamily::RAF_GSM = RIL_RadioAccessFamily::RAF_GSM;
const int MtkRadioAccessFamily::RAF_GPRS = RIL_RadioAccessFamily::RAF_GPRS;
const int MtkRadioAccessFamily::RAF_EDGE = RIL_RadioAccessFamily::RAF_EDGE;
const int MtkRadioAccessFamily::RAF_IS95A = RIL_RadioAccessFamily::RAF_IS95A;
const int MtkRadioAccessFamily::RAF_IS95B = RIL_RadioAccessFamily::RAF_IS95B;
const int MtkRadioAccessFamily::RAF_1xRTT = RIL_RadioAccessFamily::RAF_1xRTT;
// 3G
const int MtkRadioAccessFamily::RAF_EVDO_0 = RIL_RadioAccessFamily::RAF_EVDO_0;
const int MtkRadioAccessFamily::RAF_EVDO_A = RIL_RadioAccessFamily::RAF_EVDO_A;
const int MtkRadioAccessFamily::RAF_EVDO_B = RIL_RadioAccessFamily::RAF_EVDO_B;
const int MtkRadioAccessFamily::RAF_EHRPD = RIL_RadioAccessFamily::RAF_EHRPD;
const int MtkRadioAccessFamily::RAF_HSUPA = RIL_RadioAccessFamily::RAF_HSUPA;
const int MtkRadioAccessFamily::RAF_HSDPA = RIL_RadioAccessFamily::RAF_HSDPA;
const int MtkRadioAccessFamily::RAF_HSPA = RIL_RadioAccessFamily::RAF_HSPA;
const int MtkRadioAccessFamily::RAF_HSPAP = RIL_RadioAccessFamily::RAF_HSPAP;
const int MtkRadioAccessFamily::RAF_UMTS = RIL_RadioAccessFamily::RAF_UMTS;
const int MtkRadioAccessFamily::RAF_TD_SCDMA =
        RIL_RadioAccessFamily::RAF_TD_SCDMA;
// 4G
const int MtkRadioAccessFamily::RAF_LTE = RIL_RadioAccessFamily::RAF_LTE;
const int MtkRadioAccessFamily::RAF_LTE_CA = 19; //RIL_RadioAccessFamily::RAF_LTE_CA;

// Grouping of RAFs
// 2G
const int MtkRadioAccessFamily::GSM = RAF_GSM | RAF_GPRS | RAF_EDGE;
const int MtkRadioAccessFamily::CDMA = RAF_IS95A | RAF_IS95B | RAF_1xRTT;
// 3G
const int MtkRadioAccessFamily::EVDO = RAF_EVDO_0 | RAF_EVDO_A | RAF_EVDO_B
        | RAF_EHRPD;
const int MtkRadioAccessFamily::HS = RAF_HSUPA | RAF_HSDPA | RAF_HSPA
        | RAF_HSPAP;
const int MtkRadioAccessFamily::WCDMA = HS | RAF_UMTS | RAF_TD_SCDMA;
// 4G
const int MtkRadioAccessFamily::LTE = RAF_LTE | RAF_LTE_CA;

MtkRadioAccessFamily::MtkRadioAccessFamily() {
    // TODO Auto-generated constructor stub

}

MtkRadioAccessFamily::~MtkRadioAccessFamily() {
    // TODO Auto-generated destructor stub
}

int MtkRadioAccessFamily::getRafFromNetworkType(int type) {
    int raf;

    switch (type) {
    case Phone_utils::NETWORK_MODE_WCDMA_PREF:
        raf = GSM | WCDMA;
        break;
    case Phone_utils::NETWORK_MODE_GSM_ONLY:
        raf = GSM;
        break;
    case Phone_utils::NETWORK_MODE_WCDMA_ONLY:
        raf = WCDMA;
        break;
    case Phone_utils::NETWORK_MODE_GSM_UMTS:
        raf = GSM | WCDMA;
        break;
    case Phone_utils::NETWORK_MODE_CDMA:
        raf = CDMA | EVDO;
        break;
    case Phone_utils::NETWORK_MODE_LTE_CDMA_EVDO:
        raf = LTE | CDMA | EVDO;
        break;
    case Phone_utils::NETWORK_MODE_LTE_GSM_WCDMA:
        raf = LTE | GSM | WCDMA;
        break;
    case Phone_utils::NETWORK_MODE_LTE_CDMA_EVDO_GSM_WCDMA:
        raf = LTE | CDMA | EVDO | GSM | WCDMA;
        break;
    case Phone_utils::NETWORK_MODE_LTE_ONLY:
        raf = LTE;
        break;
    case Phone_utils::NETWORK_MODE_LTE_WCDMA:
        raf = LTE | WCDMA;
        break;
    case Phone_utils::NETWORK_MODE_CDMA_NO_EVDO:
        raf = CDMA;
        break;
    case Phone_utils::NETWORK_MODE_EVDO_NO_CDMA:
        raf = EVDO;
        break;
    case Phone_utils::NETWORK_MODE_GLOBAL:
        raf = GSM | WCDMA | CDMA | EVDO;
        break;
    case Phone_utils::NETWORK_MODE_TDSCDMA_ONLY:
        raf = RAF_TD_SCDMA;
        break;
    case Phone_utils::NETWORK_MODE_TDSCDMA_WCDMA:
        raf = RAF_TD_SCDMA | WCDMA;
        break;
    case Phone_utils::NETWORK_MODE_LTE_TDSCDMA:
        raf = LTE | RAF_TD_SCDMA;
        break;
    case Phone_utils::NETWORK_MODE_TDSCDMA_GSM:
        raf = RAF_TD_SCDMA | GSM;
        break;
    case Phone_utils::NETWORK_MODE_LTE_TDSCDMA_GSM:
        raf = LTE | RAF_TD_SCDMA | GSM;
        break;
    case Phone_utils::NETWORK_MODE_TDSCDMA_GSM_WCDMA:
        raf = RAF_TD_SCDMA | GSM | WCDMA;
        break;
    case Phone_utils::NETWORK_MODE_LTE_TDSCDMA_WCDMA:
        raf = LTE | RAF_TD_SCDMA | WCDMA;
        break;
    case Phone_utils::NETWORK_MODE_LTE_TDSCDMA_GSM_WCDMA:
        raf = LTE | RAF_TD_SCDMA | GSM | WCDMA;
        break;
    case Phone_utils::NETWORK_MODE_TDSCDMA_CDMA_EVDO_GSM_WCDMA:
        raf = RAF_TD_SCDMA | CDMA | EVDO | GSM | WCDMA;
        break;
    case Phone_utils::NETWORK_MODE_LTE_TDSCDMA_CDMA_EVDO_GSM_WCDMA:
        raf = LTE | RAF_TD_SCDMA | CDMA | EVDO | GSM | WCDMA;
        break;
    case Phone_utils::NETWORK_MODE_LTE_GSM:
        raf = LTE | GSM;
        break;
    case Phone_utils::NETWORK_MODE_LTE_TDD_ONLY:
        raf = LTE;
        break;
    case Phone_utils::NETWORK_MODE_CDMA_GSM:
        raf = CDMA | GSM;
        break;
    case Phone_utils::NETWORK_MODE_CDMA_EVDO_GSM:
        raf = CDMA | EVDO | GSM;
        break;
    case Phone_utils::NETWORK_MODE_LTE_CDMA_EVDO_GSM:
        raf = LTE | CDMA | EVDO | GSM;
        break;
    default:
        raf = RAF_UNKNOWN;
        break;
    }

    return raf;
}

/**
 * if the raf includes ANY bit set for a group
 * adjust it to contain ALL the bits for that group
 */
int MtkRadioAccessFamily::getAdjustedRaf(int raf) {
    raf = ((GSM & raf) > 0) ? (GSM | raf) : raf;
    raf = ((WCDMA & raf) > 0) ? (WCDMA | raf) : raf;
    raf = ((CDMA & raf) > 0) ? (CDMA | raf) : raf;
    raf = ((EVDO & raf) > 0) ? (EVDO | raf) : raf;
    raf = ((LTE & raf) > 0) ? (LTE | raf) : raf;

    return raf;
}

int MtkRadioAccessFamily::getNetworkTypeFromRaf(int raf) {
    int type;

    raf = getAdjustedRaf(raf);

    switch (raf) {
    case (GSM | WCDMA):
        type = Phone_utils::NETWORK_MODE_WCDMA_PREF;
        break;
    case GSM:
        type = Phone_utils::NETWORK_MODE_GSM_ONLY;
        break;
    case WCDMA:
        type = Phone_utils::NETWORK_MODE_WCDMA_ONLY;
        break;
    case (CDMA | EVDO):
        type = Phone_utils::NETWORK_MODE_CDMA;
        break;
    case (LTE | CDMA | EVDO):
        type = Phone_utils::NETWORK_MODE_LTE_CDMA_EVDO;
        break;
    case (LTE | GSM | WCDMA):
        type = Phone_utils::NETWORK_MODE_LTE_GSM_WCDMA;
        break;
    case (LTE | CDMA | EVDO | GSM | WCDMA):
        type = Phone_utils::NETWORK_MODE_LTE_CDMA_EVDO_GSM_WCDMA;
        break;
    case LTE:
        type = Phone_utils::NETWORK_MODE_LTE_ONLY;
        break;
    case (LTE | WCDMA):
        type = Phone_utils::NETWORK_MODE_LTE_WCDMA;
        break;
    case CDMA:
        type = Phone_utils::NETWORK_MODE_CDMA_NO_EVDO;
        break;
    case EVDO:
        type = Phone_utils::NETWORK_MODE_EVDO_NO_CDMA;
        break;
    case (GSM | WCDMA | CDMA | EVDO):
        type = Phone_utils::NETWORK_MODE_GLOBAL;
        break;
    case RAF_TD_SCDMA:
        type = Phone_utils::NETWORK_MODE_TDSCDMA_ONLY;
        break;
    case (LTE | RAF_TD_SCDMA):
        type = Phone_utils::NETWORK_MODE_LTE_TDSCDMA;
        break;
    case (RAF_TD_SCDMA | GSM):
        type = Phone_utils::NETWORK_MODE_TDSCDMA_GSM;
        break;
    case (LTE | RAF_TD_SCDMA | GSM):
        type = Phone_utils::NETWORK_MODE_LTE_TDSCDMA_GSM;
        break;
    case (LTE | GSM):
        type = Phone_utils::NETWORK_MODE_LTE_GSM;
        break;
    case (CDMA | GSM):
        type = Phone_utils::NETWORK_MODE_CDMA_GSM;
        break;
    case (CDMA | EVDO | GSM):
        type = Phone_utils::NETWORK_MODE_CDMA_EVDO_GSM;
        break;
    case (LTE | CDMA | EVDO | GSM):
        type = Phone_utils::NETWORK_MODE_LTE_CDMA_EVDO_GSM;
        break;
    default:
        type = Phone_utils::PREFERRED_NETWORK_MODE;
        break;
    }

    return type;
}
