/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SRC_UTIL_MTKRADIOACCESSFAMILY_H_
#define SRC_UTIL_MTKRADIOACCESSFAMILY_H_

#include <vendor-ril/telephony/ril.h>

class MtkRadioAccessFamily {
public:
    MtkRadioAccessFamily();
    virtual ~MtkRadioAccessFamily();
    static int getRafFromNetworkType(int type);
    static int getAdjustedRaf(int raf);
    static int getNetworkTypeFromRaf(int raf);
public:
    // Radio Access Family
    // 2G
    static const int RAF_UNKNOWN;
    static const int RAF_GSM;
    static const int RAF_GPRS;
    static const int RAF_EDGE;
    static const int RAF_IS95A;
    static const int RAF_IS95B;
    static const int RAF_1xRTT;
    // 3G
    static const int RAF_EVDO_0;
    static const int RAF_EVDO_A;
    static const int RAF_EVDO_B;
    static const int RAF_EHRPD;
    static const int RAF_HSUPA;
    static const int RAF_HSDPA;
    static const int RAF_HSPA;
    static const int RAF_HSPAP;
    static const int RAF_UMTS;
    static const int RAF_TD_SCDMA;
    // 4G
    static const int RAF_LTE;
    static const int RAF_LTE_CA;
private:
    // Grouping of RAFs
    // 2G
    static const int GSM;
    static const int CDMA;
    // 3G
    static const int EVDO;
    static const int HS;
    static const int WCDMA;
    // 4G
    static const int LTE;
};

#endif /* SRC_UTIL_MTKRADIOACCESSFAMILY_H_ */
