/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SRC_UTIL_PHONE_UTILS_H_
#define SRC_UTIL_PHONE_UTILS_H_

#include <string>
#include <vendor-ril/telephony/ril.h>

class Phone_utils {
public:
    Phone_utils();
    virtual ~Phone_utils();
    static int get_phone_count();
    static bool isGsm(int radioTechnology);
    static bool isCdma(int radioTechnology);
    static bool isLte(int radioTechnology);
    static int get_enable_sim_for_dsss();
    static int get_phone_type(int slot);
public:
    static const int APP_FAM_3GPP;
    static const int APP_FAM_3GPP2;
    static const int APP_FAM_IMS;
    /* NETWORK_MODE_* See ril.h RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE */
    static constexpr int NETWORK_MODE_WCDMA_PREF     = RIL_PreferredNetworkType::PREF_NET_TYPE_GSM_WCDMA; /* GSM/WCDMA (WCDMA preferred) */
    static constexpr int NETWORK_MODE_GSM_ONLY       = RIL_PreferredNetworkType::PREF_NET_TYPE_GSM_ONLY; /* GSM only */
    static constexpr int NETWORK_MODE_WCDMA_ONLY     = RIL_PreferredNetworkType::PREF_NET_TYPE_WCDMA; /* WCDMA only */
    static constexpr int NETWORK_MODE_GSM_UMTS       = RIL_PreferredNetworkType::PREF_NET_TYPE_GSM_WCDMA_AUTO; /* GSM/WCDMA (auto mode, according to PRL)
                                            AVAILABLE Application Settings menu*/
    static constexpr int NETWORK_MODE_CDMA           = RIL_PreferredNetworkType::PREF_NET_TYPE_CDMA_EVDO_AUTO; /* CDMA and EvDo (auto mode, according to PRL)
                                            AVAILABLE Application Settings menu*/
    static constexpr int NETWORK_MODE_CDMA_NO_EVDO   = RIL_PreferredNetworkType::PREF_NET_TYPE_CDMA_ONLY; /* CDMA only */
    static constexpr int NETWORK_MODE_EVDO_NO_CDMA   = RIL_PreferredNetworkType::PREF_NET_TYPE_EVDO_ONLY; /* EvDo only */
    static constexpr int NETWORK_MODE_GLOBAL         = RIL_PreferredNetworkType::PREF_NET_TYPE_GSM_WCDMA_CDMA_EVDO_AUTO; /* GSM/WCDMA, CDMA, and EvDo (auto mode, according to PRL)
                                            AVAILABLE Application Settings menu*/
    static constexpr int NETWORK_MODE_LTE_CDMA_EVDO  = RIL_PreferredNetworkType::PREF_NET_TYPE_LTE_CDMA_EVDO; /* LTE, CDMA and EvDo */
    static constexpr int NETWORK_MODE_LTE_GSM_WCDMA  = RIL_PreferredNetworkType::PREF_NET_TYPE_LTE_GSM_WCDMA; /* LTE, GSM/WCDMA */
    static constexpr int NETWORK_MODE_LTE_CDMA_EVDO_GSM_WCDMA = RIL_PreferredNetworkType::PREF_NET_TYPE_LTE_CMDA_EVDO_GSM_WCDMA; /* LTE, CDMA, EvDo, GSM/WCDMA */
    static constexpr int NETWORK_MODE_LTE_ONLY       = RIL_PreferredNetworkType::PREF_NET_TYPE_LTE_ONLY; /* LTE Only mode. */
    static constexpr int NETWORK_MODE_LTE_WCDMA      = RIL_PreferredNetworkType::PREF_NET_TYPE_LTE_WCDMA; /* LTE/WCDMA */
    static constexpr int NETWORK_MODE_TDSCDMA_ONLY            = 13; /*RIL_PreferredNetworkType::PREF_NET_TYPE_TD_SCDMA_ONLY;  TD-SCDMA only */
    static constexpr int NETWORK_MODE_TDSCDMA_WCDMA           = 14; /*RIL_PreferredNetworkType::PREF_NET_TYPE_TD_SCDMA_WCDMA;  TD-SCDMA and WCDMA */
    static constexpr int NETWORK_MODE_LTE_TDSCDMA             = 15; /*RIL_PreferredNetworkType::PREF_NET_TYPE_TD_SCDMA_LTE; TD-SCDMA and LTE */
    static constexpr int NETWORK_MODE_TDSCDMA_GSM             = 16; /*RIL_PreferredNetworkType::PREF_NET_TYPE_TD_SCDMA_GSM;  TD-SCDMA and GSM */
    static constexpr int NETWORK_MODE_LTE_TDSCDMA_GSM         = 17; /*RIL_PreferredNetworkType::PREF_NET_TYPE_TD_SCDMA_GSM_LTE;  TD-SCDMA,GSM and LTE */
    static constexpr int NETWORK_MODE_TDSCDMA_GSM_WCDMA       = 18; /*RIL_PreferredNetworkType::PREF_NET_TYPE_TD_SCDMA_GSM_WCDMA;  TD-SCDMA, GSM/WCDMA */
    static constexpr int NETWORK_MODE_LTE_TDSCDMA_WCDMA       = 19; /*RIL_PreferredNetworkType::PREF_NET_TYPE_TD_SCDMA_WCDMA_LTE;  TD-SCDMA, WCDMA and LTE */
    static constexpr int NETWORK_MODE_LTE_TDSCDMA_GSM_WCDMA   =  20; /*RIL_PreferredNetworkType::PREF_NET_TYPE_TD_SCDMA_GSM_WCDMA_LTE;  TD-SCDMA, GSM/WCDMA and LTE */
    static constexpr int NETWORK_MODE_TDSCDMA_CDMA_EVDO_GSM_WCDMA  = 21; /*RIL_PreferredNetworkType::PREF_NET_TYPE_TD_SCDMA_GSM_WCDMA_CDMA_EVDO_AUTO; TD-SCDMA,EvDo,CDMA,GSM/WCDMA*/
    static constexpr int NETWORK_MODE_LTE_TDSCDMA_CDMA_EVDO_GSM_WCDMA = 22; /*RIL_PreferredNetworkType::PREF_NET_TYPE_TD_SCDMA_LTE_CDMA_EVDO_GSM_WCDMA;  TD-SCDMA/LTE/GSM/WCDMA, CDMA, and EvDo */
    /// M: [Network][C2K]Add the MTK new network type. @{
    static constexpr int NETWORK_MODE_LTE_GSM        = 30; /*LTE/GSM */
    static constexpr int NETWORK_MODE_LTE_TDD_ONLY   = 31; /* LTE TDD Only mode. */
    static constexpr int NETWORK_MODE_CDMA_GSM                         = 32; /* CDMA,GSM(2G Global) */
    static constexpr int NETWORK_MODE_CDMA_EVDO_GSM                    = 33; /* CDMA,EVDO,GSM */
    static constexpr int NETWORK_MODE_LTE_CDMA_EVDO_GSM                = 34; /* LTE,CDMA,EVDO,GSM(4G Global, 4M) */
    static const int PHONE_TYPE_NONE;
    static const int PHONE_TYPE_GSM;
    static const int PHONE_TYPE_CDMA;
    static const int PHONE_TYPE_SIP;
    static const int PHONE_TYPE_THIRD_PARTY;
    static const int PHONE_TYPE_IMS;
    /**
     * Available radio technologies for GSM, UMTS and CDMA.
     * Duplicates the constants from hardware/radio/include/ril.h
     * This should only be used by agents working with the ril.  Others
     * should use the equivalent TelephonyManager.NETWORK_TYPE_*
     */
    static constexpr int RIL_RADIO_TECHNOLOGY_UNKNOWN = RIL_RadioTechnology::RADIO_TECH_UNKNOWN;
    static constexpr int RIL_RADIO_TECHNOLOGY_GPRS = RIL_RadioTechnology::RADIO_TECH_GPRS;
    static constexpr int RIL_RADIO_TECHNOLOGY_EDGE = RIL_RadioTechnology::RADIO_TECH_EDGE;
    static constexpr int RIL_RADIO_TECHNOLOGY_UMTS = RIL_RadioTechnology::RADIO_TECH_UMTS;
    static constexpr int RIL_RADIO_TECHNOLOGY_IS95A = RIL_RadioTechnology::RADIO_TECH_IS95A;
    static constexpr int RIL_RADIO_TECHNOLOGY_IS95B = RIL_RadioTechnology::RADIO_TECH_IS95B;
    static constexpr int RIL_RADIO_TECHNOLOGY_1xRTT = RIL_RadioTechnology::RADIO_TECH_1xRTT;
    static constexpr int RIL_RADIO_TECHNOLOGY_EVDO_0 = RIL_RadioTechnology::RADIO_TECH_EVDO_0;
    static constexpr int RIL_RADIO_TECHNOLOGY_EVDO_A = RIL_RadioTechnology::RADIO_TECH_EVDO_A;
    static constexpr int RIL_RADIO_TECHNOLOGY_HSDPA = RIL_RadioTechnology::RADIO_TECH_HSDPA;
    static constexpr int RIL_RADIO_TECHNOLOGY_HSUPA = RIL_RadioTechnology::RADIO_TECH_HSUPA;
    static constexpr int RIL_RADIO_TECHNOLOGY_HSPA = RIL_RadioTechnology::RADIO_TECH_HSPA;
    static constexpr int RIL_RADIO_TECHNOLOGY_EVDO_B = RIL_RadioTechnology::RADIO_TECH_EVDO_B;
    static constexpr int RIL_RADIO_TECHNOLOGY_EHRPD = RIL_RadioTechnology::RADIO_TECH_EHRPD;
    static constexpr int RIL_RADIO_TECHNOLOGY_LTE = RIL_RadioTechnology::RADIO_TECH_LTE;
    static constexpr int RIL_RADIO_TECHNOLOGY_HSPAP = RIL_RadioTechnology::RADIO_TECH_HSPAP;
    static constexpr int RIL_RADIO_TECHNOLOGY_GSM = RIL_RadioTechnology::RADIO_TECH_GSM;
    static constexpr int RIL_RADIO_TECHNOLOGY_TD_SCDMA = RIL_RadioTechnology::RADIO_TECH_TD_SCDMA;
    static constexpr int RIL_RADIO_TECHNOLOGY_IWLAN = RIL_RadioTechnology::RADIO_TECH_IWLAN;
    static constexpr int RIL_RADIO_TECHNOLOGY_LTE_CA = 19;//RIL_RadioTechnology::RADIO_TECH_LTE_CA;

    static int PREFERRED_NETWORK_MODE;
private:
    static const std::string RADIO_DSSS_SIM_DISABLE;
    static int32_t disable_sim;
private:
    static int init();
};

#endif /* SRC_UTIL_PHONE_UTILS_H_ */
