/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SRC_UTIL_WORLDPHONEUTIL_H_
#define SRC_UTIL_WORLDPHONEUTIL_H_

#include <string>

class WorldPhoneUtil {
private:
    static const int ACTIVE_MD_TYPE_UNKNOWN;
    static const int ACTIVE_MD_TYPE_WG;//3G(WCDMA)+2G(GSM)
    static const int ACTIVE_MD_TYPE_TG;//3G(TDS-CDMA)+2G(GSM)
    static const int ACTIVE_MD_TYPE_LWG;//4G(TDD-LTE+FDD-LTE)+3G(WCDMA)+2G(GSM)
    static const int ACTIVE_MD_TYPE_LTG;//4G(TDD-LTE+FDD-LTE)+3G(TDS-CDMA)+2G(GSM)
    //4G(TDD-LTE+FDD-LTE)+3G(WCDMA+EVDO)+2G(GSM+CDMA2000)
    static const int ACTIVE_MD_TYPE_LWCG;
    static const int ACTIVE_MD_TYPE_LtTG;//4G(TDD-LTE)+3G(TDS-CDMA)+2G(GSM)
    static const int ACTIVE_MD_TYPE_LfWG;//4G(FDD-LTE)+3G(WCDMA)+2G(GSM)


    static const int MD_TYPE_UNKNOWN;
    static const int MD_TYPE_WG;
    static const int MD_TYPE_TG;
    static const int MD_TYPE_LWG;
    static const int MD_TYPE_LTG;
    static const int MD_TYPE_FDD;
    static const int MD_TYPE_TDD;

    static const int MD_WORLD_MODE_UNKNOWN;
    static const int MD_WORLD_MODE_LTG;   //uLTG
    static const int MD_WORLD_MODE_LWG;   //uLWG
    static const int MD_WORLD_MODE_LWTG;  //uLWTG
    static const int MD_WORLD_MODE_LWCG;  //uLWCG
    static const int MD_WORLD_MODE_LWCTG;  //uLWTCG(Auto mode)
    static const int MD_WORLD_MODE_LTTG;  //LtTG
    static const int MD_WORLD_MODE_LFWG;  //LfWG
    static const int MD_WORLD_MODE_LFWCG;  //uLfWCG
    static const int MD_WORLD_MODE_LCTG;  //uLCTG
    static const int MD_WORLD_MODE_LTCTG;  //uLtCTG
    static const int MD_WORLD_MODE_LTWG;  //uLtWG
    static const int MD_WORLD_MODE_LTWCG;  //uLTWCG
    static const int MD_WORLD_MODE_LFTG;  //uLfTG
    static const int MD_WORLD_MODE_LFCTG;  //uLfCTG

    static std::string PROPERTY_RAT_CONFIG;
    static std::string PROPERTY_ACTIVE_MD;
    static std::string WCDMA;
    static std::string TDSCDMA;
    static std::string CDMA;
    static const int UTRAN_DIVISION_DUPLEX_MODE_UNKNOWN;
    static const int UTRAN_DIVISION_DUPLEX_MODE_FDD;
    static const int UTRAN_DIVISION_DUPLEX_MODE_TDD;

    // World mode result cause for EN.
    static const int WORLD_MODE_RESULT_SUCCESS;
    static const int WORLD_MODE_RESULT_ERROR;
    static const int WORLD_MODE_RESULT_WM_ID_NOT_SUPPORT;

    /* bitmask */
    /* the defination must be sync with ratconfig.c */
    static const int MASK_CDMA;
    static const int MASK_LTEFDD;
    static const int MASK_LTETDD;
    static const int MASK_WCDMA;
    static const int MASK_TDSCDMA;
    static const int MASK_GSM;

private:
    static int getActiveModemType();
public:
    static const int MODEM_FDD;
    static const int MODEM_TD;
    static const int MODEM_NO3G;
public:
    WorldPhoneUtil();
    virtual ~WorldPhoneUtil();
    static bool isWorldPhoneSupport();
    static bool isLteSupport();
    static bool isWorldModeSupport();
    static int get3GDivisionDuplexMode();
    static int getWorldModeId();
    static int getModemType();

};

#endif /* SRC_UTIL_WORLDPHONEUTIL_H_ */
