BOOLEAN = {
    [0] = "FALSE",
    [1] = "TRUE",
}
SYS_SIM_PS = {
    [1] = "SIM0",
    [2] = "SIM1",
    [4] = "SIM2",
    [8] = "SIM3",
    [16] = "PS0",
    [32] = "PS1",
    [64] = "PS2",
    [128] = "PS3",
    [255] = "ALL",
}
SYS_REBOOT_MODE = {
    [0] = "NORMAL",
    [1] = "DOWNLOAD",
    [2] = "POWEROFF",
    [3] = "PRESHUTDOWN",
    [4] = "DOWNLOAD_NONRST",
    [5] = "SBP_CHANGE",
}
SYS_CAP_CELLULAR_CLASS = {
    [1] = "GSM",
    [2] = "CDMA",
}
SYS_VOICE_CLASS = {
    [0] = "UNKNOWN",
    [1] = "NO_VOICE",
    [2] = "SEPARATE_VOICE_DATA",
    [3] = "SIMULTANEOUS_VOICE_DATA",
}
SYS_SIM_CLASS = {
    [0] = "UNKNOWN",
    [1] = "LOGICAL",
    [2] = "REMOVABLE",
}
SYS_CAP_DATA = {
    [0] = "NONE",
    [1] = "GPRS",
    [2] = "EDGE",
    [4] = "UMTS",
    [8] = "HSDPA",
    [16] = "HSUPA",
    [32] = "LTE",
    [64] = "5G_NSA",
    [128] = "5G_SA",
    [65536] = "1XRTT",
    [131072] = "1XEVDO",
    [262144] = "1XEVDO_REVA",
    [524288] = "1XEVDV",
    [1048576] = "3XRTT",
    [2097152] = "1XEVDO_REVB",
    [4194304] = "UMB",
    [1073741824] = "HSPA_PLUS",
    [2147483648] = "CUSTOM",
}
SYS_CAP_SMS = {
    [0] = "NONE",
    [1] = "PDU_RECEIVE",
    [2] = "PDU_SEND",
    [4] = "TEXT_RECEIVE",
    [8] = "TEXT_SEND",
}
SYS_CAP_CTRL = {
    [0] = "NONE",
    [1] = "REG_MANUAL",
    [2] = "HW_RADIO_SWITCH",
    [4] = "CDMA_MOBILE_IP",
    [8] = "CDMA_SIMPLE_IP",
    [16] = "MULTI_CARRIER",
    [32] = "ESIM",
    [64] = "UE_POLICY_ROUTE_SELECTION",
    [128] = "SIM_HOT_SWAP_CAPABLE",
}
SYS_AUTH_ALGO = {
    [0] = "NONE",
    [1] = "SIM",
    [2] = "AKA",
    [3] = "AKAP",
}
SYS_CAP_SERVICE = {
    [0] = "NONE",
    [1] = "LTE_ATTACH",
    [2] = "CONTEXT_MGMT",
    [4] = "MULTI_SIM",
    [8] = "EX_SAR",
    [16] = "NETWORK_BLACKLIST",
    [32] = "5G_NSA",
}
SYS_CAP_GSM_BAND = {
    [2] = "900",
    [8] = "DCS_1800",
    [16] = "PCS_1900",
    [128] = "PCS_850",
}
SYS_CAP_UMTS_BAND = {
    [1] = "I",
    [2] = "II",
    [4] = "III",
    [8] = "IV",
    [16] = "V",
    [32] = "VI",
    [64] = "VII",
    [128] = "VIII",
    [256] = "IX",
    [512] = "X",
}
SYS_CAP_CDMA_BAND = {
    [1] = "0",
    [2] = "1",
    [4] = "2",
    [8] = "3",
    [16] = "4",
    [32] = "5",
    [64] = "6",
    [128] = "7",
    [256] = "8",
    [512] = "9",
    [1024] = "10",
    [2048] = "11",
    [4096] = "12",
    [8192] = "13",
    [16384] = "14",
    [32768] = "15",
    [65536] = "16",
    [131072] = "17",
    [262144] = "18",
    [524288] = "19",
    [1048576] = "20",
}
SYS_CAP_TDS_BAND = {
    [1] = "A",
    [2] = "B",
    [4] = "C",
    [8] = "D",
    [16] = "E",
    [32] = "F",
}
SYS_PRODUCT_TYPE = {
    [0] = "SMARTPHONE",
    [1] = "DATACARD",
}
SYS_CONFIG_CLASS = {
    [0] = "GENERAL_MD_CONFIG",
    [1] = "LEGACY_MD_CONFIG",
    [2] = "HOST_RELAY_DIPC_CONFIG",
    [3] = "N3X_CONFIG",
    [4] = "IWLAN_CONFIG",
}
IMS_CONFIG_CLASS = {
    [0] = "IMS_FEATURE",
    [1] = "IMS_CONFIG",
    [2] = "IMS_PROVISION",
    [3] = "IMS_CAPABILITY",
}
IMS_CONFIG_IND_REASON = {
    [0] = "IMS_READY",
    [1] = "USER_CHANGE",
}
IMS_STATE_IND_EVENT = {
    [0] = "REG_STATE",
    [1] = "WFC",
    [2] = "REG_URI",
    [3] = "REG_RESP",
}
IMS_STATE = {
    [0] = "UNREGISTERED",
    [1] = "REGISTERED",
}
SYS_CONFIG_CHANGE_REASON = {
    [0] = "SIM_READY",
    [1] = "USER_CHANGE",
}
SYS_ADPCLK_STATE = {
    [0] = "DISABLE",
    [1] = "ENABLE",
}
SYS_MCF_OP = {
    [0] = "SET_OTA_AND_OPOTA_FILE_PATH",
    [1] = "SET_OTA_FILE_PATH",
    [2] = "SET_OPOTA_FILE_PATH",
    [3] = "SET_FILE_PATH_IN_MCF_DSBP_ACTIVE_MODE",
    [4] = "GET_APPLIED_FILE_PATH",
    [5] = "DUMP_LID_DATA",
    [6] = "SET_FILE_PATH_AND_AUTO_SELECT_BIN",
    [7] = "UPDATE_OPOTA_FILE",
    [8] = "INI_OPERATION",
    [9] = "LID_VARIABLE_OPERATION",
    [10] = "QUERY_VARIABLE_VALUE",
    [11] = "ASSIGN_COMBINED_PATH",
}
SYS_SAR_MODE = {
    [0] = "BY_DEVICE",
    [1] = "BY_HOST",
}
SYS_ACCOUNT_ID = {
    [0] = "SIM1_NORMAL",
    [1] = "SIM1_EMERGENCY",
    [2] = "SIM2_NORMAL",
    [3] = "SIM2_EMERGENCY",
}
APN_PDP_TYPE = {
    [0] = "DEFAULT",
    [1] = "IPV4",
    [2] = "IPV6",
    [3] = "IPV4V6",
    [4] = "IPV4_AND_IPV6",
}
APN_ENABLED_TYPE = {
    [0] = "DISABLED",
    [1] = "ENABLED",
    [2] = "MAX",
}
EIF_ADDRESS_TYPE = {
    [0] = "DEFAULT",
    [1] = "IPV4",
    [2] = "IPV6",
    [3] = "IPV4V6",
}
APN_AUTH_TYPE = {
    [0] = "NONE",
    [1] = "PAP",
    [2] = "CHAP",
    [3] = "PAP_OR_CHAP",
}
APN_TYPE = {
    [0] = "UNKNOWN",
    [1] = "DEFAULT",
    [2] = "IMS",
    [4] = "MMS",
    [8] = "SUPL",
    [16] = "DUN",
    [32] = "HIPRI",
    [64] = "FOTA",
    [128] = "CBS",
    [256] = "EMERGENCY",
    [512] = "IA",
    [1024] = "DM",
    [2048] = "WAP",
    [4096] = "NET",
    [8192] = "CMMAIL",
    [16384] = "TETHERING",
    [32768] = "RCSE",
    [65536] = "XCAP",
    [131072] = "RCS",
    [262144] = "RCS_PCSCF",
    [524288] = "VSIM",
    [1048576] = "BIP",
    [2147483648] = "NW_ASSIGNED",
}
APN_COMPRESSION = {
    [0] = "NONE",
    [1] = "ENABLE",
}
APN_PROFILE_MODE = {
    [0] = "HOST_NOT_SET_APN_PROFILE",
    [1] = "HOST_SET_APN_PROFILE",
}
DATA_FALLBACK_TYPE = {
    [0] = "DISABLE",
    [1] = "IPV4_FIRST",
    [2] = "IPV6_FIRST",
}
MIPC_CID_ACT_STATE = {
    [0] = "DEACTIVATED",
    [1] = "ACTIVATED",
}
DATA_REUSE_TYPE = {
    [0] = "DEFAULT",
    [1] = "USER_SETTING_FIRST",
    [2] = "NOT_REUSE",
    [3] = "REUSE_ONLY",
}
DATA_CONFIG_TYPE = {
    [0] = "DISABLE",
    [1] = "ENABLE",
    [2] = "NO_CHANGE",
}
DATA_RETRY_MODE = {
    [0] = "QUERY_TIMER",
    [1] = "RESET_TIMER",
    [2] = "RETRY_AFTER_TIMER",
}
DATA_RETRY_TYPE = {
    [0] = "RETRY_TYPE_NO_SUGGEST",
    [1] = "RETRY_TYPE_NO_RETRY",
    [2] = "RETRY_TYPE_WITH_SUGGEST",
}
DATA_KEEPALIVE_STATUS_CODE = {
    [0] = "ACTIVE",
    [1] = "INACTIVE",
    [2] = "PENDING",
}
DATA_KEEPALIVE_TYPE = {
    [0] = "NATT_IPV4",
    [1] = "NATT_IPV6",
}
MIPC_EIWLPL_PRIORITY_TYPE = {
    [0] = "START",
    [1] = "NULL",
    [2] = "CELLULAR",
    [3] = "WIFI",
    [4] = "CELLULAR_GREATER_THAN_WIFI",
    [5] = "WIFI_GREATER_THAN_CELLULAR",
    [6] = "END",
}
INTERNAL_EIF_REQ_CMD = {
    [0] = "IFUP",
    [1] = "IFDOWN",
    [2] = "IPUPDATE",
    [3] = "IFQUERY",
    [4] = "NO_RA_INITIAL",
    [5] = "NO_RA_REFRESH",
    [6] = "IPADD",
    [7] = "IPDEL",
    [8] = "IPCHG",
}
INTERNAL_EIF_IND_CMD = {
    [0] = "IFUP",
    [1] = "IFDOWN",
    [4] = "IPCHG",
    [5] = "IFCHANGE",
}
INTERNAL_EIPPORT_ACTION = {
    [0] = "ALLOC",
    [1] = "FREE",
}
INTERNAL_EIPPORT_RESULT = {
    [0] = "FAILURE",
    [1] = "SUCCESS",
}
INTERNAL_EIPSPI_ACTION = {
    [0] = "ALLOC",
    [1] = "FREE",
}
INTERNAL_HO_PROGRESS = {
    [0] = "START",
    [1] = "STOP_SUCCESS",
    [255] = "STOP_FAILED",
}
SSC_MODE_ENUM = {
    [0] = "NONE",
    [1] = "SSC_MODE_1",
    [2] = "SSC_MODE_2",
    [3] = "SSC_MODE_3",
    [127] = "MAX",
}
NW_RADIO_STATE = {
    [0] = "OFF",
    [1] = "ON",
}
NW_RADIO_STATE_CAUSE = {
    [0] = "UNSPECIFIED",
    [1] = "DUPLEX_MODE_CHANGE",
    [2] = "POWER_OFF",
    [3] = "SIM_SWITCH",
}
NW_PROVIDER_STATE = {
    [0] = "UNKNOWN",
    [1] = "AVAILABLE",
    [2] = "CURRENT",
    [3] = "FORBIDDEN",
}
NW_REGISTER_MODE = {
    [0] = "AUTOMATIC",
    [1] = "MANUAL",
}
NW_REGISTER_STATE = {
    [0] = "NOT_REGISTERED",
    [1] = "HOME",
    [2] = "SEARCHING",
    [3] = "DENIED",
    [4] = "UNKNOWN",
    [5] = "ROAMING",
    [6] = "HOME_SMS_ONLY",
    [7] = "ROAMING_SMS_ONLY",
    [8] = "ATTACHED_ECC_ONLY",
    [9] = "HOME_CSFB_NOT_PREF",
    [10] = "ROAMING_CSFB_NOT_PREF",
}
NW_PS = {
    [0] = "DETACH",
    [1] = "ATTACH",
}
NW_IA = {
    [0] = "DETACH",
    [1] = "ATTACH",
}
NW_FAST_DORMANCY = {
    [0] = "DISABLE",
    [1] = "ENABLE",
}
NW_BLACKLIST_TYPE = {
    [0] = "SIM",
    [1] = "NETWORK",
}
NW_CELL_TYPE = {
    [0] = "NONE",
    [1] = "GSM",
    [2] = "CDMA",
    [3] = "LTE",
    [4] = "UMTS",
    [5] = "TD_SCDMA",
    [6] = "NR",
    [7] = "NSA_EXT",
}
NW_CH_LOCK = {
    [0] = "CANCEL",
    [1] = "ENABLE_CH_LK_EM",
    [2] = "ENABLE_CH_LK_CBRS",
    [3] = "CONFIG_CH_LK_CBRS",
}
NW_CH_LOCK_MODE = {
    [0] = "IDLE_MODE_ONLY",
    [1] = "IDLE_MR",
    [2] = "IDLE_HOCCO",
    [3] = "IDLE_AND_CONNECTED",
    [255] = "UNCHANGED",
}
NW_DATA_SPEED = {
    [0] = "NONE_SPECIFIED",
    [1] = "GPRS",
    [2] = "EDGE",
    [4] = "UMTS",
    [8] = "HSDPA",
    [16] = "HSUPA",
    [24] = "HSDPA_UPA",
    [32] = "HSDPAP",
    [48] = "HSDPAP_UPA",
    [64] = "HSUPAP",
    [72] = "HSUPAP_DPA",
    [96] = "HSPAP",
    [136] = "DC_DPA",
    [152] = "DC_DPA_UPA",
    [160] = "DC_HSDPAP",
    [176] = "DC_HSDPAP_UPA",
    [200] = "DC_HSUPAP_DPA",
    [224] = "DC_HSPAP",
    [256] = "1XRTT",
    [512] = "HRPD",
    [1024] = "EHRPD",
    [4096] = "LTE",
    [8192] = "LTE_CA",
    [16384] = "ENDC",
    [32768] = "NR",
    [65535] = "NOT_CHANGE",
}
NW_SIGNAL_TYPE = {
    [0] = "GSM",
    [1] = "UMTS",
    [2] = "LTE",
    [3] = "NR",
    [4] = "NR_NSA",
}
NW_CSCON_MODE = {
    [0] = "IDLE",
    [1] = "CONNECTED",
    [255] = "UNKNOWN",
}
NW_CSCON_STATE = {
    [0] = "UTRAN_URA_PCH",
    [1] = "UTRAN_CELL_PCH",
    [2] = "UTRAN_CELL_FACH",
    [3] = "UTRAN_CELL_DCH",
    [4] = "GERAN_CS_CONNECTED",
    [5] = "GERAN_PS_CONNECTED",
    [6] = "GERAN_CS_PS_CONNECTED",
    [7] = "EUTRAN_CONNECTED",
    [8] = "NR_RAN_CONNECTED",
    [8] = "NR_RAN_INACTIVE",
    [255] = "UNKNOWN",
}
NW_CSCON_ACCESS = {
    [0] = "GERAN",
    [1] = "UTRAN_TDD",
    [2] = "UTRAN_FDD",
    [3] = "EUTRAN_TDD",
    [4] = "EUTRAN_FDD",
    [5] = "NR",
    [255] = "UNKNOWN",
}
NW_CSCON_CORE_NETWORK = {
    [0] = "EPC",
    [1] = "5GCN",
    [255] = "UNKNOWN",
}
NW_PREFER_RAT_TYPE = {
    [1] = "GSM",
    [2] = "UMTS",
    [4] = "LTE",
    [128] = "NR",
}
NW_LTE_CARRIER_ARRREGATION_SWITCH = {
    [0] = "TURNOFF",
    [1] = "TURNON",
}
NW_PS_CS_REG_STATE = {
    [0] = "IN_SERVICE",
    [1] = "OUT_OF_SERVICE",
    [2] = "EMERGENCY_ONLY",
    [3] = "POWER_OFF",
}
NW_PS_CS_ROAMING_TYPE = {
    [0] = "NOT_ROAMING",
    [1] = "UNKNOWN",
    [2] = "DOMESTIC",
    [3] = "INTERNATIONAL",
}
NW_RIL_PS_CS_REG_STATE = {
    [0] = "NOT_REGISTERED_AND_NOT_SEARCHING",
    [1] = "HOME_NETWORK",
    [2] = "NOT_REGISTERED_AND_SEARCHING",
    [3] = "REG_DENIED",
    [4] = "UNKNOWN",
    [5] = "ROAMING",
    [6] = "GOOGLE_UNDEFINED1",
    [7] = "GOOGLE_UNDEFINED2",
    [8] = "GOOGLE_UNDEFINED3",
    [9] = "GOOGLE_UNDEFINED4",
    [10] = "NOT_REGISTERED_AND_NOT_SEARCHING_EMERGENCY_CALL_ENABLED",
    [11] = "GOOGLE_UNDEFINED5",
    [12] = "NOT_REGISTERED_AND_SEARCHING_EMERGENCY_CALL_ENABLED",
    [13] = "REG_DENIED_EMERGENCY_CALL_ENABLED",
    [14] = "UNKNOWN_EMERGENCY_CALL_ENABLED",
    [15] = "GOOGLE_UNDEFINED6",
}
NW_CELLMEASUREMENT_SCAN_TYPE = {
    [0] = "ONLINE_CUS_DEP",
    [1] = "OFFLINE",
    [2] = "ONLINE_NETWORK_DEP",
}
NW_BAND_OPTION = {
    [0] = "CURRENT_SETTING",
    [1] = "SYSTEM_SUPPORT",
}
NW_SIGNAL_THRESHOLD_MODE = {
    [0] = "MAP_VALUE",
    [1] = "RAW",
}
NW_ROAMING_MODE = {
    [0] = "DIS_NONE",
    [1] = "DIS_INTERNATIONAL",
    [2] = "DIS_NATIONAL",
    [4] = "DIS_H_P_PLMN_SEARCH",
}
NW_IND_TYPE = {
    [1] = "ECELL",
}
NW_RF_FAULT_CODE = {
    [1] = "RFC",
    [2] = "CALIBRATION",
    [3] = "OTHERS",
}
NW_RF_DEFECTIVE = {
    [0] = "INDEFECTIVE",
    [1] = "DEFECTIVE",
}
NW_TUW_ID = {
    [1] = "TUW1",
    [2] = "TUW2",
    [3] = "TUW3",
}
SIM_STATUS = {
    [0] = "NOT_INSERT",
    [1] = "BUSY",
    [2] = "READY",
    [3] = "SIM_PIN",
    [4] = "SIM_PUK",
    [5] = "PH_SIM_PIN",
    [6] = "PH_FSIM_PIN",
    [7] = "PH_FSIM_PUK",
    [8] = "SIM_PIN2",
    [9] = "SIM_PUK2",
    [10] = "PH_NET_PIN",
    [11] = "PH_NET_PUK",
    [12] = "PH_NETSUB_PIN",
    [13] = "PH_NETSUB_PUK",
    [14] = "PH_SP_PIN",
    [15] = "PH_SP_PUK",
    [16] = "PH_CORP_PIN",
    [17] = "PH_CORP_PUK",
    [18] = "CARD_REBOOT",
    [19] = "CARD_RESTRICTED",
    [20] = "EMPT_EUICC",
    [21] = "COMPLETE_READY",
}
SIM_STATE = {
    [0] = "UNKNOWN",
    [1] = "OFFEMPTY",
    [2] = "OFF",
    [3] = "EMPTY",
    [4] = "NOTREADY",
    [5] = "ACTIVE",
    [6] = "ERROR",
    [7] = "ACTIVE_ESIM",
    [8] = "ACTIVE_ESIM_NOPROFILE",
}
SIM_CARD_PRESENT_STATE = {
    [0] = "ABSENT",
    [1] = "PRESENT",
    [2] = "ERROR",
    [3] = "RESTRICTED",
}
SIM_SUB_STATE = {
    [0] = "UNKNOWN",
    [1] = "PLUG_IN",
    [2] = "PLUG_OUT",
    [3] = "RECOVERY_START",
    [4] = "RECOVERY_EN",
}
SIM_PIN_TYPE = {
    [0] = "NONE",
    [1] = "PIN1",
    [2] = "PIN2",
    [3] = "PUK1",
    [4] = "PUK2",
    [5] = "NW",
    [6] = "SUB_NW",
    [7] = "SP",
    [8] = "CORP",
    [9] = "SIM",
    [10] = "NS_SP",
    [11] = "SIM_C",
    [12] = "PUK_N",
    [13] = "PUK_NS",
    [14] = "PUK_SP",
    [15] = "PUK_C",
    [16] = "PUK_SIM",
    [17] = "PUK_NS_SP",
    [18] = "PUK_SIM_C",
}
SIM_PIN_PROTECTION = {
    [0] = "DISABLE",
    [1] = "ENABLE",
}
SIM_PIN_MODE = {
    [0] = "NOT_SUPPORT",
    [1] = "ENABLE",
    [2] = "DISABLE",
}
SIM_PIN_FORMAT = {
    [0] = "UNKNOWN",
    [1] = "NUMERIC",
    [2] = "ALPHA_NUMERIC",
}
SIM_PIN_STATE = {
    [0] = "UNLOCKED",
    [1] = "LOCKED",
}
SIM_PIN_OPERATION = {
    [0] = "ENTER",
    [1] = "ENABLE",
    [2] = "DISABLE",
    [3] = "CHANGE",
}
SIM_PASS_THROUGH_MODE = {
    [0] = "DISABLE",
    [1] = "ENABLE",
}
SIM_APP_TYPE = {
    [0] = "UNKNOWN",
    [1] = "MF",
    [2] = "MFSIM",
    [3] = "MFRUIM",
    [4] = "USIM",
    [5] = "CSIM",
    [6] = "ISIM",
}
SIM_ACCESS_COMMAND = {
    [176] = "READ_BINARY",
    [178] = "READ_RECORD",
    [192] = "GET_RESPONSE",
    [214] = "UPDATE_BINARY",
    [220] = "UPDATE_RECORD",
    [242] = "STATUS",
    [203] = "RETRIEVE_DATA",
    [219] = "SET_DATA",
}
SIM_FILE_ACCESSIBILITY = {
    [0] = "UNKNOWN",
    [1] = "NOTSHAREABLE",
    [2] = "SHAREABLE",
}
SIM_FILE_TYPE = {
    [0] = "UNKNOWN",
    [1] = "WORKING_EF",
    [2] = "INTERNAL_EF",
    [3] = "DF_OR_ADF",
}
SIM_FILE_STRUCTURE = {
    [0] = "UNKNOWN",
    [1] = "TRANSPARENT",
    [2] = "CYCLIC",
    [3] = "LINEAR",
    [4] = "BERTLV",
}
SIM_ENABLED = {
    [0] = "UNKNOWN",
    [1] = "ENABLED_NOT_VERIFIED",
    [2] = "ENABLED_VERIFIED",
    [3] = "DISABLED",
    [4] = "ENABLED_BLOCKED",
    [5] = "ENABLED_PERM_BLOCKED",
}
SIM_APP_STATE = {
    [0] = "UNKNOWN",
    [1] = "DETECTED",
    [2] = "PIN",
    [3] = "PUK",
    [4] = "SUBSTATE",
    [5] = "READY",
}
SIM_APP_SUB_STATUS = {
    [0] = "UNKNOWN",
    [1] = "IN_PROGRESS",
    [2] = "READY",
    [3] = "NW",
    [4] = "NW_PUK",
    [5] = "SUB_NW",
    [6] = "SUB_NW_PUK",
    [7] = "CORP",
    [8] = "CORP_PUK",
    [9] = "SP",
    [10] = "SP_PUK",
    [11] = "IMSI",
    [12] = "IMSI_PUK",
}
SIM_CAUSE = {
    [0] = "CARD_REMOVED",
    [1] = "ACCESS_ERROR",
    [2] = "SIM_REFRESH",
    [3] = "SIM_REFRESH_POWER_OFF",
    [4] = "SIM_PUK1",
    [5] = "SIM_ACCESS_PROFILE_ON",
    [6] = "SIM_ACCESS_PROFILE_OFF",
    [7] = "DUAIL_DISCONNECTED",
    [8] = "DUAIL_CONNECTED",
    [9] = "SIM_VSIM_ON",
    [10] = "SIM_VSIM_OFF",
    [11] = "SIM_PLUG_OUT",
    [12] = "SIM_PLUG_IN",
    [13] = "SIM_RECOVERY_START",
    [14] = "SIM_RECOVERY_END",
    [15] = "SIM_IMEI_LOCK_FAIL",
    [16] = "SIM_OP09_LOCK_FAIL",
    [17] = "SIM_CARD_TECHNICAL_PROBLEM",
    [18] = "SIM_POWER_OFF_BY_L4",
    [19] = "SIM_OP20_IMEI_LOCK",
    [20] = "SIM_PLUG_IN_REPLACED",
    [21] = "SIM_OP01_LOCK",
    [22] = "SIM_OP01_UNLOCK",
    [23] = "SIM_FAST_RECOVERY_START",
    [24] = "SIM_FAST_RECOVERY_SUCCESS",
    [25] = "SIM_TRAY_PLUG_OUT",
    [26] = "SIM_PLUG_IN_NO_INIT",
    [27] = "SIM_PRESENCE_DETECTION_FAIL",
    [28] = "SIM_STATE_DISABLE",
    [29] = "SIM_STATE_ENABLE",
}
SMS_STATE = {
    [0] = "NOT_INITIALIZED",
    [1] = "INITIALIZED",
}
SMS_FORMAT = {
    [0] = "PDU",
    [1] = "TEXT",
    [2] = "CDMA",
    [253] = "QUERY",
    [254] = "NULL",
    [255] = "INVALID",
}
SMS_CBM_TYPE = {
    [1] = "ETWS_PRIMARY",
    [2] = "ETWS_SECONDARY",
    [4] = "CMAS",
    [2147483648] = "OTHERS",
}
SMS_FLAG = {
    [0] = "ALL",
    [1] = "NEW",
    [2] = "OLD",
    [3] = "SENT",
    [4] = "DRAFT",
    [5] = "INDEX",
    [255] = "INVALID",
}
SMS_STATUS = {
    [0] = "REC_UNREAD",
    [1] = "REC_READ",
    [2] = "STO_UNSENT",
    [3] = "STO_SENT",
    [255] = "INVALID",
}
SMS_CLASS = {
    [0] = "0",
    [1] = "1",
    [2] = "2",
    [3] = "3",
    [254] = "NONE",
    [255] = "INVALID",
}
SMS_STORE_FLAG = {
    [0] = "NONE",
    [1] = "STORE_FULL",
    [2] = "NEW_MESSAGE",
}
SMS_STORAGE = {
    [0] = "SIM",
    [1] = "ME",
    [2] = "TE",
    [4] = "MT",
    [253] = "QUERY",
    [254] = "NULL",
    [255] = "INVALID",
}
SMS_ACK = {
    [0] = "NONEED",
    [1] = "NEEDED",
    [253] = "QUERY",
    [254] = "NULL",
    [255] = "INVALID",
}
NEW_SMS_ACK = {
    [0] = "RP_ACK",
    [1] = "RP_ERROR",
    [255] = "INVALID",
}
SMS_SEND_SAVE = {
    [0] = "NO_SAVE",
    [1] = "SAVE_IN_SIM",
    [255] = "INVALID",
}
SMS_MORE_MSG_TO_SEND = {
    [0] = "DISABLE",
    [1] = "ENABLE_ONCE",
    [2] = "ENABLE_ALWAYS",
    [254] = "NULL",
    [255] = "INVALID",
}
SMS_CBM_CFG_TYPE = {
    [1] = "ALLOW",
    [2] = "BAN",
    [253] = "QUERY",
}
SMS_SCBM_STATUS = {
    [0] = "EXIT",
    [1] = "ENTERED",
    [2] = "DISABLED",
    [3] = "REINITED",
}
SS_USSD = {
    [0] = "NO_ACTION_REQUIRED",
    [1] = "ACTION_REQUIRED",
    [2] = "TERMINATED_BY_NW",
    [3] = "OTHER_LOCAL_CLIENT",
    [4] = "OPERATION_NOT_SUPPORTED",
    [5] = "NW_TIME_OUT",
}
SS_SESSION = {
    [0] = "NEW",
    [1] = "EXISTING",
}
SS_CALL_WAITING = {
    [0] = "DISABLE",
    [1] = "ENABLE",
}
SS_SET_CALL_FORWARD_OPERATION_CODE = {
    [0] = "SS_ACTIVATE",
    [1] = "SS_DEACTIVATE",
    [3] = "SS_REGISTRATION",
    [4] = "SS_ERASURE",
}
SS_CALL_FORWARD_REASON = {
    [21] = "CALL_FORWARD_UNCONDITIONAL",
    [67] = "CALL_FORWARD_BUSY",
    [61] = "CALL_FORWARD_NO_REPLY",
    [62] = "CALL_FORWARD_NOT_REACHABLE",
    [2] = "CALL_FORWARD_ALL",
    [4] = "CALL_FORWARD_ALL_CONDITIONAL",
    [68] = "CALL_FORWARD_NOT_REGISTER",
}
SS_ACTIVE_STATUS = {
    [0] = "NOT_ACTIVE",
    [1] = "ACTIVE",
}
SS_TYPE_OF_ADDRESS = {
    [0] = "NORMAL",
    [1] = "INTERNATIONAL",
}
SS_SERVICE_CLASS = {
    [1] = "VOICE",
    [2] = "DATA",
    [4] = "FAX",
    [8] = "SMS",
    [16] = "DATA_CIRCUIT_SYNC",
    [32] = "DATA_CIRCUIT_ASYNC",
    [64] = "DEDICATED_PACKET_ACCESS",
    [128] = "DEDICATED_PAD_ACCESS",
    [256] = "MTK_LINE2",
    [512] = "MTK_VIDEO",
}
SS_CALL_BARRING_LOCK = {
    [0] = "UNLOCK",
    [1] = "LOCK",
}
SS_CALL_BARRING_FAC = {
    [0] = "AO",
    [1] = "OI",
    [2] = "OX",
    [3] = "AI",
    [4] = "IR",
    [5] = "AB",
    [6] = "AG",
    [7] = "AC",
}
STK_NOT_HANDLED = {
    [0] = "BY_FUNCTION_CANNOT_BE_HANDLED_BY_HOST",
    [1] = "By_FUNCTION_MAY_BE_HANDLED_BY_HOST",
}
STK_HANDLED = {
    [2] = "BY_FUNCTION_ONLY_TRANSPARENT_TO_HOST",
    [3] = "BY_FUNCTION_NOTIFICATION_TO_HOST_POSSIBLE",
    [4] = "BY_FUNCTION_NOTIFICATIONS_TO_HOST_ENABLE",
    [5] = "BY_FUNCTION_CAN_BE_OVERRIDDEN_BY_HOST",
    [6] = "BY_HOST_FUNCTION_NOT_ABLE_TO_HANDLE",
    [7] = "BY_HOST_FUNCTION_ABLE_TO_HANDLE",
}
STK_PAC_TYPE = {
    [0] = "PROACTIVE_COMMAND",
    [1] = "NOTIFICATION",
    [2] = "SESSION_END",
}
SIM_REFRESH_RESULT_TYPE = {
    [0] = "SIM_FILE_UPDATE",
    [1] = "SIM_INIT",
    [2] = "SIM_RESET",
    [3] = "APP_INIT",
    [4] = "SIM_INIT_FULL_FILE_CHANGE",
    [5] = "SIM_INIT_FILE_CHANGE",
    [6] = "SESSION_RESET",
}
RAN = {
    [0] = "UNKNOWN",
    [1] = "CELL",
    [2] = "WIFI",
}
CALL_CLCC_STATE = {
    [0] = "ACTIVE",
    [1] = "HELD",
    [2] = "DIALING",
    [3] = "ALERTING",
    [4] = "INCOMING",
    [5] = "WAITING",
}
CALL_DIRECTION = {
    [0] = "MO_CALL",
    [1] = "MT_CALL",
}
SDP_DIRECTION = {
    [0] = "INACTIVE",
    [1] = "SEND_ONLY",
    [2] = "RECV_ONLY",
    [3] = "SEND_RECV",
}
SPEECH_RAT = {
    [1] = "GSM",
    [2] = "UTMS",
    [4] = "IMS",
}
CALL_RAT = {
    [0] = "UNKNOWN",
    [1] = "CS",
    [2] = "VoLTE",
    [3] = "WFC",
}
CALL_TYPE = {
    [1] = "MPTY",
    [16] = "EMERGENCY",
    [256] = "VIDEO",
    [4096] = "RTT",
    [65536] = "IN_BAND_TONE",
    [1048576] = "TCH",
}
CALL_MODE = {
    [0] = "VOICE",
    [1] = "DATA",
    [3] = "VFD_VOICE",
    [4] = "AVD_VOICE",
    [5] = "AVF_VOICE",
    [6] = "VFD_DATA",
    [7] = "AVD_DATA",
    [9] = "UNKNOWN",
    [20] = "IMS_VOICE_CALL",
    [21] = "IMS_VIDEO_CALL",
    [22] = "IMS_VOICE_CONFERENCE",
    [23] = "IMS_VIDEO_CONFERENCE",
    [24] = "IMS_VOICE_CONFERENCE_PARTICIPANT",
    [25] = "IMS_VIDEO_CONFERENCE_PARTICIPANT",
    [40] = "C2K_VOICE_CALL",
    [41] = "C2K_OTASP_CALL_STD",
    [42] = "C2K_OTASP_CALL_NO_STD",
    [43] = "C2K_ECC_CALL",
}
CALL_DIAL_ADDRESS_TYPE = {
    [0] = "NONE",
    [1] = "SIP_URI",
    [2] = "NUMBER",
}
CALL_AUDIO_CODEC = {
    [0] = "NONE",
    [1] = "QCELP13K",
    [2] = "EVRC",
    [3] = "EVRC_B",
    [4] = "EVRC_WB",
    [5] = "EVRC_NW",
    [6] = "AMR_NB",
    [7] = "AMR_WB",
    [8] = "GSM_EFR",
    [9] = "GSM_FR",
    [10] = "GSM_HR",
    [23] = "EVS_NB",
    [24] = "EVS_WB",
    [25] = "EVS_SW",
    [32] = "EVS_FB",
    [33] = "EVS_AWB",
}
SDP_AUDIO_CODEC = {
    [1] = "AMR",
    [2] = "AMR_WB",
    [17] = "EVS",
}
CALL_EVENT = {
    [1] = "MT_REJECTED",
    [2] = "MT_REDIRECT",
    [3] = "SRVCC",
    [4] = "AUDIO_CODEC_CHANGE",
    [5] = "SPEECH_ATTACH",
    [6] = "CRING",
    [9] = "ECONFSRVCC",
}
CALL_MSG_TYPE = {
    [0] = "MT_CALL",
    [1] = "DISCONNECT",
    [2] = "ALERT",
    [3] = "CALL_PROCESS",
    [4] = "SYNC",
    [5] = "PROGRESS",
    [6] = "CONNECTED",
    [129] = "ALL_CALLS_DISC",
    [130] = "CALL_ID_ASSIGN",
    [131] = "STATE_CHANGE_HELD",
    [132] = "STATE_CHANGE_ACTIVE",
    [133] = "STATE_CHANGE_DISCONNECTED",
    [134] = "STATE_CHANGE_MO_DISCONNECTING",
    [135] = "STATE_HELD_BY_REMOTE",
    [136] = "STATE_ACTIVE_BY_REMOTE",
}
CALL_REJECT_REASON = {
    [0] = "UNDEFINED",
}
CALL_DIAL_TYPE = {
    [1] = "VOICE",
    [2] = "VIDEO",
    [3] = "EMERGENCY",
    [4] = "RTT",
}
CALL_CONFERENCE_DIAL_TYPE = {
    [1] = "VOICE",
    [2] = "VIDEO",
}
CALL_DIAL_DOMAIN = {
    [0] = "AUTO",
    [1] = "CS_ONLY",
    [2] = "3GPP_ONLY",
    [3] = "3GPP2_ONLY",
}
CALL_SS_ACTION = {
    [0] = "RELEASE_ALL_HELD_OR_WAITING_CALL",
    [1] = "RELEASE_ALL_ACTIVE_AND_ACCEPT_CALL",
    [2] = "PLACE_ALL_ACTIVE_CALL_ON_HOLD_AND_ACCEPT_CALL",
    [4] = "EXPLICIT_CALL_AND_TRANSFER",
    [5] = "COMPLETION_CALL_BUSY_SUBSCRIBER",
    [131] = "HOLD_CALL",
    [132] = "RESUME_CALL",
}
CALL_CONF_ACTION = {
    [0] = "MERGE",
    [1] = "ADD_PARTICIPANT",
    [2] = "REMOVE_PARTICIPANT",
    [3] = "SPLIT",
}
CALL_HANGUP_MODE = {
    [0] = "HANGUP",
    [1] = "HANGUP_ALL",
    [2] = "FORCE_HANGUP",
}
CALL_HANGUP_CAUSE = {
    [0] = "USER_HANGUP",
    [1] = "IMS_NO_COVERAGE",
    [2] = "IS_LOW_BATTERY",
    [3] = "IMS_FORWARD",
    [4] = "IMS_SPECIAL_HUNGUP",
    [5] = "IMS_607_UNWANTED",
    [6] = "CS_INCOMING_REJECTED_NO_FORWARD",
}
CALL_ANSWER_MODE = {
    [0] = "DEFAULT",
    [1] = "AUDIO_CALL",
    [2] = "Rx_VIDEO_CALL",
    [3] = "Tx_VIDEO_CALL",
}
CALL_SS_CODE1 = {
    [0] = "UCF_ACTIVE",
    [1] = "CCF_ACTIVE",
    [2] = "FORWARDED_CALL",
    [3] = "WAITING_CALL",
    [4] = "CUG_CALL",
    [5] = "OUTGOING_CALLS_ARE_BARRED",
    [6] = "INCOMING_CALLS_ARE_BARRED",
    [7] = "CLIR_SUPPRESSION_REJECTED",
    [8] = "DEFLECTED_CALL",
}
CALL_SS_CODE2 = {
    [0] = "FORWARDED_CALL",
    [1] = "CUG_CALL",
    [2] = "HOLD_CALL",
    [3] = "RETRIEVED_CALL",
    [4] = "MULTIPARTY_CALL",
    [5] = "HOLD_CALL_HAS_BEEN_RELEASEED",
    [6] = "FORWARD_CHECK_SS_MSG_RECEIVED",
    [7] = "CONNECTED_CALL_WITH_REMOTE_PARTY_IN_ALERTING",
    [8] = "CONNECTED_CALL_WITH_REMOTE_PARTY_IN_EXPLICIT_CALL_TRANSFER",
    [9] = "DEFLECTED_CALL",
    [10] = "ADDITIONAL_INCOMING_CALL_FORWARDED",
    [11] = "CALL_FORWARDED",
    [12] = "CALL_FORWARDED_UNCONDITIONAL",
    [13] = "CALL_FORWARDED_CONDITIONAL",
    [14] = "CALL_BUSY_FORWARDED",
    [15] = "CALL_FORWARDED_ON_NO_REPLY",
    [16] = "CALL_FORWARDED_ON_NOT_REACHABLE",
}
CONF_PARTICIPANT_STATUS = {
    [0] = "PENDING",
    [1] = "DIALING_OUT",
    [2] = "DIALING_IN",
    [3] = "ALERTING",
    [4] = "ON_HOLD",
    [5] = "CONNECTED",
    [6] = "DISCONNECTING",
    [7] = "DISCONNECTED",
    [8] = "MUTED_VIA_FOCUS",
    [9] = "CONNECT_FAIL",
}
SIP_DIRECTION = {
    [0] = "SEND",
    [1] = "RECEIVE",
}
SIP_MSG_TYPE = {
    [0] = "REQUEST",
    [1] = "RESPONSE",
}
SIP_METHOD = {
    [1] = "INVITE",
    [2] = "REFER",
    [3] = "UPDATE",
    [4] = "CANCEL",
    [5] = "MESSAGE",
    [6] = "ACK",
    [7] = "BYE",
    [8] = "OPTIONS",
    [9] = "SUBSCRIBE",
    [10] = "NOTIFY",
    [11] = "PUBLISH",
    [12] = "INFO",
    [13] = "PRACK",
}
IMS_EVENT_PACKAGE_TYPE = {
    [1] = "CONFERENCE",
    [2] = "DIALOG",
    [3] = "MWI",
}
ECC_INFO_TYPE = {
    [0] = "HOST",
    [1] = "SIM",
    [2] = "MCF",
}
DTMF_MODE = {
    [0] = "START",
    [1] = "STOP",
    [2] = "SINGLE_TONE",
}
CALL_ECBM_MODE = {
    [0] = "ECBM_OFF",
    [1] = "ECBM_ON",
    [2] = "NO_ECBM",
}
CALL_CLI_VALIDITY = {
    [0] = "CLI_VALID",
    [1] = "CLI_WITHHELD",
    [2] = "CLI_INTERWORK",
    [3] = "CLI_PAYPHONE",
    [4] = "CLI_OTHERS",
}
CALL_CNI_VALIDITY = {
    [0] = "CNI_VALID",
    [1] = "CNI_WITHHELD",
    [2] = "CNI_INTERWORK",
    [3] = "CNI_PAYPHONE",
    [4] = "CNI_OTHERS",
}
CRSS_TYPE = {
    [0] = "CRSS_CALL_WAITING",
    [1] = "CRSS_CALLING_LINE_ID_PRESET",
    [2] = "CRSS_CALLED_LINE_ID_PRESET",
    [3] = "CRSS_CONNECTED_LINE_ID_PRESET",
    [4] = "CDMA_CALL_WAITING",
    [5] = "CDMA_CALLING_LINE_ID_PRESET",
}
NUMBER_PRESENTATION = {
    [0] = "ALLOWED",
    [1] = "RESTRICTED",
    [2] = "UNKNOWN",
}
NUMBER_TYPE = {
    [0] = "UNKNOWN",
    [1] = "INTERNATIONAL",
    [2] = "NATIONAL",
}
RESULT = {
    [0] = "SUCCESS",
    [1] = "BUSY",
    [2] = "FAILURE",
    [3] = "SIM_NOT_INSERTED",
    [4] = "BAD_SIM",
    [5] = "PIN_REQUIRED",
    [6] = "PIN_DISABLED",
    [7] = "NOT_REGISTERED",
    [8] = "PROVIDERS_NOT_FOUND",
    [9] = "NO_DEVICE_SUPPORT",
    [10] = "PROVIDER_NOT_VISIBLE",
    [11] = "DATA_CLASS_NOT_AVAILABLE",
    [12] = "PACKET_SERVICE_DETACHED",
    [13] = "MAX_ACTIVATED_CONTEXTS",
    [14] = "NOT_INITIALIZED",
    [15] = "VOICE_CALL_IN_PROGRESS",
    [16] = "CONTEXT_NOT_ACTIVATED",
    [17] = "SERVICE_NOT_ACTIVATED",
    [18] = "INVALID_ACCESS_STRING",
    [19] = "INVALID_USERID_PASSWORD",
    [20] = "RADIO_POWER_OFF",
    [21] = "INVALID_PARAMETERS",
    [22] = "READ_FAILURE",
    [23] = "WRITE_FAILURE",
    [24] = "Reserved_24",
    [25] = "NO_PHONEBOOK",
    [26] = "PARAMETER_TOO_LONG",
    [27] = "STK_BUSY",
    [28] = "OPERATION_NOT_ALLOWED",
    [29] = "MEMORY_FAILURE",
    [30] = "INVALID_MEMORY_INDEX",
    [31] = "MEMORY_FULL",
    [32] = "FILTER_NOT_SUPPORTED",
    [33] = "DSS_INSTANCE_LIMIT",
    [34] = "INVALID_DEVICE_SERVICE_OPERATION",
    [35] = "AUTH_INCORRECT_AUTN",
    [36] = "AUTH_SYNC_FAILURE",
    [37] = "AUTH_AMF_NOT_SET",
    [38] = "CONTEXT_NOT_SUPPORTED",
    [100] = "SMS_UNKNOWN_SMSC_ADDRESS",
    [101] = "SMS_NETWORK_TIMEOUT",
    [102] = "SMS_LANG_NOT_SUPPORTED",
    [103] = "SMS_ENCODING_NOT_SUPPORTED",
    [104] = "SMS_FORMAT_NOT_SUPPORTED",
    [262143] = "COMMON_END",
    [524288] = "CAT_EXT_BEGIN",
    [786431] = "CAT_EXT_END",
    [786432] = "CC_EXT_BEGIN",
    [786433] = "CC_CALL_FORCE_RELEASED_BEFORE",
    [1048575] = "CC_EXT_END",
    [1048576] = "NW_EXT_BEGIN",
    [1310719] = "NW_EXT_END",
    [1310720] = "PDN_EXT_BEGIN",
    [1310720] = "PDN_EXT_NETWORK_ERROR_BEGIN",
    [1313792] = "PDN_EXT_NETWORK_SM_CAUSE_BEGIN",
    [1313793] = "PDN_EXT_NETWORK_SM_CAUSE_EMPTY",
    [1313800] = "PDN_EXT_NETWORK_SM_CAUSE_OPERATOR_DETERMINED_BARRING",
    [1313817] = "PDN_EXT_NETWORK_SM_CAUSE_LLC_SND_FAILURE",
    [1313818] = "PDN_EXT_NETWORK_SM_CAUSE_INSUFF_RESOURCE",
    [1313819] = "PDN_EXT_NETWORK_SM_CAUSE_UNKNOWN_APN",
    [1313820] = "PDN_EXT_NETWORK_SM_CAUSE_UNKNOWN_PDP_ADDR_OR_TYPE",
    [1313821] = "PDN_EXT_NETWORK_SM_CAUSE_AUTHENTICATION_FAILURE",
    [1313822] = "PDN_EXT_NETWORK_SM_CAUSE_ACTIVATION_REJ_GGSN",
    [1313823] = "PDN_EXT_NETWORK_SM_CAUSE_ACTIVATION_REJ_UNSPECIFIED",
    [1313824] = "PDN_EXT_NETWORK_SM_CAUSE_UNSUPPORTED_SERVICE_OPTION",
    [1313825] = "PDN_EXT_NETWORK_SM_CAUSE_UNSUBSCRIBED_SERVICE_OPTION",
    [1313826] = "PDN_EXT_NETWORK_SM_CAUSE_SERVICE_OPTION_TEMPORARILY_OUT_OF_ORDER",
    [1313827] = "PDN_EXT_NETWORK_SM_CAUSE_PTI_ALREADY_USED",
    [1313828] = "PDN_EXT_NETWORK_SM_CAUSE_REGULAR_DEACTIVATION",
    [1313829] = "PDN_EXT_NETWORK_SM_CAUSE_QOS_NOT_ACCEPTED",
    [1313830] = "PDN_EXT_NETWORK_SM_CAUSE_NETWORK_FAIL",
    [1313831] = "PDN_EXT_NETWORK_SM_CAUSE_REACTIVATION_REQD",
    [1313832] = "PDN_EXT_NETWORK_SM_CAUSE_UNSUPPORTED_NW_CONTEXT_ACTIVATION",
    [1313833] = "PDN_EXT_NETWORK_SM_CAUSE_SEMANTIC_ERROR_IN_TFT_OP",
    [1313834] = "PDN_EXT_NETWORK_SM_CAUSE_SYNTACTICAL_ERROR_IN_TFT_OP",
    [1313835] = "PDN_EXT_NETWORK_SM_CAUSE_UNKNOWN_PDP_CONTEXT",
    [1313836] = "PDN_EXT_NETWORK_SM_CAUSE_SEMANTIC_ERROR_IN_PACKET_FILTER",
    [1313837] = "PDN_EXT_NETWORK_SM_CAUSE_SYNTAX_ERROR_IN_PACKET_FILTER",
    [1313838] = "PDN_EXT_NETWORK_SM_CAUSE_PDP_CONTEXT_WO_TFT_ALREADY_ACT",
    [1313839] = "PDN_EXT_NETWORK_SM_CAUSE_PTI_MISMATCH",
    [1313840] = "PDN_EXT_NETWORK_SM_CAUSE_ACTIVATION_REJ_BCM_VIOLATION",
    [1313841] = "PDN_EXT_NETWORK_SM_CAUSE_LAST_PDN_DISC_NOT_ALLOWED",
    [1313842] = "PDN_EXT_NETWORK_SM_CAUSE_PDP_TYPE_IPV4_ONLY_ALLOWED",
    [1313843] = "PDN_EXT_NETWORK_SM_CAUSE_PDP_TYPE_IPV6_ONLY_ALLOWED",
    [1313844] = "PDN_EXT_NETWORK_SM_CAUSE_SINGLE_ADDR_BEARERS_ONLY_ALLOWED",
    [1313845] = "PDN_EXT_NETWORK_SM_CAUSE_ESM_INFORMATION_NOT_RECEIVED",
    [1313846] = "PDN_EXT_NETWORK_SM_CAUSE_PDN_CONNENCTION_NOT_EXIST",
    [1313847] = "PDN_EXT_NETWORK_SM_CAUSE_MULTIPLE_PDN_APN_NOT_ALLOWED",
    [1313848] = "PDN_EXT_NETWORK_SM_CAUSE_COLLISION_WITH_NW_INITIATED_REQ",
    [1313851] = "PDN_EXT_NETWORK_SM_CAUSE_UNSUPPORTED_QCI_VALUE",
    [1313857] = "PDN_EXT_NETWORK_SM_CAUSE_MAXIMUM_NUM_OF_PDP_CONTEXTS_REACHED",
    [1313858] = "PDN_EXT_NETWORK_SM_CAUSE_REQUESTED_APN_NOT_SUPPORTED_IN_CURRENT_RAT_AND_PLMN_COMBINATION",
    [1313873] = "PDN_EXT_NETWORK_SM_CAUSE_INVALID_TI",
    [1313887] = "PDN_EXT_NETWORK_SM_CAUSE_SM_SEMANTICALLY_INCORRECT_MSG",
    [1313888] = "PDN_EXT_NETWORK_SM_CAUSE_INVALID_MAND_INFO",
    [1313889] = "PDN_EXT_NETWORK_SM_CAUSE_SM_MSG_TYPE_NON_EXISTENT_OR_NOT_IMPLEMENTED",
    [1313890] = "PDN_EXT_NETWORK_SM_CAUSE_SM_MSG_TYPE_NOT_COMPATIBLE_WITH_PROTOCOL_STATE",
    [1313891] = "PDN_EXT_NETWORK_SM_CAUSE_IE_NON_EXISTENCE_OR_NOT_IMPLEMENTED",
    [1313892] = "PDN_EXT_NETWORK_SM_CAUSE_CONDITIONAL_IE_ERROR",
    [1313893] = "PDN_EXT_NETWORK_SM_CAUSE_SM_MSG_NOT_COMPATIBLE_WITH_PROTOCOL_STATE",
    [1313903] = "PDN_EXT_NETWORK_SM_CAUSE_SM_PROTOCOL_ERROR_UNSPECIFIED",
    [1313904] = "PDN_EXT_NETWORK_SM_CAUSE_APN_RESTRICTION_VALUE_INCOMPATIBLE_WITH_ACTIVE_PDP_CTX",
    [1313905] = "PDN_EXT_NETWORK_SM_CAUSE_END",
    [1314048] = "PDN_EXT_NETWORK_ESM_CAUSE_BEGIN",
    [1314049] = "PDN_EXT_NETWORK_ESM_CAUSE_NO_CAUSE",
    [1314056] = "PDN_EXT_NETWORK_ESM_CAUSE_OPERATOR_DETERMINED_BARRING",
    [1314074] = "PDN_EXT_NETWORK_ESM_CAUSE_INSUFFICIENT_RESOURCES",
    [1314075] = "PDN_EXT_NETWORK_ESM_CAUSE_UNKNOWN_OR_MISSING_APN",
    [1314076] = "PDN_EXT_NETWORK_ESM_CAUSE_UNKNOWN_PDN_TYPE",
    [1314077] = "PDN_EXT_NETWORK_ESM_CAUSE_USER_AUTH_FAILED",
    [1314078] = "PDN_EXT_NETWORK_ESM_CAUSE_REQUEST_REJECTED_BY_SGW_OR_PDNGW ",
    [1314079] = "PDN_EXT_NETWORK_ESM_CAUSE_REQUEST_REJECTED_UNSPECIFIED",
    [1314080] = "PDN_EXT_NETWORK_ESM_CAUSE_SERVICE_OPT_NOT_SUPPORTED",
    [1314081] = "PDN_EXT_NETWORK_ESM_CAUSE_REQ_SERVICE_NOT_SUBSCRIBED",
    [1314082] = "PDN_EXT_NETWORK_ESM_CAUSE_SERVICE_TEMP_OUT_OF_ORDER",
    [1314083] = "PDN_EXT_NETWORK_ESM_CAUSE_PTI_ALREADY_USED",
    [1314084] = "PDN_EXT_NETWORK_ESM_CAUSE_REGULAR_DEACTIVATION",
    [1314085] = "PDN_EXT_NETWORK_ESM_CAUSE_EPS_QOS_NOT_ACCEPTED",
    [1314086] = "PDN_EXT_NETWORK_ESM_CAUSE_NETWORK_FAILURE",
    [1314087] = "PDN_EXT_NETWORK_ESM_CAUSE_REACTIVATION_REQUESTED",
    [1314089] = "PDN_EXT_NETWORK_ESM_CAUSE_SEMANTIC_ERROR_IN_TFT",
    [1314090] = "PDN_EXT_NETWORK_ESM_CAUSE_SYNTACTIC_ERROR_IN_TFT",
    [1314091] = "PDN_EXT_NETWORK_ESM_CAUSE_INVALID_EPS_BEARER_IDENTITY",
    [1314092] = "PDN_EXT_NETWORK_ESM_CAUSE_SEMANTIC_ERROR_IN_PACKET_FILTERS",
    [1314093] = "PDN_EXT_NETWORK_ESM_CAUSE_SYNTACTIC_ERROR_IN_PACKET_FILTERS",
    [1314094] = "PDN_EXT_NETWORK_ESM_CAUSE_EPSB_CTXT_WITHOUT_TFT_ACTIVATED",
    [1314095] = "PDN_EXT_NETWORK_ESM_CAUSE_PTI_MISMATCH",
    [1314097] = "PDN_EXT_NETWORK_ESM_CAUSE_LAST_PDN_DISC_NOT_ALLOWED",
    [1314098] = "PDN_EXT_NETWORK_ESM_CAUSE_PDN_TYPE_IPV4_ONLY_ALLOWED",
    [1314099] = "PDN_EXT_NETWORK_ESM_CAUSE_PDN_TYPE_IPV6_ONLY_ALLOWED",
    [1314100] = "PDN_EXT_NETWORK_ESM_CAUSE_SINGLE_ADDRESS_ONLY_ALLOWED",
    [1314101] = "PDN_EXT_NETWORK_ESM_CAUSE_ESM_INFORMATION_NOT_RECEIVED",
    [1314102] = "PDN_EXT_NETWORK_ESM_CAUSE_PDN_CONNENCTION_NOT_EXIST",
    [1314103] = "PDN_EXT_NETWORK_ESM_CAUSE_MULTIPLE_PDN_APN_NOT_ALLOWED",
    [1314104] = "PDN_EXT_NETWORK_ESM_CAUSE_COLLISION_WITH_NW_INIT_REQUESTD",
    [1314107] = "PDN_EXT_NETWORK_ESM_CAUSE_UNSUPPORTED_QCI_VALUE",
    [1314113] = "PDN_EXT_NETWORK_ESM_CAUSE_MAXIMUM_NUM_OF_EPS_BEARERS_REACHED",
    [1314114] = "PDN_EXT_NETWORK_ESM_CAUSE_ESM_REQUESTED_APN_NOT_SUPPORTED_IN_CURRENT_RAT_AND_PLMN_COMBINATION",
    [1314129] = "PDN_EXT_NETWORK_ESM_CAUSE_INVALID_PTI_VALUE",
    [1314143] = "PDN_EXT_NETWORK_ESM_CAUSE_SEMANTIC_INCORRECT_MSG",
    [1314144] = "PDN_EXT_NETWORK_ESM_CAUSE_INVALID_MANDATORY_IE",
    [1314145] = "PDN_EXT_NETWORK_ESM_CAUSE_MSG_TYPE_NON_EXISTENT",
    [1314146] = "PDN_EXT_NETWORK_ESM_CAUSE_MSG_TYPE_NOT_COMPATIBLE_STATE",
    [1314147] = "PDN_EXT_NETWORK_ESM_CAUSE_IE_NON_EXISTENT_NOT_IMPLEMENTED",
    [1314148] = "PDN_EXT_NETWORK_ESM_CAUSE_CONDITIONAL_IE_ERROR",
    [1314149] = "PDN_EXT_NETWORK_ESM_CAUSE_MSG_NOT_COMPATIBLE_STATE",
    [1314159] = "PDN_EXT_NETWORK_ESM_CAUSE_PROTOCOL_ERROR_UNSPECIFIED",
    [1314160] = "PDN_EXT_NETWORK_ESM_CAUSE_APN_RESTRICT_VALUE_INCOMPATIBLE ",
    [1314161] = "PDN_EXT_NETWORK_ESM_CAUSE_END",
    [1317376] = "PDN_EXT_NETWORK_5GSM_CAUSE_BEGIN",
    [1317377] = "PDN_EXT_NETWORK_5GSM_CAUSE_NO_CAUSE",
    [1317384] = "PDN_EXT_NETWORK_5GSM_CAUSE_OPERATOR_DETERMINED_BARRING",
    [1317402] = "PDN_EXT_NETWORK_5GSM_CAUSE_INSUFFICIENT_RESOURCES",
    [1317403] = "PDN_EXT_NETWORK_5GSM_CAUSE_MISSING_OR_UNKNOWN_DNN",
    [1317404] = "PDN_EXT_NETWORK_5GSM_CAUSE_UNKNOWN_PDU_SESSION_TYPE",
    [1317405] = "PDN_EXT_NETWORK_5GSM_CAUSE_USER_AUTH_FAILED",
    [1317406] = "PDN_EXT_NETWORK_5GSM_CAUSE_REQUEST_REJECTED_BY_SGW_OR_PDNGW",
    [1317407] = "PDN_EXT_NETWORK_5GSM_CAUSE_REQUEST_REJECTED_UNSPECIFIED",
    [1317408] = "PDN_EXT_NETWORK_5GSM_CAUSE_SERVICE_OPT_NOT_SUPPORTED",
    [1317409] = "PDN_EXT_NETWORK_5GSM_CAUSE_REQ_SERVICE_NOT_SUBSCRIBED",
    [1317410] = "PDN_EXT_NETWORK_5GSM_CAUSE_SERVICE_OPT_TEMP_OUT_OF_ORDER",
    [1317411] = "PDN_EXT_NETWORK_5GSM_CAUSE_PTI_ALREADY_USED",
    [1317412] = "PDN_EXT_NETWORK_5GSM_CAUSE_REGULAR_DEACTIVATION",
    [1317413] = "PDN_EXT_NETWORK_5GSM_CAUSE_EPS_QOS_NOT_ACCEPTED",
    [1317414] = "PDN_EXT_NETWORK_5GSM_CAUSE_NETWORK_FAILURE",
    [1317415] = "PDN_EXT_NETWORK_5GSM_CAUSE_REACTIVATION_REQUESTED",
    [1317417] = "PDN_EXT_NETWORK_5GSM_CAUSE_SEMANTIC_ERROR_IN_TFT",
    [1317418] = "PDN_EXT_NETWORK_5GSM_CAUSE_SYNTACTIC_ERROR_IN_TFT",
    [1317419] = "PDN_EXT_NETWORK_5GSM_CAUSE_INVALID_PDU_SESSION_IDENTITY",
    [1317420] = "PDN_EXT_NETWORK_5GSM_CAUSE_SEMANTIC_ERROR_IN_PACKET_FILTERS",
    [1317421] = "PDN_EXT_NETWORK_5GSM_CAUSE_SYNTACTIC_ERROR_IN_PACKET_FILTERS",
    [1317422] = "PDN_EXT_NETWORK_5GSM_CAUSE_OUT_OF_LADN_SERVICE_AREA",
    [1317423] = "PDN_EXT_NETWORK_5GSM_CAUSE_PTI_MISMATCH",
    [1317425] = "PDN_EXT_NETWORK_5GSM_CAUSE_LAST_PDN_DISC_NOT_ALLOWED",
    [1317426] = "PDN_EXT_NETWORK_5GSM_CAUSE_PDU_SESSION_TYPE_IPV4_ONLY_ALLOWED",
    [1317427] = "PDN_EXT_NETWORK_5GSM_CAUSE_PDU_SESSION_TYPE_IPV6_ONLY_ALLOWED",
    [1317428] = "PDN_EXT_NETWORK_5GSM_CAUSE_SINGLE_ADDRESS_ONLY_ALLOWED",
    [1317430] = "PDN_EXT_NETWORK_5GSM_CAUSE_PDU_SESSION_NOT_EXIST",
    [1317431] = "PDN_EXT_NETWORK_5GSM_CAUSE_MULTIPLE_PDN_APN_NOT_ALLOWED",
    [1317432] = "PDN_EXT_NETWORK_5GSM_CAUSE_COLLISION_WITH_NW_INIT_REQUEST",
    [1317435] = "PDN_EXT_NETWORK_5GSM_CAUSE_UNSUPPORTED_QCI_VALUE",
    [1317441] = "PDN_EXT_NETWORK_5GSM_CAUSE_MAXIMUM_NUM_OF_EPS_BEARERS_REACHED",
    [1317442] = "PDN_EXT_NETWORK_5GSM_CAUSE_REQUESTED_APN_NOT_SUPPORTED_IN_CURRENT_RAT_AND_PLMN_COMBINATION",
    [1317443] = "PDN_EXT_NETWORK_5GSM_CAUSE_INSUFFICIENT_RESOURCES_FOR_SPECIFIC_SLICE_AND_DNN",
    [1317444] = "PDN_EXT_NETWORK_5GSM_CAUSE_NOT_SUPPORTED_SSC_MODE",
    [1317445] = "PDN_EXT_NETWORK_5GSM_CAUSE_INSUFFICIENT_RESOURCES_FOR_SPECIFIC_SLICE",
    [1317446] = "PDN_EXT_NETWORK_5GSM_CAUSE_MISSING_OR_UNKNOWN_DNN_IN_A_SLICE",
    [1317457] = "PDN_EXT_NETWORK_5GSM_CAUSE_INVALID_PTI_VALUE",
    [1317458] = "PDN_EXT_NETWORK_5GSM_CAUSE_MAX_DATA_RATE_PER_UE_FOR_UPLANE_INTEGRITY_PROTECTION_IS_TOO_LOW",
    [1317459] = "PDN_EXT_NETWORK_5GSM_CAUSE_SEMANTIC_ERROR_IN_QOS_OPERATION",
    [1317460] = "PDN_EXT_NETWORK_5GSM_CAUSE_SYNTACTIC_ERROR_IN_QOS_OPERATION",
    [1317461] = "PDN_EXT_NETWORK_5GSM_CAUSE_INVALID_MAPPED_EPS_BEARER_IDENTITY",
    [1317471] = "PDN_EXT_NETWORK_5GSM_CAUSE_SEMANTICLLY_INCORRECT_MSG",
    [1317472] = "PDN_EXT_NETWORK_5GSM_CAUSE_INVALID_MANDATORY_IE",
    [1317473] = "PDN_EXT_NETWORK_5GSM_CAUSE_MSG_TYPE_NON_EXISTENT_OR_NOT_IMPLEMENT",
    [1317474] = "PDN_EXT_NETWORK_5GSM_CAUSE_MSG_TYPE_NOT_COMPATIBLE_STATE",
    [1317475] = "PDN_EXT_NETWORK_5GSM_CAUSE_IE_NON_EXISTENT_NOT_IMPLEMENTED",
    [1317476] = "PDN_EXT_NETWORK_5GSM_CAUSE_CONDITIONAL_IE_ERROR",
    [1317477] = "PDN_EXT_NETWORK_5GSM_CAUSE_MSG_NOT_COMPATIBLE_STATE",
    [1317487] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROTOCOL_ERROR_UNSPECIFIED",
    [1317631] = "PDN_EXT_NETWORK_5GSM_CAUSE_END",
    [1376255] = "PDN_EXT_NETWORK_ERROR_END",
    [1376256] = "PDN_EXT_LOCAL_MIPC_ERROR_BEGIN",
    [1376257] = "PDN_EXT_LOCAL_MIPC_ERROR_NO_ENOUGH_INFO",
    [1376511] = "PDN_EXT_LOCAL_MIPC_ERROR_END",
    [1376512] = "PDN_EXT_LOCAL_PARA_ERROR_BEGIN",
    [1376513] = "PDN_EXT_LOCAL_PARA_ERROR_INVALID_PARA",
    [1376514] = "PDN_EXT_LOCAL_PARA_ERROR_NOT_FIND_APN_TO_ACT",
    [1376515] = "PDN_EXT_LOCAL_PARA_ERROR_NO_APN_INFO_TO_ABORT",
    [1376516] = "PDN_EXT_LOCAL_PARA_ERROR_APN_PROFILE_IS_DISABLED",
    [1376517] = "PDN_EXT_LOCAL_PARA_ERROR_NOT_FIND_CALL_INFO",
    [1376767] = "PDN_EXT_LOCAL_PARA_ERROR_END",
    [1572863] = "PDN_EXT_END",
    [1572864] = "RF_EXT_BEGIN",
    [1835007] = "RF_EXT_END",
    [1835008] = "SIM_EXT_BEGIN",
    [1835009] = "SIM_EXT_PUK1_REQUIRED",
    [1835010] = "SIM_EXT_PIN2_REQUIRED",
    [1835011] = "SIM_EXT_PUK2_REQUIRED",
    [1835012] = "SIM_EXT_SIM_FAILURE",
    [1835013] = "SIM_EXT_INCORRECT_PASS_WORD",
    [1835014] = "SIM_EXT_NW_PERSON_PIN_REQUIRED",
    [1835015] = "SIM_EXT_NW_PERSON_PUK_REQUIRED",
    [1835016] = "SIM_EXT_NW_SUB_PERSON_PIN_REQUIRED",
    [1835017] = "SIM_EXT_NW_SUB_PERSON_PUK_REQUIRED",
    [1835018] = "SIM_EXT_SP_PERSON_PIN_REQUIRED",
    [1835019] = "SIM_EXT_SP_PERSON_PUK_REQUIRED",
    [1835020] = "SIM_EXT_CORP_PERSON_PIN_REQUIRED",
    [1835021] = "SIM_EXT_CORP_PERSON_PUK_REQUIRED",
    [1835022] = "SIM_EXT_IMSI_PERSON_PIN_REQUIRED",
    [1835023] = "SIM_EXT_IMSI_PERSON_PUK_REQUIRED",
    [1835024] = "SIM_EXT_LINK_NS_SP_PERSON_PIN_REQUIRED",
    [1835025] = "SIM_EXT_LINK_NS_SP_PERSON_PUK_REQUIRED",
    [1835026] = "SIM_EXT_LINK_SIM_C_PERSON_PIN_REQUIRED",
    [1835027] = "SIM_EXT_LINK_SIM_C_PERSON_PUK_REQUIRED",
    [1835028] = "SIM_EXT_BT_SAP_UNDEFINED",
    [1835029] = "SIM_EXT_BT_SAP_NOT_ACCESSIBLE",
    [1835030] = "SIM_EXT_BT_SAP_CARD_REMOVED",
    [1835031] = "SIM_EXT_BT_SAP_CARD_ALREADY_POWERED_OFF",
    [1835032] = "SIM_EXT_BT_SAP_CARD_ALREADY_POWERED_ON",
    [2097151] = "SIM_EXT_END",
    [2097152] = "SMS_EXT_BEGIN",
    [2097153] = "SMS_EXT_CBM_CFG_WRONG_MSG_ID_RANGE_FORMAT",
    [2097154] = "SMS_EXT_CBM_CFG_WRONG_MSG_ID_SINGLE_FORMAT",
    [2097155] = "SMS_EXT_CBM_CFG_WRONG_DCS_RANGE_FORMAT",
    [2097156] = "SMS_EXT_CBM_CFG_WRONG_DCS_SINGLE_FORMAT",
    [2097157] = "SMS_EXT_CBM_CFG_TOO_MORE_RANGES_OR_SINGLES",
    [2097158] = "SMS_EXT_CBM_CFG_MSG_ID_LOGIC_ERROR",
    [2097159] = "SMS_EXT_CBM_CFG_DCS_LOGIC_ERROR",
    [2097160] = "SMS_EXT_NEED_SET_PREFER_STORAGE_AGAIN",
    [2097161] = "SMS_EXT_C2K_ERROR",
    [2162688] = "SMS_EXT_AT_ERROR_BEGIN",
    [2162914] = "SMS_EXT_CM_SMS_CONNECTION_BROKEN",
    [2165289] = "SMS_EXT_MTK_FDN_CHECK_FAILURE",
    [2168833] = "SMS_EXT_MTK_REQ_RETRY",
    [2228223] = "SMS_EXT_AT_ERROR_END",
    [2359295] = "SMS_EXT_END",
    [2359296] = "SS_EXT_BEGIN",
    [2621439] = "SS_EXT_END",
    [2621440] = "SWITCH_EXT_BEGIN",
    [2883583] = "SWITCH_EXT_END",
    [2883584] = "SYS_EXT_BEGIN",
    [3145727] = "SYS_EXT_END",
    [4294967294] = "AUTH_REQUIRED",
    [4294967295] = "TIMEOUT",
}
