#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "platform.h"
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_api.h"

void send_atcmd(char *atcmd) {
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;

    printf("Send [%s]\n", atcmd);
    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_AT_REQ, MIPC_MSG_PS0);

    //SETP2: add paramters
    mipc_sys_at_req_add_atcmd(msg_req_ptr, strlen(atcmd) + 1 , atcmd);
    //SETP3: send to MD
    msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    //SETP5: process the cnf msg
    if (msg_cnf_ptr == NULL) {
        printf("TIMEOUT\n");
        return;
    }
    if (mipc_get_result(msg_cnf_ptr) == MIPC_RESULT_SUCCESS) {
        printf("%s", mipc_sys_at_cnf_get_atcmd(msg_cnf_ptr, NULL));
    } else {
        printf("ERROR\n");
    }

    //SETE6: free the cnf msg
    mipc_msg_deinit(msg_cnf_ptr);
}

int main(int argc, char *argv[])
{
    uint8_t deact_cid;
    if (argc == 3) {
        printf("SETCOM: %s\n", argv[1]);
        SETCOM(argv[1]);
    } else {
        printf("%s <COM> <deact_cid>\n", argv[0]);
        exit(0);
    }

    deact_cid = atoi(argv[2]);

    mipc_init("wwan");

    printf("=======================================================>> deact data call [cid=%d]\n", deact_cid);
    do {
        mipc_msg_t *msg_req_ptr;
        mipc_msg_t *msg_cnf_ptr;

        //SETP1: build MIPC message
        msg_req_ptr = mipc_msg_init(MIPC_DATA_DEACT_CALL_REQ, MIPC_MSG_PS0);
        //SETP2: add paramters
        mipc_data_deact_call_req_add_id(msg_req_ptr, deact_cid);
        //SETP3: send to MD
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        //SETE4: free the req msg
        mipc_msg_deinit(msg_req_ptr);

        //SETP5: process the cnf msg
        if (msg_cnf_ptr == NULL) {
            printf("TIMEOUT\n");
            break;
        }
        if (mipc_get_result(msg_cnf_ptr) == MIPC_RESULT_SUCCESS) {
            printf("DEACT DATA CALL %d SUCCESS\n", deact_cid);
        } else {
            printf("DEACT DATA CALL %d FAIL\n", deact_cid);
        }

        //SETE6: free the cnf msg
        mipc_msg_deinit(msg_cnf_ptr);
    } while (0);

    char cmd[256];
    snprintf(cmd, sizeof(cmd), "ifconfig ccmni0 down");
    system(cmd);
    snprintf(cmd, sizeof(cmd), "ifconfig ccmni1 down");
    system(cmd);
    snprintf(cmd, sizeof(cmd), "ifconfig ccmni2 down");
    system(cmd);
    snprintf(cmd, sizeof(cmd), "ifconfig ccmni3 down");
    system(cmd);

    mipc_deinit();
}
