BOOLEAN = {
    [0] = "FALSE",
    [1] = "TRUE",
}
SYS_SIM_PS = {
    [1] = "SIM0",
    [2] = "SIM1",
    [4] = "SIM2",
    [8] = "SIM3",
    [16] = "PS0",
    [32] = "PS1",
    [64] = "PS2",
    [128] = "PS3",
    [255] = "ALL",
}
SYS_REBOOT_MODE = {
    [0] = "NORMAL",
    [1] = "DOWNLOAD",
    [2] = "POWEROFF",
    [3] = "PRESHUTDOWN",
    [4] = "DOWNLOAD_NONRST",
    [5] = "SBP_CHANGE",
    [6] = "FAST_DOWNLOAD",
}
SYS_CAP_CELLULAR_CLASS = {
    [1] = "GSM",
    [2] = "CDMA",
}
SYS_VOICE_CLASS = {
    [0] = "UNKNOWN",
    [1] = "NO_VOICE",
    [2] = "SEPARATE_VOICE_DATA",
    [3] = "SIMULTANEOUS_VOICE_DATA",
}
SYS_SIM_CLASS = {
    [0] = "UNKNOWN",
    [1] = "LOGICAL",
    [2] = "REMOVABLE",
}
SYS_CAP_DATA = {
    [0] = "NONE",
    [1] = "GPRS",
    [2] = "EDGE",
    [4] = "UMTS",
    [8] = "HSDPA",
    [16] = "HSUPA",
    [32] = "LTE",
    [64] = "5G_NSA",
    [128] = "5G_SA",
    [65536] = "1XRTT",
    [131072] = "1XEVDO",
    [262144] = "1XEVDO_REVA",
    [524288] = "1XEVDV",
    [1048576] = "3XRTT",
    [2097152] = "1XEVDO_REVB",
    [4194304] = "UMB",
    [1073741824] = "HSPA_PLUS",
    [2147483648] = "CUSTOM",
}
SYS_CAP_SMS = {
    [0] = "NONE",
    [1] = "PDU_RECEIVE",
    [2] = "PDU_SEND",
    [4] = "TEXT_RECEIVE",
    [8] = "TEXT_SEND",
}
SYS_CAP_CTRL = {
    [0] = "NONE",
    [1] = "REG_MANUAL",
    [2] = "HW_RADIO_SWITCH",
    [4] = "CDMA_MOBILE_IP",
    [8] = "CDMA_SIMPLE_IP",
    [16] = "MULTI_CARRIER",
    [32] = "ESIM",
    [64] = "UE_POLICY_ROUTE_SELECTION",
    [128] = "SIM_HOT_SWAP_CAPABLE",
}
SYS_AUTH_ALGO = {
    [0] = "NONE",
    [1] = "SIM",
    [2] = "AKA",
    [3] = "AKAP",
}
SYS_CAP_SERVICE = {
    [0] = "NONE",
    [1] = "LTE_ATTACH",
    [2] = "CONTEXT_MGMT",
    [4] = "MULTI_SIM",
    [8] = "EX_SAR",
    [16] = "NETWORK_BLACKLIST",
    [32] = "5G_NSA",
}
SYS_CAP_GSM_BAND = {
    [2] = "900",
    [8] = "DCS_1800",
    [16] = "PCS_1900",
    [128] = "PCS_850",
}
SYS_CAP_UMTS_BAND = {
    [1] = "I",
    [2] = "II",
    [4] = "III",
    [8] = "IV",
    [16] = "V",
    [32] = "VI",
    [64] = "VII",
    [128] = "VIII",
    [256] = "IX",
    [512] = "X",
}
SYS_CAP_CDMA_BAND = {
    [1] = "0",
    [2] = "1",
    [4] = "2",
    [8] = "3",
    [16] = "4",
    [32] = "5",
    [64] = "6",
    [128] = "7",
    [256] = "8",
    [512] = "9",
    [1024] = "10",
    [2048] = "11",
    [4096] = "12",
    [8192] = "13",
    [16384] = "14",
    [32768] = "15",
    [65536] = "16",
    [131072] = "17",
    [262144] = "18",
    [524288] = "19",
    [1048576] = "20",
}
SYS_CAP_TDS_BAND = {
    [1] = "A",
    [2] = "B",
    [4] = "C",
    [8] = "D",
    [16] = "E",
    [32] = "F",
}
SYS_PRODUCT_TYPE = {
    [0] = "SMARTPHONE",
    [1] = "DATACARD",
}
SYS_CONFIG_CLASS = {
    [0] = "GENERAL_MD_CONFIG",
    [1] = "LEGACY_MD_CONFIG",
    [2] = "HOST_RELAY_DIPC_CONFIG",
    [3] = "N3X_CONFIG",
    [4] = "IWLAN_CONFIG",
}
IMS_CONFIG_CLASS = {
    [0] = "IMS_FEATURE",
    [1] = "IMS_CONFIG",
    [2] = "IMS_PROVISION",
    [3] = "IMS_CAPABILITY",
}
IMS_CONFIG_IND_REASON = {
    [0] = "IMS_READY",
    [1] = "USER_CHANGE",
}
IMS_STATE_IND_EVENT = {
    [0] = "REG_STATE",
    [1] = "WFC",
    [2] = "REG_URI",
    [3] = "REG_RESP",
}
IMS_STATE = {
    [0] = "UNREGISTERED",
    [1] = "REGISTERED",
}
SYS_CONFIG_CHANGE_REASON = {
    [0] = "SIM_READY",
    [1] = "USER_CHANGE",
}
SYS_ADPCLK_STATE = {
    [0] = "DISABLE",
    [1] = "ENABLE",
}
SYS_MCF_OP = {
    [0] = "SET_OTA_AND_OPOTA_FILE_PATH",
    [1] = "SET_OTA_FILE_PATH",
    [2] = "SET_OPOTA_FILE_PATH",
    [3] = "SET_FILE_PATH_IN_MCF_DSBP_ACTIVE_MODE",
    [4] = "GET_APPLIED_FILE_PATH",
    [5] = "DUMP_LID_DATA",
    [6] = "SET_FILE_PATH_AND_AUTO_SELECT_BIN",
    [7] = "UPDATE_OPOTA_FILE",
    [8] = "INI_OPERATION",
    [9] = "LID_VARIABLE_OPERATION",
    [10] = "QUERY_VARIABLE_VALUE",
    [11] = "ASSIGN_COMBINED_PATH",
}
SYS_SAR_MODE = {
    [0] = "BY_DEVICE",
    [1] = "BY_HOST",
}
SYS_ACCOUNT_ID = {
    [0] = "SIM1_NORMAL",
    [1] = "SIM1_EMERGENCY",
    [2] = "SIM2_NORMAL",
    [3] = "SIM2_EMERGENCY",
}
APN_PDP_TYPE = {
    [0] = "DEFAULT",
    [1] = "IPV4",
    [2] = "IPV6",
    [3] = "IPV4V6",
    [4] = "IPV4_AND_IPV6",
}
APN_ENABLED_TYPE = {
    [0] = "DISABLED",
    [1] = "ENABLED",
    [2] = "MAX",
}
EIF_ADDRESS_TYPE = {
    [0] = "DEFAULT",
    [1] = "IPV4",
    [2] = "IPV6",
    [3] = "IPV4V6",
}
APN_AUTH_TYPE = {
    [0] = "NONE",
    [1] = "PAP",
    [2] = "CHAP",
    [3] = "PAP_OR_CHAP",
}
APN_TYPE = {
    [0] = "UNKNOWN",
    [1] = "DEFAULT",
    [2] = "IMS",
    [4] = "MMS",
    [8] = "SUPL",
    [16] = "DUN",
    [32] = "HIPRI",
    [64] = "FOTA",
    [128] = "CBS",
    [256] = "EMERGENCY",
    [512] = "IA",
    [1024] = "DM",
    [2048] = "WAP",
    [4096] = "NET",
    [8192] = "CMMAIL",
    [16384] = "TETHERING",
    [32768] = "RCSE",
    [65536] = "XCAP",
    [131072] = "RCS",
    [262144] = "RCS_PCSCF",
    [524288] = "VSIM",
    [1048576] = "BIP",
    [2147483648] = "NW_ASSIGNED",
}
APN_COMPRESSION = {
    [0] = "NONE",
    [1] = "ENABLE",
}
APN_PROFILE_MODE = {
    [0] = "HOST_NOT_SET_APN_PROFILE",
    [1] = "HOST_SET_APN_PROFILE",
}
DATA_FALLBACK_TYPE = {
    [0] = "DISABLE",
    [1] = "IPV4_FIRST",
    [2] = "IPV6_FIRST",
}
MIPC_CID_ACT_STATE = {
    [0] = "DEACTIVATED",
    [1] = "ACTIVATED",
}
DATA_REUSE_TYPE = {
    [0] = "DEFAULT",
    [1] = "USER_SETTING_FIRST",
    [2] = "NOT_REUSE",
    [3] = "REUSE_ONLY",
}
DATA_CONFIG_TYPE = {
    [0] = "DISABLE",
    [1] = "ENABLE",
    [2] = "NO_CHANGE",
}
DATA_RETRY_MODE = {
    [0] = "QUERY_TIMER",
    [1] = "RESET_TIMER",
    [2] = "RETRY_AFTER_TIMER",
}
DATA_RETRY_TYPE = {
    [0] = "RETRY_TYPE_NO_SUGGEST",
    [1] = "RETRY_TYPE_NO_RETRY",
    [2] = "RETRY_TYPE_WITH_SUGGEST",
}
DATA_KEEPALIVE_STATUS_CODE = {
    [0] = "ACTIVE",
    [1] = "INACTIVE",
    [2] = "PENDING",
}
DATA_KEEPALIVE_TYPE = {
    [0] = "NATT_IPV4",
    [1] = "NATT_IPV6",
    [2] = "IPV4_TCP",
    [3] = "IPV4_UDP",
    [4] = "IPV6_TCP",
    [5] = "IPV6_UDP",
}
MIPC_EIWLPL_PRIORITY_TYPE = {
    [0] = "START",
    [1] = "NULL",
    [2] = "CELLULAR",
    [3] = "WIFI",
    [4] = "CELLULAR_GREATER_THAN_WIFI",
    [5] = "WIFI_GREATER_THAN_CELLULAR",
    [6] = "END",
}
INTERNAL_EIF_REQ_CMD = {
    [0] = "IFUP",
    [1] = "IFDOWN",
    [2] = "IPUPDATE",
    [3] = "IFQUERY",
    [4] = "NO_RA_INITIAL",
    [5] = "NO_RA_REFRESH",
    [6] = "IPADD",
    [7] = "IPDEL",
    [8] = "IPCHG",
}
INTERNAL_EIF_IND_CMD = {
    [0] = "IFUP",
    [1] = "IFDOWN",
    [4] = "IPCHG",
    [5] = "IFCHANGE",
}
INTERNAL_EIPPORT_ACTION = {
    [0] = "ALLOC",
    [1] = "FREE",
}
INTERNAL_EIPPORT_RESULT = {
    [0] = "FAILURE",
    [1] = "SUCCESS",
}
INTERNAL_EIPSPI_ACTION = {
    [0] = "ALLOC",
    [1] = "FREE",
}
INTERNAL_HO_PROGRESS = {
    [0] = "START",
    [1] = "STOP_SUCCESS",
    [255] = "STOP_FAILED",
}
SSC_MODE_ENUM = {
    [0] = "NONE",
    [1] = "SSC_MODE_1",
    [2] = "SSC_MODE_2",
    [3] = "SSC_MODE_3",
    [127] = "MAX",
}
NSSAI_TYPE_ENUM = {
    [0] = "DEFAULT_CONFIGURED_NSSAI",
    [1] = "DEFAULT_CONFIGURED_AND_REJECT_NSSAI",
    [2] = "DEFAULT_CONFIGURED_AND_REJECT_AND_CONFIGURED_NSSAI",
    [3] = "DEFAULT_CONFIGURED_AND_REJECT_AND_CONFIGURED_AND_ALLOWED_NSSAI",
    [127] = "MAX",
}
NW_RADIO_STATE = {
    [0] = "OFF",
    [1] = "ON",
}
NW_RADIO_STATE_CAUSE = {
    [0] = "UNSPECIFIED",
    [1] = "DUPLEX_MODE_CHANGE",
    [2] = "POWER_OFF",
    [3] = "SIM_SWITCH",
}
NW_PROVIDER_STATE = {
    [0] = "UNKNOWN",
    [1] = "AVAILABLE",
    [2] = "CURRENT",
    [3] = "FORBIDDEN",
}
NW_REGISTER_MODE = {
    [0] = "AUTOMATIC",
    [1] = "MANUAL",
    [2] = "DEREGISTER",
}
NW_REGISTER_STATE = {
    [0] = "NOT_REGISTERED",
    [1] = "HOME",
    [2] = "SEARCHING",
    [3] = "DENIED",
    [4] = "UNKNOWN",
    [5] = "ROAMING",
    [6] = "HOME_SMS_ONLY",
    [7] = "ROAMING_SMS_ONLY",
    [8] = "ATTACHED_ECC_ONLY",
    [9] = "HOME_CSFB_NOT_PREF",
    [10] = "ROAMING_CSFB_NOT_PREF",
}
NW_PS = {
    [0] = "DETACH",
    [1] = "ATTACH",
}
NW_IA = {
    [0] = "DETACH",
    [1] = "ATTACH",
}
NW_FAST_DORMANCY = {
    [0] = "DISABLE",
    [1] = "ENABLE",
}
NW_BLACKLIST_TYPE = {
    [0] = "SIM",
    [1] = "NETWORK",
}
NW_CELL_TYPE = {
    [0] = "NONE",
    [1] = "GSM",
    [2] = "CDMA",
    [3] = "LTE",
    [4] = "UMTS",
    [5] = "TD_SCDMA",
    [6] = "NR",
    [7] = "NSA_EXT",
}
NW_CH_LOCK = {
    [0] = "CANCEL",
    [1] = "ENABLE_CH_LK_EM",
    [2] = "ENABLE_CH_LK_CBRS",
    [3] = "CONFIG_CH_LK_CBRS",
}
NW_CH_LOCK_MODE = {
    [0] = "IDLE_MODE_ONLY",
    [1] = "IDLE_MR",
    [2] = "IDLE_HOCCO",
    [3] = "IDLE_AND_CONNECTED",
    [255] = "UNCHANGED",
}
NW_DATA_SPEED = {
    [0] = "NONE_SPECIFIED",
    [1] = "GPRS",
    [2] = "EDGE",
    [4] = "UMTS",
    [8] = "HSDPA",
    [16] = "HSUPA",
    [24] = "HSDPA_UPA",
    [32] = "HSDPAP",
    [48] = "HSDPAP_UPA",
    [64] = "HSUPAP",
    [72] = "HSUPAP_DPA",
    [96] = "HSPAP",
    [136] = "DC_DPA",
    [152] = "DC_DPA_UPA",
    [160] = "DC_HSDPAP",
    [176] = "DC_HSDPAP_UPA",
    [200] = "DC_HSUPAP_DPA",
    [224] = "DC_HSPAP",
    [256] = "1XRTT",
    [512] = "HRPD",
    [1024] = "EHRPD",
    [4096] = "LTE",
    [8192] = "LTE_CA",
    [16384] = "ENDC",
    [32768] = "NR",
    [65535] = "NOT_CHANGE",
}
NW_SIGNAL_TYPE = {
    [0] = "GSM",
    [1] = "UMTS",
    [2] = "LTE",
    [3] = "NR",
    [4] = "NR_NSA",
}
NW_CSCON_MODE = {
    [0] = "IDLE",
    [1] = "CONNECTED",
    [255] = "UNKNOWN",
}
NW_CSCON_STATE = {
    [0] = "UTRAN_URA_PCH",
    [1] = "UTRAN_CELL_PCH",
    [2] = "UTRAN_CELL_FACH",
    [3] = "UTRAN_CELL_DCH",
    [4] = "GERAN_CS_CONNECTED",
    [5] = "GERAN_PS_CONNECTED",
    [6] = "GERAN_CS_PS_CONNECTED",
    [7] = "EUTRAN_CONNECTED",
    [8] = "NR_RAN_CONNECTED",
    [8] = "NR_RAN_INACTIVE",
    [255] = "UNKNOWN",
}
NW_CSCON_ACCESS = {
    [0] = "GERAN",
    [1] = "UTRAN_TDD",
    [2] = "UTRAN_FDD",
    [3] = "EUTRAN_TDD",
    [4] = "EUTRAN_FDD",
    [5] = "NR",
    [255] = "UNKNOWN",
}
NW_CSCON_CORE_NETWORK = {
    [0] = "EPC",
    [1] = "5GCN",
    [255] = "UNKNOWN",
}
NW_PREFER_RAT_TYPE = {
    [1] = "GSM",
    [2] = "UMTS",
    [4] = "LTE",
    [128] = "NR",
}
NW_LTE_CARRIER_ARRREGATION_SWITCH = {
    [0] = "TURNOFF",
    [1] = "TURNON",
}
NW_PS_CS_REG_STATE = {
    [0] = "IN_SERVICE",
    [1] = "OUT_OF_SERVICE",
    [2] = "EMERGENCY_ONLY",
    [3] = "POWER_OFF",
}
NW_PS_CS_ROAMING_TYPE = {
    [0] = "NOT_ROAMING",
    [1] = "UNKNOWN",
    [2] = "DOMESTIC",
    [3] = "INTERNATIONAL",
}
NW_RIL_PS_CS_REG_STATE = {
    [0] = "NOT_REGISTERED_AND_NOT_SEARCHING",
    [1] = "HOME_NETWORK",
    [2] = "NOT_REGISTERED_AND_SEARCHING",
    [3] = "REG_DENIED",
    [4] = "UNKNOWN",
    [5] = "ROAMING",
    [6] = "GOOGLE_UNDEFINED1",
    [7] = "GOOGLE_UNDEFINED2",
    [8] = "GOOGLE_UNDEFINED3",
    [9] = "GOOGLE_UNDEFINED4",
    [10] = "NOT_REGISTERED_AND_NOT_SEARCHING_EMERGENCY_CALL_ENABLED",
    [11] = "GOOGLE_UNDEFINED5",
    [12] = "NOT_REGISTERED_AND_SEARCHING_EMERGENCY_CALL_ENABLED",
    [13] = "REG_DENIED_EMERGENCY_CALL_ENABLED",
    [14] = "UNKNOWN_EMERGENCY_CALL_ENABLED",
    [15] = "GOOGLE_UNDEFINED6",
}
NW_CELLMEASUREMENT_SCAN_TYPE = {
    [0] = "ONLINE_CUS_DEP",
    [1] = "OFFLINE",
    [2] = "ONLINE_NETWORK_DEP",
}
NW_BAND_OPTION = {
    [0] = "CURRENT_SETTING",
    [1] = "SYSTEM_SUPPORT",
}
NW_SIGNAL_THRESHOLD_MODE = {
    [0] = "MAP_VALUE",
    [1] = "RAW",
}
NW_ROAMING_MODE = {
    [0] = "DIS_NONE",
    [1] = "DIS_INTERNATIONAL",
    [2] = "DIS_NATIONAL",
    [4] = "DIS_H_P_PLMN_SEARCH",
}
NW_IND_TYPE = {
    [1] = "ECELL",
}
NW_RF_FAULT_CODE = {
    [1] = "RFC",
    [2] = "CALIBRATION",
    [3] = "OTHERS",
}
NW_RF_DEFECTIVE = {
    [0] = "INDEFECTIVE",
    [1] = "DEFECTIVE",
}
NW_TUW_ID = {
    [1] = "TUW1",
    [2] = "TUW2",
    [3] = "TUW3",
}
NW_ALLOWED_MCC_LIST_ACTION = {
    [0] = "DISABLE",
    [1] = "ENABLE",
}
SIM_STATUS = {
    [0] = "NOT_INSERT",
    [1] = "BUSY",
    [2] = "READY",
    [3] = "SIM_PIN",
    [4] = "SIM_PUK",
    [5] = "PH_SIM_PIN",
    [6] = "PH_FSIM_PIN",
    [7] = "PH_FSIM_PUK",
    [8] = "SIM_PIN2",
    [9] = "SIM_PUK2",
    [10] = "PH_NET_PIN",
    [11] = "PH_NET_PUK",
    [12] = "PH_NETSUB_PIN",
    [13] = "PH_NETSUB_PUK",
    [14] = "PH_SP_PIN",
    [15] = "PH_SP_PUK",
    [16] = "PH_CORP_PIN",
    [17] = "PH_CORP_PUK",
    [18] = "CARD_REBOOT",
    [19] = "CARD_RESTRICTED",
    [20] = "EMPT_EUICC",
    [21] = "COMPLETE_READY",
}
SIM_STATE = {
    [0] = "UNKNOWN",
    [1] = "OFFEMPTY",
    [2] = "OFF",
    [3] = "EMPTY",
    [4] = "NOTREADY",
    [5] = "ACTIVE",
    [6] = "ERROR",
    [7] = "ACTIVE_ESIM",
    [8] = "ACTIVE_ESIM_NOPROFILE",
}
SIM_CARD_PRESENT_STATE = {
    [0] = "ABSENT",
    [1] = "PRESENT",
    [2] = "ERROR",
    [3] = "RESTRICTED",
}
SIM_SUB_STATE = {
    [0] = "UNKNOWN",
    [1] = "PLUG_IN",
    [2] = "PLUG_OUT",
    [3] = "RECOVERY_START",
    [4] = "RECOVERY_EN",
}
SIM_PIN_TYPE = {
    [0] = "NONE",
    [1] = "PIN1",
    [2] = "PIN2",
    [3] = "PUK1",
    [4] = "PUK2",
    [5] = "NW",
    [6] = "SUB_NW",
    [7] = "SP",
    [8] = "CORP",
    [9] = "SIM",
    [10] = "NS_SP",
    [11] = "SIM_C",
    [12] = "PUK_N",
    [13] = "PUK_NS",
    [14] = "PUK_SP",
    [15] = "PUK_C",
    [16] = "PUK_SIM",
    [17] = "PUK_NS_SP",
    [18] = "PUK_SIM_C",
}
SIM_PIN_PROTECTION = {
    [0] = "DISABLE",
    [1] = "ENABLE",
}
SIM_PIN_MODE = {
    [0] = "NOT_SUPPORT",
    [1] = "ENABLE",
    [2] = "DISABLE",
}
SIM_PIN_FORMAT = {
    [0] = "UNKNOWN",
    [1] = "NUMERIC",
    [2] = "ALPHA_NUMERIC",
}
SIM_PIN_STATE = {
    [0] = "UNLOCKED",
    [1] = "LOCKED",
}
SIM_PIN_OPERATION = {
    [0] = "ENTER",
    [1] = "ENABLE",
    [2] = "DISABLE",
    [3] = "CHANGE",
}
SIM_PASS_THROUGH_MODE = {
    [0] = "DISABLE",
    [1] = "ENABLE",
}
SIM_APP_TYPE = {
    [0] = "UNKNOWN",
    [1] = "MF",
    [2] = "MFSIM",
    [3] = "MFRUIM",
    [4] = "USIM",
    [5] = "CSIM",
    [6] = "ISIM",
}
SIM_ACCESS_COMMAND = {
    [176] = "READ_BINARY",
    [178] = "READ_RECORD",
    [192] = "GET_RESPONSE",
    [214] = "UPDATE_BINARY",
    [220] = "UPDATE_RECORD",
    [242] = "STATUS",
    [203] = "RETRIEVE_DATA",
    [219] = "SET_DATA",
}
SIM_FILE_ACCESSIBILITY = {
    [0] = "UNKNOWN",
    [1] = "NOTSHAREABLE",
    [2] = "SHAREABLE",
}
SIM_FILE_TYPE = {
    [0] = "UNKNOWN",
    [1] = "WORKING_EF",
    [2] = "INTERNAL_EF",
    [3] = "DF_OR_ADF",
}
SIM_FILE_STRUCTURE = {
    [0] = "UNKNOWN",
    [1] = "TRANSPARENT",
    [2] = "CYCLIC",
    [3] = "LINEAR",
    [4] = "BERTLV",
}
SIM_ENABLED = {
    [0] = "UNKNOWN",
    [1] = "ENABLED_NOT_VERIFIED",
    [2] = "ENABLED_VERIFIED",
    [3] = "DISABLED",
    [4] = "ENABLED_BLOCKED",
    [5] = "ENABLED_PERM_BLOCKED",
}
SIM_APP_STATE = {
    [0] = "UNKNOWN",
    [1] = "DETECTED",
    [2] = "PIN",
    [3] = "PUK",
    [4] = "SUBSTATE",
    [5] = "READY",
}
SIM_APP_SUB_STATUS = {
    [0] = "UNKNOWN",
    [1] = "IN_PROGRESS",
    [2] = "READY",
    [3] = "NW",
    [4] = "NW_PUK",
    [5] = "SUB_NW",
    [6] = "SUB_NW_PUK",
    [7] = "CORP",
    [8] = "CORP_PUK",
    [9] = "SP",
    [10] = "SP_PUK",
    [11] = "IMSI",
    [12] = "IMSI_PUK",
}
SIM_CAUSE = {
    [0] = "CARD_REMOVED",
    [1] = "ACCESS_ERROR",
    [2] = "SIM_REFRESH",
    [3] = "SIM_REFRESH_POWER_OFF",
    [4] = "SIM_PUK1",
    [5] = "SIM_ACCESS_PROFILE_ON",
    [6] = "SIM_ACCESS_PROFILE_OFF",
    [7] = "DUAIL_DISCONNECTED",
    [8] = "DUAIL_CONNECTED",
    [9] = "SIM_VSIM_ON",
    [10] = "SIM_VSIM_OFF",
    [11] = "SIM_PLUG_OUT",
    [12] = "SIM_PLUG_IN",
    [13] = "SIM_RECOVERY_START",
    [14] = "SIM_RECOVERY_END",
    [15] = "SIM_IMEI_LOCK_FAIL",
    [16] = "SIM_OP09_LOCK_FAIL",
    [17] = "SIM_CARD_TECHNICAL_PROBLEM",
    [18] = "SIM_POWER_OFF_BY_L4",
    [19] = "SIM_OP20_IMEI_LOCK",
    [20] = "SIM_PLUG_IN_REPLACED",
    [21] = "SIM_OP01_LOCK",
    [22] = "SIM_OP01_UNLOCK",
    [23] = "SIM_FAST_RECOVERY_START",
    [24] = "SIM_FAST_RECOVERY_SUCCESS",
    [25] = "SIM_TRAY_PLUG_OUT",
    [26] = "SIM_PLUG_IN_NO_INIT",
    [27] = "SIM_PRESENCE_DETECTION_FAIL",
    [28] = "SIM_STATE_DISABLE",
    [29] = "SIM_STATE_ENABLE",
}
SIM_FCP_CONVERT = {
    [0] = "DISABLE",
    [1] = "ENABLE",
}
SMS_STATE = {
    [0] = "NOT_INITIALIZED",
    [1] = "INITIALIZED",
}
SMS_FORMAT = {
    [0] = "PDU",
    [1] = "TEXT",
    [2] = "CDMA",
    [4] = "PDU_3GPP2",
    [253] = "QUERY",
    [254] = "NULL",
    [255] = "INVALID",
}
SMS_CBM_TYPE = {
    [1] = "ETWS_PRIMARY",
    [2] = "ETWS_SECONDARY",
    [4] = "CMAS",
    [2147483648] = "OTHERS",
}
SMS_FLAG = {
    [0] = "ALL",
    [1] = "NEW",
    [2] = "OLD",
    [3] = "SENT",
    [4] = "DRAFT",
    [5] = "INDEX",
    [255] = "INVALID",
}
SMS_STATUS = {
    [0] = "REC_UNREAD",
    [1] = "REC_READ",
    [2] = "STO_UNSENT",
    [3] = "STO_SENT",
    [255] = "INVALID",
}
SMS_CLASS = {
    [0] = "0",
    [1] = "1",
    [2] = "2",
    [3] = "3",
    [254] = "NONE",
    [255] = "INVALID",
}
SMS_STORE_FLAG = {
    [0] = "NONE",
    [1] = "STORE_FULL",
    [2] = "NEW_MESSAGE",
}
SMS_STORAGE = {
    [0] = "SIM",
    [1] = "ME",
    [2] = "TE",
    [4] = "MT",
    [253] = "QUERY",
    [254] = "NULL",
    [255] = "INVALID",
}
SMS_ACK = {
    [0] = "NONEED",
    [1] = "NEEDED",
    [253] = "QUERY",
    [254] = "NULL",
    [255] = "INVALID",
}
NEW_SMS_ACK = {
    [0] = "RP_ACK",
    [1] = "RP_ERROR",
    [255] = "INVALID",
}
SMS_SEND_SAVE = {
    [0] = "NO_SAVE",
    [1] = "SAVE_IN_SIM",
    [255] = "INVALID",
}
SMS_MORE_MSG_TO_SEND = {
    [0] = "DISABLE",
    [1] = "ENABLE_ONCE",
    [2] = "ENABLE_ALWAYS",
    [254] = "NULL",
    [255] = "INVALID",
}
SMS_CBM_CFG_TYPE = {
    [1] = "ALLOW",
    [2] = "BAN",
    [253] = "QUERY",
}
SMS_SCBM_STATUS = {
    [0] = "EXIT",
    [1] = "ENTERED",
    [2] = "DISABLED",
    [3] = "REINITED",
}
SS_USSD = {
    [0] = "NO_ACTION_REQUIRED",
    [1] = "ACTION_REQUIRED",
    [2] = "TERMINATED_BY_NW",
    [3] = "OTHER_LOCAL_CLIENT",
    [4] = "OPERATION_NOT_SUPPORTED",
    [5] = "NW_TIME_OUT",
}
SS_SESSION = {
    [0] = "NEW",
    [1] = "EXISTING",
}
SS_CALL_WAITING = {
    [0] = "DISABLE",
    [1] = "ENABLE",
}
SS_SET_CALL_FORWARD_OPERATION_CODE = {
    [0] = "SS_ACTIVATE",
    [1] = "SS_DEACTIVATE",
    [3] = "SS_REGISTRATION",
    [4] = "SS_ERASURE",
}
SS_CALL_FORWARD_REASON = {
    [21] = "CALL_FORWARD_UNCONDITIONAL",
    [67] = "CALL_FORWARD_BUSY",
    [61] = "CALL_FORWARD_NO_REPLY",
    [62] = "CALL_FORWARD_NOT_REACHABLE",
    [2] = "CALL_FORWARD_ALL",
    [4] = "CALL_FORWARD_ALL_CONDITIONAL",
    [68] = "CALL_FORWARD_NOT_REGISTER",
}
SS_ACTIVE_STATUS = {
    [0] = "NOT_ACTIVE",
    [1] = "ACTIVE",
}
SS_TYPE_OF_ADDRESS = {
    [0] = "NORMAL",
    [1] = "INTERNATIONAL",
}
SS_SERVICE_CLASS = {
    [1] = "VOICE",
    [2] = "DATA",
    [4] = "FAX",
    [8] = "SMS",
    [16] = "DATA_CIRCUIT_SYNC",
    [32] = "DATA_CIRCUIT_ASYNC",
    [64] = "DEDICATED_PACKET_ACCESS",
    [128] = "DEDICATED_PAD_ACCESS",
    [256] = "MTK_LINE2",
    [512] = "MTK_VIDEO",
}
SS_CALL_BARRING_LOCK = {
    [0] = "UNLOCK",
    [1] = "LOCK",
}
SS_CALL_BARRING_FAC = {
    [0] = "AO",
    [1] = "OI",
    [2] = "OX",
    [3] = "AI",
    [4] = "IR",
    [5] = "AB",
    [6] = "AG",
    [7] = "AC",
}
STK_NOT_HANDLED = {
    [0] = "BY_FUNCTION_CANNOT_BE_HANDLED_BY_HOST",
    [1] = "By_FUNCTION_MAY_BE_HANDLED_BY_HOST",
}
STK_HANDLED = {
    [2] = "BY_FUNCTION_ONLY_TRANSPARENT_TO_HOST",
    [3] = "BY_FUNCTION_NOTIFICATION_TO_HOST_POSSIBLE",
    [4] = "BY_FUNCTION_NOTIFICATIONS_TO_HOST_ENABLE",
    [5] = "BY_FUNCTION_CAN_BE_OVERRIDDEN_BY_HOST",
    [6] = "BY_HOST_FUNCTION_NOT_ABLE_TO_HANDLE",
    [7] = "BY_HOST_FUNCTION_ABLE_TO_HANDLE",
}
STK_PAC_TYPE = {
    [0] = "PROACTIVE_COMMAND",
    [1] = "NOTIFICATION",
    [2] = "SESSION_END",
}
SIM_REFRESH_RESULT_TYPE = {
    [0] = "SIM_FILE_UPDATE",
    [1] = "SIM_INIT",
    [2] = "SIM_RESET",
    [3] = "APP_INIT",
    [4] = "SIM_INIT_FULL_FILE_CHANGE",
    [5] = "SIM_INIT_FILE_CHANGE",
    [6] = "SESSION_RESET",
}
RAN = {
    [0] = "UNKNOWN",
    [1] = "CELL",
    [2] = "WIFI",
}
CALL_CLCC_STATE = {
    [0] = "ACTIVE",
    [1] = "HELD",
    [2] = "DIALING",
    [3] = "ALERTING",
    [4] = "INCOMING",
    [5] = "WAITING",
}
CALL_DIRECTION = {
    [0] = "MO_CALL",
    [1] = "MT_CALL",
}
SDP_DIRECTION = {
    [0] = "INACTIVE",
    [1] = "SEND_ONLY",
    [2] = "RECV_ONLY",
    [3] = "SEND_RECV",
}
SPEECH_RAT = {
    [1] = "GSM",
    [2] = "UTMS",
    [4] = "IMS",
}
CALL_RAT = {
    [0] = "UNKNOWN",
    [1] = "CS",
    [2] = "VoLTE",
    [3] = "WFC",
}
CALL_TYPE = {
    [1] = "MPTY",
    [16] = "EMERGENCY",
    [256] = "VIDEO",
    [4096] = "RTT",
    [65536] = "IN_BAND_TONE",
    [1048576] = "TCH",
}
CALL_MODE = {
    [0] = "VOICE",
    [1] = "DATA",
    [3] = "VFD_VOICE",
    [4] = "AVD_VOICE",
    [5] = "AVF_VOICE",
    [6] = "VFD_DATA",
    [7] = "AVD_DATA",
    [9] = "UNKNOWN",
    [20] = "IMS_VOICE_CALL",
    [21] = "IMS_VIDEO_CALL",
    [22] = "IMS_VOICE_CONFERENCE",
    [23] = "IMS_VIDEO_CONFERENCE",
    [24] = "IMS_VOICE_CONFERENCE_PARTICIPANT",
    [25] = "IMS_VIDEO_CONFERENCE_PARTICIPANT",
    [40] = "C2K_VOICE_CALL",
    [41] = "C2K_OTASP_CALL_STD",
    [42] = "C2K_OTASP_CALL_NO_STD",
    [43] = "C2K_ECC_CALL",
}
CALL_DIAL_ADDRESS_TYPE = {
    [0] = "NONE",
    [1] = "SIP_URI",
    [2] = "NUMBER",
}
CALL_AUDIO_CODEC = {
    [0] = "NONE",
    [1] = "QCELP13K",
    [2] = "EVRC",
    [3] = "EVRC_B",
    [4] = "EVRC_WB",
    [5] = "EVRC_NW",
    [6] = "AMR_NB",
    [7] = "AMR_WB",
    [8] = "GSM_EFR",
    [9] = "GSM_FR",
    [10] = "GSM_HR",
    [23] = "EVS_NB",
    [24] = "EVS_WB",
    [25] = "EVS_SW",
    [32] = "EVS_FB",
    [33] = "EVS_AWB",
}
SDP_AUDIO_CODEC = {
    [1] = "AMR",
    [2] = "AMR_WB",
    [17] = "EVS",
}
CALL_EVENT = {
    [1] = "MT_REJECTED",
    [2] = "MT_REDIRECT",
    [3] = "SRVCC",
    [4] = "AUDIO_CODEC_CHANGE",
    [5] = "SPEECH_ATTACH",
    [6] = "CRING",
    [9] = "ECONFSRVCC",
}
CALL_MSG_TYPE = {
    [0] = "MT_CALL",
    [1] = "DISCONNECT",
    [2] = "ALERT",
    [3] = "CALL_PROCESS",
    [4] = "SYNC",
    [5] = "PROGRESS",
    [6] = "CONNECTED",
    [129] = "ALL_CALLS_DISC",
    [130] = "CALL_ID_ASSIGN",
    [131] = "STATE_CHANGE_HELD",
    [132] = "STATE_CHANGE_ACTIVE",
    [133] = "STATE_CHANGE_DISCONNECTED",
    [134] = "STATE_CHANGE_MO_DISCONNECTING",
    [135] = "STATE_HELD_BY_REMOTE",
    [136] = "STATE_ACTIVE_BY_REMOTE",
}
CALL_REJECT_REASON = {
    [0] = "UNDEFINED",
}
CALL_DIAL_TYPE = {
    [1] = "VOICE",
    [2] = "VIDEO",
    [3] = "EMERGENCY",
    [4] = "RTT",
}
CALL_CONFERENCE_DIAL_TYPE = {
    [1] = "VOICE",
    [2] = "VIDEO",
}
CALL_DIAL_DOMAIN = {
    [0] = "AUTO",
    [1] = "CS_ONLY",
    [2] = "3GPP_ONLY",
    [3] = "3GPP2_ONLY",
}
CALL_SS_ACTION = {
    [0] = "RELEASE_ALL_HELD_OR_WAITING_CALL",
    [1] = "RELEASE_ALL_ACTIVE_AND_ACCEPT_CALL",
    [2] = "PLACE_ALL_ACTIVE_CALL_ON_HOLD_AND_ACCEPT_CALL",
    [4] = "EXPLICIT_CALL_AND_TRANSFER",
    [5] = "COMPLETION_CALL_BUSY_SUBSCRIBER",
    [131] = "HOLD_CALL",
    [132] = "RESUME_CALL",
}
CALL_CONF_ACTION = {
    [0] = "MERGE",
    [1] = "ADD_PARTICIPANT",
    [2] = "REMOVE_PARTICIPANT",
    [3] = "SPLIT",
}
CALL_HANGUP_MODE = {
    [0] = "HANGUP",
    [1] = "HANGUP_ALL",
    [2] = "FORCE_HANGUP",
}
CALL_HANGUP_CAUSE = {
    [0] = "USER_HANGUP",
    [1] = "IMS_NO_COVERAGE",
    [2] = "IS_LOW_BATTERY",
    [3] = "IMS_FORWARD",
    [4] = "IMS_SPECIAL_HUNGUP",
    [5] = "IMS_607_UNWANTED",
    [6] = "CS_INCOMING_REJECTED_NO_FORWARD",
}
CALL_ANSWER_MODE = {
    [0] = "DEFAULT",
    [1] = "AUDIO_CALL",
    [2] = "Rx_VIDEO_CALL",
    [3] = "Tx_VIDEO_CALL",
}
CALL_SS_CODE1 = {
    [0] = "UCF_ACTIVE",
    [1] = "CCF_ACTIVE",
    [2] = "FORWARDED_CALL",
    [3] = "WAITING_CALL",
    [4] = "CUG_CALL",
    [5] = "OUTGOING_CALLS_ARE_BARRED",
    [6] = "INCOMING_CALLS_ARE_BARRED",
    [7] = "CLIR_SUPPRESSION_REJECTED",
    [8] = "DEFLECTED_CALL",
}
CALL_SS_CODE2 = {
    [0] = "FORWARDED_CALL",
    [1] = "CUG_CALL",
    [2] = "HOLD_CALL",
    [3] = "RETRIEVED_CALL",
    [4] = "MULTIPARTY_CALL",
    [5] = "HOLD_CALL_HAS_BEEN_RELEASEED",
    [6] = "FORWARD_CHECK_SS_MSG_RECEIVED",
    [7] = "CONNECTED_CALL_WITH_REMOTE_PARTY_IN_ALERTING",
    [8] = "CONNECTED_CALL_WITH_REMOTE_PARTY_IN_EXPLICIT_CALL_TRANSFER",
    [9] = "DEFLECTED_CALL",
    [10] = "ADDITIONAL_INCOMING_CALL_FORWARDED",
    [11] = "CALL_FORWARDED",
    [12] = "CALL_FORWARDED_UNCONDITIONAL",
    [13] = "CALL_FORWARDED_CONDITIONAL",
    [14] = "CALL_BUSY_FORWARDED",
    [15] = "CALL_FORWARDED_ON_NO_REPLY",
    [16] = "CALL_FORWARDED_ON_NOT_REACHABLE",
}
CONF_PARTICIPANT_STATUS = {
    [0] = "PENDING",
    [1] = "DIALING_OUT",
    [2] = "DIALING_IN",
    [3] = "ALERTING",
    [4] = "ON_HOLD",
    [5] = "CONNECTED",
    [6] = "DISCONNECTING",
    [7] = "DISCONNECTED",
    [8] = "MUTED_VIA_FOCUS",
    [9] = "CONNECT_FAIL",
}
SIP_DIRECTION = {
    [0] = "SEND",
    [1] = "RECEIVE",
}
SIP_MSG_TYPE = {
    [0] = "REQUEST",
    [1] = "RESPONSE",
}
SIP_METHOD = {
    [1] = "INVITE",
    [2] = "REFER",
    [3] = "UPDATE",
    [4] = "CANCEL",
    [5] = "MESSAGE",
    [6] = "ACK",
    [7] = "BYE",
    [8] = "OPTIONS",
    [9] = "SUBSCRIBE",
    [10] = "NOTIFY",
    [11] = "PUBLISH",
    [12] = "INFO",
    [13] = "PRACK",
}
IMS_EVENT_PACKAGE_TYPE = {
    [1] = "CONFERENCE",
    [2] = "DIALOG",
    [3] = "MWI",
}
ECC_INFO_TYPE = {
    [0] = "HOST",
    [1] = "SIM",
    [2] = "MCF",
}
DTMF_MODE = {
    [0] = "START",
    [1] = "STOP",
    [2] = "SINGLE_TONE",
}
CALL_ECBM_MODE = {
    [0] = "ECBM_OFF",
    [1] = "ECBM_ON",
    [2] = "NO_ECBM",
}
CALL_CLI_VALIDITY = {
    [0] = "CLI_VALID",
    [1] = "CLI_WITHHELD",
    [2] = "CLI_INTERWORK",
    [3] = "CLI_PAYPHONE",
    [4] = "CLI_OTHERS",
}
CALL_CNI_VALIDITY = {
    [0] = "CNI_VALID",
    [1] = "CNI_WITHHELD",
    [2] = "CNI_INTERWORK",
    [3] = "CNI_PAYPHONE",
    [4] = "CNI_OTHERS",
}
CRSS_TYPE = {
    [0] = "CRSS_CALL_WAITING",
    [1] = "CRSS_CALLING_LINE_ID_PRESET",
    [2] = "CRSS_CALLED_LINE_ID_PRESET",
    [3] = "CRSS_CONNECTED_LINE_ID_PRESET",
    [4] = "CDMA_CALL_WAITING",
    [5] = "CDMA_CALLING_LINE_ID_PRESET",
}
NUMBER_PRESENTATION = {
    [0] = "ALLOWED",
    [1] = "RESTRICTED",
    [2] = "UNKNOWN",
}
NUMBER_TYPE = {
    [0] = "UNKNOWN",
    [1] = "INTERNATIONAL",
    [2] = "NATIONAL",
}
ECALL_TYPE = {
    [0] = "TEST",
    [1] = "RECOFIG",
    [2] = "MANUAL",
    [3] = "AUTO",
}
ECALL_MSD_FORMAT = {
    [1] = "BINARY",
}
ECALL_ADDRESS_PRIORITY_CLASS = {
    [1] = "CUSTOM_ECALL_URI",
    [2] = "USIM_ECALL_URI",
    [3] = "CUSTOM_ECALL_NUM",
    [4] = "USIM_ECALL_NUM",
}
ECALL_SIM_TYPE = {
    [0] = "NORMAL",
    [1] = "ECALL_ONLY",
    [2] = "ECALL_AND_NORMAL",
}
ECALL_STATUS = {
    [1] = "START",
    [2] = "SENDING_MSD",
    [3] = "LLACK",
    [4] = "ALACK_POSITIVE",
    [5] = "ALACK_CLEARDOWN",
    [11] = "CONNECTED",
    [12] = "DISCONNECTED",
    [13] = "IMS_CONNECTED",
    [14] = "IMS_DISCONNECTED",
    [15] = "ABNORMAL_HANGUP",
    [20] = "IMS_MSD_ACK",
    [21] = "IMS_UPDATE_MSD",
    [22] = "IMS_IN_BAND_TRANSFER",
    [23] = "IMS_MSD_NACK",
    [24] = "IMS_SRVCC",
    [31] = "ECALL_ONLY_DEREG",
    [40] = "PSAP_CALLBACK_START",
    [41] = "PSAP_CALLBACK_IMS_UPDATE_MSD",
    [255] = "UNSPECIFIED",
}
RESULT = {
    [0] = "SUCCESS",
    [1] = "BUSY",
    [2] = "FAILURE",
    [3] = "SIM_NOT_INSERTED",
    [4] = "BAD_SIM",
    [5] = "PIN_REQUIRED",
    [6] = "PIN_DISABLED",
    [7] = "NOT_REGISTERED",
    [8] = "PROVIDERS_NOT_FOUND",
    [9] = "NO_DEVICE_SUPPORT",
    [10] = "PROVIDER_NOT_VISIBLE",
    [11] = "DATA_CLASS_NOT_AVAILABLE",
    [12] = "PACKET_SERVICE_DETACHED",
    [13] = "MAX_ACTIVATED_CONTEXTS",
    [14] = "NOT_INITIALIZED",
    [15] = "VOICE_CALL_IN_PROGRESS",
    [16] = "CONTEXT_NOT_ACTIVATED",
    [17] = "SERVICE_NOT_ACTIVATED",
    [18] = "INVALID_ACCESS_STRING",
    [19] = "INVALID_USERID_PASSWORD",
    [20] = "RADIO_POWER_OFF",
    [21] = "INVALID_PARAMETERS",
    [22] = "READ_FAILURE",
    [23] = "WRITE_FAILURE",
    [24] = "Reserved_24",
    [25] = "NO_PHONEBOOK",
    [26] = "PARAMETER_TOO_LONG",
    [27] = "STK_BUSY",
    [28] = "OPERATION_NOT_ALLOWED",
    [29] = "MEMORY_FAILURE",
    [30] = "INVALID_MEMORY_INDEX",
    [31] = "MEMORY_FULL",
    [32] = "FILTER_NOT_SUPPORTED",
    [33] = "DSS_INSTANCE_LIMIT",
    [34] = "INVALID_DEVICE_SERVICE_OPERATION",
    [35] = "AUTH_INCORRECT_AUTN",
    [36] = "AUTH_SYNC_FAILURE",
    [37] = "AUTH_AMF_NOT_SET",
    [38] = "CONTEXT_NOT_SUPPORTED",
    [100] = "SMS_UNKNOWN_SMSC_ADDRESS",
    [101] = "SMS_NETWORK_TIMEOUT",
    [102] = "SMS_LANG_NOT_SUPPORTED",
    [103] = "SMS_ENCODING_NOT_SUPPORTED",
    [104] = "SMS_FORMAT_NOT_SUPPORTED",
    [262143] = "COMMON_END",
    [524288] = "CAT_EXT_BEGIN",
    [786431] = "CAT_EXT_END",
    [786432] = "CC_EXT_BEGIN",
    [786433] = "CC_CALL_FORCE_RELEASED_BEFORE",
    [1048575] = "CC_EXT_END",
    [1048576] = "NW_EXT_BEGIN",
    [1310719] = "NW_EXT_END",
    [1310720] = "PDN_EXT_BEGIN",
    [1310720] = "PDN_EXT_NETWORK_ERROR_BEGIN",
    [1310820] = "PDN_EXT_CME_ERROR_BEGIN",
    [1310920] = "PDN_EXT_CME_ERROR_END",
    [1313792] = "PDN_EXT_NETWORK_SM_CAUSE_BEGIN",
    [1313793] = "PDN_EXT_NETWORK_SM_CAUSE_EMPTY",
    [1313800] = "PDN_EXT_NETWORK_SM_CAUSE_OPERATOR_DETERMINED_BARRING",
    [1313817] = "PDN_EXT_NETWORK_SM_CAUSE_LLC_SND_FAILURE",
    [1313818] = "PDN_EXT_NETWORK_SM_CAUSE_INSUFF_RESOURCE",
    [1313819] = "PDN_EXT_NETWORK_SM_CAUSE_UNKNOWN_APN",
    [1313820] = "PDN_EXT_NETWORK_SM_CAUSE_UNKNOWN_PDP_ADDR_OR_TYPE",
    [1313821] = "PDN_EXT_NETWORK_SM_CAUSE_AUTHENTICATION_FAILURE",
    [1313822] = "PDN_EXT_NETWORK_SM_CAUSE_ACTIVATION_REJ_GGSN",
    [1313823] = "PDN_EXT_NETWORK_SM_CAUSE_ACTIVATION_REJ_UNSPECIFIED",
    [1313824] = "PDN_EXT_NETWORK_SM_CAUSE_UNSUPPORTED_SERVICE_OPTION",
    [1313825] = "PDN_EXT_NETWORK_SM_CAUSE_UNSUBSCRIBED_SERVICE_OPTION",
    [1313826] = "PDN_EXT_NETWORK_SM_CAUSE_SERVICE_OPTION_TEMPORARILY_OUT_OF_ORDER",
    [1313827] = "PDN_EXT_NETWORK_SM_CAUSE_PTI_ALREADY_USED",
    [1313828] = "PDN_EXT_NETWORK_SM_CAUSE_REGULAR_DEACTIVATION",
    [1313829] = "PDN_EXT_NETWORK_SM_CAUSE_QOS_NOT_ACCEPTED",
    [1313830] = "PDN_EXT_NETWORK_SM_CAUSE_NETWORK_FAIL",
    [1313831] = "PDN_EXT_NETWORK_SM_CAUSE_REACTIVATION_REQD",
    [1313832] = "PDN_EXT_NETWORK_SM_CAUSE_UNSUPPORTED_NW_CONTEXT_ACTIVATION",
    [1313833] = "PDN_EXT_NETWORK_SM_CAUSE_SEMANTIC_ERROR_IN_TFT_OP",
    [1313834] = "PDN_EXT_NETWORK_SM_CAUSE_SYNTACTICAL_ERROR_IN_TFT_OP",
    [1313835] = "PDN_EXT_NETWORK_SM_CAUSE_UNKNOWN_PDP_CONTEXT",
    [1313836] = "PDN_EXT_NETWORK_SM_CAUSE_SEMANTIC_ERROR_IN_PACKET_FILTER",
    [1313837] = "PDN_EXT_NETWORK_SM_CAUSE_SYNTAX_ERROR_IN_PACKET_FILTER",
    [1313838] = "PDN_EXT_NETWORK_SM_CAUSE_PDP_CONTEXT_WO_TFT_ALREADY_ACT",
    [1313839] = "PDN_EXT_NETWORK_SM_CAUSE_PTI_MISMATCH",
    [1313840] = "PDN_EXT_NETWORK_SM_CAUSE_ACTIVATION_REJ_BCM_VIOLATION",
    [1313841] = "PDN_EXT_NETWORK_SM_CAUSE_LAST_PDN_DISC_NOT_ALLOWED",
    [1313842] = "PDN_EXT_NETWORK_SM_CAUSE_PDP_TYPE_IPV4_ONLY_ALLOWED",
    [1313843] = "PDN_EXT_NETWORK_SM_CAUSE_PDP_TYPE_IPV6_ONLY_ALLOWED",
    [1313844] = "PDN_EXT_NETWORK_SM_CAUSE_SINGLE_ADDR_BEARERS_ONLY_ALLOWED",
    [1313845] = "PDN_EXT_NETWORK_SM_CAUSE_ESM_INFORMATION_NOT_RECEIVED",
    [1313846] = "PDN_EXT_NETWORK_SM_CAUSE_PDN_CONNENCTION_NOT_EXIST",
    [1313847] = "PDN_EXT_NETWORK_SM_CAUSE_MULTIPLE_PDN_APN_NOT_ALLOWED",
    [1313848] = "PDN_EXT_NETWORK_SM_CAUSE_COLLISION_WITH_NW_INITIATED_REQ",
    [1313851] = "PDN_EXT_NETWORK_SM_CAUSE_UNSUPPORTED_QCI_VALUE",
    [1313857] = "PDN_EXT_NETWORK_SM_CAUSE_MAXIMUM_NUM_OF_PDP_CONTEXTS_REACHED",
    [1313858] = "PDN_EXT_NETWORK_SM_CAUSE_REQUESTED_APN_NOT_SUPPORTED_IN_CURRENT_RAT_AND_PLMN_COMBINATION",
    [1313873] = "PDN_EXT_NETWORK_SM_CAUSE_INVALID_TI",
    [1313887] = "PDN_EXT_NETWORK_SM_CAUSE_SM_SEMANTICALLY_INCORRECT_MSG",
    [1313888] = "PDN_EXT_NETWORK_SM_CAUSE_INVALID_MAND_INFO",
    [1313889] = "PDN_EXT_NETWORK_SM_CAUSE_SM_MSG_TYPE_NON_EXISTENT_OR_NOT_IMPLEMENTED",
    [1313890] = "PDN_EXT_NETWORK_SM_CAUSE_SM_MSG_TYPE_NOT_COMPATIBLE_WITH_PROTOCOL_STATE",
    [1313891] = "PDN_EXT_NETWORK_SM_CAUSE_IE_NON_EXISTENCE_OR_NOT_IMPLEMENTED",
    [1313892] = "PDN_EXT_NETWORK_SM_CAUSE_CONDITIONAL_IE_ERROR",
    [1313893] = "PDN_EXT_NETWORK_SM_CAUSE_SM_MSG_NOT_COMPATIBLE_WITH_PROTOCOL_STATE",
    [1313903] = "PDN_EXT_NETWORK_SM_CAUSE_SM_PROTOCOL_ERROR_UNSPECIFIED",
    [1313904] = "PDN_EXT_NETWORK_SM_CAUSE_APN_RESTRICTION_VALUE_INCOMPATIBLE_WITH_ACTIVE_PDP_CTX",
    [1313905] = "PDN_EXT_NETWORK_SM_CAUSE_END",
    [1314048] = "PDN_EXT_NETWORK_ESM_CAUSE_BEGIN",
    [1314049] = "PDN_EXT_NETWORK_ESM_CAUSE_NO_CAUSE",
    [1314056] = "PDN_EXT_NETWORK_ESM_CAUSE_OPERATOR_DETERMINED_BARRING",
    [1314074] = "PDN_EXT_NETWORK_ESM_CAUSE_INSUFFICIENT_RESOURCES",
    [1314075] = "PDN_EXT_NETWORK_ESM_CAUSE_UNKNOWN_OR_MISSING_APN",
    [1314076] = "PDN_EXT_NETWORK_ESM_CAUSE_UNKNOWN_PDN_TYPE",
    [1314077] = "PDN_EXT_NETWORK_ESM_CAUSE_USER_AUTH_FAILED",
    [1314078] = "PDN_EXT_NETWORK_ESM_CAUSE_REQUEST_REJECTED_BY_SGW_OR_PDNGW ",
    [1314079] = "PDN_EXT_NETWORK_ESM_CAUSE_REQUEST_REJECTED_UNSPECIFIED",
    [1314080] = "PDN_EXT_NETWORK_ESM_CAUSE_SERVICE_OPT_NOT_SUPPORTED",
    [1314081] = "PDN_EXT_NETWORK_ESM_CAUSE_REQ_SERVICE_NOT_SUBSCRIBED",
    [1314082] = "PDN_EXT_NETWORK_ESM_CAUSE_SERVICE_TEMP_OUT_OF_ORDER",
    [1314083] = "PDN_EXT_NETWORK_ESM_CAUSE_PTI_ALREADY_USED",
    [1314084] = "PDN_EXT_NETWORK_ESM_CAUSE_REGULAR_DEACTIVATION",
    [1314085] = "PDN_EXT_NETWORK_ESM_CAUSE_EPS_QOS_NOT_ACCEPTED",
    [1314086] = "PDN_EXT_NETWORK_ESM_CAUSE_NETWORK_FAILURE",
    [1314087] = "PDN_EXT_NETWORK_ESM_CAUSE_REACTIVATION_REQUESTED",
    [1314089] = "PDN_EXT_NETWORK_ESM_CAUSE_SEMANTIC_ERROR_IN_TFT",
    [1314090] = "PDN_EXT_NETWORK_ESM_CAUSE_SYNTACTIC_ERROR_IN_TFT",
    [1314091] = "PDN_EXT_NETWORK_ESM_CAUSE_INVALID_EPS_BEARER_IDENTITY",
    [1314092] = "PDN_EXT_NETWORK_ESM_CAUSE_SEMANTIC_ERROR_IN_PACKET_FILTERS",
    [1314093] = "PDN_EXT_NETWORK_ESM_CAUSE_SYNTACTIC_ERROR_IN_PACKET_FILTERS",
    [1314094] = "PDN_EXT_NETWORK_ESM_CAUSE_EPSB_CTXT_WITHOUT_TFT_ACTIVATED",
    [1314095] = "PDN_EXT_NETWORK_ESM_CAUSE_PTI_MISMATCH",
    [1314097] = "PDN_EXT_NETWORK_ESM_CAUSE_LAST_PDN_DISC_NOT_ALLOWED",
    [1314098] = "PDN_EXT_NETWORK_ESM_CAUSE_PDN_TYPE_IPV4_ONLY_ALLOWED",
    [1314099] = "PDN_EXT_NETWORK_ESM_CAUSE_PDN_TYPE_IPV6_ONLY_ALLOWED",
    [1314100] = "PDN_EXT_NETWORK_ESM_CAUSE_SINGLE_ADDRESS_ONLY_ALLOWED",
    [1314101] = "PDN_EXT_NETWORK_ESM_CAUSE_ESM_INFORMATION_NOT_RECEIVED",
    [1314102] = "PDN_EXT_NETWORK_ESM_CAUSE_PDN_CONNENCTION_NOT_EXIST",
    [1314103] = "PDN_EXT_NETWORK_ESM_CAUSE_MULTIPLE_PDN_APN_NOT_ALLOWED",
    [1314104] = "PDN_EXT_NETWORK_ESM_CAUSE_COLLISION_WITH_NW_INIT_REQUESTD",
    [1314107] = "PDN_EXT_NETWORK_ESM_CAUSE_UNSUPPORTED_QCI_VALUE",
    [1314113] = "PDN_EXT_NETWORK_ESM_CAUSE_MAXIMUM_NUM_OF_EPS_BEARERS_REACHED",
    [1314114] = "PDN_EXT_NETWORK_ESM_CAUSE_ESM_REQUESTED_APN_NOT_SUPPORTED_IN_CURRENT_RAT_AND_PLMN_COMBINATION",
    [1314129] = "PDN_EXT_NETWORK_ESM_CAUSE_INVALID_PTI_VALUE",
    [1314143] = "PDN_EXT_NETWORK_ESM_CAUSE_SEMANTIC_INCORRECT_MSG",
    [1314144] = "PDN_EXT_NETWORK_ESM_CAUSE_INVALID_MANDATORY_IE",
    [1314145] = "PDN_EXT_NETWORK_ESM_CAUSE_MSG_TYPE_NON_EXISTENT",
    [1314146] = "PDN_EXT_NETWORK_ESM_CAUSE_MSG_TYPE_NOT_COMPATIBLE_STATE",
    [1314147] = "PDN_EXT_NETWORK_ESM_CAUSE_IE_NON_EXISTENT_NOT_IMPLEMENTED",
    [1314148] = "PDN_EXT_NETWORK_ESM_CAUSE_CONDITIONAL_IE_ERROR",
    [1314149] = "PDN_EXT_NETWORK_ESM_CAUSE_MSG_NOT_COMPATIBLE_STATE",
    [1314159] = "PDN_EXT_NETWORK_ESM_CAUSE_PROTOCOL_ERROR_UNSPECIFIED",
    [1314160] = "PDN_EXT_NETWORK_ESM_CAUSE_APN_RESTRICT_VALUE_INCOMPATIBLE ",
    [1314161] = "PDN_EXT_NETWORK_ESM_CAUSE_END",
    [1314560] = "PDN_EXT_NETWORK_TCM_CAUSE_BEGIN",
    [1314561] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_ACT_WITH_CID_UNEXPECTED",
    [1314562] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_ACT_WITH_CID_NOT_DEFINED",
    [1314563] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_ACT_WITH_FSM_UNEXPECTED",
    [1314564] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_ACT_WITH_CID_SECONDARY_WITHOUT_TFT",
    [1314565] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_ACT_WITH_PRIMARY_IS_NOT_ACTIVATED",
    [1314566] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_DEACT_WITH_CID_UNEXPECTED",
    [1314567] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_DEACT_WITH_FSM_UNEXPECTED",
    [1314568] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_DEACT_WITH_ACTIVATED_FROM_UNEXPECTED",
    [1314569] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_MODIFY_WITH_CID_UNEXPECTED",
    [1314570] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_MODIFY_WITH_FSM_UNEXPECTED",
    [1314571] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_MODIFY_WITH_NO_QOS_OR_TFT_SET",
    [1314572] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_CGDATA_WITH_CID_UNEXPECTED",
    [1314573] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_CGDATA_WITH_FSM_UNEXPECTED",
    [1314574] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DCONT_CID_UNEXPECTED",
    [1314575] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DCONT_NOT_ALLOW_FOR_PPP_TYPE",
    [1314576] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DCONT_INVALID_PARAMETER",
    [1314577] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DCONT_INVALID_PDP_TYPE",
    [1314578] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DCONT_CID_ALREADY_IN_USE",
    [1314579] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DCONT_INVALID_APN",
    [1314580] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DSCONT_CID_UNEXPECTED",
    [1314581] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DSCONT_INVALID_PARAMETER",
    [1314582] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DSCONT_CID_PRIMARY_IS_NOT_IN_USE",
    [1314583] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DSCONT_CID_PRIMARY_IS_NOT_ACTIVATED",
    [1314584] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DSCONT_NOT_ALLOW_FOR_PPP_TYPE",
    [1314585] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DSCONT_CID_ALREADY_IN_USE",
    [1314586] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_PRCO_CID_ALREADY_IN_USE",
    [1314587] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_PRCO_CID_UNEXPECTED",
    [1314588] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_ACT_NOT_SUPPORT_EMERGENCY_BEARER_ACTIVATION",
    [1314589] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_ACT_ALLOC_NSAPI_FAIL",
    [1314590] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DEACT_IND_BY_TIMER_EXPIRY",
    [1314591] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DEACT_IND_BY_NO_USER_RESPONSE_TILL_RAT_CHANGE_COMPLETE_IND",
    [1314592] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_MOD_PRESERVED_PDP_CONTEXT",
    [1314593] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_MOD_CHECK_TFT_FAIL",
    [1314594] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_MOD_REJ_DUE_TO_DEACT_IND",
    [1314595] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_SET_MULTI_PDN_SUCCESS",
    [1314596] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_SET_MULTI_PDN_CID_UNEXPECTED",
    [1314597] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_SET_MULTI_PDN_PARA_UNEXPECTED",
    [1314598] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_SET_MULTI_PDN_INVALID_PDP_TYPE_AND_LEN",
    [1314599] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_SET_MULTI_PDN_INVALID_APN",
    [1314600] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_PPP_CHECKED_ACT_WITH_CID_UNEXPECTED",
    [1314601] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_PPP_CHECKED_ACT_WITH_PDP_TYPE_LEN_UNEXPECTED",
    [1314602] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_PPP_CHECKED_ACT_WITH_INVALID_CONFIG_PROTOCOL",
    [1314603] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_PPP_CHECKED_ACT_WITH_CID_NOT_DEFINED",
    [1314604] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_PPP_CHECKED_ACT_WITH_FSM_UNEXPECTED",
    [1314605] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_PPP_CHECKED_DEACT_WITH_CID_UNEXPECTED",
    [1314606] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_PPP_CHECKED_DEACT_WITH_FSM_UNEXPECTED",
    [1314607] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_PPP_CHECKED_DEACT_WITH_ACTIVATED_FROM_UNEXPECTED",
    [1314608] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_PPP_CHECKED_CGDATA_WITH_CID_UNEXPECTED",
    [1314609] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_PPP_CHECKED_CGDATA_WITH_FSM_UNEXPECTED",
    [1314610] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_DISPATCH_PDP_ACT_CHECK_TFT_FAIL",
    [1314611] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_UPCM_BIND_CNF_BEARER_HAS_BEEN_DEACTIVATED_ALREADY",
    [1314612] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_UPCM_UNBIND_CNF_BEARER_HAS_BEEN_DEACTIVATED_ALREADY",
    [1314613] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ACL_APN_NOT_EXIST_IN_ACL",
    [1314614] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ACL_ACTION_NOT_ALLOWED",
    [1314615] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ACL_SIM_FILE_FULL",
    [1314616] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ACL_ADD_ENTRY_FAILED",
    [1314617] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ACL_DEL_ENTRY_FAILED",
    [1314618] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ACL_SET_ENTRY_FAILED",
    [1314619] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ACL_SIM_READ_FAILED",
    [1314620] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ACL_SIM_WRITE_FAILED",
    [1314621] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_CAUSE_START",
    [1314622] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_FAIL_CAUSE_EMPTY",
    [1314623] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_USER_CANCEL",
    [1314624] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_CID_ALREADY_CONNECT",
    [1314625] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_PDN_NOT_ACTIVATED",
    [1314626] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_BEARER_NOT_ACTIVATED",
    [1314627] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_RMV_LAST_PDN_NOT_ALLOWED",
    [1314628] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_LOCAL_RELEASE",
    [1314629] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_DETACH",
    [1314630] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_IE_ERROR",
    [1314631] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_TIMER_TIMEOUT",
    [1314632] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_TX_FAILURE",
    [1314633] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_FAIL_CAUSE_RAT_CHANGE",
    [1314634] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_FAIL_CAUSE_PS_SWITCH",
    [1314635] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_ACTION_NOT_ALLOWED",
    [1314636] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_FAIL_CAUSE_T3346_CONGESTION",
    [1314637] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_FAIL_CAUSE_THROTTLING_RUNNING",
    [1314638] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_FAIL_CAUSE_SERIOUS_ERROR_AT_LOW_LAYER",
    [1314639] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_FAIL_CAUSE_OTHERS",
    [1314640] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_CAUSE_END",
    [1314641] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_RETRY_NEEDED_AFTER_IRAT_IF_IN_3GPP",
    [1314642] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_LOCAL_REJECTED_DUE_TO_PS_SWITCH",
    [1314643] = "PDN_EXT_NETWORK_TCM_CAUSE_AP_RETRY_NEEDED_AFTER_LTE_TO_C2K_IRAT",
    [1314644] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_DEACT_SUCCESS_DUE_TO_CONTEXT_NEVER_ACTIVATED",
    [1314645] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_MODIFY_FAIL_DUE_TO_CONTEXT_DEACTIVATED",
    [1314646] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_MODIFY_FAIL_DUE_TO_CONTEXT_NOT_ACTIVATED",
    [1314647] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_DEACTIVATED_DUE_TO_NAS_TFT_TRIGGERED_DEACTIVATION",
    [1314648] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_23G_MT_PRIMARY_PDP_IS_ABORTED_DUE_TO_CHANGE_TO_4G",
    [1314649] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_DEACTIVATE_SUCCESS_IMMEDIATELY_BECAUSE_ACTIVATION_IS_NOT_PROCESSED_BY_TCM_YET",
    [1314650] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_EGACT_ACTIVATE_REJ_DUE_TO_ERROR_RAT",
    [1314651] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_EGACT_DEACTIVATE_REJ_DUE_TO_ERROR_RAT",
    [1314652] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_DEACTIVATED_DUE_TO_INACTIVITY_TIMER_TIMEOUT",
    [1314653] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ETCM_CID_NOT_DEFINE_TFT_QOS",
    [1314654] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ETCM_CID_IS_NOT_PRIMARY",
    [1314655] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ETCM_TFT_VALIDATION_ERROR",
    [1314656] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ETCM_PTI_IS_FULL",
    [1314657] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_EGLD_WITH_CID_UNEXPECTED",
    [1314658] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_EGLD_WITH_FSM_UNEXPECTED",
    [1314659] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_EAPNSYNC_WRONG_APN_IDX",
    [1314660] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_EAPNSYNC_APN_TOO_LONG",
    [1314661] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_EAPNSYNC_TOO_MUCH_APN_SETTING",
    [1314662] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_MOD_PRIMARY_QOS_IS_NOT_ALLOWED",
    [1314663] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_MOD_QOS_FOR_NO_MS_PF_IS_NOT_ALLOWED",
    [1314667] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_ACT_FAIL_DUE_TO_IRAT_ONGOING",
    [1314668] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_MODIFY_FAIL_DUE_TO_IRAT_ONGOING",
    [1314669] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_DEACT_FAIL_DUE_TO_IRAT_ONGOING",
    [1314670] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_LOCAL_REJECTED_DUE_TO_FSM_UNEXPECTED",
    [1314671] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_LOCAL_REJECTED_DUE_TO_GUARANTEE_RSPONSE_TIME_TIMEOUT",
    [1314672] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_REGION_2_CAUSE_START",
    [1314673] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_CID_INVALID",
    [1314674] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_CID_ALREADY_IN_ACTION",
    [1314675] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_ACT_WITH_UNEXPECTED_LTE_ATTACH_PDN_IN_23G",
    [1314676] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_UGTCM_DEACT_DUE_TO_USER_FORCE_TO_LOCAL_RELEASE",
    [1314677] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_ACT_NOT_SUPPORT_HANDOVER_OF_EMERGENCY_BEARER",
    [1314678] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_UGTCM_DEACT_DUE_TO_AOSP_SHUTDOWN",
    [1314679] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_UGTCM_DEACT_DUE_TO_AOSP_HANDOVER",
    [1314680] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_FAIL_CAUSE_GEMINI_SUSPEND",
    [1314681] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_FAIL_CAUSE_GEMINI_FAILURE",
    [1314682] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_FAIL_CAUSE_GEMINI_SUSPEND_DUE_TO_CALL_ONGOING",
    [1314683] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_UGTCM_DEACT_DUE_TO_APN_CHANGED",
    [1314684] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_DETACH_REATTACH",
    [1314685] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_VGTCM_DEACT_DUE_TO_AOSP_SHUTDOWN",
    [1314686] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_FAIL_CAUSE_REQ_RES_APN_MISMATCH",
    [1314687] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_UGTCM_DEACT_DUE_TO_IMS_HANDOVER",
    [1314702] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_DEACT_DUE_TO_DRB_RELEASE",
    [1314703] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_REGION_2_CAUSE_END",
    [1314704] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_REGION_3_CAUSE_START",
    [1314705] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_DCONT_PSI_UNEXPECTED",
    [1314706] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_ACT_WITH_UNEXPECTED_LTE_ATTACH_PDN_IN_5G",
    [1314707] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHECKED_ACT_WITH_CID_SECONDARY_NOT_SUPPORT_IN_5G",
    [1314708] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_VGTCM_DEACT_DUE_TO_USER_FORCE_TO_LOCAL_RELEASE",
    [1314709] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_EGPCO_CID_UNEXPECTED",
    [1314710] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_EGPCO_PSI_UNEXPECTED",
    [1314711] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_EGDCONT_CID_UNEXPECTED",
    [1314712] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_EGDCONT_PSI_UNEXPECTED",
    [1314713] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_EGDCONT_INVALID_PDP_TYPE",
    [1314714] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_HANDOVER_REESTABLISHMENT_NEEDED",
    [1314715] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_HANDOVER_REESTABLISHMENT_FAIL_DUE_TO_NO_WITHOUT_N26_INFO",
    [1314716] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_VGTCM_DEACT_DUE_TO_INTERRAT",
    [1314717] = "PDN_EXT_NETWORK_TCM_CAUSE_RAT_TCM_LOCAL_REJECTED_DUE_TO_ONGOING_PROCESS",
    [1314735] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_REGION_3_CAUSE_END",
    [1314736] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_REGION_4_CAUSE_START",
    [1314737] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_PSI_NOT_DEFINED",
    [1314738] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_VGTCM_PROCEDURE_ONGOING_ON_CORRESPONDING_CID",
    [1314739] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CHANGE_PSI_FOR_ACTIVE_CID_NOT_ALLOWED",
    [1314740] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CGAUTH_CID_UNEXPECTED",
    [1314741] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_CGAUTH_PSI_UNEXPECTED",
    [1314742] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_VGTCM_UNEXPECTED_FIC_TYPE",
    [1314743] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_PEER_TO_PEER_MODIFY_WITHOUT_P_CSCF",
    [1314744] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_PEER_TO_PEER_MODIFY_WITH_P_CSCF",
    [1314745] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_MODIFY_DUE_TO_INTERRAT",
    [1314746] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_ACTIVATE_FAIL_DUE_TO_SAT_DATA_CONNECTION_CTRL_FAIL",
    [1314747] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_ACTIVATE_FAIL_DUE_TO_SAT_NOT_ALLOW",
    [1314748] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_ACTIVATE_FAIL_DUE_TO_SAT_SIM_ERROR",
    [1314749] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_L4C_ACTIVATE_FAIL_DUE_TO_DEACTIVATE_ABORT",
    [1314767] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_REGION_4_CAUSE_END",
    [1314768] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_REGION_5_CAUSE_START",
    [1314768] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_REGION_2_CAUSE_START",
    [1314769] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_4G5_EPS_BEARER_MAPPED_FAILED",
    [1314770] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_ATTACH_FAILURE",
    [1314784] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_ESM_REGION_2_CAUSE_END",
    [1314815] = "PDN_EXT_NETWORK_TCM_CAUSE_TCM_REGION_5_CAUSE_END",
    [1314815] = "PDN_EXT_NETWORK_TCM_CAUSE_END",
    [1315328] = "PDN_EXT_NETWORK_PAM_CAUSE_BEGIN",
    [1315329] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_GRANTED",
    [1315336] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_08",
    [1315354] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_26",
    [1315355] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_27",
    [1315356] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_28",
    [1315357] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_29",
    [1315358] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_30",
    [1315359] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_31",
    [1315360] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_32",
    [1315361] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_33",
    [1315362] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_34",
    [1315363] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_35",
    [1315364] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_36",
    [1315365] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_37",
    [1315366] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_38",
    [1315367] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_39",
    [1315369] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_41",
    [1315370] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_42",
    [1315371] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_43",
    [1315372] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_44",
    [1315373] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_45",
    [1315374] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_46",
    [1315375] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_47",
    [1315377] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_49",
    [1315378] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_50",
    [1315379] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_51",
    [1315380] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_52",
    [1315381] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_53",
    [1315382] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_54",
    [1315383] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_55",
    [1315384] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_56",
    [1315387] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_59",
    [1315393] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_65",
    [1315394] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_66",
    [1315409] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_81",
    [1315423] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_95",
    [1315424] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_96",
    [1315425] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_97",
    [1315426] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_98",
    [1315427] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_99",
    [1315428] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_100",
    [1315429] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_101",
    [1315439] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_111",
    [1315440] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_DUE_TO_CAUSE_112",
    [1315528] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_NOT_IN_ACL",
    [1315529] = "PDN_EXT_NETWORK_PAM_CAUSE_PAM_PDN_ACCESS_REJECT_READ_EF_ACL_ONGOING",
    [1315583] = "PDN_EXT_NETWORK_PAM_CAUSE_END",
    [1315584] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_BEGIN",
    [1315585] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_GRANTED",
    [1315586] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_DISABLE_IN_APN_TABLE",
    [1315587] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_ASK_APN_CHANGE_NOT_READY",
    [1315588] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_CHANGE_APN_CLASS",
    [1315589] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_CHANGE_APN_CLASS_AND_THROTTLE",
    [1315590] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_THROTTLE_FOREVER",
    [1315591] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_THROTTLE",
    [1315592] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_THROTTLE_WITH_BACKOFF_TIMER",
    [1315593] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_THROTTLE_FOREVER_CANDIDATE",
    [1315594] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_THROTTLE_NO_RSP",
    [1315595] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_NOT_IN_ACL",
    [1315596] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_STOP_ATTACH_FOR_CLASS1_AND_CLASS2_NOT_ENABLED",
    [1315597] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_WAIT_TIME_NOT_EXPIRED",
    [1315598] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_EXCEED_MAX_PDN_CONN_TRIES",
    [1315599] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_THROTTLE_BY_MAX_PDN_CONN_TRIES",
    [1315600] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_NO_AVAILABLE_CLASS_CAN_BE_USED",
    [1315601] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_APN_IN_USE",
    [1315602] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_VZ_REQ_LTEDATA_39683_FEB_2016",
    [1315603] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_VZ_REQ_LTEDATA_39684_FEB_2016",
    [1315604] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_ALLOC",
    [1315605] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDN_ACCESS_REJECT_MOD",
    [1315616] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDU_ACCESS_GRANTED",
    [1315617] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDU_ACCESS_REJECT_THROTTLE_FOREVER",
    [1315618] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDU_ACCESS_REJECT_THROTTLE",
    [1315619] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDU_ACCESS_REJECT_THROTTLE_WITH_BACKOFF_TIMER",
    [1315620] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDU_ACCESS_REJECT_THROTTLE_NO_RSP",
    [1315621] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDU_ACCESS_REJECT_MOD",
    [1315622] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDU_ACCESS_REJECT_EST",
    [1315623] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_PAM_VZW_PDU_ACCESS_THROTTLE_EXEMPTION",
    [1315839] = "PDN_EXT_NETWORK_PAM_VZW_CAUSE_END",
    [1315840] = "PDN_EXT_NETWORK_PAM_ATT_CAUSE_BEGIN",
    [1315841] = "PDN_EXT_NETWORK_PAM_ATT_CAUSE_PAM_ATT_PDN_ACCESS_GRANTED",
    [1315842] = "PDN_EXT_NETWORK_PAM_ATT_CAUSE_PAM_ATT_PDN_ACCESS_REJECT_IMS_PDN_BLOCK_TEMP",
    [1315843] = "PDN_EXT_NETWORK_PAM_ATT_CAUSE_PAM_ATT_PDN_ACCESS_REJECT_IMS_PDN_BLOCK_FOREVER",
    [1316095] = "PDN_EXT_NETWORK_PAM_ATT_CAUSE_END",
    [1316096] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_BEGIN",
    [1316097] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_OK",
    [1316098] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_CMD_MODE_NOT_SUPPORT",
    [1316099] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_CURRENT_RAT_UNKNOWN",
    [1316100] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_CID_IS_NOT_ACTIVE_FOR_CGCONTRDP",
    [1316101] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_CID_IS_NOT_VALID",
    [1316102] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_IE_PARSE_RESULT_IS_NOT_OK",
    [1316103] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_PCO_ID_IS_NOT_VALID",
    [1316104] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_PCO_ID_IS_NOT_SUPPORTED",
    [1316105] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_PCO_ID_SUPPORTED_IS_NOT_PRESENT",
    [1316106] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_CID_IS_NOT_ACTIVE_FOR_BINDING",
    [1316107] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_CID_IS_NOT_ACTIVE_FOR_UNBINDING",
    [1316108] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_CMD_NOT_SUPPORT_IN_CURRENT_DOMAIN",
    [1316109] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_CID_IS_ALREADY_BINDED",
    [1316110] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_CID_IS_ALREADY_UNBINDED",
    [1316111] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_CMD_NOT_SUPPORT",
    [1316112] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_CGCMOD_NOT_SUPPORT_IN_C2K",
    [1316113] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_EGACT_NOT_SUPPORT_IN_C2K",
    [1316114] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_CID_IS_ACTIVE_BUT_NOT_PRIMARY_PDP",
    [1316115] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_CID_IS_NOT_ACTIVE_FOR_SENDING_DATA",
    [1316116] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_CGEV_IND_FROM_CVAL_WITHOUT_CAUSE",
    [1316117] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_CGEV_IND_NO_CAUSE",
    [1316118] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_EGACT_UNEXPECTED_RAT_IN_C2K",
    [1316119] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_AT_ERROR_C2K_LTE_DEACT_RETRY_NEEDED",
    [1316224] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_LEISIM_CAUSE_START",
    [1316225] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_LEISIM_AT_ERROR_CID_IS_ALREADY_BINDED",
    [1316226] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_LEISIM_AT_ERROR_CID_PDN_TRANSFER_ONGOING",
    [1316227] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_LEISIM_OTHER_DIRECTION_IRAT_STARTED_ABORT_REVIVE",
    [1316228] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_LEISIM_EHRPD_ALL_3_ROUNDS_REVIVE_FAIL",
    [1316229] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_LEISIM_DEACT_ABORT_REVIVE",
    [1316230] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_LEISIM_EHRPD_ONE_PDN_REVIVE_SUCCESS_NO_NEED_REVIVE_OTHER",
    [1316231] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_LEISIM_OTHER_DIRECTION_IRAT_STARTED_ABORT_EHRPD_2ND_REVIVE",
    [1316232] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_L4BPDN_LEISIM_OTHER_DIRECTION_IRAT_STARTED_ABORT_EHRPD_3ND_REVIVE",
    [1316351] = "PDN_EXT_NETWORK_L4BPDN_CAUSE_END",
    [1316352] = "PDN_EXT_NETWORK_D2_CAUSE_BEGIN",
    [1316353] = "PDN_EXT_NETWORK_D2_CAUSE_D2AT_OK",
    [1316354] = "PDN_EXT_NETWORK_D2_CAUSE_D2AT_ERROR_EIF_ERROR",
    [1316355] = "PDN_EXT_NETWORK_D2_CAUSE_D2AT_ERROR_EIF_FORMAT_ERROR",
    [1316356] = "PDN_EXT_NETWORK_D2_CAUSE_D2AT_ERROR_INVALID_INTERFACE_ID",
    [1316357] = "PDN_EXT_NETWORK_D2_CAUSE_D2AT_ERROR_INVALID_STATE",
    [1316358] = "PDN_EXT_NETWORK_D2_CAUSE_D2AT_ERROR_DSCONT_WITHOUT_PRIMARY",
    [1316416] = "PDN_EXT_NETWORK_D2_CAUSE_D2_NETIF_OK",
    [1316417] = "PDN_EXT_NETWORK_D2_CAUSE_D2_NETIF_ERROR",
    [1316418] = "PDN_EXT_NETWORK_D2_CAUSE_D2_NETIF_INVALID_INTERFACE_ID",
    [1316419] = "PDN_EXT_NETWORK_D2_CAUSE_D2_NETIF_POOL_FULL",
    [1316420] = "PDN_EXT_NETWORK_D2_CAUSE_D2_NETIF_INVALID_STATE",
    [1316421] = "PDN_EXT_NETWORK_D2_CAUSE_D2_NETIF_INVALID_PARAMETER",
    [1316432] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_NW_CAUSE_START",
    [1316448] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_IA_CAUSE_START",
    [1316449] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_IA_APN_NOT_SET",
    [1316450] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_IA_APN_NOT_FOUND",
    [1316451] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_IA_APN_CID_ALLOC_FAIL",
    [1316452] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_IA_TARGET_DETACH",
    [1316453] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_IA_RF_OFF",
    [1316454] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_IA_APN_ON_WIFI",
    [1316455] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_IA_ICCID_NOT_GET",
    [1316456] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_IA_IMS_ON_WIFI",
    [1316457] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_IA_UNBIND_ONGOING",
    [1316464] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_OTHER_CAUSE_START",
    [1316465] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_DATA_NOT_ALLOWED",
    [1316466] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_IMPORTANT_USER_USING",
    [1316467] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_IMS_CALLING_ON_OTHER_SIM",
    [1316468] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_DUAL_MDALLOW",
    [1316469] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_MDALLOW_NOT_SUPPORT",
    [1316470] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_PS_MODE_UNKNOWN",
    [1316471] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_CS_CALLING_ON_OTHER_SIM",
    [1316472] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_VZW_DATA_NOT_ALLOWED",
    [1316473] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_DSBP_ONGOING",
    [1316474] = "PDN_EXT_NETWORK_D2_CAUSE_D2AM_SIM_NOT_READY",
    [1316560] = "PDN_EXT_NETWORK_D2_CAUSE_D2CPM_OK",
    [1316561] = "PDN_EXT_NETWORK_D2_CAUSE_D2CPM_INVAL_ARG",
    [1316562] = "PDN_EXT_NETWORK_D2_CAUSE_D2CPM_NOT_CONN",
    [1316563] = "PDN_EXT_NETWORK_D2_CAUSE_D2CPM_ALREADY_PROG",
    [1316564] = "PDN_EXT_NETWORK_D2_CAUSE_D2CPM_CONN_ABORT",
    [1316565] = "PDN_EXT_NETWORK_D2_CAUSE_D2CPM_NO_ADDR",
    [1316566] = "PDN_EXT_NETWORK_D2_CAUSE_D2CPM_NOT_PERM",
    [1316567] = "PDN_EXT_NETWORK_D2_CAUSE_D2CPM_IN_USE",
    [1316568] = "PDN_EXT_NETWORK_D2_CAUSE_D2CPM_CONFLICT",
    [1316569] = "PDN_EXT_NETWORK_D2_CAUSE_D2CPM_UNRECOV",
    [1316575] = "PDN_EXT_NETWORK_D2_CAUSE_D2CPM_CAUSE_END",
    [1316576] = "PDN_EXT_NETWORK_D2_CAUSE_D2CM_CAUSE_START",
    [1316591] = "PDN_EXT_NETWORK_D2_CAUSE_D2CM_CAUSE_END",
    [1316592] = "PDN_EXT_NETWORK_D2_CAUSE_D2PM_CAUSE_START",
    [1316593] = "PDN_EXT_NETWORK_D2_CAUSE_D2PM_D2RM_REJ",
    [1316594] = "PDN_EXT_NETWORK_D2_CAUSE_D2PM_NW_UNKNOWN",
    [1316607] = "PDN_EXT_NETWORK_D2_CAUSE_END",
    [1316608] = "PDN_EXT_NETWORK_DDM_CAUSE_BEGIN",
    [1316609] = "PDN_EXT_NETWORK_DDM_CAUSE_DDM_AT_OK",
    [1316610] = "PDN_EXT_NETWORK_DDM_CAUSE_DDM_DEFINE_ATTACH_PDN_FAIL",
    [1316611] = "PDN_EXT_NETWORK_DDM_CAUSE_DDM_BLOCK_ACT_DATA_CALL",
    [1316612] = "PDN_EXT_NETWORK_DDM_CAUSE_DDM_REUSE_PDP_TYPE_NOT_MATCH",
    [1316613] = "PDN_EXT_NETWORK_DDM_CAUSE_DDM_IA_IS_ONGOING",
    [1316614] = "PDN_EXT_NETWORK_DDM_CAUSE_DDM_ACT_IS_ONGOING",
    [1316615] = "PDN_EXT_NETWORK_DDM_CAUSE_DDM_DEACT_IS_ONGOING",
    [1316863] = "PDN_EXT_NETWORK_DDM_CAUSE_END",
    [1317376] = "PDN_EXT_NETWORK_5GSM_CAUSE_BEGIN",
    [1317377] = "PDN_EXT_NETWORK_5GSM_CAUSE_NO_CAUSE",
    [1317384] = "PDN_EXT_NETWORK_5GSM_CAUSE_OPERATOR_DETERMINED_BARRING",
    [1317402] = "PDN_EXT_NETWORK_5GSM_CAUSE_INSUFFICIENT_RESOURCES",
    [1317403] = "PDN_EXT_NETWORK_5GSM_CAUSE_MISSING_OR_UNKNOWN_DNN",
    [1317404] = "PDN_EXT_NETWORK_5GSM_CAUSE_UNKNOWN_PDU_SESSION_TYPE",
    [1317405] = "PDN_EXT_NETWORK_5GSM_CAUSE_USER_AUTH_FAILED",
    [1317406] = "PDN_EXT_NETWORK_5GSM_CAUSE_REQUEST_REJECTED_BY_SGW_OR_PDNGW",
    [1317407] = "PDN_EXT_NETWORK_5GSM_CAUSE_REQUEST_REJECTED_UNSPECIFIED",
    [1317408] = "PDN_EXT_NETWORK_5GSM_CAUSE_SERVICE_OPT_NOT_SUPPORTED",
    [1317409] = "PDN_EXT_NETWORK_5GSM_CAUSE_REQ_SERVICE_NOT_SUBSCRIBED",
    [1317410] = "PDN_EXT_NETWORK_5GSM_CAUSE_SERVICE_OPT_TEMP_OUT_OF_ORDER",
    [1317411] = "PDN_EXT_NETWORK_5GSM_CAUSE_PTI_ALREADY_USED",
    [1317412] = "PDN_EXT_NETWORK_5GSM_CAUSE_REGULAR_DEACTIVATION",
    [1317413] = "PDN_EXT_NETWORK_5GSM_CAUSE_EPS_QOS_NOT_ACCEPTED",
    [1317414] = "PDN_EXT_NETWORK_5GSM_CAUSE_NETWORK_FAILURE",
    [1317415] = "PDN_EXT_NETWORK_5GSM_CAUSE_REACTIVATION_REQUESTED",
    [1317417] = "PDN_EXT_NETWORK_5GSM_CAUSE_SEMANTIC_ERROR_IN_TFT",
    [1317418] = "PDN_EXT_NETWORK_5GSM_CAUSE_SYNTACTIC_ERROR_IN_TFT",
    [1317419] = "PDN_EXT_NETWORK_5GSM_CAUSE_INVALID_PDU_SESSION_IDENTITY",
    [1317420] = "PDN_EXT_NETWORK_5GSM_CAUSE_SEMANTIC_ERROR_IN_PACKET_FILTERS",
    [1317421] = "PDN_EXT_NETWORK_5GSM_CAUSE_SYNTACTIC_ERROR_IN_PACKET_FILTERS",
    [1317422] = "PDN_EXT_NETWORK_5GSM_CAUSE_OUT_OF_LADN_SERVICE_AREA",
    [1317423] = "PDN_EXT_NETWORK_5GSM_CAUSE_PTI_MISMATCH",
    [1317425] = "PDN_EXT_NETWORK_5GSM_CAUSE_LAST_PDN_DISC_NOT_ALLOWED",
    [1317426] = "PDN_EXT_NETWORK_5GSM_CAUSE_PDU_SESSION_TYPE_IPV4_ONLY_ALLOWED",
    [1317427] = "PDN_EXT_NETWORK_5GSM_CAUSE_PDU_SESSION_TYPE_IPV6_ONLY_ALLOWED",
    [1317428] = "PDN_EXT_NETWORK_5GSM_CAUSE_SINGLE_ADDRESS_ONLY_ALLOWED",
    [1317430] = "PDN_EXT_NETWORK_5GSM_CAUSE_PDU_SESSION_NOT_EXIST",
    [1317431] = "PDN_EXT_NETWORK_5GSM_CAUSE_MULTIPLE_PDN_APN_NOT_ALLOWED",
    [1317432] = "PDN_EXT_NETWORK_5GSM_CAUSE_COLLISION_WITH_NW_INIT_REQUEST",
    [1317433] = "PDN_EXT_NETWORK_5GSM_CAUSE_PDU_SESSION_TYPE_IPV4V6_ONLY_ALLOWED",
    [1317434] = "PDN_EXT_NETWORK_5GSM_CAUSE_PDU_SESSION_TYPE_UNSTRUCTURED_ONLY_ALLOWED",
    [1317435] = "PDN_EXT_NETWORK_5GSM_CAUSE_UNSUPPORTED_QCI_VALUE",
    [1317437] = "PDN_EXT_NETWORK_5GSM_CAUSE_PDU_SESSION_TYPE_ETHERNET_ONLY_ALLOWED",
    [1317441] = "PDN_EXT_NETWORK_5GSM_CAUSE_MAXIMUM_NUM_OF_EPS_BEARERS_REACHED",
    [1317442] = "PDN_EXT_NETWORK_5GSM_CAUSE_REQUESTED_APN_NOT_SUPPORTED_IN_CURRENT_RAT_AND_PLMN_COMBINATION",
    [1317443] = "PDN_EXT_NETWORK_5GSM_CAUSE_INSUFFICIENT_RESOURCES_FOR_SPECIFIC_SLICE_AND_DNN",
    [1317444] = "PDN_EXT_NETWORK_5GSM_CAUSE_NOT_SUPPORTED_SSC_MODE",
    [1317445] = "PDN_EXT_NETWORK_5GSM_CAUSE_INSUFFICIENT_RESOURCES_FOR_SPECIFIC_SLICE",
    [1317446] = "PDN_EXT_NETWORK_5GSM_CAUSE_MISSING_OR_UNKNOWN_DNN_IN_A_SLICE",
    [1317457] = "PDN_EXT_NETWORK_5GSM_CAUSE_INVALID_PTI_VALUE",
    [1317458] = "PDN_EXT_NETWORK_5GSM_CAUSE_MAX_DATA_RATE_PER_UE_FOR_UPLANE_INTEGRITY_PROTECTION_IS_TOO_LOW",
    [1317459] = "PDN_EXT_NETWORK_5GSM_CAUSE_SEMANTIC_ERROR_IN_QOS_OPERATION",
    [1317460] = "PDN_EXT_NETWORK_5GSM_CAUSE_SYNTACTIC_ERROR_IN_QOS_OPERATION",
    [1317461] = "PDN_EXT_NETWORK_5GSM_CAUSE_INVALID_MAPPED_EPS_BEARER_IDENTITY",
    [1317471] = "PDN_EXT_NETWORK_5GSM_CAUSE_SEMANTICLLY_INCORRECT_MSG",
    [1317472] = "PDN_EXT_NETWORK_5GSM_CAUSE_INVALID_MANDATORY_IE",
    [1317473] = "PDN_EXT_NETWORK_5GSM_CAUSE_MSG_TYPE_NON_EXISTENT_OR_NOT_IMPLEMENT",
    [1317474] = "PDN_EXT_NETWORK_5GSM_CAUSE_MSG_TYPE_NOT_COMPATIBLE_STATE",
    [1317475] = "PDN_EXT_NETWORK_5GSM_CAUSE_IE_NON_EXISTENT_NOT_IMPLEMENTED",
    [1317476] = "PDN_EXT_NETWORK_5GSM_CAUSE_CONDITIONAL_IE_ERROR",
    [1317477] = "PDN_EXT_NETWORK_5GSM_CAUSE_MSG_NOT_COMPATIBLE_STATE",
    [1317487] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROTOCOL_ERROR_UNSPECIFIED",
    [1317531] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_START",
    [1317532] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_RESPONDER_REJ_REQ_DUE_TO_NESTED_SAME_REQ",
    [1317533] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_RESPONDER_REJ_REQ_DUE_TO_INVALID_PSI",
    [1317534] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_RESPONDER_REJ_REQ_DUE_VGSM_INIT_MOD_ONGOING",
    [1317535] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_RESPONDER_PROCESSING_TIME_NOT_ENOUGH",
    [1317536] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_RESPONDER_GUARANTEE_RESPONSE_TIMER_TIME_OUT",
    [1317537] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_RESPONDER_REJ_REQ_DUE_TO_VZ_REQ_5GNRSA_10_2_3",
    [1317546] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CONN_REJ_REQ_DUE_TO_PS_SUSPENDED",
    [1317547] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CONN_REJ_REQ_DUE_TO_ERROR_OCCURED",
    [1317548] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CONN_REJ_REQ_DUE_TO_HURRY_UP_REQ",
    [1317549] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CONN_REJ_REQ_DUE_TO_UAC_BARRING",
    [1317550] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CONN_REJ_REQ_DUE_TO_FATAL_FAIL",
    [1317551] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CONN_ABORT_PROC_DUE_TO_POSSIBLE_LONG_GEMINI_SUSPEND",
    [1317552] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CONN_REJ_REQ_DUE_TO_TRANSMISSION_FAILURE",
    [1317553] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CONN_REJ_REQ_DUE_TO_S_NSSAI_REJECTED",
    [1317556] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_SYSTEM_STATE_CHECK_FAIL",
    [1317557] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_REQ_INFO_ERROR",
    [1317558] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_TX_FAILURE",
    [1317559] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_TIMER_TIMEOUT",
    [1317560] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_LOCAL_RELEASE",
    [1317561] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_CANCLE_BY_RELEASE_FROM_UPPER_LAYER",
    [1317562] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_NW_RELEASE_ABORT_ORIGINAL_PROCEDURE",
    [1317563] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_MSG_NOT_FORWARD_ROUTING_FAILURE",
    [1317564] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_MSG_NOT_FORWARD_DNN_NOT_SUPPORT_IN_SLICE",
    [1317565] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_MSG_NOT_FORWARD_PLMN_MAX_NUM_PDU_SESSION_REACH",
    [1317566] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_MT_MOD_ABORT_ORIGINAL_PROCEDURE",
    [1317567] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_MT_MOD_ONGOING_MO_MOD_NOT_ALLOW",
    [1317568] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_SYNC_PDUS_STATUS_WITH_NW",
    [1317569] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_UE_DEREGISTER_FROM_NW",
    [1317570] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_5G23_DO_LOCAL_RELEASE",
    [1317571] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_THIS_PDU_WAS_REVIVED_IN_4G",
    [1317572] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_INTERSYSTEM_CHANGE_ABORT",
    [1317573] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_PDU_SESSION_ALREADY_DEACTIVATE",
    [1317574] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_5G4_MAP_FAILED",
    [1317575] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_TRIGGERED_BY_RQOS",
    [1317576] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_THIS_PDUS_CANNOT_TO_4G",
    [1317577] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_SYSTEM_STATE_UNSYNC_WITH_UPPER_LAYER",
    [1317578] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_UPPER_LAYER_REQ_FORCE_TO_LOCAL_REL_PDUS",
    [1317579] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_SYNC_EPSB_STATUS_WITH_NW",
    [1317580] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_PAM_REJECT_REQ",
    [1317581] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_SECOND_EMC_PDUS_NOT_ALLOW",
    [1317582] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_EST_NON_EMC_PDUS_NOT_ALLOW_WHEN_ENTER_EMC_REGISTERED",
    [1317583] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_THIS_MOD_REQ_ON_EMC_PDUS_IS_NOT_ALLOWED",
    [1317584] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_SNSSAI_NOT_IN_NSSAI",
    [1317585] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_DUE_TO_DETACH_WITH_REATTACH_REQUIRED",
    [1317586] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_MSG_TYPE_NON_EXISTENT_OR_NOT_IMPLEMENT_INDICATED_BY_5GSM_STATUS",
    [1317587] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_TRIGGERED_BY_SNSSAI_UPDATE",
    [1317588] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_VGMM_ENTER_EMC_TO_LOCAL_RELEASE",
    [1317589] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_PROCESS_NW_MOD_COMMAND_OK",
    [1317590] = "PDN_EXT_NETWORK_5GSM_CAUSE_PROPRIETARY_CAUSE_CORE_MSG_NOT_FORWARD_RESTRICTED_SERVICE_AREA",
    [1317631] = "PDN_EXT_NETWORK_5GSM_CAUSE_END",
    [1317632] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_BEGIN",
    [1317640] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_8",
    [1317658] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_26",
    [1317659] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_27",
    [1317660] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_28",
    [1317661] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_29",
    [1317662] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_30",
    [1317663] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_31",
    [1317664] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_32",
    [1317665] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_33",
    [1317666] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_34",
    [1317667] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_35",
    [1317668] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_36",
    [1317669] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_37",
    [1317670] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_38",
    [1317671] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_39",
    [1317673] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_41",
    [1317674] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_42",
    [1317675] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_43",
    [1317676] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_44",
    [1317677] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_45",
    [1317678] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_46",
    [1317679] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_47",
    [1317681] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_49",
    [1317682] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_50",
    [1317683] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_51",
    [1317686] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_54",
    [1317687] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_55",
    [1317688] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_56",
    [1317689] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_57",
    [1317691] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_59",
    [1317690] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_58",
    [1317693] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_61",
    [1317697] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_65",
    [1317698] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_66",
    [1317699] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_67",
    [1317700] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_68",
    [1317701] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_69",
    [1317702] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_70",
    [1317713] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_81",
    [1317714] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_82",
    [1317715] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_83",
    [1317716] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_84",
    [1317717] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_85",
    [1317727] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_95",
    [1317728] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_96",
    [1317729] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_97",
    [1317730] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_98",
    [1317731] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_99",
    [1317732] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_100",
    [1317733] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_101",
    [1317743] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_CAUSE_111",
    [1317760] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_NOT_FORWARDED_CAUSE_START",
    [1317761] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_DNN_NOT_SUPPORT_IN_SLICE",
    [1317762] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_5G_PDU_SESSION_ACCESS_REJECT_DUE_TO_MAX_PDU_SESSION_REACHED",
    [1317763] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_VGSM_REJECT_DUE_TO_LADN_OUT_OF_SERVICE_AREA",
    [1317764] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_PAM_VGSM_REJECT_DUE_TO_LADN_TABLE_VERSION_NOT_UNSYNC",
    [1317887] = "PDN_EXT_NETWORK_EXT_PAM_CAUSE_END",
    [1376255] = "PDN_EXT_NETWORK_ERROR_END",
    [1376256] = "PDN_EXT_LOCAL_MIPC_ERROR_BEGIN",
    [1376257] = "PDN_EXT_LOCAL_MIPC_ERROR_NO_ENOUGH_INFO",
    [1376511] = "PDN_EXT_LOCAL_MIPC_ERROR_END",
    [1376512] = "PDN_EXT_LOCAL_PARA_ERROR_BEGIN",
    [1376513] = "PDN_EXT_LOCAL_PARA_ERROR_INVALID_PARA",
    [1376514] = "PDN_EXT_LOCAL_PARA_ERROR_NOT_FIND_APN_TO_ACT",
    [1376515] = "PDN_EXT_LOCAL_PARA_ERROR_NO_APN_INFO_TO_ABORT",
    [1376516] = "PDN_EXT_LOCAL_PARA_ERROR_APN_PROFILE_IS_DISABLED",
    [1376517] = "PDN_EXT_LOCAL_PARA_ERROR_NOT_FIND_CALL_INFO",
    [1376518] = "PDN_EXT_LOCAL_PARA_ERROR_REACH_MAX_USER",
    [1376519] = "PDN_EXT_LOCAL_PARA_ERROR_PROFILE_COUNT_ERROR",
    [1376520] = "PDN_EXT_LOCAL_PARA_ERROR_WRONG_APN_TYPE_OR_NO_APN",
    [1376767] = "PDN_EXT_LOCAL_PARA_ERROR_END",
    [1376768] = "PDN_EXT_LOCAL_FALLBACK_RES_START",
    [1376769] = "PDN_EXT_LOCAL_FALLBACK_RES_FAIL_ABORT",
    [1376770] = "PDN_EXT_LOCAL_FALLBACK_RES_SUCC_ABORT",
    [1376771] = "PDN_EXT_LOCAL_FALLBACK_RES_FAIL_CONT",
    [1376772] = "PDN_EXT_LOCAL_FALLBACK_RES_SUCC_CONT",
    [1376783] = "PDN_EXT_LOCAL_FALLBACK_RES_END",
    [1572863] = "PDN_EXT_END",
    [1572864] = "RF_EXT_BEGIN",
    [1835007] = "RF_EXT_END",
    [1835008] = "SIM_EXT_BEGIN",
    [1835009] = "SIM_EXT_PUK1_REQUIRED",
    [1835010] = "SIM_EXT_PIN2_REQUIRED",
    [1835011] = "SIM_EXT_PUK2_REQUIRED",
    [1835012] = "SIM_EXT_SIM_FAILURE",
    [1835013] = "SIM_EXT_INCORRECT_PASS_WORD",
    [1835014] = "SIM_EXT_NW_PERSON_PIN_REQUIRED",
    [1835015] = "SIM_EXT_NW_PERSON_PUK_REQUIRED",
    [1835016] = "SIM_EXT_NW_SUB_PERSON_PIN_REQUIRED",
    [1835017] = "SIM_EXT_NW_SUB_PERSON_PUK_REQUIRED",
    [1835018] = "SIM_EXT_SP_PERSON_PIN_REQUIRED",
    [1835019] = "SIM_EXT_SP_PERSON_PUK_REQUIRED",
    [1835020] = "SIM_EXT_CORP_PERSON_PIN_REQUIRED",
    [1835021] = "SIM_EXT_CORP_PERSON_PUK_REQUIRED",
    [1835022] = "SIM_EXT_IMSI_PERSON_PIN_REQUIRED",
    [1835023] = "SIM_EXT_IMSI_PERSON_PUK_REQUIRED",
    [1835024] = "SIM_EXT_LINK_NS_SP_PERSON_PIN_REQUIRED",
    [1835025] = "SIM_EXT_LINK_NS_SP_PERSON_PUK_REQUIRED",
    [1835026] = "SIM_EXT_LINK_SIM_C_PERSON_PIN_REQUIRED",
    [1835027] = "SIM_EXT_LINK_SIM_C_PERSON_PUK_REQUIRED",
    [1835028] = "SIM_EXT_BT_SAP_UNDEFINED",
    [1835029] = "SIM_EXT_BT_SAP_NOT_ACCESSIBLE",
    [1835030] = "SIM_EXT_BT_SAP_CARD_REMOVED",
    [1835031] = "SIM_EXT_BT_SAP_CARD_ALREADY_POWERED_OFF",
    [1835032] = "SIM_EXT_BT_SAP_CARD_ALREADY_POWERED_ON",
    [2097151] = "SIM_EXT_END",
    [2097152] = "SMS_EXT_BEGIN",
    [2097153] = "SMS_EXT_CBM_CFG_WRONG_MSG_ID_RANGE_FORMAT",
    [2097154] = "SMS_EXT_CBM_CFG_WRONG_MSG_ID_SINGLE_FORMAT",
    [2097155] = "SMS_EXT_CBM_CFG_WRONG_DCS_RANGE_FORMAT",
    [2097156] = "SMS_EXT_CBM_CFG_WRONG_DCS_SINGLE_FORMAT",
    [2097157] = "SMS_EXT_CBM_CFG_TOO_MORE_RANGES_OR_SINGLES",
    [2097158] = "SMS_EXT_CBM_CFG_MSG_ID_LOGIC_ERROR",
    [2097159] = "SMS_EXT_CBM_CFG_DCS_LOGIC_ERROR",
    [2097160] = "SMS_EXT_NEED_SET_PREFER_STORAGE_AGAIN",
    [2097161] = "SMS_EXT_C2K_ERROR",
    [2162688] = "SMS_EXT_AT_ERROR_BEGIN",
    [2162914] = "SMS_EXT_CM_SMS_CONNECTION_BROKEN",
    [2165289] = "SMS_EXT_MTK_FDN_CHECK_FAILURE",
    [2168833] = "SMS_EXT_MTK_REQ_RETRY",
    [2228223] = "SMS_EXT_AT_ERROR_END",
    [2359295] = "SMS_EXT_END",
    [2359296] = "SS_EXT_BEGIN",
    [2621439] = "SS_EXT_END",
    [2621440] = "SWITCH_EXT_BEGIN",
    [2883583] = "SWITCH_EXT_END",
    [2883584] = "SYS_EXT_BEGIN",
    [3145727] = "SYS_EXT_END",
    [4294967294] = "AUTH_REQUIRED",
    [4294967295] = "TIMEOUT",
}
