#include "platform.h"

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "mipc_msg_host.h"
#include "mipc_internal.h"

int main(int argc, char *argv[])
{
    if (argc == 4) {
        printf("SETCOM: %s\n", argv[1]);
        SETCOM(argv[1]);
    } else {
        printf("%s <COM> <CONFIG_NAME> <CONFIG_VAL>\n", argv[0]);
        exit(0);
    }

    //SETP0: init MIPC library
    mipc_init("test");

    do {
        mipc_msg_t* msg_req_ptr;
        mipc_msg_t* msg_cnf_ptr;
        char     config_type[64] = {0};
        char     config_data[1024] = {0};
        void     *resp_data = 0;
        uint16_t  resp_len;
        uint32_t val;

        //SETP1: build MIPC message
        msg_req_ptr = mipc_msg_init(MIPC_SYS_SET_CONFIG_REQ, MIPC_MSG_SIM0);

        //SETP2: add paramters (in this case, there is only one TLV parameter)
        mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_CONFIG_REQ_T_CLASS, MIPC_SYS_CONFIG_CLASS_HOST_RELAY_DIPC_CONFIG);
        strcpy(config_type, argv[2]); // set your config type
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_SET_CONFIG_REQ_T_TYPE, strlen(config_type) + 1, config_type);
        // prepare your config data - config_data
        val = strtoul(argv[3], NULL, 10);
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_SET_CONFIG_REQ_T_DATA, sizeof(val), &val);
        printf("set %s to %x\n", config_type, val);

        //SETP3: send to MD and wait the response
        msg_cnf_ptr = mipc_msg_sync(msg_req_ptr);

        //SETE4: free the req msg
        mipc_msg_deinit(msg_req_ptr);

        //STEP5: check the result
        resp_data = (void *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SYS_SET_CONFIG_CNF_T_DATA, &resp_len);

        //SETP6: free the cnf msg
        mipc_msg_deinit(msg_cnf_ptr);
    } while (0);

    mipc_deinit();
}
