/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#include "atcid.h"
#include "atcid_serial.h"

#ifdef ANDROID
#include <cutils/sockets.h>
#endif

#include <netinet/in.h>
#include <sys/socket.h>
#include "lynq_atsvc_controller.h" /*warren add for lynq atsvc on 2022/12/06*/

/*misc global vars */
Serial serial;

#define PROP_ATM_MODE "ro.boot.atm"
#define BUILD_TYPE_PROP "ro.vendor.build.type"
#if defined(CONFIG_TARGET_mt6890) || defined(CONFIG_TARGET_mt6880)
#define BOOTMODE_PATH "/proc/device-tree/chosen/atag,boot"  //for common kernel
#else
#define BOOTMODE_PATH "/proc/boot_mode"
#endif

#define UNKNOWN_BOOT -1
#define NORMAL_BOOT 0
#define META_BOOT 1

extern int adb_socket_listen(int socketFd);
extern int get_control_socket(char* name);

/*
* Purpose:  The main program loop
* Return:    0
*/
int main() {
    int i = 0;
    int res = 0;
    LOGATCI(LOG_INFO, "atcid-daemon start!!!");

    //Initial the parameter for serial dervice
    initSerialDevice(&serial);
#ifdef LYNQ_ATSVC
    res = lynq_atsvc_init(0,PLUGIN_CONF_PATH);
    if(res!=0)
    {
        ALOGD("lynq_atsvc_init fail,result = %d",res);
        ALOGD("lynq all at cmd can`t use");
    }
#endif
#ifdef MTK_DATACARD_ATCI
    //AP AT port is GS3 in factory mode
    snprintf(serial.devicename[0], strlen(TTY_GS3) + 1, "%s", TTY_GS3);
    int listenVCOM = 0; //don't listen AT port in normal mode
    int bootMode = readSys_int(BOOTMODE_PATH);

    if (bootMode == META_BOOT) {
        LOGATCI(LOG_INFO, "meta mode for data card, listen");
        listenVCOM = 1;
    }
#else
#ifdef CONFIG_WOM_ATCID
    /*dongyu@2023.5.2 VCOM port as AT port in WOM platform meta mode, ELT port as AT port in normal mode start*/
    snprintf(serial.devicename[0], strlen(TTY_GS0) + 1, "%s", TTY_GS0);
    int listenVCOM = 1;
    int bootMode = readSys_int(BOOTMODE_PATH);

    LOGATCI(LOG_INFO, "bootMode = %d", bootMode);

    if(bootMode == META_BOOT)
    {
        LOGATCI(LOG_INFO, "meta mode for CPE/ IVT, listen VCOM");
        listenVCOM = 0;
    }
    else if(bootMode == NORMAL_BOOT)
    {
        LOGATCI(LOG_INFO, "normal mode for CPE/ IVT, listen ELT");
        snprintf(serial.devicename[0], strlen(TTY_GS3) + 1, "%s", TTY_GS3);
        listenVCOM = 1;
    }
    /*dongyu@2023.4.2 VCOM port as AT port in WOM platform meta mode, ELT port as AT port in normal mode end*/
#else
    //for CPE / IVT listen TTYGS0
    snprintf(serial.devicename[0], strlen(TTY_GS0) + 1, "%s", TTY_GS0);
    int listenVCOM = 1; //listen ETS port as default
    int bootMode = readSys_int(BOOTMODE_PATH);

    LOGATCI(LOG_INFO, "bootMode = %d", bootMode);

    if (bootMode == META_BOOT) {
        LOGATCI(LOG_INFO, "meta mode for CPE/ IVT, don't listen");
        listenVCOM = 0;
    }
#endif
#endif

    if (listenVCOM == 1) {
        for (i = 0; i < MAX_DEVICE_VCOM_NUM; i++) {
            if ((serial.fd[i] = open_serial_device(&serial, serial.devicename[i])) ==
                    INVALIDE_SOCKET_FD) {
                LOGATCI(LOG_ERR, "Could not open serial device [%d] and start atci service", i);
                return ATCID_OPEN_SERIAL_DEV_ERR;
            }
        }
    } else {
        LOGATCI(LOG_INFO, "current mode, don't open VCOM");
    }

#ifdef ANDROID
    serial.fd[ADB_SKT_SERVER_NUM] = android_get_control_socket(ADB_ATCI_SOCKET);
#else
    serial.fd[ADB_SKT_SERVER_NUM] = get_control_socket(ADB_ATCI_SOCKET);
#endif
    if (serial.fd[ADB_SKT_SERVER_NUM] < 0) {
        LOGATCI(LOG_ERR, "Failed to get socket '%s'", ADB_ATCI_SOCKET);
    } else {
        if (ATCID_SUCCESS != adb_socket_listen(serial.fd[ADB_SKT_SERVER_NUM])) {
            LOGATCI(LOG_ERR, "Could not open adb socket [%d] and start atci service", i);
            return ATCID_OPEN_SERIAL_DEV_ERR;
        }
    }

    readerLoop((void*) &serial);

    return 0;
}
