#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <termios.h>
#include <sys/select.h>
/* According to earlier standards */
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>


#include "transfer_controller.h"
#include "atcid_serial.h"
typedef struct
{
    int serial_io_port;
    int serial_urc_port;
    int io_fd;
    int urc_fd;
}port_conf_t;

port_conf_t port_config;

static int conf_to_colon(char *p_cur)
{
    if (p_cur == NULL)
    {
        return -1;
    }
    p_cur = strchr(p_cur, ':');
    if (p_cur == NULL)
    {
        return -1;
    }
    ALOGD("line:%s",p_cur+1);
    return atoi(p_cur+1);
}

char* map_device(int device_id)
{
    switch (device_id)
    {
        case L_TTY_GS0:
            return "/dev/ttyGS0";
        case L_TTY_GS1:
            return "/dev/ttyGS1";
        case L_TTY_GS3:
            return "/dev/ttyGS3";
        case L_TTY_GS4:
            return "/dev/ttyGS4";
        default:
            return "unkonw";
    }
    return NULL;
}
int parse_terminal_config(char *path, port_conf_t * port_conf)
{
    ALOGD("[%d][%s] enter",__LINE__,__FUNCTION__);
    FILE *fp;
    const char *at_io = "CONF_PORT_ATIO";
    const char *at_urc = "CONF_PORT_ATURC";
    char *needle = NULL;
    int conut = 0;
    int ret = 0;
    char line[100] = {0};
    fp=fopen(path,"r");
    if(fp==NULL)
    {
        ALOGD("can not load file!");
        return -1;
    }
    while(!feof(fp))
    {
        memset(line,0,100);
        fgets(line,100,fp);
        ALOGD("%d:%s",conut,line);
        needle = NULL;
        needle = strstr(line,at_io);
        if(NULL != needle)
        {
            ret = conf_to_colon(line);
            if(ret >= 0 && ret <= 3)
            {
                port_conf->serial_io_port = ret;
            }
            ALOGD("line:%s:ret:%d",line,ret);
        }
        needle = NULL;
        needle = strstr(line,at_urc);
        if(NULL != needle)
        {
            ret = conf_to_colon(line);
            if(ret >= 0 && ret <= 3)
            {
                port_conf->serial_urc_port = ret;
            }
            ALOGD("urc line:%s:ret:%d",line,ret);
        }
        conut++;
    }
    fclose(fp);
    return 0;
}


/*
* Purpose:  Open and initialize the serial device used.
* Input:    device_id - the serial port
* Return:    0 if port successfully opened, else -1.
*/
int open_serial_device_with_id(int device_id,int type)
{
    LOGATCI(LOG_DEBUG, "Enter,device_id:%d,type=%d",device_id,type);
    int fdflags;
    struct termios deviceOptions;
    int fd = INVALIDE_SOCKET_FD;
    int ret = 0;
    char *devicename = NULL;
    devicename  = map_device(device_id);
    LOGATCI(LOG_INFO, "Opened serial port:%s", devicename);

    do {
        fd = open(devicename, O_RDWR | O_NOCTTY | O_NONBLOCK);
    } while (fd < 0 && errno == EINTR);

    if(fd < 0) {
        LOGATCI(LOG_ERR, "Fail to open serial device(%s) with error code:%d", devicename, errno);
        return INVALIDE_SOCKET_FD;
    }

    LOGATCI(LOG_DEBUG, "serial->fd is %d ", fd);

    // Set FD to Sync IO
    fdflags = fcntl(fd, F_GETFL);
    ret = fcntl(fd, F_SETFL, fdflags & ~O_NONBLOCK);
    if (ret < 0) {
        LOGATCI(LOG_ERR, "Error clearing O_NONBLOCK errno: %d", errno);
    }

    // get the parameters
    tcgetattr(fd,&deviceOptions);

    // set raw input
    //deviceOptions.c_lflag = ICANON | ECHO;
    // set raw output
    deviceOptions.c_oflag &= ~OPOST;
    deviceOptions.c_oflag &= ~OLCUC;
    deviceOptions.c_oflag &= ~ONLRET;
    deviceOptions.c_oflag &= ~ONOCR;
    deviceOptions.c_oflag &= ~OCRNL;

    deviceOptions.c_cc[VEOL] = 0x1a; /*Ctrl+Z*/
    deviceOptions.c_lflag = deviceOptions.c_lflag | IEXTEN;
    deviceOptions.c_cc[VEOL2] = 0x1b; /*ESC*/

    tcflush(fd, TCIFLUSH);
    tcsetattr(fd,TCSANOW,&deviceOptions);
    if(type == L_URC_TYPE)
    {
        port_config.urc_fd = fd;
    }
    else if(type == L_RESP_TYPE)
    {
        port_config.io_fd = fd;
    }
    else
    {
        LOGATCI(LOG_ERR, "type is invalid:%d",type);
    }
    return fd;
}




int init_pseudo_terminal()
{
    ALOGD("[%d][%s] enter",__LINE__,__FUNCTION__);
    int ret = 0;
    bool init_default = true;
    port_config.io_fd = -1;
    port_config.urc_fd = -1;
    port_config.serial_io_port = -1;
    port_config.serial_urc_port = -1;
    ret = parse_terminal_config(TERMINAL_CONF_PATH, &port_config);
    if(ret < 0)
    {
        ALOGD("parse terminal fail,init defualt prot");
        init_default = false;
        port_config.serial_io_port = L_TTY_GS0;
        port_config.serial_urc_port = L_TTY_GS0;
    }
    //todo init device
    //just init urc port,why not init io port?Because this function is executed earlier than [atcid.c line 112]open_serial_device(), 
    //it will cause logic confusion.
    if(port_config.serial_urc_port != L_TTY_GS0)
    {
        ALOGD("[%d][%s] init urc port %d",__LINE__,__FUNCTION__,port_config.serial_urc_port);
        if(open_serial_device_with_id(port_config.serial_urc_port,L_URC_TYPE)!=0)
        {
            ALOGD("[%d][%s] init urc port fail,serial_urc_port:%d,urc_fd:%d",__LINE__,__FUNCTION__,port_config.serial_urc_port,port_config.urc_fd);
        }
    }
    return 0;
}

void write_data_to_serial_with_port(int serial_port,int type,char *output,int out_size)
{
    ALOGD("serial_io_port:%d,type%d,output:%s,out_size:%d",serial_port,type,output,out_size);
    int write_len = 0;
    char buffer[out_size+1];
    int output_len = 0;
    int count=0;
    memset(buffer,0,out_size+1);
    if(NULL == output)
    {
        ALOGE("output is null");
        return;
    }
    output_len = strlen(output);
    if(out_size != output_len)
    {
        ALOGD("output len not equal to out_size,and send output,output_len = %d",output_len);
        if(out_size > output_len)
        {
            memcpy(buffer,output,output_len);
        }
        else
        {
            memcpy(buffer,output,out_size);
            buffer[out_size] = '\0';
            output_len = out_size+1;
        }
    }
    else
    {
        memcpy(buffer,output,output_len);
    }
    ALOGD("output_len = %d",output_len);
    if(strcmp(serial.devicename[0],map_device(serial_port)) == 0)
    {
        ALOGD("[%s] use writeDataToSerial",__FUNCTION__);
        writeDataToSerial(buffer,output_len);
        return;
    }
    if(type == L_RESP_TYPE)
    {
        if(port_config.io_fd < 0)
        {
            ALOGE("io fd don`t opened");
            return;
        }
        resp_try_write:
        write_len = write(port_config.io_fd, buffer,output_len);
        if(write_len != output_len)
        {
            LOGATCI(LOG_DEBUG, "resp wirte_line=%d,output_len=%d,errno:%d!",write_len,output_len,errno);
            if(write_len == -1)
            {//meybe usb has change,eg.switch adb to rndis mode,or rndis to adb mode,so we need reopen,the reopen time is 5.
                if(count < 5)
                {
                    close(port_config.io_fd);
                    init_pseudo_terminal();
                    usleep(500*1000);
                    count++;
                    LOGATCI(LOG_DEBUG, "retry times = %d",count);
                    goto resp_try_write;
                }
            }
        }
        LOGATCI(LOG_DEBUG, "resp wirte_line=%d,output_len=%d!",write_len,output_len);
    }
    else if(type == L_URC_TYPE)
    {
        if(port_config.urc_fd < 0)
        {
            ALOGE("urc fd don`t opened");
            return;
        }
        urc_try_write:
        write_len = write(port_config.urc_fd, buffer,output_len);
        if(write_len != output_len)
        {
            LOGATCI(LOG_DEBUG, "urc wirte_line=%d,output_len=%d,errno:%d!",write_len,output_len,errno);
            if(write_len == -1)//meybe usb has change,eg.switch adb to rndis mode,or rndis to adb mode,so we need reopen,the reopen time is 5.
            {
                if(count < 5)
                {
                    close(port_config.urc_fd);
                    init_pseudo_terminal();
                    usleep(100*1000);
                    count++;
                    LOGATCI(LOG_DEBUG, "retry times = %d",count);
                    goto urc_try_write;
                }
            }
        }
        LOGATCI(LOG_DEBUG, "urc wirte_line=%d,output_len=%d!",write_len,output_len);
    }
    else
    {
        ALOGE("the type is invalid");
    }
    LOGATCI(LOG_DEBUG, "end retry times = %d",count);
    return;
}


void lynq_write_data_to_serail(char *output,int out_size,int type)
{
    if(type == L_RESP_TYPE)
    {
        ALOGD("device：%s,total:%d,current:%d",serial.devicename[0],serial.totalSize,serial.currDevice);
        if(strcmp(serial.devicename[0],map_device(port_config.serial_io_port)) == 0)
        {
            ALOGD("use writeDataToSerial");
            writeDataToSerial(output,out_size);
        }
        else
        {
            write_data_to_serial_with_port(port_config.serial_io_port,L_RESP_TYPE,output,out_size);
        }
    }
    else if(type == L_URC_TYPE)
    {
        write_data_to_serial_with_port(port_config.serial_urc_port,L_URC_TYPE,output,out_size);
    }
    return;
}
