/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#include <string.h>
#include "atcid_common.h"
#include "atcid.h"

extern int property_get(const char *key, char *value, const char *default_value);
extern int property_set(const char *key, const char *in_value);

int atci_property_get(const char *key, char *value, const char *default_value) {
    int ali_pro_res = property_get(key, value, default_value);
//xf.li@20231120 modify for T8TSK-291 start
    if((strcmp(key, "vendor.ril.iccid.sim1") != 0) && (strcmp(key, "vendor.ril.iccid.sim2") != 0))
    {
        LOGATCI(LOG_DEBUG, "get key is %s, value is %s", key, value);
    }
    else
    {
	if(value != NULL && strlen(value) > 0)
        {
            LOGATCI(LOG_DEBUG, "get key is %s, value is (has got)", key);
        }
        else
        {
            LOGATCI(LOG_DEBUG, "get key is %s, value is ", key);
        }
    }
//xf.li@20231120 modify for T8TSK-291 end
    return ali_pro_res;
}

int atci_property_set(const char *key, const char *value) {
    int ret_val = property_set(key, value);
//xf.li@20231120 modify for T8TSK-291 start
    if((strcmp(key, "vendor.ril.iccid.sim1") != 0) && (strcmp(key, "vendor.ril.iccid.sim2") != 0))
    {
        LOGATCI(LOG_DEBUG, "set key is %s, value is %s", key, value);
    }
    else
    {
	if(value != NULL && strlen(value) > 0)
        {
            LOGATCI(LOG_DEBUG, "set key is %s, value is (has got)", key);
        }
        else
        {
            LOGATCI(LOG_DEBUG, "set key is %s, value is ", key);
        }
    }
//xf.li@20231120 modify for T8TSK-291 end
    return ret_val;
}
