/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */
#include <pthread.h>

#include "atcid_mipc.h"
#include "atcid_adaptation.h"
#include "atcid_common.h"
#include "mipc_msg_tlv_api.h"
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_api.h"

#if defined(CONFIG_TARGET_mt6890) || defined(TELEMATICS)
#include "mipc_trm.h"
#endif
#include "platform.h"

#define ATCI_SIM "persist.vendor.service.atci.sim"

static pthread_t s_tid_atcid_urc;
static bool listen_URC = false;
bool atci_mipc_inited = false;
bool atci_mipc_regCB = false;
static int acti_mipc_md_status = 0;

#if defined(CONFIG_TARGET_mt6890) || defined(TELEMATICS)
static void atcid_mipc_md_event_cb(void *priv_ptr, struct md_status_event* event_ptr)
{
    LOGATCI(LOG_INFO, "Received md event %d!!!",event_ptr->event_type);
    if((0 == acti_mipc_md_status) && (event_ptr->event_type == 12)) { //MD_STA_EV_STOP
        acti_mipc_md_status = 1;
        listen_URC = false;
        atci_mipc_inited = false;
        LOGATCI(LOG_INFO, "reset mipc_inited true");
        LOGATCI(LOG_INFO, "Received MD_STA_EV_STOP event!!!");
    }

    if((1 == acti_mipc_md_status) && (event_ptr->event_type == 10)) { //MD_STA_EV_READY
        acti_mipc_md_status = 0;
        mipc_deinit();
        LOGATCI(LOG_INFO, "mipc_deinit()");
        LOGATCI(LOG_INFO, "Received MD_STA_EV_READY event!!!");
    }
}
#endif

static void atcid_mipc_ind_cb(mipc_msg_t *msg_ptr, void *priv_ptr) {
    char *urc_ptr;
    uint16_t urc_len;

    urc_ptr = mipc_sys_at_ind_get_atcmd(msg_ptr, &urc_len);

    LOGATCI(LOG_INFO, "URC to atcid =%s\n", urc_ptr);

    if (listen_URC) {
        sendCommandResponse(urc_ptr);
    } else {
        LOGATCI(LOG_INFO, "no send URC due to   host cancel\n");
    }
}

waitModemReady () {
    //wait MD ready
    do {
        char buf[64];
        int ccci_fd = open("/sys/kernel/ccci/boot", O_RDONLY);
        if (ccci_fd >= 0) {
            memset(buf, 0, sizeof(buf));
            read(ccci_fd, buf, sizeof(buf));
            close(ccci_fd);

            if (strncmp(buf, "md1:4", 5) == 0) {
                //MD1 is ready
                ALOGD("MD ready!!!");
                break;
            }
        }
        sleep(1);
    } while (1);
}

void* waitMIPCUrc(void *param) {
    UNUSED(param);

    waitModemReady();

    LOGATCI(LOG_INFO, "atcid start to wait for MIPC URC!!!");
    if(!listen_URC) {

        if (!atci_mipc_inited) {
            SETCOM("/dev/ttyCMIPC2");
            mipc_init("atci");
            atci_mipc_inited = true;
            LOGATCI(LOG_INFO, "set mipc_inited true");
        }

    #if defined(CONFIG_TARGET_mt6890) || defined(TELEMATICS)
        if (!atci_mipc_regCB) {
            mipc_md_event_register(atcid_mipc_md_event_cb,NULL);
            atci_mipc_regCB = true;
        }
    #endif

        mipc_msg_register_ind(MIPC_MSG_PS0, MIPC_SYS_AT_IND, (void*)atcid_mipc_ind_cb, NULL);
        mipc_msg_register_ind(MIPC_MSG_PS1, MIPC_SYS_AT_IND, (void*)atcid_mipc_ind_cb, NULL);
        listen_URC = true;
    }
}

void startUrcThread() {
    int ret = 0;

    LOGATCI(LOG_INFO, "create atcid urc thread");
    ret = pthread_create(&s_tid_atcid_urc, NULL, waitMIPCUrc, NULL);
    if (ret != 0) {
        ALOGE("fail to create atcid urc thread. errno:%d", errno);
        return;
    }

    LOGATCI(LOG_INFO, "create atcid urc thread successfully");
    pthread_join(s_tid_atcid_urc, NULL);
}

void stopUrcThread() {
    listen_URC = false;
}

void run_at_cmd(char* cmd) {
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_result_enum result;
    char *atcicmd_req_ptr, *atcmd_res_ptr, *atci_res;
    uint16_t atcmd_req_len, atcmd_res_len;

    char simIDProperty[MTK_PROPERTY_VALUE_MAX];
    int simID = 0;

    int char_sub = 0x1a;
    int char_esc = 0x1b;
    bool contain_sub_esc = false;
    char *pLine = cmd;

    LOGATCI(LOG_INFO, "AT command execution:%s", cmd);

    atci_property_get(ATCI_SIM, simIDProperty, "0");
    simID = atoi(simIDProperty);
    if (simID == 0) {
        LOGATCI(LOG_INFO, "AT command execution on SIM1");
        msg_req_ptr = mipc_msg_init(MIPC_SYS_AT_REQ, MIPC_PS0);
    } else {
        LOGATCI(LOG_INFO, "AT command execution on SIM2");
        msg_req_ptr = mipc_msg_init(MIPC_SYS_AT_REQ, MIPC_PS1);
    }

    if (!listen_URC && !atci_mipc_inited) {

        SETCOM("/dev/ttyCMIPC2");
        mipc_init("atci");
        atci_mipc_inited = true;
        LOGATCI(LOG_INFO, "set mipc_inited true");

    #if defined(CONFIG_TARGET_mt6890) || defined(TELEMATICS)
        if (!atci_mipc_regCB) {
            mipc_md_event_register(atcid_mipc_md_event_cb,NULL);
            atci_mipc_regCB = true;
        }
    #endif

    }

    while(*pLine != '\0') {
        int currChar = (int)*pLine;
        if(char_sub == currChar || char_esc == currChar) {
            contain_sub_esc = true;
        }
        pLine++;
    }

    // add '\r' for all cmd
    // In AT spec, the string need including '\r' but not is the case that is the last sms message finished by Ctrl+Z or ESC
    // In MIPC spec said that the size passing need including '\0'
    if (!contain_sub_esc) {
        atcmd_req_len = strlen(cmd);
        atcicmd_req_ptr = (char *)malloc(atcmd_req_len + 2);  // 1 for '\r', 1 for '\0'
        strncpy(atcicmd_req_ptr, cmd, atcmd_req_len);
        atcicmd_req_ptr[atcmd_req_len] = '\r';
        atcicmd_req_ptr[atcmd_req_len + 1] = '\0';
        atcmd_req_len +=2;

        LOGATCI(LOG_INFO, "AT command execution (with \\r\\0):%s", atcicmd_req_ptr);

    } else {
        atcmd_req_len = strlen(cmd);
        atcicmd_req_ptr = (char *)malloc(atcmd_req_len + 1);  // 1 for '\0'
        strncpy(atcicmd_req_ptr, cmd, atcmd_req_len);
        atcicmd_req_ptr[atcmd_req_len] = '\0';
        atcmd_req_len +=1;

        LOGATCI(LOG_INFO, "AT command execution (with \\r):%s", atcicmd_req_ptr);
    }

    LOGATCI(LOG_INFO, "start mipc_msg_add_tlv");
    mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_AT_REQ_T_ATCMD, atcmd_req_len, atcicmd_req_ptr);

    LOGATCI(LOG_INFO, "start mipc_msg_sync_timeout");
    msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);

    LOGATCI(LOG_INFO, "start mipc_msg_deinit");
    mipc_msg_deinit(msg_req_ptr);

    LOGATCI(LOG_INFO, "start mipc_get_result");
    result = mipc_get_result(msg_cnf_ptr);

    free(atcicmd_req_ptr);

    if (result == MIPC_RESULT_SUCCESS) {
        atcmd_res_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SYS_AT_CNF_T_ATCMD, &atcmd_res_len);
        int res_len = strlen(atcmd_res_ptr);
        printf("res_len is:%d, atcmd_res_len is %d\n", res_len, atcmd_res_len);
        atci_res = (char *)malloc(res_len + 3); //2+1, 2 for adding \r\n before response, 1 for termination
        strncpy(atci_res, "\r\n", 2); //add \r\n
        strncpy(atci_res + 2, atcmd_res_ptr, res_len); //copy reponse string
        atci_res[res_len + 2] = '\0';  // add termination

        printf("AT response:%s with len:%d\n", atci_res, res_len);
        //send respons to atcid
        sendCommandResponse(atci_res);
        free(atci_res);
    } else {
        sendCommandResponse("Unknown error\n");
        printf("Failed to execute:%d\n", result);
    }
    mipc_msg_deinit(msg_cnf_ptr);

    if (!listen_URC) {
        //mipc_deinit();
    }
}

