/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2020. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#include "atci_gpio_cmd.h"
#include "atci_service.h"
#include "atci_util.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define  GPIO_SYS                "/sys/devices/platform/10005000.pinctrl/mt_gpio"

int gpio_count;

static bool __DEBUG__ = true;
#define MGP_LOG(fmt, args...)							\
	do {												\
		if (__DEBUG__)									\
			printf("GPIO: %s: "fmt, __func__,##args); \
	} while (0)

int gpio_set_direction(int gpio_pin, enum GPIO_DIR dir)
{
	int ret;
	char cmd[512];

	if (dir == GPIO_DIR_OUT) {
		// Set out direction
		snprintf(cmd, sizeof(cmd),
			"echo dir %d 1 > %s", gpio_pin, GPIO_SYS);
	} else if (dir == GPIO_DIR_IN) {
		// Set in direction
		snprintf(cmd, sizeof(cmd),
			"echo dir %d 0 > %s", gpio_pin, GPIO_SYS);
	} else {
		MGP_LOG("error dir = %d\r\n", dir);
		ret = -1;
		goto _err;
	}

	ret = system(cmd);
	MGP_LOG("exec %s (%d)\r\n", cmd, ret);

_err:
	return ret;
}

int gpio_set_value(int gpio_pin, enum GPIO_OUT level)
{
	int ret;
	char cmd[512];

	ret = gpio_set_direction(gpio_pin, GPIO_DIR_OUT);
	if (ret)
		return -1;

	if (level == GPIO_OUT_ONE) {
		// Set GPIO high status
		snprintf(cmd, sizeof(cmd),
			"echo out %d 1 > %s", gpio_pin, GPIO_SYS);
	} else {
		// Set GPIO low status
		snprintf(cmd, sizeof(cmd),
			"echo out %d 0 > %s", gpio_pin, GPIO_SYS);
	}

	ret = system(cmd);

	MGP_LOG("exec %s (%d)\r\n", cmd, ret);

	if (ret)
		return -1;
	else
		return 0;
}

int gpio_get_value(int gpio_pin, enum GPIO_OUT *level)
{
	int ret;
	FILE *fp;
	char *fg = NULL;
	char cmd[512], res[512];

	/* change dir as intput */
	ret = gpio_set_direction(gpio_pin, GPIO_DIR_IN);
	if (ret)
		return -1;

	/* wait 150 ms to stable*/
	usleep(150 * 1000);

	snprintf(cmd, sizeof(cmd),
		"cat %s | grep %03d:", GPIO_SYS, gpio_pin);

	fp = popen(cmd, "r");
	if (!fp) {
		MGP_LOG("exec %s fail\r\n", cmd);
		goto _err;
	}

	MGP_LOG("exec %s\r\n", cmd);

	fg = fgets(res, sizeof(res), fp);

	pclose(fp);

	if (!fg)
		goto _err;

	MGP_LOG("res %s, [3] = %c, [8] = %c\r\n", res, res[3], res[8]);

	/* String format
	 * PIN: (MODE)(DIR)(DOUT)(DIN)(DRIVE)(SMT)(IES)(PULL_EN)(PULL_SEL)(R1 R0)
	 * 000: 0000001110
	 */
	if (res[8] == '1') {
		// Current GPIO status high
		*level = GPIO_OUT_ONE;
	} else if (res[8] == '0') {
		// Current GPIO status low
		*level = GPIO_OUT_ZERO;
	} else
		goto _err;

	return 0;

_err:
	return -1;
}

bool GPIO_Init(void)
{
	int ret;
	FILE *fp;
	char *fg = NULL;
	char cmd[512], res[512];

	snprintf(cmd, sizeof(cmd), "chmod 664 %s", GPIO_SYS);

	ret = system(cmd);

	MGP_LOG("exec %s (%d)\r\n", cmd, ret);
	if (ret)
		goto _err;

	snprintf(cmd, sizeof(cmd),
		"cat %s | grep count: | awk '{print $6}'", GPIO_SYS);

	fp = popen(cmd, "r");
	if (!fp) {
		MGP_LOG("exec %s fail\r\n", cmd);
		goto _err;
	}

	fg = fgets(res, sizeof(res), fp);

	pclose(fp);

	if (!fg) {
		ret = -1;
		goto _err;
	}

	sscanf(res, "%d", &gpio_count);
	MGP_LOG("res %s, gpio_count = %d\r\n", res, gpio_count);

_err:
	if (ret)
		return false;
	else 
		return true;
}

bool GPIO_Deinit(void)
{
	int ret;
	char cmd[512];

	snprintf(cmd, sizeof(cmd), "chmod 644 %s", GPIO_SYS);

	ret = system(cmd);

	MGP_LOG("exec %s (%d)\r\n", cmd, ret);

	if (ret)
		return false;
	else 
		return true;
}

/*****************************************************************************/
#define TAG "[GPIO_TEST] "

int gpio_cmd_handler(char* cmdline, ATOP_t at_op, char* response)
{
	int ret = 0;
	int gpio_no = -1, op_code = -1;
	int val;

	ALOGD(TAG"gpio cmdline=%s, at_op=%d \r\n", cmdline, at_op);

    if (!GPIO_Init()) {
		ret = -1;
		goto out;
    }

	switch(at_op) {
		case AT_SET_OP:
			ret = sscanf(cmdline, "%d,%d", &gpio_no, &op_code);
			ALOGD(TAG"gpio_no=%d, op_code=%d, ret=%d\r\n",
				gpio_no, op_code, ret);
			/* need 2 parameter */
			if (ret != 2) {
				ALOGD(TAG"input count error %d\r\n", ret);
				ret = -1;
				goto out;
			}

			if (gpio_no >= gpio_count) {
				ALOGD(TAG"set gpio_no=%d larger than total count %d\r\n",
					gpio_no, gpio_count);
				ret = -1;
				goto out;
			}

			switch(op_code) {
				case SET_GPIO_OUTPUT_LOW:
					ALOGD(TAG"set gpio_no=%d low\r\n", gpio_no);
					ret = gpio_set_value(gpio_no, GPIO_OUT_ZERO);
					if (!ret)
						sprintf(response, "OK\r\n");
					break;
				case SET_GPIO_OUTPUT_HIGH:
					ALOGD(TAG"set gpio_no=%d high\r\n", gpio_no);
					ret = gpio_set_value(gpio_no, GPIO_OUT_ONE);
					if (!ret)
						sprintf(response, "OK\r\n");
					break;
				case GET_GPIO_LEVEL:
					ALOGD(TAG"get gpio_no=%d level\r\n", gpio_no);
					ret = gpio_get_value(gpio_no, &val);
					if (!ret) {
						ALOGD(TAG"get gpio_no=%d val=%d\r\n",
							gpio_no, val);
						sprintf(response, "+TGPIO=%d,%d\r\nOK\r\n",
							gpio_no, val);
					}
					break;
				default:
					ret = -1;
					break;
			}
			break;
		default:
			ALOGD(TAG"not supported at_op=%d\r\n", at_op);
			ret = -1;
			break;
	}

out:
    GPIO_Deinit();

	if (ret) {
		ALOGD(TAG"%s, gpio_no=%d, op=%d, ret=%d failed\r\n",
			cmdline, gpio_no, op_code, ret);
		sprintf(response, "ERROR\r\n");
	}

    return ret;
}
