/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>
#include <pthread.h>
#include <linux/ioctl.h>

#include <stdbool.h>

#include "atci_typec_cmd.h"
#include "atci_service.h"
#include "atci_util.h"

#define TAG                 "[USB TYPEC] "
#define TYPEC_ERROR_COUNT_PATH "/sys/devices/platform/usb-phy@11e30000/phy/phy-usb-phy@11e30000.1/loopback_test"
#define FUSB_SEL_PATH "/sys/devices/platform/typec_switch/sw"

/* depends on typec driver */
#define TYPEC_U2_CC "/sys/kernel/debug/usb_c/smt_u2_cc_mode"

enum {
	ITEM_FAIL,
	ITEM_PASS,
};

struct usb_typec {
	char  info[1024];
	bool  avail;
	bool  exit_thd;
	int  test_type;

	pthread_t typec_update_thd;
};

static struct usb_typec priv; 

int g_result_usb_typec = ITEM_FAIL;

static int check_sel_path(void)
{
	int fd_mux = -1;

	fd_mux = open(FUSB_SEL_PATH, O_WRONLY, 0);
	if (fd_mux < 0) {
		ALOGD(TAG "Can't open %s\n", FUSB_SEL_PATH);
		return 0;
	}
	close(fd_mux);
	return 1;
}

static bool usb_cc_pin_test(void)
{
	int fd = -1;
	int cc_status = -1;
	int ret = 0;

	fd = open(TYPEC_U2_CC, O_RDONLY, 0);
	if (fd < 0) {
		ALOGD(TAG "Can't open %s\n", TYPEC_U2_CC);
		goto end;
	}

	ret = read(fd, &cc_status, sizeof(cc_status));
	if (ret <= 0) {
		goto close_cc_fd;
	}

	ALOGD(TAG "Result_CC = %d\n", cc_status);

	ret = cc_status;

close_cc_fd:
	close(fd);
end:
	return ret;
}

static bool usb_u3_loopback(void)
{
	int fd = -1;
	int fd_mux = -1;

	char side_1 = -1;
	char side_2 = -1;
	int ret = -1;

	fd_mux = open(FUSB_SEL_PATH, O_WRONLY, 0);
	if (fd_mux < 0) {
		ALOGD(TAG "Can't open %s\n", FUSB_SEL_PATH);
		ret = ITEM_FAIL;
		goto end;
	}

	fd = open(TYPEC_ERROR_COUNT_PATH, O_RDONLY, 0);
	if (fd < 0) {
		ALOGD(TAG "Can't open %s\n", TYPEC_ERROR_COUNT_PATH);
		goto close_fd_mux;
	}

	write(fd_mux, "1", 1);

	ret = read(fd, &side_1, sizeof(side_1));
	ALOGD(TAG "%s: side1: %d ret: %d\n", __FUNCTION__, side_1, ret);
	if (ret <= 0) {
		goto close_fd;
	}

	write(fd_mux, "2", 1);

	/* avoid read ret is 0 */
	lseek(fd, 0, SEEK_SET);

	ret = read(fd, &side_2, sizeof(side_2));
	ALOGD(TAG "%s: side2: %d ret: %d\n", __FUNCTION__, side_2, ret);
	if (ret <= 0) {
		goto close_fd;
	}

	/* convert hex to value */
	/* 0: fail, 1: pass */
	side_1 = (char)atoi(&side_1);
	side_2 = (char)atoi(&side_2);

	ret = side_1 && side_2;

	ALOGD(TAG "Result = %d, %d, ret: %d\n", side_1, side_2, ret);
close_fd:
	close(fd);
close_fd_mux:
	write(fd_mux, "0", 1);
	close(fd_mux);
end:
	return ret;
}

static int update_cc_pin_info(struct usb_typec *hds, char *info)
{
	char *ptr;
	int fd = -1;

	char ret = '9';
	int ret1 = 0;

	ptr  = info;
	hds->avail = false;


	fd = open(TYPEC_U2_CC, O_RDONLY, 0);
	if (fd < 0) {
		ALOGD(TAG "Can't open %s\n", TYPEC_U2_CC);
		ptr += sprintf(ptr, "can't test CC pin!!\n");
	} else {
		if (read(fd, &ret, sizeof(ret)) <= 0) {
			ALOGD(TAG "Read fail (ret1)\n");
		}
		close(fd);
	}

	ALOGD(TAG "ret=%c\n", ret);

	/*success return char '1', fail return char '0'.*/
	if (ret == '1') {
		ret1 = 1;
		ptr += sprintf(ptr, "CC pin test pass\n");
	} else {
		ret1 = 0;
		ptr += sprintf(ptr, "CC pin test fail\n");
	}

	ALOGD(TAG "ret1=%d\n", ret1);

	if (ret1) {
		return ITEM_PASS;
	} else {
		ptr += sprintf(ptr, "CC pin test fail, please check cable!!\n");
		return ITEM_FAIL;
	}
}

static int update_info(struct usb_typec *hds, char *info)
{
	char *ptr;
	int fd = -1;
	int fd_mux = -1;

	char ret = '9';
	int ret1 = 0;
	int ret2 = 0;

	ptr  = info;
	hds->avail = false;

	fd_mux = open(FUSB_SEL_PATH, O_WRONLY, 0);
	if (fd_mux < 0) {
		ALOGD(TAG "Can't open %s\n", FUSB_SEL_PATH);
		ptr += sprintf(ptr, "can't control mux!!\n");
		goto end;
	}

	/* Side 1 */
	write(fd_mux, "1", 1);

	fd = open(TYPEC_ERROR_COUNT_PATH, O_RDONLY, 0);
	if (fd < 0) {
		ALOGD(TAG "Can't open %s\n", TYPEC_ERROR_COUNT_PATH);
		ptr += sprintf(ptr, "can't loop back!!\n");
	} else {
		if (read(fd, &ret, sizeof(ret)) <= 0) {
			ALOGD(TAG "Read fail (ret1)\n");
		}
		close(fd);
	}

	ALOGD(TAG "ret=%c\n", ret);

	/*success return char '1', fail return char '0'.*/
	if (ret == '1') {
		ret1 = 1;
		ptr += sprintf(ptr, "loop back pass(side up)\n");
	} else {
		ret1 = 0;
		ptr += sprintf(ptr, "loop back fail(side up)\n");
	}

	/* Side 2 */
	write(fd_mux, "2", 1);

	fd = open(TYPEC_ERROR_COUNT_PATH, O_RDONLY, 0);
	if (fd < 0) {
		ALOGD(TAG "Can't open %s\n", TYPEC_ERROR_COUNT_PATH);
		ptr += sprintf(ptr, "can't loop back!!\n");
	} else {
		if (read(fd, &ret, sizeof(ret)) <= 0){
			ALOGD(TAG "Read fail (ret2)\n");
		}
		close(fd);
	}

	ALOGD(TAG "ret=%c\n", ret);

	if (ret == '1') {
		ret2 = 1;
		ptr += sprintf(ptr, "loop back pass(side down)\n");
	} else {
		ret2 = 0;
		ptr += sprintf(ptr, "loop back fail(side down)\n");
	}

	write(fd_mux, "0", 1);

end:
	if (fd_mux >= 0)
		close(fd_mux);

	ALOGD(TAG "ret1=%d, ret2=%d\n", ret1, ret2);

	if (ret1 && ret2) {
		return ITEM_PASS;
	} else {
		ptr += sprintf(ptr, "loop back fail, please check cable!!\n");
		return ITEM_FAIL;
	}
}

static void *typec_update_iv_thread(void *priv)
{
	struct usb_typec *hds = (struct usb_typec *)priv;

	int retry = 10;

	ALOGD(TAG "%s: Start\n", __FUNCTION__);

	while (1) {
		ALOGD(TAG "%s: retry %d\n", __FUNCTION__, retry);
		usleep(200000);

		if (retry > 0) {
			retry--;
		}

		if (hds->exit_thd)
			break;

		if (check_sel_path()) {
			g_result_usb_typec = update_info(hds, hds->info);
		} else {
			g_result_usb_typec = update_cc_pin_info(hds, hds->info);
		}

		if ((retry == 0) || (g_result_usb_typec == ITEM_PASS)) {
			break;
		}
	}

	ALOGD(TAG "%s: Exit\n", __FUNCTION__);
	usleep(1000000);
#if 0
	} else {
		pthread_exit(NULL);
	}
#endif
	return NULL;
}


int usb_typec_cmd_handler(char* cmdline, ATOP_t at_op, char* response)
{
	int chosen;
	bool exit = false;
	struct usb_typec *hds = (struct usb_typec *)&priv;

	ALOGD("handle cmdline:%s", cmdline);
	sprintf(response, "\r\n\r\nFAILED\r\n\r\n");

	hds->exit_thd = false;

#if 0
	if (FTM_AUTO_ITEM == param->test_type) {
		iv->set_items(iv, auto_menu_items, 0);
	} else {
		iv->set_items(iv, manual_menu_items, 0);
	}
#endif

//	if (FTM_AUTO_ITEM == param->test_type) {
//	typec_update_iv_thread(priv);
//	pthread_create(&hds->typec_update_thd, NULL, typec_update_iv_thread, &priv);
	do {
		if (check_sel_path()) {
			if(usb_u3_loopback())
				chosen = ITEM_PASS;
			else
				chosen = ITEM_FAIL;
		} else {
			if(usb_cc_pin_test())
				chosen = ITEM_PASS;
			else
				chosen = ITEM_FAIL;
		}

		switch (chosen) {
		case ITEM_PASS:
		case ITEM_FAIL:
			if (chosen == ITEM_PASS) {
				sprintf(response, "\r\n\r\nOK\r\n\r\n");
			} else if (chosen == ITEM_FAIL) {
				sprintf(response, "\r\n\r\nOK\r\n\r\n");
			}
			exit = true;
		break;
		}

		if (exit) {
			hds->exit_thd = true;
			break;
		}
	} while (1);
//	pthread_join(hds->typec_update_thd, NULL);

	ALOGD(TAG "g_result_usb_typec=%x\n", g_result_usb_typec);

	if (chosen == ITEM_PASS)
		sprintf(response, "\r\n\r\nOK\r\n\r\n");
	else
		sprintf(response, "\r\n\r\nFAILED\r\n\r\n");

	return 0;
}
