/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2008
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/
/*****************************************************************************
 *
 * Filename:
 * ---------
 *   ccci_mdinit.h
 *
 * Project:
 * --------
 *  
 *
 * Description:
 * ------------
 *   
 *
 * Author:
 * -------
 *   
 *
 ****************************************************************************/

#ifndef __CCCI_MD_INIT_CFG_H__
#define __CCCI_MD_INIT_CFG_H__

#define CCCI_TIMEZONE_FILE	"/data/ccci_cfg/timezone"
#define CCCI_TIME_UPDATE_PORT	"/dev/ccci_ipc_5"
//----------------debug log define-----------------//
#define MD_COMM_TAG				"[ccci_mdinit]"
#include <syslog.h>
#define DEBUGLEVEL LOG_LEVEL_ERR
#define DEBUG 1

#ifdef DEBUG
/*
 * The maximum log level for messages to be logged to the syslog.
 * Only messages with a level lower than this will be printed to the console.
 */
enum {
    LOG_LEVEL_ERR,
    LOG_LEVEL_WARNING,
    LOG_LEVEL_INFO,
    LOG_LEVEL_DEBUG,
};
#define PRINTF(fmt, ...) syslog(LOG_DEBUG, fmt, ## __VA_ARGS__)

#define LOGD(fmt, ...) \
do { \
    if (LOG_LEVEL_DEBUG <= DEBUGLEVEL) \
        PRINTF(fmt, ##__VA_ARGS__); \
} while(0)

#define LOGI(fmt, ...) \
do { \
    if (LOG_LEVEL_INFO <= DEBUGLEVEL) \
        PRINTF(fmt, ##__VA_ARGS__); \
} while(0)

#define LOGW(fmt, ...) \
do { \
    if (LOG_LEVEL_WARNING <= DEBUGLEVEL) \
        PRINTF(fmt, ##__VA_ARGS__); \
} while(0)

#define LOGE(fmt, ...) \
do { \
    if (LOG_LEVEL_ERR <= DEBUGLEVEL) \
        PRINTF(fmt, ##__VA_ARGS__); \
} while(0)

#define LOGE_COM(fmt, ...) \
do { \
    if (LOG_LEVEL_ERR <= DEBUGLEVEL) \
        PRINTF(fmt, ##__VA_ARGS__); \
} while(0)

#else

#ifdef NEED_CTRL_AS_SP
/* deleted for code size */
#else
#define LOGV(...)	do{ printf(MD_COMM_TAG, __VA_ARGS__); }while(0)

#define LOGD(...)	do{ printf(MD_COMM_TAG, __VA_ARGS__); }while(0)

#define LOGI(...)	do{ printf(MD_COMM_TAG, __VA_ARGS__); }while(0)

#define LOGW(...)	do{ printf(MD_COMM_TAG, __VA_ARGS__); }while(0)

#define LOGE(...)	do{ printf(MD_COMM_TAG, __VA_ARGS__); }while(0)

#define LOGE_COM(...)	do{ printf(MD_COMM_TAG, __VA_ARGS__); }while(0)
#endif
#endif

#ifdef NEED_CTRL_AS_SP
/* deleted for code size */
#else
#define SMSG_DEBUG(fmt, ...) \
	do{ printf(MD_COMM_TAG fmt, ##__VA_ARGS__); }while(0)

#define SMSG_ERROR(fmt, ...) \
	do{ printf(MD_COMM_TAG fmt, ##__VA_ARGS__); }while(0)

#define SMSG_INFO(fmt, ...) \
	do{ printf(MD_COMM_TAG fmt, ##__VA_ARGS__); }while(0)
#endif

#endif

