#define LOG_TAG "NW_ADAPTER"
#include "mtk_log.h"

#include <utils/Log.h>
#include "RpNwAdapter.h"
#include "Rfx.h"


RpNwAdapter* RpNwAdapter::sInstance = NULL;

RpNwAdapter::RpNwAdapter() {
}

RpNwAdapter::~RpNwAdapter() {
}

RpNwAdapter *RpNwAdapter::getInstance() {
    if (sInstance == NULL) {
        RLOGD("RpNwAdapter getInstance \n");
        sInstance = new RpNwAdapter();
        sInstance->init();
    }
    return sInstance;
}

void RpNwAdapter::closeInstance() {
    if (sInstance != NULL) {
        sInstance->deInit();
        sInstance = NULL;
    }
}

void RpNwAdapter::init() {
    //Start Thread
    RLOGD("RpNwAdapter init\n");
    mResponseHandleThread = new ResponseHandleThread(this);
    mResponseHandleThread->run("response thread");
}

void RpNwAdapter::deInit() {

}

void RpNwAdapter::responseConditionSignal() {
    m_RespMutex.lock();
    m_RespCondition.signal();
    m_RespMutex.unlock();
}

void RpNwAdapter::responseConditionWait() {
    m_RespMutex.lock();
    m_RespCondition.wait(m_RespMutex);    
    m_RespMutex.unlock();
}

// Method implements of ResponseHandleThread
RpNwAdapter::ResponseHandleThread::ResponseHandleThread(RpNwAdapter* adapter) : m_looper(NULL) {
    mAdapter = adapter;
    RLOGD("ResponseHandleThread created");
}

RpNwAdapter::ResponseHandleThread::~ResponseHandleThread() {
    mAdapter = NULL;
    RLOGD("ResponseHandleThread destroyed");
}

bool RpNwAdapter::ResponseHandleThread::threadLoop() {
    RLOGD("ResponseHandleThread threadLoop");
    // start message loop
    m_looper = Looper::prepare(0);
    int result;
    do {
        result = m_looper->pollAll(-1);
        RLOGD("ResponseHandleThread threadLoop, pull message result = %d", result);
    } while (result == Looper::POLL_WAKE || result == Looper::POLL_CALLBACK);
    return true;
}

sp<Looper> RpNwAdapter::ResponseHandleThread::getLooper() {
    return m_looper;
}

//Response Message

RpNwAdapter::ResponseMessage::ResponseMessage() {
}


RpNwAdapter::ResponseHandler::ResponseHandler(RpNwAdapter* adapter) {
    mAdapter = adapter;
}
extern void RFX_onRequestComplete(RIL_Token t, RIL_Errno e, Parcel *parcel);

//Response Handler
void RpNwAdapter::ResponseHandler::handleMessage(const Message& message) {
    int token = mMsg->mToken;
    switch (token) {
    case 99:
    {
        RLOGD("Message handler receive message token=%d\n",token);
        mipc_sim_ps_id_enum ps_id = MIPC_API_PS0;
        mipc_nw_signal_state_struct signal_state_result;
        signal_state_result.result_code =(mipc_result_enum)0;
        signal_state_result.info_count = 1;
        #if 0
        signal_state_result.infos[0].current_data_class = MIPC_ENUM_DATA_LTE;
        signal_state_result.infos[0].rssi = 90;
        signal_state_result.infos[0].rsrp = 80;
        #endif
        RLOGD("handleMessage PrivateData %x\n",mMsg->mPrivateData);
        //mMsg->mCb(ps_id,&signal_state_result,mMsg->mPrivateData);
        RFX_onRequestComplete(mMsg->mPrivateData, RIL_E_REQUEST_NOT_SUPPORTED, NULL);
        //rfx_enqueue_response_message(RADIO_TECH_GROUP_GSM,NULL,mMsg->mPrivateData,(RIL_SOCKET_ID)0,RIL_E_REQUEST_NOT_SUPPORTED);
        break;
    }
    default:
        break;
    }
}

//Called by other thread to send message to Response handle
sp<RpNwAdapter::ResponseHandler> RpNwAdapter::sendMessage(sp<ResponseMessage> msg, int delayms) {
    ALOGD("sendMessage msg token=%d delayms=%d", msg->mToken, delayms);
    // Create a handler to handle this message
    sp<ResponseHandler> handler = new ResponseHandler(this);
    handler->mMsg = msg;
    // Sand message to looper
    if (delayms > 0) {
        mResponseHandleThread->getLooper()->sendMessageDelayed(ms2ns(delayms),
                handler, handler->m_dummyMsg);
    } else {
        mResponseHandleThread->getLooper()->sendMessage(handler, handler->m_dummyMsg);
    }
    return handler;
}

void RpNwAdapter::test(MIPC_NW_SIGNAL_STATE_GET_CB cb,void *privateData) {
    RLOGD("releaseDedicatedApn_handler");
    // Create a request message
    sp<ResponseMessage> msg = new ResponseMessage();
    msg->mToken = 99;
    msg->mPrivateData = privateData;
    msg->mCb = cb;
    
    RLOGD("test PrivateData %x\n",privateData);
    sendMessage(msg, 0);
}
