// SPDX-License-Identifier: MediaTekProprietary
/* //device/libs/telephony/ril.cpp
**
** Copyright 2006, The Android Open Source Project
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
*/

#define LOG_TAG "RILC"

#include "mtk_log.h"
#include <mtk_power.h>
#include <telephony/ril_cdma_sms.h>
#include <telephony/mtk_ril.h>
#include <telephony/mtk_ril_ivt.h>
#include <libmtkrilutils.h>
#include <cutils/sockets.h>
#include <cutils/jstring.h>
#include <telephony/record_stream.h>
#include <log/mtk_log.h>
#include <utils/SystemClock.h>
#include <pthread.h>
#include <binder/Parcel.h>
#include <cutils/jstring.h>
#include <sys/types.h>
#include <limits.h>
#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <errno.h>
#include <assert.h>
#include <ctype.h>
#include <sys/un.h>
#include <assert.h>
#include <netinet/in.h>
#include <mtk_properties.h>
#include <RilSapSocket.h>
#include <semaphore.h>
#if !defined(__ANDROID__)
#include <signal.h>
#endif
/// M: eMBMS feature
#include <telephony/mtk_ril_embms_def.h>
#include <telephony/mtk_ril_request_info.h>

#ifdef HAVE_AEE_FEATURE
#include "aee.h"
#endif

#include <netagent/NetAgentService.h>




extern "C" void
RIL_onRequestComplete(RIL_Token t, RIL_Errno e, void *response, size_t responselen);

extern "C" void
RIL_onRequestAck(RIL_Token t);

/// MTK_RIL_ADAPTER @{
extern "C" void
RIL_onIssueLocalRequest(int request, void *data, int len, RIL_SOCKET_ID socket_id);
/// @}

extern void
onRequest (int request, Parcel *parcel, RIL_Token t, RIL_SOCKET_ID socket_id);

namespace android {

#define PHONE_PROCESS "radio"
#define BLUETOOTH_PROCESS "bluetooth"

#define SOCKET_NAME_RIL_NORMAL "rild"
#define SOCKET2_NAME_RIL_NORMAL "rild2"
#define SOCKET3_NAME_RIL_NORMAL "rild3"
#define SOCKET4_NAME_RIL_NORMAL "rild4"

#define SOCKET_NAME_RIL_TEST "rild-test"
#define SOCKET2_NAME_RIL_TEST "rild2-test"
#define SOCKET3_NAME_RIL_TEST "rild3-test"
#define SOCKET4_NAME_RIL_TEST "rild4-test"

const char socket_status[RIL_SLOT_MAX][35]= {
    "rild.socket.status1",
    "rild.socket.status2",
};

char semName[RIL_SLOT_MAX][20] = {
    "/sem_socket1",
    "/sem_socket2",
};

extern "C" const char * RIL_getRilSocketNameById(RIL_SOCKET_ID socket_id) {
    const char* socket_name;
    char test_mode[PROP_VALUE_MAX] = {0};
    mtk_property_get("persist.ril.test_mode", test_mode, "0");
    if (strcmp(test_mode, "0") == 0) {
        switch (socket_id) {
        case RIL_SOCKET_1:
            socket_name = SOCKET_NAME_RIL_NORMAL;
            break;
        case RIL_SOCKET_2:
            socket_name = SOCKET2_NAME_RIL_NORMAL;
            break;
        case RIL_SOCKET_3:
            socket_name = SOCKET3_NAME_RIL_NORMAL;
            break;
        case RIL_SOCKET_4:
            socket_name = SOCKET4_NAME_RIL_NORMAL;
            break;
        default:
            RLOGE("Socket id is wrong!!");
            return NULL;
        }
    } else { //test mode
        RLOGD("getRilSocketNameById %d under debug mode!", socket_id);
        switch (socket_id) {
        case RIL_SOCKET_1:
            socket_name = SOCKET_NAME_RIL_TEST;
            break;
        case RIL_SOCKET_2:
            socket_name = SOCKET2_NAME_RIL_TEST;
            break;
        case RIL_SOCKET_3:
            socket_name = SOCKET3_NAME_RIL_TEST;
            break;
        case RIL_SOCKET_4:
            socket_name = SOCKET4_NAME_RIL_TEST;
            break;
        default:
            RLOGE("Socket id is wrong!!");
            return NULL;
        }
    }

    return socket_name;
}

#define SOCKET_NAME_RIL RIL_getRilSocketNameById(RIL_SOCKET_1)
#define SOCKET2_NAME_RIL RIL_getRilSocketNameById(RIL_SOCKET_2)
#define SOCKET3_NAME_RIL RIL_getRilSocketNameById(RIL_SOCKET_3)
#define SOCKET4_NAME_RIL RIL_getRilSocketNameById(RIL_SOCKET_4)

#define SOCKET_NAME_RIL_DEBUG "rild-debug"

#define ANDROID_WAKE_LOCK_NAME "radio-interface"

#define ANDROID_WAKE_LOCK_SECS 0
#define ANDROID_WAKE_LOCK_USECS 200000

#define CONF_CALL_ID_SHIFT 100

#define PROPERTY_RIL_IMPL "gsm.version.ril-impl"

// match with constant in RIL.java
#define MAX_COMMAND_BYTES (20 * 1024)

// Basically: memset buffers that the client library
// shouldn't be using anymore in an attempt to find
// memory usage issues sooner.
#define MEMSET_FREED 1

#define NUM_ELEMS(a)     (sizeof (a) / sizeof (a)[0])

#define MIN(a,b) ((a)<(b) ? (a) : (b))

/* Constants for response types */
#define RESPONSE_SOLICITED 0
#define RESPONSE_UNSOLICITED 1
#define RESPONSE_SOLICITED_ACK 2
#define RESPONSE_SOLICITED_ACK_EXP 3
#define RESPONSE_UNSOLICITED_ACK_EXP 4

/* Negative values for private RIL errno's */
#define RIL_ERRNO_INVALID_RESPONSE -1
#define RIL_ERRNO_NO_MEMORY -12

// request, response, and unsolicited msg print macro
#define PRINTBUF_SIZE 8096

// Enable verbose logging
#define VDBG 1
#define RILJDBG 0

// Enable RILC log
#define RILC_LOG 0

#if RILC_LOG
    #define startRequest           sprintf(printBuf, "(")
    #define closeRequest           sprintf(printBuf, "%s)", printBuf)
    #define printRequest(token, req)           \
            RLOGD("[%04d]> %s %s", token, requestToString(req), printBuf)

    #define startResponse           sprintf(printBuf, "%s {", printBuf)
    #define closeResponse           sprintf(printBuf, "%s}", printBuf)
    #define printResponse           RLOGD("%s", printBuf)

    #define clearPrintBuf           printBuf[0] = 0
    #define removeLastChar          printBuf[strlen(printBuf)-1] = 0
    #define appendPrintBuf(x...)    snprintf(printBuf, PRINTBUF_SIZE, x)
#else
    #define startRequest
    #define closeRequest
    #define printRequest(token, req)
    #define startResponse
    #define closeResponse
    #define printResponse
    #define clearPrintBuf
    #define removeLastChar
    #define appendPrintBuf(x...)
#endif

enum WakeType {DONT_WAKE, WAKE_PARTIAL};

// MTK-START [mtk80776] WiFi Calling
typedef struct {
    int sessionId;  /* for +CRLA */
    int command;    /* one of the commands listed for TS 27.007 +CRSM/CRLA*/
    int fileId;     /* EF id */
    char *path;     /* "pathid" from TS 27.007 +CRSM command.
                       Path is in hex asciii format eg "7f205f70"
                       Path must always be provided.
                     */
    int p1;
    int p2;
    int p3;
    char *data;     /* May be NULL*/
    char *pin2;     /* May be NULL*/
    char *aidPtr;   /* AID value, See ETSI 102.221 8.1 and 101.220 4, NULL if no value. */
} RIL_UICC_IO_v6;

typedef struct {
    int session_id;
    char *context1;
    char *context2;
} RIL_UICC_Authentication;

// [New R8 modem FD]
typedef struct {
    int argsNum;  // record total number of arguments of this mode
    int mode;  // allowed mode:0,1,2,3
    int parameter1;  // only mode 2 and 3 has parameter1 this field
    int parameter2;  // only mode2 has parameter2 this field
}RIL_FdModeData;

typedef struct {
    int type;                  /* type of the entry, refer to RIL_PhbStorageType */
    int index;                 /* the stored index of the entry */
    char *number;              /* the phone number */
    int ton;                   /* type of the number */
    char * alphaId;            /* the alpha ID, using Hexdecimal coding method */
} RIL_PhbEntryStrucutre;

typedef struct {
    int requestNumber;
    int (*responseFunction) (Parcel &p, void *response, size_t responselen);
    WakeType wakeType;
} UnsolResponseInfo;

typedef struct UserCallbackInfo {
    RIL_TimedCallback p_callback;
    void *userParam;
    struct ril_event event;
    struct UserCallbackInfo *p_next;
} UserCallbackInfo;

extern "C" const char * requestToString(int request);
extern "C" const char * failCauseToString(RIL_Errno);
extern "C" const char * callStateToString(RIL_CallState);
extern "C" const char * radioStateToString(RIL_RadioState);
extern "C" const char * rilSocketIdToString(RIL_SOCKET_ID socket_id);
extern "C"
char rild[MAX_SOCKET_NAME_LENGTH] = { 0 };
/*******************************************************************/

RIL_RadioFunctions s_callbacks = {0, NULL, NULL, NULL, NULL, NULL};
static int s_registerCalled = 0;

static pthread_t s_tid_dispatch;
static pthread_t s_tid_reader;
static int s_started = 0;

static int s_fdDebug = -1;
static int s_fdDebug_socket2 = -1;

static int s_fdWakeupRead;
static int s_fdWakeupWrite;

int s_wakelock_count = 0;

static struct ril_event s_commands_event;
static struct ril_event s_wakeupfd_event;
static struct ril_event s_listen_event;
static SocketListenParam s_ril_param_socket;

static pthread_mutex_t s_pendingRequestsMutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t s_writeMutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t s_wakeLockCountMutex = PTHREAD_MUTEX_INITIALIZER;
static RequestInfo *s_pendingRequests = NULL;

static struct ril_event s_commands_event_socket2;
static struct ril_event s_listen_event_socket2;
static SocketListenParam s_ril_param_socket2;

static pthread_mutex_t s_pendingRequestsMutex_socket2  = PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t s_writeMutex_socket2            = PTHREAD_MUTEX_INITIALIZER;
static RequestInfo *s_pendingRequests_socket2          = NULL;

static struct ril_event s_commands_event_socket3;
static struct ril_event s_listen_event_socket3;
static SocketListenParam s_ril_param_socket3;

static pthread_mutex_t s_pendingRequestsMutex_socket3  = PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t s_writeMutex_socket3            = PTHREAD_MUTEX_INITIALIZER;
static RequestInfo *s_pendingRequests_socket3          = NULL;

static struct ril_event s_commands_event_socket4;
static struct ril_event s_listen_event_socket4;
static SocketListenParam s_ril_param_socket4;

static pthread_mutex_t s_pendingRequestsMutex_socket4  = PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t s_writeMutex_socket4            = PTHREAD_MUTEX_INITIALIZER;
static RequestInfo *s_pendingRequests_socket4          = NULL;


// support for multi-client socket
static struct ril_event* s_commands_event_socket_client;
static struct ril_event* s_listen_event_socket_client;
static SocketListenParam* s_ril_param_socket_clients;

static pthread_mutex_t* s_pendingRequestsMutex_socket_client;
static pthread_mutex_t* s_writeMutex_socket_client;
static RequestInfo **s_pendingRequests_socket_client;

/* RILJ client socket @{ */

static struct ril_event s_commands_event_socket_rilj;
static struct ril_event s_listen_event_socket_rilj;
static SocketListenParam s_ril_param_socket_rilj;

static pthread_mutex_t s_pendingRequestsMutex_socket_rilj  = PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t s_writeMutex_socket_rilj            = PTHREAD_MUTEX_INITIALIZER;
static RequestInfo *s_pendingRequests_socket_rilj          = NULL;

static struct ril_event s_commands_event_socket_rilj2;
static struct ril_event s_listen_event_socket_rilj2;
static SocketListenParam s_ril_param_socket_rilj2;

static pthread_mutex_t s_pendingRequestsMutex_socket_rilj2  = PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t s_writeMutex_socket_rilj2            = PTHREAD_MUTEX_INITIALIZER;
static RequestInfo *s_pendingRequests_socket_rilj2          = NULL;

static SocketListenParam* s_rilj_socket_params[] = {
            &s_ril_param_socket_rilj, &s_ril_param_socket_rilj2 };

static SocketListenParam* s_ril_socket_params[] = { &s_ril_param_socket,
        &s_ril_param_socket2, &s_ril_param_socket3, &s_ril_param_socket4,
        &s_ril_param_socket_rilj, &s_ril_param_socket_rilj2 };

#define SOCKET_NAME_RILJCLIENT "rild-rilj"
#define SOCKET2_NAME_RILJCLIENT "rild-rilj2"
static int s_riljclient_support = -1;
#define RILJ_CLIENT_SUPPORT_KEY "persist.ril.riljsupport"

/* }@ */

static struct ril_event s_wake_timeout_event;
static struct ril_event s_debug_event;


static const struct timeval TIMEVAL_WAKE_TIMEOUT = {ANDROID_WAKE_LOCK_SECS,ANDROID_WAKE_LOCK_USECS};


static pthread_mutex_t s_startupMutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_startupCond = PTHREAD_COND_INITIALIZER;

static pthread_mutex_t s_dispatchMutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_dispatchCond = PTHREAD_COND_INITIALIZER;

static RequestInfo *s_toDispatchHead = NULL;
static RequestInfo *s_toDispatchTail = NULL;

static UserCallbackInfo *s_last_wake_timeout_info = NULL;

static void *s_lastNITZTimeData = NULL;
static size_t s_lastNITZTimeDataSize;

#if RILC_LOG
    static char printBuf[PRINTBUF_SIZE];
#endif

// M: cache URC when RILJ socket is not connected
typedef struct AtResponseList {
    int id;
    Parcel* data;
    size_t datalen;
    AtResponseList *pNext;
} AtResponseList;

void cacheUrc(int unsolResponse, const void *data, size_t datalen, RIL_SOCKET_ID id);
void sendPendedUrcs(RIL_SOCKET_ID socket_id, int fdCommand);
void sendUrc(RIL_SOCKET_ID socket_id, AtResponseList * urcCached);
bool isDsds();

int haveActiveFd(int socket_id);

static AtResponseList* pendedUrcList1 = NULL;
static AtResponseList* pendedUrcList2 = NULL;
static AtResponseList* pendedUrcList3 = NULL;
static AtResponseList* pendedUrcList4 = NULL;
static AtResponseList* pendedUrcList_rilj = NULL;
static AtResponseList* pendedUrcList_rilj2 = NULL;

pthread_mutex_t s_pendingUrcMutex[RIL_SOCKET_NUM];
static int s_fdCommand[RIL_SOCKET_NUM];
// extern "C" int SIM_COUNT = 2;

static pthread_mutex_t s_state_mutex[RIL_SOCKET_NUM];

static int *s_fdCommand_client;


/*******************************************************************/
static int sendResponse (Parcel &p, RIL_SOCKET_ID socket_id, int clientId);

static void dispatchVoid (Parcel& p, RequestInfo *pRI);
static void dispatchString (Parcel& p, RequestInfo *pRI);
static void dispatchStrings (Parcel& p, RequestInfo *pRI);
static void dispatchInts (Parcel& p, RequestInfo *pRI);
static void dispatchDial (Parcel& p, RequestInfo *pRI);
static void dispatchSIM_IO (Parcel& p, RequestInfo *pRI);
static void dispatchSIM_APDU (Parcel& p, RequestInfo *pRI);
static void dispatchCallForward(Parcel& p, RequestInfo *pRI);
static void dispatchCallForwardEx(Parcel& p, RequestInfo *pRI);
static void dispatchRaw(Parcel& p, RequestInfo *pRI);
static void dispatchSmsWrite (Parcel &p, RequestInfo *pRI);
static void dispatchDataCall (Parcel& p, RequestInfo *pRI);
static void dispatchSetInitialAttachApn (Parcel& p, RequestInfo *pRI);

static void dispatchCdmaSms(Parcel &p, RequestInfo *pRI);
static void dispatchImsSms(Parcel &p, RequestInfo *pRI);
static void dispatchImsCdmaSms(Parcel &p, RequestInfo *pRI, uint8_t retry, int32_t messageRef);
static void dispatchImsGsmSms(Parcel &p, RequestInfo *pRI, uint8_t retry, int32_t messageRef);
static void dispatchCdmaSmsAck(Parcel &p, RequestInfo *pRI);
static void dispatchGsmBrSmsCnf(Parcel &p, RequestInfo *pRI);
static void dispatchCdmaBrSmsCnf(Parcel &p, RequestInfo *pRI);
static void dispatchRilCdmaSmsWriteArgs(Parcel &p, RequestInfo *pRI);
static void dispatchNVReadItem(Parcel &p, RequestInfo *pRI);
static void dispatchNVWriteItem(Parcel &p, RequestInfo *pRI);
static void dispatchUiccSubscripton(Parcel &p, RequestInfo *pRI);
static void dispatchSimAuthentication(Parcel &p, RequestInfo *pRI);
static void dispatchDataProfile(Parcel &p, RequestInfo *pRI);
static void dispatchRadioCapability(Parcel &p, RequestInfo *pRI);
static void dispatchCarrierRestrictions(Parcel &p, RequestInfo *pRI);
//MTK-START [mtk80776] WiFi Calling
static void dispatchUiccIo(Parcel &p, RequestInfo *pRI);
static void dispatchUiccAuthentication(Parcel &p, RequestInfo *pRI);
//MTK-END [mtk80776] WiFi Calling
// New SIM Authentication
static void dispatchSimAuth(Parcel &p, RequestInfo *pRI);
//[New R8 modem FD]
static void dispatchFdMode(Parcel &p, RequestInfo *pRI);
//MTK-START PHB
static void dispatchPhbEntry(Parcel &p, RequestInfo *pRI);
static void dispatchWritePhbEntryExt(Parcel &p, RequestInfo *pRI);
//MTK-END PHB
//MTK-START SMS
static void dispatchSmsParams(Parcel &p, RequestInfo *pRI);
//MTK-END SMS

// MTK-START: SIM OPEN CHANNEL WITH P2
static void dispatchOpenChannelParams(Parcel &p, RequestInfo *pRI);
// MTK-END

// Add for porting telematics
static void dispatchNetworkScan(Parcel &p, RequestInfo *pRI);
static void dispatchLinkCapacityReportingCriteria(Parcel &p, RequestInfo *pRI);

static int responseNetworkScanResult(Parcel &p, void *response, size_t responselen);
static int responseQueryNetworkLock(android::Parcel &p, void *response, size_t responselen);
static void dispatchEcallSetMsd(Parcel &p, RequestInfo *pRI);
static void dispatchFastMakeEcall(Parcel &p, RequestInfo *pRI);
static void dispatchEcallSetNum(Parcel &p, RequestInfo *pRI);
static int responseEcallInd(Parcel &p, void *response, size_t responselen);

// M: [VzW] Data Framework
static int responsePcoDataAfterAttached(Parcel &p, void *response, size_t responselen);

static int responseLinkCapacityEstimate(Parcel &p, void *response, size_t responselen);

static int responseInts(Parcel &p, void *response, size_t responselen);
static int responseFailCause(Parcel &p, void *response, size_t responselen);
static int responseStrings(Parcel &p, void *response, size_t responselen);
static int responseString(Parcel &p, void *response, size_t responselen);
static int responseVoid(Parcel &p, void *response, size_t responselen);
static int responseCallList(Parcel &p, void *response, size_t responselen);
static int responseSMS(Parcel &p, void *response, size_t responselen);
static int responseSIM_IO(Parcel &p, void *response, size_t responselen);
static int responseCallForwards(Parcel &p, void *response, size_t responselen);
static int responseCallForwardsEx(Parcel &p, void *response, size_t responselen);
static int responseDataCallList(Parcel &p, void *response, size_t responselen);
static int responseSetupDataCall(Parcel &p, void *response, size_t responselen);
static int responseRaw(Parcel &p, void *response, size_t responselen);
static int responseSsn(Parcel &p, void *response, size_t responselen);
static int responseSimStatus(Parcel &p, void *response, size_t responselen);
static int responseGsmBrSmsCnf(Parcel &p, void *response, size_t responselen);
static int responseCdmaBrSmsCnf(Parcel &p, void *response, size_t responselen);
static int responseCdmaSms(Parcel &p, void *response, size_t responselen);
static int responseCellList(Parcel &p, void *response, size_t responselen);
static int responseCdmaInformationRecords(Parcel &p,void *response, size_t responselen);
static int responseRilSignalStrength(Parcel &p,void *response, size_t responselen);
static int responseCallRing(Parcel &p, void *response, size_t responselen);
static int responseCdmaSignalInfoRecord(Parcel &p,void *response, size_t responselen);
static int responseCdmaCallWaiting(Parcel &p,void *response, size_t responselen);
static int responseSimRefresh(Parcel &p, void *response, size_t responselen);
static int responseCellInfoList(Parcel &p, void *response, size_t responselen);
static int responseGetSmsSimMemStatusCnf(Parcel &p,void *response, size_t responselen);
static int responseEtwsNotification(Parcel &p, void *response, size_t responselen);
static int responseHardwareConfig(Parcel &p, void *response, size_t responselen);
static int responseDcRtInfo(Parcel &p, void *response, size_t responselen);
static int responseRadioCapability(Parcel &p, void *response, size_t responselen);
static int responseSSData(Parcel &p, void *response, size_t responselen);
static int responseLceStatus(Parcel &p, void *response, size_t responselen);
static int responseLceData(Parcel &p, void *response, size_t responselen);
static int responseActivityData(Parcel &p, void *response, size_t responselen);
static int responseCarrierRestrictions(Parcel &p, void *response, size_t responselen);
static int responsePcoData(Parcel &p, void *response, size_t responselen);
static int responseCrssN(Parcel &p, void *response, size_t responselen);
//MTK-START PHB
static int responsePhbEntries(Parcel &p,void *response, size_t responselen);
static int responseGetPhbMemStorage(Parcel &p,void *response, size_t responselen);
static int responseReadPhbEntryExt(Parcel &p,void *response, size_t responselen);
//MTK-END PHB
static int responseImsBearerNotify(Parcel &p, void *response, size_t responselen);
//MTK-START SMS
static int responseSmsParams(Parcel &p, void *response, size_t responselen);
//MTK-END SMS

static int decodeVoiceRadioTechnology (RIL_RadioState radioState);
static int decodeCdmaSubscriptionSource (RIL_RadioState radioState);
// static RIL_RadioState processRadioState(RIL_RadioState newRadioState);
static void grabPartialWakeLock();
static void releaseWakeLock();
static void wakeTimeoutCallback(void *);

static bool isServiceTypeCfQuery(RIL_SsServiceType serType, RIL_SsRequestType reqType);

static bool isDebuggable();

/// M: eMBMS feature
static int responseEmbmsEnable(Parcel &p, void *response, size_t responselen);
static int responseEmbmsDisable(Parcel &p, void *response, size_t responselen);
static void dispatchEmbmsStartSessionInfo(Parcel &p, RequestInfo *pRI);
static void dispatchEmbmsStopSessionInfo(Parcel &p, RequestInfo *pRI);
static int responseEmbmsSessionInfo(Parcel &p, void *response, size_t responselen);
static int responseEmbmsNetworkTime(Parcel &p, void *response, size_t responselen);
static int responseEmbmsGetCoverageState(Parcel &p, void *response, size_t responselen);
static int responseEmbmsOosNotify(Parcel &p, void *response, size_t responselen);
static int responseEmbmsActiveSessionNotify(Parcel &p, void *response, size_t responselen);
static int responseEmbmsCellInfoNotify(Parcel &p, void *response, size_t responselen);
static int responseEmbmsSaiNotify(Parcel &p, void *response, size_t responselen);
static int responseEmbmsModemEeNotify(Parcel &p, void *response, size_t responselen);

static int responseVoiceRegState(Parcel &p, void *response, size_t responselen);
static int responseDataRegState(Parcel &p, void *response, size_t responselen);
static int responseKeepaliveStatus(Parcel &p, void *response, size_t responselen);

// External SIM - Start
static void dispatchVsimEvent(Parcel &p, RequestInfo *pRI);
static void dispatchVsimOperationEvent(Parcel &p, RequestInfo *pRI);
static int responseVsimOperationEvent(Parcel &p, void *response, size_t responselen);
static int responseVsimNotificationResponse(Parcel &p, void *response, size_t responselen);
// External SIM - End

/// since vendor ril uses socket id, so change slot id to socket id again
static RIL_SOCKET_ID mapingSlotIdToRilSocketId(RIL_SLOT_ID slot_id);

/// change libril's socket id to slot id to initialize slot id
extern "C" RIL_SLOT_ID mappingSocketIdToSlotId(RIL_SOCKET_ID socket_id);

#ifdef HAVE_AEE_FEATURE
void triggerWarning(char *pErrMsg);
#endif

#ifdef RIL_SHLIB
#if defined(ANDROID_MULTI_SIM)
extern "C" void RIL_onUnsolicitedResponse(int unsolResponse, const void *data,
                                size_t datalen, RIL_SOCKET_ID socket_id);
#else
extern "C" void RIL_onUnsolicitedResponse(int unsolResponse, const void *data,
                                size_t datalen);
#endif
#endif

static void RIL_onUnsolicitedResponseInternal(int unsolResponse, const void *data,
                                      size_t datalen, SocketListenParam* socket_param);

#if defined(ANDROID_MULTI_SIM)
#define RIL_UNSOL_RESPONSE(a, b, c, d) RIL_onUnsolicitedResponse((a), (b), (c), (d))
#define CALL_ONREQUEST(a, b, c, d, e) android::s_callbacks.onRequest((a), (b), (c), (d), (e))
#define CALL_ONSTATEREQUEST(a) android::s_callbacks.onStateRequest(a)
#else
#define RIL_UNSOL_RESPONSE(a, b, c, d) RIL_onUnsolicitedResponse((a), (b), (c))
#define CALL_ONREQUEST(a, b, c, d, e) android::s_callbacks.onRequest((a), (b), (c), (d))
#define CALL_ONSTATEREQUEST(a) android::s_callbacks.onStateRequest()
#endif

// Multiple Radio HIDL Client for IMS

static UserCallbackInfo * internalRequestTimedCallback
    (RIL_TimedCallback callback, void *param,
        const struct timeval *relativeTime);


/** Index == requestNumber */
static CommandInfo s_commands[] = {
#include "telephony/ril_commands.h"
};

static UnsolResponseInfo s_unsolResponses[] = {
#include "telephony/ril_unsol_commands.h"
};

/// M: mtk request table
CommandInfo s_mtk_commands[] = {
#include "telephony/mtk_ril_commands.h"
};

static UnsolResponseInfo s_mtk_unsolResponses[] = {
#include "telephony/mtk_ril_unsol_commands.h"
};
/// M

/// M: mtk ivt request table
CommandInfo s_mtk_ivt_commands[] = {
#include "telephony/mtk_ril_ivt_commands.h"
};

static UnsolResponseInfo s_mtk_ivt_unsolResponses[] = {
#include "telephony/mtk_ril_ivt_unsol_commands.h"
};
/// M

/* For older RILs that do not support new commands RIL_REQUEST_VOICE_RADIO_TECH and
   RIL_UNSOL_VOICE_RADIO_TECH_CHANGED messages, decode the voice radio tech from
   radio state message and store it. Every time there is a change in Radio State
   check to see if voice radio tech changes and notify telephony
 */
int voiceRadioTech = -1;

/* For older RILs that do not support new commands RIL_REQUEST_GET_CDMA_SUBSCRIPTION_SOURCE
   and RIL_UNSOL_CDMA_SUBSCRIPTION_SOURCE_CHANGED messages, decode the subscription
   source from radio state and store it. Every time there is a change in Radio State
   check to see if subscription source changed and notify telephony
 */
int cdmaSubscriptionSource = -1;

/* For older RILs that do not send RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED, decode the
   SIM/RUIM state from radio state and store it. Every time there is a change in Radio State,
   check to see if SIM/RUIM status changed and notify telephony
 */
int simRuimStatus = -1;

static void changeClientSoketStatus(int slot_id, int client_id, int value){
    long long status = 0;
    char property_status[PROP_VALUE_MAX] = {0};
    char clientNum[PROP_VALUE_MAX] = {0};
    int clientSocketNum = 0;

    mtk_property_get("persist.ril.client.num", clientNum, "0");
    clientSocketNum = std::stoi(clientNum);
    RLOGD("[changeClientSoketStatus] persist.ril.client.num= %d, slot_id=%d, client_id=%d,value=%d",
        clientSocketNum, slot_id, client_id, value);

    if((0 != value) && (1!=value)){      //value must be 0 or 1
        RLOGE("[changeClientSoketStatus]error!value must be 0 or 1");
        return;
    }
    if((slot_id >= RIL_SLOT_MAX) || (client_id >= clientSocketNum) || (client_id >= (8*sizeof(long long) -1))){
        RLOGE("[changeClientSoketStatus]error, RIL_SLOT_MAX=%d, slot_id=%d, persist.ril.client.num=%d, client_id=d",
            RIL_SLOT_MAX, slot_id, clientSocketNum, client_id);
            return;
    }

    mtk_property_get(socket_status[slot_id], property_status, "0");
    RLOGD("[changeClientSoketStatus]before sscanf: %s = %s, status = 0x%llx",
       socket_status[slot_id], property_status, status);
    sscanf(property_status, "%lld", &status);
    RLOGD("[changeClientSoketStatus]before: %s = %s, status = 0x%llx",
       socket_status[slot_id], property_status, status);
    if(0 == value) {
        status = (~(1 << client_id)) & status;
    } else if (1 == value) {
        status = (1 << client_id) | status;
    }
    sprintf(property_status, "%lld", status);
    mtk_property_set(socket_status[slot_id], property_status);
    RLOGD("[changeClientSoketStatus]after: %s = %s, status = 0x%llx", socket_status[slot_id], property_status, status);
}
static char * RIL_getRilSocketName() {
    char test_mode[PROP_VALUE_MAX] = { 0 };
    if (strlen(rild) == 0) {
        strcpy(rild, RIL_getRilSocketNameById(RIL_SOCKET_1));
    }
    mtk_property_get("persist.ril.test_mode", test_mode, "0");
    if (strcmp(test_mode, "0") == 0) {
        //no test mode
        return rild;
    } else {
        strcpy(rild, RIL_getRilSocketNameById(RIL_SOCKET_1));
    }
    return rild;
}

static char *
strdupReadString(Parcel &p) {
    size_t stringlen;
    const char16_t *s16;

    s16 = p.readString16Inplace(&stringlen);

    return strndup16to8(s16, stringlen);
}

static status_t
readStringFromParcelInplace(Parcel &p, char *str, size_t maxLen) {
    size_t s16Len;
    const char16_t *s16;

    s16 = p.readString16Inplace(&s16Len);
    if (s16 == NULL) {
        return NO_MEMORY;
    }
    size_t strLen = strnlen16to8(s16, s16Len);
    if ((strLen + 1) > maxLen) {
        return NO_MEMORY;
    }
    if (strncpy16to8(str, s16, strLen) == NULL) {
        return NO_MEMORY;
    } else {
        return NO_ERROR;
    }
}

static void writeStringToParcel(Parcel &p, const char *s) {
    char16_t *s16;
    size_t s16_len;
    s16 = strdup8to16(s, &s16_len);
    p.writeString16(s16, s16_len);
    free(s16);
}


static void
memsetString (char *s) {
    if (s != NULL) {
        memset (s, 0, strlen(s));
    }
}

void   nullParcelReleaseFunction (const uint8_t* data, size_t dataSize,
                                    const size_t* objects, size_t objectsSize,
                                        void* cookie) {
    // do nothing -- the data reference lives longer than the Parcel object
}

/**
 * To be called from dispatch thread
 * Issue a single local request, ensuring that the response
 * is not sent back up to the command process
 */
static void
issueLocalRequest(int request, void *data, int len, RIL_SOCKET_ID socket_id) {
    RequestInfo *pRI;
    int ret;
    /* Hook for current context */
    /* pendingRequestsMutextHook refer to &s_pendingRequestsMutex */
    pthread_mutex_t* pendingRequestsMutexHook = &s_pendingRequestsMutex;
    /* pendingRequestsHook refer to &s_pendingRequests */
    RequestInfo**    pendingRequestsHook = &s_pendingRequests;

    if (socket_id == RIL_SOCKET_2) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket2;
        pendingRequestsHook = &s_pendingRequests_socket2;
    }
    if (request < 1 || request >= (int32_t)NUM_ELEMS(s_commands)) {
        /// M: customize for mtk request
        if ((request >= (int32_t)NUM_ELEMS(s_commands) && request < RIL_REQUEST_VENDOR_BASE) ||
            (request > (RIL_REQUEST_VENDOR_BASE + (int32_t)NUM_ELEMS(s_mtk_commands)) && request < RIL_REQUEST_VENDOR_IVT_BASE) ||
             request > (RIL_REQUEST_VENDOR_IVT_BASE + (int32_t)NUM_ELEMS(s_mtk_ivt_commands))) {
        /// M
            RLOGE("unsupported local request code %d", request);
            return;
        }
    }

    pRI = (RequestInfo *)calloc(1, sizeof(RequestInfo));
    if (pRI == NULL) {
        RLOGE("Memory allocation failed for request %s", requestToString(request));
        return;
    }

    pRI->local = 1;
    pRI->token = 0xffffffff;        // token is not used in this context
    if (request >= RIL_REQUEST_VENDOR_IVT_BASE) {
        pRI->pCI = &(s_mtk_ivt_commands[request - RIL_REQUEST_VENDOR_IVT_BASE]);
    } else if (request >= RIL_REQUEST_VENDOR_BASE) {
        pRI->pCI = &(s_mtk_commands[request - RIL_REQUEST_VENDOR_BASE]);
    } else {
        pRI->pCI = &(s_commands[request]);
    }
    pRI->socket_id = socket_id;
    pRI->slot_id = mappingSocketIdToSlotId(socket_id);

    ret = pthread_mutex_lock(pendingRequestsMutexHook);
    assert (ret == 0);

    pRI->p_next = *pendingRequestsHook;
    *pendingRequestsHook = pRI;

    ret = pthread_mutex_unlock(pendingRequestsMutexHook);
    assert (ret == 0);

    RLOGD("C[locl]> %s", requestToString(request));

    onRequest(request,(Parcel *)data,pRI,pRI->socket_id);
    //CALL_ONREQUEST(request, data, len, pRI, mapingSlotIdToRilSocketId(pRI->slot_id));
}

static int
processCommandBuffer(void *buffer, size_t buflen, RIL_SOCKET_ID socket_id, int clientId) {
    Parcel *p = new Parcel();
    status_t status;
    int32_t request = 0;
    int32_t token;
    RequestInfo *pRI;
    int ret;
    /* Hook for current context */
    /* pendingRequestsMutextHook refer to &s_pendingRequestsMutex */
    pthread_mutex_t* pendingRequestsMutexHook = &s_pendingRequestsMutex;
    /* pendingRequestsHook refer to &s_pendingRequests */
    RequestInfo**    pendingRequestsHook = &s_pendingRequests;

    if(p == NULL) {
        RLOGE("processCommandBuffer new parcel fail!!!");
        return 0;
    }
    p->setData((uint8_t *) buffer, buflen);

    // status checked at end
    status = p->readInt32(&request);
    status = p->readInt32 (&token);

    /// M: support rilj client @{

    if (socket_id == RIL_SOCKET_2) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket2;
        pendingRequestsHook = &s_pendingRequests_socket2;
    }
    else if (socket_id == RIL_SOCKET_3) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket3;
        pendingRequestsHook = &s_pendingRequests_socket3;
    }
    else if (socket_id == RIL_SOCKET_4) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket4;
        pendingRequestsHook = &s_pendingRequests_socket4;
    }
    else if (socket_id == RIL_SOCKET_RILJ) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket_rilj;
        pendingRequestsHook = &s_pendingRequests_socket_rilj;
    } else if (socket_id == RIL_SOCKET_RILJ2) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket_rilj2;
        pendingRequestsHook = &s_pendingRequests_socket_rilj2;
    }

    if (clientId >= 0) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket_client[clientId];
        pendingRequestsHook = &s_pendingRequests_socket_client[clientId];
    }

    /// @}

    if (status != NO_ERROR) {
        delete(p);
        RLOGE("invalid request block");
        return 0;
    }

    // Received an Ack for the previous result sent to RIL.java,
    // so release wakelock and exit
    if (request == RIL_RESPONSE_ACKNOWLEDGEMENT) {
        releaseWakeLock();
        delete(p);
        return 0;
    }

    if (request < 1 || request >= (int32_t)NUM_ELEMS(s_commands)) {
        /// M: customize for mtk request
        if ((request >= (int32_t)NUM_ELEMS(s_commands) && request < RIL_REQUEST_VENDOR_BASE) ||
            (request >= (RIL_REQUEST_VENDOR_BASE + (int32_t)NUM_ELEMS(s_mtk_commands)) && request < RIL_REQUEST_VENDOR_IVT_BASE) ||
             request >= (RIL_REQUEST_VENDOR_IVT_BASE + (int32_t)NUM_ELEMS(s_mtk_ivt_commands))) {
        /// M
            Parcel pErr;
            RLOGE("unsupported request code %d token %d", request, token);
            // FIXME this should perhaps return a response
            pErr.writeInt32 (RESPONSE_SOLICITED);
            pErr.writeInt32 (token);
            pErr.writeInt32 (RIL_E_GENERIC_FAILURE);

            /// support RILJ client, using real socket id
            sendResponse(pErr, socket_id, clientId);
            delete(p);
            return 0;
        }
    }

    pRI = (RequestInfo *)calloc(1, sizeof(RequestInfo));
    if (pRI == NULL) {
        RLOGE("Memory allocation failed for request %s", requestToString(request));
        delete(p);
        return 0;
    }

    pRI->token = token;

    RLOGD("socket id = %s, token = %d, request = %s(%d)", rilSocketIdToString(socket_id),
            token, requestToString(request), request);
    /// M: ril proxy
    if (request >= RIL_REQUEST_VENDOR_IVT_BASE) {
        pRI->pCI = &(s_mtk_ivt_commands[request - RIL_REQUEST_VENDOR_IVT_BASE]);
    } else if (request >= RIL_REQUEST_VENDOR_BASE) {
        pRI->pCI = &(s_mtk_commands[request - RIL_REQUEST_VENDOR_BASE]);
    } else {
        pRI->pCI = &(s_commands[request]);
    }
    /// M

    pRI->socket_id = socket_id;
    /// M: support rilj client
    pRI->slot_id = mappingSocketIdToSlotId(socket_id);

    pRI->clientId = clientId;

    ret = pthread_mutex_lock(pendingRequestsMutexHook);
    assert (ret == 0);

    pRI->p_next = *pendingRequestsHook;
    *pendingRequestsHook = pRI;

    ret = pthread_mutex_unlock(pendingRequestsMutexHook);
    assert (ret == 0);

/*    sLastDispatchedToken = token; */
    // TODO: remove this! temp solution
    if (pRI->pCI->dispatchFunction != NULL) {
        //pRI->pCI->dispatchFunction(p, pRI);
        onRequest(request,p,pRI,pRI->socket_id);
    } else {
        RIL_onRequestComplete(pRI, RIL_E_REQUEST_NOT_SUPPORTED, NULL, 0);
    }

    return 0;
}

static void
invalidCommandBlock (RequestInfo *pRI) {
    RLOGE("invalid command block for token %d request %s",
                pRI->token, requestToString(pRI->pCI->requestNumber));
}

/** Callee expects NULL */
static void
dispatchVoid (Parcel& p, RequestInfo *pRI) {
    clearPrintBuf;
    printRequest(pRI->token, pRI->pCI->requestNumber);
    CALL_ONREQUEST(pRI->pCI->requestNumber, NULL, 0, pRI, mapingSlotIdToRilSocketId(pRI->slot_id));
}

/** Callee expects const char * */
static void
dispatchString (Parcel& p, RequestInfo *pRI) {
    status_t status;
    size_t datalen;
    size_t stringlen;
    char *string8 = NULL;

    string8 = strdupReadString(p);

    startRequest;
    appendPrintBuf("%s%s", printBuf, string8);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, string8,
                       sizeof(char *), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString(string8);
#endif

    free(string8);
    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/** Callee expects const char ** */
static void
dispatchStrings (Parcel &p, RequestInfo *pRI) {
    int32_t countStrings;
    status_t status;
    size_t datalen;
    char **pStrings;

    status = p.readInt32 (&countStrings);

    if (status != NO_ERROR) {
        goto invalid;
    }

    startRequest;
    if (countStrings == 0) {
        // just some non-null pointer
        pStrings = (char **)calloc(1, sizeof(char *));
        if (pStrings == NULL) {
            RLOGE("Memory allocation failed for request %s",
                    requestToString(pRI->pCI->requestNumber));
            closeRequest;
            return;
        }

        datalen = 0;
    } else if (countStrings < 0) {
        pStrings = NULL;
        datalen = 0;
    } else {
        datalen = sizeof(char *) * countStrings;

        pStrings = (char **)calloc(countStrings, sizeof(char *));
        if (pStrings == NULL) {
            RLOGE("Memory allocation failed for request %s",
                    requestToString(pRI->pCI->requestNumber));
            closeRequest;
            return;
        }

        for (int i = 0 ; i < countStrings ; i++) {
            pStrings[i] = strdupReadString(p);
            appendPrintBuf("%s%s,", printBuf, pStrings[i]);
        }
    }
    removeLastChar;
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, pStrings, datalen, pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

    if (pStrings != NULL) {
        for (int i = 0 ; i < countStrings ; i++) {
#ifdef MEMSET_FREED
            memsetString (pStrings[i]);
#endif
            free(pStrings[i]);
        }

#ifdef MEMSET_FREED
        memset(pStrings, 0, datalen);
#endif
        free(pStrings);
    }

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/** Callee expects const int * */
static void
dispatchInts (Parcel &p, RequestInfo *pRI) {
    int32_t count = 0;
    status_t status;
    size_t datalen;
    int *pInts;

    status = p.readInt32 (&count);

    if (status != NO_ERROR || count <= 0) {
        goto invalid;
    }

    datalen = sizeof(int) * count;
    pInts = (int *)calloc(count, sizeof(int));
    if (pInts == NULL) {
        RLOGE("Memory allocation failed for request %s", requestToString(pRI->pCI->requestNumber));
        return;
    }

    startRequest;
    for (int i = 0 ; i < count ; i++) {
        int32_t t = 0;

        status = p.readInt32(&t);
        pInts[i] = (int)t;
        appendPrintBuf("%s%d,", printBuf, t);

        if (status != NO_ERROR) {
            free(pInts);
            goto invalid;
        }
   }
   removeLastChar;
   closeRequest;
   printRequest(pRI->token, pRI->pCI->requestNumber);

   CALL_ONREQUEST(pRI->pCI->requestNumber, const_cast<int *>(pInts),
                       datalen, pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memset(pInts, 0, datalen);
#endif
    free(pInts);
    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}


/**
 * Callee expects const RIL_SMS_WriteArgs *
 * Payload is:
 *   int32_t status
 *   String pdu
 */
static void
dispatchSmsWrite (Parcel &p, RequestInfo *pRI) {
    RIL_SMS_WriteArgs args;
    int32_t t = 0;
    status_t status;

    RLOGD("dispatchSmsWrite");
    memset (&args, 0, sizeof(args));

    status = p.readInt32(&t);
    args.status = (int)t;

    args.pdu = strdupReadString(p);

    if (status != NO_ERROR || args.pdu == NULL) {
        goto invalid;
    }

    args.smsc = strdupReadString(p);

    startRequest;
    appendPrintBuf("%s%d,%s,smsc=%s", printBuf, args.status,
        (char*)args.pdu,  (char*)args.smsc);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &args, sizeof(args), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString (args.pdu);
#endif

    free (args.pdu);

#ifdef MEMSET_FREED
    memset(&args, 0, sizeof(args));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/**
 * Callee expects const RIL_Dial *
 * Payload is:
 *   String address
 *   int32_t clir
 */
static void
dispatchDial (Parcel &p, RequestInfo *pRI) {
    RIL_Dial dial;
    RIL_UUS_Info uusInfo;
    int32_t sizeOfDial;
    int32_t t;
    int32_t uusPresent;
    status_t status;

    RLOGD("dispatchDial");
    memset (&dial, 0, sizeof(dial));

    dial.address = strdupReadString(p);

    status = p.readInt32(&t);
    dial.clir = (int)t;

    if (status != NO_ERROR || dial.address == NULL) {
        goto invalid;
    }

    if (s_callbacks.version < 3) { // Remove when partners upgrade to version 3
        uusPresent = 0;
        sizeOfDial = sizeof(dial) - sizeof(RIL_UUS_Info *);
    } else {
        status = p.readInt32(&uusPresent);

        if (status != NO_ERROR) {
            goto invalid;
        }

        if (uusPresent == 0) {
            dial.uusInfo = NULL;
        } else {
            int32_t len;

            memset(&uusInfo, 0, sizeof(RIL_UUS_Info));

            status = p.readInt32(&t);
            uusInfo.uusType = (RIL_UUS_Type) t;

            status = p.readInt32(&t);
            uusInfo.uusDcs = (RIL_UUS_DCS) t;

            status = p.readInt32(&len);
            if (status != NO_ERROR) {
                goto invalid;
            }

            // The java code writes -1 for null arrays
            if (((int) len) == -1) {
                uusInfo.uusData = NULL;
                len = 0;
            } else {
                uusInfo.uusData = (char*) p.readInplace(len);
            }

            uusInfo.uusLength = len;
            dial.uusInfo = &uusInfo;
        }
        sizeOfDial = sizeof(dial);
    }

    startRequest;
    appendPrintBuf("%snum=%s,clir=%d", printBuf, dial.address, dial.clir);
    if (uusPresent) {
        appendPrintBuf("%s,uusType=%d,uusDcs=%d,uusLen=%d", printBuf,
                dial.uusInfo->uusType, dial.uusInfo->uusDcs,
                dial.uusInfo->uusLength);
    }
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &dial, sizeOfDial, pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString (dial.address);
#endif

    free (dial.address);

#ifdef MEMSET_FREED
    memset(&uusInfo, 0, sizeof(RIL_UUS_Info));
    memset(&dial, 0, sizeof(dial));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/**
 * Callee expects const RIL_SIM_IO *
 * Payload is:
 *   int32_t command
 *   int32_t fileid
 *   String path
 *   int32_t p1, p2, p3
 *   String data
 *   String pin2
 *   String aidPtr
 */
static void
dispatchSIM_IO (Parcel &p, RequestInfo *pRI) {
    union RIL_SIM_IO {
        RIL_SIM_IO_v6 v6;
        RIL_SIM_IO_v5 v5;
    } simIO;

    int32_t t = 0;
    int size;
    status_t status;

#if VDBG
    RLOGD("dispatchSIM_IO");
#endif
    memset (&simIO, 0, sizeof(simIO));

    // note we only check status at the end

    status = p.readInt32(&t);
    simIO.v6.command = (int)t;

    status = p.readInt32(&t);
    simIO.v6.fileid = (int)t;

    simIO.v6.path = strdupReadString(p);

    status = p.readInt32(&t);
    simIO.v6.p1 = (int)t;

    status = p.readInt32(&t);
    simIO.v6.p2 = (int)t;

    status = p.readInt32(&t);
    simIO.v6.p3 = (int)t;

    simIO.v6.data = strdupReadString(p);
    simIO.v6.pin2 = strdupReadString(p);
    simIO.v6.aidPtr = strdupReadString(p);

    startRequest;
    appendPrintBuf("%scmd=0x%X,efid=0x%X,path=%s,%d,%d,%d,%s,pin2=%s,aid=%s", printBuf,
        simIO.v6.command, simIO.v6.fileid, (char*)simIO.v6.path,
        simIO.v6.p1, simIO.v6.p2, simIO.v6.p3,
        (char*)simIO.v6.data,  (char*)simIO.v6.pin2, simIO.v6.aidPtr);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }

    size = (s_callbacks.version < 6) ? sizeof(simIO.v5) : sizeof(simIO.v6);
    CALL_ONREQUEST(pRI->pCI->requestNumber, &simIO, size, pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString (simIO.v6.path);
    memsetString (simIO.v6.data);
    memsetString (simIO.v6.pin2);
    memsetString (simIO.v6.aidPtr);
#endif

    free (simIO.v6.path);
    free (simIO.v6.data);
    free (simIO.v6.pin2);
    free (simIO.v6.aidPtr);

#ifdef MEMSET_FREED
    memset(&simIO, 0, sizeof(simIO));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/**
 * Callee expects const RIL_SIM_APDU *
 * Payload is:
 *   int32_t sessionid
 *   int32_t cla
 *   int32_t instruction
 *   int32_t p1, p2, p3
 *   String data
 */
static void
dispatchSIM_APDU (Parcel &p, RequestInfo *pRI) {
    int32_t t = 0;
    status_t status;
    RIL_SIM_APDU apdu;

#if VDBG
    RLOGD("dispatchSIM_APDU");
#endif
    memset (&apdu, 0, sizeof(RIL_SIM_APDU));

    // Note we only check status at the end. Any single failure leads to
    // subsequent reads filing.
    status = p.readInt32(&t);
    apdu.sessionid = (int)t;

    status = p.readInt32(&t);
    apdu.cla = (int)t;

    status = p.readInt32(&t);
    apdu.instruction = (int)t;

    status = p.readInt32(&t);
    apdu.p1 = (int)t;

    status = p.readInt32(&t);
    apdu.p2 = (int)t;

    status = p.readInt32(&t);
    apdu.p3 = (int)t;

    apdu.data = strdupReadString(p);

    startRequest;
    appendPrintBuf("%ssessionid=%d,cla=%d,ins=%d,p1=%d,p2=%d,p3=%d,data=%s",
        printBuf, apdu.sessionid, apdu.cla, apdu.instruction, apdu.p1, apdu.p2,
        apdu.p3, (char*)apdu.data);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }

    CALL_ONREQUEST(pRI->pCI->requestNumber, &apdu, sizeof(RIL_SIM_APDU), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString(apdu.data);
#endif
    free(apdu.data);

#ifdef MEMSET_FREED
    memset(&apdu, 0, sizeof(RIL_SIM_APDU));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}


/**
 * Callee expects const RIL_CallForwardInfo *
 * Payload is:
 *  int32_t status/action
 *  int32_t reason
 *  int32_t serviceCode
 *  int32_t toa
 *  String number  (0 length -> null)
 *  int32_t timeSeconds
 */
static void
dispatchCallForward(Parcel &p, RequestInfo *pRI) {
    RIL_CallForwardInfo cff;
    int32_t t = 0;
    status_t status;

    RLOGD("dispatchCallForward");
    memset (&cff, 0, sizeof(cff));

    // note we only check status at the end

    status = p.readInt32(&t);
    cff.status = (int)t;

    status = p.readInt32(&t);
    cff.reason = (int)t;

    status = p.readInt32(&t);
    cff.serviceClass = (int)t;

    status = p.readInt32(&t);
    cff.toa = (int)t;

    cff.number = strdupReadString(p);

    status = p.readInt32(&t);
    cff.timeSeconds = (int)t;

    if (status != NO_ERROR) {
        goto invalid;
    }

    // special case: number 0-length fields is null

    if (cff.number != NULL && strlen (cff.number) == 0) {
        cff.number = NULL;
    }

    startRequest;
    appendPrintBuf("%sstat=%d,reason=%d,serv=%d,toa=%d,%s,tout=%d", printBuf,
        cff.status, cff.reason, cff.serviceClass, cff.toa,
        (char*)cff.number, cff.timeSeconds);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &cff, sizeof(cff), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString(cff.number);
#endif

    free (cff.number);

#ifdef MEMSET_FREED
    memset(&cff, 0, sizeof(cff));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/**
 * Callee expects const RIL_CallForwardInfoEx *
 * Payload is:
 *  int32_t status/action
 *  int32_t reason
 *  int32_t serviceCode
 *  int32_t toa
 *  String number  (0 length -> null)
 *  int32_t timeSeconds
 *  String timeSlotBegin  (0 length -> null)
 *  String timeSlotEnd  (0 length -> null)
 */
static void
dispatchCallForwardEx(Parcel &p, RequestInfo *pRI) {
    RIL_CallForwardInfoEx cff;
    int32_t t = 0;
    status_t status;

    RLOGD("dispatchCallForwardEx");
    memset (&cff, 0, sizeof(cff));

    // note we only check status at the end

    status = p.readInt32(&t);
    cff.status = (int)t;

    status = p.readInt32(&t);
    cff.reason = (int)t;

    status = p.readInt32(&t);
    cff.serviceClass = (int)t;

    status = p.readInt32(&t);
    cff.toa = (int)t;

    cff.number = strdupReadString(p);

    status = p.readInt32(&t);
    cff.timeSeconds = (int)t;

    cff.timeSlotBegin = strdupReadString(p);
    cff.timeSlotEnd = strdupReadString(p);

    if (status != NO_ERROR) {
        goto invalid;
    }

    // special case: number 0-length fields is null

    if (cff.number != NULL && strlen (cff.number) == 0) {
        cff.number = NULL;
    }

    if (cff.timeSlotBegin != NULL && strlen (cff.timeSlotBegin) == 0) {
        cff.timeSlotBegin = NULL;
    }
    if (cff.timeSlotEnd != NULL && strlen (cff.timeSlotEnd) == 0) {
        cff.timeSlotEnd = NULL;
    }

    startRequest;
    appendPrintBuf("%sstat=%d,reason=%d,serv=%d,toa=%d,%s,tout=%d,timeSlot=%s,%s", printBuf,
        cff.status, cff.reason, cff.serviceClass, cff.toa,
        (char*)cff.number, cff.timeSeconds, cff.timeSlotBegin, cff.timeSlotEnd);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &cff, sizeof(cff), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString(cff.number);
    memsetString(cff.timeSlotBegin);
    memsetString(cff.timeSlotEnd);
#endif

    free (cff.number);
    free (cff.timeSlotBegin);
    free (cff.timeSlotEnd);

#ifdef MEMSET_FREED
    memset(&cff, 0, sizeof(cff));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

static void
dispatchRaw(Parcel &p, RequestInfo *pRI) {
    int32_t len;
    status_t status;
    const void *data;

    status = p.readInt32(&len);

    if (status != NO_ERROR) {
        goto invalid;
    }

    // The java code writes -1 for null arrays
    if (((int)len) == -1) {
        data = NULL;
        len = 0;
    }

    data = p.readInplace(len);

    startRequest;
    appendPrintBuf("%sraw_size=%d", printBuf, len);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, const_cast<void *>(data), len, pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

static status_t
constructCdmaSms(Parcel &p, RequestInfo *pRI, RIL_CDMA_SMS_Message& rcsm) {
    int32_t  t = 0;
    uint8_t ut = 0;
    status_t status;
    int32_t digitCount;
    int digitLimit;

    memset(&rcsm, 0, sizeof(rcsm));

    status = p.readInt32(&t);
    rcsm.uTeleserviceID = (int) t;

    status = p.read(&ut,sizeof(ut));
    rcsm.bIsServicePresent = (uint8_t) ut;

    status = p.readInt32(&t);
    rcsm.uServicecategory = (int) t;

    status = p.readInt32(&t);
    rcsm.sAddress.digit_mode = (RIL_CDMA_SMS_DigitMode) t;

    status = p.readInt32(&t);
    rcsm.sAddress.number_mode = (RIL_CDMA_SMS_NumberMode) t;

    status = p.readInt32(&t);
    rcsm.sAddress.number_type = (RIL_CDMA_SMS_NumberType) t;

    status = p.readInt32(&t);
    rcsm.sAddress.number_plan = (RIL_CDMA_SMS_NumberPlan) t;

    status = p.read(&ut,sizeof(ut));
    rcsm.sAddress.number_of_digits= (uint8_t) ut;

    digitLimit= MIN((rcsm.sAddress.number_of_digits), RIL_CDMA_SMS_ADDRESS_MAX);
    for(digitCount =0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&ut,sizeof(ut));
        rcsm.sAddress.digits[digitCount] = (uint8_t) ut;
    }

    status = p.readInt32(&t);
    rcsm.sSubAddress.subaddressType = (RIL_CDMA_SMS_SubaddressType) t;

    status = p.read(&ut,sizeof(ut));
    rcsm.sSubAddress.odd = (uint8_t) ut;

    status = p.read(&ut,sizeof(ut));
    rcsm.sSubAddress.number_of_digits = (uint8_t) ut;

    digitLimit= MIN((rcsm.sSubAddress.number_of_digits), RIL_CDMA_SMS_SUBADDRESS_MAX);
    for(digitCount =0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&ut,sizeof(ut));
        rcsm.sSubAddress.digits[digitCount] = (uint8_t) ut;
    }

    status = p.readInt32(&t);
    rcsm.uBearerDataLen = (int) t;

    digitLimit= MIN((rcsm.uBearerDataLen), RIL_CDMA_SMS_BEARER_DATA_MAX);
    for(digitCount =0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&ut, sizeof(ut));
        rcsm.aBearerData[digitCount] = (uint8_t) ut;
    }

    if (status != NO_ERROR) {
        return status;
    }

    startRequest;
    appendPrintBuf("%suTeleserviceID=%d, bIsServicePresent=%d, uServicecategory=%d, \
            sAddress.digit_mode=%d, sAddress.Number_mode=%d, sAddress.number_type=%d, ",
            printBuf, rcsm.uTeleserviceID,rcsm.bIsServicePresent,rcsm.uServicecategory,
            rcsm.sAddress.digit_mode, rcsm.sAddress.number_mode,rcsm.sAddress.number_type);
    closeRequest;

    printRequest(pRI->token, pRI->pCI->requestNumber);

    return status;
}

static void
dispatchCdmaSms(Parcel &p, RequestInfo *pRI) {
    RIL_CDMA_SMS_Message rcsm;

    RLOGD("dispatchCdmaSms");
    if (NO_ERROR != constructCdmaSms(p, pRI, rcsm)) {
        goto invalid;
    }

    CALL_ONREQUEST(pRI->pCI->requestNumber, &rcsm, sizeof(rcsm),pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memset(&rcsm, 0, sizeof(rcsm));
#endif

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void
dispatchImsCdmaSms(Parcel &p, RequestInfo *pRI, uint8_t retry, int32_t messageRef) {
    RIL_IMS_SMS_Message rism;
    RIL_CDMA_SMS_Message rcsm;

    RLOGD("dispatchImsCdmaSms: retry=%d, messageRef=%d", retry, messageRef);

    if (NO_ERROR != constructCdmaSms(p, pRI, rcsm)) {
        goto invalid;
    }
    memset(&rism, 0, sizeof(rism));
    rism.tech = RADIO_TECH_3GPP2;
    rism.retry = retry;
    rism.messageRef = messageRef;
    rism.message.cdmaMessage = &rcsm;

    CALL_ONREQUEST(pRI->pCI->requestNumber, &rism,
            sizeof(RIL_RadioTechnologyFamily)+sizeof(uint8_t)+sizeof(int32_t)
            +sizeof(rcsm),pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memset(&rcsm, 0, sizeof(rcsm));
    memset(&rism, 0, sizeof(rism));
#endif

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void
dispatchImsGsmSms(Parcel &p, RequestInfo *pRI, uint8_t retry, int32_t messageRef) {
    RIL_IMS_SMS_Message rism;
    int32_t countStrings;
    status_t status;
    size_t datalen;
    char **pStrings;
    RLOGD("dispatchImsGsmSms: retry=%d, messageRef=%d", retry, messageRef);

    status = p.readInt32 (&countStrings);

    if (status != NO_ERROR) {
        goto invalid;
    }

    memset(&rism, 0, sizeof(rism));
    rism.tech = RADIO_TECH_3GPP;
    rism.retry = retry;
    rism.messageRef = messageRef;

    startRequest;
    appendPrintBuf("%stech=%d, retry=%d, messageRef=%d, ", printBuf,
                    (int)rism.tech, (int)rism.retry, rism.messageRef);
    if (countStrings == 0) {
        // just some non-null pointer
        pStrings = (char **)calloc(1, sizeof(char *));
        if (pStrings == NULL) {
            RLOGE("Memory allocation failed for request %s",
                    requestToString(pRI->pCI->requestNumber));
            closeRequest;
            return;
        }

        datalen = 0;
    } else if (countStrings < 0) {
        pStrings = NULL;
        datalen = 0;
    } else {
        if ((size_t)countStrings > (INT_MAX/sizeof(char *))) {
            RLOGE("Invalid value of countStrings: \n");
            closeRequest;
            return;
        }
        datalen = sizeof(char *) * countStrings;

        pStrings = (char **)calloc(countStrings, sizeof(char *));
        if (pStrings == NULL) {
            RLOGE("Memory allocation failed for request %s",
                    requestToString(pRI->pCI->requestNumber));
            closeRequest;
            return;
        }

        for (int i = 0 ; i < countStrings ; i++) {
            pStrings[i] = strdupReadString(p);
            appendPrintBuf("%s%s,", printBuf, pStrings[i]);
        }
        RLOGE("ImsGsmSms smsc %s, pdu %s", ((pStrings[0] != NULL)? pStrings[0] : "null"),
            ((pStrings[1] != NULL)? pStrings[1] : "null"));
    }
    removeLastChar;
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    rism.message.gsmMessage = pStrings;
    CALL_ONREQUEST(pRI->pCI->requestNumber, &rism,
            sizeof(RIL_RadioTechnologyFamily)+sizeof(uint8_t)+sizeof(int32_t)
            +datalen, pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

    if (pStrings != NULL) {
        for (int i = 0 ; i < countStrings ; i++) {
#ifdef MEMSET_FREED
            memsetString (pStrings[i]);
#endif
            free(pStrings[i]);
        }

#ifdef MEMSET_FREED
        memset(pStrings, 0, datalen);
#endif
        free(pStrings);
    }

#ifdef MEMSET_FREED
    memset(&rism, 0, sizeof(rism));
#endif
    return;
invalid:
    ALOGE("dispatchImsGsmSms invalid block");
    invalidCommandBlock(pRI);
    return;
}

static void
dispatchImsSms(Parcel &p, RequestInfo *pRI) {
    int32_t  t;
    status_t status = p.readInt32(&t);
    RIL_RadioTechnologyFamily format;
    uint8_t retry;
    int32_t messageRef;

    RLOGD("dispatchImsSms");
    if (status != NO_ERROR) {
        goto invalid;
    }
    format = (RIL_RadioTechnologyFamily) t;
    RLOGE("tech %d", t);

    // read retry field
    status = p.read(&retry,sizeof(retry));
    if (status != NO_ERROR) {
        goto invalid;
    }
    RLOGE("retry %d", retry);

    // read messageRef field
    status = p.read(&messageRef,sizeof(messageRef));
    if (status != NO_ERROR) {
        goto invalid;
    }
    RLOGE("messageRef %d", messageRef);

    if (RADIO_TECH_3GPP == format) {
        dispatchImsGsmSms(p, pRI, retry, messageRef);
    } else if (RADIO_TECH_3GPP2 == format) {
        dispatchImsCdmaSms(p, pRI, retry, messageRef);
    } else {
        ALOGE("requestImsSendSMS invalid format value =%d", format);
    }

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void
dispatchCdmaSmsAck(Parcel &p, RequestInfo *pRI) {
    RIL_CDMA_SMS_Ack rcsa;
    int32_t  t = 0;
    status_t status;
    int32_t digitCount;

    RLOGD("dispatchCdmaSmsAck");
    memset(&rcsa, 0, sizeof(rcsa));

    status = p.readInt32(&t);
    rcsa.uErrorClass = (RIL_CDMA_SMS_ErrorClass) t;

    status = p.readInt32(&t);
    rcsa.uSMSCauseCode = (int) t;

    if (status != NO_ERROR) {
        goto invalid;
    }

    startRequest;
    appendPrintBuf("%suErrorClass=%d, uTLStatus=%d, ",
            printBuf, rcsa.uErrorClass, rcsa.uSMSCauseCode);
    closeRequest;

    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &rcsa, sizeof(rcsa),pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memset(&rcsa, 0, sizeof(rcsa));
#endif

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void
dispatchGsmBrSmsCnf(Parcel &p, RequestInfo *pRI) {
    int32_t t;
    status_t status;
    int32_t num;

    status = p.readInt32(&num);
    if (status != NO_ERROR) {
        goto invalid;
    }

    {
        RIL_GSM_BroadcastSmsConfigInfo gsmBci[num];
        RIL_GSM_BroadcastSmsConfigInfo *gsmBciPtrs[num];

        startRequest;
        for (int i = 0 ; i < num ; i++ ) {
            gsmBciPtrs[i] = &gsmBci[i];

            status = p.readInt32(&t);
            gsmBci[i].fromServiceId = (int) t;

            status = p.readInt32(&t);
            gsmBci[i].toServiceId = (int) t;

            status = p.readInt32(&t);
            gsmBci[i].fromCodeScheme = (int) t;

            status = p.readInt32(&t);
            gsmBci[i].toCodeScheme = (int) t;

            status = p.readInt32(&t);
            gsmBci[i].selected = (uint8_t) t;

            appendPrintBuf("%s [%d: fromServiceId=%d, toServiceId =%d, \
                  fromCodeScheme=%d, toCodeScheme=%d, selected =%d]", printBuf, i,
                  gsmBci[i].fromServiceId, gsmBci[i].toServiceId,
                  gsmBci[i].fromCodeScheme, gsmBci[i].toCodeScheme,
                  gsmBci[i].selected);
        }
        closeRequest;

        if (status != NO_ERROR) {
            goto invalid;
        }

        CALL_ONREQUEST(pRI->pCI->requestNumber,
                              gsmBciPtrs,
                              num * sizeof(RIL_GSM_BroadcastSmsConfigInfo *),
                              pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
        memset(gsmBci, 0, num * sizeof(RIL_GSM_BroadcastSmsConfigInfo));
        memset(gsmBciPtrs, 0, num * sizeof(RIL_GSM_BroadcastSmsConfigInfo *));
#endif
    }

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void
dispatchCdmaBrSmsCnf(Parcel &p, RequestInfo *pRI) {
    int32_t t;
    status_t status;
    int32_t num;

    status = p.readInt32(&num);
    if (status != NO_ERROR) {
        goto invalid;
    }

    {
        RIL_CDMA_BroadcastSmsConfigInfo cdmaBci[num];
        RIL_CDMA_BroadcastSmsConfigInfo *cdmaBciPtrs[num];

        startRequest;
        for (int i = 0 ; i < num ; i++ ) {
            cdmaBciPtrs[i] = &cdmaBci[i];

            status = p.readInt32(&t);
            cdmaBci[i].service_category = (int) t;

            status = p.readInt32(&t);
            cdmaBci[i].language = (int) t;

            status = p.readInt32(&t);
            cdmaBci[i].selected = (uint8_t) t;

            appendPrintBuf("%s [%d: service_category=%d, language =%d, \
                  entries.bSelected =%d]", printBuf, i, cdmaBci[i].service_category,
                  cdmaBci[i].language, cdmaBci[i].selected);
        }
        closeRequest;

        if (status != NO_ERROR) {
            goto invalid;
        }

        CALL_ONREQUEST(pRI->pCI->requestNumber,
                              cdmaBciPtrs,
                              num * sizeof(RIL_CDMA_BroadcastSmsConfigInfo *),
                              pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
        memset(cdmaBci, 0, num * sizeof(RIL_CDMA_BroadcastSmsConfigInfo));
        memset(cdmaBciPtrs, 0, num * sizeof(RIL_CDMA_BroadcastSmsConfigInfo *));
#endif
    }

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchRilCdmaSmsWriteArgs(Parcel &p, RequestInfo *pRI) {
    RIL_CDMA_SMS_WriteArgs rcsw;
    int32_t  t = 0;
    uint32_t ut = 0;
    uint8_t  uct = 0;
    status_t status;
    int32_t  digitCount;
    int32_t  digitLimit;

    memset(&rcsw, 0, sizeof(rcsw));

    status = p.readInt32(&t);
    rcsw.status = t;

    status = p.readInt32(&t);
    rcsw.message.uTeleserviceID = (int) t;

    status = p.read(&uct,sizeof(uct));
    rcsw.message.bIsServicePresent = (uint8_t) uct;

    status = p.readInt32(&t);
    rcsw.message.uServicecategory = (int) t;

    status = p.readInt32(&t);
    rcsw.message.sAddress.digit_mode = (RIL_CDMA_SMS_DigitMode) t;

    status = p.readInt32(&t);
    rcsw.message.sAddress.number_mode = (RIL_CDMA_SMS_NumberMode) t;

    status = p.readInt32(&t);
    rcsw.message.sAddress.number_type = (RIL_CDMA_SMS_NumberType) t;

    status = p.readInt32(&t);
    rcsw.message.sAddress.number_plan = (RIL_CDMA_SMS_NumberPlan) t;

    status = p.read(&uct,sizeof(uct));
    rcsw.message.sAddress.number_of_digits = (uint8_t) uct;

    digitLimit = MIN((rcsw.message.sAddress.number_of_digits), RIL_CDMA_SMS_ADDRESS_MAX);

    for(digitCount = 0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&uct,sizeof(uct));
        rcsw.message.sAddress.digits[digitCount] = (uint8_t) uct;
    }

    status = p.readInt32(&t);
    rcsw.message.sSubAddress.subaddressType = (RIL_CDMA_SMS_SubaddressType) t;

    status = p.read(&uct,sizeof(uct));
    rcsw.message.sSubAddress.odd = (uint8_t) uct;

    status = p.read(&uct,sizeof(uct));
    rcsw.message.sSubAddress.number_of_digits = (uint8_t) uct;

    digitLimit = MIN((rcsw.message.sSubAddress.number_of_digits), RIL_CDMA_SMS_SUBADDRESS_MAX);

    for(digitCount = 0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&uct,sizeof(uct));
        rcsw.message.sSubAddress.digits[digitCount] = (uint8_t) uct;
    }

    status = p.readInt32(&t);
    rcsw.message.uBearerDataLen = (int) t;

    digitLimit = MIN((rcsw.message.uBearerDataLen), RIL_CDMA_SMS_BEARER_DATA_MAX);

    for(digitCount = 0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&uct, sizeof(uct));
        rcsw.message.aBearerData[digitCount] = (uint8_t) uct;
    }

    if (status != NO_ERROR) {
        goto invalid;
    }

    startRequest;
    appendPrintBuf("%sstatus=%d, message.uTeleserviceID=%d, message.bIsServicePresent=%d, \
            message.uServicecategory=%d, message.sAddress.digit_mode=%d, \
            message.sAddress.number_mode=%d, \
            message.sAddress.number_type=%d, ",
            printBuf, rcsw.status, rcsw.message.uTeleserviceID, rcsw.message.bIsServicePresent,
            rcsw.message.uServicecategory, rcsw.message.sAddress.digit_mode,
            rcsw.message.sAddress.number_mode,
            rcsw.message.sAddress.number_type);
    closeRequest;

    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &rcsw, sizeof(rcsw),pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memset(&rcsw, 0, sizeof(rcsw));
#endif

    return;

invalid:
    invalidCommandBlock(pRI);
    return;

}

// For backwards compatibility in RIL_REQUEST_SETUP_DATA_CALL.
// Version 4 of the RIL interface adds a new PDP type parameter to support
// IPv6 and dual-stack PDP contexts. When dealing with a previous version of
// RIL, remove the parameter from the request.
static void dispatchDataCall(Parcel& p, RequestInfo *pRI) {
    // In RIL v3, REQUEST_SETUP_DATA_CALL takes 6 parameters.
    const int numParamsRilV3 = 6;

    // The first bytes of the RIL parcel contain the request number and the
    // serial number - see processCommandBuffer(). Copy them over too.
    int pos = p.dataPosition();

    int numParams = p.readInt32();
#if defined(__MTK_ANDROID__)
    if (s_callbacks.version < 4 && numParams > numParamsRilV3) {
      Parcel p2;
      p2.appendFrom(&p, 0, pos);
      p2.writeInt32(numParamsRilV3);
      for(int i = 0; i < numParamsRilV3; i++) {
        p2.writeString16(p.readString16());
      }
      p2.setDataPosition(pos);
      dispatchStrings(p2, pRI);
    } else {
      p.setDataPosition(pos);
      dispatchStrings(p, pRI);
    }
#else
    p.setDataPosition(pos);
    dispatchStrings(p, pRI);
#endif
}


static void dispatchSetInitialAttachApn(Parcel &p, RequestInfo *pRI)
{
    RIL_InitialAttachApn_v15 pf;
    char *roamingProtocol;
    int32_t  t = 0;
    status_t status;

    memset(&pf, 0, sizeof(pf));

    pf.apn = strdupReadString(p);
    pf.protocol = strdupReadString(p);

    // compatible for lagecy chip implementation in ril java
    //roamingProtocol= strdupReadString(p);

    status = p.readInt32(&t);
    pf.authtype = (int) t;

    pf.username = strdupReadString(p);
    pf.password = strdupReadString(p);

    startRequest;
    appendPrintBuf("%sapn=%s, protocol=%s, authtype=%d, username=%s, password=%s",
            printBuf, pf.apn, pf.protocol, pf.authtype, pf.username, pf.password);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }
    CALL_ONREQUEST(pRI->pCI->requestNumber, &pf, sizeof(pf), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString(pf.apn);
    memsetString(pf.protocol);
    memsetString(pf.username);
    memsetString(pf.password);
#endif

    free(pf.apn);
    free(pf.protocol);
    free(pf.username);
    free(pf.password);

    // compatible for lagecy chip implementation in ril java
    //free(roamingProtocol);

#ifdef MEMSET_FREED
    memset(&pf, 0, sizeof(pf));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchNVReadItem(Parcel &p, RequestInfo *pRI) {
    RIL_NV_ReadItem nvri;
    int32_t  t = 0;
    status_t status;

    memset(&nvri, 0, sizeof(nvri));

    status = p.readInt32(&t);
    nvri.itemID = (RIL_NV_Item) t;

    if (status != NO_ERROR) {
        goto invalid;
    }

    startRequest;
    appendPrintBuf("%snvri.itemID=%d, ", printBuf, nvri.itemID);
    closeRequest;

    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &nvri, sizeof(nvri), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memset(&nvri, 0, sizeof(nvri));
#endif

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchNVWriteItem(Parcel &p, RequestInfo *pRI) {
    RIL_NV_WriteItem nvwi;
    int32_t  t = 0;
    status_t status;

    memset(&nvwi, 0, sizeof(nvwi));

    status = p.readInt32(&t);
    nvwi.itemID = (RIL_NV_Item) t;

    nvwi.value = strdupReadString(p);

    if (status != NO_ERROR || nvwi.value == NULL) {
        goto invalid;
    }

    startRequest;
    appendPrintBuf("%snvwi.itemID=%d, value=%s, ", printBuf, nvwi.itemID,
            nvwi.value);
    closeRequest;

    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &nvwi, sizeof(nvwi), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString(nvwi.value);
#endif

    free(nvwi.value);

#ifdef MEMSET_FREED
    memset(&nvwi, 0, sizeof(nvwi));
#endif

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}


static void dispatchUiccSubscripton(Parcel &p, RequestInfo *pRI) {
    RIL_SelectUiccSub uicc_sub;
    status_t status;
    int32_t  t;
    memset(&uicc_sub, 0, sizeof(uicc_sub));

    status = p.readInt32(&t);
    if (status != NO_ERROR) {
        goto invalid;
    }
    uicc_sub.slot = (int) t;

    status = p.readInt32(&t);
    if (status != NO_ERROR) {
        goto invalid;
    }
    uicc_sub.app_index = (int) t;

    status = p.readInt32(&t);
    if (status != NO_ERROR) {
        goto invalid;
    }
    uicc_sub.sub_type = (RIL_SubscriptionType) t;

    status = p.readInt32(&t);
    if (status != NO_ERROR) {
        goto invalid;
    }
    uicc_sub.act_status = (RIL_UiccSubActStatus) t;

    startRequest;
    appendPrintBuf("slot=%d, app_index=%d, act_status = %d", uicc_sub.slot, uicc_sub.app_index,
            uicc_sub.act_status);
    RLOGD("dispatchUiccSubscription, slot=%d, app_index=%d, act_status = %d", uicc_sub.slot,
            uicc_sub.app_index, uicc_sub.act_status);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &uicc_sub, sizeof(uicc_sub), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memset(&uicc_sub, 0, sizeof(uicc_sub));
#endif
    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchSimAuthentication(Parcel &p, RequestInfo *pRI)
{
    RIL_SimAuthentication pf;
    int32_t  t = 0;
    status_t status;

    memset(&pf, 0, sizeof(pf));

    status = p.readInt32(&t);
    pf.authContext = (int) t;
    pf.authData = strdupReadString(p);
    pf.aid = strdupReadString(p);

    startRequest;
    appendPrintBuf("authContext=%s, authData=%s, aid=%s", pf.authContext, pf.authData, pf.aid);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }
    CALL_ONREQUEST(pRI->pCI->requestNumber, &pf, sizeof(pf), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString(pf.authData);
    memsetString(pf.aid);
#endif

    free(pf.authData);
    free(pf.aid);

#ifdef MEMSET_FREED
    memset(&pf, 0, sizeof(pf));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

static void memsetAndFreeStrings(int numPointers, ...) {
    va_list ap;
    va_start(ap, numPointers);
    for (int i = 0; i < numPointers; i++) {
        char *ptr = va_arg(ap, char *);
        if (ptr) {
#ifdef MEMSET_FREED
#define MAX_STRING_LENGTH 4096
            memset(ptr, 0, strnlen(ptr, MAX_STRING_LENGTH));
#endif
            free(ptr);
        }
    }
    va_end(ap);
}

template <typename T>
static void freeSetDataProfileData(int numProfiles, T *dataProfiles, T **dataProfilePtrs,
                            int numfields, ...) {
    va_list args;
    va_start(args, numfields);

    // Iterate through each string-type field that need to be free.
    for (int i = 0; i < numfields; i++) {
        // Iterate through each data profile and free that specific string-type field.
        // The type 'char *T::*' is a type of pointer to a 'char *' member inside T structure.
        char *T::*ptr = va_arg(args, char *T::*);
        for (int j = 0; j < numProfiles; j++) {
            memsetAndFreeStrings(1, dataProfiles[j].*ptr);
        }
    }

    va_end(args);

#ifdef MEMSET_FREED
    memset(dataProfiles, 0, numProfiles * sizeof(T));
    memset(dataProfilePtrs, 0, numProfiles * sizeof(T *));
#endif
    free(dataProfiles);
    free(dataProfilePtrs);
}

static void dispatchDataProfile(Parcel &p, RequestInfo *pRI) {
    int32_t t;
    status_t status;
    int32_t num = 0;

    status = p.readInt32(&num);
    if (status != NO_ERROR || num < 0) {
        RLOGE("dispatchDataProfile status = %d num = %d,%s ",
                   status, num,requestToString(pRI->pCI->requestNumber));
        goto invalid;
    }

    {
        RIL_MtkDataProfileInfo *dataProfiles =
                (RIL_MtkDataProfileInfo *)calloc(num, sizeof(RIL_MtkDataProfileInfo));
        if (dataProfiles == NULL) {
            RLOGE("Memory allocation failed for request %s",
                    requestToString(pRI->pCI->requestNumber));
            return;
        }
        RIL_MtkDataProfileInfo **dataProfilePtrs =
                (RIL_MtkDataProfileInfo **)calloc(num, sizeof(RIL_MtkDataProfileInfo *));
        if (dataProfilePtrs == NULL) {
            RLOGE("Memory allocation failed for request %s",
                    requestToString(pRI->pCI->requestNumber));
            free(dataProfiles);
            return;
        }

        startRequest;
        for (int i = 0 ; i < num ; i++ ) {
            dataProfilePtrs[i] = &dataProfiles[i];

            status = p.readInt32(&t);
            dataProfiles[i].profileId = (int) t;

            dataProfiles[i].apn = strdupReadString(p);
            dataProfiles[i].protocol = strdupReadString(p);
            status = p.readInt32(&t);
            dataProfiles[i].authType = (int) t;

            dataProfiles[i].user = strdupReadString(p);
            dataProfiles[i].password = strdupReadString(p);

            status = p.readInt32(&t);
            dataProfiles[i].type = (int) t;

            status = p.readInt32(&t);
            dataProfiles[i].maxConnsTime = (int) t;
            status = p.readInt32(&t);
            dataProfiles[i].maxConns = (int) t;
            status = p.readInt32(&t);
            dataProfiles[i].waitTime = (int) t;

            status = p.readInt32(&t);
            dataProfiles[i].enabled = (int) t;

            status = p.readInt32(&t);
            dataProfiles[i].supportedTypesBitmask = (int) t;

            dataProfiles[i].roamingProtocol = strdupReadString(p);

            status = p.readInt32(&t);
            dataProfiles[i].bearerBitmask = (int) t;

            status = p.readInt32(&t);
            dataProfiles[i].mtu = (int) t;

            dataProfiles[i].mvnoType = strdupReadString(p);

            dataProfiles[i].mvnoMatchData = strdupReadString(p);

            // read modemCognitive
            status = p.readInt32(&t);

            appendPrintBuf("%s [%d: profileId=%d, apn =%s, protocol =%s, authType =%d, \
                  user =%s, password =%s, type =%d, maxConnsTime =%d, maxConns =%d, \
                  waitTime =%d, enabled =%d]", printBuf, i, dataProfiles[i].profileId,
                  dataProfiles[i].apn, dataProfiles[i].protocol, dataProfiles[i].authType,
                  dataProfiles[i].user, dataProfiles[i].password, dataProfiles[i].type,
                  dataProfiles[i].maxConnsTime, dataProfiles[i].maxConns,
                  dataProfiles[i].waitTime, dataProfiles[i].enabled);
        }
        closeRequest;
        printRequest(pRI->token, pRI->pCI->requestNumber);

        if (status != NO_ERROR) {
            freeSetDataProfileData(num, dataProfiles, dataProfilePtrs, 7,
                    &RIL_MtkDataProfileInfo::apn, &RIL_MtkDataProfileInfo::protocol,
                    &RIL_MtkDataProfileInfo::roamingProtocol, &RIL_MtkDataProfileInfo::user,
                    &RIL_MtkDataProfileInfo::password, &RIL_MtkDataProfileInfo::mvnoType,
                    &RIL_MtkDataProfileInfo::mvnoMatchData);
            goto invalid;
        }
        CALL_ONREQUEST(pRI->pCI->requestNumber,
                              dataProfilePtrs,
                              num * sizeof(RIL_MtkDataProfileInfo *),
                              pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

        freeSetDataProfileData(num, dataProfiles, dataProfilePtrs, 7,
                &RIL_MtkDataProfileInfo::apn, &RIL_MtkDataProfileInfo::protocol,
                &RIL_MtkDataProfileInfo::roamingProtocol, &RIL_MtkDataProfileInfo::user,
                &RIL_MtkDataProfileInfo::password, &RIL_MtkDataProfileInfo::mvnoType,
                &RIL_MtkDataProfileInfo::mvnoMatchData);
    }

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchRadioCapability(Parcel &p, RequestInfo *pRI){
    RIL_RadioCapability rc;
    int32_t t = 0;
    status_t status;

    memset (&rc, 0, sizeof(RIL_RadioCapability));

    status = p.readInt32(&t);
    rc.version = (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    rc.session= (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    rc.phase= (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    rc.rat = (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = readStringFromParcelInplace(p, rc.logicalModemUuid, sizeof(rc.logicalModemUuid));
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    rc.status = (int)t;

    if (status != NO_ERROR) {
        goto invalid;
    }

    startRequest;
    appendPrintBuf("%s [version:%d, session:%d, phase:%d, rat:%d, \
            logicalModemUuid:%s, status:%d", printBuf, rc.version, rc.session,
            rc.phase, rc.rat, rc.logicalModemUuid, rc.session);

    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber,
                &rc,
                sizeof(RIL_RadioCapability),
                pRI, mapingSlotIdToRilSocketId(pRI->slot_id));
    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/**
 * Callee expects const RIL_CarrierRestrictions *
 */
static void dispatchCarrierRestrictions(Parcel &p, RequestInfo *pRI) {
    RIL_CarrierRestrictions cr;
    RIL_Carrier * allowed_carriers = NULL;
    RIL_Carrier * excluded_carriers = NULL;
    int32_t t;
    status_t status;

    memset(&cr, 0, sizeof(RIL_CarrierRestrictions));

    if (s_callbacks.version < 14) {
        RLOGE("Unsuppoted RIL version %d, min version expected %d",
              s_callbacks.version, 14);
        RIL_onRequestComplete(pRI, RIL_E_REQUEST_NOT_SUPPORTED, NULL, 0);
        return;
    }

    status = p.readInt32(&t);
    if (status != NO_ERROR) {
        goto invalid;
    }
    allowed_carriers = (RIL_Carrier *)calloc(t, sizeof(RIL_Carrier));
    if (allowed_carriers == NULL) {
        RLOGE("Memory allocation failed for request %s", requestToString(pRI->pCI->requestNumber));
        goto exit;
    }
    cr.len_allowed_carriers = t;
    cr.allowed_carriers = allowed_carriers;

    status = p.readInt32(&t);
    if (status != NO_ERROR) {
        goto invalid;
    }
    excluded_carriers = (RIL_Carrier *)calloc(t, sizeof(RIL_Carrier));
    if (excluded_carriers == NULL) {
        RLOGE("Memory allocation failed for request %s", requestToString(pRI->pCI->requestNumber));
        goto exit;
    }
    cr.len_excluded_carriers = t;
    cr.excluded_carriers = excluded_carriers;

    startRequest;
    appendPrintBuf("%s len_allowed_carriers:%d, len_excluded_carriers:%d,",
                   printBuf, cr.len_allowed_carriers, cr.len_excluded_carriers);

    appendPrintBuf("%s allowed_carriers:", printBuf);
    for (int32_t i = 0; i < cr.len_allowed_carriers; i++) {
        RIL_Carrier *p_cr = allowed_carriers + i;
        p_cr->mcc = strdupReadString(p);
        p_cr->mnc = strdupReadString(p);
        status = p.readInt32(&t);
        p_cr->match_type = static_cast<RIL_CarrierMatchType>(t);
        if (status != NO_ERROR) {
            goto invalid;
        }
        p_cr->match_data = strdupReadString(p);
        appendPrintBuf("%s [%d mcc:%s, mnc:%s, match_type:%d, match_data:%s],",
                       printBuf, i, p_cr->mcc, p_cr->mnc, p_cr->match_type, p_cr->match_data);
    }

    for (int32_t i = 0; i < cr.len_excluded_carriers; i++) {
        RIL_Carrier *p_cr = excluded_carriers + i;
        p_cr->mcc = strdupReadString(p);
        p_cr->mnc = strdupReadString(p);
        status = p.readInt32(&t);
        p_cr->match_type = static_cast<RIL_CarrierMatchType>(t);
        if (status != NO_ERROR) {
            goto invalid;
        }
        p_cr->match_data = strdupReadString(p);
        appendPrintBuf("%s [%d mcc:%s, mnc:%s, match_type:%d, match_data:%s],",
                       printBuf, i, p_cr->mcc, p_cr->mnc, p_cr->match_type, p_cr->match_data);
    }

    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber,
                &cr,
                sizeof(RIL_CarrierRestrictions),
                pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

    goto exit;

invalid:
    invalidCommandBlock(pRI);
    RIL_onRequestComplete(pRI, RIL_E_INVALID_ARGUMENTS, NULL, 0);
exit:
    if (allowed_carriers != NULL) {
        free(allowed_carriers);
    }
    if (excluded_carriers != NULL) {
        free(excluded_carriers);
    }
    return;
}

//MTK-START [mtk80776] WiFi Calling
static void dispatchUiccIo(Parcel &p, RequestInfo *pRI)
{
    RIL_UICC_IO_v6 uiccIo;
    int32_t t = 0;
    status_t status;

    memset(&uiccIo, 0, sizeof(uiccIo));

    status = p.readInt32(&t);
    uiccIo.sessionId = (int)t;

    status = p.readInt32(&t);
    uiccIo.command = (int)t;

    status = p.readInt32(&t);
    uiccIo.fileId = (int)t;

    uiccIo.path = strdupReadString(p);

    status = p.readInt32(&t);
    uiccIo.p1 = (int)t;

    status = p.readInt32(&t);
    uiccIo.p2 = (int)t;

    status = p.readInt32(&t);
    uiccIo.p3 = (int)t;

    uiccIo.data = strdupReadString(p);
    uiccIo.pin2 = strdupReadString(p);

    startRequest;
    appendPrintBuf("%s sessionId=0x%X, cmd=0x%x, efid=0x%x path=%s,%d,%d,%d,%s,pin2=%s", printBuf,
            uiccIo.sessionId, uiccIo.command, uiccIo.fileId, (char *)uiccIo.path,
            uiccIo.p1, uiccIo.p2, uiccIo.p3, (char *)uiccIo.data, (char *)uiccIo.pin2);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->reqeustNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }

    CALL_ONREQUEST(pRI->pCI->requestNumber, &uiccIo, sizeof(RIL_UICC_IO_v6), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString(uiccIo.path);
    memsetString(uiccIo.data);
    memsetString(uiccIo.pin2);
#endif

    free(uiccIo.path);
    free(uiccIo.data);
    free(uiccIo.pin2);

#ifdef MEMSET_FREED
    memset(&uiccIo, 0, sizeof(RIL_UICC_IO_v6));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchUiccAuthentication(Parcel &p, RequestInfo *pRI)
{
    RIL_UICC_Authentication uiccAuth;
    int32_t t = 0;
    int32_t len;
    status_t status;

    RLOGD("dispatchUiccAuthentication Enter...");

    memset(&uiccAuth, 0, sizeof(uiccAuth));

    status = p.readInt32(&t);
    uiccAuth.session_id = (int)t;

    uiccAuth.context1 = strdupReadString(p);
    uiccAuth.context2 = strdupReadString(p);

    startRequest;
    appendPrintBuf("%ssessionId=%d, context1=%s, context2=%s", printBuf,
            uiccAuth.session_id, uiccAuth.context1, uiccAuth.context2);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }

    CALL_ONREQUEST(pRI->pCI->requestNumber, &uiccAuth, sizeof(uiccAuth), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString(uiccAuth.context1);
    memsetString(uiccAuth.context2);
#endif

    free(uiccAuth.context1);
    free(uiccAuth.context2);

#ifdef MEMSET_FREED
    memset(&uiccAuth, 0, sizeof(uiccAuth));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}
//MTK-END [mtk80776] WiFi Calling

// New SIM Authentication
static void dispatchSimAuth(Parcel &p, RequestInfo *pRI) {
    RIL_SimAuthStructure args;
    int32_t t = 0;
    status_t status;

    memset (&args, 0, sizeof(args));

    // Session ID
    status = p.readInt32(&t);
    args.sessionId = (int) t;

    // mode
    status = p.readInt32(&t);
    args.mode = (int) t;

    args.param1 = strdupReadString(p);
    args.param2 = strdupReadString(p);

    if (args.mode == 1) {
        // GBA
        status = p.readInt32(&t);
        args.tag = (int) t;
    }

    if (status != NO_ERROR) {
        goto invalid;
    }

    CALL_ONREQUEST(pRI->pCI->requestNumber, &args, sizeof(args), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

//[New R8 modem FD]
static void dispatchFdMode(Parcel &p, RequestInfo *pRI) {
    RIL_FdModeData args;
    status_t status;
    int t_value = 0;
    memset(&args, 0, sizeof(args));
    status = p.readInt32(&t_value);
    args.argsNum = t_value;

    /* AT+EFD=<mode>[,<param1>[,<param2>]] */
    /* For all modes: but mode 0 & 1 only has one argument */
    if (args.argsNum >= 1) {
        status = p.readInt32(&t_value);
        args.mode = t_value;
    }
    /* For mode 2 & 3 */
    if (args.argsNum >= 2) {
        status = p.readInt32(&t_value);
        args.parameter1 = t_value;
    }
    /* Only mode 2 */
    if (args.argsNum >=3) {
        status = p.readInt32(&t_value);
        args.parameter2 = t_value;
    }

    CALL_ONREQUEST(pRI->pCI->requestNumber, &args, sizeof(args), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));
}

static void dispatchPhbEntry(Parcel &p, RequestInfo *pRI) {

    RIL_PhbEntryStrucutre args;
    int32_t t = 0;
    status_t status;

    memset (&args, 0, sizeof(args));

    // storage type
    status = p.readInt32(&t);
    args.type = (int) t;

    // index of the entry
    status = p.readInt32(&t);
    args.index = (int) t;

    // phone number
    args.number = strdupReadString(p);

    // Type of the number
    status = p.readInt32(&t);
    args.ton = (int) t;

    // alpha Id
    args.alphaId = strdupReadString(p);

    if (status != NO_ERROR) {
        goto invalid;
    }

    startRequest;
    appendPrintBuf("%s%d,index=%d,num=%s,ton=%d,alphaId=%s", printBuf, args.type,
                   args.index, (char*)args.number, args.ton,  (char*)args.alphaId);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &args, sizeof(args), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString (args.number);
    memsetString (args.alphaId);
#endif

    free (args.number);
    free (args.alphaId);

#ifdef MEMSET_FREED
    memset(&args, 0, sizeof(args));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;

}

static void dispatchWritePhbEntryExt(Parcel &p, RequestInfo *pRI) {

    RIL_PHB_ENTRY args;
    int32_t t = 0;
    status_t status;

    memset (&args, 0, sizeof(args));

    // index of the entry
    status = p.readInt32(&t);
    args.index = (int) t;
    // phone number
    args.number = strdupReadString(p);
    // Type of the number
    status = p.readInt32(&t);
    args.type = (int) t;
    //text
    args.text = strdupReadString(p);
    //hidden
    status = p.readInt32(&t);
    args.hidden = (int) t;

    //group
    args.group = strdupReadString(p);
    //anr
    args.adnumber = strdupReadString(p);
    // Type of the adnumber
    status = p.readInt32(&t);
    args.adtype = (int) t;
    //SNE
    args.secondtext = strdupReadString(p);
    // email
    args.email = strdupReadString(p);

    if (status != NO_ERROR) {
        goto invalid;
    }

    startRequest;
    appendPrintBuf("%s,index=%d,num=%s,type=%d,text=%s,hidden=%d,group=%s,adnumber=%s,adtype=%d,secondtext=%s,email=%s", printBuf,
                   args.index, (char*)args.number, args.type, (char*)args.text,
                   args.hidden, (char*)args.group,(char*)args.adnumber, args.adtype,(char*)args.secondtext,(char*)args.email);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &args, sizeof(args), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString (args.number);
    memsetString (args.text);
    memsetString (args.group);
    memsetString (args.adnumber);
    memsetString (args.secondtext);
    memsetString (args.email);
#endif
    free (args.number);
    free (args.text);
    free (args.group);
    free (args.adnumber);
    free (args.secondtext);
    free (args.email);

#ifdef MEMSET_FREED
    memset(&args, 0, sizeof(args));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;

}


static int
blockingWrite(int fd, const void *buffer, size_t len) {
    size_t writeOffset = 0;
    const uint8_t *toWrite;

    toWrite = (const uint8_t *)buffer;

    while (writeOffset < len) {
        ssize_t written;
        do {
            written = write (fd, toWrite + writeOffset,
                                len - writeOffset);
        } while (written < 0 && ((errno == EINTR) || (errno == EAGAIN)));

        if (written >= 0) {
            writeOffset += written;
        } else {   // written < 0
            RLOGE ("RIL Response: unexpected error on write errno:%d", errno);
            close(fd);
            return -1;
        }
    }
#if VDBG
    RLOGE("RIL Response bytes written:%d", writeOffset);
#endif
    return 0;
}

static int
sendResponseRaw (const void *data, size_t dataSize, RIL_SOCKET_ID socket_id, int clientId) {
    int fd = s_ril_param_socket.fdCommand;
    int ret;
    uint32_t header;
    pthread_mutex_t * writeMutexHook = &s_writeMutex;

#if VDBG
    RLOGE("Send Response to %s %d", rilSocketIdToString(socket_id), clientId);
#endif
    if (clientId >= 0) {
        fd = s_ril_param_socket_clients[clientId].fdCommand;
        writeMutexHook = &(s_writeMutex_socket_client[clientId]);
        RLOGD("Send Response to client %d", clientId);
    } else {
        if (socket_id == RIL_SOCKET_2) {
            fd = s_ril_param_socket2.fdCommand;
            writeMutexHook = &s_writeMutex_socket2;
        }
        else if (socket_id == RIL_SOCKET_3) {
            fd = s_ril_param_socket3.fdCommand;
            writeMutexHook = &s_writeMutex_socket3;
        }
        else if (socket_id == RIL_SOCKET_4) {
            fd = s_ril_param_socket4.fdCommand;
            writeMutexHook = &s_writeMutex_socket4;
        }
        else if (socket_id == RIL_SOCKET_RILJ) {
            fd = s_ril_param_socket_rilj.fdCommand;
            writeMutexHook = &s_writeMutex_socket_rilj;
        }
        else if (socket_id == RIL_SOCKET_RILJ2) {
                fd = s_ril_param_socket_rilj2.fdCommand;
                writeMutexHook = &s_writeMutex_socket_rilj2;
        }
    }
    if (fd < 0) {
        return -1;
    }

    if (dataSize > MAX_COMMAND_BYTES) {
        RLOGE("RIL: packet larger than %u (%u)",
                MAX_COMMAND_BYTES, (unsigned int )dataSize);

        return -1;
    }

    pthread_mutex_lock(writeMutexHook);

    header = htonl(dataSize);

    ret = blockingWrite(fd, (void *)&header, sizeof(header));

    if (ret < 0) {
        pthread_mutex_unlock(writeMutexHook);
        return ret;
    }

    ret = blockingWrite(fd, data, dataSize);

    if (ret < 0) {
        pthread_mutex_unlock(writeMutexHook);
        return ret;
    }

    pthread_mutex_unlock(writeMutexHook);
    return 0;
}

static int
sendResponse (Parcel &p, RIL_SOCKET_ID socket_id, int clientId) {
    printResponse;
    return sendResponseRaw(p.data(), p.dataSize(), socket_id, clientId);
}

/** response is an int* pointing to an array of ints */

static int
responseInts(Parcel &p, void *response, size_t responselen) {
    int numInts;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }
    if (responselen % sizeof(int) != 0) {
        RLOGE("responseInts: invalid response length %d expected multiple of %d\n",
            (int)responselen, (int)sizeof(int));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    int *p_int = (int *) response;

    numInts = responselen / sizeof(int);
    p.writeInt32 (numInts);

    /* each int*/
    startResponse;
    for (int i = 0 ; i < numInts ; i++) {
        appendPrintBuf("%s%d,", printBuf, p_int[i]);
        p.writeInt32(p_int[i]);
    }
    removeLastChar;
    closeResponse;

    return 0;
}

// Response is an int or RIL_LastCallFailCauseInfo.
// Currently, only Shamu plans to use RIL_LastCallFailCauseInfo.
// TODO(yjl): Let all implementations use RIL_LastCallFailCauseInfo.
static int responseFailCause(Parcel &p, void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen == sizeof(int)) {
      startResponse;
      int *p_int = (int *) response;
      appendPrintBuf("%s%d,", printBuf, p_int[0]);
      p.writeInt32(p_int[0]);
      removeLastChar;
      closeResponse;
    } else if (responselen == sizeof(RIL_LastCallFailCauseInfo)) {
      startResponse;
      RIL_LastCallFailCauseInfo *p_fail_cause_info = (RIL_LastCallFailCauseInfo *) response;
      appendPrintBuf("%s[cause_code=%d,vendor_cause=%s]", printBuf, p_fail_cause_info->cause_code,
                     p_fail_cause_info->vendor_cause);
      p.writeInt32(p_fail_cause_info->cause_code);
      writeStringToParcel(p, p_fail_cause_info->vendor_cause);
      removeLastChar;
      closeResponse;
    } else {
      RLOGE("responseFailCause: invalid response length %d expected an int or "
            "RIL_LastCallFailCauseInfo", (int)responselen);
      return RIL_ERRNO_INVALID_RESPONSE;
    }

    return 0;
}

/** response is a char **, pointing to an array of char *'s
    The parcel will begin with the version */
static int responseStringsWithVersion(int version, Parcel &p, void *response, size_t responselen) {
    p.writeInt32(version);
    return responseStrings(p, response, responselen);
}

/** response is a char **, pointing to an array of char *'s */
static int responseStrings(Parcel &p, void *response, size_t responselen) {
    int numStrings;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }
    if (responselen % sizeof(char *) != 0) {
        RLOGE("responseStrings: invalid response length %d expected multiple of %d\n",
            (int)responselen, (int)sizeof(char *));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (response == NULL) {
        p.writeInt32 (0);
    } else {
        char **p_cur = (char **) response;

        numStrings = responselen / sizeof(char *);
        p.writeInt32 (numStrings);

        /* each string*/
        startResponse;
        for (int i = 0 ; i < numStrings ; i++) {
            appendPrintBuf("%s%s,", printBuf, (char*)p_cur[i]);
            writeStringToParcel (p, p_cur[i]);
        }
        removeLastChar;
        closeResponse;
    }
    return 0;
}

static void responseRIL_CellIdentity_v16(Parcel &p, RIL_CellIdentity_v16 *ci) {
    p.writeInt32(ci->cellInfoType);
    switch (ci->cellInfoType) {
        case RIL_CELL_INFO_TYPE_GSM: {
            p.writeInt32(ci->cellIdentityGsm.mcc);
            p.writeInt32(ci->cellIdentityGsm.mnc);
            p.writeInt32(ci->cellIdentityGsm.mnc_len);
            p.writeInt32(ci->cellIdentityGsm.lac);
            p.writeInt32(ci->cellIdentityGsm.cid);
            p.writeInt32(ci->cellIdentityGsm.arfcn);
            p.writeByte(ci->cellIdentityGsm.bsic);
            writeStringToParcel(p, (const char *)ci->cellIdentityGsm.operName.long_name);
            writeStringToParcel(p, (const char *)ci->cellIdentityGsm.operName.short_name);
            break;
        }
        case RIL_CELL_INFO_TYPE_WCDMA: {
            p.writeInt32(ci->cellIdentityWcdma.mcc);
            p.writeInt32(ci->cellIdentityWcdma.mnc);
            p.writeInt32(ci->cellIdentityWcdma.mnc_len);
            p.writeInt32(ci->cellIdentityWcdma.lac);
            p.writeInt32(ci->cellIdentityWcdma.cid);
            p.writeInt32(ci->cellIdentityWcdma.uarfcn);
            writeStringToParcel(p, (const char *)ci->cellIdentityWcdma.operName.long_name);
            writeStringToParcel(p, (const char *)ci->cellIdentityWcdma.operName.short_name);
            break;
        }
        case RIL_CELL_INFO_TYPE_CDMA: {
            p.writeInt32(ci->cellIdentityCdma.networkId);
            p.writeInt32(ci->cellIdentityCdma.systemId);
            p.writeInt32(ci->cellIdentityCdma.basestationId);
            p.writeInt32(ci->cellIdentityCdma.longitude);
            p.writeInt32(ci->cellIdentityCdma.latitude);
            writeStringToParcel(p, (const char *)ci->cellIdentityCdma.operName.long_name);
            writeStringToParcel(p, (const char *)ci->cellIdentityCdma.operName.short_name);
            break;
        }
        case RIL_CELL_INFO_TYPE_LTE: {
            p.writeInt32(ci->cellIdentityLte.mcc);
            p.writeInt32(ci->cellIdentityLte.mnc);
            p.writeInt32(ci->cellIdentityLte.mnc_len);
            p.writeInt32(ci->cellIdentityLte.ci);
            p.writeInt32(ci->cellIdentityLte.pci);
            p.writeInt32(ci->cellIdentityLte.tac);
            p.writeInt32(ci->cellIdentityLte.earfcn);
            writeStringToParcel(p, (const char *)ci->cellIdentityLte.operName.long_name);
            writeStringToParcel(p, (const char *)ci->cellIdentityLte.operName.short_name);
            p.writeInt32(ci->cellIdentityLte.bandwidth);
            break;
        }
        case RIL_CELL_INFO_TYPE_TD_SCDMA: {
            p.writeInt32(ci->cellIdentityTdscdma.mcc);
            p.writeInt32(ci->cellIdentityTdscdma.mnc);
            p.writeInt32(ci->cellIdentityTdscdma.mnc_len);
            p.writeInt32(ci->cellIdentityTdscdma.lac);
            p.writeInt32(ci->cellIdentityTdscdma.cid);
            p.writeInt32(ci->cellIdentityTdscdma.cpid);
            writeStringToParcel(p, (const char *)ci->cellIdentityTdscdma.operName.long_name);
            writeStringToParcel(p, (const char *)ci->cellIdentityTdscdma.operName.short_name);
            break;
        }

        default: {
            break;
        }
    }
}

static int responseVoiceRegState(Parcel &p, void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    } else if (s_callbacks.version >= 15) {
        if (responselen == sizeof(RIL_VoiceRegistrationStateResponse)) {
            RIL_VoiceRegistrationStateResponse *res = (RIL_VoiceRegistrationStateResponse *) response;
            p.writeInt32(res->regState);
            p.writeInt32(res->rat);
            p.writeInt32(res->cssSupported);
            p.writeInt32(res->roamingIndicator);
            p.writeInt32(res->systemIsInPrl);
            p.writeInt32(res->defaultRoamingIndicator);
            p.writeInt32(res->reasonForDenial);
            responseRIL_CellIdentity_v16(p, &(res->cellIdentity));
        } else {
            RLOGE("invalid response: size not matched");
            return RIL_ERRNO_INVALID_RESPONSE;
        }
    } else {
        responseStrings(p, response, responselen);
    }
    return 0;
}

static int responseDataRegState(Parcel &p, void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    } else if (s_callbacks.version >= 15) {
        if (responselen == sizeof(RIL_DataRegistrationStateResponse)) {
            RIL_DataRegistrationStateResponse *res = (RIL_DataRegistrationStateResponse *) response;
            p.writeInt32(res->regState);
            p.writeInt32(res->rat);
            p.writeInt32(res->reasonDataDenied);
            p.writeInt32(res->maxDataCalls);
            responseRIL_CellIdentity_v16(p, &(res->cellIdentity));
        } else {
            RLOGE("invalid response: size not matched");
            return RIL_ERRNO_INVALID_RESPONSE;
        }
    } else {
        responseStrings(p, response, responselen);
    }
    return 0;
}

static int responseKeepaliveStatus(Parcel &p, void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    } else if (s_callbacks.version >= 15) {
        if (responselen == sizeof(RIL_KeepaliveStatus)) {
            RIL_KeepaliveStatus *stat = (RIL_KeepaliveStatus *)response;
            p.writeInt32(stat->sessionHandle);
            p.writeInt32(stat->code);
        } else {
            RLOGE("invalid response: size not matched");
            return RIL_ERRNO_INVALID_RESPONSE;
        }
    } else {
        return responseVoid(p, response, responselen);
    }
    return 0;
}

/**
 * NULL strings are accepted
 * FIXME currently ignores responselen
 */
static int responseString(Parcel &p, void *response, size_t responselen) {
    /* one string only */
    startResponse;
    appendPrintBuf("%s%s", printBuf, (char*)response);
    closeResponse;

    writeStringToParcel(p, (const char *)response);

    return 0;
}

static int responseVoid(Parcel &p, void *response, size_t responselen) {
    startResponse;
    removeLastChar;
    return 0;
}

static int responseCallList(Parcel &p, void *response, size_t responselen) {
    int num;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof (RIL_Call *) != 0) {
        RLOGE("responseCallList: invalid response length %d expected multiple of %d\n",
            (int)responselen, (int)sizeof (RIL_Call *));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;
    /* number of call info's */
    num = responselen / sizeof(RIL_Call *);
    /// MTK_RIL_ADAPTER for IMS CC @{
    int count = 0;
    for (int i = 0 ; i < num ; i++) {
        RIL_Call *p_cur = ((RIL_Call **) response)[i];
        if (p_cur->index < CONF_CALL_ID_SHIFT) {
            count++;
        }
    }
    p.writeInt32(count);
    /// @}

    for (int i = 0 ; i < num ; i++) {
        RIL_Call *p_cur = ((RIL_Call **) response)[i];
        /// MTK_RIL_ADAPTER for IMS CC @{
        if (p_cur->index >= CONF_CALL_ID_SHIFT) {
            continue;
        }
        /// @}
        /* each call info */
        p.writeInt32(p_cur->state);
        p.writeInt32(p_cur->index);
        p.writeInt32(p_cur->toa);
        p.writeInt32(p_cur->isMpty);
        p.writeInt32(p_cur->isMT);
        p.writeInt32(p_cur->als);
        p.writeInt32(p_cur->isVoice);
        p.writeInt32(p_cur->isVoicePrivacy);
        writeStringToParcel(p, p_cur->number);
        p.writeInt32(p_cur->numberPresentation);
        writeStringToParcel(p, p_cur->name);
        p.writeInt32(p_cur->namePresentation);
        // Remove when partners upgrade to version 3
        if ((s_callbacks.version < 3) || (p_cur->uusInfo == NULL || p_cur->uusInfo->uusData == NULL)) {
            p.writeInt32(0); /* UUS Information is absent */
        } else {
            RIL_UUS_Info *uusInfo = p_cur->uusInfo;
            p.writeInt32(1); /* UUS Information is present */
            p.writeInt32(uusInfo->uusType);
            p.writeInt32(uusInfo->uusDcs);
            p.writeInt32(uusInfo->uusLength);
            p.write(uusInfo->uusData, uusInfo->uusLength);
        }
        p.writeInt32(p_cur->speechCodec);
        appendPrintBuf("%s[id=%d,%s,toa=%d,",
            printBuf,
            p_cur->index,
            callStateToString(p_cur->state),
            p_cur->toa);
        appendPrintBuf("%s%s,%s,als=%d,%s,%s,",
            printBuf,
            (p_cur->isMpty)?"conf":"norm",
            (p_cur->isMT)?"mt":"mo",
            p_cur->als,
            (p_cur->isVoice)?"voc":"nonvoc",
            (p_cur->isVoicePrivacy)?"evp":"noevp");
        appendPrintBuf("%s%s,cli=%d,name='%s',%d]",
            printBuf,
            p_cur->number,
            p_cur->numberPresentation,
            p_cur->name,
            p_cur->namePresentation);
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static int responseSMS(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof (RIL_SMS_Response) ) {
        RLOGE("invalid response length %d expected %d",
                (int)responselen, (int)sizeof (RIL_SMS_Response));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_SMS_Response *p_cur = (RIL_SMS_Response *) response;

    p.writeInt32(p_cur->messageRef);
    writeStringToParcel(p, p_cur->ackPDU);
    p.writeInt32(p_cur->errorCode);

    startResponse;
    appendPrintBuf("%s%d,%s,%d", printBuf, p_cur->messageRef,
        (char*)p_cur->ackPDU, p_cur->errorCode);
    closeResponse;

    return 0;
}

static int responseDataCallListV4(Parcel &p, void *response, size_t responselen)
{
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_Data_Call_Response_v4) != 0) {
        RLOGE("responseDataCallListV4: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_Data_Call_Response_v4));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    // Write version
    p.writeInt32(4);

    int num = responselen / sizeof(RIL_Data_Call_Response_v4);
    p.writeInt32(num);

    RIL_Data_Call_Response_v4 *p_cur = (RIL_Data_Call_Response_v4 *) response;
    startResponse;
    int i;
    for (i = 0; i < num; i++) {
        p.writeInt32(p_cur[i].cid);
        p.writeInt32(p_cur[i].active);
        writeStringToParcel(p, p_cur[i].type);
        // apn is not used, so don't send.
        writeStringToParcel(p, p_cur[i].address);
        appendPrintBuf("%s[cid=%d,%s,%s,%s],", printBuf,
            p_cur[i].cid,
            (p_cur[i].active==0)?"down":"up",
            (char*)p_cur[i].type,
            (char*)p_cur[i].address);
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static int responseDataCallListV6(Parcel &p, void *response, size_t responselen)
{
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_Data_Call_Response_v6) != 0) {
        RLOGE("responseDataCallListV6: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_Data_Call_Response_v6));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    // Write version
    p.writeInt32(6);

    int num = responselen / sizeof(RIL_Data_Call_Response_v6);
    p.writeInt32(num);

    RIL_Data_Call_Response_v6 *p_cur = (RIL_Data_Call_Response_v6 *) response;
    startResponse;
    int i;
    for (i = 0; i < num; i++) {
        p.writeInt32((int)p_cur[i].status);
        p.writeInt32(p_cur[i].suggestedRetryTime);
        p.writeInt32(p_cur[i].cid);
        p.writeInt32(p_cur[i].active);
        writeStringToParcel(p, p_cur[i].type);
        writeStringToParcel(p, p_cur[i].ifname);
        writeStringToParcel(p, p_cur[i].addresses);
        writeStringToParcel(p, p_cur[i].dnses);
        writeStringToParcel(p, p_cur[i].gateways);
        appendPrintBuf("%s[status=%d,retry=%d,cid=%d,%s,%s,%s,%s,%s,%s],", printBuf,
            p_cur[i].status,
            p_cur[i].suggestedRetryTime,
            p_cur[i].cid,
            (p_cur[i].active==0)?"down":"up",
            (char*)p_cur[i].type,
            (char*)p_cur[i].ifname,
            (char*)p_cur[i].addresses,
            (char*)p_cur[i].dnses,
            (char*)p_cur[i].gateways);
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static int responseDataCallListV9(Parcel &p, void *response, size_t responselen)
{
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_Data_Call_Response_v9) != 0) {
        RLOGE("responseDataCallListV9: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_Data_Call_Response_v9));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    // Write version
    p.writeInt32(10);

    int num = responselen / sizeof(RIL_Data_Call_Response_v9);
    p.writeInt32(num);

    RIL_Data_Call_Response_v9 *p_cur = (RIL_Data_Call_Response_v9 *) response;
    startResponse;
    int i;
    for (i = 0; i < num; i++) {
        p.writeInt32((int)p_cur[i].status);
        p.writeInt32(p_cur[i].suggestedRetryTime);
        p.writeInt32(p_cur[i].cid);
        p.writeInt32(p_cur[i].active);
        writeStringToParcel(p, p_cur[i].type);
        writeStringToParcel(p, p_cur[i].ifname);
        writeStringToParcel(p, p_cur[i].addresses);
        writeStringToParcel(p, p_cur[i].dnses);
        writeStringToParcel(p, p_cur[i].gateways);
        writeStringToParcel(p, p_cur[i].pcscf);
        appendPrintBuf("%s[status=%d,retry=%d,cid=%d,%s,%s,%s,%s,%s,%s,%s],", printBuf,
            p_cur[i].status,
            p_cur[i].suggestedRetryTime,
            p_cur[i].cid,
            (p_cur[i].active==0)?"down":"up",
            (char*)p_cur[i].type,
            (char*)p_cur[i].ifname,
            (char*)p_cur[i].addresses,
            (char*)p_cur[i].dnses,
            (char*)p_cur[i].gateways,
            (char*)p_cur[i].pcscf);
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static int responseDataCallListV11(Parcel &p, void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
                RLOGE("invalid response: NULL");
                return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(MTK_RIL_Data_Call_Response_v11) != 0) {
        RLOGE("invalid response length %d expected multiple of %d",
        (int)responselen, (int)sizeof(MTK_RIL_Data_Call_Response_v11));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    // Write version
    p.writeInt32(11);

    int num = responselen / sizeof(MTK_RIL_Data_Call_Response_v11);
    p.writeInt32(num);

    MTK_RIL_Data_Call_Response_v11 *p_cur = (MTK_RIL_Data_Call_Response_v11 *) response;
    startResponse;
    int i;
    for (i = 0; i < num; i++) {
        p.writeInt32((int)p_cur[i].status);
        p.writeInt32(p_cur[i].suggestedRetryTime);
        p.writeInt32(p_cur[i].cid);
        p.writeInt32(p_cur[i].active);
        writeStringToParcel(p, p_cur[i].type);
        writeStringToParcel(p, p_cur[i].ifname);
        writeStringToParcel(p, p_cur[i].addresses);
        writeStringToParcel(p, p_cur[i].dnses);
        writeStringToParcel(p, p_cur[i].gateways);
        writeStringToParcel(p, p_cur[i].pcscf);
        p.writeInt32(p_cur[i].mtu);
        p.writeInt32(p_cur[i].rat);
        appendPrintBuf("%s[status=%d,retry=%d,cid=%d,%s,%s,%s,%s,%s,%s,%s,%d,rat=%d],", printBuf,
        p_cur[i].status,
        p_cur[i].suggestedRetryTime,
        p_cur[i].cid,
        (p_cur[i].active==0)?"down":"up",
        (char*)p_cur[i].type,
        (char*)p_cur[i].ifname,
        (char*)p_cur[i].addresses,
        (char*)p_cur[i].dnses,
        (char*)p_cur[i].gateways,
        (char*)p_cur[i].pcscf,
        p_cur[i].mtu,
        p_cur[i].rat);
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static int responseDataCallList(Parcel &p, void *response, size_t responselen)
{
    if (s_callbacks.version <= LAST_IMPRECISE_RIL_VERSION) {
        if (s_callbacks.version < 5) {
            RLOGD("responseDataCallList: v4");
            return responseDataCallListV4(p, response, responselen);
        } else if (responselen % sizeof(RIL_Data_Call_Response_v6) == 0) {
            return responseDataCallListV6(p, response, responselen);
        } else if (responselen % sizeof(RIL_Data_Call_Response_v9) == 0) {
            return responseDataCallListV9(p, response, responselen);
        } else {
            return responseDataCallListV11(p, response, responselen);
        }
    } else { // RIL version >= 13
        if (responselen % sizeof(MTK_RIL_Data_Call_Response_v11) != 0) {
            RLOGE("Data structure expected is MTK_RIL_Data_Call_Response_v11");
            if (!isDebuggable()) {
                return RIL_ERRNO_INVALID_RESPONSE;
            } else {
                assert(0);
            }
        }
        return responseDataCallListV11(p, response, responselen);
    }
}

static int responseSetupDataCall(Parcel &p, void *response, size_t responselen)
{
    if (s_callbacks.version < 5) {
        return responseStringsWithVersion(s_callbacks.version, p, response, responselen);
    } else {
        return responseDataCallList(p, response, responselen);
    }
}

static int responseRaw(Parcel &p, void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL with responselen != 0");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    // The java code reads -1 size as null byte array
    if (response == NULL) {
        p.writeInt32(-1);
    } else {
        p.writeInt32(responselen);
        p.write(response, responselen);
    }

    return 0;
}


static int responseSIM_IO(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof (RIL_SIM_IO_Response) ) {
        RLOGE("invalid response length was %d expected %d",
                (int)responselen, (int)sizeof (RIL_SIM_IO_Response));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_SIM_IO_Response *p_cur = (RIL_SIM_IO_Response *) response;
    p.writeInt32(p_cur->sw1);
    p.writeInt32(p_cur->sw2);
    writeStringToParcel(p, p_cur->simResponse);

    startResponse;
    appendPrintBuf("%ssw1=0x%X,sw2=0x%X,%s", printBuf, p_cur->sw1, p_cur->sw2,
        (char*)p_cur->simResponse);
    closeResponse;


    return 0;
}

static int responseCallForwards(Parcel &p, void *response, size_t responselen) {
    int num;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_CallForwardInfo *) != 0) {
        RLOGE("responseCallForwards: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_CallForwardInfo *));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    /* number of call info's */
    num = responselen / sizeof(RIL_CallForwardInfo *);
    p.writeInt32(num);

    startResponse;
    for (int i = 0 ; i < num ; i++) {
        RIL_CallForwardInfo *p_cur = ((RIL_CallForwardInfo **) response)[i];

        p.writeInt32(p_cur->status);
        p.writeInt32(p_cur->reason);
        p.writeInt32(p_cur->serviceClass);
        p.writeInt32(p_cur->toa);
        writeStringToParcel(p, p_cur->number);
        p.writeInt32(p_cur->timeSeconds);
        appendPrintBuf("%s[%s,reason=%d,cls=%d,toa=%d,%s,tout=%d],", printBuf,
            (p_cur->status==1)?"enable":"disable",
            p_cur->reason, p_cur->serviceClass, p_cur->toa,
            (char*)p_cur->number,
            p_cur->timeSeconds);
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static int responseCallForwardsEx(Parcel &p, void *response, size_t responselen) {
    int num;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_CallForwardInfoEx *) != 0) {
        RLOGE("responseCallForwardsEx: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_CallForwardInfoEx *));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    /* number of call info's */
    num = responselen / sizeof(RIL_CallForwardInfoEx *);
    p.writeInt32(num);

    startResponse;
    for (int i = 0 ; i < num ; i++) {
        RIL_CallForwardInfoEx *p_cur = ((RIL_CallForwardInfoEx **) response)[i];

        p.writeInt32(p_cur->status);
        p.writeInt32(p_cur->reason);
        p.writeInt32(p_cur->serviceClass);
        p.writeInt32(p_cur->toa);
        writeStringToParcel(p, p_cur->number);
        p.writeInt32(p_cur->timeSeconds);

        writeStringToParcel(p, p_cur->timeSlotBegin);
        writeStringToParcel(p, p_cur->timeSlotEnd);

        appendPrintBuf("%s[%s,reason=%d,cls=%d,toa=%d,%s,tout=%d,timeSlot=%s,%s],", printBuf,
            (p_cur->status==1)?"enable":"disable",
            p_cur->reason, p_cur->serviceClass, p_cur->toa,
            (char*)p_cur->number,
            p_cur->timeSeconds,
            p_cur->timeSlotBegin,
            p_cur->timeSlotEnd);
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static int responseSsn(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof(RIL_SuppSvcNotification)) {
        RLOGE("invalid response length was %d expected %d",
                (int)responselen, (int)sizeof (RIL_SuppSvcNotification));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_SuppSvcNotification *p_cur = (RIL_SuppSvcNotification *) response;
    p.writeInt32(p_cur->notificationType);
    p.writeInt32(p_cur->code);
    p.writeInt32(p_cur->index);
    p.writeInt32(p_cur->type);
    writeStringToParcel(p, p_cur->number);

    startResponse;
    appendPrintBuf("%s%s,code=%d,id=%d,type=%d,%s", printBuf,
        (p_cur->notificationType==0)?"mo":"mt",
         p_cur->code, p_cur->index, p_cur->type,
        (char*)p_cur->number);
    closeResponse;

    return 0;
}

static int responseCellList(Parcel &p, void *response, size_t responselen) {
    int num;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof (RIL_NeighboringCell *) != 0) {
        RLOGE("responseCellList: invalid response length %d expected multiple of %d\n",
            (int)responselen, (int)sizeof (RIL_NeighboringCell *));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;
    /* number of records */
    num = responselen / sizeof(RIL_NeighboringCell *);
    p.writeInt32(num);

    for (int i = 0 ; i < num ; i++) {
        RIL_NeighboringCell *p_cur = ((RIL_NeighboringCell **) response)[i];

        p.writeInt32(p_cur->rssi);
        writeStringToParcel (p, p_cur->cid);

        appendPrintBuf("%s[cid=%s,rssi=%d],", printBuf,
            p_cur->cid, p_cur->rssi);
    }
    removeLastChar;
    closeResponse;

    return 0;
}

/**
 * Marshall the signalInfoRecord into the parcel if it exists.
 */
static void marshallSignalInfoRecord(Parcel &p,
            RIL_CDMA_SignalInfoRecord &p_signalInfoRecord) {
    p.writeInt32(p_signalInfoRecord.isPresent);
    p.writeInt32(p_signalInfoRecord.signalType);
    p.writeInt32(p_signalInfoRecord.alertPitch);
    p.writeInt32(p_signalInfoRecord.signal);
}

static int responseCdmaInformationRecords(Parcel &p,
            void *response, size_t responselen) {
    int num;
    char* string8 = NULL;
    int buffer_lenght;
    RIL_CDMA_InformationRecord *infoRec;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof (RIL_CDMA_InformationRecords)) {
        RLOGE("responseCdmaInformationRecords: invalid response length %d expected multiple of %d\n",
            (int)responselen, (int)sizeof (RIL_CDMA_InformationRecords *));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_CDMA_InformationRecords *p_cur =
                             (RIL_CDMA_InformationRecords *) response;
    num = MIN(p_cur->numberOfInfoRecs, RIL_CDMA_MAX_NUMBER_OF_INFO_RECS);

    startResponse;
    p.writeInt32(num);

    for (int i = 0 ; i < num ; i++) {
        infoRec = &p_cur->infoRec[i];
        p.writeInt32(infoRec->name);
        switch (infoRec->name) {
            case RIL_CDMA_DISPLAY_INFO_REC:
            case RIL_CDMA_EXTENDED_DISPLAY_INFO_REC:
                if (infoRec->rec.display.alpha_len >
                                         CDMA_ALPHA_INFO_BUFFER_LENGTH) {
                    RLOGE("invalid display info response length %d \
                          expected not more than %d\n",
                         (int)infoRec->rec.display.alpha_len,
                         CDMA_ALPHA_INFO_BUFFER_LENGTH);
                    return RIL_ERRNO_INVALID_RESPONSE;
                }
                string8 = (char*) calloc(infoRec->rec.display.alpha_len + 1, sizeof(char));
                if (string8 == NULL) {
                    RLOGE("Memory allocation failed for responseCdmaInformationRecords");
                    closeRequest;
                    return RIL_ERRNO_NO_MEMORY;
                }
                for (int i = 0 ; i < infoRec->rec.display.alpha_len ; i++) {
                    string8[i] = infoRec->rec.display.alpha_buf[i];
                }
                string8[(int)infoRec->rec.display.alpha_len] = '\0';
                writeStringToParcel(p, (const char*)string8);
                free(string8);
                string8 = NULL;
                break;
            case RIL_CDMA_CALLED_PARTY_NUMBER_INFO_REC:
            case RIL_CDMA_CALLING_PARTY_NUMBER_INFO_REC:
            case RIL_CDMA_CONNECTED_NUMBER_INFO_REC:
                if (infoRec->rec.number.len > CDMA_NUMBER_INFO_BUFFER_LENGTH) {
                    RLOGE("invalid display info response length %d \
                          expected not more than %d\n",
                         (int)infoRec->rec.number.len,
                         CDMA_NUMBER_INFO_BUFFER_LENGTH);
                    return RIL_ERRNO_INVALID_RESPONSE;
                }
                string8 = (char*) calloc(infoRec->rec.number.len + 1, sizeof(char));
                if (string8 == NULL) {
                    RLOGE("Memory allocation failed for responseCdmaInformationRecords");
                    closeRequest;
                    return RIL_ERRNO_NO_MEMORY;
                }
                for (int i = 0 ; i < infoRec->rec.number.len; i++) {
                    string8[i] = infoRec->rec.number.buf[i];
                }
                string8[(int)infoRec->rec.number.len] = '\0';
                writeStringToParcel(p, (const char*)string8);
                free(string8);
                string8 = NULL;
                p.writeInt32(infoRec->rec.number.number_type);
                p.writeInt32(infoRec->rec.number.number_plan);
                p.writeInt32(infoRec->rec.number.pi);
                p.writeInt32(infoRec->rec.number.si);
                break;
            case RIL_CDMA_SIGNAL_INFO_REC:
                p.writeInt32(infoRec->rec.signal.isPresent);
                p.writeInt32(infoRec->rec.signal.signalType);
                p.writeInt32(infoRec->rec.signal.alertPitch);
                p.writeInt32(infoRec->rec.signal.signal);

                appendPrintBuf("%sisPresent=%X, signalType=%X, \
                                alertPitch=%X, signal=%X, ",
                   printBuf, (int)infoRec->rec.signal.isPresent,
                   (int)infoRec->rec.signal.signalType,
                   (int)infoRec->rec.signal.alertPitch,
                   (int)infoRec->rec.signal.signal);
                removeLastChar;
                break;
            case RIL_CDMA_REDIRECTING_NUMBER_INFO_REC:
                if (infoRec->rec.redir.redirectingNumber.len >
                                              CDMA_NUMBER_INFO_BUFFER_LENGTH) {
                    RLOGE("invalid display info response length %d \
                          expected not more than %d\n",
                         (int)infoRec->rec.redir.redirectingNumber.len,
                         CDMA_NUMBER_INFO_BUFFER_LENGTH);
                    return RIL_ERRNO_INVALID_RESPONSE;
                }
                string8 = (char*) calloc(infoRec->rec.redir.redirectingNumber.len + 1,
                        sizeof(char));
                if (string8 == NULL) {
                    RLOGE("Memory allocation failed for responseCdmaInformationRecords");
                    closeRequest;
                    return RIL_ERRNO_NO_MEMORY;
                }
                for (int i = 0;
                         i < infoRec->rec.redir.redirectingNumber.len;
                         i++) {
                    string8[i] = infoRec->rec.redir.redirectingNumber.buf[i];
                }
                string8[(int)infoRec->rec.redir.redirectingNumber.len] = '\0';
                writeStringToParcel(p, (const char*)string8);
                free(string8);
                string8 = NULL;
                p.writeInt32(infoRec->rec.redir.redirectingNumber.number_type);
                p.writeInt32(infoRec->rec.redir.redirectingNumber.number_plan);
                p.writeInt32(infoRec->rec.redir.redirectingNumber.pi);
                p.writeInt32(infoRec->rec.redir.redirectingNumber.si);
                p.writeInt32(infoRec->rec.redir.redirectingReason);
                break;
            case RIL_CDMA_LINE_CONTROL_INFO_REC:
                p.writeInt32(infoRec->rec.lineCtrl.lineCtrlPolarityIncluded);
                p.writeInt32(infoRec->rec.lineCtrl.lineCtrlToggle);
                p.writeInt32(infoRec->rec.lineCtrl.lineCtrlReverse);
                p.writeInt32(infoRec->rec.lineCtrl.lineCtrlPowerDenial);

                appendPrintBuf("%slineCtrlPolarityIncluded=%d, \
                                lineCtrlToggle=%d, lineCtrlReverse=%d, \
                                lineCtrlPowerDenial=%d, ", printBuf,
                       (int)infoRec->rec.lineCtrl.lineCtrlPolarityIncluded,
                       (int)infoRec->rec.lineCtrl.lineCtrlToggle,
                       (int)infoRec->rec.lineCtrl.lineCtrlReverse,
                       (int)infoRec->rec.lineCtrl.lineCtrlPowerDenial);
                removeLastChar;
                break;
            case RIL_CDMA_T53_CLIR_INFO_REC:
                p.writeInt32((int)(infoRec->rec.clir.cause));

                appendPrintBuf("%scause%d", printBuf, infoRec->rec.clir.cause);
                removeLastChar;
                break;
            case RIL_CDMA_T53_AUDIO_CONTROL_INFO_REC:
                p.writeInt32(infoRec->rec.audioCtrl.upLink);
                p.writeInt32(infoRec->rec.audioCtrl.downLink);

                appendPrintBuf("%supLink=%d, downLink=%d, ", printBuf,
                        infoRec->rec.audioCtrl.upLink,
                        infoRec->rec.audioCtrl.downLink);
                removeLastChar;
                break;
            case RIL_CDMA_T53_RELEASE_INFO_REC:
                // TODO(Moto): See David Krause, he has the answer:)
                RLOGE("RIL_CDMA_T53_RELEASE_INFO_REC: return INVALID_RESPONSE");
                return RIL_ERRNO_INVALID_RESPONSE;
            default:
                RLOGE("Incorrect name value");
                return RIL_ERRNO_INVALID_RESPONSE;
        }
    }
    closeResponse;

    return 0;
}

static void responseRilSignalStrengthV5(Parcel &p, RIL_SignalStrength_v10 *p_cur) {
    p.writeInt32(p_cur->GW_SignalStrength.signalStrength);
    p.writeInt32(p_cur->GW_SignalStrength.bitErrorRate);
    p.writeInt32(p_cur->CDMA_SignalStrength.dbm);
    p.writeInt32(p_cur->CDMA_SignalStrength.ecio);
    p.writeInt32(p_cur->EVDO_SignalStrength.dbm);
    p.writeInt32(p_cur->EVDO_SignalStrength.ecio);
    p.writeInt32(p_cur->EVDO_SignalStrength.signalNoiseRatio);
}

static void responseRilSignalStrengthV6Extra(Parcel &p, RIL_SignalStrength_v10 *p_cur) {
    /*
     * Fixup LTE for backwards compatibility
     */
    // signalStrength: -1 -> 99
    if (p_cur->LTE_SignalStrength.signalStrength == -1) {
        p_cur->LTE_SignalStrength.signalStrength = 99;
    }
    // rsrp: -1 -> INT_MAX all other negative value to positive.
    // So remap here
    if (p_cur->LTE_SignalStrength.rsrp == -1) {
        p_cur->LTE_SignalStrength.rsrp = INT_MAX;
    } else if (p_cur->LTE_SignalStrength.rsrp < -1) {
        p_cur->LTE_SignalStrength.rsrp = -p_cur->LTE_SignalStrength.rsrp;
    }
    // rsrq: -1 -> INT_MAX
    if (p_cur->LTE_SignalStrength.rsrq == -1) {
        p_cur->LTE_SignalStrength.rsrq = INT_MAX;
    }
    // Not remapping rssnr is already using INT_MAX

    // cqi: -1 -> INT_MAX
    if (p_cur->LTE_SignalStrength.cqi == -1) {
        p_cur->LTE_SignalStrength.cqi = INT_MAX;
    }

    p.writeInt32(p_cur->LTE_SignalStrength.signalStrength);
    p.writeInt32(p_cur->LTE_SignalStrength.rsrp);
    p.writeInt32(p_cur->LTE_SignalStrength.rsrq);
    p.writeInt32(p_cur->LTE_SignalStrength.rssnr);
    p.writeInt32(p_cur->LTE_SignalStrength.cqi);
}

static void responseRilSignalStrengthV10(Parcel &p, RIL_SignalStrength_v10 *p_cur) {
    responseRilSignalStrengthV5(p, p_cur);
    responseRilSignalStrengthV6Extra(p, p_cur);
    p.writeInt32(p_cur->TD_SCDMA_SignalStrength.rscp);
}

static int responseRilSignalStrength(Parcel &p,
                    void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_SignalStrength_v10 *p_cur;
    if (s_callbacks.version <= LAST_IMPRECISE_RIL_VERSION) {
        if (responselen >= sizeof (RIL_SignalStrength_v5)) {
            p_cur = ((RIL_SignalStrength_v10 *) response);

            responseRilSignalStrengthV5(p, p_cur);

            if (responselen >= sizeof (RIL_SignalStrength_v6)) {
                responseRilSignalStrengthV6Extra(p, p_cur);
                if (responselen >= sizeof (RIL_SignalStrength_v10)) {
                    p.writeInt32(p_cur->TD_SCDMA_SignalStrength.rscp);
                } else {
                    p.writeInt32(INT_MAX);
                }
            } else {
                p.writeInt32(99);
                p.writeInt32(INT_MAX);
                p.writeInt32(INT_MAX);
                p.writeInt32(INT_MAX);
                p.writeInt32(INT_MAX);
                p.writeInt32(INT_MAX);
            }
        } else {
            RLOGE("invalid response length");
            return RIL_ERRNO_INVALID_RESPONSE;
        }
    } else { // RIL version >= 13
        if (responselen % sizeof(RIL_SignalStrength_v10) != 0) {
            RLOGE("Data structure expected is RIL_SignalStrength_v10");
            if (!isDebuggable()) {
                return RIL_ERRNO_INVALID_RESPONSE;
            } else {
                assert(0);
            }
        }
        p_cur = ((RIL_SignalStrength_v10 *) response);
        responseRilSignalStrengthV10(p, p_cur);
    }
    startResponse;
    appendPrintBuf("%s[signalStrength=%d,bitErrorRate=%d,\
            CDMA_SS.dbm=%d,CDMA_SSecio=%d,\
            EVDO_SS.dbm=%d,EVDO_SS.ecio=%d,\
            EVDO_SS.signalNoiseRatio=%d,\
            LTE_SS.signalStrength=%d,LTE_SS.rsrp=%d,LTE_SS.rsrq=%d,\
            LTE_SS.rssnr=%d,LTE_SS.cqi=%d,TDSCDMA_SS.rscp=%d]",
            printBuf,
            p_cur->GW_SignalStrength.signalStrength,
            p_cur->GW_SignalStrength.bitErrorRate,
            p_cur->CDMA_SignalStrength.dbm,
            p_cur->CDMA_SignalStrength.ecio,
            p_cur->EVDO_SignalStrength.dbm,
            p_cur->EVDO_SignalStrength.ecio,
            p_cur->EVDO_SignalStrength.signalNoiseRatio,
            p_cur->LTE_SignalStrength.signalStrength,
            p_cur->LTE_SignalStrength.rsrp,
            p_cur->LTE_SignalStrength.rsrq,
            p_cur->LTE_SignalStrength.rssnr,
            p_cur->LTE_SignalStrength.cqi,
            p_cur->TD_SCDMA_SignalStrength.rscp);
    closeResponse;
    return 0;
}

static int responseCallRing(Parcel &p, void *response, size_t responselen) {
    if ((response == NULL) || (responselen == 0)) {
        return responseVoid(p, response, responselen);
    } else {
        return responseCdmaSignalInfoRecord(p, response, responselen);
    }
}

static int responseCdmaSignalInfoRecord(Parcel &p, void *response, size_t responselen) {
    if (response == NULL || responselen == 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof (RIL_CDMA_SignalInfoRecord)) {
        RLOGE("invalid response length %d expected sizeof (RIL_CDMA_SignalInfoRecord) of %d\n",
            (int)responselen, (int)sizeof (RIL_CDMA_SignalInfoRecord));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;

    RIL_CDMA_SignalInfoRecord *p_cur = ((RIL_CDMA_SignalInfoRecord *) response);
    marshallSignalInfoRecord(p, *p_cur);

    appendPrintBuf("%s[isPresent=%d,signalType=%d,alertPitch=%d\
              signal=%d]",
              printBuf,
              p_cur->isPresent,
              p_cur->signalType,
              p_cur->alertPitch,
              p_cur->signal);

    closeResponse;
    return 0;
}

static int responseCdmaCallWaiting(Parcel &p, void *response,
            size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen < sizeof(RIL_CDMA_CallWaiting_v6)) {
        RLOGW("Upgrade to ril version %d\n", RIL_VERSION);
    }

    RIL_CDMA_CallWaiting_v6 *p_cur = ((RIL_CDMA_CallWaiting_v6 *) response);

    writeStringToParcel(p, p_cur->number);
    p.writeInt32(p_cur->numberPresentation);
    writeStringToParcel(p, p_cur->name);
    marshallSignalInfoRecord(p, p_cur->signalInfoRecord);

    if (s_callbacks.version <= LAST_IMPRECISE_RIL_VERSION) {
        if (responselen >= sizeof(RIL_CDMA_CallWaiting_v6)) {
            p.writeInt32(p_cur->number_type);
            p.writeInt32(p_cur->number_plan);
        } else {
            p.writeInt32(0);
            p.writeInt32(0);
        }
    } else { // RIL version >= 13
        if (responselen % sizeof(RIL_CDMA_CallWaiting_v6) != 0) {
            RLOGE("Data structure expected is RIL_CDMA_CallWaiting_v6");
            if (!isDebuggable()) {
                return RIL_ERRNO_INVALID_RESPONSE;
            } else {
                assert(0);
            }
        }
        p.writeInt32(p_cur->number_type);
        p.writeInt32(p_cur->number_plan);
    }

    startResponse;
    appendPrintBuf("%snumber=%s,numberPresentation=%d, name=%s,\
            signalInfoRecord[isPresent=%d,signalType=%d,alertPitch=%d\
            signal=%d,number_type=%d,number_plan=%d]",
            printBuf,
            p_cur->number,
            p_cur->numberPresentation,
            p_cur->name,
            p_cur->signalInfoRecord.isPresent,
            p_cur->signalInfoRecord.signalType,
            p_cur->signalInfoRecord.alertPitch,
            p_cur->signalInfoRecord.signal,
            p_cur->number_type,
            p_cur->number_plan);
    closeResponse;

    return 0;
}

static void responseSimRefreshV7(Parcel &p, void *response) {
      RIL_SimRefreshResponse_v7 *p_cur = ((RIL_SimRefreshResponse_v7 *) response);
      p.writeInt32(p_cur->result);
      p.writeInt32(p_cur->ef_id);
      writeStringToParcel(p, p_cur->aid);

      appendPrintBuf("%sresult=%d, ef_id=%d, aid=%s",
            printBuf,
            p_cur->result,
            p_cur->ef_id,
            p_cur->aid);

}

static int responseSimRefresh(Parcel &p, void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("responseSimRefresh: invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;
    if (s_callbacks.version <= LAST_IMPRECISE_RIL_VERSION) {
        if (s_callbacks.version >= 7) {
            responseSimRefreshV7(p, response);
        } else {
            int *p_cur = ((int *) response);
            p.writeInt32(p_cur[0]);
            p.writeInt32(p_cur[1]);
            writeStringToParcel(p, NULL);

            appendPrintBuf("%sresult=%d, ef_id=%d",
                    printBuf,
                    p_cur[0],
                    p_cur[1]);
        }
    } else { // RIL version >= 13
        if (responselen % sizeof(RIL_SimRefreshResponse_v7) != 0) {
            RLOGE("Data structure expected is RIL_SimRefreshResponse_v7");
            if (!isDebuggable()) {
                return RIL_ERRNO_INVALID_RESPONSE;
            } else {
                assert(0);
            }
        }
        responseSimRefreshV7(p, response);

    }
    closeResponse;

    return 0;
}

static int responseCellInfoListV6(Parcel &p, void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_CellInfo) != 0) {
        RLOGE("responseCellInfoList: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_CellInfo));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    int num = responselen / sizeof(RIL_CellInfo);
    p.writeInt32(num);

    RIL_CellInfo *p_cur = (RIL_CellInfo *) response;
    startResponse;
    int i;
    for (i = 0; i < num; i++) {
        p.writeInt32((int)p_cur->cellInfoType);
        p.writeInt32(p_cur->registered);
        p.writeInt32(p_cur->timeStampType);
        p.writeInt64(p_cur->timeStamp);
        switch(p_cur->cellInfoType) {
            case RIL_CELL_INFO_TYPE_GSM: {
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.mcc);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.mnc);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.lac);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.cid);
                p.writeInt32(p_cur->CellInfo.gsm.signalStrengthGsm.signalStrength);
                p.writeInt32(p_cur->CellInfo.gsm.signalStrengthGsm.bitErrorRate);
                break;
            }
            case RIL_CELL_INFO_TYPE_WCDMA: {
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.mcc);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.mnc);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.lac);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.cid);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.psc);
                p.writeInt32(p_cur->CellInfo.wcdma.signalStrengthWcdma.signalStrength);
                p.writeInt32(p_cur->CellInfo.wcdma.signalStrengthWcdma.bitErrorRate);
                break;
            }
            case RIL_CELL_INFO_TYPE_CDMA: {
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.networkId);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.systemId);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.basestationId);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.longitude);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.latitude);

                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthCdma.dbm);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthCdma.ecio);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.dbm);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.ecio);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.signalNoiseRatio);
                break;
            }
            case RIL_CELL_INFO_TYPE_LTE: {
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.mcc);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.mnc);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.ci);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.pci);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.tac);

                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.signalStrength);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rsrp);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rsrq);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rssnr);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.cqi);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.timingAdvance);
                break;
            }
            case RIL_CELL_INFO_TYPE_TD_SCDMA: {
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mcc);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mnc);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.lac);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cid);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cpid);
                p.writeInt32(p_cur->CellInfo.tdscdma.signalStrengthTdscdma.rscp);
                break;
            }
        }
        p_cur += 1;
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static int responseCellInfoListV12(Parcel &p, void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_CellInfo_v12) != 0) {
        RLOGE("responseCellInfoList: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_CellInfo_v12));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    int num = responselen / sizeof(RIL_CellInfo_v12);
    p.writeInt32(num);

    RIL_CellInfo_v12 *p_cur = (RIL_CellInfo_v12 *) response;
    startResponse;
    int i;
    for (i = 0; i < num; i++) {
        p.writeInt32((int)p_cur->cellInfoType);
        p.writeInt32(p_cur->registered);
        p.writeInt32(p_cur->timeStampType);
        p.writeInt64(p_cur->timeStamp);
        switch(p_cur->cellInfoType) {
            case RIL_CELL_INFO_TYPE_GSM: {
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.mcc);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.mnc);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.lac);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.cid);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.arfcn);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.bsic);
                p.writeInt32(p_cur->CellInfo.gsm.signalStrengthGsm.signalStrength);
                p.writeInt32(p_cur->CellInfo.gsm.signalStrengthGsm.bitErrorRate);
                p.writeInt32(p_cur->CellInfo.gsm.signalStrengthGsm.timingAdvance);
                break;
            }
            case RIL_CELL_INFO_TYPE_WCDMA: {
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.mcc);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.mnc);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.lac);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.cid);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.psc);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.uarfcn);
                p.writeInt32(p_cur->CellInfo.wcdma.signalStrengthWcdma.signalStrength);
                p.writeInt32(p_cur->CellInfo.wcdma.signalStrengthWcdma.bitErrorRate);
                break;
            }
            case RIL_CELL_INFO_TYPE_CDMA: {
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.networkId);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.systemId);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.basestationId);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.longitude);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.latitude);

                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthCdma.dbm);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthCdma.ecio);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.dbm);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.ecio);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.signalNoiseRatio);
                break;
            }
            case RIL_CELL_INFO_TYPE_LTE: {
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.mcc);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.mnc);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.ci);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.pci);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.tac);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.earfcn);

                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.signalStrength);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rsrp);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rsrq);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rssnr);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.cqi);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.timingAdvance);
                break;
            }
            case RIL_CELL_INFO_TYPE_TD_SCDMA: {
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mcc);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mnc);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.lac);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cid);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cpid);
                p.writeInt32(p_cur->CellInfo.tdscdma.signalStrengthTdscdma.rscp);
                break;
            }
        }
        p_cur += 1;
    }
    removeLastChar;
    closeResponse;
    return 0;
}

static int responseCellInfoList(Parcel &p, void *response, size_t responselen)
{
    if (s_callbacks.version <= LAST_IMPRECISE_RIL_VERSION) {
        if (s_callbacks.version < 12) {
            RLOGD("responseCellInfoList: v6");
            return responseCellInfoListV6(p, response, responselen);
        } else {
            RLOGD("responseCellInfoList: v12");
            return responseCellInfoListV12(p, response, responselen);
        }
    } else { // RIL version >= 13
        if (responselen % sizeof(RIL_CellInfo_v12) != 0) {
            RLOGE("Data structure expected is RIL_CellInfo_v12");
            if (!isDebuggable()) {
                return RIL_ERRNO_INVALID_RESPONSE;
            } else {
                assert(0);
            }
        }
        return responseCellInfoListV12(p, response, responselen);
    }

    return 0;
}

static int responseHardwareConfig(Parcel &p, void *response, size_t responselen)
{
   if (response == NULL && responselen != 0) {
       RLOGE("invalid response: NULL");
       return RIL_ERRNO_INVALID_RESPONSE;
   }

   if (responselen % sizeof(RIL_HardwareConfig) != 0) {
       RLOGE("responseHardwareConfig: invalid response length %d expected multiple of %d",
          (int)responselen, (int)sizeof(RIL_HardwareConfig));
       return RIL_ERRNO_INVALID_RESPONSE;
   }

   int num = responselen / sizeof(RIL_HardwareConfig);
   int i;
   RIL_HardwareConfig *p_cur = (RIL_HardwareConfig *) response;

   p.writeInt32(num);

   startResponse;
   for (i = 0; i < num; i++) {
      switch (p_cur[i].type) {
         case RIL_HARDWARE_CONFIG_MODEM: {
            p.writeInt32(p_cur[i].type);
            writeStringToParcel(p, p_cur[i].uuid);
            p.writeInt32((int)p_cur[i].state);
            p.writeInt32(p_cur[i].cfg.modem.rilModel);
            p.writeInt32(p_cur[i].cfg.modem.rat);
            p.writeInt32(p_cur[i].cfg.modem.maxVoice);
            p.writeInt32(p_cur[i].cfg.modem.maxData);
            p.writeInt32(p_cur[i].cfg.modem.maxStandby);

            appendPrintBuf("%s modem: uuid=%s,state=%d,rat=%08x,maxV=%d,maxD=%d,maxS=%d", printBuf,
               p_cur[i].uuid, (int)p_cur[i].state, p_cur[i].cfg.modem.rat,
               p_cur[i].cfg.modem.maxVoice, p_cur[i].cfg.modem.maxData, p_cur[i].cfg.modem.maxStandby);
            break;
         }
         case RIL_HARDWARE_CONFIG_SIM: {
            p.writeInt32(p_cur[i].type);
            writeStringToParcel(p, p_cur[i].uuid);
            p.writeInt32((int)p_cur[i].state);
            writeStringToParcel(p, p_cur[i].cfg.sim.modemUuid);

            appendPrintBuf("%s sim: uuid=%s,state=%d,modem-uuid=%s", printBuf,
               p_cur[i].uuid, (int)p_cur[i].state, p_cur[i].cfg.sim.modemUuid);
            break;
         }
      }
   }
   removeLastChar;
   closeResponse;
   return 0;
}

static int responseRadioCapability(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof (RIL_RadioCapability) ) {
        RLOGE("invalid response length was %d expected %d",
                (int)responselen, (int)sizeof (RIL_SIM_IO_Response));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_RadioCapability *p_cur = (RIL_RadioCapability *) response;
    p.writeInt32(p_cur->version);
    p.writeInt32(p_cur->session);
    p.writeInt32(p_cur->phase);
    p.writeInt32(p_cur->rat);
    writeStringToParcel(p, p_cur->logicalModemUuid);
    p.writeInt32(p_cur->status);

    startResponse;
    appendPrintBuf("%s[version=%d,session=%d,phase=%d,\
            rat=%s,logicalModemUuid=%s,status=%d]",
            printBuf,
            p_cur->version,
            p_cur->session,
            p_cur->phase,
            p_cur->rat,
            p_cur->logicalModemUuid,
            p_cur->status);
    closeResponse;
    return 0;
}

static int responseSSData(Parcel &p, void *response, size_t responselen) {
    RLOGD("In responseSSData");
    int num;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response length was %d expected %d",
                (int)responselen, (int)sizeof (RIL_SIM_IO_Response));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof(RIL_StkCcUnsolSsResponse)) {
        RLOGE("invalid response length %d, expected %d",
               (int)responselen, (int)sizeof(RIL_StkCcUnsolSsResponse));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;
    RIL_StkCcUnsolSsResponse *p_cur = (RIL_StkCcUnsolSsResponse *) response;
    p.writeInt32(p_cur->serviceType);
    p.writeInt32(p_cur->requestType);
    p.writeInt32(p_cur->teleserviceType);
    p.writeInt32(p_cur->serviceClass);
    p.writeInt32(p_cur->result);

    if (isServiceTypeCfQuery(p_cur->serviceType, p_cur->requestType)) {
        RLOGD("responseSSData CF type, num of Cf elements %d", p_cur->cfData.numValidIndexes);
        if (p_cur->cfData.numValidIndexes > NUM_SERVICE_CLASSES) {
            RLOGE("numValidIndexes is greater than max value %d, "
                  "truncating it to max value", NUM_SERVICE_CLASSES);
            p_cur->cfData.numValidIndexes = NUM_SERVICE_CLASSES;
        }
        /* number of call info's */
        p.writeInt32(p_cur->cfData.numValidIndexes);

        for (int i = 0; i < p_cur->cfData.numValidIndexes; i++) {
             RIL_CallForwardInfo cf = p_cur->cfData.cfInfo[i];

             p.writeInt32(cf.status);
             p.writeInt32(cf.reason);
             p.writeInt32(cf.serviceClass);
             p.writeInt32(cf.toa);
             writeStringToParcel(p, cf.number);
             p.writeInt32(cf.timeSeconds);
             appendPrintBuf("%s[%s,reason=%d,cls=%d,toa=%d,%s,tout=%d],", printBuf,
                 (cf.status==1)?"enable":"disable", cf.reason, cf.serviceClass, cf.toa,
                  (char*)cf.number, cf.timeSeconds);
             RLOGD("Data: %d,reason=%d,cls=%d,toa=%d,num=%s,tout=%d],", cf.status,
                  cf.reason, cf.serviceClass, cf.toa, (char*)cf.number, cf.timeSeconds);
        }
    } else {
        p.writeInt32 (SS_INFO_MAX);

        /* each int*/
        for (int i = 0; i < SS_INFO_MAX; i++) {
             appendPrintBuf("%s%d,", printBuf, p_cur->ssInfo[i]);
             RLOGD("Data: %d",p_cur->ssInfo[i]);
             p.writeInt32(p_cur->ssInfo[i]);
        }
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static bool isServiceTypeCfQuery(RIL_SsServiceType serType, RIL_SsRequestType reqType) {
    if ((reqType == SS_INTERROGATION) &&
        (serType == SS_CFU ||
         serType == SS_CF_BUSY ||
         serType == SS_CF_NO_REPLY ||
         serType == SS_CF_NOT_REACHABLE ||
         serType == SS_CF_ALL ||
         serType == SS_CF_ALL_CONDITIONAL)) {
        return true;
    }
    return false;
}

static void triggerEvLoop() {
    int ret;
    if (!pthread_equal(pthread_self(), s_tid_dispatch)) {
        /* trigger event loop to wakeup. No reason to do this,
         * if we're in the event loop thread */
         do {
            ret = write (s_fdWakeupWrite, " ", 1);
         } while (ret < 0 && errno == EINTR);
    }
}

static void rilEventAddWakeup(struct ril_event *ev) {
    ril_event_add(ev);
    triggerEvLoop();
}

static void sendSimStatusAppInfo(Parcel &p, int num_apps, RIL_AppStatus appStatus[]) {
        p.writeInt32(num_apps);
        startResponse;
        for (int i = 0; i < num_apps; i++) {
            p.writeInt32(appStatus[i].app_type);
            p.writeInt32(appStatus[i].app_state);
            p.writeInt32(appStatus[i].perso_substate);
            writeStringToParcel(p, (const char*)(appStatus[i].aid_ptr));
            writeStringToParcel(p, (const char*)
                                          (appStatus[i].app_label_ptr));
            p.writeInt32(appStatus[i].pin1_replaced);
            p.writeInt32(appStatus[i].pin1);
            p.writeInt32(appStatus[i].pin2);
            appendPrintBuf("%s[app_type=%d,app_state=%d,perso_substate=%d,\
                    aid_ptr=%s,app_label_ptr=%s,pin1_replaced=%d,pin1=%d,pin2=%d],",
                    printBuf,
                    appStatus[i].app_type,
                    appStatus[i].app_state,
                    appStatus[i].perso_substate,
                    appStatus[i].aid_ptr,
                    appStatus[i].app_label_ptr,
                    appStatus[i].pin1_replaced,
                    appStatus[i].pin1,
                    appStatus[i].pin2);
        }
        closeResponse;
}

static void responseSimStatusV5(Parcel &p, void *response) {
    RIL_CardStatus_v5 *p_cur = ((RIL_CardStatus_v5 *) response);

    p.writeInt32(p_cur->card_state);
    p.writeInt32(p_cur->universal_pin_state);
    p.writeInt32(p_cur->gsm_umts_subscription_app_index);
    p.writeInt32(p_cur->cdma_subscription_app_index);

    sendSimStatusAppInfo(p, p_cur->num_applications, p_cur->applications);
}

static void responseSimStatusV6(Parcel &p, void *response) {
    RIL_CardStatus_v6 *p_cur = ((RIL_CardStatus_v6 *) response);

    p.writeInt32(p_cur->card_state);
    p.writeInt32(p_cur->universal_pin_state);
    p.writeInt32(p_cur->gsm_umts_subscription_app_index);
    p.writeInt32(p_cur->cdma_subscription_app_index);
    p.writeInt32(p_cur->ims_subscription_app_index);

    sendSimStatusAppInfo(p, p_cur->num_applications, p_cur->applications);
}

static void responseSimStatusV7(Parcel &p, void *response) {
    RIL_CardStatus_v7 *p_cur = ((RIL_CardStatus_v7 *) response);

    p.writeInt32(p_cur->card_state);
    p.writeInt32(p_cur->universal_pin_state);
    p.writeInt32(p_cur->gsm_umts_subscription_app_index);
    p.writeInt32(p_cur->cdma_subscription_app_index);
    p.writeInt32(p_cur->ims_subscription_app_index);

    sendSimStatusAppInfo(p, p_cur->num_applications, p_cur->applications);
    p.writeInt32(p_cur->physicalSlotId);
    writeStringToParcel(p, (const char *)p_cur->atr);
    writeStringToParcel(p, (const char *)p_cur->iccId);
}

static int responseSimStatus(Parcel &p, void *response, size_t responselen) {
    int i;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (s_callbacks.version <= LAST_IMPRECISE_RIL_VERSION) {
        if (responselen == sizeof (RIL_CardStatus_v6)) {
            responseSimStatusV6(p, response);
        } else if (responselen == sizeof (RIL_CardStatus_v5)) {
            responseSimStatusV5(p, response);
        } else {
            RLOGE("responseSimStatus: A RilCardStatus_v6 or _v5 expected\n");
            return RIL_ERRNO_INVALID_RESPONSE;
        }
    } else { // RIL version >= 13
        if (responselen == sizeof(RIL_CardStatus_v6)) {
            responseSimStatusV6(p, response);
        } else if(responselen == sizeof(RIL_CardStatus_v7)) {
            responseSimStatusV7(p, response);
        } else {
            RLOGE("Data structure expected is RIL_CardStatus_v7 or v6");
            if (!isDebuggable()) {
                return RIL_ERRNO_INVALID_RESPONSE;
            } else {
                assert(0);
            }
        }
    }

    return 0;
}

static int responseGsmBrSmsCnf(Parcel &p, void *response, size_t responselen) {
    int num = responselen / sizeof(RIL_GSM_BroadcastSmsConfigInfo *);
    p.writeInt32(num);

    startResponse;
    RIL_GSM_BroadcastSmsConfigInfo **p_cur =
                (RIL_GSM_BroadcastSmsConfigInfo **) response;
    for (int i = 0; i < num; i++) {
        p.writeInt32(p_cur[i]->fromServiceId);
        p.writeInt32(p_cur[i]->toServiceId);
        p.writeInt32(p_cur[i]->fromCodeScheme);
        p.writeInt32(p_cur[i]->toCodeScheme);
        p.writeInt32(p_cur[i]->selected);

        appendPrintBuf("%s [%d: fromServiceId=%d, toServiceId=%d, \
                fromCodeScheme=%d, toCodeScheme=%d, selected =%d]",
                printBuf, i, p_cur[i]->fromServiceId, p_cur[i]->toServiceId,
                p_cur[i]->fromCodeScheme, p_cur[i]->toCodeScheme,
                p_cur[i]->selected);
    }
    closeResponse;

    return 0;
}

static int responseCdmaBrSmsCnf(Parcel &p, void *response, size_t responselen) {
    RIL_CDMA_BroadcastSmsConfigInfo **p_cur =
               (RIL_CDMA_BroadcastSmsConfigInfo **) response;

    int num = responselen / sizeof (RIL_CDMA_BroadcastSmsConfigInfo *);
    p.writeInt32(num);

    startResponse;
    for (int i = 0 ; i < num ; i++ ) {
        p.writeInt32(p_cur[i]->service_category);
        p.writeInt32(p_cur[i]->language);
        p.writeInt32(p_cur[i]->selected);

        appendPrintBuf("%s [%d: srvice_category=%d, language =%d, \
              selected =%d], ",
              printBuf, i, p_cur[i]->service_category, p_cur[i]->language,
              p_cur[i]->selected);
    }
    closeResponse;

    return 0;
}

static int responseCdmaSms(Parcel &p, void *response, size_t responselen) {
    int num;
    int digitCount;
    int digitLimit;
    uint8_t uct;
    void* dest;

    RLOGD("Inside responseCdmaSms");

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof(RIL_CDMA_SMS_Message)) {
        RLOGE("invalid response length was %d expected %d",
                (int)responselen, (int)sizeof(RIL_CDMA_SMS_Message));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_CDMA_SMS_Message *p_cur = (RIL_CDMA_SMS_Message *) response;
    p.writeInt32(p_cur->uTeleserviceID);
    p.write(&(p_cur->bIsServicePresent),sizeof(uct));
    p.writeInt32(p_cur->uServicecategory);
    p.writeInt32(p_cur->sAddress.digit_mode);
    p.writeInt32(p_cur->sAddress.number_mode);
    p.writeInt32(p_cur->sAddress.number_type);
    p.writeInt32(p_cur->sAddress.number_plan);
    p.write(&(p_cur->sAddress.number_of_digits), sizeof(uct));
    digitLimit= MIN((p_cur->sAddress.number_of_digits), RIL_CDMA_SMS_ADDRESS_MAX);
    for(digitCount =0 ; digitCount < digitLimit; digitCount ++) {
        p.write(&(p_cur->sAddress.digits[digitCount]),sizeof(uct));
    }

    p.writeInt32(p_cur->sSubAddress.subaddressType);
    p.write(&(p_cur->sSubAddress.odd),sizeof(uct));
    p.write(&(p_cur->sSubAddress.number_of_digits),sizeof(uct));
    digitLimit= MIN((p_cur->sSubAddress.number_of_digits), RIL_CDMA_SMS_SUBADDRESS_MAX);
    for(digitCount =0 ; digitCount < digitLimit; digitCount ++) {
        p.write(&(p_cur->sSubAddress.digits[digitCount]),sizeof(uct));
    }

    digitLimit= MIN((p_cur->uBearerDataLen), RIL_CDMA_SMS_BEARER_DATA_MAX);
    p.writeInt32(p_cur->uBearerDataLen);
    for(digitCount =0 ; digitCount < digitLimit; digitCount ++) {
       p.write(&(p_cur->aBearerData[digitCount]), sizeof(uct));
    }

    startResponse;
    appendPrintBuf("%suTeleserviceID=%d, bIsServicePresent=%d, uServicecategory=%d, \
            sAddress.digit_mode=%d, sAddress.number_mode=%d, sAddress.number_type=%d, ",
            printBuf, p_cur->uTeleserviceID,p_cur->bIsServicePresent,p_cur->uServicecategory,
            p_cur->sAddress.digit_mode, p_cur->sAddress.number_mode,p_cur->sAddress.number_type);
    closeResponse;

    return 0;
}

static int responseGetSmsSimMemStatusCnf(Parcel &p,void *response, size_t responselen)
{
    if (response == NULL || responselen == 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof (RIL_SMS_Memory_Status)) {
        RLOGE("invalid response length %d expected sizeof (RIL_SMS_Memory_Status) of %d\n",
             (int)responselen, (int)sizeof(RIL_SMS_Memory_Status));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;

    RIL_SMS_Memory_Status *mem_status = (RIL_SMS_Memory_Status*)response;

    p.writeInt32(mem_status->used);
    p.writeInt32(mem_status->total);

    appendPrintBuf("%s [used = %d, total = %d]", printBuf, mem_status->used, mem_status->total);

    closeResponse;

    return 0;
}


static int responseEtwsNotification(Parcel &p, void *response, size_t responselen) {
    if(NULL == response) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if(responselen != sizeof(RIL_CBEtwsNotification)) {
        RLOGE("invalid response length %d expected %d",
            responselen, sizeof(RIL_CBEtwsNotification));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_CBEtwsNotification *p_cur = (RIL_CBEtwsNotification *)response;
    p.writeInt32(p_cur->warningType);
    p.writeInt32(p_cur->messageId);
    p.writeInt32(p_cur->serialNumber);
    writeStringToParcel(p, p_cur->plmnId);
    writeStringToParcel(p, p_cur->securityInfo);

    startResponse;
    appendPrintBuf("%s%d,%d,%d,%s,%s", printBuf, p_cur->waringType, p_cur->messageId,
                   p_cur->serialNumber, p_cur->plmnId, p_cur->securityInfo);
    closeResponse;

    return 0;
}

static int responseDcRtInfo(Parcel &p, void *response, size_t responselen)
{
    int num = responselen / sizeof(RIL_DcRtInfo);
    if ((responselen % sizeof(RIL_DcRtInfo) != 0) || (num != 1)) {
        RLOGE("responseDcRtInfo: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_DcRtInfo));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;
    RIL_DcRtInfo *pDcRtInfo = (RIL_DcRtInfo *)response;
    p.writeInt64(pDcRtInfo->time);
    p.writeInt32(pDcRtInfo->powerState);
    appendPrintBuf("%s[time=%d,powerState=%d]", printBuf,
        pDcRtInfo->time,
        pDcRtInfo->powerState);
    closeResponse;

    return 0;
}

static int responseLceStatus(Parcel &p, void *response, size_t responselen) {
  if (response == NULL || responselen != sizeof(RIL_LceStatusInfo)) {
    if (response == NULL) {
      RLOGE("invalid response: NULL");
    }
    else {
      RLOGE("responseLceStatus: invalid response length %u expecting len: %u",
            (unsigned)sizeof(RIL_LceStatusInfo), (unsigned)responselen);
    }
    return RIL_ERRNO_INVALID_RESPONSE;
  }

  RIL_LceStatusInfo *p_cur = (RIL_LceStatusInfo *)response;
  p.write((void *)p_cur, 1);  // p_cur->lce_status takes one byte.
  p.writeInt32(p_cur->actual_interval_ms);

  startResponse;
  appendPrintBuf("LCE Status: %d, actual_interval_ms: %d",
                 p_cur->lce_status, p_cur->actual_interval_ms);
  closeResponse;

  return 0;
}

static int responseLceData(Parcel &p, void *response, size_t responselen) {
  if (response == NULL || responselen != sizeof(RIL_LceDataInfo)) {
    if (response == NULL) {
      RLOGE("invalid response: NULL");
    }
    else {
      RLOGE("responseLceData: invalid response length %u expecting len: %u",
            (unsigned)sizeof(RIL_LceDataInfo), (unsigned)responselen);
    }
    return RIL_ERRNO_INVALID_RESPONSE;
  }

  RIL_LceDataInfo *p_cur = (RIL_LceDataInfo *)response;
  p.writeInt32(p_cur->last_hop_capacity_kbps);

  /* p_cur->confidence_level and p_cur->lce_suspended take 1 byte each.*/
  p.write((void *)&(p_cur->confidence_level), 1);
  p.write((void *)&(p_cur->lce_suspended), 1);

  startResponse;
  appendPrintBuf("LCE info received: capacity %d confidence level %d \
                  and suspended %d",
                  p_cur->last_hop_capacity_kbps, p_cur->confidence_level,
                  p_cur->lce_suspended);
  closeResponse;

  return 0;
}

static int responseActivityData(Parcel &p, void *response, size_t responselen) {
  if (response == NULL || responselen != sizeof(RIL_ActivityStatsInfo)) {
    if (response == NULL) {
      RLOGE("invalid response: NULL");
    }
    else {
      RLOGE("responseActivityData: invalid response length %u expecting len: %u",
            (unsigned)sizeof(RIL_ActivityStatsInfo), (unsigned)responselen);
    }
    return RIL_ERRNO_INVALID_RESPONSE;
  }

  RIL_ActivityStatsInfo *p_cur = (RIL_ActivityStatsInfo *)response;
  p.writeInt32(p_cur->sleep_mode_time_ms);
  p.writeInt32(p_cur->idle_mode_time_ms);
  for(int i = 0; i < RIL_NUM_TX_POWER_LEVELS; i++) {
    p.writeInt32(p_cur->tx_mode_time_ms[i]);
  }
  p.writeInt32(p_cur->rx_mode_time_ms);

  startResponse;
  appendPrintBuf("Modem activity info received: sleep_mode_time_ms %d idle_mode_time_ms %d \
                  tx_mode_time_ms %d %d %d %d %d and rx_mode_time_ms %d",
                  p_cur->sleep_mode_time_ms, p_cur->idle_mode_time_ms, p_cur->tx_mode_time_ms[0],
                  p_cur->tx_mode_time_ms[1], p_cur->tx_mode_time_ms[2], p_cur->tx_mode_time_ms[3],
                  p_cur->tx_mode_time_ms[4], p_cur->rx_mode_time_ms);
   closeResponse;

  return 0;
}

static int responseCarrierRestrictions(Parcel &p, void *response, size_t responselen) {
  if (response == NULL) {
    RLOGE("invalid response: NULL");
    return RIL_ERRNO_INVALID_RESPONSE;
  }
  if (responselen != sizeof(RIL_CarrierRestrictions)) {
    RLOGE("responseCarrierRestrictions: invalid response length %u expecting len: %u",
          (unsigned)responselen, (unsigned)sizeof(RIL_CarrierRestrictions));
    return RIL_ERRNO_INVALID_RESPONSE;
  }

  RIL_CarrierRestrictions *p_cr = (RIL_CarrierRestrictions *)response;
  startResponse;

  p.writeInt32(p_cr->len_allowed_carriers);
  p.writeInt32(p_cr->len_excluded_carriers);
  appendPrintBuf(" %s len_allowed_carriers: %d, len_excluded_carriers: %d,", printBuf,
                 p_cr->len_allowed_carriers,p_cr->len_excluded_carriers);

  appendPrintBuf(" %s allowed_carriers:", printBuf);
  for(int32_t i = 0; i < p_cr->len_allowed_carriers; i++) {
    RIL_Carrier *carrier = p_cr->allowed_carriers + i;
    writeStringToParcel(p, carrier->mcc);
    writeStringToParcel(p, carrier->mnc);
    p.writeInt32(carrier->match_type);
    writeStringToParcel(p, carrier->match_data);
    appendPrintBuf(" %s [%d mcc: %s, mnc: %s, match_type: %d, match_data: %s],", printBuf,
                   i, carrier->mcc, carrier->mnc, carrier->match_type, carrier->match_data);
  }

  appendPrintBuf(" %s excluded_carriers:", printBuf);
  for(int32_t i = 0; i < p_cr->len_excluded_carriers; i++) {
    RIL_Carrier *carrier = p_cr->excluded_carriers + i;
    writeStringToParcel(p, carrier->mcc);
    writeStringToParcel(p, carrier->mnc);
    p.writeInt32(carrier->match_type);
    writeStringToParcel(p, carrier->match_data);
    appendPrintBuf(" %s [%d mcc: %s, mnc: %s, match_type: %d, match_data: %s],", printBuf,
                   i, carrier->mcc, carrier->mnc, carrier->match_type, carrier->match_data);
  }

  closeResponse;

  return 0;
}

static int responsePcoData(Parcel &p, void *response, size_t responselen) {
  if (response == NULL) {
    RLOGE("responsePcoData: invalid NULL response");
    return RIL_ERRNO_INVALID_RESPONSE;
  }
  if (responselen != sizeof(RIL_PCO_Data)) {
    RLOGE("responsePcoData: invalid response length %u, expecting %u",
          (unsigned)responselen, (unsigned)sizeof(RIL_PCO_Data));
    return RIL_ERRNO_INVALID_RESPONSE;
  }

  RIL_PCO_Data *p_cur = (RIL_PCO_Data *)response;
  p.writeInt32(p_cur->cid);
  writeStringToParcel(p, p_cur->bearer_proto);
  p.writeInt32(p_cur->pco_id);
  p.writeInt32(p_cur->contents_length);
  p.write(p_cur->contents, p_cur->contents_length);

  startResponse;
      appendPrintBuf("PCO data received: cid %d, id %d, length %d",
                     p_cur->cid, p_cur->pco_id, p_cur->contents_length);
  closeResponse;

  return 0;
}

static int responseCrssN(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof(RIL_CrssNotification)) {
        RLOGE("invalid response length was %d expected %d",
             (int)responselen, (int)sizeof (RIL_CrssNotification));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_CrssNotification *p_cur = (RIL_CrssNotification *) response;
    p.writeInt32(p_cur->code);
    p.writeInt32(p_cur->type);
    writeStringToParcel(p, p_cur->number);
    writeStringToParcel(p, p_cur->alphaid);
    p.writeInt32(p_cur->cli_validity);
    return 0;
}

static int responsePhbEntries(Parcel &p,void *response, size_t responselen) {


    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof (RIL_PhbEntryStrucutre *) != 0) {
        RLOGE("invalid response length %d expected multiple of %d\n",
             (int)responselen, (int)sizeof (RIL_PhbEntryStrucutre *));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    int num = responselen / sizeof(RIL_PhbEntryStrucutre *);
    p.writeInt32(num);

    startResponse;
    RIL_PhbEntryStrucutre **p_cur =
        (RIL_PhbEntryStrucutre **) response;
    for (int i = 0; i < num; i++) {
        p.writeInt32(p_cur[i]->type);
        p.writeInt32(p_cur[i]->index);
        writeStringToParcel(p, p_cur[i]->number);
        p.writeInt32(p_cur[i]->ton);
        writeStringToParcel(p, p_cur[i]->alphaId);

        appendPrintBuf("%s [%d: type=%d, index=%d, \
                number=%s, ton=%d, alphaId =%s]",
                       printBuf, i, p_cur[i]->type, p_cur[i]->index,
                       p_cur[i]->number, p_cur[i]->ton,
                       p_cur[i]->alphaId);
    }
    closeResponse;

    return 0;

}

static int responseReadPhbEntryExt(Parcel &p,void *response, size_t responselen)
{
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }
    if (responselen % sizeof (RIL_PHB_ENTRY *) != 0) {
        RLOGE("invalid response length %d expected multiple of %d\n",
             (int)responselen, (int)sizeof (RIL_PHB_ENTRY *));
        return RIL_ERRNO_INVALID_RESPONSE;
    }
    int num = responselen / sizeof(RIL_PHB_ENTRY *);
    p.writeInt32(num);
    startResponse;
    RIL_PHB_ENTRY **p_cur =
        (RIL_PHB_ENTRY **) response;

    for (int i = 0; i < num; i++) {
        p.writeInt32(p_cur[i]->index);
        writeStringToParcel(p, p_cur[i]->number);
        p.writeInt32(p_cur[i]->type);
        writeStringToParcel(p, p_cur[i]->text);
        p.writeInt32(p_cur[i]->hidden);
        writeStringToParcel(p, p_cur[i]->group);
        writeStringToParcel(p, p_cur[i]->adnumber);
        p.writeInt32(p_cur[i]->adtype);
        writeStringToParcel(p, p_cur[i]->secondtext);
        writeStringToParcel(p, p_cur[i]->email);

        appendPrintBuf("%s [%d: index=%d, \
                number=%s, type=%d, text =%s, hidden=%d,group=%s,adnumber=%s,adtype=%d,sectext=%s,email=%s]",
                       printBuf, i,  p_cur[i]->index,
                       p_cur[i]->number, p_cur[i]->type,
                       p_cur[i]->text, p_cur[i]->hidden,p_cur[i]->group,p_cur[i]->adnumber,
                       p_cur[i]->adtype,p_cur[i]->secondtext,p_cur[i]->email);
    }

    closeResponse;

    return 0;

}

static int responseGetPhbMemStorage(Parcel &p,void *response, size_t responselen)
{
    if (response == NULL || responselen == 0) {
        RLOGE("responseGetPhbMemStorage invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }
    if (responselen != sizeof (RIL_PHB_MEM_STORAGE_RESPONSE)) {
        RLOGE("invalid response length %d expected sizeof (RIL_PHB_MEM_STORAGE_RESPONSE) of %d\n",
             (int)responselen, (int)sizeof(RIL_PHB_MEM_STORAGE_RESPONSE));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;

    RIL_PHB_MEM_STORAGE_RESPONSE *mem_status = (RIL_PHB_MEM_STORAGE_RESPONSE*)response;
    writeStringToParcel (p, mem_status->storage);
    p.writeInt32(mem_status->used);
    p.writeInt32(mem_status->total);

    appendPrintBuf("%s [storage = %s, used = %d, total = %d]", printBuf, mem_status->storage, mem_status->used, mem_status->total);

    closeResponse;
    return 0;
}

static int responseImsBearerNotify(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof(RIL_CrssNotification)) {
        RLOGE("invalid response length was %d expected %d",
             (int)responselen, (int)sizeof (RIL_IMS_BearerNotification));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_IMS_BearerNotification *p_cur = (RIL_IMS_BearerNotification *) response;
    p.writeInt32(p_cur->phone);
    p.writeInt32(p_cur->aid);
    writeStringToParcel(p, p_cur->type);
    return 0;
}

//MTK-START SMS
static void dispatchSmsParams(Parcel &p, RequestInfo *pRI) {
    RIL_SmsParams smsParams;
    int32_t t;
    status_t status;

    RLOGD("dispatchSmsParams Enter.");

    memset(&smsParams, 0, sizeof(smsParams));

    status = p.readInt32(&t);
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    smsParams.format = t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    smsParams.vp = t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    smsParams.pid = t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    smsParams.dcs = t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    RLOGD("dispatchSmsParams format: %d, vp: %d, pid: %d, dcs: %d", smsParams.format, smsParams.vp,
            smsParams.pid, smsParams.dcs);

    startRequest;
    appendPrintBuf("%sformat=%d,vp=%d,pid=%d,dcs=%d", printBuf,
            smsParams.format, smsParams.vp, smsParams.pid, smsParams.dcs);
    closeRequest;

    CALL_ONREQUEST(pRI->pCI->requestNumber, &smsParams, sizeof(smsParams), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memset(&smsParams, 0, sizeof(smsParams));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

static int responseSmsParams(Parcel &p, void *response, size_t responselen) {
    if(response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if(responselen != (int)sizeof(RIL_SmsParams)) {
        RLOGE("invalid response length %d expected %d",
             (int)responselen, (int)sizeof(RIL_SmsParams));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_SmsParams *p_cur = (RIL_SmsParams *)response;
    p.writeInt32(p_cur->format);
    p.writeInt32(p_cur->vp);
    p.writeInt32(p_cur->pid);
    p.writeInt32(p_cur->dcs);

    startResponse;
    appendPrintBuf("%s%d,%d,%d,%d", printBuf, p_cur->format, p_cur->vp,
                   p_cur->pid, p_cur->dcs);
    closeResponse;

    return 0;
}

//MTK-END SMS

// External SIM [Start]
static void dispatchVsimEvent(Parcel &p, RequestInfo *pRI) {
    RIL_VsimEvent args;
    int32_t t = 0;
    status_t status;

    memset (&args, 0, sizeof(args));

    // Transcation id
    status = p.readInt32(&t);
    args.transaction_id = (int) t;

    // Event id
    status = p.readInt32(&t);
    args.eventId = (int) t;

    // Sim type
    status = p.readInt32(&t);
    args.sim_type = (int) t;

    startRequest;
    appendPrintBuf("%scmd=0x%X,transaction_id=%d,eventId=%d,sim_type=%d", printBuf,
        args.transaction_id, args.eventId, args.sim_type);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }

    CALL_ONREQUEST(pRI->pCI->requestNumber, &args, sizeof(args), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchVsimOperationEvent(Parcel &p, RequestInfo *pRI) {
    RIL_VsimOperationEvent args;
    int32_t t = 0;
    status_t status;

    memset (&args, 0, sizeof(args));

    // Transcation id
    status = p.readInt32(&t);
    args.transaction_id = (int) t;

    // Event id
    status = p.readInt32(&t);
    args.eventId = (int) t;

    // Result
    status = p.readInt32(&t);
    args.result = (int) t;

    // Data length
    status = p.readInt32(&t);
    args.data_length = (int) t;

    // Data array
    args.data = (char *)strdupReadString(p);

    RLOGI ("[dispatchVsimOperationEvent]%d, %d, %d, %d, data:%s, response_addr:%p",
            args.transaction_id, args.eventId, args.result, args.data_length, args.data, &args);

    startRequest;
    appendPrintBuf("%scmd=0x%X,transaction_id=%d,eventId=%d,result=%d, data_len=%d, data=%s", printBuf,
        args.transaction_id, args.eventId, args.result, args.data_length, args.data);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }

    CALL_ONREQUEST(pRI->pCI->requestNumber, &args, sizeof(args), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static int responseVsimNotificationResponse(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof(RIL_VsimEvent)) {
        RLOGE("invalid response length was %d expected %d",
                        (int)responselen, (int)sizeof (RIL_VsimEvent));
                return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_VsimEvent *p_cur = ((RIL_VsimEvent *) response);
    p.writeInt32(p_cur->transaction_id);
    p.writeInt32(p_cur->eventId);
    p.writeInt32(p_cur->sim_type);

    startResponse;
    appendPrintBuf("%stransaction_id=%d,eventId=%d,simtype=%d", printBuf, p_cur->transaction_id,
            p_cur->eventId, p_cur->sim_type);
    closeResponse;

    return 0;
}

static int responseVsimOperationEvent(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof (RIL_VsimOperationEvent) ) {
        RLOGE("invalid response length was %d expected %d",
                (int)responselen, (int)sizeof (RIL_VsimOperationEvent));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_VsimOperationEvent *p_cur = (RIL_VsimOperationEvent *) response;
    p.writeInt32(p_cur->transaction_id);
    p.writeInt32(p_cur->eventId);
    p.writeInt32(p_cur->result);
    p.writeInt32(p_cur->data_length);
    writeStringToParcel(p, p_cur->data);

    startResponse;
    appendPrintBuf("%stransaction_id=%d,eventId=%d,datalen=%d", printBuf, p_cur->transaction_id,
            p_cur->eventId, p_cur->data_length);
    closeResponse;

    return 0;
}
// External SIM [Start]


/**
 * A write on the wakeup fd is done just to pop us out of select()
 * We empty the buffer here and then ril_event will reset the timers on the
 * way back down
 */
static void processWakeupCallback(int fd, short flags, void *param) {
    char buff[16];
    int ret;

    RLOGV("processWakeupCallback");

    /* empty our wakeup socket out */
    do {
        ret = read(s_fdWakeupRead, &buff, sizeof(buff));
    } while (ret > 0 || (ret < 0 && errno == EINTR));
}

static void onCommandsSocketClosed(RIL_SOCKET_ID socket_id, int clientId) {
    int ret;
    RequestInfo *p_cur;
    /* Hook for current context
       pendingRequestsMutextHook refer to &s_pendingRequestsMutex */
    pthread_mutex_t * pendingRequestsMutexHook = &s_pendingRequestsMutex;
    /* pendingRequestsHook refer to &s_pendingRequests */
    RequestInfo **    pendingRequestsHook = &s_pendingRequests;

    if (socket_id == RIL_SOCKET_2) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket2;
        pendingRequestsHook = &s_pendingRequests_socket2;
    }
    else if (socket_id == RIL_SOCKET_3) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket3;
        pendingRequestsHook = &s_pendingRequests_socket3;
    }
    else if (socket_id == RIL_SOCKET_4) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket4;
        pendingRequestsHook = &s_pendingRequests_socket4;
    }
    else if (socket_id == RIL_SOCKET_RILJ) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket_rilj;
        pendingRequestsHook = &s_pendingRequests_socket_rilj;
    }
    else if (socket_id == RIL_SOCKET_RILJ2) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket_rilj2;
        pendingRequestsHook = &s_pendingRequests_socket_rilj2;
    }

    if (clientId >= 0) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket_client[clientId];
        pendingRequestsHook = &s_pendingRequests_socket_client[clientId];
    }

    /// M: Hangup all if the socket is closed.
    issueLocalRequest(RIL_REQUEST_HANGUP_ALL, NULL, 0, socket_id);

    /* mark pending requests as "cancelled" so we dont report responses */
    ret = pthread_mutex_lock(pendingRequestsMutexHook);
    assert (ret == 0);

    p_cur = *pendingRequestsHook;

    for (p_cur = *pendingRequestsHook
            ; p_cur != NULL
            ; p_cur  = p_cur->p_next
    ) {
        p_cur->cancelled = 1;
    }

    ret = pthread_mutex_unlock(pendingRequestsMutexHook);
    assert (ret == 0);
}

static void processCommandsCallback(int fd, short flags, void *param) {
    RecordStream *p_rs;
    void *p_record;
    size_t recordlen;
    int ret;
    SocketListenParam *p_info = (SocketListenParam *)param;
    int slot_id = p_info->slot_id;
    int clientId_tmp = (true == isDsds())? ((p_info->clientId)/2) : (p_info->clientId);
    sem_t* sem;

    assert(fd == p_info->fdCommand);

    p_rs = p_info->p_rs;

    for (;;) {
        /* loop until EAGAIN/EINTR, end of stream, or other error */
        ret = record_stream_get_next(p_rs, &p_record, &recordlen);

        if (ret == 0 && p_record == NULL) {
            /* end-of-stream */
            break;
        } else if (ret < 0) {
            break;
        } else if (ret == 0) { /* && p_record != NULL */
            processCommandBuffer(p_record, recordlen, p_info->socket_id, p_info->clientId);
        }
    }

    if (ret == 0 || !(errno == EAGAIN || errno == EINTR)) {
        /* fatal error or end-of-stream */
        if (ret != 0) {
            RLOGE("rild error on reading command socket errno:%d\n", errno);
        } else {
            RLOGW("EOS.  Closing command socket.");
        }

        close(fd);
        p_info->fdCommand = -1;

        if (p_info->clientId >= 0) {
            s_fdCommand_client[p_info->clientId] = -1;
        } else {
            s_fdCommand[p_info->socket_id] = -1;
        }

        ril_event_del(p_info->commands_event);

        record_stream_free(p_rs);
        RLOGD("[processCommandsCallback] get semaphone: %s", semName[slot_id]);
        sem = sem_open(semName[slot_id], O_CREAT, 0644, 1);
        if(SEM_FAILED == sem) {
            RLOGD("[processCommandsCallback]sem_open failed, errno = %d (%s)", errno, strerror(errno));
        }
        sem_wait(sem);
        changeClientSoketStatus(slot_id, clientId_tmp, 0);
        sem_post(sem);
        RLOGD("[processCommandsCallback] release semaphone: %s", semName[slot_id]);
        sem_close(sem);
        /* start listening for new connections again */
        rilEventAddWakeup(p_info->listen_event);

        onCommandsSocketClosed(p_info->socket_id, p_info->clientId);
    }
}


static void onNewCommandConnect(RIL_SOCKET_ID socket_id, int clientId) {
    // Inform we are connected and the ril version
    int rilVer = s_callbacks.version;
    /// support rilj client @{
    SocketListenParam* soc_params = NULL;

    for (int i = 0; i < NUM_ELEMS(s_ril_socket_params); i++) {
        /// since vendor ril using socket id, mapping to libril's slot id
        if (s_ril_socket_params[i]->socket_id == socket_id) {
            soc_params = s_ril_socket_params[i];
            break;
        }
    }
    if (clientId >= 0) {
        soc_params = &s_ril_param_socket_clients[clientId];
    }

    if (soc_params == NULL) {
        RLOGE("onNewCommandConnect invalid socket id %d", socket_id);
        return;
    }
    RLOGD("onNewCommandConnect rilversion %d",rilVer);
    Parcel *parcel = new Parcel();
    if(parcel == NULL) {
        RLOGE("onNewCommandConnect new parcel fail!!!");
        return;
    }
    parcel->writeInt32(1);
    parcel->writeInt32(rilVer);
    RIL_onUnsolicitedResponseInternal(RIL_UNSOL_RIL_CONNECTED,
                                    parcel, parcel->dataSize(), soc_params);

    // implicit radio state changed
    RIL_onUnsolicitedResponseInternal(RIL_UNSOL_RESPONSE_RADIO_STATE_CHANGED,
                                    NULL, 0, soc_params);
    /// @}

    // Send last NITZ time data, in case it was missed
    if (s_lastNITZTimeData != NULL) {
        RLOGE("onNewCommandConnect send last NTIZ to socket_id=%d", socket_id);
        sendResponseRaw(s_lastNITZTimeData, s_lastNITZTimeDataSize, socket_id, clientId);
        // for multi user, we keep the nitz data for the next one.
        /*
        free(s_lastNITZTimeData);
        s_lastNITZTimeData = NULL;
        */
    }

    // Get version string
    if (s_callbacks.getVersion != NULL) {
        const char *version;
        version = s_callbacks.getVersion();
        RLOGI("RIL Daemon version: %s\n", version);

        mtk_property_set(PROPERTY_RIL_IMPL, version);
    } else {
        RLOGI("RIL Daemon version: unavailable\n");
        mtk_property_set(PROPERTY_RIL_IMPL, "unavailable");
    }

    delete(parcel);
}

static void listenCallback (int fd, short flags, void *param) {
    int ret;
    int err;
    int is_phone_socket;
    int fdCommand = -1;
    const char* processName;
    RecordStream *p_rs;
    MySocketListenParam* listenParam;
    RilSocket *sapSocket = NULL;
    socketClient *sClient = NULL;

    SocketListenParam *p_info = (SocketListenParam *)param;

    if(RIL_SAP_SOCKET == p_info->type) {
        listenParam = (MySocketListenParam *)param;
        sapSocket = listenParam->socket;
    }

    struct sockaddr_un peeraddr;
    socklen_t socklen = sizeof (peeraddr);

    struct ucred creds;
    socklen_t szCreds = sizeof(creds);

    struct passwd *pwd = NULL;

    if(NULL == sapSocket) {
        assert (p_info->fdCommand < 0);
        assert (fd == p_info->fdListen);
        processName = PHONE_PROCESS;
    } else {
        assert (sapSocket->getCommandFd() < 0);
        assert (fd == sapSocket->getListenFd());
        processName = BLUETOOTH_PROCESS;
    }


    fdCommand = accept(fd, (sockaddr *) &peeraddr, &socklen);

    if (fdCommand < 0 ) {
        RLOGE("Error on accept() errno:%d", errno);
        /* start listening for new connections again */
        if(NULL == sapSocket) {
            rilEventAddWakeup(p_info->listen_event);
        } else {
            rilEventAddWakeup(sapSocket->getListenEvent());
        }
        return;
    }

    /* check the credential of the other side and only accept socket from
     * phone process
     */
    errno = 0;
    is_phone_socket = 1;

    err = getsockopt(fdCommand, SOL_SOCKET, SO_PEERCRED, &creds, &szCreds);

    if (err == 0 && szCreds > 0) {
        errno = 0;
        pwd = getpwuid(creds.uid);
        if (pwd != NULL) {
           /*TODO:bringup disable process check
            if (strcmp(pwd->pw_name, processName) == 0) {
                is_phone_socket = 1;
            } else {
                RLOGE("RILD can't accept socket from process %s", pwd->pw_name);
            }*/
            RLOGD("RILD receive socket request from process %s", pwd->pw_name);
            is_phone_socket = 1;
        } else {
            RLOGE("Error on getpwuid() errno: %d", errno);
        }
    } else {
        RLOGD("Error on getsockopt() errno: %d", errno);
    }

    if (!is_phone_socket) {
        RLOGE("RILD must accept socket from %s", processName);

        close(fdCommand);
        fdCommand = -1;

        if(NULL == sapSocket) {
            onCommandsSocketClosed(p_info->socket_id, p_info->clientId);

            /* start listening for new connections again */
            rilEventAddWakeup(p_info->listen_event);
        } else {
            sapSocket->onCommandsSocketClosed();

            /* start listening for new connections again */
            rilEventAddWakeup(sapSocket->getListenEvent());
        }

        return;
    }

    ret = fcntl(fdCommand, F_SETFL, O_NONBLOCK);

    if (ret < 0) {
        RLOGE ("Error setting O_NONBLOCK errno:%d", errno);
    }

    if(NULL == sapSocket) {
        RLOGI("libril: new connection to %s, clientId:%d",
                rilSocketIdToString(p_info->socket_id), p_info->clientId);

        p_info->fdCommand = fdCommand;
        p_rs = record_stream_new(p_info->fdCommand, MAX_COMMAND_BYTES);
        p_info->p_rs = p_rs;

        ril_event_set (p_info->commands_event, p_info->fdCommand, 1,
        p_info->processCommandsCallback, p_info);
        rilEventAddWakeup (p_info->commands_event);

        onNewCommandConnect(p_info->socket_id, p_info->clientId);

        // M: ril proxy
        pthread_mutex_lock(&s_pendingUrcMutex[p_info->socket_id]);
        if (p_info->clientId >= 0) {
            s_fdCommand_client[p_info->clientId] = p_info->fdCommand;
        } else {
            s_fdCommand[p_info->socket_id] = p_info->fdCommand;
        }
        sendPendedUrcs(p_info->socket_id, p_info->fdCommand);
        pthread_mutex_unlock(&s_pendingUrcMutex[p_info->socket_id]);
        //
    } else {
        RLOGI("libril: new connection");

        sapSocket->setCommandFd(fdCommand);
        p_rs = record_stream_new(sapSocket->getCommandFd(), MAX_COMMAND_BYTES);
        sClient = new socketClient(sapSocket,p_rs);
        ril_event_set (sapSocket->getCallbackEvent(), sapSocket->getCommandFd(), 1,
        sapSocket->getCommandCb(), sClient);

        rilEventAddWakeup(sapSocket->getCallbackEvent());
        sapSocket->onNewCommandConnect();
    }
}

static void freeDebugCallbackArgs(int number, char **args) {
    for (int i = 0; i < number; i++) {
        if (args[i] != NULL) {
            free(args[i]);
        }
    }
    free(args);
}

static void debugCallback (int fd, short flags, void *param) {
    int acceptFD, option;
    struct sockaddr_un peeraddr;
    socklen_t socklen = sizeof (peeraddr);
    int data;
    unsigned int qxdm_data[6];
    const char *deactData[1] = {"1"};
    RIL_Dial dialData;
    int hangupData[1] = {1};
    int number;
    char **args;
    RIL_SOCKET_ID socket_id = RIL_SOCKET_1;
    int MAX_DIAL_ADDRESS = 128;
    int sim_id = 0;

    RLOGI("debugCallback for socket %s", rilSocketIdToString(socket_id));

    acceptFD = accept (fd,  (sockaddr *) &peeraddr, &socklen);

    if (acceptFD < 0) {
        RLOGE ("error accepting on debug port: %d\n", errno);
        return;
    }

    if (recv(acceptFD, &number, sizeof(int), 0) != sizeof(int)) {
        RLOGE ("error reading on socket: number of Args: \n");
        close(acceptFD);
        return;
    }

    if (number < 0) {
        RLOGE ("Invalid number of arguments: \n");
        close(acceptFD);
        return;
    }

    args = (char **) calloc(number, sizeof(char*));
    if (args == NULL) {
        RLOGE("Memory allocation failed for debug args");
        close(acceptFD);
        return;
    }

    for (int i = 0; i < number; i++) {
        int len;
        if (recv(acceptFD, &len, sizeof(int), 0) != sizeof(int)) {
            RLOGE ("error reading on socket: Len of Args: \n");
            freeDebugCallbackArgs(i, args);
            close(acceptFD);
            return;
        }
        if (len == INT_MAX || len < 0) {
            RLOGE("Invalid value of len: \n");
            freeDebugCallbackArgs(i, args);
            close(acceptFD);
            return;
        }

        // +1 for null-term
        args[i] = (char *) calloc(len + 1, sizeof(char));
        if (args[i] == NULL) {
            RLOGE("Memory allocation failed for debug args");
            freeDebugCallbackArgs(i, args);
            close(acceptFD);
            return;
        }
        if (recv(acceptFD, args[i], sizeof(char) * len, 0)
            != (int)sizeof(char) * len) {
            RLOGE ("error reading on socket: Args[%d] \n", i);
            freeDebugCallbackArgs(i, args);
            close(acceptFD);
            return;
        }
        char * buf = args[i];
        buf[len] = 0;
        if ((i+1) == number) {
            /* The last argument should be sim id 0(SIM1)~3(SIM4) */
            sim_id = atoi(args[i]);
            switch (sim_id) {
                case 0:
                    socket_id = RIL_SOCKET_1;
                    break;
                case 1:
                    socket_id = RIL_SOCKET_2;
                    break;
                case 2:
                    socket_id = RIL_SOCKET_3;
                    break;
                case 3:
                    socket_id = RIL_SOCKET_4;
                    break;
                default:
                    socket_id = RIL_SOCKET_1;
                    break;
            }
        }
    }

    switch (atoi(args[0])) {
        case 0:
            RLOGI ("Connection on debug port: issuing reset.");
            issueLocalRequest(RIL_REQUEST_RESET_RADIO, NULL, 0, socket_id);
            break;
        case 1:
            RLOGI ("Connection on debug port: issuing radio power off.");
            data = 0;
            issueLocalRequest(RIL_REQUEST_RADIO_POWER, &data, sizeof(int), socket_id);
            // Close the socket
            if (socket_id == RIL_SOCKET_1 && s_ril_param_socket.fdCommand > 0) {
                close(s_ril_param_socket.fdCommand);
                s_ril_param_socket.fdCommand = -1;
            }
            else if (socket_id == RIL_SOCKET_2 && s_ril_param_socket2.fdCommand > 0) {
                close(s_ril_param_socket2.fdCommand);
                s_ril_param_socket2.fdCommand = -1;
            }
            break;
        case 2:
            RLOGI ("Debug port: issuing unsolicited voice network change.");
            RIL_UNSOL_RESPONSE(RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED, NULL, 0, socket_id);
            break;
        case 3:
            RLOGI ("Debug port: QXDM log enable.");
            qxdm_data[0] = 65536;     // head.func_tag
            qxdm_data[1] = 16;        // head.len
            qxdm_data[2] = 1;         // mode: 1 for 'start logging'
            qxdm_data[3] = 32;        // log_file_size: 32megabytes
            qxdm_data[4] = 0;         // log_mask
            qxdm_data[5] = 8;         // log_max_fileindex
            issueLocalRequest(RIL_REQUEST_OEM_HOOK_RAW, qxdm_data,
                              6 * sizeof(int), socket_id);
            break;
        case 4:
            RLOGI ("Debug port: QXDM log disable.");
            qxdm_data[0] = 65536;
            qxdm_data[1] = 16;
            qxdm_data[2] = 0;          // mode: 0 for 'stop logging'
            qxdm_data[3] = 32;
            qxdm_data[4] = 0;
            qxdm_data[5] = 8;
            issueLocalRequest(RIL_REQUEST_OEM_HOOK_RAW, qxdm_data,
                              6 * sizeof(int), socket_id);
            break;
        case 5:
            RLOGI("Debug port: Radio On");
            data = 1;
            issueLocalRequest(RIL_REQUEST_RADIO_POWER, &data, sizeof(int), socket_id);
            sleep(2);
            // Set network selection automatic.
            issueLocalRequest(RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC, NULL, 0, socket_id);
            break;
        case 7:
            RLOGI("Debug port: Deactivate Data Call");
            issueLocalRequest(RIL_REQUEST_DEACTIVATE_DATA_CALL, &deactData,
                              sizeof(deactData), socket_id);
            break;
        case 8:
            RLOGI("Debug port: Dial Call");
            dialData.clir = 0;
            if (strlen(args[1]) > MAX_DIAL_ADDRESS) {
                RLOGE("Debug port: Error calling Dial");
                freeDebugCallbackArgs(number, args);
                close(acceptFD);
                return;
            }
            dialData.address = args[1];
            issueLocalRequest(RIL_REQUEST_DIAL, &dialData, sizeof(dialData), socket_id);
            break;
        case 9:
            RLOGI("Debug port: Answer Call");
            issueLocalRequest(RIL_REQUEST_ANSWER, NULL, 0, socket_id);
            break;
        case 10:
            RLOGI("Debug port: End Call");
            issueLocalRequest(RIL_REQUEST_HANGUP, &hangupData,
                              sizeof(hangupData), socket_id);
            break;
        default:
            RLOGE ("Invalid request");
            break;
    }
    freeDebugCallbackArgs(number, args);
    close(acceptFD);
}


static void userTimerCallback (int fd, short flags, void *param) {
    UserCallbackInfo *p_info;

    p_info = (UserCallbackInfo *)param;

    p_info->p_callback(p_info->userParam);


    // FIXME generalize this...there should be a cancel mechanism
    if (s_last_wake_timeout_info != NULL && s_last_wake_timeout_info == p_info) {
        s_last_wake_timeout_info = NULL;
    }

    free(p_info);
}


static void *
eventLoop(void *param) {
    int ret;
    int filedes[2];

    ril_event_init();

    pthread_mutex_lock(&s_startupMutex);

    s_started = 1;
    pthread_cond_broadcast(&s_startupCond);

    pthread_mutex_unlock(&s_startupMutex);

    ret = pipe(filedes);

    if (ret < 0) {
        RLOGE("Error in pipe() errno:%d", errno);
        return NULL;
    }

    s_fdWakeupRead = filedes[0];
    s_fdWakeupWrite = filedes[1];

    fcntl(s_fdWakeupRead, F_SETFL, O_NONBLOCK);

    ril_event_set (&s_wakeupfd_event, s_fdWakeupRead, true,
                processWakeupCallback, NULL);

    rilEventAddWakeup (&s_wakeupfd_event);

    // Only returns on error
    ril_event_loop();
    RLOGE ("error in event_loop_base errno:%d", errno);
    // kill self to restart on error
    kill(0, SIGKILL);

    return NULL;
}

extern "C" void
RIL_startEventLoop(void) {
    /* spin up eventLoop thread and wait for it to get started */
    s_started = 0;
    pthread_mutex_lock(&s_startupMutex);

    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

    int result = pthread_create(&s_tid_dispatch, &attr, eventLoop, NULL);
    if (result != 0) {
        RLOGE("Failed to create dispatch thread: %s", strerror(result));
        goto done;
    }

    while (s_started == 0) {
        pthread_cond_wait(&s_startupCond, &s_startupMutex);
    }

done:
    pthread_mutex_unlock(&s_startupMutex);
}

extern "C" void
RIL_startNetagent(void) {


    RLOGD("start NetAgentService");
    bool bSuccess = false;
    do {
        bSuccess = NetAgentService::createNetAgentService();
        if(!bSuccess) {
            RLOGE("Fail to create NetAgent service!");
            sleep(10);
            /* never returns */
        }
    } while (!bSuccess);

    RLOGD("started NetAgentService");
}


// Used for testing purpose only.
extern "C" void RIL_setcallbacks (const RIL_RadioFunctions *callbacks) {
    memcpy(&s_callbacks, callbacks, sizeof (RIL_RadioFunctions));
}

static void startListen(RIL_SOCKET_ID socket_id, SocketListenParam* socket_listen_p) {
    int fdListen = -1;
    int ret;
    char socket_name[20];

    memset(socket_name, 0, sizeof(char)*20);

    switch(socket_id) {
        case RIL_SOCKET_1:
            strncpy(socket_name, RIL_getRilSocketName(), 19);
            break;
        case RIL_SOCKET_2:
            strncpy(socket_name, SOCKET2_NAME_RIL, 19);
            break;
        case RIL_SOCKET_3:
            strncpy(socket_name, SOCKET3_NAME_RIL, 19);
            break;
        case RIL_SOCKET_4:
            strncpy(socket_name, SOCKET4_NAME_RIL, 19);
            break;
        case RIL_SOCKET_RILJ:
            strncpy(socket_name, SOCKET_NAME_RILJCLIENT, 19);
            break;
        case RIL_SOCKET_RILJ2:
            strncpy(socket_name, SOCKET2_NAME_RILJCLIENT, 19);
            break;
        default:
            RLOGE("Socket id is wrong!!");
            return;
    }

    RLOGI("Start to listen %s %s", rilSocketIdToString(socket_id), socket_name);

    fdListen = android_get_control_socket(socket_name);
    if (fdListen < 0) {
        RLOGE("Failed to get socket %s", socket_name);
        exit(-1);
    }

    ret = listen(fdListen, 4);

    if (ret < 0) {
        RLOGE("Failed to listen on control socket '%d': %s",
             fdListen, strerror(errno));
        exit(-1);
    }
    socket_listen_p->fdListen = fdListen;

    /* note: non-persistent so we can accept only one connection at a time */
    ril_event_set (socket_listen_p->listen_event, fdListen, false,
                listenCallback, socket_listen_p);

    rilEventAddWakeup (socket_listen_p->listen_event);
}

static bool isRiljEnable() {
    if (s_riljclient_support != -1) {
        return s_riljclient_support;
    } else {
        char rilj_support[PROP_VALUE_MAX] = { 0 };
        mtk_property_get(RILJ_CLIENT_SUPPORT_KEY, rilj_support, "0");
        if (strcmp(rilj_support, "1") == 0) {
            return true;
        }
        return false;
    }
}

bool isDsds() {
    char isDsdsString[PROP_VALUE_MAX] = {0};
    mtk_property_get("persist.radio.multisim.config", isDsdsString, "");
    if (strcmp(isDsdsString, "dsds") == 0) {
        return true;
    } else {
        return false;
    }
}

static int getDisableSim() {
    char disableSimNum[PROP_VALUE_MAX] = {0};
    mtk_property_get("persist.radio.dsss.sim.disable", disableSimNum, "");
    if (strcmp(disableSimNum, "1") == 0) {
        return 1;
    } else if (strcmp(disableSimNum, "2") == 0) {
        return 2;
    } else {
        return 0;
    }
}

static void initSocketParam(int clientId, int listenFd) {
    bool isDsdsClient = isDsds();
    int disableSim = getDisableSim();
    if (isDsdsClient) {
        if((clientId % 2) == 1){
            s_ril_param_socket_clients[clientId].socket_id = RIL_SOCKET_2;
            s_ril_param_socket_clients[clientId].slot_id = RIL_SLOT_2;
        } else {
            s_ril_param_socket_clients[clientId].socket_id = RIL_SOCKET_1;
            s_ril_param_socket_clients[clientId].slot_id = RIL_SLOT_1;
        }
    } else {
        if (disableSim == 1) {
            s_ril_param_socket_clients[clientId].socket_id = RIL_SOCKET_2;
            s_ril_param_socket_clients[clientId].slot_id = RIL_SLOT_2;
        } else {
            s_ril_param_socket_clients[clientId].socket_id = RIL_SOCKET_1;
            s_ril_param_socket_clients[clientId].slot_id = RIL_SLOT_1;
        }
    }
    s_ril_param_socket_clients[clientId].fdListen = listenFd;
    s_ril_param_socket_clients[clientId].fdCommand = -1;
    s_ril_param_socket_clients[clientId].processName = PHONE_PROCESS;
    s_ril_param_socket_clients[clientId].commands_event = &s_commands_event_socket_client[clientId];
    s_ril_param_socket_clients[clientId].listen_event = &s_listen_event_socket_client[clientId];
    s_ril_param_socket_clients[clientId].processCommandsCallback = processCommandsCallback;
    s_ril_param_socket_clients[clientId].p_rs = NULL;
    s_ril_param_socket_clients[clientId].type = RIL_TELEPHONY_SOCKET;
    s_ril_param_socket_clients[clientId].clientId = clientId;
    return;
}


static int createClientSocket(char* socketName, int clientId) {
    struct sockaddr_un my_addr;
    struct sockaddr_un peer_addr;
    int ret;

    int listenFd = android_get_control_socket(socketName);

    //do retry if init.rc didn't define socket
    if (listenFd < 0) {
        RLOGD("init.rc didn't define, create client socket");
        listenFd = socket_local_server(socketName, ANDROID_SOCKET_NAMESPACE_RESERVED, SOCK_STREAM);
        RLOGD("[createClientSocket]listenFd = %d", listenFd);
    }

    if (listenFd < 0) {
        return listenFd;
    }

    RLOGI("start listen on fd: %d, socket name: %s", listenFd, socketName);

    ret = listen(listenFd, 4);

    if (ret < 0) {
        RLOGE("Failed to listen on control socket '%d': %s", listenFd, strerror(errno));
        close(listenFd);
        return -1;
    }

    RLOGI("createClientSocket start listen end");

    initSocketParam(clientId, listenFd);
    /* note: non-persistent so we can accept only one connection at a time */
    ril_event_set(&s_listen_event_socket_client[clientId], listenFd,
            false, listenCallback, &s_ril_param_socket_clients[clientId]);
    rilEventAddWakeup(&s_listen_event_socket_client[clientId]);


    return listenFd;
}

static int getClientNum() {
    char clientNum[PROP_VALUE_MAX] = {0};
    int clientSocketNum = 0;
    mtk_property_get("persist.ril.client.num", clientNum, "0");
    clientSocketNum = std::stoi(clientNum);

    if (isDsds()) {
        clientSocketNum = clientSocketNum * 2;
    }

    return clientSocketNum;
}

static void RIL_client_register() {
    RLOGI("RIL_client_register enter");
    // start listen client socket

    int clientSocketNum = getClientNum();
    RLOGD("RIL_client_register create socket clientNum %d", clientSocketNum);

    for(int i = 0; i < RIL_SLOT_MAX; i++) {
        if(0 != strlen(socket_status[i])){
            mtk_property_set(socket_status[i], "0");   //init property
        }
    }

    if (clientSocketNum > 0) {
        RLOGD("RIL_client_register clientSocketNum >0");
        s_ril_param_socket_clients = new SocketListenParam[clientSocketNum];
        s_commands_event_socket_client = new ril_event[clientSocketNum];
        s_listen_event_socket_client = new ril_event[clientSocketNum];

        s_pendingRequestsMutex_socket_client = new pthread_mutex_t[clientSocketNum];
        s_writeMutex_socket_client = new pthread_mutex_t[clientSocketNum];
        s_pendingRequests_socket_client = new RequestInfo*[clientSocketNum];

        s_fdCommand_client = new int[clientSocketNum];

        for (int i = 0; i < clientSocketNum; i++) {
            RLOGD("RIL_client_register create socket");
            s_writeMutex_socket_client[i] = PTHREAD_MUTEX_INITIALIZER;
            s_pendingRequestsMutex_socket_client[i] = PTHREAD_MUTEX_INITIALIZER;
            s_pendingRequests_socket_client[i] = NULL;

            char clientSocketName[20];
            if (isDsds()) {
                if (i % 2 == 0) {
                    sprintf(clientSocketName, "%s%d%s", "rild-client", i/2, "-0");
                } else {
                    sprintf(clientSocketName, "%s%d%s", "rild-client", i/2, "-1");
                }
            } else {
                sprintf(clientSocketName, "%s%d", "rild-client", i);
            }

            RLOGD("RIL_client_register create socket clientSocketName %s", clientSocketName);
            s_fdCommand_client[i] = -1;
            if (createClientSocket(clientSocketName, i) < 0) {
                RLOGE("create client failed");
                return;
            }
        }
    }
}

static void RILJ_register () {
    /* Initialize RILJ socket parameters */
    s_ril_param_socket_rilj = {
      RIL_SOCKET_RILJ, /* socket_id */
      -1, /* fdListen */
      -1, /* fdCommand */
      PHONE_PROCESS, /* processName */
      &s_commands_event_socket_rilj, /* commands_event */
      &s_listen_event_socket_rilj, /* listen_event */
      processCommandsCallback, /* processCommandsCallback */
      NULL, /* p_rs */
      RIL_TELEPHONY_SOCKET, /* type */
      RIL_SLOT_1,
      -1 /* clientId */
    };

    s_ril_param_socket_rilj2 = {
      RIL_SOCKET_RILJ2, /* socket_id */
      -1, /* fdListen */
      -1, /* fdCommand */
      PHONE_PROCESS, /* processName */
      &s_commands_event_socket_rilj2, /* commands_event */
      &s_listen_event_socket_rilj2, /* listen_event */
      processCommandsCallback, /* processCommandsCallback */
      NULL, /* p_rs */
      RIL_TELEPHONY_SOCKET, /* type */
      RIL_SLOT_2,
      -1 /* clientId */
    };

    if(!isRiljEnable()) {
        RLOGD("Not Support RILJ CLient");
        return;
    }
    // start listen socket1
    startListen(RIL_SOCKET_RILJ, &s_ril_param_socket_rilj);

    if (SIM_COUNT >= 2) {
    // start listen socket2
    startListen(RIL_SOCKET_RILJ2, &s_ril_param_socket_rilj2);
    }

  }


extern "C" void
RIL_register (const RIL_RadioFunctions *callbacks) {
    int ret;
    int flags;

    RLOGI("SIM_COUNT: %d", SIM_COUNT);

    if (callbacks == NULL) {
        RLOGE("RIL_register: RIL_RadioFunctions * null");
        return;
    }
    if (callbacks->version < RIL_VERSION_MIN) {
        RLOGE("RIL_register: version %d is to old, min version is %d",
             callbacks->version, RIL_VERSION_MIN);
        return;
    }

    RLOGE("RIL_register: RIL version %d", callbacks->version);

    if (s_registerCalled > 0) {
        RLOGE("RIL_register has been called more than once. "
                "Subsequent call ignored");
        return;
    }

    memcpy(&s_callbacks, callbacks, sizeof (RIL_RadioFunctions));

    /* Initialize socket1 parameters */
    s_ril_param_socket = {
                        RIL_SOCKET_1,             /* socket_id */
                        -1,                       /* fdListen */
                        -1,                       /* fdCommand */
                        PHONE_PROCESS,            /* processName */
                        &s_commands_event,        /* commands_event */
                        &s_listen_event,          /* listen_event */
                        processCommandsCallback,  /* processCommandsCallback */
                        NULL,                     /* p_rs */
                        RIL_TELEPHONY_SOCKET,      /* type */
                        RIL_SLOT_1,
                        -1                         /* clientId */
                        };

    s_ril_param_socket2 = {
                        RIL_SOCKET_2,               /* socket_id */
                        -1,                         /* fdListen */
                        -1,                         /* fdCommand */
                        PHONE_PROCESS,              /* processName */
                        &s_commands_event_socket2,  /* commands_event */
                        &s_listen_event_socket2,    /* listen_event */
                        processCommandsCallback,    /* processCommandsCallback */
                        NULL,                       /* p_rs */
                        RIL_TELEPHONY_SOCKET,        /* type */
                        RIL_SLOT_2,
                        -1                          /* clientId */
                        };

    /// support RILJ client @{
    s_ril_param_socket3 = {
                        RIL_SOCKET_3,               /* socket_id */
                        -1,                         /* fdListen */
                        -1,                         /* fdCommand */
                        PHONE_PROCESS,              /* processName */
                        &s_commands_event_socket3,  /* commands_event */
                        &s_listen_event_socket3,    /* listen_event */
                        processCommandsCallback,    /* processCommandsCallback */
                        NULL,                       /* p_rs */
                        RIL_TELEPHONY_SOCKET,        /* type */
                        RIL_SLOT_3,
                        -1                          /* clientId */
                        };

    s_ril_param_socket4 = {
                        RIL_SOCKET_4,               /* socket_id */
                        -1,                         /* fdListen */
                        -1,                         /* fdCommand */
                        PHONE_PROCESS,              /* processName */
                        &s_commands_event_socket4,  /* commands_event */
                        &s_listen_event_socket4,    /* listen_event */
                        processCommandsCallback,    /* processCommandsCallback */
                        NULL,                       /* p_rs */
                        RIL_TELEPHONY_SOCKET,        /* type */
                        RIL_SLOT_4,
                        -1                          /* clientId */
                        };
    /// @}

    s_registerCalled = 1;

    RLOGI("s_registerCalled flag set, %d", s_started);
    // Little self-check

//    for (int i = 0; i < (int)NUM_ELEMS(s_commands); i++) {
//        assert(i == s_commands[i].requestNumber);
//    }
//
//    for (int i = 0; i < (int)NUM_ELEMS(s_unsolResponses); i++) {
//        assert(i + RIL_UNSOL_RESPONSE_BASE
//                == s_unsolResponses[i].requestNumber);
//    }

//    for (int i = 0; i < (int)NUM_ELEMS(s_mtk_commands); i++) {
//        if (i + RIL_REQUEST_VENDOR_BASE != s_mtk_commands[i].requestNumber) {
//            RLOGE("mtk_ril_commands table error. index : %d, requestNumber = %d",
//                    i, s_mtk_commands[i].requestNumber);
//            #ifdef HAVE_AEE_FEATURE
//            char *msg = NULL;
//            asprintf(&msg, "mtk_ril_commands table error. index : %d, requestNumber = %d",
//                        i, s_mtk_commands[i].requestNumber);
//            triggerWarning(msg);
//            free(msg);
//            #else
//            assert(0);
//            #endif
//        }
//    }
//
//    for (int i = 0; i < (int)NUM_ELEMS(s_mtk_unsolResponses); i++) {
//        if (i + RIL_UNSOL_VENDOR_BASE != s_mtk_unsolResponses[i].requestNumber) {
//            RLOGE("mtk_ril_unsol_commands table error. index : %d, requestNumber = %d",
//                    i, s_mtk_unsolResponses[i].requestNumber);
//            #ifdef HAVE_AEE_FEATURE
//            char *msg = NULL;
//            asprintf(&msg, "mtk_ril_unsol_commands table error. index : %d, requestNumber = %d",
//                    i, s_mtk_unsolResponses[i].requestNumber);
//            triggerWarning(msg);
//            free(msg);
//            #else
//            assert(0);
//            #endif
//        }
//    }
    // initialize mutex
    for (int i = 0; i < RIL_SOCKET_NUM; i++) {
        pthread_mutex_init(&s_state_mutex[i], NULL);
        pthread_mutex_init(&s_pendingUrcMutex[i], NULL);
        s_fdCommand[i] = -1;
    }

    // New rild impl calls RIL_startEventLoop() first
    // old standalone impl wants it here.

    if (s_started == 0) {
        RIL_startEventLoop();
    }

    // start listen socket1
    startListen(RIL_SOCKET_1, &s_ril_param_socket);

    if (SIM_COUNT >= 2) {
    // start listen socket2
    startListen(RIL_SOCKET_2, &s_ril_param_socket2);
    }

    if (SIM_COUNT >= 3) {
    // start listen socket3
    startListen(RIL_SOCKET_3, &s_ril_param_socket3);
    }

    if (SIM_COUNT >= 4) {
    // start listen socket4
    startListen(RIL_SOCKET_4, &s_ril_param_socket4);
    }

    /// @}
    RILJ_register();

    RIL_client_register();
#if 1
    // start debug interface socket

    char *inst = NULL;
    if (strlen(RIL_getRilSocketName()) >= strlen(SOCKET_NAME_RIL)) {
        inst = RIL_getRilSocketName() + strlen(SOCKET_NAME_RIL);
    }

    char rildebug[MAX_DEBUG_SOCKET_NAME_LENGTH] = SOCKET_NAME_RIL_DEBUG;
    if (inst != NULL) {
        strncat(rildebug, inst, MAX_DEBUG_SOCKET_NAME_LENGTH);
    }

    s_fdDebug = android_get_control_socket(rildebug);
    if (s_fdDebug < 0) {
        RLOGE("Failed to get socket : %s errno:%d", rildebug, errno);
        exit(-1);
    }

    ret = listen(s_fdDebug, 4);

    if (ret < 0) {
        RLOGE("Failed to listen on ril debug socket '%d': %s",
             s_fdDebug, strerror(errno));
        exit(-1);
    }

    ril_event_set (&s_debug_event, s_fdDebug, true,
                debugCallback, NULL);

    rilEventAddWakeup (&s_debug_event);
#endif

}

extern "C" void
RIL_register_socket (const RIL_RadioFunctions *(*Init)(const struct RIL_Env *, int, char **),RIL_SOCKET_TYPE socketType, int argc, char **argv) {

    const RIL_RadioFunctions* UimFuncs = NULL;

    if(Init) {
        UimFuncs = Init(&RilSapSocket::uimRilEnv, argc, argv);

        switch(socketType) {
            case RIL_SAP_SOCKET:
                RilSapSocket::initSapSocket("sap_uim_socket1", UimFuncs);
                if (SIM_COUNT >= 2) {
                    RilSapSocket::initSapSocket("sap_uim_socket2", UimFuncs);
                }
                if (SIM_COUNT >= 3) {
                    RilSapSocket::initSapSocket("sap_uim_socket3", UimFuncs);
                }
                if (SIM_COUNT >= 4) {
                    RilSapSocket::initSapSocket("sap_uim_socket4", UimFuncs);
                }
                break;
            default:;
        }
    }
}

// Check and remove RequestInfo if its a response and not just ack sent back
static int
checkAndDequeueRequestInfoIfAck(struct RequestInfo *pRI, bool isAck) {
    int ret = 0;
    /* Hook for current context
       pendingRequestsMutextHook refer to &s_pendingRequestsMutex */
    pthread_mutex_t* pendingRequestsMutexHook = &s_pendingRequestsMutex;
    /* pendingRequestsHook refer to &s_pendingRequests */
    RequestInfo ** pendingRequestsHook = &s_pendingRequests;

    if (pRI == NULL) {
        return 0;
    }

    if (pRI->socket_id == RIL_SOCKET_2) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket2;
        pendingRequestsHook = &s_pendingRequests_socket2;
    }
        if (pRI->socket_id == RIL_SOCKET_3) {
            pendingRequestsMutexHook = &s_pendingRequestsMutex_socket3;
            pendingRequestsHook = &s_pendingRequests_socket3;
        }
    if (pRI->socket_id == RIL_SOCKET_4) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket4;
        pendingRequestsHook = &s_pendingRequests_socket4;
    }
    if (pRI->socket_id == RIL_SOCKET_RILJ) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket_rilj;
        pendingRequestsHook = &s_pendingRequests_socket_rilj;
    }
    if (pRI->socket_id == RIL_SOCKET_RILJ2) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket_rilj2;
        pendingRequestsHook = &s_pendingRequests_socket_rilj2;
    }

    if (pRI->clientId >= 0) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket_client[pRI->clientId];
        pendingRequestsHook = &s_pendingRequests_socket_client[pRI->clientId];
    }

    pthread_mutex_lock(pendingRequestsMutexHook);

    for(RequestInfo **ppCur = pendingRequestsHook
            ; *ppCur != NULL
            ; ppCur = &((*ppCur)->p_next)
        ) {
        if (pRI == *ppCur) {
            ret = 1;
            if (isAck) { // Async ack
                if (pRI->wasAckSent == 1) {
                    RLOGD("Ack was already sent for %s", requestToString(pRI->pCI->requestNumber));
                } else {
                    pRI->wasAckSent = 1;
                }
            } else {
                *ppCur = (*ppCur)->p_next;
            }
            break;
        }
    }

    pthread_mutex_unlock(pendingRequestsMutexHook);

    return ret;
}

static int findFd(int socket_id, int clientId) {
    int fd = -1;
    if (clientId >= 0) {
        fd = s_ril_param_socket_clients[clientId].fdCommand;
    } else {
        fd = s_ril_param_socket.fdCommand;
        if (socket_id == RIL_SOCKET_2) {
            fd = s_ril_param_socket2.fdCommand;
        }
        if (socket_id == RIL_SOCKET_3) {
            fd = s_ril_param_socket3.fdCommand;
        }
        if (socket_id == RIL_SOCKET_4) {
            fd = s_ril_param_socket4.fdCommand;
        }
        if (socket_id == RIL_SOCKET_RILJ) {
            fd = s_ril_param_socket_rilj.fdCommand;
        }
        if (socket_id == RIL_SOCKET_RILJ2) {
            fd = s_ril_param_socket_rilj2.fdCommand;
        }
    }
    RLOGD("findFd end socket_id=%d, clientId =%d, fd=%d", socket_id, clientId, fd);
    return fd;
}

/// since vendor ril uses socket id, so change slot id to socket id again
static RIL_SOCKET_ID mapingSlotIdToRilSocketId(RIL_SLOT_ID slot_id) {
    RIL_SOCKET_ID soc_id = RIL_SOCKET_1;
    switch(slot_id) {
        case RIL_SLOT_2:
            soc_id = RIL_SOCKET_2;
            break;
        case RIL_SLOT_3:
            soc_id = RIL_SOCKET_3;
            break;
        case RIL_SLOT_4:
            soc_id = RIL_SOCKET_4;
            break;
    }
    return soc_id;
}

/// change libril's socket id to slot id to initialize slot id
extern "C"
RIL_SLOT_ID mappingSocketIdToSlotId(RIL_SOCKET_ID socket_id) {
    RIL_SLOT_ID slot_id = RIL_SLOT_1;
    for (int i = 0; i < NUM_ELEMS(s_ril_socket_params); i++) {
        if (socket_id == s_ril_socket_params[i]->socket_id) {
            slot_id = s_ril_socket_params[i]->slot_id;
            break;
        }
    }
    return slot_id;
}

extern "C" void
RIL_onRequestAck(RIL_Token t) {
    RequestInfo *pRI;
    int ret, fd;

    size_t errorOffset;
    RIL_SOCKET_ID socket_id = RIL_SOCKET_1;
    int clientId = -1;

    pRI = (RequestInfo *)t;

    if (!checkAndDequeueRequestInfoIfAck(pRI, true)) {
        RLOGE ("RIL_onRequestAck: invalid RIL_Token");
        return;
    }
    /// support client socket
    socket_id = pRI->socket_id;
    clientId = pRI->clientId;
    fd = findFd(socket_id, clientId);

#if VDBG
    RLOGD("Request Ack, %s", rilSocketIdToString(socket_id));
#endif

    appendPrintBuf("Ack [%04d]< %s", pRI->token, requestToString(pRI->pCI->requestNumber));

    if (pRI->cancelled == 0) {
        Parcel p;

        p.writeInt32 (RESPONSE_SOLICITED_ACK);
        p.writeInt32 (pRI->token);

        if (fd < 0) {
            RLOGD ("RIL onRequestComplete: Command channel closed");
        }

        sendResponse(p, socket_id, clientId);
    }
}

extern "C" void
RIL_onRequestComplete(RIL_Token t, RIL_Errno e, void *response, size_t responselen) {
    RequestInfo *pRI;
    int ret;
    int fd;
    size_t errorOffset;
    RIL_SOCKET_ID socket_id = RIL_SOCKET_1;

    pRI = (RequestInfo *)t;

    if (!checkAndDequeueRequestInfoIfAck(pRI, false)) {
        RLOGE ("RIL_onRequestComplete: invalid RIL_Token");
        return;
    }

    socket_id = pRI->socket_id;
    fd = findFd(socket_id, pRI->clientId);
    if (fd < 0) {
        RLOGD ("RIL onRequestComplete: Command channel closed");
    }

#if RILJDBG
    RLOGD("RequestComplete, %s, type %d", rilSocketIdToString(socket_id), pRI->type);
#endif

    if (pRI->local > 0) {
        // Locally issued command...void only!
        // response does not go back up the command socket
        if (pRI->cancelled == 0) {
            RLOGD("C[locl]< %s", requestToString(pRI->pCI->requestNumber));
        }

        goto done;
    }

    appendPrintBuf("[%04d]< %s",
        pRI->token, requestToString(pRI->pCI->requestNumber));
    RLOGD("RequestComplete, sendResponse, %d",pRI->cancelled);

    if (pRI->cancelled == 0) {
        Parcel p;

        if (s_callbacks.version >= 13 && pRI->wasAckSent == 1) {
            // If ack was already sent, then this call is an asynchronous response. So we need to
            // send id indicating that we expect an ack from RIL.java as we acquire wakelock here.
            p.writeInt32 (RESPONSE_SOLICITED_ACK_EXP);
            grabPartialWakeLock();
        } else {
            p.writeInt32 (RESPONSE_SOLICITED);
        }
        p.writeInt32 (pRI->token);
        errorOffset = p.dataPosition();

        p.writeInt32 (e);

        if (response != NULL) {
            Parcel *resp = (Parcel *) response;
            // there is a response payload, no matter success or not.
            //ret = pRI->pCI->responseFunction(p, response, responselen);
            resp->setDataPosition(0);
            ret = p.appendFrom(resp,0,resp->dataSize());
            /* if an error occurred, rewind and mark it */
            if (ret != 0) {
                RLOGE ("responseFunction error, ret %d", ret);
                p.setDataPosition(errorOffset);
                p.writeInt32 (ret);
            }
        }
        RLOGD("RequestComplete, before sendResponse, %d",responselen);

        if (e != RIL_E_SUCCESS) {
            appendPrintBuf("%s fails by %s", printBuf, failCauseToString(e));
        }

        sendResponse(p, socket_id, pRI->clientId);
    }

done:
    free(pRI);
}

extern "C"
void resetWakelock(void) {
    RLOGD("reset Wakelock %s", ANDROID_WAKE_LOCK_NAME);
    mtk_release_wake_lock(ANDROID_WAKE_LOCK_NAME);
}

/// MTK_RIL_ADAPTER @{
extern "C" void
RIL_onIssueLocalRequest(int request, void *data, int len, RIL_SOCKET_ID socket_id) {
    RLOGD("issue local request: %s", requestToString(request));
    issueLocalRequest(request, data, len, socket_id); //data changed to parcel* type
}
/// @}

static void
grabPartialWakeLock() {
    if (s_callbacks.version >= 13) {
        int ret;
        ret = pthread_mutex_lock(&s_wakeLockCountMutex);
        assert(ret == 0);
        mtk_acquire_wake_lock(ANDROID_WAKE_LOCK_NAME);

        UserCallbackInfo *p_info =
                internalRequestTimedCallback(wakeTimeoutCallback, NULL, &TIMEVAL_WAKE_TIMEOUT);
        if (p_info == NULL) {
            mtk_release_wake_lock(ANDROID_WAKE_LOCK_NAME);
        } else {
            s_wakelock_count++;
            if (s_last_wake_timeout_info != NULL) {
                s_last_wake_timeout_info->userParam = (void *)1;
            }
            s_last_wake_timeout_info = p_info;
        }
        ret = pthread_mutex_unlock(&s_wakeLockCountMutex);
        assert(ret == 0);
    } else {
        mtk_acquire_wake_lock(ANDROID_WAKE_LOCK_NAME);
    }
}

static void
releaseWakeLock() {
    if (s_callbacks.version >= 13) {
        int ret;
        ret = pthread_mutex_lock(&s_wakeLockCountMutex);
        assert(ret == 0);

        if (s_wakelock_count > 1) {
            s_wakelock_count--;
        } else {
            s_wakelock_count = 0;
            mtk_release_wake_lock(ANDROID_WAKE_LOCK_NAME);
            if (s_last_wake_timeout_info != NULL) {
                s_last_wake_timeout_info->userParam = (void *)1;
            }
        }

        ret = pthread_mutex_unlock(&s_wakeLockCountMutex);
        assert(ret == 0);
    } else {
        mtk_release_wake_lock(ANDROID_WAKE_LOCK_NAME);
    }
}

/**
 * Timer callback to put us back to sleep before the default timeout
 */
static void
wakeTimeoutCallback (void *param) {
    // We're using "param != NULL" as a cancellation mechanism
    if (s_callbacks.version >= 13) {
        if (param == NULL) {
            int ret;
            ret = pthread_mutex_lock(&s_wakeLockCountMutex);
            assert(ret == 0);
            s_wakelock_count = 0;
            mtk_release_wake_lock(ANDROID_WAKE_LOCK_NAME);
            ret = pthread_mutex_unlock(&s_wakeLockCountMutex);
            assert(ret == 0);
        }
    } else {
        if (param == NULL) {
            releaseWakeLock();
        }
    }
}

static bool is3gpp2(int radioTech) {
    switch (radioTech) {
        case RADIO_TECH_IS95A:
        case RADIO_TECH_IS95B:
        case RADIO_TECH_1xRTT:
        case RADIO_TECH_EVDO_0:
        case RADIO_TECH_EVDO_A:
        case RADIO_TECH_EVDO_B:
        case RADIO_TECH_EHRPD:
            return true;
        default:
            return false;
    }
}

#if defined(ANDROID_MULTI_SIM)
extern "C"
void RIL_onUnsolicitedResponse(int unsolResponse, const void *data,
                                size_t datalen, RIL_SOCKET_ID soc_id)
#else
extern "C"
void RIL_onUnsolicitedResponse(int unsolResponse, const void *data,
                                size_t datalen)
#endif
{
#if defined(ANDROID_MULTI_SIM)
    RIL_SOCKET_ID socId = soc_id;
#else
    RIL_SOCKET_ID socId = RIL_SOCKET_1;
#endif
    RLOGD("RIL_onUnsolicitedResponse %d\n",unsolResponse);
    // alway keeps a copy of NITZ URC so we can use it later.
    if (unsolResponse == RIL_UNSOL_NITZ_TIME_RECEIVED) {
        RLOGD("alway keeps a copy of NITZ URC so we can use it later");
        Parcel p;
        int64_t timeReceived = elapsedRealtime();
        int unsolResponseIndex = unsolResponse - RIL_UNSOL_RESPONSE_BASE;
        p.writeInt32 (RESPONSE_UNSOLICITED);
        p.writeInt32 (unsolResponse);
        int ret = -1;
        if (data != NULL) {
            Parcel *parcelUrc = (Parcel *) data;
            ret = p.appendFrom(parcelUrc,0,parcelUrc->dataSize());
        }
        if (ret == 0) {
            p.writeInt64(timeReceived);
            if (s_lastNITZTimeData != NULL) {
                free (s_lastNITZTimeData);
                s_lastNITZTimeData = NULL;
            }

            s_lastNITZTimeData = calloc(p.dataSize(), 1);
            if (s_lastNITZTimeData != NULL) {
                s_lastNITZTimeDataSize = p.dataSize();
                memcpy(s_lastNITZTimeData, p.data(), p.dataSize());
            } else {
                RLOGE("Memory allocation failed when keep nitz urc");
            }
        } else {
            RLOGE("responseFunction failed when keep nitz urc");
        }
    }
    /// support RILJ Client, and send URC to all the slot client @{
    for (int i = 0; i < NUM_ELEMS(s_ril_socket_params); i++) {
        /// since vendor ril using socket id, mapping to libril's slot id
        if (s_ril_socket_params[i]->socket_id == socId && s_fdCommand[socId] != -1) {
            RIL_onUnsolicitedResponseInternal(unsolResponse, data, datalen,
                    s_ril_socket_params[i]);
        }
    }
    /// @}
    int clientNum = getClientNum();
    for (int j = 0; j < clientNum; j++) {
        if (s_fdCommand_client[j] != -1 && s_ril_param_socket_clients[j].socket_id == socId) {
            RIL_onUnsolicitedResponseInternal(unsolResponse, data, datalen,
                    &s_ril_param_socket_clients[j]);
        }
    }
}

static void RIL_onUnsolicitedResponseInternal(int unsolResponse, const void *data,
                                      size_t datalen, SocketListenParam* socket_param) {
    int unsolResponseIndex;
    int ret = 0;
    int64_t timeReceived = 0;
    bool shouldScheduleTimeout = false;
    RIL_RadioState newState;
    RIL_SOCKET_ID soc_id = socket_param->socket_id;
    RIL_SLOT_ID slot_id = socket_param->slot_id;
    int clientId = socket_param->clientId;
    int fdCommand;

    if (s_registerCalled == 0) {
        // Ignore RIL_onUnsolicitedResponse before RIL_register
        RLOGW("RIL_onUnsolicitedResponse called before RIL_register");
        return;
    }

    if ((soc_id == RIL_SOCKET_RILJ || soc_id == RIL_SOCKET_RILJ2)
            && !isRiljEnable()) {
        /// ignore urc since rilj is not enable
        return;
    }

    unsolResponseIndex = unsolResponse - RIL_UNSOL_RESPONSE_BASE;

    if ((unsolResponseIndex < 0)
        || (unsolResponseIndex >= (int32_t)NUM_ELEMS(s_unsolResponses))) {
        //M: ril proxy
        if ((unsolResponse < RIL_UNSOL_VENDOR_BASE) ||
                ((unsolResponse >= RIL_UNSOL_VENDOR_BASE + (int32_t)NUM_ELEMS(s_mtk_unsolResponses)) &&
                        unsolResponse < RIL_UNSOL_VENDOR_IVT_BASE) ||
                (unsolResponse >= RIL_UNSOL_VENDOR_IVT_BASE + (int32_t)NUM_ELEMS(s_mtk_ivt_unsolResponses))) {
            RLOGE("unsupported unsolicited response code %d", unsolResponse);
            return;
        }
        //
    }

    // M: ril proxy
    fdCommand = findFd(soc_id, clientId);
    /// @}

    if (fdCommand == -1) {
        if (unsolResponse == RIL_UNSOL_NITZ_TIME_RECEIVED) {
            RLOGD("Use default cache to handle RIL_UNSOL_NITZ_TIME_RECEIVED");
        } else {
            RLOGD("Can't send URC because there is no connection yet."\
                    "Try to cache request:%s in RIL%s",
                    requestToString(unsolResponse), rilSocketIdToString(soc_id));
            pthread_mutex_lock(&s_pendingUrcMutex[soc_id]);
            cacheUrc(unsolResponse, data, datalen , soc_id);
            pthread_mutex_unlock(&s_pendingUrcMutex[soc_id]);
            return; //cahche then return
        }
    }
    //
    // Grab a wake lock if needed for this reponse,
    // as we exit we'll either release it immediately
    // or set a timer to release it later.
    // M: ril proxy
    WakeType wakeType;
    if (unsolResponse >= RIL_UNSOL_VENDOR_IVT_BASE) {
        RLOGD("RIL_onUnsolicitedResponse: ivt");
        unsolResponseIndex = unsolResponse - RIL_UNSOL_VENDOR_IVT_BASE;
        if (s_mtk_ivt_unsolResponses[unsolResponseIndex].responseFunction == NULL) {
            RLOGE("Need add response function to command table");
            return;
        }
        wakeType = s_mtk_ivt_unsolResponses[unsolResponseIndex].wakeType;
    } else if (unsolResponse >= RIL_UNSOL_VENDOR_BASE) {
        RLOGD("RIL_onUnsolicitedResponse: GSM/C2K");
        unsolResponseIndex = unsolResponse - RIL_UNSOL_VENDOR_BASE;
        if (s_mtk_unsolResponses[unsolResponseIndex].responseFunction == NULL) {
            RLOGE("Need add response function to command table");
            return;
        }
        wakeType = s_mtk_unsolResponses[unsolResponseIndex].wakeType;
    } else {
        RLOGD("RIL_onUnsolicitedResponse: default");
        if (s_unsolResponses[unsolResponseIndex].responseFunction == NULL) {
            RLOGE("Need add response function to command table");
            return;
        }
        wakeType = s_unsolResponses[unsolResponseIndex].wakeType;
    }
    //

    switch (wakeType) {
        case WAKE_PARTIAL:
            grabPartialWakeLock();
            shouldScheduleTimeout = true;
        break;

        case DONT_WAKE:
        default:
            // No wake lock is grabed so don't set timeout
            shouldScheduleTimeout = false;
            break;
    }

    // Mark the time this was received, doing this
    // after grabing the wakelock incase getting
    // the elapsedRealTime might cause us to goto
    // sleep.
    if (unsolResponse == RIL_UNSOL_NITZ_TIME_RECEIVED) {
        timeReceived = elapsedRealtime();
    }

    appendPrintBuf("[UNSL]< %s", requestToString(unsolResponse));

    Parcel p;
    //if (s_callbacks.version >= 13
    //            && s_unsolResponses[unsolResponseIndex].wakeType == WAKE_PARTIAL) {
    //    p.writeInt32 (RESPONSE_UNSOLICITED_ACK_EXP);
    //} else {
        p.writeInt32 (RESPONSE_UNSOLICITED);
    //}
    p.writeInt32 (unsolResponse);

#if 0
    /// M: ril proxy
    if (unsolResponse >= RIL_UNSOL_VENDOR_IVT_BASE) {
        ret = s_mtk_ivt_unsolResponses[unsolResponseIndex]
                                       .responseFunction(p, const_cast<void*>(data), datalen);
    }
    else if (unsolResponse >= RIL_UNSOL_VENDOR_BASE) {
        ret = s_mtk_unsolResponses[unsolResponseIndex]
                .responseFunction(p, const_cast<void*>(data), datalen);
    } else {
        ret = s_unsolResponses[unsolResponseIndex]
                .responseFunction(p, const_cast<void*>(data), datalen);
    }
#else
    if (data != NULL) {
        Parcel *parcelUrc = (Parcel *) data;
        ret = p.appendFrom(parcelUrc,0,parcelUrc->dataSize());
    }
#endif
    if (ret != 0) {
        RLOGI("RIL_onUnsolicitedResponse ret %d", ret);
        // Problem with the response. Don't continue;
        goto error_exit;
    }

    // some things get more payload
    switch(unsolResponse) {
        case RIL_UNSOL_RESPONSE_RADIO_STATE_CHANGED:
            /// Add mutex to avoid async error when handle this unsolResponse.@{
            /// Such as radio state off send before unavailable.
            pthread_mutex_lock(&s_state_mutex[soc_id]);
            /// @}

            newState = CALL_ONSTATEREQUEST(soc_id);
            p.writeInt32(newState);
            appendPrintBuf("%s {%s}", printBuf, radioStateToString(CALL_ONSTATEREQUEST(soc_id)));
        break;


        case RIL_UNSOL_NITZ_TIME_RECEIVED:
            // Store the time that this was received so the
            // handler of this message can account for
            // the time it takes to arrive and process. In
            // particular the system has been known to sleep
            // before this message can be processed.
            p.writeInt64(timeReceived);
        break;
    }

    if (s_callbacks.version < 13) {
        if (shouldScheduleTimeout) {
            UserCallbackInfo *p_info = internalRequestTimedCallback(wakeTimeoutCallback, NULL,
                    &TIMEVAL_WAKE_TIMEOUT);

            if (p_info == NULL) {
                /// relase state lock @{
                if (unsolResponse == RIL_UNSOL_RESPONSE_RADIO_STATE_CHANGED) {
                    pthread_mutex_unlock(&s_state_mutex[soc_id]);
                }
                /// @}
                goto error_exit;
            } else {
                // Cancel the previous request
                if (s_last_wake_timeout_info != NULL) {
                    s_last_wake_timeout_info->userParam = (void *)1;
                }
                s_last_wake_timeout_info = p_info;
            }
        }
    }

#if VDBG
    RLOGI("%s UNSOLICITED: %s length:%d", rilSocketIdToString(soc_id), requestToString(unsolResponse), p.dataSize());
#endif
    ret = sendResponse(p, soc_id, socket_param->clientId);

    /// release state lock @{
    if (unsolResponse == RIL_UNSOL_RESPONSE_RADIO_STATE_CHANGED) {
        pthread_mutex_unlock(&s_state_mutex[soc_id]);
    }
    /// @}

    if (ret != 0 && unsolResponse == RIL_UNSOL_NITZ_TIME_RECEIVED) {

        // Unfortunately, NITZ time is not poll/update like everything
        // else in the system. So, if the upstream client isn't connected,
        // keep a copy of the last NITZ response (with receive time noted
        // above) around so we can deliver it when it is connected

        if (s_lastNITZTimeData != NULL) {
            free (s_lastNITZTimeData);
            s_lastNITZTimeData = NULL;
        }

        s_lastNITZTimeData = calloc(p.dataSize(), 1);
        if (s_lastNITZTimeData == NULL) {
             RLOGE("Memory allocation failed in RIL_onUnsolicitedResponse");
             goto error_exit;
        }
        s_lastNITZTimeDataSize = p.dataSize();
        memcpy(s_lastNITZTimeData, p.data(), p.dataSize());
    }

    // Normal exit
    return;

error_exit:

    if (shouldScheduleTimeout) {
        releaseWakeLock();
    }
}

/** FIXME generalize this if you track UserCAllbackInfo, clear it
    when the callback occurs
*/
static UserCallbackInfo *
internalRequestTimedCallback (RIL_TimedCallback callback, void *param,
                                const struct timeval *relativeTime)
{
    struct timeval myRelativeTime;
    UserCallbackInfo *p_info;

    p_info = (UserCallbackInfo *) calloc(1, sizeof(UserCallbackInfo));
    if (p_info == NULL) {
        RLOGE("Memory allocation failed in internalRequestTimedCallback");
        return p_info;

    }

    p_info->p_callback = callback;
    p_info->userParam = param;

    if (relativeTime == NULL) {
        /* treat null parameter as a 0 relative time */
        memset (&myRelativeTime, 0, sizeof(myRelativeTime));
    } else {
        /* FIXME I think event_add's tv param is really const anyway */
        memcpy (&myRelativeTime, relativeTime, sizeof(myRelativeTime));
    }

    ril_event_set(&(p_info->event), -1, false, userTimerCallback, p_info);

    ril_timer_add(&(p_info->event), &myRelativeTime);

    triggerEvLoop();
    return p_info;
}


extern "C" void
RIL_requestTimedCallback (RIL_TimedCallback callback, void *param,
                                const struct timeval *relativeTime) {
    internalRequestTimedCallback (callback, param, relativeTime);
}

const char *
failCauseToString(RIL_Errno e) {
    switch(e) {
        case RIL_E_SUCCESS: return "E_SUCCESS";
        case RIL_E_RADIO_NOT_AVAILABLE: return "E_RADIO_NOT_AVAILABLE";
        case RIL_E_GENERIC_FAILURE: return "E_GENERIC_FAILURE";
        case RIL_E_PASSWORD_INCORRECT: return "E_PASSWORD_INCORRECT";
        case RIL_E_SIM_PIN2: return "E_SIM_PIN2";
        case RIL_E_SIM_PUK2: return "E_SIM_PUK2";
        case RIL_E_REQUEST_NOT_SUPPORTED: return "E_REQUEST_NOT_SUPPORTED";
        case RIL_E_CANCELLED: return "E_CANCELLED";
        case RIL_E_OP_NOT_ALLOWED_DURING_VOICE_CALL: return "E_OP_NOT_ALLOWED_DURING_VOICE_CALL";
        case RIL_E_OP_NOT_ALLOWED_BEFORE_REG_TO_NW: return "E_OP_NOT_ALLOWED_BEFORE_REG_TO_NW";
        case RIL_E_SMS_SEND_FAIL_RETRY: return "E_SMS_SEND_FAIL_RETRY";
        case RIL_E_SIM_ABSENT:return "E_SIM_ABSENT";
        case RIL_E_ILLEGAL_SIM_OR_ME:return "E_ILLEGAL_SIM_OR_ME";
#ifdef FEATURE_MULTIMODE_ANDROID
        case RIL_E_SUBSCRIPTION_NOT_AVAILABLE:return "E_SUBSCRIPTION_NOT_AVAILABLE";
        case RIL_E_MODE_NOT_SUPPORTED:return "E_MODE_NOT_SUPPORTED";
#endif
        case RIL_E_FDN_CHECK_FAILURE: return "E_FDN_CHECK_FAILURE";
        case RIL_E_MISSING_RESOURCE: return "E_MISSING_RESOURCE";
        case RIL_E_NO_SUCH_ELEMENT: return "E_NO_SUCH_ELEMENT";
        case RIL_E_DIAL_MODIFIED_TO_USSD: return "E_DIAL_MODIFIED_TO_USSD";
        case RIL_E_DIAL_MODIFIED_TO_SS: return "E_DIAL_MODIFIED_TO_SS";
        case RIL_E_DIAL_MODIFIED_TO_DIAL: return "E_DIAL_MODIFIED_TO_DIAL";
        case RIL_E_USSD_MODIFIED_TO_DIAL: return "E_USSD_MODIFIED_TO_DIAL";
        case RIL_E_USSD_MODIFIED_TO_SS: return "E_USSD_MODIFIED_TO_SS";
        case RIL_E_USSD_MODIFIED_TO_USSD: return "E_USSD_MODIFIED_TO_USSD";
        case RIL_E_SS_MODIFIED_TO_DIAL: return "E_SS_MODIFIED_TO_DIAL";
        case RIL_E_SS_MODIFIED_TO_USSD: return "E_SS_MODIFIED_TO_USSD";
        case RIL_E_SUBSCRIPTION_NOT_SUPPORTED: return "E_SUBSCRIPTION_NOT_SUPPORTED";
        case RIL_E_SS_MODIFIED_TO_SS: return "E_SS_MODIFIED_TO_SS";
        case RIL_E_LCE_NOT_SUPPORTED: return "E_LCE_NOT_SUPPORTED";
        case RIL_E_NO_MEMORY: return "E_NO_MEMORY";
        case RIL_E_INTERNAL_ERR: return "E_INTERNAL_ERR";
        case RIL_E_SYSTEM_ERR: return "E_SYSTEM_ERR";
        case RIL_E_MODEM_ERR: return "E_MODEM_ERR";
        case RIL_E_INVALID_STATE: return "E_INVALID_STATE";
        case RIL_E_NO_RESOURCES: return "E_NO_RESOURCES";
        case RIL_E_SIM_ERR: return "E_SIM_ERR";
        case RIL_E_INVALID_ARGUMENTS: return "E_INVALID_ARGUMENTS";
        case RIL_E_INVALID_SIM_STATE: return "E_INVALID_SIM_STATE";
        case RIL_E_INVALID_MODEM_STATE: return "E_INVALID_MODEM_STATE";
        case RIL_E_INVALID_CALL_ID: return "E_INVALID_CALL_ID";
        case RIL_E_NO_SMS_TO_ACK: return "E_NO_SMS_TO_ACK";
        case RIL_E_NETWORK_ERR: return "E_NETWORK_ERR";
        case RIL_E_REQUEST_RATE_LIMITED: return "E_REQUEST_RATE_LIMITED";
        case RIL_E_SIM_BUSY: return "E_SIM_BUSY";
        case RIL_E_SIM_FULL: return "E_SIM_FULL";
        case RIL_E_NETWORK_REJECT: return "E_NETWORK_REJECT";
        case RIL_E_OPERATION_NOT_ALLOWED: return "E_OPERATION_NOT_ALLOWED";
        case RIL_E_EMPTY_RECORD: "E_EMPTY_RECORD";
        case RIL_E_INVALID_SMS_FORMAT: return "E_INVALID_SMS_FORMAT";
        case RIL_E_ENCODING_ERR: return "E_ENCODING_ERR";
        case RIL_E_INVALID_SMSC_ADDRESS: return "E_INVALID_SMSC_ADDRESS";
        case RIL_E_NO_SUCH_ENTRY: return "E_NO_SUCH_ENTRY";
        case RIL_E_NETWORK_NOT_READY: return "E_NETWORK_NOT_READY";
        case RIL_E_NOT_PROVISIONED: return "E_NOT_PROVISIONED";
        case RIL_E_NO_SUBSCRIPTION: return "E_NO_SUBSCRIPTION";
        case RIL_E_NO_NETWORK_FOUND: return "E_NO_NETWORK_FOUND";
        case RIL_E_DEVICE_IN_USE: return "E_DEVICE_IN_USE";
        case RIL_E_ABORTED: return "E_ABORTED";
        case RIL_E_OEM_ERROR_1: return "E_OEM_ERROR_1";
        case RIL_E_OEM_ERROR_2: return "E_OEM_ERROR_2";
        case RIL_E_OEM_ERROR_3: return "E_OEM_ERROR_3";
        case RIL_E_OEM_ERROR_4: return "E_OEM_ERROR_4";
        case RIL_E_OEM_ERROR_5: return "E_OEM_ERROR_5";
        case RIL_E_OEM_ERROR_6: return "E_OEM_ERROR_6";
        case RIL_E_OEM_ERROR_7: return "E_OEM_ERROR_7";
        case RIL_E_OEM_ERROR_8: return "E_OEM_ERROR_8";
        case RIL_E_OEM_ERROR_9: return "E_OEM_ERROR_9";
        case RIL_E_OEM_ERROR_10: return "E_OEM_ERROR_10";
        case RIL_E_OEM_ERROR_11: return "E_OEM_ERROR_11";
        case RIL_E_OEM_ERROR_12: return "E_OEM_ERROR_12";
        case RIL_E_OEM_ERROR_13: return "E_OEM_ERROR_13";
        case RIL_E_OEM_ERROR_14: return "E_OEM_ERROR_14";
        case RIL_E_OEM_ERROR_15: return "E_OEM_ERROR_15";
        case RIL_E_OEM_ERROR_16: return "E_OEM_ERROR_16";
        case RIL_E_OEM_ERROR_17: return "E_OEM_ERROR_17";
        case RIL_E_OEM_ERROR_18: return "E_OEM_ERROR_18";
        case RIL_E_OEM_ERROR_19: return "E_OEM_ERROR_19";
        case RIL_E_OEM_ERROR_20: return "E_OEM_ERROR_20";
        case RIL_E_OEM_ERROR_21: return "E_OEM_ERROR_21";
        case RIL_E_OEM_ERROR_22: return "E_OEM_ERROR_22";
        case RIL_E_OEM_ERROR_23: return "E_OEM_ERROR_23";
        case RIL_E_OEM_ERROR_24: return "E_OEM_ERROR_24";
        case RIL_E_OEM_ERROR_25: return "E_OEM_ERROR_25";
        default: return "<unknown error>";
    }
}

const char *
callStateToString(RIL_CallState s) {
    switch(s) {
        case RIL_CALL_ACTIVE : return "ACTIVE";
        case RIL_CALL_HOLDING: return "HOLDING";
        case RIL_CALL_DIALING: return "DIALING";
        case RIL_CALL_ALERTING: return "ALERTING";
        case RIL_CALL_INCOMING: return "INCOMING";
        case RIL_CALL_WAITING: return "WAITING";
        default: return "<unknown state>";
    }
}

const char *
requestToString(int request) {
/*
 cat libs/telephony/ril_commands.h \
 | egrep "^ *{RIL_" \
 | sed -re 's/\{RIL_([^,]+),[^,]+,([^}]+).+/case RIL_\1: return "\1";/'


 cat libs/telephony/ril_unsol_commands.h \
 | egrep "^ *{RIL_" \
 | sed -re 's/\{RIL_([^,]+),([^}]+).+/case RIL_\1: return "\1";/'

*/
    switch(request) {
        case RIL_REQUEST_GET_SIM_STATUS: return "GET_SIM_STATUS";
        case RIL_REQUEST_ENTER_SIM_PIN: return "ENTER_SIM_PIN";
        case RIL_REQUEST_ENTER_SIM_PUK: return "ENTER_SIM_PUK";
        case RIL_REQUEST_ENTER_SIM_PIN2: return "ENTER_SIM_PIN2";
        case RIL_REQUEST_ENTER_SIM_PUK2: return "ENTER_SIM_PUK2";
        case RIL_REQUEST_CHANGE_SIM_PIN: return "CHANGE_SIM_PIN";
        case RIL_REQUEST_CHANGE_SIM_PIN2: return "CHANGE_SIM_PIN2";
        case RIL_REQUEST_ENTER_NETWORK_DEPERSONALIZATION: return "ENTER_NETWORK_DEPERSONALIZATION";
        case RIL_REQUEST_GET_CURRENT_CALLS: return "GET_CURRENT_CALLS";
        case RIL_REQUEST_DIAL: return "DIAL";
        case RIL_REQUEST_GET_IMSI: return "GET_IMSI";
        case RIL_REQUEST_HANGUP: return "HANGUP";
        case RIL_REQUEST_HANGUP_WAITING_OR_BACKGROUND: return "HANGUP_WAITING_OR_BACKGROUND";
        case RIL_REQUEST_HANGUP_FOREGROUND_RESUME_BACKGROUND: return "HANGUP_FOREGROUND_RESUME_BACKGROUND";
        case RIL_REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE: return "SWITCH_WAITING_OR_HOLDING_AND_ACTIVE";
        case RIL_REQUEST_CONFERENCE: return "CONFERENCE";
        case RIL_REQUEST_UDUB: return "UDUB";
        case RIL_REQUEST_LAST_CALL_FAIL_CAUSE: return "LAST_CALL_FAIL_CAUSE";
        case RIL_REQUEST_SIGNAL_STRENGTH: return "SIGNAL_STRENGTH";
        case RIL_REQUEST_VOICE_REGISTRATION_STATE: return "VOICE_REGISTRATION_STATE";
        case RIL_REQUEST_DATA_REGISTRATION_STATE: return "DATA_REGISTRATION_STATE";
        case RIL_REQUEST_OPERATOR: return "OPERATOR";
        case RIL_REQUEST_RADIO_POWER: return "RADIO_POWER";
        case RIL_REQUEST_DTMF: return "DTMF";
        case RIL_REQUEST_SEND_SMS: return "SEND_SMS";
        case RIL_REQUEST_SEND_SMS_EXPECT_MORE: return "SEND_SMS_EXPECT_MORE";
        case RIL_REQUEST_SETUP_DATA_CALL: return "SETUP_DATA_CALL";
        case RIL_REQUEST_SIM_IO: return "SIM_IO";
        case RIL_REQUEST_SEND_USSD: return "SEND_USSD";
        case RIL_REQUEST_CANCEL_USSD: return "CANCEL_USSD";
        case RIL_REQUEST_GET_CLIR: return "GET_CLIR";
        case RIL_REQUEST_SET_CLIR: return "SET_CLIR";
        case RIL_REQUEST_QUERY_CALL_FORWARD_STATUS: return "QUERY_CALL_FORWARD_STATUS";
        case RIL_REQUEST_SET_CALL_FORWARD: return "SET_CALL_FORWARD";
        case RIL_REQUEST_QUERY_CALL_WAITING: return "QUERY_CALL_WAITING";
        case RIL_REQUEST_SET_CALL_WAITING: return "SET_CALL_WAITING";
        case RIL_REQUEST_SMS_ACKNOWLEDGE: return "SMS_ACKNOWLEDGE";
        case RIL_REQUEST_GET_IMEI: return "GET_IMEI";
        case RIL_REQUEST_GET_IMEISV: return "GET_IMEISV";
        case RIL_REQUEST_ANSWER: return "ANSWER";
        case RIL_REQUEST_DEACTIVATE_DATA_CALL: return "DEACTIVATE_DATA_CALL";
        case RIL_REQUEST_QUERY_FACILITY_LOCK: return "QUERY_FACILITY_LOCK";
        case RIL_REQUEST_SET_FACILITY_LOCK: return "SET_FACILITY_LOCK";
        case RIL_REQUEST_CHANGE_BARRING_PASSWORD: return "CHANGE_BARRING_PASSWORD";
        case RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE: return "QUERY_NETWORK_SELECTION_MODE";
        case RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC: return "SET_NETWORK_SELECTION_AUTOMATIC";
        case RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL: return "SET_NETWORK_SELECTION_MANUAL";
        case RIL_REQUEST_QUERY_AVAILABLE_NETWORKS : return "QUERY_AVAILABLE_NETWORKS";
        case RIL_REQUEST_DTMF_START: return "DTMF_START";
        case RIL_REQUEST_DTMF_STOP: return "DTMF_STOP";
        case RIL_REQUEST_BASEBAND_VERSION: return "BASEBAND_VERSION";
        case RIL_REQUEST_SEPARATE_CONNECTION: return "SEPARATE_CONNECTION";
        case RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE: return "SET_PREFERRED_NETWORK_TYPE";
        case RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE: return "GET_PREFERRED_NETWORK_TYPE";
        case RIL_REQUEST_GET_NEIGHBORING_CELL_IDS: return "GET_NEIGHBORING_CELL_IDS";
        case RIL_REQUEST_SET_MUTE: return "SET_MUTE";
        case RIL_REQUEST_GET_MUTE: return "GET_MUTE";
        case RIL_REQUEST_QUERY_CLIP: return "QUERY_CLIP";
        case RIL_REQUEST_LAST_DATA_CALL_FAIL_CAUSE: return "LAST_DATA_CALL_FAIL_CAUSE";
        case RIL_REQUEST_DATA_CALL_LIST: return "DATA_CALL_LIST";
        case RIL_REQUEST_NV_RESET_CONFIG: return "NV_RESET_CONFIG";
        case RIL_REQUEST_RESET_RADIO: return "RESET_RADIO";
        case RIL_REQUEST_OEM_HOOK_RAW: return "OEM_HOOK_RAW";
        case RIL_REQUEST_OEM_HOOK_STRINGS: return "OEM_HOOK_STRINGS";
        case RIL_REQUEST_SET_BAND_MODE: return "SET_BAND_MODE";
        case RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE: return "QUERY_AVAILABLE_BAND_MODE";
        case RIL_REQUEST_STK_GET_PROFILE: return "STK_GET_PROFILE";
        case RIL_REQUEST_STK_SET_PROFILE: return "STK_SET_PROFILE";
        case RIL_REQUEST_STK_SEND_ENVELOPE_COMMAND: return "STK_SEND_ENVELOPE_COMMAND";
        case RIL_REQUEST_STK_SEND_TERMINAL_RESPONSE: return "STK_SEND_TERMINAL_RESPONSE";
        case RIL_REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM: return "STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM";
        case RIL_REQUEST_SCREEN_STATE: return "SCREEN_STATE";
        case RIL_REQUEST_EXPLICIT_CALL_TRANSFER: return "EXPLICIT_CALL_TRANSFER";
        case RIL_REQUEST_SET_LOCATION_UPDATES: return "SET_LOCATION_UPDATES";
        case RIL_REQUEST_CDMA_SET_SUBSCRIPTION_SOURCE:return"CDMA_SET_SUBSCRIPTION_SOURCE";
        case RIL_REQUEST_CDMA_SET_ROAMING_PREFERENCE:return"CDMA_SET_ROAMING_PREFERENCE";
        case RIL_REQUEST_CDMA_QUERY_ROAMING_PREFERENCE:return"CDMA_QUERY_ROAMING_PREFERENCE";
        case RIL_REQUEST_SET_TTY_MODE:return"SET_TTY_MODE";
        case RIL_REQUEST_QUERY_TTY_MODE:return"QUERY_TTY_MODE";
        case RIL_REQUEST_CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE:return"CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE";
        case RIL_REQUEST_CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE:return"CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE";
        case RIL_REQUEST_CDMA_FLASH:return"CDMA_FLASH";
        case RIL_REQUEST_CDMA_BURST_DTMF:return"CDMA_BURST_DTMF";
        case RIL_REQUEST_CDMA_SEND_SMS:return"CDMA_SEND_SMS";
        case RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE:return"CDMA_SMS_ACKNOWLEDGE";
        case RIL_REQUEST_GSM_GET_BROADCAST_SMS_CONFIG:return"GSM_GET_BROADCAST_SMS_CONFIG";
        case RIL_REQUEST_GSM_SET_BROADCAST_SMS_CONFIG:return"GSM_SET_BROADCAST_SMS_CONFIG";
        case RIL_REQUEST_CDMA_GET_BROADCAST_SMS_CONFIG:return "CDMA_GET_BROADCAST_SMS_CONFIG";
        case RIL_REQUEST_CDMA_SET_BROADCAST_SMS_CONFIG:return "CDMA_SET_BROADCAST_SMS_CONFIG";
        case RIL_REQUEST_CDMA_SMS_BROADCAST_ACTIVATION:return "CDMA_SMS_BROADCAST_ACTIVATION";
        case RIL_REQUEST_CDMA_VALIDATE_AND_WRITE_AKEY: return"CDMA_VALIDATE_AND_WRITE_AKEY";
        case RIL_REQUEST_CDMA_SUBSCRIPTION: return"CDMA_SUBSCRIPTION";
        case RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM: return "CDMA_WRITE_SMS_TO_RUIM";
        case RIL_REQUEST_CDMA_DELETE_SMS_ON_RUIM: return "CDMA_DELETE_SMS_ON_RUIM";
        case RIL_REQUEST_DEVICE_IDENTITY: return "DEVICE_IDENTITY";
        case RIL_REQUEST_EXIT_EMERGENCY_CALLBACK_MODE: return "EXIT_EMERGENCY_CALLBACK_MODE";
        case RIL_REQUEST_GET_SMSC_ADDRESS: return "GET_SMSC_ADDRESS";
        case RIL_REQUEST_SET_SMSC_ADDRESS: return "SET_SMSC_ADDRESS";
        case RIL_REQUEST_REPORT_SMS_MEMORY_STATUS: return "REPORT_SMS_MEMORY_STATUS";
        case RIL_REQUEST_GET_SMS_SIM_MEM_STATUS: return "GET_SMS_SIM_MEM_STATUS";
        case RIL_REQUEST_GSM_GET_BROADCAST_LANGUAGE: return "GSM_GET_BROADCAST_LANGUAGE";
        case RIL_REQUEST_GSM_SET_BROADCAST_LANGUAGE: return "GSM_SET_BROADCAST_LANGUAGE";
        case RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING: return "REPORT_STK_SERVICE_IS_RUNNING";
        case RIL_REQUEST_CDMA_GET_SUBSCRIPTION_SOURCE: return "CDMA_GET_SUBSCRIPTION_SOURCE";
        case RIL_REQUEST_ISIM_AUTHENTICATION: return "ISIM_AUTHENTICATION";
        case RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU: return "RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU";
        case RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS: return "RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS";
        case RIL_REQUEST_VOICE_RADIO_TECH: return "VOICE_RADIO_TECH";
        case RIL_REQUEST_WRITE_SMS_TO_SIM: return "WRITE_SMS_TO_SIM";
        case RIL_REQUEST_GET_CELL_INFO_LIST: return"GET_CELL_INFO_LIST";
        case RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE: return"SET_UNSOL_CELL_INFO_LIST_RATE";
        case RIL_REQUEST_SET_INITIAL_ATTACH_APN: return "RIL_REQUEST_SET_INITIAL_ATTACH_APN";
        case RIL_REQUEST_IMS_REGISTRATION_STATE: return "IMS_REGISTRATION_STATE";
        case RIL_REQUEST_IMS_SEND_SMS: return "IMS_SEND_SMS";
        case RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC: return "SIM_TRANSMIT_APDU_BASIC";
        case RIL_REQUEST_SIM_OPEN_CHANNEL: return "SIM_OPEN_CHANNEL";
        case RIL_REQUEST_SIM_CLOSE_CHANNEL: return "SIM_CLOSE_CHANNEL";
        case RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL: return "SIM_TRANSMIT_APDU_CHANNEL";
        case RIL_REQUEST_GET_RADIO_CAPABILITY: return "RIL_REQUEST_GET_RADIO_CAPABILITY";
        case RIL_REQUEST_SET_RADIO_CAPABILITY: return "RIL_REQUEST_SET_RADIO_CAPABILITY";
        case RIL_REQUEST_SET_UICC_SUBSCRIPTION: return "SET_UICC_SUBSCRIPTION";
        case RIL_REQUEST_ALLOW_DATA: return "ALLOW_DATA";
        case RIL_REQUEST_GET_HARDWARE_CONFIG: return "GET_HARDWARE_CONFIG";
        case RIL_REQUEST_SIM_AUTHENTICATION: return "SIM_AUTHENTICATION";
        case RIL_REQUEST_GET_DC_RT_INFO: return "GET_DC_RT_INFO";
        case RIL_REQUEST_SET_DC_RT_INFO_RATE: return "SET_DC_RT_INFO_RATE";
        case RIL_REQUEST_SET_DATA_PROFILE: return "SET_DATA_PROFILE";
        case RIL_REQUEST_SET_CARRIER_RESTRICTIONS: return "SET_CARRIER_RESTRICTIONS";
        case RIL_REQUEST_GET_CARRIER_RESTRICTIONS: return "GET_CARRIER_RESTRICTIONS";
        // case RIL_REQUEST_SET_PSEUDO_BS_ENABLE: return "SET_PSEUDO_BS_ENABLE";
        // case RIL_REQUEST_GET_PSEUDO_BS_RECORDS: return "GET_PSEUDO_BS_RECORDS";
        case RIL_REQUEST_IMS_BEARER_ACTIVATION_DONE: return "RIL_REQUEST_IMS_BEARER_ACTIVATION_DONE";
        case RIL_REQUEST_IMS_BEARER_DEACTIVATION_DONE: return "RIL_REQUEST_IMS_BEARER_DEACTIVATION_DONE";
        case RIL_UNSOL_RESPONSE_RADIO_STATE_CHANGED: return "UNSOL_RESPONSE_RADIO_STATE_CHANGED";
        case RIL_UNSOL_RESPONSE_CALL_STATE_CHANGED: return "UNSOL_RESPONSE_CALL_STATE_CHANGED";
        case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED: return "UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED";
        case RIL_UNSOL_RESPONSE_NEW_SMS: return "UNSOL_RESPONSE_NEW_SMS";
        case RIL_UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT: return "UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT";
        case RIL_UNSOL_RESPONSE_NEW_SMS_ON_SIM: return "UNSOL_RESPONSE_NEW_SMS_ON_SIM";
        case RIL_UNSOL_ON_USSD: return "UNSOL_ON_USSD";
        case RIL_UNSOL_ON_USSD_REQUEST: return "UNSOL_ON_USSD_REQUEST(obsolete)";
        case RIL_UNSOL_NITZ_TIME_RECEIVED: return "UNSOL_NITZ_TIME_RECEIVED";
        case RIL_UNSOL_SIGNAL_STRENGTH: return "UNSOL_SIGNAL_STRENGTH";
        case RIL_UNSOL_SUPP_SVC_NOTIFICATION: return "UNSOL_SUPP_SVC_NOTIFICATION";
        case RIL_UNSOL_STK_SESSION_END: return "UNSOL_STK_SESSION_END";
        case RIL_UNSOL_STK_PROACTIVE_COMMAND: return "UNSOL_STK_PROACTIVE_COMMAND";
        case RIL_UNSOL_STK_EVENT_NOTIFY: return "UNSOL_STK_EVENT_NOTIFY";
        case RIL_UNSOL_STK_CALL_SETUP: return "UNSOL_STK_CALL_SETUP";
        case RIL_UNSOL_SIM_SMS_STORAGE_FULL: return "UNSOL_SIM_SMS_STORAGE_FUL";
        case RIL_UNSOL_SIM_REFRESH: return "UNSOL_SIM_REFRESH";
        case RIL_UNSOL_DATA_CALL_LIST_CHANGED: return "UNSOL_DATA_CALL_LIST_CHANGED";
        case RIL_UNSOL_CALL_RING: return "UNSOL_CALL_RING";
        case RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED: return "UNSOL_RESPONSE_SIM_STATUS_CHANGED";
        case RIL_UNSOL_RESPONSE_CDMA_NEW_SMS: return "UNSOL_NEW_CDMA_SMS";
        case RIL_UNSOL_RESPONSE_NEW_BROADCAST_SMS: return "UNSOL_NEW_BROADCAST_SMS";
        case RIL_UNSOL_CDMA_RUIM_SMS_STORAGE_FULL: return "UNSOL_CDMA_RUIM_SMS_STORAGE_FULL";
        case RIL_UNSOL_RESTRICTED_STATE_CHANGED: return "UNSOL_RESTRICTED_STATE_CHANGED";
        case RIL_UNSOL_ENTER_EMERGENCY_CALLBACK_MODE: return "UNSOL_ENTER_EMERGENCY_CALLBACK_MODE";
        case RIL_UNSOL_CDMA_CALL_WAITING: return "UNSOL_CDMA_CALL_WAITING";
        case RIL_UNSOL_CDMA_OTA_PROVISION_STATUS: return "UNSOL_CDMA_OTA_PROVISION_STATUS";
        case RIL_UNSOL_CDMA_INFO_REC: return "UNSOL_CDMA_INFO_REC";
        case RIL_UNSOL_OEM_HOOK_RAW: return "UNSOL_OEM_HOOK_RAW";
        case RIL_UNSOL_RINGBACK_TONE: return "UNSOL_RINGBACK_TONE";
        case RIL_UNSOL_RESEND_INCALL_MUTE: return "UNSOL_RESEND_INCALL_MUTE";
        case RIL_UNSOL_CDMA_SUBSCRIPTION_SOURCE_CHANGED: return "UNSOL_CDMA_SUBSCRIPTION_SOURCE_CHANGED";
        case RIL_UNSOL_CDMA_PRL_CHANGED: return "UNSOL_CDMA_PRL_CHANGED";
        case RIL_UNSOL_EXIT_EMERGENCY_CALLBACK_MODE: return "UNSOL_EXIT_EMERGENCY_CALLBACK_MODE";
        case RIL_UNSOL_RIL_CONNECTED: return "UNSOL_RIL_CONNECTED";
        case RIL_UNSOL_VOICE_RADIO_TECH_CHANGED: return "UNSOL_VOICE_RADIO_TECH_CHANGED";
        case RIL_UNSOL_CELL_INFO_LIST: return "UNSOL_CELL_INFO_LIST";
        case RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED: return "RESPONSE_IMS_NETWORK_STATE_CHANGED";
        case RIL_UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED: return "UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED";
        case RIL_UNSOL_SRVCC_STATE_NOTIFY: return "UNSOL_SRVCC_STATE_NOTIFY";
        case RIL_UNSOL_HARDWARE_CONFIG_CHANGED: return "HARDWARE_CONFIG_CHANGED";
        case RIL_UNSOL_DC_RT_INFO_CHANGED: return "UNSOL_DC_RT_INFO_CHANGED";
        case RIL_REQUEST_SHUTDOWN: return "SHUTDOWN";
        case RIL_UNSOL_RADIO_CAPABILITY: return "RIL_UNSOL_RADIO_CAPABILITY";
        case RIL_RESPONSE_ACKNOWLEDGEMENT: return "RIL_RESPONSE_ACKNOWLEDGEMENT";
        case RIL_UNSOL_PCO_DATA: return "RIL_UNSOL_PCO_DATA";
        // case RIL_UNSOL_PSEUDO_BS_INFO_LIST: return "UNSOL_PSEUDO_BS_INFO_LIST";
        case RIL_REQUEST_SET_SUPP_SVC_NOTIFICATION: return "RIL_REQUEST_SET_SUPP_SVC_NOTIFICATION";
        case RIL_REQUEST_SET_COLR: return "RIL_REQUEST_SET_COLR";
        case RIL_REQUEST_GET_COLP: return "RIL_REQUEST_GET_COLP";
        case RIL_REQUEST_GET_COLR: return "RIL_REQUEST_GET_COLR";
        case RIL_REQUEST_SET_CLIP: return "RIL_REQUEST_SET_CLIP";
        case RIL_REQUEST_SET_COLP: return "RIL_REQUEST_SET_COLP";
        case RIL_REQUEST_QUERY_CALL_FORWARD_IN_TIME_SLOT: return "RIL_REQUEST_QUERY_CALL_FORWARD_IN_TIME_SLOT";
        case RIL_REQUEST_SET_CALL_FORWARD_IN_TIME_SLOT: return "RIL_REQUEST_SET_CALL_FORWARD_IN_TIME_SLOT";
        case RIL_REQUEST_RUN_GBA: return "RIL_REQUEST_RUN_GBA";
        case RIL_UNSOL_IMS_BEARER_ACTIVATION: return "RIL_UNSOL_IMS_BEARER_ACTIVATION";
        case RIL_UNSOL_IMS_BEARER_DEACTIVATION: return "RIL_UNSOL_IMS_BEARER_DEACTIVATION";
        case RIL_UNSOL_IMS_BEARER_INIT: return "RIL_UNSOL_IMS_BEARER_INIT";
        // case RIL_REQUEST_SETUP_DATA_CALL_ALT: return "RIL_REQUEST_SETUP_DATA_CALL_ALT";
        // case RIL_REQUEST_LAST_DATA_CALL_FAIL_CAUSE_ALT: return "RIL_REQUEST_LAST_DATA_CALL_FAIL_CAUSE_ALT";
        // case RIL_REQUEST_PCSCF_DISCOVERY_PCO_ALT: return "RIL_REQUEST_PCSCF_DISCOVERY_PCO_ALT";
        case RIL_REQUEST_SET_MD_IMSCFG: return "RIL_REQUEST_SET_MD_IMSCFG";
        // case RIL_REQUEST_SET_IMS_EVS_ENABLE : return "RIL_REQUEST_SET_IMS_EVS_ENABLE";
        default: return mtkRequestToString(request);
    }
}

const char *
rilSocketIdToString(RIL_SOCKET_ID socket_id)
{
    switch(socket_id) {
        case RIL_SOCKET_1:
            return "RIL_SOCKET_1";
        case RIL_SOCKET_2:
            return "RIL_SOCKET_2";
        case RIL_SOCKET_3:
            return "RIL_SOCKET_3";
        case RIL_SOCKET_4:
            return "RIL_SOCKET_4";
        case RIL_SOCKET_RILJ:
            return SOCKET_NAME_RILJCLIENT;
        case RIL_SOCKET_RILJ2:
            return SOCKET2_NAME_RILJCLIENT;
        default:
            return "not a valid RIL";
    }
}

// M: ril proxy
void cacheUrc(int unsolResponse, const void *data, size_t datalen, RIL_SOCKET_ID socket_id){
    //Only the URC list we wanted.
    if (unsolResponse != RIL_UNSOL_STK_PROACTIVE_COMMAND
        && unsolResponse != RIL_UNSOL_STK_EVENT_NOTIFY
        && unsolResponse != RIL_UNSOL_CALL_FORWARDING
        && unsolResponse != RIL_UNSOL_SMS_READY_NOTIFICATION
        && unsolResponse != RIL_UNSOL_IMEI_LOCK
        && unsolResponse != RIL_UNSOL_PHB_READY_NOTIFICATION
        && unsolResponse != RIL_UNSOL_SIM_SMS_STORAGE_FULL
        && unsolResponse != RIL_UNSOL_ME_SMS_STORAGE_FULL
        && unsolResponse != RIL_UNSOL_RADIO_CAPABILITY
        && unsolResponse != RIL_UNSOL_SIM_PLUG_IN
        && unsolResponse != RIL_UNSOL_SIM_PLUG_OUT
        && unsolResponse != RIL_UNSOL_RESPONSE_PLMN_CHANGED
        && unsolResponse != RIL_UNSOL_RESPONSE_REGISTRATION_SUSPENDED
        && unsolResponse != RIL_UNSOL_VOICE_RADIO_TECH_CHANGED
        && unsolResponse != RIL_UNSOL_WORLD_MODE_CHANGED
        && unsolResponse != RIL_UNSOL_CDMA_CARD_INITIAL_ESN_OR_MEID
        && unsolResponse != RIL_UNSOL_RESPONSE_CDMA_NEW_SMS
        && unsolResponse != RIL_UNSOL_CDMA_RUIM_SMS_STORAGE_FULL
        && unsolResponse != RIL_UNSOL_TX_POWER
        && unsolResponse != RIL_UNSOL_HARDWARE_CONFIG_CHANGED
        /*&& unsolResponse != RIL_UNSOL_TRAY_PLUG_IN*/) {
        RLOGI("Don't need to cache the request");
        return;
    }
    AtResponseList* urcCur = NULL;
    AtResponseList* urcPrev = NULL;
    int pendedUrcCount = 0;

    switch(socket_id) {
        case RIL_SOCKET_1:
            urcCur = pendedUrcList1;
            break;
        case RIL_SOCKET_2:
            urcCur = pendedUrcList2;
            break;
        case RIL_SOCKET_3:
            urcCur = pendedUrcList3;
            break;
        case RIL_SOCKET_4:
            urcCur = pendedUrcList4;
            break;
        case RIL_SOCKET_RILJ:
            urcCur = pendedUrcList_rilj;
            break;
        case RIL_SOCKET_RILJ2:
            urcCur = pendedUrcList_rilj2;
            break;
        default:
            RLOGE("Socket id is wrong!!");
            return;
    }
    while (urcCur != NULL) {
        RLOGD("Pended URC:%d, RILD:%s, :%s",
            pendedUrcCount,
            rilSocketIdToString(socket_id),
            requestToString(urcCur->id));
        urcPrev = urcCur;
        urcCur = urcCur->pNext;
        pendedUrcCount++;
    }
    urcCur = (AtResponseList*)calloc(1, sizeof(AtResponseList));
    if (urcPrev != NULL)
        urcPrev->pNext = urcCur;
    urcCur->pNext = NULL;
    urcCur->id = unsolResponse;
    if (data != NULL) {
        urcCur->data = new Parcel();
        Parcel *parcelUrc = (Parcel *) data;
        urcCur->datalen = parcelUrc->dataSize();
        urcCur->data->appendFrom(parcelUrc,0,parcelUrc->dataSize());
    }else {
        urcCur->data = NULL;
        urcCur->datalen = 0;
    }
    if (pendedUrcCount == 0) {
        switch(socket_id) {
            case RIL_SOCKET_1:
                pendedUrcList1 = urcCur;
                break;
            case RIL_SOCKET_2:
                pendedUrcList2 = urcCur;
                break;
            case RIL_SOCKET_3:
                pendedUrcList3 = urcCur;
                break;
            case RIL_SOCKET_4:
                pendedUrcList4 = urcCur;
                break;
            case RIL_SOCKET_RILJ:
                pendedUrcList_rilj = urcCur;
                break;
            case RIL_SOCKET_RILJ2:
                pendedUrcList_rilj2 = urcCur;
                break;
            default:
                RLOGE("Socket id is wrong!!");
                return;
        }
    }

    RLOGD("Current pendedUrcCount = %d", pendedUrcCount + 1);

    int activeFd = haveActiveFd(socket_id);
    if (activeFd != -1) {
        RLOGD("s_fdCommand [%d] = %d, sendUrc again", socket_id, activeFd);
        sendPendedUrcs(socket_id, activeFd);
    }
}

int haveActiveFd(int socket_id) {
    if (s_fdCommand[socket_id] != -1) {
        return s_fdCommand[socket_id];
    }
    int clientNum = getClientNum();
    for (int i = 0; i < clientNum; i++) {
        if (s_fdCommand_client[i] != -1) {
            return s_fdCommand_client[i];
        }
    }
    return -1;
}

void sendUrc(RIL_SOCKET_ID socket_id, AtResponseList* urcCached) {
    AtResponseList* urc = urcCached;
    AtResponseList* urc_temp;
    while (urc != NULL) {
        RLOGD("sendPendedUrcs RIL%s, %s",
        rilSocketIdToString(socket_id),
        requestToString(urc->id));
    #if defined(ANDROID_MULTI_SIM)
        RIL_onUnsolicitedResponse(urc->id, urc->data, urc->datalen, socket_id);
    #else
        RIL_onUnsolicitedResponse(urc->id, urc->data, urc->datalen);
    #endif
        if(urc->data != NULL)
            delete urc->data;
        urc_temp = urc;
        urc = urc->pNext;
        free(urc_temp);
    }
}

void sendPendedUrcs(RIL_SOCKET_ID socket_id, int fdCommand) {
    RLOGD("Ready to send pended URCs, socket:%s, fdCommand:%d",
            rilSocketIdToString(socket_id), fdCommand);

    if ((RIL_SOCKET_1 == socket_id) && (fdCommand != -1)) {
        sendUrc(socket_id, pendedUrcList1);
        pendedUrcList1 = NULL;
    }
    else if ((RIL_SOCKET_2 == socket_id) && (fdCommand != -1)) {
        sendUrc(socket_id, pendedUrcList2);
        pendedUrcList2 = NULL;
    }
    else if ((RIL_SOCKET_3 == socket_id) && (fdCommand != -1)) {
        sendUrc(socket_id, pendedUrcList3);
        pendedUrcList3 = NULL;
    }
    else if ((RIL_SOCKET_4 == socket_id) && (fdCommand != -1)) {
        sendUrc(socket_id, pendedUrcList4);
        pendedUrcList4 = NULL;
    }
    else if ((RIL_SOCKET_RILJ == socket_id || RIL_SOCKET_RILJ2 == socket_id)
            && fdCommand != -1) {
        AtResponseList** pendedUrcAddress =
                RIL_SOCKET_RILJ == socket_id ? &pendedUrcList_rilj : &pendedUrcList_rilj2;
        sendUrc(socket_id, *pendedUrcAddress);
        *pendedUrcAddress = NULL;
    }
}
//

/*
 * Returns true for a debuggable build.
 */
static bool isDebuggable() {
    char debuggable[PROP_VALUE_MAX];
    mtk_property_get("ro.debuggable", debuggable, "0");
    if (strcmp(debuggable, "1") == 0) {
        return true;
    }
    return false;

}
#ifdef HAVE_AEE_FEATURE
void triggerWarning(char *pErrMsg) {
    if (pErrMsg != NULL) {
        aee_system_warning("ril-proxy", NULL, DB_OPT_DEFAULT, pErrMsg);
        exit(0);
    } else {
        assert(0);
    }
}
#endif

/* M: eMBMS feature */
static void dispatchEmbmsStartSessionInfo(Parcel &p, RequestInfo *pRI) {
    RIL_EMBMS_StartSessionReq args;
    int32_t t = 0;
    status_t status;

    memset (&args, 0, sizeof(args));

    status = p.readInt32(&args.trans_id);
    RLOGD("dispatchEmbmsStartSessionInfo, trans_id = %d", args.trans_id);

    status = p.readInt32(&t);
    args.tmgi_info.tmgi_len = (uint32_t)t;
    RLOGD("dispatchEmbmsStartSessionInfo, tmgi_len = %d", args.tmgi_info.tmgi_len);

    startRequest;
    appendPrintBuf("%strans_id=%d,tmgi_len=%s",
        printBuf, args.trans_id, args.tmgi_info.tmgi_len);

    if (args.tmgi_info.tmgi_len > EMBMS_MAX_BYTES_TMGI) {
        RLOGE("dispatchStartSession Invalid TMGI length %d", args.tmgi_info.tmgi_len);
        goto invalid;
    }
    for (unsigned int i=0; i < args.tmgi_info.tmgi_len; i++) {
        uint8_t ut = 0;
        status = p.read(&ut, sizeof(ut));
        args.tmgi_info.tmgi[i] = (uint8_t)ut;
    }
    RLOGD("dispatchStartSession, tmgi[%02X,%02X,%02X,%02X,%02X,%02X]",
                                                args.tmgi_info.tmgi[0],
                                                args.tmgi_info.tmgi[1],
                                                args.tmgi_info.tmgi[2],
                                                args.tmgi_info.tmgi[3],
                                                args.tmgi_info.tmgi[4],
                                                args.tmgi_info.tmgi[5]);


    status = p.readInt32(&t);
    args.earfcnlist_count = (uint32_t)t;
    RLOGD("dispatchEmbmsStartSessionInfo, earfcnlist_count = %d", args.earfcnlist_count);
    appendPrintBuf("%earfcnlist_count=%d", printBuf, args.earfcnlist_count);

    for (unsigned int i = 0 ; i < args.earfcnlist_count ; i++) {
        status = p.readInt32(&t);
        if (i < EMBMS_MAX_NUM_FREQ) {
            args.earfcnlist[i] = t;
            RLOGD("searfcnlist[%d]= %d", i, args.earfcnlist[i]);
            appendPrintBuf("%searfcnlist=%d", printBuf, args.earfcnlist[i]);
        } else {
            RLOGD("searfcnlist[%d] out of index", i);
        }
    }

    status = p.readInt32(&t);
    args.saiList_valid = (uint8_t)t;
    RLOGD("dispatchEmbmsStartSessionInfo, saiList_valid = %d", args.saiList_valid);
    appendPrintBuf("%saiList_valid=%d", printBuf, args.saiList_valid);

    if (args.saiList_valid) {
        status = p.readInt32(&t);
        args.saiList_count = (uint32_t)t;
        RLOGD("dispatchEmbmsStartSessionInfo, saiList_count = %d", args.saiList_count);
        appendPrintBuf("%saiList_count=%d", printBuf, args.saiList_count);

        for (unsigned int i = 0 ; i < args.saiList_count ; i++) {
            status = p.readInt32(&args.saiList[i]);
            RLOGV("saiList[%d]= %d", i, args.saiList[i]);
            appendPrintBuf("%ssaiList=%d", printBuf, args.saiList[i]);
        }
    } else {
        args.saiList_count = 0;
        RLOGD("dispatchEmbmsStartSessionInfo, saiList_count = 0 due to not valid");
        appendPrintBuf("%saiList_count=%d", printBuf, args.saiList_count);
    }

    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }

    CALL_ONREQUEST(pRI->pCI->requestNumber, &args, sizeof(args), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchEmbmsStopSessionInfo(Parcel &p, RequestInfo *pRI) {
    RIL_EMBMS_StopSessionReq args;
    int32_t t = 0;
    status_t status;

    memset (&args, 0, sizeof(args));

    startRequest;
    status = p.readInt32(&t);
    args.trans_id = (int)t;
    RLOGD("dispatchStopSession, status:%d, trans_id%d", status, args.trans_id);

    // readByteArray
    status = p.readInt32(&t);
    args.tmgi_info.tmgi_len = (uint32_t)t;
    RLOGD("dispatchStopSession, tmgi_len status = %d ,tmgi_len = %d ", status , args.tmgi_info.tmgi_len);

    if (args.tmgi_info.tmgi_len > EMBMS_MAX_BYTES_TMGI) {
        RLOGE("dispatchStopSession Invalid TMGI length %d", args.tmgi_info.tmgi_len);
        goto invalid;
    }
    for (unsigned int i=0; i < args.tmgi_info.tmgi_len; i++) {
        uint8_t ut = 0;
        status = p.read(&ut, sizeof(ut));
        args.tmgi_info.tmgi[i] = (uint8_t)ut;
    }
    RLOGD("dispatchStopSession, tmgi[%02X,%02X,%02X,%02X,%02X,%02X]",
                                                args.tmgi_info.tmgi[0],
                                                args.tmgi_info.tmgi[1],
                                                args.tmgi_info.tmgi[2],
                                                args.tmgi_info.tmgi[3],
                                                args.tmgi_info.tmgi[4],
                                                args.tmgi_info.tmgi[5]);


    appendPrintBuf("%strans_id=%d,tmgi_len=%d",
        printBuf, args.trans_id, args.tmgi_info.tmgi_len);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }

    CALL_ONREQUEST(pRI->pCI->requestNumber, &args, sizeof(args), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static int responseEmbmsNetworkTime(Parcel &p, void *response, size_t responselen) {
     if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_EMBMS_GetTimeResp) != 0) {
        RLOGE("responseEmbmsNetworkTime: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_EMBMS_GetTimeResp));
        assert(false);
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_EMBMS_GetTimeResp *p_cur = (RIL_EMBMS_GetTimeResp *)response;
    p.writeInt32(p_cur->trans_id);
    p.writeInt32(p_cur->response);
    p.writeInt64(p_cur->milli_sec);
    p.writeInt32(p_cur->day_light_saving_valid);
    p.writeInt32(p_cur->day_light_saving);
    p.writeInt32(p_cur->leap_seconds_valid);
    p.writeInt32(p_cur->leap_seconds);
    p.writeInt32(p_cur->local_time_offset_valid);
    p.writeInt32(p_cur->local_time_offset);

    startResponse;
    appendPrintBuf("%s%d,%d,%lu,%d,%d,%d,%d,%d,%d", printBuf, p_cur->trans_id, p_cur->response
        , p_cur->milli_sec, p_cur->day_light_saving_valid, p_cur->day_light_saving
        , p_cur->leap_seconds_valid, p_cur->leap_seconds, p_cur->local_time_offset_valid
        , p_cur->local_time_offset);
    closeResponse;

    return 0;
}

static int responseEmbmsOosNotify(Parcel &p, void *response, size_t responselen) {
     if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_EMBMS_OosNotify) != 0) {
        RLOGE("responseEmbmsOosNotify: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_EMBMS_OosNotify));
        assert(false);
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;
    RIL_EMBMS_OosNotify *p_cur = (RIL_EMBMS_OosNotify *)response;
    p.writeInt32(p_cur->trans_id);
    p.writeInt32(p_cur->reason);
    p.writeInt32(p_cur->tmgi_info_count);
    RLOGD("tmgi_info_count, %d", p_cur->tmgi_info_count);
    appendPrintBuf("%s%d,%d,%d", printBuf, p_cur->trans_id,
        p_cur->reason, p_cur->tmgi_info_count);

    for (uint32_t i = 0; i < p_cur->tmgi_info_count; i++) {
        // writeByteArray will introduce endian issue
        p.writeInt32(p_cur->tmgi_info[i].tmgi_len);
        uint8_t uct;
        for (uint32_t j=0; j < p_cur->tmgi_info[i].tmgi_len; j++) {
            p.write(&(p_cur->tmgi_info[i].tmgi[j]), sizeof(uct));
        }
        appendPrintBuf("%s%d", printBuf, p_cur->tmgi_info[i].tmgi_len);
    }
    closeResponse;

    return 0;
}

static int responseEmbmsCellInfoNotify(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_EMBMS_CellInfoNotify) != 0) {
        RLOGE("responseEmbmsCellInfoNotify: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_EMBMS_CellInfoNotify));
        assert(false);
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_EMBMS_CellInfoNotify *p_cur = (RIL_EMBMS_CellInfoNotify *) response;
    p.writeInt32(p_cur->trans_id);
    p.writeInt32(p_cur->cell_id);
    startResponse;
    appendPrintBuf("%s%d,%d", printBuf, p_cur->trans_id, p_cur->cell_id);
    closeResponse;
    return 0;
}

static int responseEmbmsModemEeNotify(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_EMBMS_ModemEeNotify) != 0) {
        RLOGE("responseEmbmsModemEeNotify: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_EMBMS_ModemEeNotify));
        assert(false);
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_EMBMS_ModemEeNotify *p_cur = (RIL_EMBMS_ModemEeNotify *) response;
    p.writeInt32(p_cur->trans_id);
    p.writeInt32(p_cur->state);
    startResponse;
    appendPrintBuf("%s%d,%d", printBuf, p_cur->trans_id, p_cur->state);
    closeResponse;
    return 0;
}

static int responseEmbmsSaiNotify(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_EMBMS_SaiNotify) != 0) {
        RLOGE("responseEmbmsSaiNotify: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_EMBMS_SaiNotify));
        assert(false);
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_EMBMS_SaiNotify *p_cur = (RIL_EMBMS_SaiNotify *) response;
    startResponse;
    // trans_id
    p.writeInt32(p_cur->trans_id);

    // cf_total
    p.writeInt32(p_cur->cf_total);

    // curFreqData
    for (uint32_t i = 0; i < p_cur->cf_total; i++) {
        p.writeInt32(p_cur->curFreqData[i]);
    }

    // csai_count_per_group
    for (uint32_t i = 0; i < p_cur->cf_total; i++) {
        p.writeInt32(p_cur->csai_count_per_group[i]);
    }

    // csai_total
    p.writeInt32(p_cur->csai_total);

    // curSaiData
    for (uint32_t i = 0; i < p_cur->csai_total; i++) {
        p.writeInt32(p_cur->curSaiData[i]);
    }

    // nf_total
    p.writeInt32(p_cur->nf_total);

    // neiFreqData
    for (uint32_t i = 0; i < p_cur->nf_total; i++) {
        p.writeInt32(p_cur->neiFreqData[i]);
    }

    // nsai_count_per_group
    for (uint32_t i = 0; i < p_cur->nf_total; i++) {
        p.writeInt32(p_cur->nsai_count_per_group[i]);
    }

    // nsai_total
    p.writeInt32(p_cur->nsai_total);

    // neiSaiData
    for (uint32_t i = 0; i < p_cur->nsai_total; i++) {
        p.writeInt32(p_cur->neiSaiData[i]);
    }

    appendPrintBuf("%s%d,%d,%d,%d,%d", printBuf, p_cur->trans_id, p_cur->cf_total
        , p_cur->csai_total, p_cur->nf_total, p_cur->nsai_total);
    RLOGD("responseEmbmsSaiNotify cf_total[%d], csai_total[%d], nf_total[%d], nf_total[%d]"
        , p_cur->cf_total, p_cur->csai_total, p_cur->nf_total, p_cur->nf_total);

    closeResponse;
    return 0;
}

static int responseEmbmsActiveSessionNotify(Parcel &p, void *response, size_t responselen) {
     if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_EMBMS_ActiveSessionNotify) != 0) {
        RLOGE("responseEmbmsActiveSessionNotify: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_EMBMS_ActiveSessionNotify));
        assert(false);
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;
    RIL_EMBMS_ActiveSessionNotify *p_cur = (RIL_EMBMS_ActiveSessionNotify *)response;
    p.writeInt32(p_cur->trans_id);
    p.writeInt32(p_cur->tmgi_info_count);
    appendPrintBuf("%s%d,%d", printBuf, p_cur->trans_id, p_cur->tmgi_info_count);
    for (uint32_t i = 0; i < p_cur->tmgi_info_count; i++) {
        // writeByteArray will introduce endian issue
        p.writeInt32(p_cur->tmgi_info[i].tmgi_len);
        uint8_t uct;
        for (uint32_t j=0; j < p_cur->tmgi_info[i].tmgi_len; j++) {
            p.write(&(p_cur->tmgi_info[i].tmgi[j]), sizeof(uct));
        }
        RLOGD("responseAvailableActiveSession, TMGI[%02X,%02X,%02X,%02X,%02X,%02X]",
                                            p_cur->tmgi_info[i].tmgi[0],
                                            p_cur->tmgi_info[i].tmgi[1],
                                            p_cur->tmgi_info[i].tmgi[2],
                                            p_cur->tmgi_info[i].tmgi[3],
                                            p_cur->tmgi_info[i].tmgi[4],
                                            p_cur->tmgi_info[i].tmgi[5]);
    }
    closeResponse;
    return 0;
}

static int responseEmbmsSessionInfo(Parcel &p, void *response, size_t responselen) {
     if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_EMBMS_StartSessionResp) != 0) {
        RLOGE("responseEmbmsSessionInfo: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_EMBMS_StartSessionResp));
        assert(false);
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;
    RIL_EMBMS_StartSessionResp *p_cur = (RIL_EMBMS_StartSessionResp *)response;
    p.writeInt32(p_cur->trans_id);
    p.writeInt32(p_cur->response);
    p.writeInt32(p_cur->tmgi_info_valid);
    RLOGD("responseStartStopSession trans_id=%d, response=%d, tmgi_info_valid=%d, tmgi_len=%d",
                    p_cur->trans_id, p_cur->response, p_cur->tmgi_info_valid, p_cur->tmgi_info.tmgi_len);
    appendPrintBuf("%s%d,%d,%d,%d", printBuf, p_cur->trans_id,
        p_cur->response, p_cur->tmgi_info_valid, p_cur->tmgi_info.tmgi_len);

    // writeByteArray will introduce endian issue
    p.writeInt32(p_cur->tmgi_info.tmgi_len);
    uint8_t uct;
    for (uint32_t j=0; j < p_cur->tmgi_info.tmgi_len; j++) {
        p.write(&(p_cur->tmgi_info.tmgi[j]), sizeof(uct));
    }

    for (uint32_t i=0; i < p_cur->tmgi_info.tmgi_len; i++) {
        appendPrintBuf("%s%d", printBuf, p_cur->tmgi_info.tmgi[i]);
        RLOGD("responseStartStopSession tmgi[%d] = %02X", i, p_cur->tmgi_info.tmgi[i]);
    }

    closeResponse;
    return 0;
}

static int responseEmbmsEnable(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_EMBMS_EnableResp) != 0) {
        RLOGE("responseEmbmsEnable: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_EMBMS_EnableResp));
        assert(false);
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_EMBMS_EnableResp *p_cur = (RIL_EMBMS_EnableResp *) response;
    p.writeInt32(p_cur->trans_id);
    p.writeInt32(p_cur->response);
    p.writeInt32(p_cur->interface_index_valid);
    p.writeInt32(p_cur->interface_index);
    startResponse;
    appendPrintBuf("%s%d,%d,%d,%d", printBuf, p_cur->trans_id, p_cur->response,
        p_cur->interface_index_valid, p_cur->interface_index);
    closeResponse;
    return 0;
}

static int responseEmbmsDisable(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_EMBMS_DisableResp) != 0) {
        RLOGE("responseEmbmsDisable: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_EMBMS_DisableResp));
        assert(false);
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_EMBMS_DisableResp *p_cur = (RIL_EMBMS_DisableResp *) response;
    p.writeInt32(p_cur->trans_id);
    p.writeInt32(p_cur->response);
    startResponse;
    appendPrintBuf("%s%d,%d", printBuf, p_cur->trans_id, p_cur->response);
    closeResponse;
    return 0;
}

static int responseEmbmsGetCoverageState(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_EMBMS_GetCoverageResp) != 0) {
        RLOGE("responseEmbmsGetCoverageState: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_EMBMS_GetCoverageResp));
        assert(false);
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_EMBMS_GetCoverageResp *p_cur = (RIL_EMBMS_GetCoverageResp *) response;
    p.writeInt32(p_cur->trans_id);
    p.writeInt32(p_cur->response);
    p.writeInt32(p_cur->coverage_state_valid);
    p.writeInt32(p_cur->coverage_state);
    startResponse;
    appendPrintBuf("%s%d,%d,%d,%d", printBuf, p_cur->trans_id, p_cur->response,
        p_cur->coverage_state_valid, p_cur->coverage_state);
    closeResponse;
    return 0;
}

// MTK-START: SIM OPEN CHANNEL WITH P2
static void dispatchOpenChannelParams(android::Parcel &p, android::RequestInfo *pRI) {
    RIL_OpenChannelParams openChannelParams;
    int32_t t = 0;
    android::status_t status;

    RLOGD("dispatchOpenChannelParams Enter.");

    memset(&openChannelParams, 0, sizeof(openChannelParams));

    openChannelParams.aidPtr = strdupReadString(p);

    status = p.readInt32(&t);
    openChannelParams.p2 = t;
    if (status != android::NO_ERROR) {
        goto invalid;
    }

    RLOGD("dispatchOpenChannelParams aid: %s, p2: %d",
            openChannelParams.aidPtr, openChannelParams.p2);

    startRequest;
    appendPrintBuf("%said=%s,p2=%d", printBuf,
            openChannelParams.aidPtr, openChannelParams.p2);
    closeRequest;

    CALL_ONREQUEST(pRI->pCI->requestNumber, &openChannelParams,
            sizeof(openChannelParams), pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    android::memsetString(openChannelParams.aidPtr);
#endif
    if (openChannelParams.aidPtr != NULL) {
        free(openChannelParams.aidPtr);
    }
#ifdef MEMSET_FREED
    memset(&openChannelParams, 0, sizeof(openChannelParams));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

// ecall start
static void dispatchEcallSetMsd(Parcel &p, RequestInfo *pRI) {
    RIL_ECallSetMSD msd;

    int32_t id = 0;
    int length = 0;
    unsigned int value = 0;
    int size;
    status_t status;

    memset(&msd, 0, sizeof(msd));

    status = p.readInt32(&id);
    msd.call_id= id;

    status = p.readInt32(&length);

    msd.length = (unsigned int)length;

    RLOGD("dispatchEcallSetMsd length=%d, call_id =%d", length, id);

    if((msd.msd_data = (unsigned char*)malloc(sizeof(unsigned char)*msd.length)) == NULL){

        RLOGD("malloc msd_data fail\n");
        return;
    }

    memset(msd.msd_data, 0, sizeof(unsigned char)*msd.length);

    for(int i = 0; i< msd.length; i++){
        status = p.readUint32(&value);
        msd.msd_data[i] = (unsigned char) value;
        //debug
        RLOGD("msd_data[%d] = %d",i,msd.msd_data[i]);
    }

    startRequest;
    appendPrintBuf("%scall_id=%d,data_length=%d", printBuf,
        msd.call_id,msd.length);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        free(msd.msd_data);
        goto invalid;
    }

    size = sizeof(RIL_ECallSetMSD)+sizeof(unsigned char)*msd.length;
    CALL_ONREQUEST(pRI->pCI->requestNumber, &msd, size, pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memset(msd.msd_data,0,sizeof(unsigned char)*msd.length);
#endif

    free(msd.msd_data);

#ifdef MEMSET_FREED
    memset(&msd, 0, sizeof(msd));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchFastMakeEcall(Parcel &p, RequestInfo *pRI) {
    RIL_ECallReqMsg eCallReqMsg;

    int32_t t = 0;
    int size;
    status_t status;
    unsigned int len;
    unsigned int value;

    memset(&eCallReqMsg, 0, sizeof(eCallReqMsg));

    status = p.readInt32(&t);
    eCallReqMsg.ecall_cat = (RIL_ECall_Category)t;

    status = p.readInt32(&t);
    eCallReqMsg.ecall_variant = (RIL_ECall_Variant)t;

    eCallReqMsg.address = strdupReadString(p);

    //debug
    RLOGD("eCallReqMsg address = %s\n",eCallReqMsg.address);

    status = p.readInt32(&t);

    eCallReqMsg.length = (unsigned int)t;

    if((eCallReqMsg.msd_data = (unsigned char*)malloc(sizeof(unsigned char)*eCallReqMsg.length)) == NULL){
        free(eCallReqMsg.address);
        return;
    }

    memset(eCallReqMsg.msd_data, 0, sizeof(unsigned char)*eCallReqMsg.length);

    for(int i = 0; i< eCallReqMsg.length; i++){
        status = p.readUint32(&value);
        eCallReqMsg.msd_data[i] = (unsigned char) value;
        //debug
        RLOGD("msd_data[%d] = %d",i,eCallReqMsg.msd_data[i]);
    }

    startRequest;
    appendPrintBuf("%secall_cat=%d,ecall_variant=%d,address=%s,length=%d", printBuf,
        eCallReqMsg.ecall_cat, eCallReqMsg.ecall_variant, (char*)eCallReqMsg.address,\
        eCallReqMsg.length
        );
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        free(eCallReqMsg.address);
        free(eCallReqMsg.msd_data);
        goto invalid;
    }

    size = sizeof(eCallReqMsg);
    CALL_ONREQUEST(pRI->pCI->requestNumber, &eCallReqMsg, size, pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString(eCallReqMsg.address);
    memset(eCallReqMsg.msd_data,0,eCallReqMsg.length);
#endif

    free(eCallReqMsg.address);
    free(eCallReqMsg.msd_data);

#ifdef MEMSET_FREED
    memset(&eCallReqMsg, 0, sizeof(eCallReqMsg));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchEcallSetNum(Parcel &p, RequestInfo *pRI) {
    RIL_ECallSetNum num;

    int32_t t = 0;
    status_t status;

    memset(&num, 0, sizeof(num));

    status = p.readInt32(&t);
    num.arg_num = t;

    status = p.readInt32(&t);
    num.type = t;

    num.address = strdupReadString(p);

    if (status != NO_ERROR) {
        goto invalid;
    }

    RLOGD("dispatchEcallSetNum status: %d, address: %s", num.type, num.address);

    startRequest;
    appendPrintBuf("%stype=%d,num=%s", printBuf, num.type, (char*)num.address);
    closeRequest;

    CALL_ONREQUEST(pRI->pCI->requestNumber, &num, sizeof(num), pRI, mapingSlotIdToRilSocketId(pRI->slot_id));

#ifdef MEMSET_FREED
    memsetString(num.address);
#endif
    if (num.address != NULL) {
        free(num.address);
    }

#ifdef MEMSET_FREED
    memset(&num, 0, sizeof(num));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

static int responseEcallInd(android::Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        LOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof(RIL_Ecall_Unsol_Indications)) {
        LOGE("invalid response length was %d expected %d",
             (int)responselen, (int)sizeof (RIL_Ecall_Unsol_Indications));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_Ecall_Unsol_Indications *p_cur = (RIL_Ecall_Unsol_Indications *)response;
    RLOGD("responseEcallInd ind:%d call_id:%d", p_cur->ind, p_cur->call_id);

    p.writeInt32(p_cur->ind);
    p.writeInt32(p_cur->call_id);

    return 0;
}
// MTK-END

static int responseQueryNetworkLock(android::Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("responseQueryNetworkLock: invalid NULL response");
        return RIL_ERRNO_INVALID_RESPONSE;
    }
    if (responselen != sizeof(RIL_SimMeLockCatInfo)) {
        RLOGE("responseQueryNetworkLock: invalid response length %u, expecting %u",
                (unsigned)responselen, (unsigned)sizeof(RIL_SimMeLockCatInfo));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_SimMeLockCatInfo *p_result = (RIL_SimMeLockCatInfo *) response;

    p.writeInt32(p_result->catagory);
    p.writeInt32(p_result->state);
    p.writeInt32(p_result->retry_cnt);
    p.writeInt32(p_result->autolock_cnt);
    p.writeInt32(p_result->num_set);
    p.writeInt32(p_result->total_set);
    p.writeInt32(p_result->key_state);

    startResponse;
    appendPrintBuf("responseQueryNetworkLock result: catagory %d, state %d ,retry_cnt %d "
            ",autolock_cnt %d ,num_set %d ,total_set %d ,key_state %d",
            p_result->catagory, p_result->state, p_result->retry_cnt,
            p_result->autolock_cnt, p_result->num_set, p_result->total_set, p_result->key_state);
    closeResponse;
    return 0;
}

static void dispatchNetworkScan(android::Parcel &p, android::RequestInfo *pRI) {
    RIL_NetworkScanRequest args;
    int32_t t = 0;
    android::status_t status;

    memset (&args, 0, sizeof(args));

    status = p.readInt32(&t);
    args.type = (RIL_ScanType) t;

    status = p.readInt32(&t);
    args.interval = (int32_t) t;

    status = p.readInt32(&t);
    args.specifiers_length = (uint32_t) t;

    for (int i = 0 ; i < args.specifiers_length ; i++) {
        status = p.readInt32(&t);
        args.specifiers[i].radio_access_network = (RIL_RadioAccessNetworks) t;

        status = p.readInt32(&t);
        args.specifiers[i].bands_length = (uint32_t) t;

        for (int j = 0 ; j < args.specifiers[i].bands_length ; j++) {
            status = p.readInt32(&t);
            if (args.specifiers[i].radio_access_network == GERAN) {
                args.specifiers[i].bands.geran_bands[j] = (RIL_GeranBands) t;
            } else if (args.specifiers[i].radio_access_network == UTRAN) {
                args.specifiers[i].bands.utran_bands[j] = (RIL_UtranBands) t;
            } else {
                args.specifiers[i].bands.eutran_bands[j] = (RIL_EutranBands) t;
            }
        }

        status = p.readInt32(&t);
        args.specifiers[i].channels_length = (uint32_t) t;

        for (int k = 0 ; k < args.specifiers[i].channels_length ; k++) {
            status = p.readInt32(&t);
            args.specifiers[i].channels[k] = (uint32_t) t;
        }
    }

    startRequest;
    appendPrintBuf("%scmd=0x%X,type=%d,interval=%d,specifiers_length=%d", printBuf,
        args.type, args.interval, args.specifiers_length);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != android::NO_ERROR) {
        goto invalid;
    }

    CALL_ONREQUEST(pRI->pCI->requestNumber, &args, sizeof(args), pRI, pRI->socket_id);

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchLinkCapacityReportingCriteria(android::Parcel &p, android::RequestInfo *pRI) {
    android::status_t status;
    int t = 0;
    int num = 0;

    RIL_LinkCapacityReportingCriteria *data = (RIL_LinkCapacityReportingCriteria *) calloc(1,
            sizeof(RIL_LinkCapacityReportingCriteria));
    if (data == NULL) {
        RLOGE("setLinkCapacityReportingCriteria: data memory allocation failed for request %s",
                android::requestToString(pRI->pCI->requestNumber));
        return;
    }

    status = p.readInt32(&t);
    if (status != android::NO_ERROR) {
        goto invalid;
    }
    data->hysteresisMs = (int)t;

    status = p.readInt32(&t);
    if (status != android::NO_ERROR) {
        goto invalid;
    }
    data->hysteresisDlKbps = (int)t;

    status = p.readInt32(&t);
    if (status != android::NO_ERROR) {
        goto invalid;
    }
    data->hysteresisUlKbps = (int)t;

    status = p.readInt32(&t);
    if (status != android::NO_ERROR) {
        goto invalid;
    }
    num = (int)t;
    data->thresholdDlKbpsNumber = num > MAX_LCE_THRESHOLD_NUMBER ? MAX_LCE_THRESHOLD_NUMBER : num;
    for (int i = 0; i < num; i++) {
        status = p.readInt32(&t);
        if (status != android::NO_ERROR) {
            goto invalid;
        }
        if (i < MAX_LCE_THRESHOLD_NUMBER) {
            data->thresholdDlKbpsList[i] = (int)t;
        }
    }

    status = p.readInt32(&t);
    if (status != android::NO_ERROR) {
        goto invalid;
    }
    num = (int)t;
    data->thresholdUlKbpsNumber = num > MAX_LCE_THRESHOLD_NUMBER ? MAX_LCE_THRESHOLD_NUMBER : num;
    for (int i = 0; i < num; i++) {
        status = p.readInt32(&t);
        if (status != android::NO_ERROR) {
            goto invalid;
        }
        if (i < MAX_LCE_THRESHOLD_NUMBER) {
            data->thresholdUlKbpsList[i] = (int)t;
        }
    }

    status = p.readInt32(&t);
    if (status != android::NO_ERROR) {
        goto invalid;
    }
    data->accessNetwork = (int)t;

    CALL_ONREQUEST(pRI->pCI->requestNumber, data, sizeof(RIL_LinkCapacityReportingCriteria), pRI,
            pRI->socket_id);

    free(data);
    return;

invalid:
    RLOGE("setLinkCapacityReportingCriteria: invalidCommandBlock for request %s",
            android::requestToString(pRI->pCI->requestNumber));
    free(data);
    invalidCommandBlock(pRI);
    return;
}


static int responseNetworkScanResult(android::Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("responseNetworkScanResult: invalid NULL response");
        return RIL_ERRNO_INVALID_RESPONSE;
    }
    if (responselen != sizeof(RIL_NetworkScanResult)) {
        RLOGE("responseNetworkScanResult: invalid response length %u, expecting %u",
                (unsigned)responselen, (unsigned)sizeof(RIL_NetworkScanResult));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_NetworkScanResult *p_result = (RIL_NetworkScanResult *)response;
    p.writeInt32(p_result->status);
    p.writeInt32(p_result->network_infos_length);

    RIL_CellInfo_v12 *p_cur = (RIL_CellInfo_v12 *) p_result->network_infos;
    for (int i = 0; i < p_result->network_infos_length; i++) {
        p.writeInt32((int)p_cur->cellInfoType);
        p.writeInt32(p_cur->registered);
        p.writeInt32(p_cur->timeStampType);
        p.writeInt64(p_cur->timeStamp);
        switch (p_cur->cellInfoType) {
            case RIL_CELL_INFO_TYPE_GSM: {
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.mcc);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.mnc);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.lac);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.cid);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.arfcn);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.bsic);
                p.writeInt32(p_cur->CellInfo.gsm.signalStrengthGsm.signalStrength);
                p.writeInt32(p_cur->CellInfo.gsm.signalStrengthGsm.bitErrorRate);
                p.writeInt32(p_cur->CellInfo.gsm.signalStrengthGsm.timingAdvance);
                break;
            }
            case RIL_CELL_INFO_TYPE_WCDMA: {
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.mcc);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.mnc);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.lac);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.cid);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.psc);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.uarfcn);
                p.writeInt32(p_cur->CellInfo.wcdma.signalStrengthWcdma.signalStrength);
                p.writeInt32(p_cur->CellInfo.wcdma.signalStrengthWcdma.bitErrorRate);
                break;
            }
            case RIL_CELL_INFO_TYPE_CDMA: {
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.networkId);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.systemId);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.basestationId);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.longitude);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.latitude);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthCdma.dbm);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthCdma.ecio);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.dbm);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.ecio);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.signalNoiseRatio);
                break;
            }
            case RIL_CELL_INFO_TYPE_LTE: {
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.mcc);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.mnc);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.ci);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.pci);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.tac);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.earfcn);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.signalStrength);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rsrp);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rsrq);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rssnr);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.cqi);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.timingAdvance);
                break;
            }
            case RIL_CELL_INFO_TYPE_TD_SCDMA: {
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mcc);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mnc);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.lac);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cid);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cpid);
                p.writeInt32(p_cur->CellInfo.tdscdma.signalStrengthTdscdma.rscp);
                break;
            }
            default: {
                break;
            }
        }
        p_cur += 1;
    }
    startResponse;
        appendPrintBuf("Network scan result: status %d, network_infos_length %d",
                p_result->status, p_result->network_infos_length);
    closeResponse;
    return 0;
}

// M: [VzW] Data Framework @{
static int responsePcoDataAfterAttached(android::Parcel &p, void *response, size_t responselen) {
  if (response == NULL) {
    RLOGE("responsePcoDataAfterAttached: invalid NULL response");
    return RIL_ERRNO_INVALID_RESPONSE;
  }
  if (responselen != sizeof(RIL_PCO_Data_attached)) {
    RLOGE("responsePcoDataAfterAttached: invalid response length %u, expecting %u",
          (unsigned)responselen, (unsigned)sizeof(RIL_PCO_Data_attached));
    return RIL_ERRNO_INVALID_RESPONSE;
  }

  RIL_PCO_Data_attached *p_cur = (RIL_PCO_Data_attached *)response;
  p.writeInt32(p_cur->cid);
  writeStringToParcel(p, p_cur->apn_name);
  writeStringToParcel(p, p_cur->bearer_proto);
  p.writeInt32(p_cur->pco_id);
  p.writeInt32(p_cur->contents_length);
  p.write(p_cur->contents, p_cur->contents_length);

  startResponse;
      appendPrintBuf("PCO data received: cid %d, id %d, apn name %s, length %d",
                     p_cur->cid, p_cur->pco_id, p_cur->apn_name, p_cur->contents_length);
  closeResponse;

  return 0;
}
// M: [VzW] Data Framework @}

static int responseLinkCapacityEstimate(android::Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("responseLinkCapacityEstimate: invalid NULL response");
        return RIL_ERRNO_INVALID_RESPONSE;
    }
    if (responselen != sizeof(RIL_LinkCapacityEstimate)) {
        RLOGE("responseLinkCapacityEstimate: invalid response length %d, expecting length: %d",
                (int)responselen, (int)sizeof(RIL_LinkCapacityEstimate));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_LinkCapacityEstimate *p_cur = (RIL_LinkCapacityEstimate *)response;
    p.writeInt32(p_cur->downlinkCapacityKbps);
    p.writeInt32(p_cur->uplinkCapacityKbps);

    startResponse;
        appendPrintBuf("responseLinkCapacityEstimate: downlinkCapacityKbps %d uplinkCapacityKbps %d",
                       p_cur->downlinkCapacityKbps, p_cur->uplinkCapacityKbps);
    closeResponse;

    return 0;
}



} /* namespace android */

void rilEventAddWakeup_helper(struct ril_event *ev) {
    android::rilEventAddWakeup(ev);
}

void listenCallback_helper(int fd, short flags, void *param) {
    android::listenCallback(fd, flags, param);
}

int blockingWrite_helper(int fd, void *buffer, size_t len) {
    return android::blockingWrite(fd, buffer, len);
}
