//SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
/*
 * File name:  RfxStatusDef.h
 * Author: Jun Liu (MTK80064)
 * Description:
 *  Define the keys of shared status.
 */

#include "RfxDefs.h"
#include "RfxStatusDefs.h"
#include "RfxVariant.h"
#include "RfxDefaultValueTable.h"

StatusDefaultValueEntry s_default_value_table[] = {
    /*Please add your default value below this line*/
    /*NOTE. below every line should be ended by "" */
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CARD_TYPE, RfxVariant(-1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CDMA_CARD_TYPE, RfxVariant(4)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CDMA_CARD_READY, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CDMA_FILE_READY, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CDMA3G_DUALMODE_CARD, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_ESIMIND_APPLIST, RfxVariant(-1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CDMA_LOCKED_CARD, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_UICC_SUB_CHANGED_STATUS, RfxVariant(-1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_UICC_GSM_NUMERIC, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_UICC_CDMA_NUMERIC, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_C2K_IMSI, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_BTSAP_STATUS, RfxVariant(BT_SAP_INIT)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_BTSAP_CURRENT_PROTOCOL, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_BTSAP_SUPPORT_PROTOCOL, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_BTSAP_ATR, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_SIM_ESIMS_CAUSE, RfxVariant(-1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_ECPIN_STATE, RfxVariant(RFX_ECPIN_DONE)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_MODEM_SIM_TASK_READY, RfxVariant(false)),
//    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_SERVICE_STATE, RfxVariant(RfxNwServiceState())),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_VOICE_TYPE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_DATA_TYPE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_RADIO_STATE, RfxVariant()),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_MODEM_POWER_OFF, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_MODEM_OFF_STATE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_SIM_STATE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_SIM_INSERT_STATE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_GSM_IMSI, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_SLOT_CAPABILITY, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_OTA_STATUS, RfxVariant(-1)),
//    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CALL_STATE, RfxVariant(RfxCallState())),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_VOICE_CALL_COUNT, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_AP_VOICE_CALL_COUNT, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_EMERGENCY_MODE, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_EMERGENCY_CALLBACK_MODE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CARRIER_AUTO_APPROVE_INCOMING, RfxVariant(String8("true"))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_ATCI_IS_NUMERIC, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_IMS_CALL_EXIST, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_DATA_CONNECTION, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_WORLD_MODE_STATE, RfxVariant(1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_GSM_WORLD_MODE_STATE, RfxVariant(1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CDMA_WORLD_MODE_STATE, RfxVariant(1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_WORLD_MODE_BLOCKED_STATE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_WORLD_MODE_BLOCKED_CHANGING_STATE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CELLULAR_PS_STATE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_WFC_STATE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_MAIN_CAPABILITY_SLOT, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_DEFAULT_DATA_SIM, RfxVariant(-1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_ECC_PREFERRED_RAT, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_RADIO_POWER_MSIM_MODE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_REQUEST_RADIO_POWER, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_RADIO_LOCK, RfxVariant(RADIO_LOCK_IDLE)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_GCF_TEST_MODE, RfxVariant(-1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_GSM_INBOUND_SMS_TYPE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_SMS_PHONE_STORAGE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CDMA_INBOUND_SMS_TYPE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CDMA_SMS_REPLY_SEQ_NO, RfxVariant(-1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CDMA_SMS_ADDR, RfxVariant(Vector<char>())),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CDMA_MO_SMS_STATE, RfxVariant(1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CDMA_PENDING_VMI, RfxVariant(-1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_PREFERRED_NW_TYPE, RfxVariant(RfxVariant(-1))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_IS_RAT_MODE_SWITCHING, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_OPERATOR, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_OPERATOR_INCLUDE_LIMITED, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_MODESWITCH_FINISHED, RfxVariant(-1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CDMA3G_SWITCH_CARD, RfxVariant(-1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE, RfxVariant(CAPABILITY_SWITCH_STATE_IDLE)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CAPABILITY_SWITCH_WAIT_MODULE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_SIM_SWITCH_RADIO_UNAVAIL_TIME, RfxVariant(int64_t(0))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_IS_CAT_RUNNING, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_STK_CACHE_CMD_TYPE, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_STK_CMD_ID, RfxVariant(-1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CAPABILITY_SWITCH_URC_CHANNEL, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_PCO_STATUS, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_HAD_POWER_OFF_MD, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_TRN_CALLID, RfxVariant(-1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_TRN, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_DSBP_ENHANCEMENT_STATE, RfxVariant(DSBP_ENHANCEMENT_END)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CAPABILITY_SWITCH_KEEP_EBOOT, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CDMA_SPN, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_GSM_SPN, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_GSM_GID1, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_GSM_PNN, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_MD_ICCID_SUPPORT, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_SIM_ICCID, RfxVariant(String8(""))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_CONNECTION_STATE, RfxVariant(false)),
//    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_IMS_CALL_LIST, RfxVariant(Vector<RfxImsCallInfo*>())),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_RESTORE_IMS_CONFERENCE_PARTICIPANT, RfxVariant(String8("true"))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_OPERATE_IMS_CONFERENCE_PARTICIPANTS_BY_USER_ENTITY,
            RfxVariant(String8("false"))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_IMS_SPECIFIC_CONFERENCE_MODE, RfxVariant(String8("0"))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_XUI_INFO, RfxVariant(Vector<String8>())),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_HIGH_PRIORITY_CLIR_PREFIX_SUPPORTED, RfxVariant(String8("false"))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CONFIG_DEVICE_VOLTE_AVAILABLE, RfxVariant(String8("0"))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CONFIG_DEVICE_VT_AVAILABLE, RfxVariant(String8("0"))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CONFIG_DEVICE_WFC_AVAILABLE, RfxVariant(String8("0"))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CARRIER_ALLOW_TURN_OFF_IMS, RfxVariant(String8("1"))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_VOLTE_STATE, RfxVariant(-1)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_TEMP_DATA_SWTICH, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_TEMP_DATA_SETTING, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_IN_CALL, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_CUSTOMIZED_USER_AGENT_FORMAT, RfxVariant(String8("0"))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_VOICE_CALL_INDEX, RfxVariant(0)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_IMS_INCOMING_CALL_RULE, RfxVariant(String8("0"))),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_ECALL_EXIST, RfxVariant(false)),
    RFX_STATUS_DEFAULT_VALUE_ENTRY(RFX_STATUS_KEY_INCOMING_MSG_TXID, RfxVariant(0)),
    /*Please add your default value above this line*/
    RFX_STATUS_DEFAULT_VALUE_TABLE_END;
