/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#ifndef __RP_CALL_CONTROLLER_H__
#define __RP_CALL_CONTROLLER_H__

#include <string>

#include "RfxController.h"
#include "RpUtils.h"
#include "RilParcelUtils.h"
#include <telephony/mtk_ril_request_info.h>

#ifdef __cplusplus
extern "C" {
#endif
#include "mipc_call_api.h"
#include "mipc_msg_tlv_const.h"
#ifdef __cplusplus
}
#endif

/*****************************************************************************
 * Class RpDataController
 *****************************************************************************/
class RpCallController : public RfxController {
    RFX_DECLARE_CLASS(RpCallController);  // Required: declare this class

public:
    RpCallController();

    virtual ~RpCallController();

// Override
protected:

    virtual void onInit();
    virtual void onDeinit();
    virtual bool onHandleRequest(const sp<RfxMessage>& message);

private:
    std::string mLog_tag;
private:
    void registerInd(mipc_sim_ps_id_enum sim_ps_id,void *cb_priv_ptr);
    void registerCmd(mipc_sim_ps_id_enum sim_ps_id,void *cb_priv_ptr);
    std::string IdToString(int request);
    void handleGetCurrentCalls(const sp<RfxMessage>& request);
    void handleDial(const sp<RfxMessage>& request);
    void handleHangup(const sp<RfxMessage>& request);
    void handleHangupWaittingOrBg(const sp<RfxMessage>& request);
    void handleHangupForegroundResumebg(const sp<RfxMessage>& request);
    void handleSwitchWaitingOrHoldingAndActive(const sp<RfxMessage>& request);
    void handleConf(const sp<RfxMessage>& request);
    void handleUdub(const sp<RfxMessage>& request);
    void handleLastCallFailCause(const sp<RfxMessage>& request);
    void handleDtmf(const sp<RfxMessage>& request);
    void handleAnswer(const sp<RfxMessage>& request);
    void handleDtmfStart(const sp<RfxMessage>& request);
    void handleDtmfStop(const sp<RfxMessage>& request);
    void handleSeperateconf(const sp<RfxMessage>& request);
    void handleSetMute(const sp<RfxMessage>& request);
    void handleGetMute(const sp<RfxMessage>& request);
    void handleExplicitCallTransfer(const sp<RfxMessage>& request);
    void handleHangupAll(const sp<RfxMessage>& request);
    void handleForceReleaseCall(const sp<RfxMessage>& request);
    void handleEmergencyDial(const sp<RfxMessage>& request);
    void handleSetEccList(const sp<RfxMessage>& request);
    void handleSetCalIndication(const sp<RfxMessage>& request);
    void handleSetEccServiceCategory(const sp<RfxMessage>& request);
    void handleImsConferenceMember(const sp<RfxMessage>& request, int control_type);
    void handleDialWithSipUri(const sp<RfxMessage>& request);
    void handleConferenceDial(const sp<RfxMessage>& request);
    void handleControlCall(const sp<RfxMessage>& request, int control_type);
};

#endif /* __RP_CALL_CONTROLLER_H__ */

