/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef __RMC_DC_REQ_HANDLER_H__
#define __RMC_DC_REQ_HANDLER_H__

/*****************************************************************************
 * Include
 *****************************************************************************/
#include "RfxController.h"
#include "RmcDataDefs.h"
#include "RmcDcDefaultReqHandler.h"
//#include "RmcDcImsReqHandler.h"
#include "RmcDcOnDemandReqHandler.h"
#include "RmcDcPdnManager.h"

/*****************************************************************************
 * Class RmcDcReqHandler
 *****************************************************************************/
class RmcDcReqHandler : public RfxController {
    RFX_DECLARE_CLASS(RmcDcReqHandler);

    public:
        RmcDcReqHandler();
        virtual ~RmcDcReqHandler();

    protected:
        virtual void onInit();
        virtual void onDeinit();
        virtual bool onHandleRequest(const sp<RfxMessage>& msg);
        virtual bool onHandleUrc(const sp<RfxMessage>& msg);

    private:
        void handleLastFailCauseRequest(const sp<RfxMessage>& msg);
        void handleSetupDataCallRequest(const sp<RfxMessage>& msg);
        void handleDeactivateDataCallRequest(const sp<RfxMessage>& msg);
        void handleDataCallListRequest(const sp<RfxMessage>& msg);
        int deactivateDataCall(int aid);
        void handleNwPdnAct(const sp<RfxMessage>& msg);
        void handleNwPdnDeact(const sp<RfxMessage>& msg);
        void handleNwModify(const sp<RfxMessage>& msg);
        void handleNwReact(const sp<RfxMessage>& msg);
        void handleMePdnAct(const sp<RfxMessage>& msg);
        void handleMePdnDeact(const sp<RfxMessage>& msg);
        void handlePdnChange(const sp<RfxMessage>& msg);
        void handleSyncApnTableRequest(const sp<RfxMessage>& msg);
        void handleSetInitialAttachApnRequest(const sp<RfxMessage>& msg);
        void handleSyncDataSettingsToMdRequest(const sp<RfxMessage>& msg);
        void handleResetMdDataRetryCount(const sp<RfxMessage>& msg);
        void handleUtTest(const sp<RfxMessage>& msg);
        void handleSetLteAccessStratumReportRequest(const sp<RfxMessage>& msg);
        void handleLteAccessStratumStateChange(const sp<RfxMessage>& msg);
        void handleSetLteUplinkDataTransferRequest(const sp<RfxMessage>& msg);
        void handleClearAllPdnInfoRequest(const sp<RfxMessage>& msg);
        void handleResendSyncDataSettingsToMd(const sp<RfxMessage>& msg);
        void handleQueryPco(const sp<RfxMessage>& msg);
        void handleResetAllConnections(const sp<RfxMessage>& msg);
        void handleSyncApnTableRequestEx(const sp<RfxMessage>& msg);
        void handleResetApnTableRequestEx(const sp<RfxMessage>& msg);
        void handleStartTcpKeepaliveRequest(const sp<RfxMessage>& msg);
        void handleStopTcpKeepaliveRequest(const sp<RfxMessage>& msg);
        void handleTcpKeepaliveStatus(const sp<RfxMessage>& msg);

    private:
        RmcDcDefaultReqHandler *m_pRmcDcDefaultReqHdlr;
        //RmcDcImsReqHandler *m_pRmcDcImsReqHdlr;
        RmcDcOnDemandReqHandler *m_pRmcDcOnDemandReqHdlr;
        RmcDcPdnManager *m_pPdnManager;
};
#endif /* __RMC_DC_REQ_HANDLER_H__ */

