// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef __RP_DATA_CONTROLLER_H__
#define __RP_DATA_CONTROLLER_H__

/*****************************************************************************
 * Include
 *****************************************************************************/
#include "RfxController.h"
#include "RfxTimer.h"
#include "RmcDcPdnManager.h"

#include <netagent/NetAgentService.h>


#include <utils/Vector.h>
#include "utils/Mutex.h"

using ::android::Mutex;

#define DATA_SETTING_NUMBERS   5

typedef enum {
    MOBILE_DATA      = 0,
    ROAMING_DATA     = 1,
    DEFAULT_DATA_SIM = 2,
    DOMESTIC_ROAMING_DATA = 3,
    INTERNATIONAL_ROAMING_DATA = 4
} DATA_SETTING_ITEM;

#define SKIP_DATA_SETTINGS    -2

typedef struct Act_Data_call_back_priv {
    RIL_Token token;
    char apn[MAX_APN_NAME_LENGTH];
} Act_Data_call_back_priv;

typedef struct Get_Retry_timer_call_back_priv {
    RIL_Token token;
    MTK_RIL_Data_Call_Response_v11* response;
} Get_Retry_timer_call_back_priv;

/*****************************************************************************
 * Class RpDataController
 *****************************************************************************/
class RpDataController : public RfxController {
    RFX_DECLARE_CLASS(RpDataController);  // Required: declare this class

public:
    RpDataController();

    virtual ~RpDataController();

    static RpDataController* sInstance[4];
    static RpDataController *getInstance(int soltId);
    RmcDcPdnManager* m_pPdnManager;
    MIPC_MSG_enum * m_mipcIndType[2];

// Override
protected:

    virtual void onInit();
    virtual void onDeinit();
    virtual bool onHandleRequest(const sp<RfxMessage>& message);

    virtual void handleSetupDataRequest(const sp<RfxMessage>& request);
    virtual void handleDeactivateDataRequest(const sp<RfxMessage>& request);

    virtual void handleGetLastFailCauseRequest(const sp<RfxMessage>& request);

    virtual void handleSyncDataSettingsToMdRequest(const sp<RfxMessage>& request);

    virtual void handleSyncApnTableRequest(const sp<RfxMessage>& request);

    virtual void handleDataCallListRequest(const sp<RfxMessage>& request);

    virtual void handleSetInitialAttachApnRequest(const sp<RfxMessage>& request);

    virtual void handleSetDataAllowRequest(const sp<RfxMessage>& request);


public:
    RmcDcPdnManager * getPdnManager ();
    int updataIpv6Address (NetlinkIpv6Info *netInfo);
    bool isDataAllowed(const char* pReqApn);
    void createDataResponse(int transIntfId, int protocol, MTK_RIL_Data_Call_Response_v11* response);
    void initDataCallResponse(MTK_RIL_Data_Call_Response_v11* responses, int length);
    int deactivateDataCall(const int aid, const sp<RfxMessage>& request);
    void freeDataResponse(MTK_RIL_Data_Call_Response_v11* response);
    int getInterfaceId(int transIntfId);
    void requestOrSendDataCallList(const sp<RfxMessage>& request);
    RmcDcPdnManager *getPdnManagerBySlotID(int slotID);
    int calculateTransIntfId(int aid, int interfaceId);
    void sendDataCallListResponse(int Aid);
    bool validateAid(int aid);
    String8 responsesToString(MTK_RIL_Data_Call_Response_v11* responses, int num);
    void setGprsFailureCause(int gprsFailureCause);
    int getGprsFailureCause();
    RIL_DataCallFailCause convertFailCauseToRilStandard(int cause);
    bool notifyDeactReasonIfNeeded(const int deactivatedAid);
    bool isFallbackPdn(const int aid);


protected:
    int m_nGprsFailureCause;
    bool isIpv6AddressUpdateCbReg;


private:
    static int s_dataSetting[MAX_SIM_COUNT][DATA_SETTING_NUMBERS];
    static int s_dataSetting_resend[MAX_SIM_COUNT][DATA_SETTING_NUMBERS];
};

#endif /* __RP_DATA_CONTROLLER_H__ */
