/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef __RP_NW_CONTROLLER_H__
#define __RP_NW_CONTROLLER_H__

/*****************************************************************************
 * Include
 *****************************************************************************/
#include "RfxController.h"
#include "RfxTimer.h"

#include <utils/Vector.h>

typedef enum
{
    BM_AUTO_MODE,
    BM_EURO_MODE,
    BM_US_MODE,
    BM_JPN_MODE,
    BM_AUS_MODE,
    BM_AUS2_MODE,
    BM_CELLULAR_MODE,
    BM_PCS_MODE,
    BM_CLASS_3,
    BM_CLASS_4,
    BM_CLASS_5,
    BM_CLASS_6,
    BM_CLASS_7,
    BM_CLASS_8,
    BM_CLASS_9,
    BM_CLASS_10,
    BM_CLASS_11,
    BM_CLASS_15,
    BM_CLASS_16,
    BM_40_BROKEN = 100,
    BM_FOR_DESENSE_RADIO_ON = 200,
    BM_FOR_DESENSE_RADIO_OFF = 201,
    BM_FOR_DESENSE_RADIO_ON_ROAMING = 202,
    BM_FOR_DESENSE_B8_OPEN = 203
} BAND_MODE;

/*****************************************************************************
 * Class RpDataController
 *****************************************************************************/
class RpNwController : public RfxController {
    RFX_DECLARE_CLASS(RpNwController);  // Required: declare this class

public:
    RpNwController();

    virtual ~RpNwController();

// Override
protected:

    virtual void onInit();
    virtual void onDeinit();
    virtual bool onHandleRequest(const sp<RfxMessage>& message);
    virtual void handleSignalStrengthRequest(const sp<RfxMessage>& request);
    virtual void handleDataRegistrationRequest(const sp<RfxMessage>& request);
    virtual void handleVoiceRegistrationRequest(const sp<RfxMessage>& request);
    virtual void handleQueryNwSelectRequest(const sp<RfxMessage>& request);
    virtual void handleSetNwAutoSelectRequest(const sp<RfxMessage>& request);
    virtual void handleSetNwManualSelectRequest(const sp<RfxMessage>& request);
    virtual void handleGetCellInfoRequest(const sp<RfxMessage>& request);
    virtual void handleGetNwPreferNwTypeRequest(const sp<RfxMessage>& request);
    virtual void handleSetNwPreferNwTypeRequest(const sp<RfxMessage>& request);
    virtual void handleGetNeighborCellInfoRequest(const sp<RfxMessage>& request);
    virtual void handleSetNwBandModeRequest(const sp<RfxMessage>& request);
    virtual void handleGetNwBandModeRequest(const sp<RfxMessage>& request);
    virtual void handleGetOperator(const sp<RfxMessage>& request);
    virtual void handleScreenStateRequest(const sp<RfxMessage>& request);
    virtual void handleGetVoiceRadioTechRequest(const sp<RfxMessage>& request);
    virtual void handleGetAvailableNWRequest(const sp<RfxMessage>& request);
    virtual void handleSetUnsolCellInfoListRate(const sp<RfxMessage>& request);
    virtual void handleReportAirplaneMode(const sp<RfxMessage>& request);

private:
    void onSimTaskReady(int slotId, RfxStatusKeyEnum key, RfxVariant old_value, RfxVariant value);

};

#endif /* __RP_NW_CONTROLLER_H__ */

