/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef __RP_SYS_CONTROLLER_H__
#define __RP_SYS_CONTROLLER_H__

/*****************************************************************************
 * Include
 *****************************************************************************/
#include "RfxController.h"
#include "RfxTimer.h"
#include "RtcCapabilitySwitchChecker.h"
#include "rfx_properties.h"
#include <utils/Vector.h>
#include "utils/Mutex.h"

using ::android::Mutex;

/*****************************************************************************
 * Class RpDataController
 *****************************************************************************/
class RpSysController : public RfxController {
    RFX_DECLARE_CLASS(RpSysController);  // Required: declare this class

public:
    RpSysController();
    virtual ~RpSysController();
    sp<RfxMessage> m_pending_request;

// Override
protected:

    virtual void onInit();
    virtual void onDeinit();
    virtual bool onHandleRequest(const sp<RfxMessage>& message);
    virtual bool onPreviewMessage(const sp<RfxMessage>& message);

    virtual void handleATRequest(const sp<RfxMessage>& request);
    virtual void handleRequestDeviceIdentity(const sp<RfxMessage>& request);
    virtual void handleGetRadioCapability(const sp<RfxMessage>& request);
    virtual bool handleSetRadioCapability(const sp<RfxMessage>& request);

private:
	void onTelephonyAssistantStatusChanged(RfxStatusKeyEnum key,
        RfxVariant old_value, RfxVariant value);

    int queryMainProtocol();
    void queryTplusWSupport();
    void queryKeep3GMode();
    void queryNoResetSupport();
    void queryActiveMode();
    void queryBearer();
    RtcCapabilitySwitchChecker *getCapabilityChecker();
    void calculateNewMainSlot(int capability, int slot, char* modemId);
    void processSetMajorSimResponse(const sp<RfxMessage> &message);
    void requestSetMajorSim(const sp<RfxMessage>& request);
    void handleRequestSwitchCapability(const sp<RfxMessage>& request);
    void setAllLocks();
    void setLock(int slot_id, RfxStatusKeyEnum key);
    int getLockState(int slot_id, RfxStatusKeyEnum key);
    void resetLock(int slot_id, RfxStatusKeyEnum key);
    void onDefaultDataChanged(RfxStatusKeyEnum key, RfxVariant old_value, RfxVariant new_value);
    void onVolteStateChanged(RfxStatusKeyEnum key, RfxVariant old_value, RfxVariant new_value);
    void registerStatusKeys();
    void unregisterStatusKeys();
    void onStatusKeyChanged(RfxStatusKeyEnum key, RfxVariant old_value, RfxVariant new_value);
    void checkAndSwitchCapability();
    bool isPendingUndoneSwitch();
    int getUndoneSwitch();
    void notifySetRatDone();
    int getActiveMode();
    void setSimSwitchProp(int old_major_slot, int new_major_slot);
    void switchCapability(int old_major_slot, int new_major_slot);
    void shiftCapability(int old_major_slot, int new_major_slot);
    void switchFixedCapability(int slot_a, int slot_b);
    void setCapabilityByConfig(int slot, bool is_major_slot);
    void updateRadioCapability();
    void updateRadioCapability(int cslot);
    void updateRadioCapability(int cslot, int session_id);
    void sendRadioCapabilityURC(int slot_id, int session_id, int radio_capability);

    int m_cslot;
    bool m_first_urc;
    RtcCapabilitySwitchChecker* m_pChecker;
    static bool s_first_instance;
    static Mutex s_first_instance_mutex;
    char rat_properties[MAX_SIM_COUNT][RFX_PROPERTY_VALUE_MAX] = {
        "ro.vendor.mtk.protocol1.rat.config",
        "persist.vendor.radio.mtk.ps2.rat",
        "persist.vendor.radio.mtk.ps3.rat",
        "persist.vendor.radio.mtk.ps4.rat"};
};

#endif /* __RP_SYS_CONTROLLER_H__ */

