// SPDX-License-Identifier: MediaTekProprietary
/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#ifndef _MIPC_APN_API_H_
#define _MIPC_APN_API_H_

/*!
    \defgroup APN
    @{
*/

#include "mipc_api.h"

/** @brief ip type of data stream*/
typedef enum {
    MIPC_APN_ENUM_PDP_TYPE_DEFAULT = MIPC_APN_PDP_TYPE_DEFAULT,/*!< host does not care what IP type is activated.*/
    MIPC_APN_ENUM_PDP_TYPE_IPV4 = MIPC_APN_PDP_TYPE_IPV4,/*!< ipv4 */
    MIPC_APN_ENUM_PDP_TYPE_IPV6 = MIPC_APN_PDP_TYPE_IPV6,/*!< ipv6 */
    MIPC_APN_ENUM_PDP_TYPE_IPV4V6 = MIPC_APN_PDP_TYPE_IPV4V6,/*!< Corresponds to the IPv4v6 context type specified in 3gpp. */
} mipc_apn_pdp_type_enum;


/** @brief auth type protocol */
typedef enum {
    MIPC_APN_ENUM_AUTH_TYPE_NONE = MIPC_APN_AUTH_TYPE_NONE,/*!< none */
    MIPC_APN_ENUM_AUTH_TYPE_PAP = MIPC_APN_AUTH_TYPE_PAP,/*!< pap */
    MIPC_APN_ENUM_AUTH_TYPE_CHAP = MIPC_APN_AUTH_TYPE_CHAP,/*!< chap */
    MIPC_APN_ENUM_AUTH_TYPE_RAP_OR_CHAP = MIPC_APN_AUTH_TYPE_PAP_OR_CHAP
} mipc_apn_auth_type_enum;

/** @brief data stream context type */
typedef enum {
    MIPC_APN_ENUM_TYPE_DEFAULT = MIPC_APN_TYPE_DEFAULT,/*!< The context represents a connection to the Internet */
    MIPC_APN_ENUM_TYPE_IMS = MIPC_APN_TYPE_IMS,/*!< The context represents a connection to IMS.*/
    MIPC_APN_ENUM_TYPE_MMS = MIPC_APN_TYPE_MMS,/*!< The context represents a connection to MMS.*/
    MIPC_APN_ENUM_TYPE_SUPL = MIPC_APN_TYPE_SUPL,/*!< The context represents a connection to SUPL.*/
    MIPC_APN_ENUM_TYPE_DUN = MIPC_APN_TYPE_DUN,/*!< The context represents a connection to DUN.*/
    MIPC_APN_ENUM_TYPE_FOTA = MIPC_APN_TYPE_FOTA,/*!< The context represents a connection to FOTA.*/
    MIPC_APN_ENUM_TYPE_EMERGENCY = MIPC_APN_TYPE_EMERGENCY,/*!< The context represents a connection to EMERGENCY.*/
    MIPC_APN_ENUM_TYPE_IA = MIPC_APN_TYPE_IA,/*!< The context represents a connection to IA.*/
    MIPC_APN_ENUM_TYPE_XCAP = MIPC_APN_TYPE_XCAP,/*!< The context represents a connection to XCAP.*/
    MIPC_APN_ENUM_TYPE_RCS_PCSCF = MIPC_APN_TYPE_RCS_PCSCF,/*!< The context represents a connection to RCS PCSCF.*/
    MIPC_APN_ENUM_TYPE_VSIM = MIPC_APN_TYPE_VSIM/*!< The context represents a connection to VSIM.*/
} mipc_apn_type_enum;

/** @brief compression */
typedef enum {
    MIPC_APN_ENUM_COMPRESSION_NONE = MIPC_APN_COMPRESSION_NONE,/*!< compression none */
    MIPC_APN_ENUM_COMPRESSION_ENABLE = MIPC_APN_COMPRESSION_ENABLE/*!< compression enable*/
} mipc_apn_compression_enum;

/** @brief lte attach apn info */
typedef struct {
    /** @brief result code*/
    mipc_result_enum result_code;

    /** @brief total apn list count*/
    uint8_t ia_list_count;
    /** @brief ia_list, each element is mipc_apn_ia_struct*/
    mipc_apn_ia_struct4 ia_list[0];
} mipc_apn_ia_struct_v;

typedef struct {
    /** @brief result code*/
    mipc_result_enum result_code;

    /** @brief total apn list count*/
    uint8_t apn_list_count;
    /** @brief apn_list, each element is mipc_apn_profile_struct*/
    mipc_apn_profile_struct4 apn_list[0];
} mipc_apn_profiles_struct_v;

/**
  *@brief callback function prototype for async. IA set operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_APN_IA_SET_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_apn_ia_struct_v *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief callback function prototype for async. IA get operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_APN_IA_GET_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_apn_ia_struct_v *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief callback function prototype for IA change notification operation
  *@param[in] sim_ps_id indicate which sim or ps received the event (the value is decided by what is used when doing register operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_APN_IA_IND_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_apn_ia_struct_v *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function for sync. IA set operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] apn_ptr point to apn
  *@param[in] pdp_type ip typea used for home
  *@param[in] roaming_type ip type used for roaming
  *@param[in] auth_type auth protocol type
  *@param[in] userid_ptr point to userid
  *@param[in] password_ptr point to password
  *@param[in] bearer_bitmask bearer bitmask
  *@param[in] compression header and data compression setting
*/
mipc_api_result_enum mipc_apn_ia_set_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_apn_ia_struct_v *result_ptr,
    char *apn_ptr,
    mipc_apn_pdp_type_enum pdp_type,
    mipc_apn_pdp_type_enum roaming_type,
    mipc_apn_auth_type_enum auth_type,
    char *userid_ptr,
    char *password_ptr,
    uint32_t bearer_bitmask,
    mipc_apn_compression_enum compression
);


/**
  *@brief function for async. IA set operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
  *@param[in] apn_ptr point to apn
  *@param[in] pdp_type ip typea used for home
  *@param[in] roaming_type ip type used for roaming
  *@param[in] auth_type auth protocol type
  *@param[in] userid_ptr point to userid
  *@param[in] password_ptr point to password
  *@param[in] bearer_bitmask bearer bitmask
  *@param[in] compression header and data compression setting
*/
mipc_api_result_enum mipc_apn_ia_set_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_APN_IA_SET_CB cb,
    void *cb_priv_ptr,
    char *apn_ptr,
    mipc_apn_pdp_type_enum pdp_type,
    mipc_apn_pdp_type_enum roaming_type,
    mipc_apn_auth_type_enum auth_type,
    char *userid_ptr,
    char *password_ptr,
    uint32_t bearer_bitmask,
    mipc_apn_compression_enum compression
);

/**
  *@brief function for sync. IA get operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
*/
mipc_api_result_enum mipc_apn_ia_get_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_apn_ia_struct_v *result_ptr
);

/**
  *@brief function for async. IA get operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
*/
mipc_api_result_enum mipc_apn_ia_get_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_APN_IA_GET_CB cb,
    void *cb_priv_ptr
);

/**
  *@brief function to register callback function for IA changed notificaton
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
*/
mipc_api_result_enum mipc_apn_ia_register(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_APN_IA_IND_CB cb,
    void *cb_priv_ptr
);

/**
  *@brief callback function prototype for async. apn profile update operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_APN_PROFILE_UPDATE_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_apn_profiles_struct_v *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief callback function prototype for async. apn profile get operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_APN_PROFILE_GET_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_apn_profiles_struct_v *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief callback function prototype for async. apn profile del operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_APN_PROFILE_DEL_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_apn_profiles_struct_v *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief callback function prototype for apn profile change notification operation
  *@param[in] sim_ps_id indicate which sim or ps received the event (the value is decided by what is used when doing register operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_APN_PROFILE_IND_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_apn_profiles_struct_v *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function for sync. apn profile update operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] id profile id
  *@param[in] plmnid_ptr point to plmn id
  *@param[in] apn_ptr point to apn
  *@param[in] apn_type apn type
  *@param[in] pdp_type ip type used for home
  *@param[in] roaming_type ip type used for roaming
  *@param[in] auth_type auth protocol type
  *@param[in] userid_ptr point to userid
  *@param[in] password_ptr point to password
  *@param[in] bearer_bitmask bearer bitmask
  *@param[in] compression header and data compression setting
*/
mipc_api_result_enum mipc_apn_profile_update_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_apn_profiles_struct_v *result_ptr,
    uint32_t id,
    char *plmnid_ptr,
    char *apn_ptr,
    uint32_t apn_type,
    mipc_apn_pdp_type_enum pdp_type,
    mipc_apn_pdp_type_enum roaming_type,
    mipc_apn_auth_type_enum auth_type,
    char *userid_ptr,
    char *password_ptr,
    uint32_t bearer_bitmask,
    mipc_apn_compression_enum compression
);

/**
  *@brief function for async. apn profile update operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
  *@param[in] id profile id
  *@param[in] plmnid_ptr point to plmn id
  *@param[in] apn_ptr point to apn
  *@param[in] apn_type apn type
  *@param[in] pdp_type ip type used for home
  *@param[in] roaming_type ip type used for roaming
  *@param[in] auth_type auth protocol type
  *@param[in] userid_ptr point to userid
  *@param[in] password_ptr point to password
  *@param[in] bearer_bitmask bearer bitmask
  *@param[in] compression header and data compression setting
*/
mipc_api_result_enum mipc_apn_profile_update_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_APN_PROFILE_UPDATE_CB cb,
    void *cb_priv_ptr,
    uint32_t id,
    char *plmnid_ptr,
    char *apn_ptr,
    uint32_t apn_type,
    mipc_apn_pdp_type_enum pdp_type,
    mipc_apn_pdp_type_enum roaming_type,
    mipc_apn_auth_type_enum auth_type,
    char *userid_ptr,
    char *password_ptr,
    uint32_t bearer_bitmask,
    mipc_apn_compression_enum compression
);

/**
  *@brief function for sync. apn profile get operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
*/
mipc_api_result_enum mipc_apn_profile_get_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_apn_profiles_struct_v *result_ptr
);

/**
  *@brief function for async. apn profile get operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
*/
mipc_api_result_enum mipc_apn_profile_get_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_APN_PROFILE_GET_CB cb,
    void *cb_priv_ptr
);

/**
  *@brief function for sync. apn profile del operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] id profile id
*/
mipc_api_result_enum mipc_apn_profile_del_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_apn_profiles_struct_v *result_ptr,
    uint32_t id
);

/**
  *@brief function for async. apn profile del operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
  *@param[in] id profile id
*/
mipc_api_result_enum mipc_apn_profile_del_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_APN_PROFILE_DEL_CB cb,
    void *cb_priv_ptr,
    uint32_t id
);

/**
  *@brief function to register callback function for apn profile changed notificaton
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
*/
mipc_api_result_enum mipc_apn_profile_register(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_APN_PROFILE_IND_CB cb,
    void *cb_priv_ptr
);

/*!
    @}
*/

#endif
