/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#ifndef HARDWARE_RIL_FUSION_LIBRIL_RILMIPC_TELEPHONY_NW_MIPC_RADIO_API_H_
#define HARDWARE_RIL_FUSION_LIBRIL_RILMIPC_TELEPHONY_NW_MIPC_RADIO_API_H_

#include "mipc_api.h"
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_const.h"


/** @brief Radio state struct */
typedef struct {
    /** @brief Just valid for set/get result, indicate the operation result. */
    mipc_result_enum result_code;

    /** @brief hw radio state */
    mipc_nw_radio_state_const_enum hw_radio_state;
    /** @brief sw radio state */
    mipc_nw_radio_state_const_enum sw_radio_state;
} mipc_nw_radio_state_struct;

typedef struct {
    /** @brief Just valid for set/get result, indicate the operation result. */
    mipc_result_enum result_code;
} mipc_sys_silent_reboot_struct;

/**
  *@brief callback function prototype for async. radio state set operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_NW_RADIO_STATE_SET_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_radio_state_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief callback function prototype for async. radio state get operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_NW_RADIO_STATE_GET_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_radio_state_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief callback function prototype for async. radio state set operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_SYS_SILENT_REBOOT_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sys_silent_reboot_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief callback function prototype for radio state changed notification operation
  * This function will be called when radio state changed.
  *@param[in] sim_ps_id indicate which sim or ps received the event (the value is decided by what is used when doing register operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_NW_RADIO_STATE_IND_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_radio_state_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function for sync. radio state set operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] radio_state expected radio state to set
*/
mipc_api_result_enum mipc_nw_radio_state_set_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_radio_state_struct *result_ptr,
    mipc_nw_radio_state_const_enum radio_state
);

/**
  *@brief function for async. radio state set operation
  *@param[in] sim_ps_id indicate which sim or ps received the event (the value is decided by what is used when doing register operation)
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
  *@param[in] radio_state expected radio state to set
*/
mipc_api_result_enum mipc_nw_radio_state_set_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_NW_RADIO_STATE_SET_CB cb,
    void *cb_priv_ptr,
    mipc_nw_radio_state_const_enum radio_state
);

/**
  *@brief function for sync. Boot up mode set operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] boot_mode expected boot up mode to set
*/
mipc_api_result_enum mipc_sys_silent_reboot_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sys_silent_reboot_struct *result_ptr,
    uint8_t boot_mode
);

/**
  *@brief function for async. Boot up mode set operation
  *@param[in] sim_ps_id indicate which sim or ps received the event (the value is decided by what is used when doing register operation)
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
  *@param[in] boot_mode expected boot up mode to set
*/
mipc_api_result_enum mipc_sys_silent_reboot_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SYS_SILENT_REBOOT_CB cb,
    void *cb_priv_ptr,
    uint8_t boot_mode
);

/**
  *@brief function for sync. radio state get operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
*/
mipc_api_result_enum mipc_nw_radio_state_get_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_radio_state_struct *result_ptr
);

/**
  *@brief function for async. radio state get operation
  *@param[in] sim_ps_id indicate which sim or ps received the event (the value is decided by what is used when doing register operation)
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
*/
mipc_api_result_enum mipc_nw_radio_state_get_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_NW_RADIO_STATE_GET_CB cb,
    void *cb_priv_ptr
);

/**
  *@brief function to register callback function for radio state changed notificaton
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
*/
mipc_api_result_enum mipc_nw_radio_state_register(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_NW_RADIO_STATE_IND_CB cb,
    void *cb_priv_ptr
);

#endif /* HARDWARE_RIL_FUSION_LIBRIL_RILMIPC_TELEPHONY_NW_MIPC_RADIO_API_H_ */
