/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/
#include "mipc_radio_api.h"

#define DEFAULT_ELEMENT_COUNT 10
#define MAX_MCC_MNC_LEN 6

//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_nw_radio_state_set_cnf(mipc_msg_t *msg_ptr, mipc_nw_radio_state_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;
    char *t_nwtmp_ptr;
    uint16_t t_nwtmp_len;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
            if ((t_nwtmp_ptr = (char *)mipc_msg_get_val_ptr(msg_ptr, MIPC_NW_SET_RADIO_STATE_CNF_T_SW_STATE, &t_nwtmp_len)) == NULL) break;
            result_ptr->sw_radio_state = (mipc_nw_radio_state_const_enum) * ((uint8_t *)t_nwtmp_ptr);
            if ((t_nwtmp_ptr = (char *)mipc_msg_get_val_ptr(msg_ptr, MIPC_NW_SET_RADIO_STATE_CNF_T_HW_STATE, &t_nwtmp_len)) == NULL) break;
            result_ptr->hw_radio_state = (mipc_nw_radio_state_const_enum) * ((uint8_t *)t_nwtmp_ptr);
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}
static void mipc_nw_radio_state_set_cnf_cb(mipc_msg_t *msg_ptr, MIPC_NW_RADIO_STATE_SET_CB cb, void *cb_priv_ptr)
{
    mipc_nw_radio_state_struct *result_ptr = (mipc_nw_radio_state_struct *)ALLOC(sizeof(mipc_nw_radio_state_struct));
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_nw_radio_state_struct));
        mipc_nw_radio_state_set_cnf(msg_ptr, result_ptr);
    }

    cb(sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}
static mipc_api_result_enum mipc_nw_radio_state_set_req(MIPC_NW_RADIO_STATE_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_nw_radio_state_struct *result_ptr, mipc_nw_radio_state_const_enum radio_state)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_NW_SET_RADIO_STATE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is only one TLV parameter)
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_NW_SET_RADIO_STATE_REQ_T_SW_STATE, radio_state);
    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_nw_radio_state_set_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_nw_radio_state_set_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_nw_radio_state_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_nw_radio_state_struct *result_ptr, mipc_nw_radio_state_const_enum radio_state)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_nw_radio_state_set_req(NULL, NULL, sim_ps_id, result_ptr, radio_state);
}

mipc_api_result_enum mipc_nw_radio_state_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_NW_RADIO_STATE_SET_CB cb, void *cb_priv_ptr, mipc_nw_radio_state_const_enum radio_state)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_nw_radio_state_set_req(cb, cb_priv_ptr, sim_ps_id, NULL, radio_state);
}

////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_silent_reboot_cnf(mipc_msg_t *msg_ptr, mipc_result_enum *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;
    char *t_nwtmp_ptr;
    uint16_t t_nwtmp_len;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            *result_ptr = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            *result_ptr = MIPC_RESULT_SUCCESS;
        } else {
            *result_ptr = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        *result_ptr = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_silent_reboot_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_SILENT_REBOOT_CB cb, void *cb_priv_ptr)
{
    mipc_result_enum *result_ptr = (mipc_result_enum *)ALLOC(sizeof(mipc_result_enum));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_result_enum));
        mipc_sys_silent_reboot_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_silent_reboot_req(MIPC_SYS_SILENT_REBOOT_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_silent_reboot_struct *result_ptr, uint8_t boot_mode)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_SILENT_REBOOT_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is only one TLV parameter)
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SYS_SILENT_REBOOT_REQ_T_MODE, boot_mode);
    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_silent_reboot_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_silent_reboot_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_silent_reboot_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_silent_reboot_struct *result_ptr, uint8_t boot_mode)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_silent_reboot_req(NULL, NULL, sim_ps_id, result_ptr, boot_mode);
}

mipc_api_result_enum mipc_sys_silent_reboot_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_SILENT_REBOOT_CB cb, void *cb_priv_ptr, uint8_t boot_mode)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_silent_reboot_req(cb, cb_priv_ptr, sim_ps_id, NULL, boot_mode);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_nw_radio_state_get_cnf(mipc_msg_t *msg_ptr, mipc_nw_radio_state_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;
    char *t_nwtmp_ptr;
    uint16_t t_nwtmp_len;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
            if ((t_nwtmp_ptr = (char *)mipc_msg_get_val_ptr(msg_ptr, MIPC_NW_GET_RADIO_STATE_CNF_T_SW_STATE, &t_nwtmp_len)) == NULL) break;
            result_ptr->sw_radio_state = (mipc_nw_radio_state_const_enum) * ((uint8_t *)t_nwtmp_ptr);
            if ((t_nwtmp_ptr = (char *)mipc_msg_get_val_ptr(msg_ptr, MIPC_NW_GET_RADIO_STATE_CNF_T_HW_STATE, &t_nwtmp_len)) == NULL) break;
            result_ptr->hw_radio_state = (mipc_nw_radio_state_const_enum) * ((uint8_t *)t_nwtmp_ptr);
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}
static void mipc_nw_radio_state_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_NW_RADIO_STATE_GET_CB cb, void *cb_priv_ptr)
{
    mipc_nw_radio_state_struct *result_ptr = (mipc_nw_radio_state_struct *)ALLOC(sizeof(mipc_nw_radio_state_struct));
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_nw_radio_state_struct));
        mipc_nw_radio_state_get_cnf(msg_ptr, result_ptr);
    }

    cb(sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}
static mipc_api_result_enum mipc_nw_radio_state_get_req(MIPC_NW_RADIO_STATE_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_nw_radio_state_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_NW_GET_RADIO_STATE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is only one TLV parameter)

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_nw_radio_state_get_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_nw_radio_state_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}
mipc_api_result_enum mipc_nw_radio_state_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_nw_radio_state_struct *result_ptr)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_nw_radio_state_get_req(NULL, NULL, sim_ps_id, result_ptr);
}
mipc_api_result_enum mipc_nw_radio_state_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_NW_RADIO_STATE_GET_CB cb, void *cb_priv_ptr)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_nw_radio_state_get_req(cb, cb_priv_ptr, sim_ps_id, NULL);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_nw_radio_state_ind(mipc_msg_t *msg_ptr, mipc_nw_radio_state_struct *result_ptr)
{
    char *t_nwtmp_ptr;
    uint8_t api_error = 1;

    do {
        result_ptr->result_code = MIPC_RESULT_SUCCESS;
        if ((t_nwtmp_ptr = (char *)mipc_msg_get_val_ptr(msg_ptr, MIPC_NW_RADIO_IND_T_SW_STATE, NULL)) == NULL) break;
        result_ptr->sw_radio_state = (mipc_nw_radio_state_const_enum) * ((uint8_t *)t_nwtmp_ptr);
        if ((t_nwtmp_ptr = (char *)mipc_msg_get_val_ptr(msg_ptr, MIPC_NW_RADIO_IND_T_HW_STATE, NULL)) == NULL) break;
        result_ptr->hw_radio_state = (mipc_nw_radio_state_const_enum) * ((uint8_t *)t_nwtmp_ptr);
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}
static void mipc_nw_radio_state_ind_cb(mipc_msg_t *msg_ptr, MIPC_NW_RADIO_STATE_IND_CB cb, void *cb_priv_ptr)
{
    mipc_nw_radio_state_struct *result_ptr = (mipc_nw_radio_state_struct *)ALLOC(sizeof(mipc_nw_radio_state_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_nw_radio_state_struct));
        if (mipc_nw_radio_state_ind(msg_ptr, result_ptr) == MIPC_API_RESULT_SUCCESS) {
            cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
        }
        FREE(result_ptr);
    }
}
mipc_api_result_enum mipc_nw_radio_state_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_NW_RADIO_STATE_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_nw_radio_state_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_NW_RADIO_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}
