#include <mtk_log.h>
#include <string.h>
#include "mtk_properties.h"

#define LOG_TAG "mtk_properties"

extern int property_get(const char *key, char *value, const char *default_value);
extern int property_set(const char *key, const char *in_value);

/*
 * Get property from alios platform.
 * Another api mtk_property_get() in PCS is for Telephonyware module.
 */
int mtk_property_get(const char *key, char *value, const char *default_value)
{
    int ali_pro_res =  property_get(key, value, default_value);
//xf.li@20231120 modify for T8TSK-291 start
    if((strcmp(key, "vendor.ril.iccid.sim1") != 0) && (strcmp(key, "vendor.ril.iccid.sim2") != 0))
    {
        mtkLogD(LOG_TAG, "get key is %s, value is %s", key, value);
    }
    else
    {
	if(value != NULL && strlen(value) > 0)
        {
            mtkLogD(LOG_TAG, "get key is %s, value is (has got)", key);
        }
        else
        {
            mtkLogD(LOG_TAG, "get key is %s, value is ", key);
        }
    }
//xf.li@20231120 modify for T8TSK-291 end
    return ali_pro_res;
}

/*
 * Set property into alios platform.
 * Another api mtk_property_set() in PCS maybe trigger start service
 * before set property, this api is only for Telephonyware module.
 */
int mtk_property_set(const char *key, const char *value)
{
    int ret_val = property_set(key, value);
//xf.li@20231120 modify for T8TSK-291 start
    if((strcmp(key, "vendor.ril.iccid.sim1") != 0) && (strcmp(key, "vendor.ril.iccid.sim2") != 0))
    {
        mtkLogD(LOG_TAG, "set key is %s, value is %s", key, value);
    }
    else
    {
	if(value != NULL && strlen(value) > 0)
        {
            mtkLogD(LOG_TAG, "set key is %s, value is (has got)", key);
        }
        else
        {
            mtkLogD(LOG_TAG, "set key is %s, value is ", key);
        }
    }
//xf.li@20231120 modify for T8TSK-291 end
    return ret_val;
}
