/*
 * apn_test.cpp
 *
 *  Created on: Nov 10, 2016
 *      Author: mtk54498
 */
#include "gtest/gtest.h"
#include "apn_interface.h"
#include "apn_manager.h"
#include "LogUtils.h"
#include "gmock/gmock.h"

const char* parseContent = "<?xml version=\"1.0\" encoding=\"utf-8\"?>"
		"\n<apns version=\"8\">\n"
		"<apn carrier=\"TEST APN1\"\n"
		"mcc=\"000\"\n"
		"mnc=\"01\"\n"
		"apn=\"internet\"\n"
		"port=\"80\"\n"
		"user=\"user\"\n"
		"password=\"pass\"\n"
		"type=\"default,supl\"\n"
		"authtype=\"0\"\n"
		"/>\n"
		" <apn carrier=\"TEST APN2\"\n"
		"mcc=\"000\"\n"
		"mnc=\"02\"\n"
		"apn=\"mms.base.be\"\n"
		"user=\"base\"\n"
		"password=\"base\"\n"
		"mmsc=\"http://mmsc.base.be\"\n"
		"mmsproxy=\"217.72.235.1\"\n"
		"mmsport=\"8080\"\n"
		"type=\"mms\"\n"
		"/>\n"
		"</apns>";

TEST(APN_BASIC_TEST, testColumns) {
	int idx = -1;
	idx = apn_get_idx_by_name(APN_PROP_ID);
	EXPECT_EQ(idx, APN_PROP_iId);
	idx = apn_get_idx_by_name(APN_PROP_TYPE);
	EXPECT_EQ(idx, APN_PROP_iTYPE);
	idx = apn_get_idx_by_name(APN_PROP_MCC);
	EXPECT_EQ(idx, APN_PROP_iMCC);
	idx = apn_get_idx_by_name(APN_PROP_MNC);
	EXPECT_EQ(idx, APN_PROP_iMNC);
	idx = apn_get_idx_by_name(APN_PROP_CARRIER);
	EXPECT_EQ(idx, APN_PROP_iCARRIER);
	idx = apn_get_idx_by_name(APN_PROP_APN);
	EXPECT_EQ(idx, APN_PROP_iAPN);
	idx = apn_get_idx_by_name(APN_PROP_PORT);
	EXPECT_EQ(idx, APN_PROP_iPORT);
	idx = apn_get_idx_by_name(APN_PROP_PROXY);
	EXPECT_EQ(idx, APN_PROP_iPROXY);
	idx = apn_get_idx_by_name(APN_PROP_MMSC);
	EXPECT_EQ(idx, APN_PROP_iMMSC);
	idx = apn_get_idx_by_name(APN_PROP_MMSPROXY);
	EXPECT_EQ(idx, APN_PROP_iMMSPROXY);
	idx = apn_get_idx_by_name(APN_PROP_MMSPORT);
	EXPECT_EQ(idx, APN_PROP_iMMSPORT);
	idx = apn_get_idx_by_name(APN_PROP_USER);
	EXPECT_EQ(idx, APN_PROP_iUSER);
	idx = apn_get_idx_by_name(APN_PROP_PASSWORD);
	EXPECT_EQ(idx, APN_PROP_iPASSWORD);
	idx = apn_get_idx_by_name(APN_PROP_AUTH_TYPE);
	EXPECT_EQ(idx, APN_PROP_iAUTH_TYPE);
	idx = apn_get_idx_by_name(APN_PROP_SERVER);
	EXPECT_EQ(idx, APN_PROP_iSERVER);
	idx = apn_get_idx_by_name(APN_PROP_PROTOCOL);
	EXPECT_EQ(idx, APN_PROP_iPROTOCOL);
	idx = apn_get_idx_by_name(APN_PROP_ROAMING_PROTOCOL);
	EXPECT_EQ(idx, APN_PROP_iROAMING_PROTOCOL);
	idx = apn_get_idx_by_name(APN_PROP_MTU);
	EXPECT_EQ(idx, APN_PROP_iMTU);
	idx = apn_get_idx_by_name(APN_PROP_CARRIER_ENABLED);
	EXPECT_EQ(idx, APN_PROP_iCARRIER_ENABLED);
	idx = apn_get_idx_by_name(APN_PROP_BEARER);
	EXPECT_EQ(idx, APN_PROP_iBEARER);
	idx = apn_get_idx_by_name(APN_PROP_BEARER_BITMASK);
	EXPECT_EQ(idx, APN_PROP_iBEARER_BITMASK);
	idx = apn_get_idx_by_name(APN_PROP_PROFILE_ID);
	EXPECT_EQ(idx, APN_PROP_iPROFILE_ID);
	idx = apn_get_idx_by_name(APN_PROP_MODEM_COGNITIVE);
	EXPECT_EQ(idx, APN_PROP_iMODEM_COGNITIVE);
	idx = apn_get_idx_by_name(APN_PROP_MAXCONNS);
	EXPECT_EQ(idx, APN_PROP_iMAXCONNS);
	idx = apn_get_idx_by_name(APN_PROP_WAITTIME);
	EXPECT_EQ(idx, APN_PROP_iWAITTIME);
	idx = apn_get_idx_by_name(APN_PROP_MAXCONNSTIME);
	EXPECT_EQ(idx, APN_PROP_iMAXCONNSTIME);
	idx = apn_get_idx_by_name(APN_PROP_MVNO_TYPE);
	EXPECT_EQ(idx, APN_PROP_iMVNO_TYPE);
	idx = apn_get_idx_by_name(APN_PROP_USER_VISIBLE);
	EXPECT_EQ(idx, APN_PROP_iUSER_VISIBLE);
	idx = apn_get_idx_by_name(APN_PROP_CURRENT);
	EXPECT_EQ(idx, APN_PROP_iCURRENT);
	idx = apn_get_idx_by_name("dummy");
	EXPECT_EQ(idx, APN_ERR);
}

TEST(APN_TEST, testParseXml) {
	apn_manager* instance = apn_manager::forTestOnly();
	int contentLen = strlen(parseContent);
	xmlDocPtr doc = NULL;
	xmlNode *root_element = NULL;
	apn_list_t* apn_list = NULL;
	doc = xmlParseMemory(parseContent, contentLen);
	if (doc == NULL) {
		SLOGD("parseRes %s!", xmlGetLastError()->message);
		return;
	}
	root_element = xmlDocGetRootElement(doc);
	EXPECT_TRUE(root_element != NULL);
	apn_list = new apn_list_t();
	EXPECT_TRUE(apn_list != NULL);
	memset(apn_list, 0, sizeof(apn_list_t));
	instance->loadApnSettings(apn_list, "apn", root_element);
	EXPECT_EQ(apn_list->count, 2);
	apn_record_t* record = apn_list->top;
	EXPECT_STREQ(apn_get_prop_from_record(record, APN_PROP_iTYPE),
			"default,supl");
	EXPECT_STREQ(apn_get_prop_from_record(record, APN_PROP_iMCC), "000");
	EXPECT_STREQ(apn_get_prop_from_record(record, APN_PROP_iMNC), "01");
	EXPECT_STREQ(apn_get_prop_from_record(record, APN_PROP_iCARRIER),
			"TEST APN1");
	EXPECT_STREQ(apn_get_prop_from_record(record, APN_PROP_iAPN), "internet");
	EXPECT_STREQ(apn_get_prop_from_record(record, APN_PROP_iPORT), "80");
	EXPECT_STREQ(apn_get_prop_from_record(record, APN_PROP_iPROXY), NULL);
	EXPECT_STREQ(apn_get_prop_from_record(record, APN_PROP_iMMSC), NULL);
	EXPECT_STREQ(apn_get_prop_from_record(record, APN_PROP_iUSER), "user");
	EXPECT_STREQ(apn_get_prop_from_record(record, APN_PROP_iPASSWORD), "pass");
	EXPECT_STREQ(apn_get_prop_from_record(record, APN_PROP_iAUTH_TYPE), "0");

	apn_free_list(apn_list);
	if (doc != NULL) {
		xmlFreeDoc(doc);
		xmlCleanupParser();
	}
	delete instance;
}
