//SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
 /*
  * RfxParcelTranferUtil.cpp
  *
  *  Created on: 2018/08/21
  *  Author: MTK06564
  *
  */
#include "RfxParcelTransferUtils.h"
#include "ril.h"

#define LOG_TAG "RfxParcelTransferUtils"

#define fillReqID(parcel, ID) do {\
      (parcel)->setDataPosition(0);\
      (parcel)->writeInt32((ID) & 0xFFFFFFFF);\
    }while(0)

#define copyReqHeader(new_p, old_p) do {\
        (old_p)->setDataPosition(0);\
        (new_p)->appendFrom(old_p, 0, sizeof(int32_t)*2);\
        (old_p)->setDataPosition(sizeof(int32_t)*2);\
        (new_p)->setDataPosition(sizeof(int32_t)*2);\
    }while(0)

#define copyRespHeader(new_p, old_p) do {\
         (old_p)->setDataPosition(0);\
         (new_p)->appendFrom(old_p, 0, sizeof(int32_t)*3);\
         (old_p)->setDataPosition(sizeof(int32_t)*3);\
         (new_p)->setDataPosition(sizeof(int32_t)*3);\
    }while(0)

#define copyUrcHeader(new_p, old_p) do {\
        (old_p)->setDataPosition(0);\
        (new_p)->appendFrom(old_p, 0, sizeof(int32_t)*2);\
        (old_p)->setDataPosition(sizeof(int32_t)*2);\
        (new_p)->setDataPosition(sizeof(int32_t)*2);\
    }while(0)

#if 0
#define fillUrcID(parcel, ID) do {\
         (parcel)->setDataPosition(sizeof(int32_t));\
         (parcel)->writeInt32((ID) & 0xFFFFFFFF);\
         (parcel)->setDataPosition(sizeof(int32_t)*2);\
    }while(0)
#endif

static char *
strdupReadString(Parcel *p) {
    size_t stringlen;
    const char16_t *s16;

    s16 = p->readString16Inplace(&stringlen);

    return strndup16to8(s16, stringlen);
}

static void writeStringToParcel(Parcel *p, const char *s) {
    char16_t *s16;
    size_t s16_len = 0;
    s16 = strdup8to16(s, &s16_len);
    p->writeString16(s16, s16_len);
    free(s16);
}



void TransferUtilsPreferredNetworkType( Parcel *old_parcel,  Parcel *new_parcel)
{
     int value = 0, new_value;
    /*profile num*/

    old_parcel->readInt32(&value);
    RFX_LOG_D(LOG_TAG, "TransferUtilsPreferredNetworkType = %d", value);
    new_parcel->writeInt32(value);
    old_parcel->readInt32(&value);
    RFX_LOG_D(LOG_TAG, "TransferUtilsPreferredNetworkType 1= %d", value);
    switch(value)
    {
        case PREF_NET_TYPE_GSM_WCDMA:
        case PREF_NET_TYPE_GSM_ONLY:
        case PREF_NET_TYPE_WCDMA:
        case PREF_NET_TYPE_GSM_WCDMA_AUTO:
        case PREF_NET_TYPE_CDMA_EVDO_AUTO:
        case PREF_NET_TYPE_CDMA_ONLY:
        case PREF_NET_TYPE_EVDO_ONLY:
        case PREF_NET_TYPE_GSM_WCDMA_CDMA_EVDO_AUTO:
        case PREF_NET_TYPE_LTE_CDMA_EVDO:
        case PREF_NET_TYPE_LTE_GSM_WCDMA:
        case PREF_NET_TYPE_LTE_CMDA_EVDO_GSM_WCDMA:
        case PREF_NET_TYPE_LTE_ONLY:
        case PREF_NET_TYPE_LTE_WCDMA:
        case PREF_NET_TYPE_NR_ONLY:
        case PREF_NET_TYPE_NR_LTE:
        case PREF_NET_TYPE_NR_LTE_CDMA_EVDO:
        case PREF_NET_TYPE_NR_LTE_GSM_WCDMA:
        case PREF_NET_TYPE_NR_LTE_WCDMA:
        case PREF_NET_TYPE_NR_LTE_TDSCDMA_CDMA_EVDO_GSM_WCDMA:
        case PREF_NET_TYPE_NR_LTE_TDSCDMA_GSM_WCDMA:
        case PREF_NET_TYPE_NR_LTE_TDSCDMA_GSM:
        case PREF_NET_TYPE_NR_LTE_TDSCDMA_WCDMA:
            new_value = value;
            break;
        default:
            new_value = PREF_NET_TYPE_LTE_GSM_WCDMA;  //Todo. needs modify
            break;
    }
    RFX_LOG_D(LOG_TAG, "TransferUtilsPreferredNetworkType 2= %d", new_value);

    new_parcel->writeInt32(new_value);

}
void TransferUtilsRadioTechnology( Parcel *old_parcel,  Parcel *new_parcel)
{
    int value = 0, new_value;
    /*profile num*/
    old_parcel->readInt32(&value);
    new_parcel->writeInt32(value);
    old_parcel->readInt32(&value);
    switch(value)
    {
        case RADIO_TECH_UNKNOWN :
        case RADIO_TECH_GPRS :
        case RADIO_TECH_EDGE :
        case RADIO_TECH_UMTS :
        case RADIO_TECH_IS95A :
        case RADIO_TECH_IS95B :
        case RADIO_TECH_1xRTT :
        case RADIO_TECH_EVDO_0 :
        case RADIO_TECH_EVDO_A :
        case RADIO_TECH_HSDPA :
        case RADIO_TECH_HSUPA :
        case RADIO_TECH_HSPA :
        case RADIO_TECH_EVDO_B :
        case RADIO_TECH_EHRPD :
        case RADIO_TECH_LTE :
        case RADIO_TECH_HSPAP :
        case RADIO_TECH_GSM :
        case RADIO_TECH_TD_SCDMA :
        case RADIO_TECH_IWLAN :
           new_value = value;
           break;
       default:
           new_value = RADIO_TECH_UNKNOWN;  //Todo. needs modify
           break;
    }
    new_parcel->writeInt32(new_value);
}
// Must be the same as CellInfo.TYPE_XXX

#if 1
typedef struct {
    char* long_name;
    char* short_name;
} RIL_OperName;
typedef struct {
    int mcc;    /* 3-digit Mobile Country Code, 0..999, INT_MAX if unknown */
    int mnc;    /* 2 or 3-digit Mobile Network Code, 0..999, INT_MAX if unknown */
    int mnc_len;
    int lac;    /* 16-bit Location Area Code, 0..65535, INT_MAX if unknown  */
    int cid;    /* 16-bit GSM Cell Identity described in TS 27.007, 0..65535, INT_MAX if unknown  */
    int arfcn;  /* 16-bit GSM Absolute RF channel number, INT_MAX if unknown */
    uint8_t bsic;/* 6-bit Base Station Identity Code, 0xFF if unknown */
    RIL_OperName operName;
} RIL_CellIdentityGsm_v12;


typedef struct {
    int signalStrength;  /* Valid values are (0-31, 99) as defined in TS 27.007 8.5 */
    int bitErrorRate;    /* bit error rate (0-7, 99) as defined in TS 27.007 8.5 */
    int timingAdvance;   /* Timing Advance in bit periods. 1 bit period = 48/13 us.
              * INT_MAX denotes invalid value */
} RIL_GSM_SignalStrength_v12;

typedef struct {
    RIL_CellIdentityGsm_v12   cellIdentityGsm;
    RIL_GSM_SignalStrength_v12 signalStrengthGsm;
} RIL_CellInfoGsm_v12;
typedef struct {
    int networkId;      /* Network Id 0..65535, INT_MAX if unknown */
    int systemId;       /* CDMA System Id 0..32767, INT_MAX if unknown  */
    int basestationId;  /* Base Station Id 0..65535, INT_MAX if unknown  */
    int longitude;      /* Longitude is a decimal number as specified in 3GPP2 C.S0005-A v6.0.
                         * It is represented in units of 0.25 seconds and ranges from -2592000
                         * to 2592000, both values inclusive (corresponding to a range of -180
                         * to +180 degrees). INT_MAX if unknown */

    int latitude;       /* Latitude is a decimal number as specified in 3GPP2 C.S0005-A v6.0.
                         * It is represented in units of 0.25 seconds and ranges from -1296000
                         * to 1296000, both values inclusive (corresponding to a range of -90
                         * to +90 degrees). INT_MAX if unknown */
    RIL_OperName operName;
} RIL_CellIdentityCdma_v12;

typedef struct {
  RIL_CellIdentityCdma_v12      cellIdentityCdma;
  RIL_CDMA_SignalStrength   signalStrengthCdma;
  RIL_EVDO_SignalStrength   signalStrengthEvdo;
} RIL_CellInfoCdma_v12;
typedef struct {
    int mcc;    /* 3-digit Mobile Country Code, 0..999, INT_MAX if unknown  */
    int mnc;    /* 2 or 3-digit Mobile Network Code, 0..999, INT_MAX if unknown  */
    int mnc_len;
    int ci;     /* 28-bit Cell Identity described in TS ???, INT_MAX if unknown */
    int pci;    /* physical cell id 0..503; this value must be reported */
    int tac;    /* 16-bit tracking area code, INT_MAX if unknown  */
    int earfcn; /* 18-bit LTE Absolute RF Channel Number; this value must be reported */
    RIL_OperName operName;
    int bandwidth;  /* Bandwidht in KHz */
} RIL_CellIdentityLte_v12;

typedef struct {
    RIL_CellIdentityLte_v12    cellIdentityLte;
    RIL_LTE_SignalStrength_v8  signalStrengthLte;  //the same with V11
} RIL_CellInfoLte_v12;

typedef struct {
    int mcc;    /* 3-digit Mobile Country Code, 0..999, INT_MAX if unknown  */
    int mnc;    /* 2 or 3-digit Mobile Network Code, 0..999, INT_MAX if unknown  */
    int mnc_len;
    int lac;    /* 16-bit Location Area Code, 0..65535, INT_MAX if unknown  */
    int cid;    /* 28-bit UMTS Cell Identity described in TS 25.331, 0..268435455, INT_MAX if unknown  */
    int psc;    /* 9-bit UMTS Primary Scrambling Code described in TS 25.331, 0..511, INT_MAX if unknown */
    int uarfcn; /* 16-bit UMTS Absolute RF Channel Number, INT_MAX if unknown */
    RIL_OperName operName;
} RIL_CellIdentityWcdma_v12;


typedef struct {
    RIL_CellIdentityWcdma_v12 cellIdentityWcdma;
    RIL_SignalStrengthWcdma signalStrengthWcdma;
} RIL_CellInfoWcdma_v12;

typedef struct {
   int mcc;    /* 3-digit Mobile Country Code, 0..999, INT_MAX if unknown  */
   int mnc;    /* 2 or 3-digit Mobile Network Code, 0..999, INT_MAX if unknown  */
   int mnc_len;
   int lac;    /* 16-bit Location Area Code, 0..65535, INT_MAX if unknown  */
   int cid;    /* 28-bit UMTS Cell Identity described in TS 25.331, 0..268435455, INT_MAX if unknown  */
   int cpid;    /* 8-bit Cell Parameters ID described in TS 25.331, 0..127, INT_MAX if unknown */
   RIL_OperName operName;
} RIL_CellIdentityTdscdma_v12;

typedef struct {
       /**
           * UTRA carrier RSSI as defined in TS 25.225 5.1.4
           * Valid values are (0-31, 99) as defined in TS 27.007 8.5
           */
       int signalStrength;
       /**
           * Transport Channel BER as defined in TS 25.225 5.2.5
           * Valid values are (0-7, 99) as defined in TS 27.007 8.5
           */
       int bitErrorRate;
       /**
           * P-CCPCH RSCP as defined in TS 25.225 5.1.1
           * Valid values are (0-96, 255) as defined in TS 27.007 8.69
           */
       int rscp;
} RIL_TD_SCDMA_SignalStrength_v12;

typedef struct {
    RIL_CellIdentityTdscdma_v12 cellIdentityTdscdma;
    RIL_TD_SCDMA_SignalStrength_v12 signalStrengthTdscdma;
} RIL_CellInfoTdscdma_v12;

typedef struct {
  RIL_CellInfoType  cellInfoType;   /* cell type for selecting from union CellInfo */
  union {
    RIL_CellIdentityGsm_v12 cellIdentityGsm;
    RIL_CellIdentityWcdma_v12 cellIdentityWcdma;
    RIL_CellIdentityLte_v12 cellIdentityLte;
    RIL_CellIdentityTdscdma_v12 cellIdentityTdscdma;
    RIL_CellIdentityCdma_v12 cellIdentityCdma;
  };
}RIL_CellIdentity_v16;


typedef enum {
    /**
        * Cell is not a serving cell.
        */
    NONE_SERVING = 0,
    /**
        * UE has connection to cell for signalling and possibly data (3GPP 36.331, 25.331).
        */
    PRIMARY_SERVING,
    /**
        * UE has connection to cell for data (3GPP 36.331, 25.331).
        */
    SECONDARY_SERVING
} RIL_CellConnectionStatus;


typedef struct {
    RIL_CellInfoType  cellInfoType;   /* cell type for selecting from union CellInfo */
    int               registered;     /* !0 if this cell is registered 0 if not registered */
    RIL_TimeStampType timeStampType;  /* type of time stamp represented by timeStamp */
    uint64_t          timeStamp;      /* Time in nanos as returned by ril_nano_time */
        union {
        RIL_CellInfoGsm_v12     gsm;
        RIL_CellInfoCdma_v12        cdma;
        RIL_CellInfoLte_v12     lte;
        RIL_CellInfoWcdma_v12   wcdma;
        RIL_CellInfoTdscdma_v12     tdscdma;
        } CellInfo;
    RIL_CellConnectionStatus connectionStatus;
} RIL_CellInfo_v12;

typedef enum {
    RIL_NOT_REG_AND_NOT_SEARCHING = 0,           // Not registered, MT is not currently searching
                                                 // a new operator to register
    RIL_REG_HOME = 1,                            // Registered, home network
    RIL_NOT_REG_AND_SEARCHING = 2,               // Not registered, but MT is currently searching
                                                 // a new operator to register
    RIL_REG_DENIED = 3,                          // Registration denied
    RIL_UNKNOWN = 4,                             // Unknown
    RIL_REG_ROAMING = 5,                         // Registered, roaming
    RIL_NOT_REG_AND_EMERGENCY_AVAILABLE_AND_NOT_SEARCHING = 10,   // Same as
                                                 // RIL_NOT_REG_AND_NOT_SEARCHING but indicates that
                                                 // emergency calls are enabled.
    RIL_NOT_REG_AND_EMERGENCY_AVAILABLE_AND_SEARCHING = 12,  // Same as RIL_NOT_REG_AND_SEARCHING
                                                 // but indicates that
                                                 // emergency calls are enabled.
    RIL_REG_DENIED_AND_EMERGENCY_AVAILABLE = 13, // Same as REG_DENIED but indicates that
                                                 // emergency calls are enabled.
    RIL_UNKNOWN_AND_EMERGENCY_AVAILABLE = 14,    // Same as UNKNOWN but indicates that
                                                 // emergency calls are enabled.
} RIL_RegState;


typedef struct {
    RIL_RegState regState;                // Valid reg states are RIL_NOT_REG_AND_NOT_SEARCHING,
                                          // REG_HOME, RIL_NOT_REG_AND_SEARCHING, REG_DENIED,
                                          // UNKNOWN, REG_ROAMING defined in RegState
    RIL_RadioTechnology rat;              // indicates the available voice radio technology,
                                          // valid values as defined by RadioTechnology.
    int32_t cssSupported;                 // concurrent services support indicator. if
                                          // registered on a CDMA system.
                                          // 0 - Concurrent services not supported,
                                          // 1 - Concurrent services supported
    int32_t roamingIndicator;             // TSB-58 Roaming Indicator if registered
                                          // on a CDMA or EVDO system or -1 if not.
                                          // Valid values are 0-255.
    int32_t systemIsInPrl;                // indicates whether the current system is in the
                                          // PRL if registered on a CDMA or EVDO system or -1 if
                                          // not. 0=not in the PRL, 1=in the PRL
    int32_t defaultRoamingIndicator;      // default Roaming Indicator from the PRL,
                                          // if registered on a CDMA or EVDO system or -1 if not.
                                          // Valid values are 0-255.
    int32_t reasonForDenial;              // reasonForDenial if registration state is 3
                                          // (Registration denied) this is an enumerated reason why
                                          // registration was denied. See 3GPP TS 24.008,
                                          // 10.5.3.6 and Annex G.
                                          // 0 - General
                                          // 1 - Authentication Failure
                                          // 2 - IMSI unknown in HLR
                                          // 3 - Illegal MS
                                          // 4 - Illegal ME
                                          // 5 - PLMN not allowed
                                          // 6 - Location area not allowed
                                          // 7 - Roaming not allowed
                                          // 8 - No Suitable Cells in this Location Area
                                          // 9 - Network failure
                                          // 10 - Persistent location update reject
                                          // 11 - PLMN not allowed
                                          // 12 - Location area not allowed
                                          // 13 - Roaming not allowed in this Location Area
                                          // 15 - No Suitable Cells in this Location Area
                                          // 17 - Network Failure
                                          // 20 - MAC Failure
                                          // 21 - Sync Failure
                                          // 22 - Congestion
                                          // 23 - GSM Authentication unacceptable
                                          // 25 - Not Authorized for this CSG
                                          // 32 - Service option not supported
                                          // 33 - Requested service option not subscribed
                                          // 34 - Service option temporarily out of order
                                          // 38 - Call cannot be identified
                                          // 48-63 - Retry upon entry into a new cell
                                          // 95 - Semantically incorrect message
                                          // 96 - Invalid mandatory information
                                          // 97 - Message type non-existent or not implemented
                                          // 98 - Message type not compatible with protocol state
                                          // 99 - Information element non-existent or
                                          //      not implemented
                                          // 100 - Conditional IE error
                                          // 101 - Message not compatible with protocol state;
    RIL_CellIdentity_v16 cellIdentity;    // current cell information
}RIL_VoiceRegistrationStateResponse;


typedef struct {
    RIL_RegState regState;                // Valid reg states are RIL_NOT_REG_AND_NOT_SEARCHING,
                                          // REG_HOME, RIL_NOT_REG_AND_SEARCHING, REG_DENIED,
                                          // UNKNOWN, REG_ROAMING defined in RegState
    RIL_RadioTechnology rat;              // indicates the available data radio technology,
                                          // valid values as defined by RadioTechnology.
    int32_t reasonDataDenied;             // if registration state is 3 (Registration
                                          // denied) this is an enumerated reason why
                                          // registration was denied. See 3GPP TS 24.008,
                                          // Annex G.6 "Additional cause codes for GMM".
                                          // 7 == GPRS services not allowed
                                          // 8 == GPRS services and non-GPRS services not allowed
                                          // 9 == MS identity cannot be derived by the network
                                          // 10 == Implicitly detached
                                          // 14 == GPRS services not allowed in this PLMN
                                          // 16 == MSC temporarily not reachable
                                          // 40 == No PDP context activated
    int32_t maxDataCalls;                 // The maximum number of simultaneous Data Calls that
                                          // must be established using setupDataCall().
    RIL_CellIdentity_v16 cellIdentity;    // Current cell information
}RIL_DataRegistrationStateResponse;
#endif
static int getCellInfoTypeRadioTechnology(int rat) {
    switch(rat) {
        case 1://RADIO_TECH_GPRS
        case 2://RADIO_TECH_UMTS
        case 16://RADIO_TECH_GSM
        {
            return 1;
        }
        case 3://RADIO_TECH_UMTS
        case 9://RADIO_TECH_HSDPA
        case 10://RADIO_TECH_HSUPA
        case 11://RADIO_TECH_HSPA
        case 15://RADIO_TECH_HSPAP:
        {
            return 4; //RIL_CELL_INFO_TYPE_WCDMA;
        }
        case 4://RADIO_TECH_IS95A:
        case 5://RADIO_TECH_IS95B:
        case 6://RADIO_TECH_1xRTT:
        case 7://RADIO_TECH_EVDO_0:
        case 8://RADIO_TECH_EVDO_A:
        case 12://RADIO_TECH_EVDO_B:
        case 13://RADIO_TECH_EHRPD:
        {
            return 2; //RIL_CELL_INFO_TYPE_CDMA;
        }
        case 14://RADIO_TECH_LTE:
        case 19: //RADIO_TECH_LTE_CA
        {
            return 3; //RIL_CELL_INFO_TYPE_LTE;
        }
        case 17://RADIO_TECH_TD_SCDMA:
        {
            return 5; //RIL_CELL_INFO_TYPE_TD_SCDMA;
        }
        default: {
            break;
        }
    }
    return 0;
}
void TransferUtilsDataCallList( Parcel *oldp,  Parcel *newp)
{
    Parcel *new_parcel = newp;
    Parcel *p = oldp;
    int ver = 0, tmp = 0, num = 0;
    size_t         stringlen = 0;
    const char16_t    *tmp_s16=NULL;

    //-->todo, tranfer parcel
    RFX_LOG_D(LOG_TAG, "TransferUtilsDataCallList, ");
    if (p->dataAvail() > 0) {
        p->readInt32(&ver);
        new_parcel->writeInt32(ver);

        p->readInt32(&num);
        new_parcel->writeInt32(num);
        RFX_LOG_D(LOG_TAG, "TransferUtilsDataCallList, num=%d",num);
        //appendPrintBuf("%d, ", (int)num);
        //list = (RIL_Data_Call_Response_v11 *) calloc(1, sizeof(RIL_Data_Call_Response_v11) * num);
        for (int i = 0; i < num; i++) {
            p->readInt32(&tmp); //status
            new_parcel->writeInt32(tmp);
            p->readInt32(&tmp); //suggestedRetryTime
            new_parcel->writeInt32(tmp);
            p->readInt32(&tmp); //cid
            new_parcel->writeInt32(tmp);
            p->readInt32(&tmp);//active
            new_parcel->writeInt32(tmp);
            tmp_s16 = p->readString16Inplace(&stringlen); //type
            newp->writeString16(tmp_s16, stringlen);
            tmp_s16 = p->readString16Inplace(&stringlen); //ifname
            newp->writeString16(tmp_s16, stringlen);
            tmp_s16 = p->readString16Inplace(&stringlen); //addresses
            newp->writeString16(tmp_s16, stringlen);
            tmp_s16 = p->readString16Inplace(&stringlen); //dnses
            newp->writeString16(tmp_s16, stringlen);
            tmp_s16 = p->readString16Inplace(&stringlen); //gateways
            newp->writeString16(tmp_s16, stringlen);
            tmp_s16 = p->readString16Inplace(&stringlen); //pcscf
            newp->writeString16(tmp_s16, stringlen);

            p->readInt32(&tmp);//mtu
            new_parcel->writeInt32(tmp);
            p->readInt32(&tmp);//rat -v11 not support this
        }
    }

}

void TransferUtilsCellInfo( Parcel *old_parcel,  Parcel *new_parcel)
{

    int  cellInfoType = 0, tmp_value = 0;
    int64_t timeStamp = 0;
    int num;
    uint64_t tmp_value_64 = 0;

    int  responselen = old_parcel->dataSize();

    old_parcel->readInt32(&num);
    new_parcel->writeInt32(num);
    RLOGD("responseCellInfoList: old_parcel->dataAvail()=%d, datasize()=%d, sizeof=%d, num=%d",old_parcel->dataAvail(), old_parcel->dataSize(), sizeof(RIL_CellInfo_v12), num);

    for(int i=0; i<num; i++)
    {
        /*CellInfo.cellInfoType*/
        old_parcel->readInt32(&cellInfoType);
        new_parcel->writeInt32(cellInfoType);
        /*CellInfo.registered*/
        old_parcel->readInt32(&tmp_value);
        new_parcel->writeInt32(tmp_value);
        /*CellInfo.timeStampType*/
        old_parcel->readInt32(&tmp_value);
        new_parcel->writeInt32(tmp_value);
        /*CellInfo.timeStamp*/
        old_parcel->readInt64(&timeStamp);
        new_parcel->writeInt64(timeStamp);
        switch(cellInfoType) {
            case RIL_CELL_INFO_TYPE_GSM: {
                /*CellInfo..gsm.cellIdentityGsm.mcc*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo..gsm.cellIdentityGsm.mnc*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo..gsm.cellIdentityGsm.mnc_len  -diff*/

                /*CellInfo..gsm.cellIdentityGsm.lac*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);

                /*CellInfo.gsm.cellIdentityGsm.cid*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);

                /*CellInfo.gsm.cellIdentityGsm.arfcn   -diff*/
                old_parcel->readInt32(&tmp_value);
                /*CellInfo.gsm.cellIdentityGsm.bsic  -diff*/
                old_parcel->readInt32(&tmp_value);


                /*CellInfo.gsm.signalStrengthGsm.operName.long_name    -diff*/
                /*CellInfo.gsm.signalStrengthGsm.operName.short_name   -diff*/

                /*CellInfo.gsm.signalStrengthGsm.signalStrength*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.gsm.signalStrengthGsm.bitErrorRate*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.gsm.signalStrengthGsm.timingAdvance*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                break;
            }
            case RIL_CELL_INFO_TYPE_WCDMA: {
                /*CellInfo.wcdma.cellIdentityWcdma.mcc*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.wcdma.cellIdentityWcdma.mnc*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);

                /*CellInfo.cdma.cellIdentityCdma.mnc_len  -diff*/

                /*CellInfo.wcdma.cellIdentityWcdma.lac*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);

                /*CellInfo.wcdma.cellIdentityWcdma.cid*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.wcdma.cellIdentityWcdma.psc*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.wcdma.cellIdentityWcdma.uarfcn   -diff*/
                old_parcel->readInt32(&tmp_value);
                /*CellInfo.wcdma.cellIdentityWcdma.operName.long_name   -diff*/
                /*CellInfo.wcdma.cellIdentityWcdma.operName.short_name  -diff*/

                /*CellInfo.wcdma.signalStrengthWcdma.signalStrength*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.wcdma.signalStrengthWcdma.bitErrorRate*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);

                break;
            }
            case RIL_CELL_INFO_TYPE_CDMA: {
                /*CellInfo.cdma.cellIdentityCdma.networkId*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.cdma.cellIdentityCdma.systemId*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.cdma.cellIdentityCdma.basestationId*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.cdma.cellIdentityCdma.longitude*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.cdma.cellIdentityCdma.latitude*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);

                /*CellInfo.wcdma.cellIdentityWcdma.operName.long_name   -diff*/
                /*CellInfo.wcdma.cellIdentityWcdma.operName.short_name  -diff*/

                /*CellInfo.cdma.signalStrengthCdma.dbm*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.cdma.signalStrengthCdma.ecio*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);

                /*CellInfo.cdma.signalStrengthEvdo.dbm*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.cdma.signalStrengthEvdo.ecio*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.cdma.signalStrengthEvdo.signalNoiseRatio*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                break;
            }
            case RIL_CELL_INFO_TYPE_LTE: {

                /*CellInfo.lte.cellIdentityLte.mcc*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.lte.cellIdentityLte.mnc*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.lte.cellIdentityLte.mnc_len  -diff*/
                /*CellInfo.lte.cellIdentityLte.ci*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.lte.cellIdentityLte.pci*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.lte.cellIdentityLte.tac*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.lte.cellIdentityLte.earfcn  -diff*/
                old_parcel->readInt32(&tmp_value);
                /*Typethree add for T800 earfcn 2022/05/30 start*/
                new_parcel->writeInt32(tmp_value);
                /*Typethree add for T800 earfcn 2022/05/30 end*/

                /*CellInfo.lte.cellIdentityLte.operName.longname  -diff*/
                /*CellInfo.lte.cellIdentityLte.operName.shortname  -diff*/
                /*CellInfo.lte.cellIdentityLte.bandwidth  -diff*/

                /*CellInfo.lte.signalStrengthLte.signalStrength*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.lte.signalStrengthLte.rsrp*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.lte.signalStrengthLte.rsrq*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.lte.signalStrengthLte.rssnr*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.lte.signalStrengthLte.cqi*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.lte.signalStrengthLte.timingAdvance*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                break;
            }
            case RIL_CELL_INFO_TYPE_TD_SCDMA: {
                /*CellInfo.lte.signalStrengthLte.timingAdvance*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.lte.signalStrengthLte.timingAdvance*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.lte.signalStrengthLte.timingAdvance   -diff */
                /*CellInfo.tdscdma.cellIdentityTdscdma.lac*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.tdscdma.cellIdentityTdscdma.cid*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.tdscdma.cellIdentityTdscdma.cpid*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.tdscdma.cellIdentityTdscdma.operName.longname    -diff */
                /*CellInfo.tdscdma.cellIdentityTdscdma.operName.shortname   -diff */

                /*CellInfo.tdscdma.signalStrengthTdscdma.signalStrength   -diff */
                /*CellInfo.tdscdma.signalStrengthTdscdma.bitErrorRate   -diff */

                /*CellInfo.tdscdma.signalStrengthTdscdma.rscp*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                break;
            }
            case RIL_CELL_INFO_TYPE_NR: {

                /*CellInfo.nr.cellIdentityNr.mcc*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.nr.cellIdentityNr.mnc*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.nr.cellIdentityNr.nci*/
                old_parcel->readUint64(&tmp_value_64);
                new_parcel->writeUint64(tmp_value_64);
                /*CellInfo.nr.cellIdentityNr.pci*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.nr.cellIdentityNr.tac*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.nr.cellIdentityNr.nr_arfcn  */
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);

                /*CellInfo.nr.SignalStrengthNr.rsrp*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.nr.SignalStrengthNr.rsrq*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.nr.SignalStrengthNr.sinr*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.nr.SignalStrengthNr.csirsrp*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.nr.SignalStrengthNr.csirsrq*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                /*CellInfo.nr.SignalStrengthNr.csisinr*/
                old_parcel->readInt32(&tmp_value);
                new_parcel->writeInt32(tmp_value);
                break;
            }
            default :
                break;
        }

    }

}

void writeStringToParcel(Parcel &p, const char *s) {
    char16_t *s16;
    size_t s16_len = 0;
    s16 = strdup8to16(s, &s16_len);
    p.writeString16(s16, s16_len);
    free(s16);
}

static int transferErrNum(int request, int err)
{
    int new_err = RIL_E_GENERIC_FAILURE;
    switch(err){
        case RIL_E_SUCCESS:
        case RIL_E_RADIO_NOT_AVAILABLE:
        case RIL_E_GENERIC_FAILURE:
        case RIL_E_PASSWORD_INCORRECT:
        case RIL_E_SIM_PIN2:
        case RIL_E_SIM_PUK2:
        case RIL_E_REQUEST_NOT_SUPPORTED:
        case RIL_E_CANCELLED:
        case RIL_E_OP_NOT_ALLOWED_DURING_VOICE_CALL:
        case RIL_E_OP_NOT_ALLOWED_BEFORE_REG_TO_NW:
        case RIL_E_SMS_SEND_FAIL_RETRY:
        case RIL_E_SIM_ABSENT:
        case RIL_E_SUBSCRIPTION_NOT_AVAILABLE:
        case RIL_E_MODE_NOT_SUPPORTED:
        case RIL_E_FDN_CHECK_FAILURE:
        case RIL_E_ILLEGAL_SIM_OR_ME:
        case RIL_E_MISSING_RESOURCE:
        case RIL_E_NO_SUCH_ELEMENT:
        case RIL_E_DIAL_MODIFIED_TO_USSD:
        case RIL_E_DIAL_MODIFIED_TO_SS:
        case RIL_E_DIAL_MODIFIED_TO_DIAL:
        case RIL_E_USSD_MODIFIED_TO_DIAL:
        case RIL_E_USSD_MODIFIED_TO_SS:
        case RIL_E_USSD_MODIFIED_TO_USSD:
        case RIL_E_SS_MODIFIED_TO_DIAL:
        case RIL_E_SS_MODIFIED_TO_USSD:
        case RIL_E_SUBSCRIPTION_NOT_SUPPORTED:
        case RIL_E_SS_MODIFIED_TO_SS:
        case RIL_E_LCE_NOT_SUPPORTED:
        case RIL_E_DIAL_STRING_TOO_LONG:
        case RIL_E_TEXT_STRING_TOO_LONG:
        case RIL_E_SIM_MEM_FULL:
        case RIL_E_CALL_BARRED:
        case RIL_E_EXTERNAL_APP_CAUSE_BEGIN:
        case RIL_E_BT_SAP_UNDEFINED:
        case RIL_E_BT_SAP_NOT_ACCESSIBLE:
        case RIL_E_BT_SAP_CARD_REMOVED:
        case RIL_E_BT_SAP_UIM_NOT_INSERTED:
        case RIL_E_BT_SAP_ERROR_NO_REASON_DEFINED:
        case RIL_E_BT_SAP_ALREADY_POWERED_OFF:
        case RIL_E_BT_SAP_ALREADY_POWERED_ON:
        case RIL_E_VERIFICATION_FAILED:
        case RIL_E_REBOOT_REQUEST:
        case RIL_E_HOLD_FAILED_CAUSED_BY_TERMINATED:
        case RIL_E_POWER_ON_UIM_NOT_READY:
            new_err = err;
            break;
        default:
            new_err = RIL_E_GENERIC_FAILURE;
            break;
    }
    return new_err;
}

// request example

//case 1: parcel don't need to be modified, default
Parcel* tranferRequestRaw(int version, int requset, Parcel *p){
    Parcel *newp = new Parcel();

    RFX_LOG_D(LOG_TAG, "tranferRequestRaw, request =%d", requset);
    newp->appendFrom(p, 0, p->dataSize());
    fillReqID(newp, requset);
    return newp;
}
//case 2: parcel need tarfer, by request id:
Parcel* tranferRequestExample(int version, int requset, Parcel *p){
    Parcel *newp = new Parcel();
    copyReqHeader(newp, p);
    //-->todo, tranfer parcel
    fillReqID(newp, requset);
    return newp;
}

Parcel* tranferRequestOpenChannel(int version, int requset, Parcel *p){
    char *aid = NULL;
    Parcel *newp = new Parcel();
    
    copyReqHeader(newp, p);
    aid = strdupReadString(p);
    writeStringToParcel(newp, aid);
    newp->writeInt32(0);
    fillReqID(newp, requset);
    return newp;
}
Parcel* tranferRequestSetDataProfile(int version, int requset, Parcel *p){
    Parcel *newp = new Parcel();
    int profile_num = 0;
    const char16_t    *tmp_s16 = NULL, *protocol=NULL;
    size_t         stringlen = 0, protocol_len= 0;
    int         authype = 0, tmp_value = 0, profile_id= 0, supportedTypesBitmask=0;
#define DATAASST_PDN_APN_TYPE_DEFAULT      0x1
//for IOT
#define IOT_DATAASST_PDN_APN_TYPE_DEFAULT   (0x00100000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_0     (0x00200000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_1     (0x00400000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_2     (0x00800000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_3     (0x01000000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_4     (0x02000000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_5     (0x04000000)
#define IOT_DATAASST_PDN_APN_TYPE_NET_6     (0x08000000)
    RFX_LOG_D(LOG_TAG, "tranferRequestSetDataProfile, request =%d", requset);
    /*profile num*/
    copyReqHeader(newp, p);
    p->readInt32(&profile_num);
    newp->writeInt32(profile_num);

    /**/
    for (int i = 0 ; i < profile_num ; i++ )
    {
        /*profileId*/
        p->readInt32(&profile_id);
        newp->writeInt32(profile_id);
        RFX_LOG_D(LOG_TAG, "tranferRequestSetDataProfile, profile_id =%d", profile_id);
        /*apn*/
        stringlen = 0;
        tmp_s16 = p->readString16Inplace(&stringlen);
        newp->writeString16(tmp_s16, stringlen);
        /*protocol*/
        protocol_len = 0;
        protocol = p->readString16Inplace(&protocol_len);
        newp->writeString16(protocol, protocol_len);

        /*auth_type*/
        p->readInt32(&authype);
        newp->writeInt32(authype);
            /*user name*/
        tmp_s16 = p->readString16Inplace(&stringlen);
        newp->writeString16(tmp_s16, stringlen);
        /*password*/
        tmp_s16 = p->readString16Inplace(&stringlen);
        newp->writeString16(tmp_s16, stringlen);
        /*type*/
        p->readInt32(&tmp_value);
        newp->writeInt32(tmp_value);
          /*maxConnsTime*/
        p->readInt32(&tmp_value);
        newp->writeInt32(tmp_value);
        /*maxConns*/
        p->readInt32(&tmp_value);
        newp->writeInt32(tmp_value);
        /*waitTime*/
        p->readInt32(&tmp_value);
        newp->writeInt32(tmp_value);
        /*enabled*/
        p->readInt32(&tmp_value);
        newp->writeInt32(tmp_value);

        /*can handle type bitmask*/
        supportedTypesBitmask = profile_id;
        if(profile_id&(IOT_DATAASST_PDN_APN_TYPE_DEFAULT
            |IOT_DATAASST_PDN_APN_TYPE_NET_0
            |IOT_DATAASST_PDN_APN_TYPE_NET_1
            |IOT_DATAASST_PDN_APN_TYPE_NET_2
            |IOT_DATAASST_PDN_APN_TYPE_NET_3
            |IOT_DATAASST_PDN_APN_TYPE_NET_4
            |IOT_DATAASST_PDN_APN_TYPE_NET_5
            |IOT_DATAASST_PDN_APN_TYPE_NET_6
                )
            )
        {
            supportedTypesBitmask = (profile_id & (!(IOT_DATAASST_PDN_APN_TYPE_DEFAULT
                |IOT_DATAASST_PDN_APN_TYPE_NET_0
                |IOT_DATAASST_PDN_APN_TYPE_NET_1
                |IOT_DATAASST_PDN_APN_TYPE_NET_2
                |IOT_DATAASST_PDN_APN_TYPE_NET_3
                |IOT_DATAASST_PDN_APN_TYPE_NET_4
                |IOT_DATAASST_PDN_APN_TYPE_NET_5
                |IOT_DATAASST_PDN_APN_TYPE_NET_6
                ) ) | DATAASST_PDN_APN_TYPE_DEFAULT);
        }

        newp->writeInt32(supportedTypesBitmask);
         /*roamingProtocol*/
        newp->writeString16(protocol, protocol_len);

        /*bearerBitmask*/
        newp->writeInt32(0);

        /*mtu, not used in syc APN table*/
        newp->writeInt32(1500);

        /*mvnoType*/
        newp->writeString16(NULL, 0);

        /*mvnoMatchData*/
        newp->writeString16(NULL, 0);

        // read modemCognitive
        newp->writeInt32(0);
    }
    fillReqID(newp, requset);
    return newp;
}

Parcel* tranferRequestSetPreferredNetworkType(int version, int requset, Parcel *p){
    Parcel *newp = new Parcel();

    copyReqHeader(newp, p);
    //-->todo, tranfer parcel
    RFX_LOG_D(LOG_TAG, "tranferRequestSetPreferredNetworkType, request =%d", requset);
    TransferUtilsPreferredNetworkType(p, newp);
    fillReqID(newp, requset);
    return newp;
}
Parcel* tranferRequestRadioTech(int version, int requset, Parcel *p){
    Parcel *newp = new Parcel();
    RFX_LOG_D(LOG_TAG, "tranferRequestRadioTech, request =%d", requset);
    copyReqHeader(newp, p);
    //-->todo, tranfer parcel
    TransferUtilsRadioTechnology(p,newp);
    fillReqID(newp, requset);
    return newp;
}

//response
Parcel* tranferResponseRaw(int version, int response, Parcel *p, int* error){
    int new_err;
    Parcel *newp = new Parcel();
    RFX_LOG_D(LOG_TAG, "tranferResponseRaw, response =%d", response);
    newp->appendFrom(p, 0, p->dataSize());
    new_err = transferErrNum(response, *error);
    *error = new_err;
    return newp;
}
Parcel* tranferResponseExample(int version, int response, Parcel *p, int* error){
    Parcel *newp = new Parcel();
    int new_err;
    copyRespHeader(newp, p);

    //-->todo, tranfer parcel


    //please remember to transfer error to correct value
    new_err = transferErrNum(response, *error);
    *error = new_err;
    return newp;
}

Parcel* tranferSignalStrength(int version, int response, Parcel *p, int* error){
    Parcel *newp = new Parcel();
    int new_err;
    RIL_SignalStrength_v14 sig_strength;
    int count = 0;
    int tmp;

    copyRespHeader(newp, p);
    if (p->dataAvail() > 0) {
        p->readInt32(&count);
        if(count>=17){
            //gsm_signal_strength
            p->readInt32(&sig_strength.GW_SignalStrength.signalStrength);
            //gsm_bit_error_rate
            p->readInt32(&sig_strength.GW_SignalStrength.bitErrorRate);
            //gsm_timing_advance
            p->readInt32(&sig_strength.GW_SignalStrength.timingAdvance);
            //cdma_dbm
            p->readInt32(&sig_strength.CDMA_SignalStrength.dbm);
            //cdma_ecio
            p->readInt32(&sig_strength.CDMA_SignalStrength.ecio);
            //evdo_dbm
            p->readInt32(&sig_strength.EVDO_SignalStrength.dbm);
            //evdo_ecio
            p->readInt32(&sig_strength.EVDO_SignalStrength.ecio);
            //evdo_snr
            p->readInt32(&sig_strength.EVDO_SignalStrength.signalNoiseRatio);
            //lte_signal_strength
            p->readInt32(&sig_strength.LTE_SignalStrength.signalStrength);
            //lte_rsrp
            p->readInt32(&sig_strength.LTE_SignalStrength.rsrp);
            //lte_rsrq
            p->readInt32(&sig_strength.LTE_SignalStrength.rsrq);
            //lte_rssnr
            p->readInt32(&sig_strength.LTE_SignalStrength.rssnr);
            //lte_cqi
            p->readInt32(&sig_strength.LTE_SignalStrength.cqi);
            //lte_timing_advance
            p->readInt32(&sig_strength.LTE_SignalStrength.timingAdvance);
            //tdscdma_signal_strength
            p->readInt32(&sig_strength.TD_SCDMA_SignalStrength.signalStrength);
            //tdscdma_bit_error_rate
            p->readInt32(&sig_strength.TD_SCDMA_SignalStrength.bitErrorRate);
            //tdscdma_rscp
            p->readInt32(&sig_strength.TD_SCDMA_SignalStrength.rscp);
            //wcdma.signalStrength
            p->readInt32(&sig_strength.WCDMA_SignalStrength.signalStrength);
            //wcdma.bitErrorRate
            p->readInt32(&sig_strength.WCDMA_SignalStrength.bitErrorRate);
            //wcdma.rscp
            p->readInt32(&sig_strength.WCDMA_SignalStrength.rscp);
            //wcdma.ecno
            p->readInt32(&sig_strength.WCDMA_SignalStrength.ecno);
            //nr.ss_rsrp
            p->readInt32(&sig_strength.NR_SignalStrength.ssRsrp);
            //nr.ss_rsrq
            p->readInt32(&sig_strength.NR_SignalStrength.ssRsrq);
            //nr.ss_sinr
            p->readInt32(&sig_strength.NR_SignalStrength.ssSinr);
            //nr.csi_rsrp
            p->readInt32(&sig_strength.NR_SignalStrength.csiRsrp);
            //nr.csi_rsrq
            p->readInt32(&sig_strength.NR_SignalStrength.csiRsrq);
            //nr.csi_sinr
            p->readInt32(&sig_strength.NR_SignalStrength.csiSinr);
            RFX_LOG_D(LOG_TAG, "tranferSignalStrength: gsm_signalStrength=%d, gsm_bitErrorRate=%d, gsm_timingAdvance=%d, \
                CDMA_dbm=%d, CDMA_ecio=%d, \
                EVDO_dbm=%d, EVDO_ecio=%d, EVDO_snr=%d, \
                LTE_signalStrength=%d, LTE_rsrp=%d, LTE_rsrq=%d, LTE_rssnr=%d, LTE_cqi=%d, LTE_timingAdvance=%d, \
                TD_SCDMA_signalStrength=%d, TD_SCDMA_bitErrorRate=%d, TD_SCDMA_rscp=%d \
                WCDMA_signalStrength=%d, WCDMA_bitErrorRate=%d, WCDMA_rscp=%d, WCDMA_ecno=%d\
                NR_SignalStrength.ssRsrp=%d, NR_SignalStrength.ssRsrq=%d, NR_SignalStrength.ssSinr=%d\
                NR_SignalStrength.csiRsrp=%d, NR_SignalStrength.csiRsrq=%d, NR_SignalStrength.csiSinr=%d",
                sig_strength.GW_SignalStrength.signalStrength,sig_strength.GW_SignalStrength.bitErrorRate,sig_strength.GW_SignalStrength.timingAdvance,
                sig_strength.CDMA_SignalStrength.dbm,sig_strength.CDMA_SignalStrength.ecio,sig_strength.EVDO_SignalStrength.dbm,
                sig_strength.EVDO_SignalStrength.ecio,sig_strength.EVDO_SignalStrength.signalNoiseRatio,sig_strength.LTE_SignalStrength.signalStrength,
                sig_strength.LTE_SignalStrength.rsrp, sig_strength.LTE_SignalStrength.rsrq,sig_strength.LTE_SignalStrength.rssnr, 
                sig_strength.LTE_SignalStrength.cqi,sig_strength.LTE_SignalStrength.timingAdvance,
                sig_strength.TD_SCDMA_SignalStrength.signalStrength, sig_strength.TD_SCDMA_SignalStrength.bitErrorRate, sig_strength.TD_SCDMA_SignalStrength.rscp,
                sig_strength.WCDMA_SignalStrength.signalStrength, sig_strength.WCDMA_SignalStrength.bitErrorRate, sig_strength.WCDMA_SignalStrength.rscp, sig_strength.WCDMA_SignalStrength.ecno,
                sig_strength.NR_SignalStrength.ssRsrp, sig_strength.NR_SignalStrength.ssRsrq, sig_strength.NR_SignalStrength.ssSinr,
                sig_strength.NR_SignalStrength.csiRsrp, sig_strength.NR_SignalStrength.csiRsrq, sig_strength.NR_SignalStrength.csiSinr);
            newp->writeInt32(sig_strength.GW_SignalStrength.signalStrength);
            newp->writeInt32(sig_strength.GW_SignalStrength.bitErrorRate);
            newp->writeInt32(sig_strength.GW_SignalStrength.timingAdvance);
            newp->writeInt32(sig_strength.CDMA_SignalStrength.dbm);
            newp->writeInt32(sig_strength.CDMA_SignalStrength.ecio);
            newp->writeInt32(sig_strength.EVDO_SignalStrength.dbm);
            newp->writeInt32(sig_strength.EVDO_SignalStrength.ecio);
            newp->writeInt32(sig_strength.EVDO_SignalStrength.signalNoiseRatio);
            newp->writeInt32(sig_strength.LTE_SignalStrength.signalStrength);
            newp->writeInt32(sig_strength.LTE_SignalStrength.rsrp);
            newp->writeInt32(sig_strength.LTE_SignalStrength.rsrq);
            newp->writeInt32(sig_strength.LTE_SignalStrength.rssnr);
            newp->writeInt32(sig_strength.LTE_SignalStrength.cqi);
            newp->writeInt32(sig_strength.LTE_SignalStrength.timingAdvance);
            newp->writeInt32(sig_strength.TD_SCDMA_SignalStrength.signalStrength);
            newp->writeInt32(sig_strength.TD_SCDMA_SignalStrength.bitErrorRate);
            newp->writeInt32(sig_strength.TD_SCDMA_SignalStrength.rscp);
            newp->writeInt32(sig_strength.WCDMA_SignalStrength.signalStrength);
            newp->writeInt32(sig_strength.WCDMA_SignalStrength.bitErrorRate);
            newp->writeInt32(sig_strength.WCDMA_SignalStrength.rscp);
            newp->writeInt32(sig_strength.WCDMA_SignalStrength.ecno);
            newp->writeInt32(sig_strength.NR_SignalStrength.ssRsrp);
            newp->writeInt32(sig_strength.NR_SignalStrength.ssRsrq);
            newp->writeInt32(sig_strength.NR_SignalStrength.ssSinr);
            newp->writeInt32(sig_strength.NR_SignalStrength.csiRsrp);
            newp->writeInt32(sig_strength.NR_SignalStrength.csiRsrq);
            newp->writeInt32(sig_strength.NR_SignalStrength.csiSinr);
        }else {
            RFX_LOG_E(LOG_TAG, "tranferSignalStrength: count=%d", count);
        }
    }  
    new_err = transferErrNum(response, *error);
    *error = new_err;
    return newp;
}

Parcel* tranferResponseLastDataCallFailCause(int version, int response, Parcel *p, int* error){
    Parcel *newp = new Parcel();
    int  new_err;
    int old_failcause = 0, new_fail_cause, count = 0;
    RFX_LOG_D(LOG_TAG, "tranferResponseLastDataCallFailCause, response =%d", response);
    copyRespHeader(newp,p);
    /*Read old parcel value, set the unknow value to PDP_FAIL_ERROR_UNSPECIFIED*/
    if (p->dataAvail() > 0) {
    p->readInt32(&count);
    newp->writeInt32(count);
    p->readInt32(&old_failcause);
    switch(old_failcause){
        case PDP_FAIL_NONE:
        case PDP_FAIL_OPERATOR_BARRED:
        case PDP_FAIL_INSUFFICIENT_RESOURCES:
        case PDP_FAIL_MISSING_UKNOWN_APN:
        case PDP_FAIL_UNKNOWN_PDP_ADDRESS_TYPE:
        case PDP_FAIL_USER_AUTHENTICATION:
        case PDP_FAIL_ACTIVATION_REJECT_GGSN:
        case PDP_FAIL_ACTIVATION_REJECT_UNSPECIFIED:
        case PDP_FAIL_SERVICE_OPTION_NOT_SUPPORTED:
        case PDP_FAIL_SERVICE_OPTION_NOT_SUBSCRIBED:
        case PDP_FAIL_SERVICE_OPTION_OUT_OF_ORDER:
        case PDP_FAIL_NSAPI_IN_USE:
        case PDP_FAIL_REGULAR_DEACTIVATION:
        case PDP_FAIL_ONLY_IPV4_ALLOWED:
        case PDP_FAIL_ONLY_IPV6_ALLOWED:
        case PDP_FAIL_ONLY_SINGLE_BEARER_ALLOWED:
        case PDP_FAIL_PROTOCOL_ERRORS:
        case PDP_FAIL_VOICE_REGISTRATION_FAIL:
        case PDP_FAIL_DATA_REGISTRATION_FAIL:
        case PDP_FAIL_SIGNAL_LOST:
        case PDP_FAIL_PREF_RADIO_TECH_CHANGED:
        case PDP_FAIL_RADIO_POWER_OFF:
        case PDP_FAIL_TETHERED_CALL_ACTIVE:
        case PDP_FAIL_ROUTER_ADVERTISEMENT_FAIL:
        case PDP_FAIL_VSNCP_TERMINATED:
        case PDP_FAIL_FALLBACK_RETRY:
        case RADIO_NOT_AVAILABLE:
        case UNACCEPTABLE_NETWORK_PARAMETER:
            new_fail_cause = old_failcause;
            break;
       default:
            new_fail_cause = PDP_FAIL_ERROR_UNSPECIFIED;
            break;
    }

    newp->writeInt32(new_fail_cause);
    }
    //please remember to transfer error to correct value
    new_err = transferErrNum(response, *error);
    *error = new_err;
    return newp;
}

Parcel* tranferResponseDataCallList(int version, int response, Parcel *p, int* error){
    Parcel *newp = new Parcel();
    int new_err;
    copyRespHeader(newp, p);
    RFX_LOG_D(LOG_TAG, "tranferResponseDataCallList, response =%d", response);
    TransferUtilsDataCallList(p, newp);

    //please remember to transfer error to correct value
    new_err = transferErrNum(response, *error);
    *error = new_err;
    return newp;
}
Parcel* tranferResponseGetPreferredNetworkType(int version, int response, Parcel *p, int* error){
    Parcel *newp = new Parcel();
    int  new_err;

    RFX_LOG_D(LOG_TAG, "tranferResponseGetPreferredNetworkType, response =%d", response);
    copyRespHeader(newp,p);
    /*Read old parcel value, set the unknow value to PDP_FAIL_ERROR_UNSPECIFIED*/
    TransferUtilsPreferredNetworkType(p,newp);
    //please remember to transfer error to correct value
    new_err = transferErrNum(response, *error);
    *error = new_err;
    return newp;
}

Parcel* tranferResponseRadioTech(int version, int response, Parcel *p, int* error){
    Parcel *newp = new Parcel();
    int new_err;
    copyRespHeader(newp, p);

    //-->todo, tranfer parcel
    RFX_LOG_D(LOG_TAG, "tranferResponseRadioTech, response =%d", response);
    TransferUtilsRadioTechnology(p,newp);

    //please remember to transfer error to correct value
    new_err = transferErrNum(response, *error);
    *error = new_err;
    return newp;
}
Parcel* tranferResponseCellInfoList(int version, int response, Parcel *p, int* error){
    Parcel *newp = new Parcel();
    int new_err;
    copyRespHeader(newp, p);
    //-->todo, tranfer parcel
    RFX_LOG_D(LOG_TAG, "tranferResponseCellInfoList, response =%d", response);
    TransferUtilsCellInfo(p,newp);

    //please remember to transfer error to correct value
    new_err = transferErrNum(response, *error);
    *error = new_err;
    return newp;
}


Parcel* tranferResponseGetCurrentCalls(int version, int response, Parcel *p, int* error){
    Parcel *newp = new Parcel();
    int new_err;
    copyRespHeader(newp, p);
    //-->todo, tranfer parcel

    typedef struct _uus_info{
        int    uusType;
        int    uusDcs;
        int    uusLength;
        const char16_t *uusData;
    } uus_Info_t;

    typedef struct _cc_call_list{
        int state;
        int index;
        int toa;
        int isMpty;
        int isMT;
        int als;
        int isVoice;
        int isVoicePrivacy;
        const char16_t *number;
        int numberPresentation;
        const char16_t *name;
        int namePresentation;
        int isUUSpresent;
        uus_Info_t *uusInfo;
    } cc_call_list_t;

    int num = 0;
    int speechCodec;
    cc_call_list_t callinfo;
    uus_Info_t uusinfo;
    size_t stringlen;

    p->readInt32(&num);
    newp->writeInt32(num);

    RFX_LOG_D(LOG_TAG, "[tranferGetCurrentCallsResponse] number is %d",num);

    for(int i=0;i<num;i++){

    p->readInt32(&callinfo.state);
    newp->writeInt32(callinfo.state);

    p->readInt32(&callinfo.index);
    newp->writeInt32(callinfo.index);

    p->readInt32(&callinfo.toa);
    newp->writeInt32(callinfo.toa);

    p->readInt32(&callinfo.isMpty);
    newp->writeInt32(callinfo.isMpty);

    p->readInt32(&callinfo.isMT);
    newp->writeInt32(callinfo.isMT);

    p->readInt32(&callinfo.als);
    newp->writeInt32(callinfo.als);

    p->readInt32(&callinfo.isVoice);
    newp->writeInt32(callinfo.isVoice);

    p->readInt32(&callinfo.isVoicePrivacy);
    newp->writeInt32(callinfo.isVoicePrivacy);

    stringlen = 0;
    callinfo.number = p->readString16Inplace(&stringlen);
    newp->writeString16(callinfo.number, stringlen);

    p->readInt32(&callinfo.numberPresentation);
    newp->writeInt32(callinfo.numberPresentation);

    stringlen = 0;
    callinfo.name = p->readString16Inplace(&stringlen);
    newp->writeString16(callinfo.name, stringlen);

    p->readInt32(&callinfo.numberPresentation);
    newp->writeInt32(callinfo.numberPresentation);

    p->readInt32(&callinfo.isUUSpresent);
    newp->writeInt32(callinfo.isUUSpresent);

    if(callinfo.isUUSpresent == 1)
    {
        p->readInt32(&uusinfo.uusType);
        newp->writeInt32(uusinfo.uusType);

        p->readInt32(&uusinfo.uusDcs);
        newp->writeInt32(uusinfo.uusDcs);

        p->readInt32(&uusinfo.uusLength);
        newp->writeInt32(uusinfo.uusLength);

        stringlen = 0;
        uusinfo.uusData = p->readString16Inplace(&stringlen);
        newp->writeString16(uusinfo.uusData, stringlen);
    }

    p->readInt32(&speechCodec);

    }
    //please remember to transfer error to correct value
    new_err = transferErrNum(response, *error);
    *error = new_err;
    return newp;
}

Parcel* tranferResponseLastFailCause(int version, int response, Parcel *p, int* error){
    Parcel *newp = new Parcel();
    int new_err;
    copyRespHeader(newp, p);
    //-->todo, tranfer parcel
    int failcause = 0;
    size_t stringlen = 0;

    const char16_t *vendor_cause=NULL;


    RFX_LOG_D(LOG_TAG, "tranferResponseLastFailCause, response =%d", response);
    p->readInt32(&failcause);

    switch(failcause){
        case CALL_FAIL_UNOBTAINABLE_NUMBER:
        case CALL_FAIL_NORMAL:
        case CALL_FAIL_BUSY:
        case CALL_FAIL_CONGESTION:
        case CALL_FAIL_ACM_LIMIT_EXCEEDED:
        case CALL_FAIL_CALL_BARRED:
        case CALL_FAIL_FDN_BLOCKED:
        case CALL_FAIL_IMSI_UNKNOWN_IN_VLR:
        case CALL_FAIL_IMEI_NOT_ACCEPTED:
        case CALL_FAIL_DIAL_MODIFIED_TO_USSD:
        case CALL_FAIL_DIAL_MODIFIED_TO_SS:
        case CALL_FAIL_DIAL_MODIFIED_TO_DIAL:
        case CALL_FAIL_CDMA_LOCKED_UNTIL_POWER_CYCLE:
        case CALL_FAIL_CDMA_DROP:
        case CALL_FAIL_CDMA_INTERCEPT:
        case CALL_FAIL_CDMA_REORDER:
        case CALL_FAIL_CDMA_SO_REJECT:
        case CALL_FAIL_CDMA_RETRY_ORDER:
        case CALL_FAIL_CDMA_ACCESS_FAILURE:
        case CALL_FAIL_CDMA_PREEMPTED:
        case CALL_FAIL_CDMA_NOT_EMERGENCY:
        case CALL_FAIL_CDMA_ACCESS_BLOCKED:
            newp->writeInt32(failcause);
            break;
        default:
            newp->writeInt32(CALL_FAIL_ERROR_UNSPECIFIED);
            break;
        }

    vendor_cause = p->readString16Inplace(&stringlen);
    newp->writeString16(vendor_cause, stringlen);

/*
    CALL_FAIL_UNOBTAINABLE_NUMBER = 1,
    CALL_FAIL_NORMAL = 16,
    CALL_FAIL_BUSY = 17,
    CALL_FAIL_CONGESTION = 34,
    CALL_FAIL_ACM_LIMIT_EXCEEDED = 68,
    CALL_FAIL_CALL_BARRED = 240,
    CALL_FAIL_FDN_BLOCKED = 241,
    CALL_FAIL_IMSI_UNKNOWN_IN_VLR = 242,
    CALL_FAIL_IMEI_NOT_ACCEPTED = 243,
    CALL_FAIL_DIAL_MODIFIED_TO_USSD = 244, /* STK Call Control
    CALL_FAIL_DIAL_MODIFIED_TO_SS = 245,
    CALL_FAIL_DIAL_MODIFIED_TO_DIAL = 246,
    CALL_FAIL_CDMA_LOCKED_UNTIL_POWER_CYCLE = 1000,
    CALL_FAIL_CDMA_DROP = 1001,
    CALL_FAIL_CDMA_INTERCEPT = 1002,
    CALL_FAIL_CDMA_REORDER = 1003,
    CALL_FAIL_CDMA_SO_REJECT = 1004,
    CALL_FAIL_CDMA_RETRY_ORDER = 1005,
    CALL_FAIL_CDMA_ACCESS_FAILURE = 1006,
    CALL_FAIL_CDMA_PREEMPTED = 1007,
    CALL_FAIL_CDMA_NOT_EMERGENCY = 1008, // For non-emergency number dialed
                                            during emergency callback mode
    CALL_FAIL_CDMA_ACCESS_BLOCKED = 1009, // CDMA network access probes blocked
    CALL_FAIL_ERROR_UNSPECIFIED = 0xffff
} RIL_LastCallFailCause;
*/
    //please remember to transfer error to correct value
    new_err = transferErrNum(response, *error);
    *error = new_err;
    return newp;
}


Parcel* transferResponseSimStatus(int version, int response, Parcel *p, int* error){
    RIL_CardStatus_v6* card_status;
    Parcel *newp = new Parcel();
    int32_t v = 0;
    int new_err;
    RFX_LOG_D(LOG_TAG, "transferResponseSimStatus, response =%d", response);
    copyRespHeader(newp, p);
    new_err = transferErrNum(response, *error);
    *error = new_err;
    if (p->dataAvail() > 0) {
        card_status = (RIL_CardStatus_v6 *)calloc(1, sizeof(RIL_CardStatus_v6));
        p->readInt32(&v);
        if(v > RIL_CARDSTATE_ERROR) {
            v = RIL_CARDSTATE_ERROR;
        }
        card_status->card_state = RIL_CardState(v);
        p->readInt32(&v);
        card_status->universal_pin_state = RIL_PinState(v);
        p->readInt32(&card_status->gsm_umts_subscription_app_index);
        p->readInt32(&card_status->cdma_subscription_app_index);
        p->readInt32(&card_status->ims_subscription_app_index);
        p->readInt32(&card_status->num_applications);
        for(int i = 0; i < card_status->num_applications; i++) {
            p->readInt32(&v);
            card_status->applications[i].app_type = RIL_AppType(v);
            p->readInt32(&v);
            card_status->applications[i].app_state = RIL_AppState(v);
            p->readInt32(&v);
            card_status->applications[i].perso_substate = RIL_PersoSubstate(v);
            card_status->applications[i].aid_ptr = strdupReadString(p);
            card_status->applications[i].app_label_ptr = strdupReadString(p);
            p->readInt32(&card_status->applications[i].pin1_replaced);
            p->readInt32(&v);
            card_status->applications[i].pin1 = RIL_PinState(v);
            p->readInt32(&v);
            card_status->applications[i].pin2 = RIL_PinState(v);
        }
    }else {
        return newp;
    }

    newp->writeInt32(card_status->card_state);
    newp->writeInt32(card_status->universal_pin_state);
    newp->writeInt32(card_status->gsm_umts_subscription_app_index);
    newp->writeInt32(card_status->cdma_subscription_app_index);
    newp->writeInt32(card_status->ims_subscription_app_index);
    newp->writeInt32(card_status->num_applications);
    for (int i = 0; i < card_status->num_applications; i++) {
        newp->writeInt32(card_status->applications[i].app_type);
        newp->writeInt32(card_status->applications[i].app_state);
        newp->writeInt32(card_status->applications[i].perso_substate);
        writeStringToParcel(newp, (const char*)(card_status->applications[i].aid_ptr));
        writeStringToParcel(newp, (const char*)(card_status->applications[i].app_label_ptr));
        newp->writeInt32(card_status->applications[i].pin1_replaced);
        newp->writeInt32(card_status->applications[i].pin1);
        newp->writeInt32(card_status->applications[i].pin2);
        RFX_LOG_D(LOG_TAG, "app_type=%d,app_state=%d,perso_substate=%d,\
                    aid_ptr=%s,app_label_ptr=%s,pin1_replaced=%d,pin1=%d,pin2=%d",
                    card_status->applications[i].app_type,
                    card_status->applications[i].app_state,
                    card_status->applications[i].perso_substate,
                    card_status->applications[i].aid_ptr,
                    card_status->applications[i].app_label_ptr,
                    card_status->applications[i].pin1_replaced,
                    card_status->applications[i].pin1,
                    card_status->applications[i].pin2);
    }

    if (card_status != NULL) {
        for (int i = 0; i < card_status->num_applications; i++) {
            free(card_status->applications[i].aid_ptr);
            free(card_status->applications[i].app_label_ptr);
        }
        free(card_status);
    }
    return newp;
}


Parcel* tranferResponseVoiceRegisterState(int version, int response, Parcel *p, int* error){
    Parcel *newp = new Parcel();
    Parcel *old_parcel = p;
    Parcel *new_parcel = newp;
    int     rat = 0, tmp_value = 0, valid_count =0;
    char            *responseStr[15]={NULL};
    int     regState = 0;
    RIL_CellInfoType type;
    int new_err;
    copyRespHeader(newp, p);

    memset(responseStr, 0, sizeof(char *) * 15);
    //-->todo, tranfer parcel

    /*regState*/
    old_parcel->readInt32(&regState);
    asprintf(&responseStr[0], "%d", regState);

    /*rat*/
    old_parcel->readInt32(&rat);
    if(19 == rat)
    {
        rat=14;
    }
    //type = (RIL_CellInfoType)getCellInfoTypeRadioTechnology(rat);
    asprintf(&responseStr[3], "%d", rat);
    /*cssSupported -diff*/
    old_parcel->readInt32(&tmp_value);
    asprintf(&responseStr[7], "%d", tmp_value);
    /*roamingIndicator -diff*/
    old_parcel->readInt32(&tmp_value);
    asprintf(&responseStr[10], "%d", tmp_value);

    /*systemIsInPrl -diff*/
    old_parcel->readInt32(&tmp_value);
    asprintf(&responseStr[11], "%d", tmp_value);
    /*defaultRoamingIndicator -diff*/
    old_parcel->readInt32(&tmp_value);
    asprintf(&responseStr[12], "%d", tmp_value);
    /*reasonForDenial -diff*/
    old_parcel->readInt32(&tmp_value);
    asprintf(&responseStr[13], "%d", tmp_value);
    // TODO: cellIdentity
    /*cellInfoType*/
    old_parcel->readInt32(&tmp_value);
    type = RIL_CellInfoType(tmp_value);
    switch(type)
    {
        case RIL_CELL_INFO_TYPE_GSM: {
            /*cellIdentity.mcc*/
            old_parcel->readInt32(&tmp_value);
            /*cellIdentity.mnc*/
            old_parcel->readInt32(&tmp_value);
            /*cellIdentitymnc_len  -diff*/
            old_parcel->readInt32(&tmp_value);
            /*cellIdentity.lac*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[1], "%d", tmp_value);
            /*cellIdentity.cid*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[2], "%d", tmp_value);
            /*cellIdentity.arfcn   -diff*/
            old_parcel->readInt32(&tmp_value);
            /*cellIdentity.bsic  -diff*/
            old_parcel->readInt32(&tmp_value);

            /*cellIdentity.operName.long_name    -diff*/
            /*cellIdentity.operName.short_name   -diff*/

            break;
        }
        case RIL_CELL_INFO_TYPE_WCDMA: {
            /*CellInfo.wcdma.cellIdentityWcdma.mcc*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.mnc*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.cdma.cellIdentityCdma.mnc_len  -diff*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.lac*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[1], "%d", tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.cid*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[2], "%d", tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.psc*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[14], "%d", tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.uarfcn   -diff*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.operName.long_name   -diff*/
            /*CellInfo.wcdma.cellIdentityWcdma.operName.short_name  -diff*/

            break;
        }
        case RIL_CELL_INFO_TYPE_CDMA: {
            /*networkId*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[9], "%d", tmp_value);
            /*CellInfo.cdma.cellIdentityCdma.systemId*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[8], "%d", tmp_value);
            /*CellInfo.cdma.cellIdentityCdma.basestationId*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[4], "%d", tmp_value);
            /*CellInfo.cdma.cellIdentityCdma.longitude*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[6], "%d", tmp_value);
            /*CellInfo.cdma.cellIdentityCdma.latitude*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[5], "%d", tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.operName.long_name   -diff*/
            /*CellInfo.wcdma.cellIdentityWcdma.operName.short_name  -diff*/

            break;
        }
        case RIL_CELL_INFO_TYPE_LTE: {

            /*CellInfo.lte.cellIdentityLte.mcc*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.lte.cellIdentityLte.mnc*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.lte.cellIdentityLte.mnc_len  -diff*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.lte.cellIdentityLte.ci*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[2], "%d", tmp_value);
            /*CellInfo.lte.cellIdentityLte.pci*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.lte.cellIdentityLte.tac*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.lte.cellIdentityLte.earfcn  -diff*/
            old_parcel->readInt32(&tmp_value);

            /*CellInfo.lte.cellIdentityLte.operName.longname  -diff*/
            /*CellInfo.lte.cellIdentityLte.operName.shortname  -diff*/
            /*CellInfo.lte.cellIdentityLte.bandwidth  -diff*/

            break;
        }
        case RIL_CELL_INFO_TYPE_TD_SCDMA: {
            /*mcc*/
            old_parcel->readInt32(&tmp_value);
            /*mnc*/
            old_parcel->readInt32(&tmp_value);
            /*mnc_len  -diff */
            old_parcel->readInt32(&tmp_value);
            /*lac*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[1], "%d", tmp_value);
            /*cid*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[2], "%d", tmp_value);
            /*cpid*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.tdscdma.cellIdentityTdscdma.operName.longname    -diff */
            /*CellInfo.tdscdma.cellIdentityTdscdma.operName.shortname   -diff */

            break;
        }
        case RIL_CELL_INFO_TYPE_NR: {
            /*nr_cell.mcc*/
            old_parcel->readInt32(&tmp_value);
            /*nr_cell.mnc*/
            old_parcel->readInt32(&tmp_value);
            /*nr_cell.mnc_len  -diff*/
            old_parcel->readInt32(&tmp_value);
            /*nr_cell.cid*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[2], "%d", tmp_value);
            /*nr_cell.pci*/
            old_parcel->readInt32(&tmp_value);
            /*nr_cell.tac*/
            old_parcel->readInt32(&tmp_value);
            /*nr_cell.nr_arfcn  -diff*/
            old_parcel->readInt32(&tmp_value);
            break;
        }
        default :
            tmp_value=-1;
            asprintf(&responseStr[1], "%d", tmp_value);
            asprintf(&responseStr[2], "%d", tmp_value);
            break;
    }

    if(regState != 1 && regState != 5)
    {
        tmp_value=-1;
        asprintf(&responseStr[1], "%d", tmp_value);
        asprintf(&responseStr[2], "%d", tmp_value);
        rat = 0;
        asprintf(&responseStr[3], "%d", rat);
    }

    new_parcel->writeInt32 (15);
    for(int i = 0; i < 15; i ++)
    {
        if(NULL != responseStr[i])
        {

            writeStringToParcel(newp,responseStr[i]);
            valid_count++;
            free(responseStr[i]);
        }
        else
        {
            writeStringToParcel(newp,"");
        }

    }
    RFX_LOG_D(LOG_TAG, "tranferResponseVoiceRegisterState, response =%d,rat = %d,type=%d,valid_count=%d", response, rat, type, valid_count);

    //please remember to transfer error to correct value
    new_err = transferErrNum(response, *error);
    *error = new_err;
    return newp;
}
Parcel* tranferResponseDataRegisterState(int version, int response, Parcel *p, int* error){
    Parcel *newp = new Parcel();
    Parcel *old_parcel = p;
    Parcel *new_parcel = newp;
    int rat = 0, tmp_value = 0, valid_count=0;
    uint64_t tmp_value_64 = 0;   // jw.ren [Feature]API-190 MTK patch CR-ID AUTO00173061 -- on Jun 2 2022
    char *responseStr[11]={NULL};
    int regState = 0;
    RIL_CellInfoType type;
    int new_err;
    
    copyRespHeader(newp, p);

    memset(responseStr, 0, sizeof(char *) * 11);
    //-->todo, tranfer parcel

    /*regState*/
    old_parcel->readInt32(&regState);
    asprintf(&responseStr[0], "%d", regState);

    /*rat*/
    old_parcel->readInt32(&rat);
    if(19 == rat)
    {
        RFX_LOG_D(LOG_TAG, "The_Data_register_status is:4G+");
        rat=14;
    }
    else if(14 == rat)
    {
        RFX_LOG_D(LOG_TAG, "The_Data_register_status is:4G");
    }
    else
    {
        RFX_LOG_D(LOG_TAG, "The_Data_register_status is:%d", rat);
    }
    //type = (RIL_CellInfoType)getCellInfoTypeRadioTechnology(rat);
    asprintf(&responseStr[3], "%d", rat);

    /*reasonDataDenied*/
    old_parcel->readInt32(&tmp_value);
    asprintf(&responseStr[4], "%d", tmp_value);
    /*maxDataCalls*/
    old_parcel->readInt32(&tmp_value);
    asprintf(&responseStr[5], "%d", tmp_value);

    old_parcel->readInt32(&tmp_value);
    type = RIL_CellInfoType(tmp_value);
    RFX_LOG_D(LOG_TAG,"type is:%d",type);   // jw.ren [Feature]API-190 MTK patch CR-ID AUTO00173061 -- on Jun 2 2022
    // TODO: cellIdentity
    switch(type)
    {
        case RIL_CELL_INFO_TYPE_GSM: {
            /*cellIdentity.mcc*/
            old_parcel->readInt32(&tmp_value);
            /*cellIdentity.mnc*/
            old_parcel->readInt32(&tmp_value);
            /*cellIdentitymnc_len  -diff*/
            old_parcel->readInt32(&tmp_value);
            /*cellIdentity.lac*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[1], "%d", tmp_value);
            /*cellIdentity.cid*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[2], "%d", tmp_value);
            /*cellIdentity.arfcn   -diff*/
            old_parcel->readInt32(&tmp_value);
            /*cellIdentity.bsic  -diff*/
            old_parcel->readInt32(&tmp_value);

            /*cellIdentity.operName.long_name    -diff*/
            /*cellIdentity.operName.short_name   -diff*/

            break;
        }
        case RIL_CELL_INFO_TYPE_WCDMA: {
            /*CellInfo.wcdma.cellIdentityWcdma.mcc*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.mnc*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.cdma.cellIdentityCdma.mnc_len  -diff*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.lac*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[1], "%d", tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.cid*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[2], "%d", tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.psc*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.uarfcn   -diff*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.operName.long_name   -diff*/
            /*CellInfo.wcdma.cellIdentityWcdma.operName.short_name  -diff*/

            break;
        }
        case RIL_CELL_INFO_TYPE_CDMA: {
            /*CellInfo.cdma.cellIdentityCdma.networkId*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.cdma.cellIdentityCdma.systemId*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.cdma.cellIdentityCdma.basestationId*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.cdma.cellIdentityCdma.longitude*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.cdma.cellIdentityCdma.latitude*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.wcdma.cellIdentityWcdma.operName.long_name   -diff*/
            /*CellInfo.wcdma.cellIdentityWcdma.operName.short_name  -diff*/

            break;
        }
        case RIL_CELL_INFO_TYPE_LTE: {

            /*CellInfo.lte.cellIdentityLte.mcc*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.lte.cellIdentityLte.mnc*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.lte.cellIdentityLte.mnc_len  -diff*/
            old_parcel->readInt32(&tmp_value);
            /*CellInfo.lte.cellIdentityLte.ci*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[2], "%d", tmp_value);                    
            /*CellInfo.lte.cellIdentityLte.pci*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[7], "%d", tmp_value);
            /*CellInfo.lte.cellIdentityLte.tac*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[6], "%d", tmp_value);
            /*CellInfo.lte.cellIdentityLte.earfcn  -diff*/
            old_parcel->readInt32(&tmp_value);

            /*CellInfo.lte.cellIdentityLte.operName.longname  -diff*/
            /*CellInfo.lte.cellIdentityLte.operName.shortname  -diff*/
            /*CellInfo.lte.cellIdentityLte.bandwidth  -diff*/

            break;
        }
        case RIL_CELL_INFO_TYPE_TD_SCDMA: {
            /*RIL_CellIdentity_v16.RIL_CellIdentityTdscdma.mcc*/
            old_parcel->readInt32(&tmp_value);
            /*RIL_CellIdentity_v16.RIL_CellIdentityTdscdma..mnc*/
            old_parcel->readInt32(&tmp_value);
            /*RIL_CellIdentity_v16.RIL_CellIdentityTdscdma.mnc_len   -diff */
            old_parcel->readInt32(&tmp_value);
            /*RIL_CellIdentity_v16.RIL_CellIdentityTdscdma.lac*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[1], "%d", tmp_value);
            /*RIL_CellIdentity_v16.RIL_CellIdentityTdscdma.cid*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[2], "%d", tmp_value);
            /*RIL_CellIdentity_v16.RIL_CellIdentityTdscdma.cpid*/
            old_parcel->readInt32(&tmp_value);
            /*RIL_CellIdentity_v16.RIL_CellIdentityTdscdma.longname    -diff */
            /*RIL_CellIdentity_v16.RIL_CellIdentityTdscdma.shortname   -diff */

            break;
        }
        case RIL_CELL_INFO_TYPE_NR: {
            /*nr_cell.mcc*/
            old_parcel->readInt32(&tmp_value);
            /*nr_cell.mnc*/
            old_parcel->readInt32(&tmp_value);
            /*nr_cell.mnc_len  -diff*/
            old_parcel->readInt32(&tmp_value);
            /*nr_cell.cid*/
            old_parcel->readUint64(&tmp_value_64);   // jw.ren [Feature]API-190 MTK patch CR-ID AUTO00173061 -- on Jun 2 2022
            asprintf(&responseStr[2], "%llu", tmp_value_64);   // jw.ren [Feature]API-190 MTK patch CR-ID AUTO00173061 -- on Jun 2 2022
            /*nr_cell.pci*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[7], "%d", tmp_value);
            /*nr_cell.tac*/
            old_parcel->readInt32(&tmp_value);
            asprintf(&responseStr[1], "%d", tmp_value);  // jw.ren [Feature]API-190 MTK patch CR-ID AUTO00173061 -- on Jun 2 2022
            asprintf(&responseStr[6], "%d", tmp_value);
            /*nr_cell.nr_arfcn  -diff*/
            old_parcel->readInt32(&tmp_value);

            break;
        }
        default :
            asprintf(&responseStr[1], "%d", tmp_value);
            asprintf(&responseStr[2], "%d", tmp_value);
            break;
    }
    if(regState != 1 && regState != 5)
    {
        tmp_value=-1;
        asprintf(&responseStr[1], "%d", tmp_value);
        asprintf(&responseStr[2], "%d", tmp_value);
        rat = 0;
        asprintf(&responseStr[3], "%d", rat);

    }

    new_parcel->writeInt32 (11);
    for(int i = 0; i < 11; i ++)
    {

        if(NULL != responseStr[i])
        {
            RFX_LOG_D(LOG_TAG, "tranferResponseDataRegisterState, response =%d, id=%d, %s", response, i,responseStr[i]);
            writeStringToParcel(newp,responseStr[i]);
            valid_count++;
            free(responseStr[i]);
        }
        else
        {
            writeStringToParcel(newp,"");
        }
    }
    RFX_LOG_D(LOG_TAG, "tranferResponseDataRegisterState, response =%d, rat = %d, type=%d, valid_count= %d", response, rat, type, valid_count);

    //please remember to transfer error to correct value
    new_err = transferErrNum(response, *error);
    *error = new_err;
    return newp;
}

//unsol
Parcel* tranferUnsolRaw(int version, int unsol, Parcel *p){
    Parcel *newp = new Parcel();
    RFX_LOG_D(LOG_TAG, "tranferUnsolRaw, unsol =%d", unsol);
    newp->appendFrom(p, 0, p->dataSize());
    return newp;
}


Parcel* tranferUnsolExample(int version, int unsol, Parcel *p){

    Parcel *newp = new Parcel();
    RFX_LOG_D(LOG_TAG, "tranferUnsolExample, unsol =%d", unsol);
    copyUrcHeader(newp, p);
    //-->todo, tranfer parcel

    return newp;
}

Parcel* transferUnsolSignalStrength(int version, int unsol, Parcel *p){
    Parcel *newp = new Parcel();    
    int count = 0;
    int tmp;
    RIL_SignalStrength_v14 sig_strength;
    
    copyUrcHeader(newp, p);
    if (p->dataAvail() > 0) {
        p->readInt32(&count);
        if(count>=17){
            //gsm_signal_strength
            p->readInt32(&sig_strength.GW_SignalStrength.signalStrength);
            //gsm_bit_error_rate
            p->readInt32(&sig_strength.GW_SignalStrength.bitErrorRate);
            //gsm_timing_advance
            p->readInt32(&sig_strength.GW_SignalStrength.timingAdvance);
            //cdma_dbm
            p->readInt32(&sig_strength.CDMA_SignalStrength.dbm);
            //cdma_ecio
            p->readInt32(&sig_strength.CDMA_SignalStrength.ecio);
            //evdo_dbm
            p->readInt32(&sig_strength.EVDO_SignalStrength.dbm);
            //evdo_ecio
            p->readInt32(&sig_strength.EVDO_SignalStrength.ecio);
            //evdo_snr
            p->readInt32(&sig_strength.EVDO_SignalStrength.signalNoiseRatio);
            //lte_signal_strength
            p->readInt32(&sig_strength.LTE_SignalStrength.signalStrength);
            //lte_rsrp
            p->readInt32(&sig_strength.LTE_SignalStrength.rsrp);
            //lte_rsrq
            p->readInt32(&sig_strength.LTE_SignalStrength.rsrq);
            //lte_rssnr
            p->readInt32(&sig_strength.LTE_SignalStrength.rssnr);
            //lte_cqi
            p->readInt32(&sig_strength.LTE_SignalStrength.cqi);
            //lte_timing_advance
            p->readInt32(&sig_strength.LTE_SignalStrength.timingAdvance);
            //tdscdma_signal_strength
            p->readInt32(&sig_strength.TD_SCDMA_SignalStrength.signalStrength);
            //tdscdma_bit_error_rate
            p->readInt32(&sig_strength.TD_SCDMA_SignalStrength.bitErrorRate);
            //tdscdma_rscp
            p->readInt32(&sig_strength.TD_SCDMA_SignalStrength.rscp);
            //wcdma.signalStrength
            p->readInt32(&sig_strength.WCDMA_SignalStrength.signalStrength);
            //wcdma.bitErrorRate
            p->readInt32(&sig_strength.WCDMA_SignalStrength.bitErrorRate);
            //wcdma.rscp
            p->readInt32(&sig_strength.WCDMA_SignalStrength.rscp);
            //wcdma.ecno
            p->readInt32(&sig_strength.WCDMA_SignalStrength.ecno);
            //nr.ss_rsrp
            p->readInt32(&sig_strength.NR_SignalStrength.ssRsrp);
            //nr.ss_rsrq
            p->readInt32(&sig_strength.NR_SignalStrength.ssRsrq);
            //nr.ss_sinr
            p->readInt32(&sig_strength.NR_SignalStrength.ssSinr);
            //nr.csi_rsrp
            p->readInt32(&sig_strength.NR_SignalStrength.csiRsrp);
            //nr.csi_rsrq
            p->readInt32(&sig_strength.NR_SignalStrength.csiRsrq);
            //nr.csi_sinr
            p->readInt32(&sig_strength.NR_SignalStrength.csiSinr);
            RFX_LOG_D(LOG_TAG, "transferUnsolSignalStrength: gsm_signalStrength=%d, gsm_bitErrorRate=%d, gsm_timingAdvance=%d, \
                CDMA_dbm=%d, CDMA_ecio=%d, \
                EVDO_dbm=%d, EVDO_ecio=%d, EVDO_snr=%d, \
                LTE_signalStrength=%d, LTE_rsrp=%d, LTE_rsrq=%d, LTE_rssnr=%d, LTE_cqi=%d, LTE_timingAdvance=%d, \
                TD_SCDMA_signalStrength=%d, TD_SCDMA_bitErrorRate=%d, TD_SCDMA_rscp=%d \
                WCDMA_signalStrength=%d, WCDMA_bitErrorRate=%d, WCDMA_rscp=%d, WCDMA_ecno=%d\
                NR_SignalStrength.ssRsrp=%d, NR_SignalStrength.ssRsrq=%d, NR_SignalStrength.ssSinr=%d\
                NR_SignalStrength.csiRsrp=%d, NR_SignalStrength.csiRsrq=%d, NR_SignalStrength.csiSinr=%d",
                sig_strength.GW_SignalStrength.signalStrength,sig_strength.GW_SignalStrength.bitErrorRate,sig_strength.GW_SignalStrength.timingAdvance,
                sig_strength.CDMA_SignalStrength.dbm,sig_strength.CDMA_SignalStrength.ecio,sig_strength.EVDO_SignalStrength.dbm,
                sig_strength.EVDO_SignalStrength.ecio,sig_strength.EVDO_SignalStrength.signalNoiseRatio,sig_strength.LTE_SignalStrength.signalStrength,
                sig_strength.LTE_SignalStrength.rsrp, sig_strength.LTE_SignalStrength.rsrq,sig_strength.LTE_SignalStrength.rssnr, 
                sig_strength.LTE_SignalStrength.cqi,sig_strength.LTE_SignalStrength.timingAdvance,
                sig_strength.TD_SCDMA_SignalStrength.signalStrength, sig_strength.TD_SCDMA_SignalStrength.bitErrorRate, sig_strength.TD_SCDMA_SignalStrength.rscp,
                sig_strength.WCDMA_SignalStrength.signalStrength, sig_strength.WCDMA_SignalStrength.bitErrorRate, sig_strength.WCDMA_SignalStrength.rscp, sig_strength.WCDMA_SignalStrength.ecno,
                sig_strength.NR_SignalStrength.ssRsrp, sig_strength.NR_SignalStrength.ssRsrq, sig_strength.NR_SignalStrength.ssSinr,
                sig_strength.NR_SignalStrength.csiRsrp, sig_strength.NR_SignalStrength.csiRsrq, sig_strength.NR_SignalStrength.csiSinr);
            newp->writeInt32(sig_strength.GW_SignalStrength.signalStrength);
            newp->writeInt32(sig_strength.GW_SignalStrength.bitErrorRate);
            newp->writeInt32(sig_strength.GW_SignalStrength.timingAdvance);
            newp->writeInt32(sig_strength.CDMA_SignalStrength.dbm);
            newp->writeInt32(sig_strength.CDMA_SignalStrength.ecio);
            newp->writeInt32(sig_strength.EVDO_SignalStrength.dbm);
            newp->writeInt32(sig_strength.EVDO_SignalStrength.ecio);
            newp->writeInt32(sig_strength.EVDO_SignalStrength.signalNoiseRatio);
            newp->writeInt32(sig_strength.LTE_SignalStrength.signalStrength);
            newp->writeInt32(sig_strength.LTE_SignalStrength.rsrp);
            newp->writeInt32(sig_strength.LTE_SignalStrength.rsrq);
            newp->writeInt32(sig_strength.LTE_SignalStrength.rssnr);
            newp->writeInt32(sig_strength.LTE_SignalStrength.cqi);
            newp->writeInt32(sig_strength.LTE_SignalStrength.timingAdvance);
            newp->writeInt32(sig_strength.TD_SCDMA_SignalStrength.signalStrength);
            newp->writeInt32(sig_strength.TD_SCDMA_SignalStrength.bitErrorRate);
            newp->writeInt32(sig_strength.TD_SCDMA_SignalStrength.rscp);
            newp->writeInt32(sig_strength.WCDMA_SignalStrength.signalStrength);
            newp->writeInt32(sig_strength.WCDMA_SignalStrength.bitErrorRate);
            newp->writeInt32(sig_strength.WCDMA_SignalStrength.rscp);
            newp->writeInt32(sig_strength.WCDMA_SignalStrength.ecno);
            newp->writeInt32(sig_strength.NR_SignalStrength.ssRsrp);
            newp->writeInt32(sig_strength.NR_SignalStrength.ssRsrq);
            newp->writeInt32(sig_strength.NR_SignalStrength.ssSinr);
            newp->writeInt32(sig_strength.NR_SignalStrength.csiRsrp);
            newp->writeInt32(sig_strength.NR_SignalStrength.csiRsrq);
            newp->writeInt32(sig_strength.NR_SignalStrength.csiSinr);
        }else {
            RFX_LOG_E(LOG_TAG, "transferUnsolSignalStrength: count=%d", count);
        }
    }      
    return newp;
}

Parcel* tranferUnsolRilConnected(int version, int unsol, Parcel *p){
    Parcel *newp = new Parcel();
    RFX_LOG_D(LOG_TAG, "tranferUnsolRilConnected, unsol =%d", unsol);
    copyUrcHeader(newp, p);
    //-->todo, tranfer parcel
    newp->writeInt32(1);
    newp->writeInt32(RIL_VERSION);
    return newp;
}

Parcel* tranferUnsolCellInfoList(int version, int unsol, Parcel *p){
    Parcel *newp = new Parcel();
    RFX_LOG_D(LOG_TAG, "tranferUnsolCellInfoList, unsol =%d", unsol);
    copyUrcHeader(newp, p);

    TransferUtilsCellInfo(p,newp);
    return newp;
}

Parcel* tranferUnsolDataCallList(int version, int unsol, Parcel *p){
    Parcel *newp = new Parcel();
    RFX_LOG_D(LOG_TAG, "tranferUnsolDataCallList, unsol =%d", unsol);
    copyUrcHeader(newp, p);
    TransferUtilsDataCallList(p, newp);
    return newp;
}


