// This source code is generated by UdpGeneratorTool, not recommend to modify it directly
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "Framework2AgpsInterface.h"
#include "mtk_socket_data_coder.h"

// Sender
bool Framework2AgpsInterface_DnsQueryResult(mtk_socket_fd* client_fd, bool isSuccess, bool hasIpv4, int ipv4, bool hasIpv6, char ipv6[], int ipv6_size) {
    pthread_mutex_lock(&client_fd->mutex);
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Framework2AgpsInterface_DnsQueryResult() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    int _ret;
    char _buff[FRAMEWORK2AGPS_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, FRAMEWORK2AGPS_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, FRAMEWORK2AGPS_INTERFACE_DNS_QUERY_RESULT);
    mtk_socket_put_bool(_buff, &_offset, isSuccess);
    mtk_socket_put_bool(_buff, &_offset, hasIpv4);
    mtk_socket_put_int(_buff, &_offset, ipv4);
    mtk_socket_put_bool(_buff, &_offset, hasIpv6);
    ASSERT_LESS_EQUAL_THAN(ipv6_size, 16);
    mtk_socket_put_char_array(_buff, &_offset, ipv6, ipv6_size);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Framework2AgpsInterface_DnsQueryResult() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

bool Framework2AgpsInterface_DnsQueryResult2(mtk_socket_fd* client_fd, bool isSuccess, bool hasIpv4, int ipv4, bool hasIpv6, char ipv6[], int ipv6_size, bool hasNetId, int netId) {
    pthread_mutex_lock(&client_fd->mutex);
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Framework2AgpsInterface_DnsQueryResult2() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    int _ret;
    char _buff[FRAMEWORK2AGPS_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, FRAMEWORK2AGPS_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, FRAMEWORK2AGPS_INTERFACE_DNS_QUERY_RESULT2);
    mtk_socket_put_bool(_buff, &_offset, isSuccess);
    mtk_socket_put_bool(_buff, &_offset, hasIpv4);
    mtk_socket_put_int(_buff, &_offset, ipv4);
    mtk_socket_put_bool(_buff, &_offset, hasIpv6);
    ASSERT_LESS_EQUAL_THAN(ipv6_size, 16);
    mtk_socket_put_char_array(_buff, &_offset, ipv6, ipv6_size);
    mtk_socket_put_bool(_buff, &_offset, hasNetId);
    mtk_socket_put_int(_buff, &_offset, netId);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Framework2AgpsInterface_DnsQueryResult2() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

// Receiver
bool Framework2AgpsInterface_receiver_decode(char* _buff, Framework2AgpsInterface_callbacks* callbacks) {
    int _ret = 0;
    int _offset = 0;
    _ret = mtk_socket_get_int(_buff, &_offset);
    if(_ret != FRAMEWORK2AGPS_INTERFACE_PROTOCOL_TYPE) {
        SOCK_LOGE("Framework2AgpsInterface_receiver_decode() protocol_type=[%d] is not equals to [%d]",
            _ret, FRAMEWORK2AGPS_INTERFACE_PROTOCOL_TYPE);
        return false;
    }
    _ret = mtk_socket_get_int(_buff, &_offset);
    switch(_ret) {
    case FRAMEWORK2AGPS_INTERFACE_DNS_QUERY_RESULT: {
        if(callbacks->Framework2AgpsInterface_DnsQueryResult_handler == NULL) {
            SOCK_LOGE("Framework2AgpsInterface_receiver_decode() Framework2AgpsInterface_DnsQueryResult_handler() is NULL");
            return false;
        }
        bool isSuccess = mtk_socket_get_bool(_buff, &_offset);
        bool hasIpv4 = mtk_socket_get_bool(_buff, &_offset);
        int ipv4 = mtk_socket_get_int(_buff, &_offset);
        bool hasIpv6 = mtk_socket_get_bool(_buff, &_offset);
        char ipv6[16];
        int ipv6_size = mtk_socket_get_char_array(_buff, &_offset, ipv6, 16);
        callbacks->Framework2AgpsInterface_DnsQueryResult_handler(isSuccess, hasIpv4, ipv4, hasIpv6, ipv6, ipv6_size);
        break;
    }
    case FRAMEWORK2AGPS_INTERFACE_DNS_QUERY_RESULT2: {
        if(callbacks->Framework2AgpsInterface_DnsQueryResult2_handler == NULL) {
            SOCK_LOGE("Framework2AgpsInterface_receiver_decode() Framework2AgpsInterface_DnsQueryResult2_handler() is NULL");
            return false;
        }
        bool isSuccess = mtk_socket_get_bool(_buff, &_offset);
        bool hasIpv4 = mtk_socket_get_bool(_buff, &_offset);
        int ipv4 = mtk_socket_get_int(_buff, &_offset);
        bool hasIpv6 = mtk_socket_get_bool(_buff, &_offset);
        char ipv6[16];
        int ipv6_size = mtk_socket_get_char_array(_buff, &_offset, ipv6, 16);
        bool hasNetId = mtk_socket_get_bool(_buff, &_offset);
        int netId = mtk_socket_get_int(_buff, &_offset);
        callbacks->Framework2AgpsInterface_DnsQueryResult2_handler(isSuccess, hasIpv4, ipv4, hasIpv6, ipv6, ipv6_size, hasNetId, netId);
        break;
    }
    default: {
        SOCK_LOGE("Framework2AgpsInterface_receiver_decode() unknown msgId=[%d]", _ret);
        return false;
    }
    }
    return true;
}
bool Framework2AgpsInterface_receiver_read_and_decode(int server_fd, Framework2AgpsInterface_callbacks* callbacks) {
    int _ret;
    char _buff[FRAMEWORK2AGPS_INTERFACE_BUFF_SIZE] = {0};

    _ret = mtk_socket_read(server_fd, _buff, sizeof(_buff));
    if(_ret == -1) {
        SOCK_LOGE("Framework2AgpsInterface_receiver_read_and_decode() mtk_socket_read() failed, fd=%d err=[%s]%d",
            server_fd, strerror(errno), errno);
        return false;
    }
    return Framework2AgpsInterface_receiver_decode(_buff, callbacks);
}

