/*
 * DataCallResponse.cpp
 *
 *  Created on: May 8, 2017
 *      Author: mtk54458
 */
#include "DataCallResponse.h"
#include "RpDataUtils.h"
#include "RfxLog.h"

#include <vector>
using namespace std;

#define RFX_LOG_TAG "RpDfwDataCallResponse"

DataCallResponse::DataCallResponse() {
    DataCallResponse::status = -1;
    DataCallResponse::cid = -1;
    DataCallResponse::active = 0;
    DataCallResponse::type = "";
    DataCallResponse::ifname = "";
    DataCallResponse::addresses = "";
    DataCallResponse::dnses = "";
    DataCallResponse::gateways = "";
    DataCallResponse::suggestedRetryTime = -1;
    DataCallResponse::pcscf = "";
    DataCallResponse::mtu = -1;
    DataCallResponse::eratType = -1;

    DataCallResponse::netId = -1;
    DataCallResponse::ipv4 = "";
    DataCallResponse::ipv6 = "";
}

DataCallResponse::DataCallResponse(int status, int cid, int active, string type, string ifname,
        string addresses, string dnses, string gateways, int suggestedRetryTime, string pcscf, int mtu,
        int eratType, int netId) {
    DataCallResponse::status = status;
    DataCallResponse::cid = cid;
    DataCallResponse::active = active;
    DataCallResponse::type = type;
    DataCallResponse::ifname = ifname;
    DataCallResponse::addresses = addresses;
    DataCallResponse::dnses = dnses;
    DataCallResponse::gateways = gateways;
    DataCallResponse::suggestedRetryTime = suggestedRetryTime;
    DataCallResponse::pcscf = pcscf;
    DataCallResponse::mtu = mtu;
    DataCallResponse::eratType = eratType;

    DataCallResponse::netId = netId;
    initAddress();
}

void DataCallResponse::initAddress() {
    if (!DataCallResponse::addresses.empty()) {
        vector<string> fragments;
        RpDataUtils::split(DataCallResponse::addresses, ' ', fragments);

        vector<string>::iterator itor = fragments.begin();
        while (itor != fragments.end()) {
            //tricky method to parse ipv4 and ipv6
            if (itor->length() < 20) {
                DataCallResponse::ipv4 = *itor;
            } else {
                DataCallResponse::ipv6 = *itor;
            }
            itor++;
        }
    }
}

string DataCallResponse::logInfo() {
    string dataCallResponseLog;
    dataCallResponseLog += ("status: " + RpDataUtils::i2s(status));
    dataCallResponseLog += (", cid: " + RpDataUtils::i2s(cid));
    dataCallResponseLog += (", active: " + std::string(RpDataUtils::pdnState2string(active)));
    dataCallResponseLog += (", type: " + type);
    dataCallResponseLog += (", ifname: " + ifname);
    dataCallResponseLog += (", addresses: " + addresses);
    dataCallResponseLog += (", dnses: " + dnses);
    dataCallResponseLog += (", gateways: " + gateways);
    dataCallResponseLog += (", suggestedRetryTime: " + RpDataUtils::i2s(suggestedRetryTime));
    dataCallResponseLog += (", pcscf: " + pcscf);
    dataCallResponseLog += (", mtu: " + RpDataUtils::i2s(mtu));
    dataCallResponseLog += (", eratType: " + RpDataUtils::i2s(eratType));
    dataCallResponseLog += (", netId: " + RpDataUtils::i2s(netId));

    return dataCallResponseLog;
}
