/*
 * DcController.h
 *
 *  Created on: May 2, 2017
 *      Author: mtk54458
 */

#ifndef DCCONTROLLER_H_
#define DCCONTROLLER_H_

#include "DataCallResponse.h"
#include "DataConnection.h"
#include <map>
#include <vector>
using namespace std;

class DcTracker;
class DcController {
public:
    DcController();
    void onDataStateChanged(const sp<RfxMessage>& message);
    void addActiveDcByCid(DataConnection *dc);
    void removeActiveDcByCid(DataConnection *dc);
    void setDcTracker(DcTracker *dct);
    map<int, DataConnection*> getActiveDataConnections();

    void retryDataConnections();
    void cleanupDataConnections();
    int getSlotId() const {
        return m_slot_id;
    }

private:
    map<int, DataConnection*> mDcListActiveByCid;
    vector<DataConnection*> mDcsToRetry;
    vector<DataConnection*> mDcsToCleanup;
    int m_slot_id;

    DcTracker *mDct;
};



#endif /* DCCONTROLLER_H_ */
