/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2018. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#ifndef __MTK_LOG_H
#define __MTK_LOG_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef LOG_TAG
#define LOG_TAG NULL
#endif

/**
 * Represents the logging level.
 */
enum {
    kLogPriorityUnknown = 0,
    kLogPriorityDefault,
    kLogPriorityVerbose,
    kLogPriorityDebug,
    kLogPriorityInfo,
    kLogPriorityWarn,
    kLogPriorityError,
    kLogPriorityFatal,
    kLogPrioritySilent
};

enum {
    kLogIdMin = 0,

    kLogIdMain = 0,
    kLogIdRadio = 1,
    kLogIdEvents = 2,
    kLogIdSystem = 3,
    kLogIdCrash = 4,

    kLogIdMax
};

#define MAX_LOG_LEN 1024

#define MTK_LOG_ID_MIN    kLogIdMin
#define MTK_LOG_ID_MAIN   kLogIdMain
#define MTK_LOG_ID_RADIO  kLogIdRadio
#define MTK_LOG_ID_SYSTEM kLogIdSystem
#define MTK_LOG_ID_CRASH  kLogIdCrash
#define MTK_LOG_ID_MAX    kLogIdMax

#define MTK_LOG_LEVEL_UNKNOWN    kLogPriorityUnknown
#define MTK_LOG_LEVEL_DEFAULT    kLogPriorityDefault
#define MTK_LOG_LEVEL_VERBOSE    kLogPriorityVerbose
#define MTK_LOG_LEVEL_DEBUG      kLogPriorityDebug
#define MTK_LOG_LEVEL_INFO       kLogPriorityInfo
#define MTK_LOG_LEVEL_WARN       kLogPriorityWarn
#define MTK_LOG_LEVEL_ERROR      kLogPriorityError
#define MTK_LOG_LEVEL_FATAL      kLogPriorityFatal
#define MTK_LOG_LEVEL_SILENT     kLogPrioritySilent

/*
 * Simplified macro to send an error radio log message using the current LOG_TAG.
 */
#ifndef RLOGE
#define RLOGE(fmt, ...) ((void)mtkLogE(LOG_TAG, fmt, ## __VA_ARGS__))
#endif

#ifndef RLOGD
#define RLOGD(fmt, ...) ((void)mtkLogD(LOG_TAG, fmt, ## __VA_ARGS__))
#endif

#ifndef RLOGI
#define RLOGI(fmt, ...) ((void)mtkLogI(LOG_TAG, fmt, ## __VA_ARGS__))
#endif

#ifndef RLOGW
#define RLOGW(fmt, ...) ((void)mtkLogW(LOG_TAG, fmt, ## __VA_ARGS__))
#endif

#ifndef RLOGV
#define RLOGV(fmt, ...) ((void)mtkLogV(LOG_TAG, fmt, ## __VA_ARGS__))
#endif

extern void __android_log_buf_print(int bufID, int prio, const char *tag, const char *fmt, ...);

#ifndef mtkLogD
#define mtkLogD(tag, fmt, ...) ((void)__android_log_buf_print(MTK_LOG_ID_RADIO, MTK_LOG_LEVEL_DEBUG, tag, fmt, ## __VA_ARGS__))
#endif

#ifndef mtkLogI
#define mtkLogI(tag, fmt, ...) ((void)__android_log_buf_print(MTK_LOG_ID_RADIO, MTK_LOG_LEVEL_INFO, tag, fmt, ## __VA_ARGS__))
#endif

#ifndef mtkLogV
#define mtkLogV(tag, fmt, ...) ((void)__android_log_buf_print(MTK_LOG_ID_RADIO, MTK_LOG_LEVEL_VERBOSE, tag, fmt, ## __VA_ARGS__))
#endif

#ifndef mtkLogW
#define mtkLogW(tag, fmt, ...) ((void)__android_log_buf_print(MTK_LOG_ID_RADIO, MTK_LOG_LEVEL_WARN, tag, fmt, ## __VA_ARGS__))
#endif

#ifndef mtkLogE
#define mtkLogE(tag, fmt, ...) ((void)__android_log_buf_print(MTK_LOG_ID_RADIO, MTK_LOG_LEVEL_ERROR, tag, fmt, ## __VA_ARGS__))
#endif

extern void mtkLog(const int level, const char *tag, const char *fmt, ...);
extern void mtkAssert(const char *pErrMsg);

#undef SLOGD
#undef SLOGW
#undef SLOGE
#undef SLOGV
#undef SLOGI

#define SLOGD(...) (mtkLogD(LOG_TAG, __VA_ARGS__))
#define SLOGW(...) (mtkLogW(LOG_TAG, __VA_ARGS__))
#define SLOGE(...) (mtkLogE(LOG_TAG, __VA_ARGS__))
#define SLOGV(...) (mtkLogV(LOG_TAG, __VA_ARGS__))
#define SLOGI(...) (mtkLogI(LOG_TAG, __VA_ARGS__))

#undef ALOGD
#undef ALOGE
#undef ALOGW
#undef ALOGV
#undef ALOGI

#define ALOGD(...) (mtkLogD(LOG_TAG, __VA_ARGS__))
#define ALOGE(...) (mtkLogE(LOG_TAG, __VA_ARGS__))
#define ALOGW(...) (mtkLogW(LOG_TAG, __VA_ARGS__))
#define ALOGV(...) (mtkLogV(LOG_TAG, __VA_ARGS__))
#define ALOGI(...) (mtkLogI(LOG_TAG, __VA_ARGS__))

#undef LOG_ALWAYS_FATAL_IF
#define LOG_ALWAYS_FATAL_IF(cond, ...)          \
    do {                                        \
        if (cond) {                             \
            mtkLogE(LOG_TAG, __VA_ARGS__);      \
            mtkAssert(NULL);                    \
            exit(0);                            \
        }                                       \
    } while(0)

#ifdef __cplusplus
}
#endif

#endif /* __MTK_LOG_H */

