#include "cccilib.h"
#include <pthread.h>

static int init = 0;
static int fd = -1;
static pthread_t tid;
static pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER; 

static CCCILIB_EXCEPTION_CB exception_cb;
static void *exception_cb_priv_ptr;

static int mipc_register_flag = 0;

int cccilib_reset(int ccci_fd)
{
    int reset_parm = -1;

    if (ioctl(ccci_fd, CCCI_IOC_MD_RESET, &reset_parm) == 0) {
        return 0;
    } else {
        return -1;
    }
}

static void *cccilib_monitor_thread(void *priv_ptr)
{
    int count;
    struct md_status_event status_buf;

    do {
        count = read(fd, &status_buf, sizeof(struct md_status_event));
        if (count < 0) {
            if (errno == EINTR) {
                continue;
            } else {
                break;
            }
        }

        if (count > 0) {
            CCCI_LOG_E("check status if MD has been stop(1 is stop): %d, %d", mipc_register_flag, status_buf.event_type);
            if ((0 == mipc_register_flag) && (status_buf.event_type == MD_STA_EV_STOP)) {
                mipc_register_flag = 1;
            }

            if ((1 == mipc_register_flag) && (status_buf.event_type == MD_STA_EV_READY)) {
                mipc_register_flag = 0;
                if (exception_cb) {
                    exception_cb(exception_cb_priv_ptr);
                }
            }
        }
    } while(1);

    pthread_mutex_lock(&mutex);
    if (fd >= 0) {
        close(fd);
        fd = -1;
    }
    init = 0;
    pthread_mutex_unlock(&mutex);

    return NULL;
}

void cccilib_exception_register(CCCILIB_EXCEPTION_CB cb, void *cb_priv_ptr)
{
    exception_cb = cb;
    exception_cb_priv_ptr = cb_priv_ptr;

    pthread_mutex_lock(&mutex);
    if (cb) {
        if (init == 0) {
            fd = open("/dev/ccci_md1_sta", O_RDWR);
            if (fd >= 0) {
                pthread_attr_t attr;
                pthread_attr_init(&attr);
                pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

                if (pthread_create(&tid, &attr, cccilib_monitor_thread, NULL) == 0) {
                    init = 1;
                } else {
                    close(fd);
                    fd = -1;
                }
            }
        }
    } else {
        if (fd >= 0) {
            close(fd);
            fd = -1;
        }
    }
    pthread_mutex_unlock(&mutex);
}
