/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "mipc_msg_tlv_api.h"
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_api.h"

static const char *radio_state_name(int state)
{
#define RADIO_STATE_NAME(state) case state: return #state;
    switch (state)
    {
        RADIO_STATE_NAME(MIPC_NW_RADIO_STATE_OFF);
        RADIO_STATE_NAME(MIPC_NW_RADIO_STATE_ON);
    default:
        return NULL;
    }
#undef RADIO_STATE_NAME
}

static void ia_status_ind_cb(mipc_msg_t *msg_ptr, void *priv_ptr)
{
    mipc_result_enum result = mipc_get_result(msg_ptr);

    printf("IA status result:%d\n", result);
    if (result == MIPC_RESULT_SUCCESS)
    {
        char* apn = mipc_nw_get_ia_status_cnf_get_apn(msg_ptr, NULL);
        uint8_t state = mipc_nw_get_ia_status_cnf_get_rat(msg_ptr, mipc_nw_ia_const_NONE);
        mipc_apn_pdp_type_const_enum pdp_type = mipc_nw_get_ia_status_cnf_get_pdp_type(msg_ptr, mipc_apn_pdp_type_const_NONE);
        mipc_apn_auth_type_const_enum auth_type = mipc_nw_get_ia_status_cnf_get_auth_type(msg_ptr, mipc_apn_auth_type_const_NONE);
        char* userid = mipc_nw_get_ia_status_cnf_get_userid(msg_ptr, NULL);
        char* password = mipc_nw_get_ia_status_cnf_get_password(msg_ptr, NULL);

        printf("[IND IA STATUS] state = %d\n", state);
        printf("[IND IA STATUS] apn = %s\n", apn);
        printf("[IND IA STATUS] pdp_type = %d\n", pdp_type);
        printf("[IND IA STATUS] auth_type = %d\n", auth_type);
        printf("[IND IA STATUS] userid = %s\n", userid);
        printf("[IND IA STATUS] passwd = %s\n", password);
        printf("[FINAL] IA completion, PASS\n");
    }
}

int main(int argc, char *argv[])
{
    char apn[MIPC_MAX_APN_LEN] = "internet";
    uint8_t rat_type = 21;
    // 0: off, 1: on, 2: reset
    uint8_t radio_state = 2;
    uint8_t pdn_type = MIPC_APN_PDP_TYPE_IPV4V6;
    uint8_t roam_pdn_type = MIPC_APN_PDP_TYPE_IPV4V6;

    mipc_init("wwan");

    if (argc >= 2) {
        memset(apn, '\0', MIPC_MAX_APN_LEN-1);
        strncpy(apn, argv[1], MIPC_MAX_APN_LEN-1);
    }
    if (argc >= 3)
        rat_type = atoi(argv[2]);
    if (argc >= 4)
        radio_state = atoi(argv[3]);
    if (argc >= 5)
        pdn_type = atoi(argv[4]);
    if (argc >= 6)
        roam_pdn_type = atoi(argv[5]);
    else
        roam_pdn_type = pdn_type;

    printf("mtk_ia %s with RAT type:%d, radio state:%d pdn type:%d roam_pdn_type:%d\n",
            apn, rat_type, radio_state, pdn_type, roam_pdn_type);

    //register IA status
    mipc_msg_register_ind(MIPC_PS0, MIPC_NW_IA_IND, ia_status_ind_cb, NULL);

    do
    {
        mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_NW_SET_REGISTER_STATE_REQ, MIPC_PS0);
        mipc_msg_t *msg_cnf_ptr;
        mipc_result_enum result = MIPC_RESULT_FAILURE;

        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_NW_SET_REGISTER_STATE_REQ_T_MODE, MIPC_NW_REGISTER_MODE_AUTOMATIC);
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_NW_SET_REGISTER_STATE_REQ_T_RAT_MODE, rat_type);
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        result = mipc_get_result(msg_cnf_ptr);

        printf("NW_SET_REGISTER result:%d\n", result);
        if (result == MIPC_RESULT_SUCCESS)
        {
            mipc_nw_reg_state_struct4* reg_state = mipc_nw_set_register_state_cnf_get_state(msg_cnf_ptr, NULL);
            mipc_nw_register_mode_const_enum reg_mode = mipc_nw_set_register_state_cnf_get_mode(msg_cnf_ptr, mipc_nw_register_mode_const_NONE);
            mipc_nw_data_speed_const_enum data_class = mipc_nw_set_register_state_cnf_get_data_speed(msg_cnf_ptr, mipc_nw_data_speed_const_NONE);
            char* network_name = mipc_nw_set_register_state_cnf_get_nw_name(msg_cnf_ptr, NULL);
            char* roaming_text = mipc_nw_set_register_state_cnf_get_roaming_text(msg_cnf_ptr, NULL);
            printf("ps_state=%d, cs_state=%d plmn=%s is_roaming:%d reg_mode=%d data_class=%d name=%s roaming_txt=%s\n",
                   reg_state->ps_state, reg_state->cs_state, reg_state->plmn, reg_state->is_roaming,
                   reg_mode, data_class, network_name, roaming_text);
        }
        mipc_msg_deinit(msg_cnf_ptr);
    }
    while (0);

    //SET IA
    printf("==============================>> set IA APN\n");
    do
    {
        mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_APN_SET_IA_REQ, MIPC_PS0);
        mipc_msg_t *msg_cnf_ptr;
        mipc_result_enum result;
        uint8_t apn_count;

        mipc_apn_set_ia_req_add_apn(msg_req_ptr, MIPC_MAX_APN_LEN, apn);
        mipc_apn_set_ia_req_add_pdp_type(msg_req_ptr, pdn_type);
        mipc_apn_set_ia_req_add_roaming_type(msg_req_ptr, roam_pdn_type);

        mipc_apn_set_ia_req_add_auth_type(msg_req_ptr, MIPC_APN_AUTH_TYPE_NONE);
        mipc_apn_set_ia_req_add_userid(msg_req_ptr, MIPC_MAX_USERID_LEN, "");
        mipc_apn_set_ia_req_add_password(msg_req_ptr, MIPC_MAX_PASSWORD_LEN, "");

        mipc_apn_set_ia_req_add_bearer_bitmask(msg_req_ptr, 0xffffffff);
        mipc_apn_set_ia_req_add_compression(msg_req_ptr, MIPC_APN_COMPRESSION_ENABLE);

        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);

        result = mipc_get_result(msg_cnf_ptr);
        if (result == MIPC_RESULT_SUCCESS)
        {
            apn_count = mipc_apn_set_ia_cnf_get_ia_count(msg_cnf_ptr, 0);
            printf("IA APN count:%d\n", apn_count);
            if (apn_count > 0)
            {
                mipc_apn_ia_struct4* ia = mipc_apn_get_ia_cnf_get_ia_list(msg_cnf_ptr, NULL);
                printf("IA apn:%s pdp_type:%d\n", ia->apn, ia->pdp_type);
            }
        }
        else
            printf("Failed to execute with  MIPC_APN_SET_IA_REQ:%d\n", result);
        mipc_msg_deinit(msg_cnf_ptr);
    }
    while (0);

    if (radio_state == 2 || radio_state == 0) {
        //TEST: SW radio off
        printf("==============================>> start to radio off\n");
        do
        {
            mipc_msg_t *msg_req_ptr;
            mipc_msg_t *msg_cnf_ptr;
            mipc_nw_radio_state_const_enum radio_state = MIPC_NW_RADIO_STATE_OFF;
            mipc_result_enum result;

            msg_req_ptr = mipc_msg_init(MIPC_NW_SET_RADIO_STATE_REQ, MIPC_PS0);
            mipc_nw_set_radio_state_req_add_sw_state(msg_req_ptr, radio_state);
            msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
            mipc_msg_deinit(msg_req_ptr);

            result = mipc_get_result(msg_cnf_ptr);
            if (result == MIPC_RESULT_SUCCESS)
            {
                radio_state = mipc_nw_get_radio_state_cnf_get_sw_state(msg_cnf_ptr, MIPC_NW_RADIO_STATE_OFF);
                printf("Set radio state%s\n", radio_state_name(radio_state));
                radio_state = mipc_nw_get_radio_state_cnf_get_hw_state(msg_cnf_ptr, MIPC_NW_RADIO_STATE_OFF);
                printf("HW radio state:%s\n", radio_state_name(radio_state));
            }
            else
                printf("Failed to execute with  MIPC_NW_SET_RADIO_STATE_REQ\n");
            mipc_msg_deinit(msg_cnf_ptr);
        }
        while (0);
    }

    if (radio_state == 2 || radio_state == 1) {
        //TEST: SW radio on
        printf("==============================>> start to radio on\n");
        do
        {
            mipc_msg_t *msg_req_ptr;
            mipc_msg_t *msg_cnf_ptr;
            mipc_nw_radio_state_const_enum radio_state = MIPC_NW_RADIO_STATE_ON;
            mipc_result_enum result;

            msg_req_ptr = mipc_msg_init(MIPC_NW_SET_RADIO_STATE_REQ, MIPC_PS0);
            mipc_nw_set_radio_state_req_add_sw_state(msg_req_ptr, radio_state);
            msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
            mipc_msg_deinit(msg_req_ptr);

            result = mipc_get_result(msg_cnf_ptr);
            if (result == MIPC_RESULT_SUCCESS)
            {
                radio_state = mipc_nw_get_radio_state_cnf_get_sw_state(msg_cnf_ptr, MIPC_NW_RADIO_STATE_OFF);
                printf("Set radio state%s\n", radio_state_name(radio_state));
                radio_state = mipc_nw_get_radio_state_cnf_get_hw_state(msg_cnf_ptr, MIPC_NW_RADIO_STATE_OFF);
                printf("HW radio state:%s\n", radio_state_name(radio_state));
            }
            else
                printf("Failed to execute with  MIPC_NW_SET_RADIO_STATE_REQ\n");
            mipc_msg_deinit(msg_cnf_ptr);
        }
        while (0);
    }

    printf("==============================>> wait IA completion\n");
    mipc_deinit();

    exit(0);
}
